/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.uoc.common.ability.impl;

import com.tydic.uoc.base.constants.UocConstant;
import com.tydic.uoc.base.exception.UocProBusinessException;
import com.tydic.uoc.common.ability.api.UocOrderRemindAbilityService;
import com.tydic.uoc.common.ability.bo.UocOrderRemindOrderInfoBO;
import com.tydic.uoc.common.ability.bo.UocOrderRemindServiceReqBO;
import com.tydic.uoc.common.ability.bo.UocOrderRemindServiceRspBO;
import com.tydic.uoc.common.busi.api.UocOrderRemindBusiService;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"UOC_GROUP_DEV/2.0.0/com.tydic.uoc.common.ability.api.UocOrderRemindAbilityService"})
public class UocOrderRemindAbilityServiceImpl
implements UocOrderRemindAbilityService {
    private static final Logger log = LoggerFactory.getLogger(UocOrderRemindAbilityServiceImpl.class);
    @Autowired
    private UocOrderRemindBusiService uocOrderRemindBusiService;

    @PostMapping(value={"dealRemind"})
    public UocOrderRemindServiceRspBO dealRemind(@RequestBody UocOrderRemindServiceReqBO reqBO) {
        this.validateArgs(reqBO);
        UocOrderRemindServiceRspBO retBo = this.uocOrderRemindBusiService.dealRemind(reqBO);
        return retBo;
    }

    private void validateArgs(UocOrderRemindServiceReqBO reqBO) {
        if (null == reqBO) {
            throw new UocProBusinessException("100001", "\u8ba2\u5355\u63d0\u9192API\u5165\u53c2\u3010bo\u3011\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (null == reqBO.getActionCode()) {
            throw new UocProBusinessException("100001", "\u8ba2\u5355\u63d0\u9192API\u5165\u53c2\u52a8\u4f5c\u7f16\u7801\u3010actionCode\u3011\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (null == reqBO.getDealType()) {
            throw new UocProBusinessException("100001", "\u8ba2\u5355\u63d0\u9192API\u5165\u53c2\u64cd\u4f5c\u4eba\u7c7b\u578b\u3010dealType\u3011\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (!reqBO.getDealType().equals(0) && !reqBO.getDealType().equals(1)) {
            throw new UocProBusinessException("100001", "\u8ba2\u5355\u63d0\u9192API\u5165\u53c2\u64cd\u4f5c\u4eba\u7c7b\u578b\u3010dealType\u3011\u9519\u8bef");
        }
        if (null == reqBO.getNoticeOrderList() || reqBO.getNoticeOrderList().size() == 0) {
            throw new UocProBusinessException("100001", "\u8ba2\u5355\u63d0\u9192API\u5165\u53c2\u9500\u552e\u8ba2\u5355ID\u3010noticeOrderList\u3011\u4e0d\u80fd\u4e3a\u7a7a");
        }
        List noticeOrderList = reqBO.getNoticeOrderList();
        for (UocOrderRemindOrderInfoBO pebDealOrderBO : noticeOrderList) {
            if (pebDealOrderBO.getOrderId() == null) {
                throw new UocProBusinessException("100001", "\u8ba2\u5355\u63d0\u9192API\u5165\u53c2\u9500\u552e\u8ba2\u5355ID\u5217\u8868\u3010noticeOrderList\u3011\u8ba2\u5355ID\u3010orderId\u3011\u4e0d\u80fd\u4e3a\u7a7a");
            }
            if (pebDealOrderBO.getPurchaseVoucherId() == null && pebDealOrderBO.getSaleVoucherId() == null) {
                throw new UocProBusinessException("100001", "\u8ba2\u5355\u63d0\u9192API\u5165\u53c2\u9500\u552e\u8ba2\u5355ID\u5217\u8868\u3010noticeOrderList\u3011\u9500\u552e\u8ba2\u5355ID\u3010saleVoucherId\u3011\u4e0e\u91c7\u8d2d\u5355ID\u3010purchaseVoucherId\u3011\u4e0d\u80fd\u540c\u65f6\u4e3a\u7a7a");
            }
            if (pebDealOrderBO.getPurchaseVoucherId() == null || pebDealOrderBO.getSaleVoucherId() == null) continue;
            throw new UocProBusinessException("100001", "\u8ba2\u5355\u63d0\u9192API\u5165\u53c2\u9500\u552e\u8ba2\u5355ID\u5217\u8868\u3010noticeOrderList\u3011\u9500\u552e\u8ba2\u5355ID\u3010saleVoucherId\u3011\u4e0e\u91c7\u8d2d\u5355ID\u3010purchaseVoucherId\u3011\u53ea\u80fd\u4e00\u4e2a\u4e0d\u4e3a\u7a7a");
        }
        if (!(null == reqBO.getAuthCtrl() || reqBO.getAuthCtrl().equals(UocConstant.ORDER_TO_REMIND_AUTH_CTRL.AUTH_CTRL0) || reqBO.getAuthCtrl().equals(UocConstant.ORDER_TO_REMIND_AUTH_CTRL.AUTH_CTRL1) || reqBO.getAuthCtrl().equals(UocConstant.ORDER_TO_REMIND_AUTH_CTRL.AUTH_CTRL2))) {
            throw new UocProBusinessException("100001", "\u8ba2\u5355\u63d0\u9192API\u5165\u53c2\u6743\u9650\u63a7\u5236\u3010authCtrl\u3011\u7c7b\u578b\u9519\u8bef");
        }
        if (null != reqBO.getAuthCtrl() && reqBO.getAuthCtrl().equals(UocConstant.ORDER_TO_REMIND_AUTH_CTRL.AUTH_CTRL1) && reqBO.getMemId() == null) {
            throw new UocProBusinessException("100001", "\u8ba2\u5355\u63d0\u9192API\u5165\u53c2\u64cd\u4f5c\u4eba\u3010memId\u3011authCtrl= 1\u65f6\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (null != reqBO.getAuthCtrl() && reqBO.getAuthCtrl().equals(UocConstant.ORDER_TO_REMIND_AUTH_CTRL.AUTH_CTRL2) && StringUtils.isBlank((CharSequence)reqBO.getStationId())) {
            throw new UocProBusinessException("100001", "\u8ba2\u5355\u63d0\u9192API\u5165\u53c2\u64cd\u4f5c\u4eba\u3010stationId\u3011authCtrl= 2\u4e0d\u80fd\u4e3a\u7a7a");
        }
    }
}

