/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.uoc.common.atom.impl;

import com.tydic.uoc.base.constants.UocConstant;
import com.tydic.uoc.base.constants.UocCoreConstant;
import com.tydic.uoc.base.exception.UocProBusinessException;
import com.tydic.uoc.base.utils.OrderGenerateIdUtil;
import com.tydic.uoc.busibase.busi.api.PebIntfMemDetailQueryBusiService;
import com.tydic.uoc.common.atom.api.PebTheOrderRemindAtomService;
import com.tydic.uoc.common.atom.api.UocCoreStateConfigRemindAtomService;
import com.tydic.uoc.common.atom.bo.PebTheOrderRemindAtomReqBO;
import com.tydic.uoc.common.atom.bo.PebTheOrderRemindAtomRspBO;
import com.tydic.uoc.common.atom.bo.RemindInfo;
import com.tydic.uoc.common.atom.bo.UocCoreStateConfigRemindAtomReqBO;
import com.tydic.uoc.common.atom.bo.UocCoreStateConfigRemindAtomRspBO;
import com.tydic.uoc.dao.ConfStatusRemindMapper;
import com.tydic.uoc.dao.OrdAgreementMapper;
import com.tydic.uoc.dao.OrdPurchaseMapper;
import com.tydic.uoc.dao.OrdRemindLogMapper;
import com.tydic.uoc.dao.OrdSaleMapper;
import com.tydic.uoc.dao.OrdStakeholderMapper;
import com.tydic.uoc.dao.OrderMapper;
import com.tydic.uoc.po.ConfStatusRemindPO;
import com.tydic.uoc.po.OrdAgreementPO;
import com.tydic.uoc.po.OrdPurchasePO;
import com.tydic.uoc.po.OrdRemindLogPO;
import com.tydic.uoc.po.OrdSalePO;
import com.tydic.uoc.po.OrdStakeholderPO;
import com.tydic.uoc.po.OrderPO;
import java.util.ArrayList;
import java.util.Date;
import java.util.LinkedHashMap;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class UocCoreStateConfigRemindAtomServiceImpl
implements UocCoreStateConfigRemindAtomService {
    private static final Logger LOG = LoggerFactory.getLogger(UocCoreStateConfigRemindAtomServiceImpl.class);
    @Autowired
    private OrdSaleMapper ordSaleMapper;
    @Autowired
    private ConfStatusRemindMapper confStatusRemindMapper;
    @Autowired
    private OrdRemindLogMapper ordRemindLogMapper;
    @Autowired
    private PebTheOrderRemindAtomService pebTheOrderRemindAtomService;
    @Autowired
    private PebIntfMemDetailQueryBusiService pebIntfMemDetailQueryBusiService;
    @Autowired
    private OrderGenerateIdUtil sequence;
    @Autowired
    private OrderMapper orderMapper;
    @Autowired
    private OrdPurchaseMapper ordPurchaseMapper;
    @Autowired
    private OrdStakeholderMapper ordStakeholderMapper;
    @Autowired
    private OrdAgreementMapper ordAgreementMapper;

    @Override
    public UocCoreStateConfigRemindAtomRspBO dealStateConfigRemind(UocCoreStateConfigRemindAtomReqBO reqBO) {
        this.validateSendType(reqBO);
        OrdSalePO ordSalePO = this.qryOrdSale(reqBO);
        List<ConfStatusRemindPO> remindConfList = this.qryConfStatusRemind(reqBO, ordSalePO);
        ArrayList<RemindInfo> remindInfoList = new ArrayList<RemindInfo>();
        this.setParam(ordSalePO, remindConfList, remindInfoList, reqBO);
        UocCoreStateConfigRemindAtomRspBO rspBO = new UocCoreStateConfigRemindAtomRspBO();
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("\u6210\u529f");
        return rspBO;
    }

    private void validateSendType(UocCoreStateConfigRemindAtomReqBO reqBO) {
        if (reqBO.getSendType() == null) {
            reqBO.setSendType(UocCoreConstant.SEND_TYPE.SMS);
        }
        if (!(UocCoreConstant.SEND_TYPE.SMS.equals(reqBO.getSendType()) || UocCoreConstant.SEND_TYPE.MAIL.equals(reqBO.getSendType()) || UocCoreConstant.SEND_TYPE.STATION_LETTER.equals(reqBO.getSendType()))) {
            throw new UocProBusinessException("100001", "\u4e0d\u652f\u6301\u7684\u53d1\u9001\u7c7b\u578b\u3010" + reqBO.getSendType() + "\u3011");
        }
    }

    private List<ConfStatusRemindPO> qryConfStatusRemind(UocCoreStateConfigRemindAtomReqBO reqBO, OrdSalePO ordSalePO) {
        ConfStatusRemindPO confStatusRemindPO = new ConfStatusRemindPO();
        confStatusRemindPO.setBusiType(reqBO.getBusiType());
        confStatusRemindPO.setStatus(ordSalePO.getSaleState() + "");
        return this.confStatusRemindMapper.selectByCondition(confStatusRemindPO);
    }

    private void setParam(OrdSalePO salePO, List<ConfStatusRemindPO> remindConfList, List<RemindInfo> remindInfoList, UocCoreStateConfigRemindAtomReqBO reqBO) {
        OrderPO orderPO = this.orderMapper.getModelById(salePO.getOrderId().longValue());
        OrdStakeholderPO stakeholderPO = this.ordStakeholderMapper.getModelById(salePO.getOrderId().longValue());
        OrdPurchasePO purchasePO = new OrdPurchasePO();
        purchasePO.setOrderId(salePO.getOrderId());
        purchasePO = this.ordPurchaseMapper.getModelBy(purchasePO);
        OrdAgreementPO agreementPO = new OrdAgreementPO();
        agreementPO.setOrderId(salePO.getOrderId());
        agreementPO = (OrdAgreementPO)this.ordAgreementMapper.selectByCondition(agreementPO).get(0);
        LinkedHashMap<String, Object> map = new LinkedHashMap<String, Object>(3);
        if (UocConstant.SALE_ORDER_STATUS.ZONE_PRE_ORDER.equals(salePO.getSaleState()) || UocConstant.SALE_ORDER_STATUS.ZONE_TO_BE_SHIP.equals(salePO.getSaleState())) {
            for (ConfStatusRemindPO remindPO : remindConfList) {
                RemindInfo remindInfo = new RemindInfo();
                remindInfo.setTemplateId(remindPO.getTemplateId());
                remindInfo.setTemplateParam(map);
                remindInfo.setContent(remindPO.getContent());
                try {
                    remindInfo.setReceiveId(Long.parseLong(reqBO.getReceive()));
                }
                catch (Exception exception) {
                    // empty catch block
                }
                switch (remindPO.getBusiType()) {
                    case "1": {
                        map.put("purAccountName", stakeholderPO.getPurAccountName());
                        map.put("orderNo", purchasePO.getPurchaseVoucherNo());
                        remindInfo.setMobile(agreementPO.getVendorPhone());
                        remindInfoList.add(remindInfo);
                        break;
                    }
                    case "2": {
                        map.put("purName", stakeholderPO.getPurName());
                        map.put("orderNo", salePO.getSaleVoucherNo());
                        remindInfo.setMobile(agreementPO.getProducerPhone());
                        remindInfoList.add(remindInfo);
                        break;
                    }
                    case "3": {
                        map.put("purName", stakeholderPO.getPurName());
                        map.put("orderNo", salePO.getSaleVoucherNo());
                        remindInfo.setMobile(stakeholderPO.getProRelaMobile());
                        remindInfoList.add(remindInfo);
                        break;
                    }
                }
            }
            map.put("orderName", orderPO.getOrderName());
            return;
        }
        if (salePO.getSaleState().equals(UocConstant.SALE_ORDER_STATUS.ZONE_AUDIT)) {
            // empty if block
        }
    }

    private OrdSalePO qryOrdSale(UocCoreStateConfigRemindAtomReqBO reqBO) {
        OrdSalePO ordSalePO = new OrdSalePO();
        ordSalePO.setOrderId(reqBO.getOrderId());
        ordSalePO = this.ordSaleMapper.getModelBy(ordSalePO);
        if (ordSalePO == null) {
            throw new UocProBusinessException("100001", "\u6839\u636e\u8ba2\u5355id\u3010" + reqBO.getOrderId() + "\u3011\u67e5\u8be2\u65e0\u9500\u552e\u5355\u4fe1\u606f");
        }
        return ordSalePO;
    }

    private boolean validateSendAmount(UocCoreStateConfigRemindAtomReqBO reqBO, ConfStatusRemindPO po) {
        if (po.getMaxCount() == null) {
            po.setMaxCount(Integer.valueOf(0));
        }
        OrdRemindLogPO ordRemindLogPO = new OrdRemindLogPO();
        ordRemindLogPO.setOrderId(reqBO.getOrderId());
        ordRemindLogPO.setBusiType(reqBO.getBusiType());
        ordRemindLogPO.setTemplateId(po.getTemplateId());
        ordRemindLogPO.setStatus("1");
        int sendedAmount = this.ordRemindLogMapper.getSendedAmount(ordRemindLogPO);
        if (sendedAmount >= po.getMaxCount()) {
            this.doFailLog(reqBO, po);
            return false;
        }
        return true;
    }

    private void doFailLog(UocCoreStateConfigRemindAtomReqBO reqBO, ConfStatusRemindPO po) {
        OrdRemindLogPO ordRemindLogPO = new OrdRemindLogPO();
        ordRemindLogPO.setId(Long.valueOf(this.sequence.nextId()));
        ordRemindLogPO.setStatus("0");
        ordRemindLogPO.setTemplateId(po.getTemplateId());
        ordRemindLogPO.setBusiType(reqBO.getBusiType());
        ordRemindLogPO.setSendType(reqBO.getSendType());
        ordRemindLogPO.setReceiveRole(po.getReceiveRole());
        ordRemindLogPO.setMemId(reqBO.getUserId() + "");
        ordRemindLogPO.setCreateTime(new Date());
        this.ordRemindLogMapper.insert(ordRemindLogPO);
    }

    private void doRemind(UocCoreStateConfigRemindAtomReqBO reqBO, OrdSalePO ordSalePO, List<RemindInfo> remindInfoList, UocCoreStateConfigRemindAtomRspBO rspBO) {
        PebTheOrderRemindAtomReqBO pebTheOrderRemindAtomReqBO = new PebTheOrderRemindAtomReqBO();
        pebTheOrderRemindAtomReqBO.setBusiType(reqBO.getBusiType());
        pebTheOrderRemindAtomReqBO.setSendType(reqBO.getSendType());
        pebTheOrderRemindAtomReqBO.setOrderId(reqBO.getOrderId());
        pebTheOrderRemindAtomReqBO.setObjId(ordSalePO.getSaleVoucherId());
        pebTheOrderRemindAtomReqBO.setObjType(UocCoreConstant.OBJ_TYPE.SALE);
        for (RemindInfo info : remindInfoList) {
            if (UocCoreConstant.SEND_TYPE.SMS.equals(reqBO.getSendType()) && StringUtils.isEmpty((CharSequence)info.getMobile()) || UocCoreConstant.SEND_TYPE.MAIL.equals(reqBO.getSendType()) && StringUtils.isEmpty((CharSequence)info.getEmail())) continue;
            pebTheOrderRemindAtomReqBO.setTemplateId(info.getTemplateId());
            pebTheOrderRemindAtomReqBO.setTemplateParam(info.getTemplateParam());
            pebTheOrderRemindAtomReqBO.setMobile(info.getMobile());
            pebTheOrderRemindAtomReqBO.setEmail(info.getEmail());
            pebTheOrderRemindAtomReqBO.setSubject(info.getSubject());
            pebTheOrderRemindAtomReqBO.setReceiveId(info.getReceiveId());
            pebTheOrderRemindAtomReqBO.setTitel(info.getTitel());
            if (StringUtils.isNotBlank((CharSequence)info.getContent()) && !info.getTemplateParam().isEmpty()) {
                String content = info.getContent();
                for (String key : info.getTemplateParam().keySet()) {
                    content = content.replace("{" + key + "}", String.valueOf(info.getTemplateParam().get(key)));
                }
                pebTheOrderRemindAtomReqBO.setContent(content);
            }
            pebTheOrderRemindAtomReqBO.setDealType(reqBO.getDealType());
            PebTheOrderRemindAtomRspBO pebTheOrderRemindAtomRspBO = this.pebTheOrderRemindAtomService.dealPebTheOrderRemind(pebTheOrderRemindAtomReqBO);
            if ("0000".equals(pebTheOrderRemindAtomRspBO.getRespCode())) continue;
        }
    }
}

