/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.uoc.common.atom.impl;

import com.alibaba.fastjson.JSON;
import com.tydic.fsc.bo.FscShouldPayBO;
import com.tydic.fsc.bo.FscShouldPayRspBO;
import com.tydic.fsc.common.ability.api.FscCreditDeductAbilityService;
import com.tydic.fsc.common.ability.bo.FscCreditDeductAbilityReqBO;
import com.tydic.fsc.common.ability.bo.FscCreditDeductAbilityRspBO;
import com.tydic.fsc.common.ability.bo.FscCreditDeductOrderInfo;
import com.tydic.fsc.pay.ability.api.FscPayShouldPayCreateAbilityService;
import com.tydic.fsc.pay.ability.bo.FscPayShouldPayCreateAbilityReqBO;
import com.tydic.fsc.pay.ability.bo.FscPayShouldPayCreateAbilityRspBO;
import com.tydic.uoc.base.constants.UocConstant;
import com.tydic.uoc.base.constants.UocCoreConstant;
import com.tydic.uoc.base.exception.UocProBusinessException;
import com.tydic.uoc.base.utils.OrderGenerateIdUtil;
import com.tydic.uoc.base.utils.UocMoneyUtil;
import com.tydic.uoc.common.ability.bo.UocProShouldPayOrDeductAmountInfoBo;
import com.tydic.uoc.common.atom.api.UocProShouldPayOrDeductDealAtomService;
import com.tydic.uoc.common.atom.api.UocRunProcessAtomService;
import com.tydic.uoc.common.atom.bo.UocProShouldPayOrDeductDealAtomReqBo;
import com.tydic.uoc.common.atom.bo.UocProShouldPayOrDeductDealAtomRspBo;
import com.tydic.uoc.common.atom.bo.UocProcessRunReqBO;
import com.tydic.uoc.common.atom.bo.UocProcessRunRspBO;
import com.tydic.uoc.dao.OrdInspectionMapper;
import com.tydic.uoc.dao.OrdPayConfMapper;
import com.tydic.uoc.dao.OrdPurchaseMapper;
import com.tydic.uoc.dao.OrdSaleMapper;
import com.tydic.uoc.dao.OrdShipMapper;
import com.tydic.uoc.dao.OrdStakeholderMapper;
import com.tydic.uoc.dao.OrderMapper;
import com.tydic.uoc.dao.UocOrdFscShouldPayMapper;
import com.tydic.uoc.po.OrdInspectionPO;
import com.tydic.uoc.po.OrdPayConfPO;
import com.tydic.uoc.po.OrdPurchasePO;
import com.tydic.uoc.po.OrdSalePO;
import com.tydic.uoc.po.OrdShipPO;
import com.tydic.uoc.po.OrdStakeholderPO;
import com.tydic.uoc.po.OrderPO;
import com.tydic.uoc.po.UocOrdFscShouldPayPo;
import java.math.BigDecimal;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.ZoneId;
import java.time.temporal.ChronoField;
import java.time.temporal.ChronoUnit;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class UocProShouldPayOrDeductDealAtomServiceImpl
implements UocProShouldPayOrDeductDealAtomService {
    private static final Logger log = LoggerFactory.getLogger(UocProShouldPayOrDeductDealAtomServiceImpl.class);
    @Autowired
    private FscCreditDeductAbilityService fscCreditDeductAbilityService;
    @Autowired
    private FscPayShouldPayCreateAbilityService fscPayShouldPayCreateAbilityService;
    @Autowired
    private OrdPayConfMapper ordPayConfMapper;
    @Autowired
    private OrdStakeholderMapper ordStakeholderMapper;
    @Autowired
    private OrdSaleMapper ordSaleMapper;
    @Autowired
    private UocOrdFscShouldPayMapper ordFscShouldPayMapper;
    @Autowired
    private OrderGenerateIdUtil generateIdUtil;
    @Autowired
    private OrdInspectionMapper ordInspectionMapper;
    @Autowired
    private UocRunProcessAtomService uocRunProcessAtomService;
    @Autowired
    private OrdShipMapper ordShipMapper;
    @Autowired
    private OrderMapper orderMapper;
    @Autowired
    private OrdPurchaseMapper ordPurchaseMapper;

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public UocProShouldPayOrDeductDealAtomRspBo dealShouldPayOrDeduct(UocProShouldPayOrDeductDealAtomReqBo reqBo) {
        ArrayList<FscShouldPayBO> fscShouldPayBOS;
        ArrayList<UocOrdFscShouldPayPo> ordFscShouldPayPos;
        Boolean isRunPay;
        OrdSalePO salePO;
        UocProShouldPayOrDeductDealAtomRspBo rspBo;
        block20: {
            OrdPurchasePO purchasePO;
            OrdPayConfPO proPayConfPO;
            OrdPayConfPO purPayConfPO;
            OrdStakeholderPO stakeholderPO;
            block21: {
                block23: {
                    block22: {
                        block19: {
                            rspBo = new UocProShouldPayOrDeductDealAtomRspBo();
                            rspBo.setRespCode("0000");
                            rspBo.setRespDesc("\u6210\u529f");
                            stakeholderPO = this.ordStakeholderMapper.getModelById(reqBo.getOrderId().longValue());
                            salePO = new OrdSalePO();
                            salePO.setOrderId(reqBo.getOrderId());
                            salePO = this.ordSaleMapper.getModelBy(salePO);
                            if (UocCoreConstant.OBJ_TYPE.SALE.equals(reqBo.getObjType())) {
                                reqBo.setObjNo(salePO.getSaleVoucherNo());
                            }
                            reqBo.setSaleVoucherId(salePO.getSaleVoucherId());
                            if (UocCoreConstant.PaymentStage.ENTER_PENDING_PAYMENT.equals(reqBo.getPaymentStage()) || UocCoreConstant.PaymentStage.ENTER_PENDING_PAYMENT_NOW.equals(reqBo.getPaymentStage())) {
                                try {
                                    reqBo.setObjSaleAmount(UocMoneyUtil.long2BigDecimal((Long)salePO.getSaleFee()));
                                    reqBo.setObjPurchaseAmount(UocMoneyUtil.long2BigDecimal((Long)salePO.getPurchaseFee()));
                                }
                                catch (Exception e) {
                                    throw new UocProBusinessException("100001", "\u91d1\u989d\u8f6c\u6362\u5f02\u5e38", (Throwable)e);
                                }
                            }
                            purPayConfPO = new OrdPayConfPO();
                            purPayConfPO.setOrderId(reqBo.getOrderId());
                            List payConfPOS = this.ordPayConfMapper.selectByCondition(purPayConfPO);
                            proPayConfPO = null;
                            for (OrdPayConfPO confPO : payConfPOS) {
                                if (UocCoreConstant.UserType.PUR.equals(confPO.getUserType())) {
                                    purPayConfPO = confPO;
                                    continue;
                                }
                                proPayConfPO = confPO;
                            }
                            isRunPay = false;
                            ordFscShouldPayPos = new ArrayList<UocOrdFscShouldPayPo>();
                            fscShouldPayBOS = new ArrayList<FscShouldPayBO>();
                            if (!UocCoreConstant.ModelSettle.MATCH_UP.equals(salePO.getModelSettle())) break block19;
                            if (null != reqBo.getIsToBePaid() && reqBo.getIsToBePaid().booleanValue() && !"2".equals(String.valueOf(purPayConfPO.getPayType()))) {
                                rspBo.setIsRunPay(false);
                                return rspBo;
                            }
                            isRunPay = this.dealFscShouldPayOrDeduct(purPayConfPO, reqBo, stakeholderPO, salePO, ordFscShouldPayPos, fscShouldPayBOS, 3, null, null);
                            break block20;
                        }
                        purchasePO = new OrdPurchasePO();
                        purchasePO.setOrderId(reqBo.getOrderId());
                        purchasePO = this.ordPurchaseMapper.getModelBy(purchasePO);
                        if (null == proPayConfPO) {
                            proPayConfPO = (OrdPayConfPO)JSON.parseObject((String)JSON.toJSONString((Object)purPayConfPO), OrdPayConfPO.class);
                            proPayConfPO.setUserType(Integer.valueOf(2));
                        }
                        if (null == reqBo.getIsToBePaid() || !reqBo.getIsToBePaid().booleanValue()) break block21;
                        if (!"2".equals(String.valueOf(purPayConfPO.getPayType())) && !"2".equals(String.valueOf(proPayConfPO.getPayType()))) {
                            rspBo.setIsRunPay(false);
                            return rspBo;
                        }
                        if (!"2".equals(String.valueOf(purPayConfPO.getPayType())) || !"2".equals(String.valueOf(proPayConfPO.getPayType()))) break block22;
                        this.dealFscShouldPayOrDeduct(purPayConfPO, reqBo, stakeholderPO, salePO, ordFscShouldPayPos, fscShouldPayBOS, 1, null, purchasePO);
                        this.dealFscShouldPayOrDeduct(proPayConfPO, reqBo, stakeholderPO, salePO, ordFscShouldPayPos, fscShouldPayBOS, 2, String.valueOf(purPayConfPO.getPayType()), purchasePO);
                        isRunPay = true;
                        break block20;
                    }
                    if (!"2".equals(String.valueOf(purPayConfPO.getPayType()))) break block23;
                    isRunPay = this.dealFscShouldPayOrDeduct(purPayConfPO, reqBo, stakeholderPO, salePO, ordFscShouldPayPos, fscShouldPayBOS, 1, null, purchasePO);
                    if (null != proPayConfPO.getPrePayFee() && !proPayConfPO.getPrePayFee().equals(proPayConfPO.getPrePayedFee())) {
                        isRunPay = false;
                    }
                    break block20;
                }
                if ("2".equals(String.valueOf(proPayConfPO.getPayType()))) {
                    isRunPay = this.dealFscShouldPayOrDeduct(proPayConfPO, reqBo, stakeholderPO, salePO, ordFscShouldPayPos, fscShouldPayBOS, 2, null, purchasePO);
                    if (null != purPayConfPO.getPrePayFee() && !purPayConfPO.getPrePayFee().equals(purPayConfPO.getPrePayedFee())) {
                        isRunPay = false;
                    }
                }
                break block20;
            }
            isRunPay = this.dealFscShouldPayOrDeduct(purPayConfPO, reqBo, stakeholderPO, salePO, ordFscShouldPayPos, fscShouldPayBOS, 1, null, purchasePO);
            if (isRunPay.booleanValue()) {
                isRunPay = this.dealFscShouldPayOrDeduct(proPayConfPO, reqBo, stakeholderPO, salePO, ordFscShouldPayPos, fscShouldPayBOS, 2, String.valueOf(purPayConfPO.getPayType()), purchasePO);
            } else {
                this.dealFscShouldPayOrDeduct(proPayConfPO, reqBo, stakeholderPO, salePO, ordFscShouldPayPos, fscShouldPayBOS, 2, String.valueOf(purPayConfPO.getPayType()), purchasePO);
            }
        }
        if (!CollectionUtils.isEmpty(ordFscShouldPayPos)) {
            FscPayShouldPayCreateAbilityReqBO fscPayShouldPayCreateAbilityReqBO = new FscPayShouldPayCreateAbilityReqBO();
            fscPayShouldPayCreateAbilityReqBO.setFscShouldPayBOS(fscShouldPayBOS);
            FscPayShouldPayCreateAbilityRspBO fscPayShouldPayCreateAbilityRspBO = this.fscPayShouldPayCreateAbilityService.dealShouldPayCreate(fscPayShouldPayCreateAbilityReqBO);
            log.debug("\u63a8\u9001\u5e94\u4ed8\u8bb0\u5f55\u5165\u53c2\uff1a{}\uff1b\u51fa\u53c2\uff1a{}", (Object)JSON.toJSONString((Object)fscPayShouldPayCreateAbilityReqBO), (Object)JSON.toJSONString((Object)fscPayShouldPayCreateAbilityRspBO));
            if (!"0000".equals(fscPayShouldPayCreateAbilityRspBO.getRespCode())) {
                throw new UocProBusinessException(fscPayShouldPayCreateAbilityRspBO.getRespCode(), fscPayShouldPayCreateAbilityRspBO.getRespDesc());
            }
            if (fscPayShouldPayCreateAbilityRspBO.getFscShouldPayRspBOs().size() != fscPayShouldPayCreateAbilityReqBO.getFscShouldPayBOS().size()) {
                throw new UocProBusinessException("100001", "\u7ed3\u7b97\u5e94\u4ed8\u8bb0\u5f55\u5165\u53c2\u548c\u51fa\u53c2\u65e0\u6cd5\u5bf9\u5e94\uff0c\u5165\u53c2\u5927\u5c0f\uff1a" + fscPayShouldPayCreateAbilityReqBO.getFscShouldPayBOS().size() + "\uff0c\u51fa\u53c2\u5927\u5c0f\uff1a" + fscPayShouldPayCreateAbilityRspBO.getFscShouldPayRspBOs().size());
            }
            for (int i = 0; i < fscPayShouldPayCreateAbilityReqBO.getFscShouldPayBOS().size(); ++i) {
                FscShouldPayRspBO fscShouldPayRspBO = (FscShouldPayRspBO)fscPayShouldPayCreateAbilityRspBO.getFscShouldPayRspBOs().get(i);
                ((UocOrdFscShouldPayPo)ordFscShouldPayPos.get(i)).setFscShouldPayId(fscShouldPayRspBO.getShouldPayId());
            }
            this.ordFscShouldPayMapper.insertBatch(ordFscShouldPayPos);
        }
        if (isRunPay.booleanValue()) {
            this.runSale(reqBo, salePO);
        }
        rspBo.setIsRunPay(isRunPay);
        return rspBo;
    }

    private FscCreditDeductAbilityRspBO deductionPeriod(UocProShouldPayOrDeductDealAtomReqBo reqBo, OrdStakeholderPO stakeholderPO, Integer threePartyPayment, Boolean isReverse) {
        FscCreditDeductAbilityReqBO fscCreditDeductAbilityReqBO = new FscCreditDeductAbilityReqBO();
        if (1 == threePartyPayment) {
            fscCreditDeductAbilityReqBO.setSupId(Long.valueOf(stakeholderPO.getProNo()));
            fscCreditDeductAbilityReqBO.setCreditOrgId(stakeholderPO.getCompanyId());
            fscCreditDeductAbilityReqBO.setAmount(reqBo.getObjSaleAmount());
        } else if (2 == threePartyPayment) {
            fscCreditDeductAbilityReqBO.setSupId(Long.valueOf(stakeholderPO.getSupNo()));
            fscCreditDeductAbilityReqBO.setCreditOrgId(Long.valueOf(stakeholderPO.getProNo()));
            fscCreditDeductAbilityReqBO.setAmount(reqBo.getObjPurchaseAmount());
        } else if (3 == threePartyPayment) {
            fscCreditDeductAbilityReqBO.setSupId(Long.valueOf(stakeholderPO.getSupNo()));
            fscCreditDeductAbilityReqBO.setCreditOrgId(stakeholderPO.getCompanyId());
            fscCreditDeductAbilityReqBO.setAmount(reqBo.getObjSaleAmount());
        }
        if (null != isReverse && isReverse.booleanValue()) {
            fscCreditDeductAbilityReqBO.setAmount(fscCreditDeductAbilityReqBO.getAmount().negate());
        }
        ArrayList<FscCreditDeductOrderInfo> orderInfoList = new ArrayList<FscCreditDeductOrderInfo>();
        FscCreditDeductOrderInfo orderInfoBo = new FscCreditDeductOrderInfo();
        orderInfoList.add(orderInfoBo);
        orderInfoBo.setOrderId(reqBo.getOrderId().longValue());
        orderInfoBo.setOrderNo(reqBo.getObjNo());
        fscCreditDeductAbilityReqBO.setOrderInfoList(orderInfoList);
        FscCreditDeductAbilityRspBO fscCreditDeductAbilityRspBO = this.fscCreditDeductAbilityService.dealAccountDeduct(fscCreditDeductAbilityReqBO);
        log.debug("\u6263\u9664\u8d26\u671f\u989d\u5ea6\u5165\u53c2\uff1a{}\uff1b\u51fa\u53c2\uff1a{}", (Object)JSON.toJSONString((Object)fscCreditDeductAbilityReqBO), (Object)JSON.toJSONString((Object)fscCreditDeductAbilityRspBO));
        return fscCreditDeductAbilityRspBO;
    }

    private FscShouldPayBO buildFscShouldPayInfo(UocProShouldPayOrDeductDealAtomReqBo reqBo, BigDecimal shouldPayAmount, Integer threePartyPayment, OrdStakeholderPO stakeholderPO, OrdPayConfPO payConfPO, Integer objectType, Integer shouldPayType, List<UocOrdFscShouldPayPo> ordFscShouldPayPos, Date shouldPayDate, String objectNo, OrdSalePO salePO) {
        OrdPayConfPO ordPayConfPO = new OrdPayConfPO();
        ordPayConfPO.setId(payConfPO.getId());
        ordPayConfPO.setOrderId(payConfPO.getOrderId());
        if (shouldPayAmount.compareTo(BigDecimal.ZERO) <= 0) {
            if (UocCoreConstant.ShouldPayType.ACCOUNT_PAYABLE.equals(shouldPayType) || UocCoreConstant.ShouldPayType.ACCEPTANCE_PAYMENT_PAYABLE.equals(shouldPayType)) {
                ordPayConfPO.setPilPayFee(Long.valueOf(0L));
                ordPayConfPO.setPilPayedFee(Long.valueOf(0L));
            } else if (UocCoreConstant.ShouldPayType.PREPAYMENT_PAYABLE.equals(shouldPayType)) {
                ordPayConfPO.setPrePayFee(Long.valueOf(0L));
                ordPayConfPO.setPrePayedFee(Long.valueOf(0L));
            } else if (UocCoreConstant.ShouldPayType.ARRIVAL_PAYMENT_PAYABLE.equals(shouldPayType)) {
                ordPayConfPO.setVerPayFee(Long.valueOf(0L));
                ordPayConfPO.setVerPayedFee(Long.valueOf(0L));
            } else if (UocCoreConstant.ShouldPayType.WARRANTY_PAYABLE.equals(shouldPayType)) {
                ordPayConfPO.setQuaPayFee(Long.valueOf(0L));
                ordPayConfPO.setQuaPayedFee(Long.valueOf(0L));
            }
            this.ordPayConfMapper.updateFee(ordPayConfPO);
            return null;
        }
        FscShouldPayBO fscShouldPayBO = new FscShouldPayBO();
        fscShouldPayBO.setShouldPayType(shouldPayType);
        fscShouldPayBO.setObjectId(reqBo.getObjId());
        fscShouldPayBO.setOrderId(reqBo.getOrderId());
        fscShouldPayBO.setObjectType(objectType);
        fscShouldPayBO.setObjectNo(objectNo);
        fscShouldPayBO.setShouldPayAmount(shouldPayAmount);
        fscShouldPayBO.setPayType(payConfPO.getPayType());
        if (1 == threePartyPayment) {
            fscShouldPayBO.setPayerId(stakeholderPO.getCompanyId());
            fscShouldPayBO.setPayerName(stakeholderPO.getCompanyName());
            fscShouldPayBO.setPayeeId(Long.valueOf(stakeholderPO.getProNo()));
            fscShouldPayBO.setPayeeName(stakeholderPO.getProName());
        } else if (2 == threePartyPayment) {
            fscShouldPayBO.setPayerId(Long.valueOf(stakeholderPO.getProNo()));
            fscShouldPayBO.setPayerName(stakeholderPO.getProName());
            fscShouldPayBO.setPayeeId(Long.valueOf(stakeholderPO.getSupNo()));
            fscShouldPayBO.setPayeeName(stakeholderPO.getSupName());
        } else if (3 == threePartyPayment) {
            fscShouldPayBO.setPayerId(stakeholderPO.getCompanyId());
            fscShouldPayBO.setPayerName(stakeholderPO.getCompanyName());
            fscShouldPayBO.setPayeeId(Long.valueOf(stakeholderPO.getSupNo()));
            fscShouldPayBO.setPayeeName(stakeholderPO.getSupName());
        }
        fscShouldPayBO.setShouldPayDate(shouldPayDate);
        fscShouldPayBO.setPenaltyRatio(payConfPO.getPayBreakScale());
        fscShouldPayBO.setSaleVoucherId(reqBo.getSaleVoucherId());
        fscShouldPayBO.setContractNo(payConfPO.getModelContractNo());
        fscShouldPayBO.setContractId(payConfPO.getModelContractId());
        fscShouldPayBO.setSaleVoucherId(reqBo.getSaleVoucherId());
        UocOrdFscShouldPayPo ordFscShouldPayPo = new UocOrdFscShouldPayPo();
        try {
            if (UocCoreConstant.ShouldPayType.ACCOUNT_PAYABLE.equals(shouldPayType) || UocCoreConstant.ShouldPayType.ACCEPTANCE_PAYMENT_PAYABLE.equals(shouldPayType)) {
                ordPayConfPO.setPilPayFee(UocMoneyUtil.bigDecimal2Long((BigDecimal)shouldPayAmount));
                ordFscShouldPayPo.setPayFeeType(UocCoreConstant.PaymentStage.ACCEPTING);
            } else if (UocCoreConstant.ShouldPayType.PREPAYMENT_PAYABLE.equals(shouldPayType)) {
                ordPayConfPO.setPrePayFee(UocMoneyUtil.bigDecimal2Long((BigDecimal)shouldPayAmount));
                ordFscShouldPayPo.setPayFeeType(UocCoreConstant.PaymentStage.ENTER_PENDING_PAYMENT);
            } else if (UocCoreConstant.ShouldPayType.ARRIVAL_PAYMENT_PAYABLE.equals(shouldPayType)) {
                ordPayConfPO.setVerPayFee(UocMoneyUtil.bigDecimal2Long((BigDecimal)shouldPayAmount));
                ordFscShouldPayPo.setPayFeeType(UocCoreConstant.PaymentStage.THE_ARRIVAL);
            } else if (UocCoreConstant.ShouldPayType.WARRANTY_PAYABLE.equals(shouldPayType)) {
                ordPayConfPO.setQuaPayFee(UocMoneyUtil.bigDecimal2Long((BigDecimal)shouldPayAmount));
                ordFscShouldPayPo.setPayFeeType(UocCoreConstant.PaymentStage.ACCEPTANCE_WARRANTY);
            }
        }
        catch (Exception e) {
            throw new UocProBusinessException("100001", "\u91d1\u989d\u8f6c\u6362\u5f02\u5e38");
        }
        this.ordPayConfMapper.updateFee(ordPayConfPO);
        ordFscShouldPayPo.setShouldPayId(Long.valueOf(this.generateIdUtil.nextId()));
        ordFscShouldPayPo.setShouldPayType(fscShouldPayBO.getShouldPayType());
        ordFscShouldPayPo.setObjectId(fscShouldPayBO.getObjectId());
        ordFscShouldPayPo.setOrderId(fscShouldPayBO.getOrderId());
        ordFscShouldPayPo.setObjType(reqBo.getObjType());
        ordFscShouldPayPo.setObjectType(fscShouldPayBO.getObjectType());
        ordFscShouldPayPo.setObjectNo(fscShouldPayBO.getObjectNo());
        try {
            ordFscShouldPayPo.setShouldPayFee(UocMoneyUtil.bigDecimal2Long((BigDecimal)fscShouldPayBO.getShouldPayAmount()));
        }
        catch (Exception e) {
            throw new UocProBusinessException("100001", "\u91d1\u989d\u8f6c\u6362\u5f02\u5e38");
        }
        ordFscShouldPayPo.setShouldPayDate(fscShouldPayBO.getShouldPayDate());
        ordFscShouldPayPo.setPayerId(fscShouldPayBO.getPayerId());
        ordFscShouldPayPo.setPayerName(fscShouldPayBO.getPayerName());
        ordFscShouldPayPo.setPayeeId(fscShouldPayBO.getPayeeId());
        ordFscShouldPayPo.setPayeeName(fscShouldPayBO.getPayeeName());
        ordFscShouldPayPo.setContractNo(fscShouldPayBO.getContractNo());
        ordFscShouldPayPo.setPenaltyRatio(fscShouldPayBO.getPenaltyRatio());
        ordFscShouldPayPo.setCreateTime(new Date());
        ordFscShouldPayPo.setPayConfId(payConfPO.getId());
        ordFscShouldPayPo.setPaidFee(Long.valueOf(0L));
        ordFscShouldPayPos.add(ordFscShouldPayPo);
        fscShouldPayBO.setContractId(salePO.getLinkContractId());
        return fscShouldPayBO;
    }

    private Date getShouldPayDate(UocProShouldPayOrDeductDealAtomReqBo reqBo, OrdPayConfPO payConfPO, OrdSalePO salePO) {
        reqBo.setObjNo(salePO.getSaleVoucherNo());
        Date shouldPayDate = null;
        if (1 == payConfPO.getPayRule()) {
            if (3 == payConfPO.getPayAccountDayRule()) {
                if ((UocConstant.SALE_ORDER_STATUS.ARRIVED.equals(salePO.getSaleState()) || UocConstant.SALE_ORDER_STATUS.ARRIVED_PART.equals(salePO.getSaleState())) && UocCoreConstant.OBJ_TYPE.SALE.equals(reqBo.getObjType())) {
                    shouldPayDate = this.getAgreementShouldPayDate(payConfPO, reqBo.getObjDate());
                    UocProShouldPayOrDeductAmountInfoBo totalAmountOfArrival = this.ordFscShouldPayMapper.getTotalAmountOfArrival(reqBo.getOrderId(), null, null, null);
                    try {
                        reqBo.setObjSaleAmount(UocMoneyUtil.long2BigDecimal((Long)totalAmountOfArrival.getObjSaleAmount()));
                        reqBo.setObjPurchaseAmount(UocMoneyUtil.long2BigDecimal((Long)totalAmountOfArrival.getObjPurchaseAmount()));
                    }
                    catch (Exception e) {
                        throw new UocProBusinessException("100001", "\u91d1\u989d\u8f6c\u6362\u5f02\u5e38");
                    }
                }
            } else if (2 == payConfPO.getPayAccountDayRule() && (UocConstant.SALE_ORDER_STATUS.RECEIVED.equals(salePO.getSaleState()) || UocConstant.SALE_ORDER_STATUS.ZONE_ACCEPT_PART.equals(salePO.getSaleState())) && UocCoreConstant.OBJ_TYPE.SALE.equals(reqBo.getObjType())) {
                shouldPayDate = this.getAgreementShouldPayDate(payConfPO, reqBo.getObjDate());
                UocProShouldPayOrDeductAmountInfoBo totalAmountOfArrival = this.ordFscShouldPayMapper.getTotalAmountOfAcceptance(reqBo.getOrderId(), null, null);
                try {
                    reqBo.setObjSaleAmount(UocMoneyUtil.long2BigDecimal((Long)totalAmountOfArrival.getObjSaleAmount()));
                    reqBo.setObjPurchaseAmount(UocMoneyUtil.long2BigDecimal((Long)totalAmountOfArrival.getObjPurchaseAmount()));
                }
                catch (Exception e) {
                    throw new UocProBusinessException("100001", "\u91d1\u989d\u8f6c\u6362\u5f02\u5e38");
                }
            }
        } else if (3 == payConfPO.getPayNodeRule()) {
            if ((UocConstant.SALE_ORDER_STATUS.ARRIVED.equals(salePO.getSaleState()) || UocConstant.SALE_ORDER_STATUS.ARRIVED_PART.equals(salePO.getSaleState())) && UocCoreConstant.OBJ_TYPE.SALE.equals(reqBo.getObjType())) {
                shouldPayDate = this.getAgreementShouldPayDate(payConfPO, reqBo.getObjDate());
                UocProShouldPayOrDeductAmountInfoBo totalAmountOfArrival = this.ordFscShouldPayMapper.getTotalAmountOfArrival(reqBo.getOrderId(), null, null, null);
                try {
                    reqBo.setObjSaleAmount(UocMoneyUtil.long2BigDecimal((Long)totalAmountOfArrival.getObjSaleAmount()));
                    reqBo.setObjPurchaseAmount(UocMoneyUtil.long2BigDecimal((Long)totalAmountOfArrival.getObjPurchaseAmount()));
                }
                catch (Exception e) {
                    throw new UocProBusinessException("100001", "\u91d1\u989d\u8f6c\u6362\u5f02\u5e38");
                }
            }
        } else if (2 == payConfPO.getPayNodeRule() && (UocConstant.SALE_ORDER_STATUS.RECEIVED.equals(salePO.getSaleState()) || UocConstant.SALE_ORDER_STATUS.ZONE_ACCEPT_PART.equals(salePO.getSaleState())) && UocCoreConstant.OBJ_TYPE.SALE.equals(reqBo.getObjType())) {
            shouldPayDate = this.getAgreementShouldPayDate(payConfPO, reqBo.getObjDate());
            UocProShouldPayOrDeductAmountInfoBo totalAmountOfArrival = this.ordFscShouldPayMapper.getTotalAmountOfAcceptance(reqBo.getOrderId(), null, null);
            try {
                reqBo.setObjSaleAmount(UocMoneyUtil.long2BigDecimal((Long)totalAmountOfArrival.getObjSaleAmount()));
                reqBo.setObjPurchaseAmount(UocMoneyUtil.long2BigDecimal((Long)totalAmountOfArrival.getObjPurchaseAmount()));
            }
            catch (Exception e) {
                throw new UocProBusinessException("100001", "\u91d1\u989d\u8f6c\u6362\u5f02\u5e38");
            }
        }
        return shouldPayDate;
    }

    private Date getAgreementShouldPayDate(OrdPayConfPO payConfPO, Date objDate) {
        Date shouldPayDate = null;
        ZoneId zoneId = ZoneId.systemDefault();
        LocalDateTime nowLocalDateTime = objDate.toInstant().atZone(zoneId).toLocalDateTime();
        if (null != payConfPO.getPayAccountDay()) {
            LocalTime localTime = LocalTime.of(23, 59, 59);
            shouldPayDate = payConfPO.getPayAccountDay() <= nowLocalDateTime.getDayOfMonth() ? (12 == nowLocalDateTime.getMonth().getValue() ? Date.from(LocalDateTime.of(nowLocalDateTime.with(ChronoField.YEAR, nowLocalDateTime.getYear() + 1).with(ChronoField.MONTH_OF_YEAR, 1L).with(ChronoField.DAY_OF_MONTH, payConfPO.getPayAccountDay().intValue()).toLocalDate(), localTime).atZone(zoneId).toInstant()) : Date.from(LocalDateTime.of(nowLocalDateTime.with(ChronoField.MONTH_OF_YEAR, nowLocalDateTime.getMonth().getValue() + 1).with(ChronoField.DAY_OF_MONTH, payConfPO.getPayAccountDay().intValue()).toLocalDate(), localTime).atZone(zoneId).toInstant())) : Date.from(LocalDateTime.of(nowLocalDateTime.with(ChronoField.DAY_OF_MONTH, payConfPO.getPayAccountDay().intValue()).toLocalDate(), localTime).atZone(zoneId).toInstant());
        } else if (null != payConfPO.getPaymentDays()) {
            shouldPayDate = Date.from(nowLocalDateTime.plus(payConfPO.getPaymentDays().intValue(), ChronoUnit.DAYS).atZone(zoneId).toInstant());
        }
        return shouldPayDate;
    }

    private void runSale(UocProShouldPayOrDeductDealAtomReqBo reqBo, OrdSalePO salePO) {
        if (!"2".equals(salePO.getOrderSource()) && reqBo.getRunStatus().booleanValue()) {
            UocProcessRunRspBO uocProcessRunRspBO;
            UocProcessRunReqBO processRunReqBO = new UocProcessRunReqBO();
            processRunReqBO.setSysCode("UOC");
            processRunReqBO.setObjId(reqBo.getSaleVoucherId());
            processRunReqBO.setObjType(UocConstant.OBJ_TYPE.SALE);
            processRunReqBO.setOrderId(reqBo.getOrderId());
            processRunReqBO.setOperId("0");
            if (UocConstant.SALE_ORDER_STATUS.ZONE_AUDIT.equals(salePO.getSaleState())) {
                HashMap<String, Object> map = new HashMap<String, Object>();
                map.put("payFlag", "1");
                processRunReqBO.setVariables(map);
            }
            if (!"0000".equals((uocProcessRunRspBO = this.uocRunProcessAtomService.start(processRunReqBO)).getRespCode())) {
                throw new UocProBusinessException(uocProcessRunRspBO.getRespCode(), "\u4ece\u4ed8\u6b3e\u4e2d\u5f80\u4e0b\u6d41\u8f6c\u5931\u8d25\uff1a" + uocProcessRunRspBO.getRespDesc());
            }
        }
    }

    private Date getWarrantyTime(OrdInspectionPO inspectionPO, OrdPayConfPO payConfPO) {
        Date warrantyTime = null;
        if (null != payConfPO.getQuaPaySup() && payConfPO.getQuaPaySup().compareTo(BigDecimal.ZERO) > 0 && null != payConfPO.getWarantty() && 0 < payConfPO.getWarantty()) {
            ZoneId zoneId = ZoneId.systemDefault();
            LocalDateTime nowLocalDateTime = inspectionPO.getInspectionTime().toInstant().atZone(zoneId).toLocalDateTime();
            warrantyTime = Date.from(nowLocalDateTime.plus(payConfPO.getWarantty().intValue(), ChronoUnit.DAYS).atZone(zoneId).toInstant());
        }
        return warrantyTime;
    }

    private Boolean dealFscShouldPayOrDeduct(OrdPayConfPO payConfPO, UocProShouldPayOrDeductDealAtomReqBo reqBo, OrdStakeholderPO stakeholderPO, OrdSalePO salePO, List<UocOrdFscShouldPayPo> ordFscShouldPayPos, List<FscShouldPayBO> fscShouldPayBOS, Integer threePartyPayment, String purPayType, OrdPurchasePO purchasePO) {
        boolean isRunPay = false;
        if ("0".equals(String.valueOf(payConfPO.getPayType()))) {
            if (UocCoreConstant.PaymentStage.ENTER_PENDING_PAYMENT_NOW.equals(reqBo.getPaymentStage()) || UocCoreConstant.PaymentStage.ENTER_PENDING_PAYMENT.equals(reqBo.getPaymentStage()) && UocConstant.SALE_ORDER_STATUS.PAYING.equals(salePO.getSaleState())) {
                if (1 == payConfPO.getUserType()) {
                    fscShouldPayBOS.add(this.buildFscShouldPayInfo(reqBo, reqBo.getObjSaleAmount(), threePartyPayment, stakeholderPO, payConfPO, 5, UocCoreConstant.ShouldPayType.PREPAYMENT_PAYABLE, ordFscShouldPayPos, null, reqBo.getObjNo(), salePO));
                } else {
                    fscShouldPayBOS.add(this.buildFscShouldPayInfo(reqBo, reqBo.getObjPurchaseAmount(), threePartyPayment, stakeholderPO, payConfPO, 1, UocCoreConstant.ShouldPayType.PREPAYMENT_PAYABLE, ordFscShouldPayPos, null, purchasePO.getPurchaseVoucherNo(), salePO));
                }
            }
        } else if ("1".equals(String.valueOf(payConfPO.getPayType()))) {
            if (UocCoreConstant.PaymentStage.ENTER_PENDING_PAYMENT_NOW.equals(reqBo.getPaymentStage()) || UocCoreConstant.PaymentStage.ENTER_PENDING_PAYMENT.equals(reqBo.getPaymentStage()) && UocConstant.SALE_ORDER_STATUS.PAYING.equals(salePO.getSaleState())) {
                reqBo.setObjNo(salePO.getSaleVoucherNo());
                if (null != payConfPO.getPrePaySup() && payConfPO.getPrePaySup().compareTo(BigDecimal.ZERO) > 0) {
                    BigDecimal objAmount;
                    String objNo;
                    int objectType;
                    if (payConfPO.getPrePaySup().compareTo(new BigDecimal("100")) < 0) {
                        if (1 == payConfPO.getUserType()) {
                            objectType = 5;
                            objNo = reqBo.getObjNo();
                            objAmount = reqBo.getObjSaleAmount().multiply(payConfPO.getPrePaySup()).multiply(new BigDecimal("0.01")).setScale(2, 1);
                        } else {
                            objectType = 1;
                            objNo = purchasePO.getPurchaseVoucherNo();
                            objAmount = reqBo.getObjPurchaseAmount().multiply(payConfPO.getPrePaySup()).multiply(new BigDecimal("0.01")).setScale(2, 1);
                        }
                    } else if (1 == payConfPO.getUserType()) {
                        objectType = 5;
                        objNo = reqBo.getObjNo();
                        objAmount = reqBo.getObjSaleAmount();
                    } else {
                        objectType = 1;
                        objNo = purchasePO.getPurchaseVoucherNo();
                        objAmount = reqBo.getObjPurchaseAmount();
                    }
                    FscShouldPayBO fscShouldPayBO = this.buildFscShouldPayInfo(reqBo, objAmount, threePartyPayment, stakeholderPO, payConfPO, objectType, UocCoreConstant.ShouldPayType.PREPAYMENT_PAYABLE, ordFscShouldPayPos, null, objNo, salePO);
                    if (null == fscShouldPayBO) {
                        isRunPay = true;
                    } else {
                        fscShouldPayBOS.add(fscShouldPayBO);
                    }
                } else {
                    isRunPay = true;
                }
            } else if (UocCoreConstant.PaymentStage.THE_ARRIVAL.equals(reqBo.getPaymentStage())) {
                if (!UocConstant.OBJ_TYPE.SHIP.equals(reqBo.getObjType())) {
                    return false;
                }
                OrdShipPO ordShipPO = new OrdShipPO();
                ordShipPO.setOrderId(reqBo.getOrderId());
                ordShipPO.setShipVoucherId(reqBo.getObjId());
                ordShipPO = this.ordShipMapper.getModelBy(ordShipPO);
                reqBo.setObjNo(ordShipPO.getShipVoucherCode());
                if (null != payConfPO.getVerPaySup() && payConfPO.getVerPaySup().compareTo(BigDecimal.ZERO) > 0) {
                    FscShouldPayBO fscShouldPayBO;
                    BigDecimal objAmount = null;
                    if (UocConstant.SALE_ORDER_STATUS.ARRIVED_PART.equals(salePO.getSaleState()) || UocConstant.SALE_ORDER_STATUS.ARRIVED.equals(salePO.getSaleState())) {
                        BigDecimal remainderPaySup = BigDecimal.ZERO;
                        if (null != payConfPO.getPilPaySup() && payConfPO.getPilPaySup().compareTo(BigDecimal.ZERO) > 0) {
                            remainderPaySup = remainderPaySup.add(payConfPO.getPilPaySup());
                        }
                        if (null != payConfPO.getQuaPaySup() && payConfPO.getQuaPaySup().compareTo(BigDecimal.ZERO) > 0) {
                            remainderPaySup = remainderPaySup.add(payConfPO.getQuaPaySup());
                        }
                        if (remainderPaySup.compareTo(BigDecimal.ZERO) <= 0) {
                            UocProShouldPayOrDeductAmountInfoBo totalAmountOfArrival = this.ordFscShouldPayMapper.getTotalAmountOfArrival(reqBo.getOrderId(), reqBo.getObjId(), payConfPO.getId(), payConfPO.getUserType());
                            try {
                                objAmount = 1 == payConfPO.getUserType() ? UocMoneyUtil.long2BigDecimal((Long)totalAmountOfArrival.getObjSaleAmount()) : UocMoneyUtil.long2BigDecimal((Long)totalAmountOfArrival.getObjPurchaseAmount());
                            }
                            catch (Exception e) {
                                throw new UocProBusinessException("100001", "\u91d1\u989d\u8f6c\u6362\u5f02\u5e38");
                            }
                        }
                    }
                    if (null == objAmount) {
                        UocProShouldPayOrDeductAmountInfoBo totalAmountOfArrival = this.ordFscShouldPayMapper.getTotalAmountOfArrival(reqBo.getOrderId(), reqBo.getObjId(), null, null);
                        try {
                            objAmount = 1 == payConfPO.getUserType() ? UocMoneyUtil.long2BigDecimal((Long)totalAmountOfArrival.getObjSaleAmount()).multiply(payConfPO.getVerPaySup()).multiply(new BigDecimal("0.01")).setScale(2, 1) : UocMoneyUtil.long2BigDecimal((Long)totalAmountOfArrival.getObjPurchaseAmount()).multiply(payConfPO.getVerPaySup()).multiply(new BigDecimal("0.01")).setScale(2, 1);
                        }
                        catch (Exception e) {
                            throw new UocProBusinessException("100001", "\u91d1\u989d\u8f6c\u6362\u5f02\u5e38");
                        }
                    }
                    if (null != (fscShouldPayBO = this.buildFscShouldPayInfo(reqBo, objAmount, threePartyPayment, stakeholderPO, payConfPO, 7, UocCoreConstant.ShouldPayType.ARRIVAL_PAYMENT_PAYABLE, ordFscShouldPayPos, null, reqBo.getObjNo(), salePO))) {
                        fscShouldPayBOS.add(fscShouldPayBO);
                    }
                }
            } else if (UocCoreConstant.PaymentStage.ACCEPTING.equals(reqBo.getPaymentStage())) {
                Date warrantyTime;
                if (!UocConstant.OBJ_TYPE.INSPECTION.equals(reqBo.getObjType())) {
                    return false;
                }
                OrdInspectionPO inspectionPO = new OrdInspectionPO();
                inspectionPO.setOrderId(reqBo.getOrderId());
                inspectionPO.setInspectionVoucherId(reqBo.getObjId());
                inspectionPO = this.ordInspectionMapper.getModelBy(inspectionPO);
                reqBo.setObjNo(inspectionPO.getInspectionVoucherCode());
                if (null != payConfPO.getPilPaySup() && payConfPO.getPilPaySup().compareTo(BigDecimal.ZERO) > 0) {
                    FscShouldPayBO fscShouldPayBO;
                    BigDecimal objAmount = null;
                    if ((UocConstant.SALE_ORDER_STATUS.RECEIVED.equals(salePO.getSaleState()) || UocConstant.SALE_ORDER_STATUS.ZONE_ACCEPT_PART.equals(salePO.getSaleState())) && null != payConfPO.getQuaPaySup() && payConfPO.getQuaPaySup().compareTo(BigDecimal.ZERO) <= 0) {
                        UocProShouldPayOrDeductAmountInfoBo totalAmountOfAcceptance = this.ordFscShouldPayMapper.getTotalAmountOfAcceptance(payConfPO.getOrderId(), payConfPO.getId(), payConfPO.getUserType());
                        try {
                            objAmount = 1 == payConfPO.getUserType() ? UocMoneyUtil.long2BigDecimal((Long)totalAmountOfAcceptance.getObjSaleAmount()) : UocMoneyUtil.long2BigDecimal((Long)totalAmountOfAcceptance.getObjPurchaseAmount());
                        }
                        catch (Exception e) {
                            throw new UocProBusinessException("100001", "\u91d1\u989d\u8f6c\u6362\u5f02\u5e38");
                        }
                    }
                    if (null == objAmount) {
                        try {
                            objAmount = 1 == payConfPO.getUserType() ? UocMoneyUtil.long2BigDecimal((Long)inspectionPO.getInspTotalSaleFee()).multiply(payConfPO.getPilPaySup()).multiply(new BigDecimal("0.01")).setScale(2, 1) : UocMoneyUtil.long2BigDecimal((Long)inspectionPO.getInspTotalPurchaseFee()).multiply(payConfPO.getPilPaySup()).multiply(new BigDecimal("0.01")).setScale(2, 1);
                        }
                        catch (Exception e) {
                            throw new UocProBusinessException("100001", "\u91d1\u989d\u8f6c\u6362\u5f02\u5e38");
                        }
                    }
                    if (null != (fscShouldPayBO = this.buildFscShouldPayInfo(reqBo, objAmount, threePartyPayment, stakeholderPO, payConfPO, 6, UocCoreConstant.ShouldPayType.ACCEPTANCE_PAYMENT_PAYABLE, ordFscShouldPayPos, null, reqBo.getObjNo(), salePO))) {
                        fscShouldPayBOS.add(fscShouldPayBO);
                    }
                }
                if (null != (warrantyTime = this.getWarrantyTime(inspectionPO, payConfPO))) {
                    if (1 == payConfPO.getUserType()) {
                        inspectionPO.setPurWarrantyTime(warrantyTime);
                    } else {
                        inspectionPO.setProWarrantyTime(warrantyTime);
                    }
                    this.ordInspectionMapper.updateWarrantyTime(inspectionPO);
                }
            } else if (UocCoreConstant.PaymentStage.ACCEPTANCE_WARRANTY.equals(reqBo.getPaymentStage())) {
                FscShouldPayBO fscShouldPayBO;
                BigDecimal objAmount;
                OrdInspectionPO inspectionPO;
                block72: {
                    inspectionPO = new OrdInspectionPO();
                    inspectionPO.setOrderId(reqBo.getOrderId());
                    inspectionPO.setInspectionVoucherId(reqBo.getObjId());
                    inspectionPO = this.ordInspectionMapper.getModelBy(inspectionPO);
                    reqBo.setObjNo(inspectionPO.getInspectionVoucherCode());
                    try {
                        if (1 == payConfPO.getUserType()) {
                            if (null != inspectionPO.getPurWarrantyTime() && inspectionPO.getPurWarrantyTime().before(new Date())) {
                                objAmount = UocMoneyUtil.long2BigDecimal((Long)inspectionPO.getInspTotalSaleFee()).multiply(payConfPO.getQuaPaySup()).multiply(new BigDecimal("0.01")).setScale(2, 1);
                                break block72;
                            }
                            return false;
                        }
                        if (null != inspectionPO.getProWarrantyTime() && inspectionPO.getProWarrantyTime().before(new Date())) {
                            objAmount = UocMoneyUtil.long2BigDecimal((Long)inspectionPO.getInspTotalPurchaseFee()).multiply(payConfPO.getQuaPaySup()).multiply(new BigDecimal("0.01")).setScale(2, 1);
                            break block72;
                        }
                        return false;
                    }
                    catch (Exception e) {
                        throw new UocProBusinessException("100001", "\u91d1\u989d\u8f6c\u6362\u5f02\u5e38");
                    }
                }
                if (UocConstant.SALE_ORDER_STATUS.RECEIVED.equals(salePO.getSaleState()) || UocConstant.SALE_ORDER_STATUS.ZONE_ACCEPT_PART.equals(salePO.getSaleState())) {
                    if (1 == payConfPO.getUserType()) {
                        inspectionPO.setPurWarrantyTime(new Date());
                    } else {
                        inspectionPO.setProWarrantyTime(new Date());
                    }
                    int i = this.ordInspectionMapper.checkWarrantyTime(inspectionPO);
                    if (i == 1) {
                        UocProShouldPayOrDeductAmountInfoBo totalAmountOfAcceptance = this.ordFscShouldPayMapper.getTotalAmountOfAcceptance(payConfPO.getOrderId(), payConfPO.getId(), payConfPO.getUserType());
                        try {
                            objAmount = 1 == payConfPO.getUserType() ? UocMoneyUtil.long2BigDecimal((Long)totalAmountOfAcceptance.getObjSaleAmount()) : UocMoneyUtil.long2BigDecimal((Long)totalAmountOfAcceptance.getObjPurchaseAmount());
                        }
                        catch (Exception e) {
                            throw new UocProBusinessException("100001", "\u91d1\u989d\u8f6c\u6362\u5f02\u5e38");
                        }
                    }
                }
                if (null != (fscShouldPayBO = this.buildFscShouldPayInfo(reqBo, objAmount, threePartyPayment, stakeholderPO, payConfPO, 6, UocCoreConstant.ShouldPayType.WARRANTY_PAYABLE, ordFscShouldPayPos, null, reqBo.getObjNo(), salePO))) {
                    fscShouldPayBOS.add(fscShouldPayBO);
                    OrdInspectionPO po = new OrdInspectionPO();
                    po.setOrderId(inspectionPO.getOrderId());
                    po.setInspectionVoucherId(inspectionPO.getInspectionVoucherId());
                    if (1 == payConfPO.getUserType()) {
                        po.setPurWarrantyTime(null);
                        po.setProWarrantyTime(new Date());
                    } else {
                        po.setPurWarrantyTime(new Date());
                        po.setProWarrantyTime(null);
                    }
                    this.ordInspectionMapper.updateNullWarrantyTime(po);
                }
            }
        } else if (null != reqBo.getIsToBePaid() && reqBo.getIsToBePaid().booleanValue()) {
            isRunPay = true;
            if (null == payConfPO.getIsPushQua() || 0 == payConfPO.getIsPushQua()) {
                FscCreditDeductAbilityRspBO fscCreditDeductAbilityRspBO = this.deductionPeriod(reqBo, stakeholderPO, threePartyPayment, null);
                if (!"0000".equals(fscCreditDeductAbilityRspBO.getRespCode())) {
                    if (2 == threePartyPayment) {
                        if ("2".equals(purPayType) && !"0000".equals((fscCreditDeductAbilityRspBO = this.deductionPeriod(reqBo, stakeholderPO, 3, true)).getRespCode())) {
                            throw new UocProBusinessException(fscCreditDeductAbilityRspBO.getRespCode(), "\u6263\u9664\u8fd0\u8425\u65b9\u989d\u5ea6\u5931\u8d25\uff0c\u9000\u8fd8\u91c7\u8d2d\u65b9\u989d\u5ea6\u4e5f\u5931\u8d25\uff1a" + fscCreditDeductAbilityRspBO.getRespDesc());
                        }
                        throw new UocProBusinessException(fscCreditDeductAbilityRspBO.getRespCode(), "\u6263\u9664\u8fd0\u8425\u65b9\u989d\u5ea6\u5931\u8d25\uff1a" + fscCreditDeductAbilityRspBO.getRespDesc());
                    }
                    throw new UocProBusinessException(fscCreditDeductAbilityRspBO.getRespCode(), fscCreditDeductAbilityRspBO.getRespDesc());
                }
                OrdPayConfPO confPO = new OrdPayConfPO();
                confPO.setId(payConfPO.getId());
                confPO.setOrderId(payConfPO.getOrderId());
                confPO.setIsPushQua(Integer.valueOf(1));
                this.ordPayConfMapper.update(confPO);
            }
        } else {
            if (!UocCoreConstant.OBJ_TYPE.SALE.equals(reqBo.getObjType())) {
                return false;
            }
            Date shouldPayDate = this.getShouldPayDate(reqBo, payConfPO, salePO);
            if (null != shouldPayDate) {
                if (1 == payConfPO.getUserType()) {
                    fscShouldPayBOS.add(this.buildFscShouldPayInfo(reqBo, reqBo.getObjSaleAmount(), threePartyPayment, stakeholderPO, payConfPO, 5, UocCoreConstant.ShouldPayType.ACCOUNT_PAYABLE, ordFscShouldPayPos, shouldPayDate, reqBo.getObjNo(), salePO));
                    OrderPO orderPO = new OrderPO();
                    orderPO.setOrderId(reqBo.getOrderId());
                    orderPO.setExpTime(shouldPayDate);
                    this.orderMapper.updateById(orderPO);
                } else {
                    fscShouldPayBOS.add(this.buildFscShouldPayInfo(reqBo, reqBo.getObjPurchaseAmount(), threePartyPayment, stakeholderPO, payConfPO, 1, UocCoreConstant.ShouldPayType.ACCOUNT_PAYABLE, ordFscShouldPayPos, shouldPayDate, purchasePO.getPurchaseVoucherNo(), salePO));
                }
            }
        }
        return isRunPay;
    }
}

