/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.uoc.common.busi.impl;

import cn.hutool.core.util.ObjectUtil;
import com.ohaotian.plugin.common.util.DateUtils;
import com.tydic.uoc.base.constants.PecConstant;
import com.tydic.uoc.base.constants.UocConstant;
import com.tydic.uoc.base.exception.UocProBusinessException;
import com.tydic.uoc.common.ability.bo.DicDictionaryBO;
import com.tydic.uoc.common.ability.bo.OrdItemRspBO;
import com.tydic.uoc.common.ability.bo.OrdSaleRspBO;
import com.tydic.uoc.common.ability.bo.PebAccessoryReqBO;
import com.tydic.uoc.common.ability.bo.PebOrderDeliveryAbilityReqBO;
import com.tydic.uoc.common.ability.bo.PebOrderDeliveryAbilityRspBO;
import com.tydic.uoc.common.ability.bo.PebProcessOrderCountBO;
import com.tydic.uoc.common.atom.api.DicDictionaryService;
import com.tydic.uoc.common.atom.api.PebOperationPermissionsCheckingAtomService;
import com.tydic.uoc.common.atom.api.SelectDicValByPcodeAndCode;
import com.tydic.uoc.common.atom.api.UocCoreBusiOperRecordAtomService;
import com.tydic.uoc.common.atom.api.UocCoreCreateAccessoryAtomService;
import com.tydic.uoc.common.atom.api.UocCoreOrderShipAtomService;
import com.tydic.uoc.common.atom.api.UocCoreQryOrderDetailAtomService;
import com.tydic.uoc.common.atom.api.UocCoreQryOrderItemListAtomService;
import com.tydic.uoc.common.atom.api.UocCoreStateCheckAtomService;
import com.tydic.uoc.common.atom.api.UocRunProcessAtomService;
import com.tydic.uoc.common.atom.bo.PebOperationPermissionsCheckingAtomReqBO;
import com.tydic.uoc.common.atom.bo.PebOperationPermissionsCheckingAtomRspBO;
import com.tydic.uoc.common.atom.bo.ShipCruxFieldBO;
import com.tydic.uoc.common.atom.bo.UocCoreCreateAccessoryReqBO;
import com.tydic.uoc.common.atom.bo.UocCoreCreateAccessoryRspBO;
import com.tydic.uoc.common.atom.bo.UocCoreOrderShipReqBO;
import com.tydic.uoc.common.atom.bo.UocCoreOrderShipRspBO;
import com.tydic.uoc.common.atom.bo.UocCoreOryOrderReqBO;
import com.tydic.uoc.common.atom.bo.UocCoreQryOrderDetailRspBO;
import com.tydic.uoc.common.atom.bo.UocCoreQryOrderItemListRspBO;
import com.tydic.uoc.common.atom.bo.UocCoreShipItemReqBO;
import com.tydic.uoc.common.atom.bo.UocCoreStateCheckAtomReqBO;
import com.tydic.uoc.common.atom.bo.UocCoreStateCheckAtomRspBO;
import com.tydic.uoc.common.atom.bo.UocProGetVoucherNoAtomReqBo;
import com.tydic.uoc.common.atom.bo.UocProGetVoucherNoAtomRspBo;
import com.tydic.uoc.common.atom.bo.UocProcessRunReqBO;
import com.tydic.uoc.common.atom.bo.UocProcessRunRspBO;
import com.tydic.uoc.common.atom.impl.UocProGetVoucherNoAtomService;
import com.tydic.uoc.common.busi.api.PebOrderDeliveryBusiService;
import com.tydic.uoc.dao.OrdSaleMapper;
import com.tydic.uoc.po.OrdSalePO;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.joda.time.DateTime;
import org.joda.time.format.DateTimeFormat;
import org.joda.time.format.DateTimeFormatter;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class PebOrderDeliveryBusiServiceImpl
implements PebOrderDeliveryBusiService {
    private static final Integer PURCHASE_TYPE_MATERIAL = 1;
    private static final Integer ORDER_METHOD_UNIT_PRICE = 1;
    private static final Integer ORDER_METHOD_TOTAL_PRICE = 2;
    private static final Integer ORDER_METHOD_FRAME = 3;
    private static final String DIC_QRY_KEY = "unit_order_ship_limit";
    private static final String DIC_QRY_PCODE = "UNIT_ORDER_SHIP_LIMIT";
    @Autowired
    private UocCoreQryOrderDetailAtomService uocCoreQryOrerDetailAtomService;
    @Autowired
    private UocCoreStateCheckAtomService uocCoreStateCheckAtomService;
    @Autowired
    private UocCoreQryOrderItemListAtomService uocCoreQryOrderItemListAtomService;
    @Autowired
    private DicDictionaryService dicDictionaryService;
    @Autowired
    private PebOperationPermissionsCheckingAtomService pebOperationPermissionsCheckingAtomService;
    @Autowired
    private UocCoreOrderShipAtomService uocCoreOrderShipAtomService;
    @Autowired
    private UocRunProcessAtomService uocRunProcessAtomService;
    @Autowired
    private UocCoreBusiOperRecordAtomService uocCoreBusiOperRecordAtomService;
    @Autowired
    private UocCoreCreateAccessoryAtomService uocCoreCreateAccessoryAtomService;
    @Autowired
    private OrdSaleMapper ordSaleMapper;
    @Autowired
    private SelectDicValByPcodeAndCode selectDicValByPcodeAndCode;
    @Autowired
    private UocProGetVoucherNoAtomService uocProGetVoucherNoAtomService;

    @Override
    public PebOrderDeliveryAbilityRspBO dealPebOrderDelivery(PebOrderDeliveryAbilityReqBO reqBO) {
        List pebAccessoryReqBOList;
        DateTime beginDate;
        List pebProcessOrderCountBOList;
        this.validateArg(reqBO);
        if (StringUtils.isBlank((CharSequence)reqBO.getActionCode())) {
            reqBO.setActionCode("ACTPEB005");
        }
        PebOrderDeliveryAbilityRspBO pebOrderDeliveryAbilityRspBO = new PebOrderDeliveryAbilityRspBO();
        UocCoreOryOrderReqBO uocCoreOryOrderReqBO = new UocCoreOryOrderReqBO();
        uocCoreOryOrderReqBO.setSaleVoucherId(reqBO.getSaleVoucherId());
        uocCoreOryOrderReqBO.setOrderId(reqBO.getOrderId());
        UocCoreQryOrderDetailRspBO uocCoreQryOrderDetailRspBO = this.uocCoreQryOrerDetailAtomService.qryCoreQryOrderDetail(uocCoreOryOrderReqBO);
        if (!"0000".equals(uocCoreQryOrderDetailRspBO.getRespCode())) {
            throw new UocProBusinessException("100001", "\u67e5\u8be2\u8ba2\u5355\u8be6\u60c5\u5931\u8d25,\u5931\u8d25\u63cf\u8ff0:" + uocCoreQryOrderDetailRspBO.getRespDesc());
        }
        if (uocCoreQryOrderDetailRspBO.getOrderRspBO() == null || uocCoreQryOrderDetailRspBO.getOrdSaleRspBO() == null) {
            throw new UocProBusinessException("100001", "\u67e5\u8be2\u8ba2\u5355\u8be6\u60c5\u5931\u8d25,\u5931\u8d25\u63cf\u8ff0:\u6ca1\u6709\u67e5\u8be2\u5230\u76f8\u5173\u5355\u636e!");
        }
        UocCoreStateCheckAtomReqBO uocCoreStateCheckAtomReqBO = new UocCoreStateCheckAtomReqBO();
        uocCoreStateCheckAtomReqBO.setActionCode(reqBO.getActionCode());
        uocCoreStateCheckAtomReqBO.setObjType(UocConstant.OBJ_TYPE.SALE);
        uocCoreStateCheckAtomReqBO.setObjId(reqBO.getSaleVoucherId());
        uocCoreStateCheckAtomReqBO.setOrderId(reqBO.getOrderId());
        UocCoreStateCheckAtomRspBO uocCoreStateCheck = this.uocCoreStateCheckAtomService.getUocCoreStateCheck(uocCoreStateCheckAtomReqBO);
        if (!"0000".equals(uocCoreStateCheck.getRespCode())) {
            throw new UocProBusinessException("100001", "\u8ba2\u5355\u72b6\u6001\u6821\u9a8c\u539f\u5b50\u670d\u52a1\u5931\u8d25,\u5931\u8d25\u63cf\u8ff0:" + uocCoreStateCheck.getRespDesc());
        }
        OrdSaleRspBO ordSaleRspBO = uocCoreQryOrderDetailRspBO.getOrdSaleRspBO();
        UocCoreOryOrderReqBO uocCoreOryOrderItemReqBO = new UocCoreOryOrderReqBO();
        uocCoreOryOrderItemReqBO.setSaleVoucherId(reqBO.getSaleVoucherId());
        uocCoreOryOrderItemReqBO.setPageNo(1);
        uocCoreOryOrderItemReqBO.setOrderId(reqBO.getOrderId());
        uocCoreOryOrderItemReqBO.setPageSize(200);
        UocCoreQryOrderItemListRspBO uocCoreQryOrderItemListRspBO = this.uocCoreQryOrderItemListAtomService.qryCoreQryOrderItemList(uocCoreOryOrderItemReqBO);
        if (!"0000".equals(uocCoreQryOrderItemListRspBO.getRespCode())) {
            throw new UocProBusinessException("100001", "\u67e5\u8be2\u8ba2\u5355\u660e\u7ec6\u5931\u8d25,\u5931\u8d25\u63cf\u8ff0:" + uocCoreQryOrderItemListRspBO.getRespDesc());
        }
        List rows = uocCoreQryOrderItemListRspBO.getRows();
        if (CollectionUtils.isEmpty((Collection)rows)) {
            throw new UocProBusinessException("100001", "\u67e5\u8be2\u8ba2\u5355\u660e\u7ec6\u5931\u8d25,\u5931\u8d25\u63cf\u8ff0:\u6ca1\u6709\u67e5\u8be2\u5230\u660e\u7ec6\u4fe1\u606f!");
        }
        DicDictionaryBO codeByVal = this.dicDictionaryService.getCodeByVal(DIC_QRY_KEY, DIC_QRY_PCODE);
        int multiple = 1;
        if (codeByVal != null) {
            multiple = Integer.parseInt(codeByVal.getDescrip());
        }
        if (!CollectionUtils.isEmpty((Collection)(pebProcessOrderCountBOList = reqBO.getPebProcessOrderCountBOList()))) {
            for (PebProcessOrderCountBO pebProcessOrderCountBO : pebProcessOrderCountBOList) {
                for (OrdItemRspBO ordItemRspBO : rows) {
                    BigDecimal newSendCount;
                    if (!ordItemRspBO.getOrdItemId().equals(pebProcessOrderCountBO.getOrdItemId())) continue;
                    pebProcessOrderCountBO.setUnitName(ordItemRspBO.getUnitName());
                    BigDecimal purchaseCount = ordItemRspBO.getPurchaseCount();
                    BigDecimal sendCount = ordItemRspBO.getSendCount();
                    if (sendCount == null) {
                        sendCount = new BigDecimal(0);
                    }
                    if ((newSendCount = sendCount.add(pebProcessOrderCountBO.getProcessCount())).compareTo(purchaseCount) > 0) {
                        BigDecimal modVal = newSendCount.remainder(purchaseCount).setScale(0, 4);
                        if (newSendCount.multiply(new BigDecimal(multiple)).compareTo(purchaseCount) > 0) {
                            throw new UocProBusinessException("100001", "\u53d1\u8d27\u91cf\u4e0d\u80fd\u5927\u4e8e\u672a\u53d1\u8d27\u91cf");
                        }
                    }
                    ordItemRspBO.setSendCount(newSendCount);
                }
            }
        }
        if (StringUtils.isNotBlank((CharSequence)reqBO.getActionCode()) && !PecConstant.AuthCtrl.NO_CTRL.equals(reqBO.getAuthCtrl())) {
            PebOperationPermissionsCheckingAtomReqBO pebOperationPermissionsCheckingAtomReqBO = new PebOperationPermissionsCheckingAtomReqBO();
            pebOperationPermissionsCheckingAtomReqBO.setActionCode(reqBO.getActionCode());
            pebOperationPermissionsCheckingAtomReqBO.setAuthCtrl(reqBO.getAuthCtrl());
            pebOperationPermissionsCheckingAtomReqBO.setOrderId(reqBO.getOrderId());
            pebOperationPermissionsCheckingAtomReqBO.setStationId(reqBO.getStationId());
            pebOperationPermissionsCheckingAtomReqBO.setMemId(reqBO.getMemId());
            pebOperationPermissionsCheckingAtomReqBO.setMemId(reqBO.getMemIdIn());
            PebOperationPermissionsCheckingAtomRspBO pebOperationPermissionsCheckingAtomRspBO = this.pebOperationPermissionsCheckingAtomService.dealPebOperationPermissionsChecking(pebOperationPermissionsCheckingAtomReqBO);
            if (!"0000".equals(pebOperationPermissionsCheckingAtomRspBO.getRespCode())) {
                throw new UocProBusinessException("100001", "\u6743\u9650\u6821\u9a8c\u5931\u8d25,\u5931\u8d25\u63cf\u8ff0:" + pebOperationPermissionsCheckingAtomRspBO.getRespDesc());
            }
        }
        UocCoreOrderShipReqBO uocCoreOrderShipReqBO = new UocCoreOrderShipReqBO();
        uocCoreOrderShipReqBO.setSaleVoucherId(reqBO.getSaleVoucherId());
        uocCoreOrderShipReqBO.setOrderId(reqBO.getOrderId());
        uocCoreOrderShipReqBO.setShipStatus("1201");
        uocCoreOrderShipReqBO.setIsStartProcess(true);
        uocCoreOrderShipReqBO.setPackageId(reqBO.getProcessNum());
        uocCoreOrderShipReqBO.setShipName(reqBO.getProcessName());
        uocCoreOrderShipReqBO.setShipPhone(reqBO.getProcessPhone());
        if (StringUtils.isNotBlank((CharSequence)reqBO.getDeliveryTime())) {
            beginDate = DateTime.parse((String)reqBO.getDeliveryTime(), (DateTimeFormatter)DateTimeFormat.forPattern((String)"yyyy-MM-dd"));
            uocCoreOrderShipReqBO.setShipTime(beginDate.toDate());
        } else {
            uocCoreOrderShipReqBO.setShipTime(new Date());
        }
        if (StringUtils.isNotBlank((CharSequence)reqBO.getEstimatedArrivalTime())) {
            beginDate = DateTime.parse((String)reqBO.getEstimatedArrivalTime(), (DateTimeFormatter)DateTimeFormat.forPattern((String)"yyyy-MM-dd"));
            uocCoreOrderShipReqBO.setEstimateArrivalTime(beginDate.toDate());
        }
        uocCoreOrderShipReqBO.setShipId(reqBO.getProcessNum());
        uocCoreOrderShipReqBO.setShipCompanyId(reqBO.getTransportMode());
        uocCoreOrderShipReqBO.setShipCompanyName(reqBO.getLogisticsExecutionUnit());
        if (StringUtils.isNotBlank((CharSequence)reqBO.getShipOrderNo())) {
            uocCoreOrderShipReqBO.setShipVoucherCode(reqBO.getShipOrderNo());
        } else {
            uocCoreOrderShipReqBO.setShipVoucherCode(this.buildNo(uocCoreQryOrderDetailRspBO.getOrdPurchaseRspBO().getPurchaseVoucherNo(), "FHD", "ORDER_SHIP_NO", uocCoreQryOrderDetailRspBO.getOrdSaleRspBO().getOrderSource()));
        }
        if (reqBO.getProcessDate() == null) {
            reqBO.setProcessDate(DateUtils.dateToStrLong((Date)new Date()));
        }
        ArrayList<ShipCruxFieldBO> shipCruxFieldBOList = new ArrayList<ShipCruxFieldBO>();
        ShipCruxFieldBO shipCruxFieldBO = new ShipCruxFieldBO();
        shipCruxFieldBO.setFieldCode("processDate");
        shipCruxFieldBO.setFieldName("\u65bd\u5de5\u3001\u670d\u52a1\u5904\u7406\u65f6\u95f4");
        shipCruxFieldBO.setFieldValue(reqBO.getProcessDate());
        shipCruxFieldBOList.add(shipCruxFieldBO);
        uocCoreOrderShipReqBO.setCruxFieldList(shipCruxFieldBOList);
        if (!CollectionUtils.isEmpty((Collection)pebProcessOrderCountBOList)) {
            ArrayList<UocCoreShipItemReqBO> uocCoreShipItemReqBOList = new ArrayList<UocCoreShipItemReqBO>();
            for (Object pebProcessOrderCountBO : pebProcessOrderCountBOList) {
                if (pebProcessOrderCountBO.getProcessCount().compareTo(BigDecimal.ZERO) == 0) continue;
                UocCoreShipItemReqBO uocCoreShipItemReqBO = new UocCoreShipItemReqBO();
                uocCoreShipItemReqBO.setOrdItemId(pebProcessOrderCountBO.getOrdItemId());
                uocCoreShipItemReqBO.setSendCount(pebProcessOrderCountBO.getProcessCount());
                uocCoreShipItemReqBO.setOrderId(reqBO.getOrderId());
                uocCoreShipItemReqBO.setUnitName(pebProcessOrderCountBO.getUnitName());
                uocCoreShipItemReqBOList.add(uocCoreShipItemReqBO);
            }
            if (CollectionUtils.isEmpty(uocCoreShipItemReqBOList)) {
                throw new UocProBusinessException("102033", "\u4e0d\u80fd\u6240\u6709\u5546\u54c1\u53d1\u8d27\u6570\u91cf\u90fd\u4e3a0");
            }
            uocCoreOrderShipReqBO.setShipItemList(uocCoreShipItemReqBOList);
        }
        uocCoreOrderShipReqBO.setOrderId(reqBO.getOrderId());
        uocCoreOrderShipReqBO.setSaleVoucherId(reqBO.getSaleVoucherId());
        uocCoreOrderShipReqBO.setIsStartProcess(true);
        uocCoreOrderShipReqBO.setProcKey("peb_el_ship_order_order_status");
        UocCoreOrderShipRspBO uocCoreOrderShipRspBO = this.uocCoreOrderShipAtomService.dealCoreOrderShip(uocCoreOrderShipReqBO);
        if (!"0000".equals(uocCoreOrderShipRspBO.getRespCode())) {
            throw new UocProBusinessException("100001", "\u751f\u6210\u53d1\u8d27,\u53d1\u8d27\u660e\u7ec6\u4fe1\u606f\u5931\u8d25,\u5931\u8d25\u63cf\u8ff0:" + uocCoreOrderShipRspBO.getRespDesc());
        }
        pebOrderDeliveryAbilityRspBO.setShipVoucherId(uocCoreOrderShipRspBO.getShipVoucherId());
        boolean isAll = true;
        for (OrdItemRspBO ordItemRspBO : rows) {
            if (ordItemRspBO.getSendCount().compareTo(ordItemRspBO.getPurchaseCount()) >= 0) continue;
            isAll = false;
        }
        OrdSalePO ordSalePo = new OrdSalePO();
        ordSalePo.setOrderId(reqBO.getOrderId());
        ordSalePo = this.ordSaleMapper.getModelBy(ordSalePo);
        Boolean auto = false;
        if (UocConstant.SALE_ORDER_STATUS.ZONE_TO_BE_SHIP.equals(ordSalePo.getSaleState())) {
            UocProcessRunReqBO processRunReqBO = new UocProcessRunReqBO();
            processRunReqBO.setObjType(UocConstant.OBJ_TYPE.SALE);
            processRunReqBO.setObjId(reqBO.getSaleVoucherId());
            processRunReqBO.setOrderId(reqBO.getOrderId());
            processRunReqBO.setOperId(reqBO.getMemIdIn() + "");
            processRunReqBO.setOperId(reqBO.getMemId() + "");
            processRunReqBO.setOperName(reqBO.getUsername());
            HashMap<String, Object> param = new HashMap<String, Object>(1);
            param.put("cancelFlag", 0);
            processRunReqBO.setVariables(param);
            UocProcessRunRspBO start = this.uocRunProcessAtomService.start(processRunReqBO);
            if (!"0000".equals(start.getRespCode())) {
                throw new UocProBusinessException("100001", "\u542f\u52a8\u6d41\u7a0b\u5931\u8d25,\u5931\u8d25\u63cf\u8ff0:" + start.getRespDesc());
            }
            auto = start.getAuto();
        }
        if (!CollectionUtils.isEmpty((Collection)(pebAccessoryReqBOList = reqBO.getPebAccessoryReqBOList()))) {
            for (PebAccessoryReqBO pebAccessoryReqBO : pebAccessoryReqBOList) {
                UocCoreCreateAccessoryReqBO uocCoreCreateAccessoryReqBO = new UocCoreCreateAccessoryReqBO();
                uocCoreCreateAccessoryReqBO.setAccessoryId(pebAccessoryReqBO.getAccessoryId());
                uocCoreCreateAccessoryReqBO.setAccessoryName(pebAccessoryReqBO.getAccessoryName());
                uocCoreCreateAccessoryReqBO.setAccessoryUrl(pebAccessoryReqBO.getAccessoryUrl());
                uocCoreCreateAccessoryReqBO.setAttachmentType(pebAccessoryReqBO.getAttachmentType());
                uocCoreCreateAccessoryReqBO.setOrderId(reqBO.getOrderId());
                uocCoreCreateAccessoryReqBO.setObjectType(UocConstant.OBJ_TYPE.SHIP);
                uocCoreCreateAccessoryReqBO.setObjectId(uocCoreOrderShipRspBO.getShipVoucherId());
                uocCoreCreateAccessoryReqBO.setRemark(reqBO.getActionCode());
                UocCoreCreateAccessoryRspBO accessory = this.uocCoreCreateAccessoryAtomService.createAccessory(uocCoreCreateAccessoryReqBO);
                if ("0000".equals(accessory.getRespCode())) continue;
                throw new UocProBusinessException("100001", "\u751f\u6210\u9644\u4ef6\u4fe1\u606f,\u5931\u8d25\u63cf\u8ff0:" + accessory.getRespDesc());
            }
        }
        pebOrderDeliveryAbilityRspBO.setIsSuccess(Boolean.valueOf(true));
        pebOrderDeliveryAbilityRspBO.setRespCode("0000");
        pebOrderDeliveryAbilityRspBO.setAuto(auto);
        return pebOrderDeliveryAbilityRspBO;
    }

    private void validateArg(PebOrderDeliveryAbilityReqBO reqBO) {
        if (ObjectUtil.isEmpty((Object)reqBO.getOrderId())) {
            throw new UocProBusinessException("102033", "\u5165\u53c2\u5bf9\u8c61\u5c5e\u6027[orderId]\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (ObjectUtil.isEmpty((Object)reqBO.getSaleVoucherId())) {
            throw new UocProBusinessException("102033", "\u5165\u53c2\u5bf9\u8c61\u5c5e\u6027[saleVoucherId]\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (ObjectUtil.isEmpty((Object)reqBO.getPebProcessOrderCountBOList())) {
            throw new UocProBusinessException("102033", "\u5165\u53c2\u5bf9\u8c61\u5c5e\u6027[pebProcessOrderCountBOList]\u4e0d\u80fd\u4e3a\u7a7a");
        }
        for (PebProcessOrderCountBO proBo : reqBO.getPebProcessOrderCountBOList()) {
            if (ObjectUtil.isEmpty((Object)proBo)) {
                throw new UocProBusinessException("102033", "\u5165\u53c2\u5bf9\u8c61\u5c5e\u6027[pebProcessOrderCountBOList]\u4e2d\u5bf9\u8c61\u4e0d\u80fd\u4e3a\u7a7a");
            }
            if (ObjectUtil.isEmpty((Object)proBo.getOrdItemId())) {
                throw new UocProBusinessException("102033", "\u5165\u53c2\u5bf9\u8c61\u5c5e\u6027[pebProcessOrderCountBOList]\u4e2d\u5bf9\u8c61\u5c5e\u6027[ordItemId]\u4e0d\u80fd\u4e3a\u7a7a");
            }
            if (ObjectUtil.isEmpty((Object)proBo.getProcessCount())) {
                throw new UocProBusinessException("102033", "\u5165\u53c2\u5bf9\u8c61\u5c5e\u6027[pebProcessOrderCountBOList]\u4e2d\u5bf9\u8c61\u5c5e\u6027[processCount]\u4e0d\u80fd\u4e3a\u7a7a");
            }
            if (proBo.getProcessCount().compareTo(BigDecimal.ZERO) > 0) continue;
            throw new UocProBusinessException("102033", "\u5165\u53c2\u5bf9\u8c61\u5c5e\u6027[pebProcessOrderCountBOList]\u4e2d\u5bf9\u8c61\u5c5e\u6027[processCount]\u5fc5\u987b\u5927\u4e8e0");
        }
        if (ObjectUtil.isEmpty((Object)reqBO.getProcessName())) {
            throw new UocProBusinessException("102033", "\u5165\u53c2\u5bf9\u8c61\u5c5e\u6027[processName]\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (ObjectUtil.isEmpty((Object)reqBO.getProcessPhone())) {
            throw new UocProBusinessException("102033", "\u5165\u53c2\u5bf9\u8c61\u5c5e\u6027[processPhone]\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (ObjectUtil.isEmpty((Object)reqBO.getProcessNum())) {
            throw new UocProBusinessException("102033", "\u5165\u53c2\u5bf9\u8c61\u5c5e\u6027[processNum]\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (ObjectUtil.isEmpty((Object)reqBO.getDeliveryTime())) {
            throw new UocProBusinessException("102033", "\u5165\u53c2\u5bf9\u8c61\u5c5e\u6027[deliveryTime]\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (ObjectUtil.isEmpty((Object)reqBO.getEstimatedArrivalTime())) {
            throw new UocProBusinessException("102033", "\u5165\u53c2\u5bf9\u8c61\u5c5e\u6027[estimatedArrivalTime]\u4e0d\u80fd\u4e3a\u7a7a");
        }
    }

    private String buildNo(String saleVoucherNo, String start, String voucherNoKey, String orderSource) {
        UocProGetVoucherNoAtomReqBo getBo = new UocProGetVoucherNoAtomReqBo();
        getBo.setVoucherNoKey(voucherNoKey);
        getBo.setOrderSource(orderSource);
        UocProGetVoucherNoAtomRspBo voucherNoRsp = this.uocProGetVoucherNoAtomService.getVoucherNo(getBo);
        if (!"0000".equals(voucherNoRsp.getRespCode())) {
            throw new UocProBusinessException("102033", voucherNoRsp.getRespDesc());
        }
        if (!voucherNoRsp.isVoucherGenerated()) {
            return this.buildNo(saleVoucherNo, start);
        }
        return voucherNoRsp.getVoucherNo();
    }

    private String buildNo(String saleVoucherNo, String start) {
        String date = DateUtils.dateToStr((Date)new Date()).replaceAll("-", "");
        String time = String.valueOf(System.currentTimeMillis());
        return saleVoucherNo + "-" + start + "-" + date + time.substring(time.length() - 3);
    }
}

