/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.uoc.common.busi.impl;

import com.tydic.uac.ability.UacNoTaskAuditCreateAbilityService;
import com.tydic.uac.ability.bo.UacNoTaskAuditCreateInfoReqBO;
import com.tydic.uac.ability.bo.UacNoTaskAuditCreateReqBO;
import com.tydic.uac.ability.bo.UacNoTaskAuditCreateRspBO;
import com.tydic.uac.bo.common.ApprovalObjBO;
import com.tydic.uoc.base.constants.UocConstant;
import com.tydic.uoc.base.exception.UocProBusinessException;
import com.tydic.uoc.base.utils.OrderGenerateIdUtil;
import com.tydic.uoc.common.ability.bo.UocPebAbnormalCreateReqBO;
import com.tydic.uoc.common.ability.bo.UocPebAbnormalCreateRspBO;
import com.tydic.uoc.common.ability.bo.UocPebAbnormalShipBO;
import com.tydic.uoc.common.ability.bo.UocPebImgUrlListBO;
import com.tydic.uoc.common.ability.bo.UocPebShipItemAbilityBO;
import com.tydic.uoc.common.atom.bo.UocProGetVoucherNoAtomReqBo;
import com.tydic.uoc.common.atom.bo.UocProGetVoucherNoAtomRspBo;
import com.tydic.uoc.common.atom.impl.UocProGetVoucherNoAtomService;
import com.tydic.uoc.common.busi.api.UocPebAbnormalCreateBusiService;
import com.tydic.uoc.dao.OrdAbnormalMapper;
import com.tydic.uoc.dao.OrdAccessoryMapper;
import com.tydic.uoc.dao.OrdItemMapper;
import com.tydic.uoc.dao.OrdPurchaseMapper;
import com.tydic.uoc.dao.OrdShipAbnormalItemMapper;
import com.tydic.uoc.dao.OrdShipAbnormalMapper;
import com.tydic.uoc.dao.OrdShipItemMapper;
import com.tydic.uoc.dao.OrdShipMapper;
import com.tydic.uoc.po.OrdAbnormalPO;
import com.tydic.uoc.po.OrdAccessoryPO;
import com.tydic.uoc.po.OrdItemPO;
import com.tydic.uoc.po.OrdPurchasePO;
import com.tydic.uoc.po.OrdShipAbnormalItemPO;
import com.tydic.uoc.po.OrdShipAbnormalPO;
import com.tydic.uoc.po.OrdShipItemPO;
import com.tydic.uoc.po.OrdShipPO;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class UocPebAbnormalCreateBusiServiceImpl
implements UocPebAbnormalCreateBusiService {
    private static final Logger log = LoggerFactory.getLogger(UocPebAbnormalCreateBusiServiceImpl.class);
    private static final String CHANGE_FEE = "changeFee";
    private static final String PUR_CHANGE_FEE_KEY = "purChangeFee";
    private static final String SALE_FEE_KEY = "saleFee";
    private static final String PUR_FEE_KEY = "purFee";
    @Autowired
    private OrdShipMapper ordShipMapper;
    @Autowired
    private OrdShipItemMapper ordShipItemMapper;
    @Autowired
    private OrdItemMapper ordItemMapper;
    @Autowired
    private OrdPurchaseMapper ordPurchaseMapper;
    @Autowired
    private OrdAbnormalMapper ordAbnormalMapper;
    @Autowired
    private OrdShipAbnormalMapper ordShipAbnormalMapper;
    @Autowired
    private OrdShipAbnormalItemMapper ordShipAbnormalItemMapper;
    @Autowired
    private OrdAccessoryMapper ordAccessoryMapper;
    @Autowired
    private OrderGenerateIdUtil orderGenerateIdUtil;
    @Autowired
    private UacNoTaskAuditCreateAbilityService uacNoTaskAuditCreateAbilityService;
    @Autowired
    private UocProGetVoucherNoAtomService uocProGetVoucherNoAtomService;

    @Override
    public UocPebAbnormalCreateRspBO create(UocPebAbnormalCreateReqBO reqBO) {
        this.validationParam(reqBO);
        OrdPurchasePO ordPurchasePo = new OrdPurchasePO();
        ordPurchasePo.setOrderId(((UocPebAbnormalShipBO)reqBO.getAbnormalShipList().get(0)).getOrderId());
        try {
            ordPurchasePo = this.ordPurchaseMapper.getModelBy(ordPurchasePo);
        }
        catch (Exception e) {
            throw new UocProBusinessException("100002", "\u67e5\u8be2\u5bf9\u5e94\u91c7\u8d2d\u5355\u5931\u8d25");
        }
        if (ordPurchasePo == null) {
            throw new UocProBusinessException("100002", "\u6ca1\u6709\u627e\u5230\u8be5\u8ba2\u5355\u5bf9\u5e94\u7684\u91c7\u8d2d\u5355");
        }
        this.isExists(ordPurchasePo.getOrderId());
        if ("1".equals(reqBO.getBusiType())) {
            return this.state(reqBO, ordPurchasePo);
        }
        for (UocPebAbnormalShipBO abBo : reqBO.getAbnormalShipList()) {
            OrdShipPO ordShipPo = new OrdShipPO();
            ordShipPo.setOrderId(abBo.getOrderId());
            ordShipPo.setShipVoucherId(abBo.getShipVoucherId());
            ordShipPo = this.ordShipMapper.getModelBy(ordShipPo);
            if (ordShipPo == null) {
                throw new UocProBusinessException("100002", "\u8be5\u53d1\u8d27\u5355(" + abBo.getShipVoucherId() + ")\u4e0d\u5b58\u5728");
            }
            if (null != ordShipPo.getIsAbnormal() && 1 == ordShipPo.getIsAbnormal()) {
                throw new UocProBusinessException("100002", "\u8be5\u53d1\u8d27\u5355(" + abBo.getShipVoucherId() + ")\u5df2\u7ecf\u8d85\u65f6\uff0c\u4e0d\u80fd\u505a\u6570\u91cf\u53d8\u66f4");
            }
            if ("2205".equals(ordShipPo.getShipStatus()) || "1204".equals(ordShipPo.getShipStatus())) continue;
            throw new UocProBusinessException("100002", "\u8be5\u53d1\u8d27\u5355(" + abBo.getShipVoucherId() + ")\u8fd8\u672a\u9a8c\u6536\uff0c\u4e0d\u80fd\u505a\u6570\u91cf\u53d8\u66f4");
        }
        return this.num(reqBO, ordPurchasePo);
    }

    private UocPebAbnormalCreateRspBO state(UocPebAbnormalCreateReqBO reqBO, OrdPurchasePO ordPurchasePO) {
        UocPebAbnormalCreateRspBO rspBO = new UocPebAbnormalCreateRspBO();
        Long abnormalVoucherId = this.orderGenerateIdUtil.nextId();
        rspBO.setAbnormalId(abnormalVoucherId);
        ArrayList<OrdShipAbnormalPO> shipAbnormalPOS = new ArrayList<OrdShipAbnormalPO>();
        ArrayList<OrdShipAbnormalItemPO> saveItemPOS = new ArrayList<OrdShipAbnormalItemPO>();
        Long fee = 0L;
        Long purFee = 0L;
        boolean isNotSave = true;
        boolean notHaveItem = true;
        for (UocPebAbnormalShipBO shipBO : reqBO.getAbnormalShipList()) {
            boolean flag;
            List shipItemPOS;
            if (CollectionUtils.isEmpty((Collection)shipBO.getShipItemList())) continue;
            ArrayList<OrdShipAbnormalItemPO> itemPOS = new ArrayList<OrdShipAbnormalItemPO>();
            Long abnormalShipId = this.orderGenerateIdUtil.nextId();
            OrdShipPO ordShipPO = new OrdShipPO();
            ordShipPO.setOrderId(shipBO.getOrderId());
            ordShipPO.setShipVoucherId(shipBO.getShipVoucherId());
            try {
                ordShipPO = this.ordShipMapper.getModelBy(ordShipPO);
            }
            catch (Exception e) {
                throw new UocProBusinessException("100002", "\u7535\u5b50\u8d85\u5e02\u5f02\u5e38\u5355\u5904\u7406\u7533\u8bf7\u67e5\u8be2\u53d1\u8d27\u5355\u5931\u8d25");
            }
            if (Integer.valueOf(1).equals(ordShipPO.getIsAbnormal())) {
                throw new UocProBusinessException("100002", "\u8be5\u53d1\u8d27\u5355(" + ordShipPO.getShipVoucherId() + ")\u5df2\u7ecf\u8d85\u65f6\uff0c\u4e0d\u80fd\u505a\u6570\u91cf\u53d8\u66f4");
            }
            if (null == rspBO.getSaleVoucherId()) {
                rspBO.setSaleVoucherId(ordShipPO.getSaleVoucherId());
            }
            OrdShipItemPO ordShipItemPO = new OrdShipItemPO();
            ordShipItemPO.setOrderId(shipBO.getOrderId());
            ordShipItemPO.setShipVoucherId(shipBO.getShipVoucherId());
            try {
                shipItemPOS = this.ordShipItemMapper.getList(ordShipItemPO);
            }
            catch (Exception e) {
                throw new UocProBusinessException("100002", "\u7535\u5b50\u8d85\u5e02\u5f02\u5e38\u5355\u5904\u7406\u7533\u8bf7\u67e5\u8be2\u53d1\u8d27\u5355\u660e\u7ec6\u5931\u8d25");
            }
            BigDecimal returnCount = new BigDecimal(0);
            Long shipFee = 0L;
            Long purShipFee = 0L;
            if (ordShipPO.getShipStatus().equals("1205") && shipBO.getNewShipState().equals("1203")) {
                flag = false;
                isNotSave = false;
            } else if (ordShipPO.getShipStatus().equals("1203") && shipBO.getNewShipState().equals("1205")) {
                flag = true;
                isNotSave = false;
            } else {
                Object str;
                if (shipBO.getNewShipState().equals("1203")) {
                    str = "\u5f53\u524d\u53d1\u8d27\u5355\u72b6\u6001\u4e0d\u80fd\u53d8\u66f4\u4e3a\u59a5\u6295";
                } else {
                    if (!shipBO.getNewShipState().equals("1205")) continue;
                    str = "\u5f53\u524d\u53d1\u8d27\u5355\u72b6\u6001\u4e0d\u80fd\u53d8\u66f4\u4e3a\u62d2\u6536";
                }
                throw new UocProBusinessException("100002", (String)str);
            }
            for (UocPebShipItemAbilityBO uocPebShipItemBO : shipBO.getShipItemList()) {
                for (OrdShipItemPO shipItemPO : shipItemPOS) {
                    if (!Long.valueOf(uocPebShipItemBO.getShipItemId()).equals(shipItemPO.getShipItemId())) continue;
                    if (shipItemPO.getReturnCount() != null && shipItemPO.getReturnCount().compareTo(new BigDecimal(0)) > 0) {
                        returnCount = returnCount.add(shipItemPO.getReturnCount());
                        itemPOS = new ArrayList();
                        break;
                    }
                    notHaveItem = false;
                    OrdItemPO ordItemPO = new OrdItemPO();
                    ordItemPO.setOrdItemId(shipItemPO.getOrdItemId());
                    ordItemPO.setOrderId(shipBO.getOrderId());
                    try {
                        ordItemPO = this.ordItemMapper.getModelBy(ordItemPO);
                    }
                    catch (Exception e) {
                        throw new UocProBusinessException("100002", "\u7535\u5b50\u8d85\u5e02\u5f02\u5e38\u5355\u5904\u7406\u7533\u8bf7\u67e5\u8be2\u9500\u552e\u5355\u660e\u7ec6\u5931\u8d25");
                    }
                    if (StringUtils.isBlank((CharSequence)uocPebShipItemBO.getNewReturnCount())) {
                        uocPebShipItemBO.setNewReturnCount("0");
                    }
                    ArrayList<Long> list = new ArrayList<Long>();
                    shipFee = shipFee + this.stateItemPOS(abnormalShipId, abnormalVoucherId, shipBO.getOrderId(), shipItemPO, ordItemPO, itemPOS, new BigDecimal(uocPebShipItemBO.getNewReturnCount()), flag, list);
                    purShipFee = purShipFee + (Long)list.get(0);
                }
                if (returnCount.compareTo(new BigDecimal(0)) <= 0) continue;
                break;
            }
            if (returnCount.compareTo(new BigDecimal(0)) > 0) continue;
            ArrayList<Long> list = new ArrayList<Long>();
            shipFee = this.stateShipAbnormalPOS(abnormalShipId, abnormalVoucherId, shipBO.getOrderId(), ordShipPO, ordPurchasePO, shipFee, shipAbnormalPOS, flag, shipBO.getNewShipState(), purShipFee, list);
            saveItemPOS.addAll(itemPOS);
            fee = fee + shipFee;
            purFee = purFee + (Long)list.get(0);
        }
        if (isNotSave) {
            rspBO.setRespCode("102009");
            rspBO.setRespDesc("\u63d0\u4ea4\u5931\u8d25\uff0c\u6ca1\u6709\u53d1\u73b0\u53d8\u66f4\u5185\u5bb9\uff0c\u8bf7\u68c0\u67e5\uff01");
            return rspBO;
        }
        if (notHaveItem) {
            rspBO.setRespCode("102009");
            rspBO.setRespDesc("\u63d0\u4ea4\u8ba2\u5355\u5f02\u5e38\uff0c\u53d1\u8d27\u660e\u7ec6\u5b58\u5728\u5df2\u53d1\u751f\u7684\u552e\u540e\uff0c\u4e0d\u5141\u8bb8\u8fdb\u884c\u72b6\u6001\u53d8\u66f4");
            return rspBO;
        }
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("\u5f02\u5e38\u5355\u5904\u7406\u7533\u8bf7\u6210\u529f");
        if (CollectionUtils.isEmpty(saveItemPOS)) {
            throw new UocProBusinessException("102009", "\u6ca1\u6709\u4efb\u4f55\u53d1\u8d27\u5355\u80fd\u591f\u7533\u8bf7\u5f02\u5e38\u53d8\u66f4");
        }
        OrdAbnormalPO ordAbnormalPO = this.save(ordPurchasePO, abnormalVoucherId, reqBO, fee, shipAbnormalPOS, saveItemPOS, purFee);
        this.audit(abnormalVoucherId, reqBO, ordPurchasePO.getOrderId(), ordAbnormalPO);
        return rspBO;
    }

    private UocPebAbnormalCreateRspBO num(UocPebAbnormalCreateReqBO reqBO, OrdPurchasePO ordPurchasePO) {
        UocPebAbnormalCreateRspBO rspBO = new UocPebAbnormalCreateRspBO();
        Long abnormalVoucherId = this.orderGenerateIdUtil.nextId();
        rspBO.setAbnormalId(abnormalVoucherId);
        ArrayList<OrdShipAbnormalPO> shipAbnormalPOS = new ArrayList<OrdShipAbnormalPO>();
        ArrayList<OrdShipAbnormalItemPO> saveItemPOS = new ArrayList<OrdShipAbnormalItemPO>();
        Long fee = 0L;
        Long purFee = 0L;
        boolean isNotSave = true;
        boolean notHaveItem = true;
        for (UocPebAbnormalShipBO shipBO : reqBO.getAbnormalShipList()) {
            List shipItemPOS;
            if (CollectionUtils.isEmpty((Collection)shipBO.getShipItemList())) continue;
            isNotSave = false;
            ArrayList<OrdShipAbnormalItemPO> itemPOS = new ArrayList<OrdShipAbnormalItemPO>();
            Long abnormalShipId = this.orderGenerateIdUtil.nextId();
            OrdShipPO ordShipPO = new OrdShipPO();
            ordShipPO.setOrderId(shipBO.getOrderId());
            ordShipPO.setShipVoucherId(shipBO.getShipVoucherId());
            try {
                ordShipPO = this.ordShipMapper.getModelBy(ordShipPO);
            }
            catch (Exception e) {
                throw new UocProBusinessException("100002", "\u7535\u5b50\u8d85\u5e02\u5f02\u5e38\u5355\u5904\u7406\u7533\u8bf7\u67e5\u8be2\u53d1\u8d27\u5355\u5931\u8d25");
            }
            OrdShipItemPO ordShipItemPO = new OrdShipItemPO();
            ordShipItemPO.setOrderId(shipBO.getOrderId());
            ordShipItemPO.setShipVoucherId(shipBO.getShipVoucherId());
            try {
                shipItemPOS = this.ordShipItemMapper.getList(ordShipItemPO);
            }
            catch (Exception e) {
                throw new UocProBusinessException("100002", "\u7535\u5b50\u8d85\u5e02\u5f02\u5e38\u5355\u5904\u7406\u7533\u8bf7\u67e5\u8be2\u53d1\u8d27\u5355\u660e\u7ec6\u5931\u8d25");
            }
            BigDecimal returnCount = new BigDecimal(0);
            Long shipFee = 0L;
            Long purShipFee = 0L;
            Long shipChangeFee = 0L;
            Long purShipChangeFee = 0L;
            if (!ordShipPO.getShipStatus().equals("1203") && !ordShipPO.getShipStatus().equals("1204") && !ordShipPO.getShipStatus().equals("2205")) continue;
            for (UocPebShipItemAbilityBO uocPebShipItemBO : shipBO.getShipItemList()) {
                if (uocPebShipItemBO.getNewReturnCount() == null || "0".equals(uocPebShipItemBO.getNewReturnCount())) continue;
                notHaveItem = false;
                returnCount = returnCount.add(new BigDecimal(uocPebShipItemBO.getNewReturnCount()).abs());
                for (OrdShipItemPO shipItemPO : shipItemPOS) {
                    if (!Long.valueOf(uocPebShipItemBO.getShipItemId()).equals(shipItemPO.getShipItemId())) continue;
                    OrdItemPO ordItemPO = new OrdItemPO();
                    ordItemPO.setOrdItemId(shipItemPO.getOrdItemId());
                    ordItemPO.setOrderId(shipBO.getOrderId());
                    try {
                        ordItemPO = this.ordItemMapper.getModelBy(ordItemPO);
                    }
                    catch (Exception e) {
                        throw new UocProBusinessException("100002", "\u7535\u5b50\u8d85\u5e02\u5f02\u5e38\u5355\u5904\u7406\u7533\u8bf7\u67e5\u8be2\u9500\u552e\u5355\u660e\u7ec6\u5931\u8d25");
                    }
                    BigDecimal oldCount = shipItemPO.getSendCount().subtract(shipItemPO.getReturnCount());
                    BigDecimal newReturnCount = new BigDecimal(uocPebShipItemBO.getNewReturnCount());
                    if (oldCount.compareTo(new BigDecimal(0)) <= 0 && !uocPebShipItemBO.getNewReturnCount().contains("-")) {
                        returnCount = returnCount.subtract(newReturnCount.abs());
                        continue;
                    }
                    BigDecimal cha = oldCount.subtract(newReturnCount);
                    if (cha.compareTo(new BigDecimal(0)) < 0) {
                        throw new UocProBusinessException("102009", "\u7533\u8bf7\u589e\u52a0\u552e\u540e\u6570\u91cf\u5927\u4e8e\u5269\u4f59\u5230\u8d27\u6570\u91cf");
                    }
                    if (cha.compareTo(shipItemPO.getSendCount()) > 0) {
                        throw new UocProBusinessException("102009", "\u7533\u8bf7\u51cf\u5c11\u552e\u540e\u6570\u91cf\u51cf\u5c11\u6570\u91cf\u5927\u4e8e\u73b0\u6709\u552e\u540e\u6570\u91cf");
                    }
                    Map<String, Long> map = this.numItemPos(abnormalShipId, abnormalVoucherId, shipBO.getOrderId(), shipItemPO, ordItemPO, itemPOS, newReturnCount, oldCount);
                    shipFee = shipFee + map.get(SALE_FEE_KEY);
                    purShipFee = purShipFee + map.get(PUR_FEE_KEY);
                    shipChangeFee = shipChangeFee + map.get(CHANGE_FEE);
                    purShipChangeFee = purShipChangeFee + map.get(PUR_CHANGE_FEE_KEY);
                }
            }
            if (returnCount.compareTo(new BigDecimal(0)) == 0) continue;
            this.numShipAbnormalPOS(abnormalShipId, abnormalVoucherId, shipBO.getOrderId(), ordShipPO, ordPurchasePO, shipFee, shipAbnormalPOS, shipBO.getNewShipState(), shipChangeFee, purShipFee, purShipChangeFee);
            saveItemPOS.addAll(itemPOS);
            fee = fee + shipChangeFee;
            purFee = purFee + purShipChangeFee;
        }
        if (isNotSave) {
            rspBO.setRespCode("102009");
            rspBO.setRespDesc("\u63d0\u4ea4\u5931\u8d25\uff0c\u6ca1\u6709\u53d1\u73b0\u53d8\u66f4\u5185\u5bb9\uff0c\u8bf7\u68c0\u67e5\uff01");
            return rspBO;
        }
        if (notHaveItem) {
            rspBO.setRespCode("102009");
            rspBO.setRespDesc("\u63d0\u4ea4\u5931\u8d25\uff0c\u6ca1\u6709\u53d1\u73b0\u53d8\u66f4\u5185\u5bb9\uff0c\u8bf7\u68c0\u67e5\uff01");
            return rspBO;
        }
        if (CollectionUtils.isEmpty(saveItemPOS)) {
            throw new UocProBusinessException("102009", "\u6ca1\u6709\u4efb\u4f55\u53d1\u8d27\u5355\u80fd\u591f\u7533\u8bf7\u5f02\u5e38\u53d8\u66f4");
        }
        OrdAbnormalPO ordAbnormalPO = this.save(ordPurchasePO, abnormalVoucherId, reqBO, fee, shipAbnormalPOS, saveItemPOS, purFee);
        this.audit(abnormalVoucherId, reqBO, ordPurchasePO.getOrderId(), ordAbnormalPO);
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("\u5f02\u5e38\u5355\u5904\u7406\u7533\u8bf7\u6210\u529f");
        return rspBO;
    }

    private String getNo(Long abnormalVoucherId, String voucherNoKey, String orderSource) {
        UocProGetVoucherNoAtomReqBo getBo = new UocProGetVoucherNoAtomReqBo();
        getBo.setVoucherNoKey(voucherNoKey);
        getBo.setOrderSource(orderSource);
        UocProGetVoucherNoAtomRspBo voucherNoRsp = this.uocProGetVoucherNoAtomService.getVoucherNo(getBo);
        if (!"0000".equals(voucherNoRsp.getRespCode())) {
            throw new UocProBusinessException("102009", voucherNoRsp.getRespDesc());
        }
        if (!voucherNoRsp.isVoucherGenerated()) {
            return abnormalVoucherId.toString();
        }
        return voucherNoRsp.getVoucherNo();
    }

    private OrdAbnormalPO save(OrdPurchasePO ordPurchasePO, Long abnormalVoucherId, UocPebAbnormalCreateReqBO reqBO, Long fee, List<OrdShipAbnormalPO> shipAbnormalPOS, List<OrdShipAbnormalItemPO> saveItemPOS, Long purFee) {
        OrdAbnormalPO ordAbnormalPO = new OrdAbnormalPO();
        ordAbnormalPO.setOrderId(ordPurchasePO.getOrderId());
        ordAbnormalPO.setAbnormalVoucherId(abnormalVoucherId);
        ordAbnormalPO.setAbnormalState(UocConstant.ABNORMAL_STATE.AUDIT);
        ordAbnormalPO.setAbnormalVoucherNo(this.getNo(abnormalVoucherId, "ORDER_ABNORMAL_NO", ordPurchasePO.getOrderSource()));
        ordAbnormalPO.setBusiType(Integer.valueOf(Integer.parseInt(reqBO.getBusiType())));
        ordAbnormalPO.setMobile(reqBO.getMobile());
        ordAbnormalPO.setRemark(reqBO.getRemark());
        ordAbnormalPO.setCreateTime(new Date());
        ordAbnormalPO.setCreateOperId(String.valueOf(reqBO.getUserId()));
        ordAbnormalPO.setCreateOperName(reqBO.getUsername());
        ordAbnormalPO.setChangeFee(fee);
        ordAbnormalPO.setPurchaseChangeFee(purFee);
        try {
            this.ordAbnormalMapper.insert(ordAbnormalPO);
        }
        catch (Exception e) {
            throw new UocProBusinessException("100002", "\u4fdd\u5b58\u5f02\u5e38\u5355\u5931\u8d25");
        }
        try {
            this.ordShipAbnormalMapper.insertBatch(shipAbnormalPOS);
        }
        catch (Exception e) {
            throw new UocProBusinessException("100002", "\u4fdd\u5b58\u5f02\u5e38\u53d1\u8d27\u5931\u8d25");
        }
        try {
            this.ordShipAbnormalItemMapper.insertBatch(saveItemPOS);
        }
        catch (Exception e) {
            throw new UocProBusinessException("100002", "\u4fdd\u5b58\u5f02\u5e38\u53d1\u8d27\u8be6\u60c5\u5931\u8d25");
        }
        this.file(reqBO, ordPurchasePO.getOrderId(), abnormalVoucherId);
        return ordAbnormalPO;
    }

    private void file(UocPebAbnormalCreateReqBO reqBO, Long orderId, Long abnormalVoucherId) {
        if (CollectionUtils.isEmpty((Collection)reqBO.getImgUrlList())) {
            return;
        }
        ArrayList<OrdAccessoryPO> list = new ArrayList<OrdAccessoryPO>(reqBO.getImgUrlList().size());
        for (UocPebImgUrlListBO urlListBO : reqBO.getImgUrlList()) {
            OrdAccessoryPO ordAccessoryPO = new OrdAccessoryPO();
            ordAccessoryPO.setId(Long.valueOf(this.orderGenerateIdUtil.nextId()));
            ordAccessoryPO.setCreateTime(new Date());
            ordAccessoryPO.setOrderId(orderId);
            ordAccessoryPO.setAttachmentType(UocConstant.UOC_ATTACHMENT_TYPE.TYPE_AFTER_ORTHER);
            ordAccessoryPO.setObjectType(UocConstant.OBJ_TYPE.ABNORMAL);
            ordAccessoryPO.setAccessoryName(urlListBO.getAccessoryName());
            ordAccessoryPO.setAccessoryUrl(urlListBO.getAccessoryUrl());
            ordAccessoryPO.setAccessoryId(urlListBO.getAccessoryId());
            ordAccessoryPO.setCreateOperId(String.valueOf(reqBO.getUserId()));
            ordAccessoryPO.setObjectId(abnormalVoucherId);
            list.add(ordAccessoryPO);
        }
        try {
            this.ordAccessoryMapper.insertBatch(list);
        }
        catch (Exception e) {
            throw new UocProBusinessException("100002", "\u4fdd\u5b58\u5f02\u5e38\u9644\u4ef6\u5931\u8d25");
        }
    }

    private Long stateShipAbnormalPOS(Long abnormalShipId, Long abnormalVoucherId, Long orderId, OrdShipPO ordShipPO, OrdPurchasePO ordPurchasePO, Long fee, List<OrdShipAbnormalPO> shipAbnormalPOS, boolean flag, String newsState, Long purFee, List<Long> pur) {
        OrdShipAbnormalPO ordShipAbnormalPO = this.shipAbnormalPO(abnormalShipId, abnormalVoucherId, orderId, ordShipPO, ordPurchasePO, newsState);
        if (flag) {
            ordShipAbnormalPO.setSaleFee(fee);
            ordShipAbnormalPO.setPurchaseFee(purFee);
            ordShipAbnormalPO.setChangeFee(fee);
            ordShipAbnormalPO.setPurchaseChangeFee(purFee);
            pur.add(purFee);
        } else {
            ordShipAbnormalPO.setSaleFee(fee);
            ordShipAbnormalPO.setPurchaseFee(purFee);
            ordShipAbnormalPO.setChangeFee(Long.valueOf(-fee.longValue()));
            ordShipAbnormalPO.setPurchaseChangeFee(Long.valueOf(-purFee.longValue()));
            ordShipAbnormalPO.setChangeFee(Long.valueOf(-fee.longValue()));
            fee = -fee.longValue();
            pur.add(-purFee.longValue());
        }
        shipAbnormalPOS.add(ordShipAbnormalPO);
        return fee;
    }

    private void numShipAbnormalPOS(Long abnormalShipId, Long abnormalVoucherId, Long orderId, OrdShipPO ordShipPO, OrdPurchasePO ordPurchasePO, Long fee, List<OrdShipAbnormalPO> shipAbnormalPOS, String newsState, Long shipChangeFee, Long purFee, Long purChangeFee) {
        OrdShipAbnormalPO ordShipAbnormalPO = this.shipAbnormalPO(abnormalShipId, abnormalVoucherId, orderId, ordShipPO, ordPurchasePO, newsState);
        ordShipAbnormalPO.setSaleFee(fee);
        ordShipAbnormalPO.setPurchaseFee(purFee);
        ordShipAbnormalPO.setChangeFee(shipChangeFee);
        ordShipAbnormalPO.setPurchaseChangeFee(purChangeFee);
        shipAbnormalPOS.add(ordShipAbnormalPO);
    }

    private OrdShipAbnormalPO shipAbnormalPO(Long abnormalShipId, Long abnormalVoucherId, Long orderId, OrdShipPO ordShipPO, OrdPurchasePO ordPurchasePO, String newsState) {
        OrdShipAbnormalPO ordShipAbnormalPO = new OrdShipAbnormalPO();
        ordShipAbnormalPO.setAbnormalShipId(abnormalShipId);
        ordShipAbnormalPO.setOrderId(orderId);
        ordShipAbnormalPO.setAbnormalVoucherId(abnormalVoucherId);
        ordShipAbnormalPO.setShipVoucherId(ordShipPO.getShipVoucherId());
        ordShipAbnormalPO.setSaleVoucherId(ordPurchasePO.getSaleVoucherId());
        ordShipAbnormalPO.setPurchaseVoucherId(ordPurchasePO.getPurchaseVoucherId());
        ordShipAbnormalPO.setNewShipState(newsState);
        ordShipAbnormalPO.setOldShipState(ordShipPO.getShipStatus());
        ordShipAbnormalPO.setCreateTime(new Date());
        return ordShipAbnormalPO;
    }

    private Long stateItemPOS(Long abnormalShipId, Long abnormalVoucherId, Long orderId, OrdShipItemPO shipItemPO, OrdItemPO ordItemPO, List<OrdShipAbnormalItemPO> itemPOS, BigDecimal newReturnCount, boolean flag, List<Long> list) {
        OrdShipAbnormalItemPO ordShipAbnormalItemPO = this.itemPO(abnormalShipId, abnormalVoucherId, orderId, shipItemPO);
        newReturnCount = flag ? shipItemPO.getSendCount() : shipItemPO.getRefuseCount();
        ordShipAbnormalItemPO.setChangeCount(newReturnCount);
        Long saleFee = new BigDecimal(ordItemPO.getSalePrice()).multiply(newReturnCount).longValue();
        Long purFee = new BigDecimal(ordItemPO.getPurchasePrice()).multiply(newReturnCount).longValue();
        ordShipAbnormalItemPO.setPurchaseFee(purFee);
        list.add(purFee);
        if (flag) {
            ordShipAbnormalItemPO.setSaleFee(saleFee);
            ordShipAbnormalItemPO.setChangeFee(saleFee);
        } else {
            ordShipAbnormalItemPO.setSaleFee(saleFee);
            ordShipAbnormalItemPO.setChangeFee(Long.valueOf(-saleFee.longValue()));
        }
        itemPOS.add(ordShipAbnormalItemPO);
        return saleFee;
    }

    private Map<String, Long> numItemPos(Long abnormalShipId, Long abnormalVoucherId, Long orderId, OrdShipItemPO shipItemPo, OrdItemPO ordItemPo, List<OrdShipAbnormalItemPO> itemPoS, BigDecimal newReturnCount, BigDecimal oldCount) {
        OrdShipAbnormalItemPO ordShipAbnormalItemPo = this.itemPO(abnormalShipId, abnormalVoucherId, orderId, shipItemPo);
        ordShipAbnormalItemPo.setChangeCount(newReturnCount);
        Long saleFee = shipItemPo.getSendCount().multiply(new BigDecimal(ordItemPo.getSalePrice())).longValue();
        Long purFee = shipItemPo.getSendCount().multiply(new BigDecimal(ordItemPo.getPurchasePrice())).longValue();
        Long changeFee = new BigDecimal(ordItemPo.getSalePrice()).multiply(newReturnCount).longValue();
        Long purChangeFee = new BigDecimal(ordItemPo.getPurchasePrice()).multiply(newReturnCount).longValue();
        ordShipAbnormalItemPo.setSaleFee(saleFee);
        ordShipAbnormalItemPo.setPurchaseFee(purFee);
        ordShipAbnormalItemPo.setChangeFee(changeFee);
        ordShipAbnormalItemPo.setPurchaseChangeFee(purChangeFee);
        itemPoS.add(ordShipAbnormalItemPo);
        HashMap<String, Long> map = new HashMap<String, Long>();
        map.put(CHANGE_FEE, changeFee);
        map.put(PUR_CHANGE_FEE_KEY, purChangeFee);
        map.put(SALE_FEE_KEY, saleFee);
        map.put(PUR_FEE_KEY, purFee);
        return map;
    }

    private OrdShipAbnormalItemPO itemPO(Long abnormalShipId, Long abnormalVoucherId, Long orderId, OrdShipItemPO shipItemPO) {
        OrdShipAbnormalItemPO ordShipAbnormalItemPO = new OrdShipAbnormalItemPO();
        ordShipAbnormalItemPO.setAbnormalShipId(abnormalShipId);
        ordShipAbnormalItemPO.setAbnormalVoucherId(abnormalVoucherId);
        ordShipAbnormalItemPO.setOrderId(orderId);
        ordShipAbnormalItemPO.setShipItemId(shipItemPO.getShipItemId());
        ordShipAbnormalItemPO.setAbnormalShipItemId(Long.valueOf(this.orderGenerateIdUtil.nextId()));
        return ordShipAbnormalItemPO;
    }

    private void audit(Long id, UocPebAbnormalCreateReqBO reqBO, Long orderId, OrdAbnormalPO ordAbnormalPO) {
        UacNoTaskAuditCreateReqBO noTaskAuditCreateReqBO = new UacNoTaskAuditCreateReqBO();
        noTaskAuditCreateReqBO.setProcDefKey("AbnormalOrderExcessApproval");
        noTaskAuditCreateReqBO.setIsSaveCreateLog(Boolean.valueOf(true));
        noTaskAuditCreateReqBO.setCreateOperId(String.valueOf(reqBO.getUserId()));
        noTaskAuditCreateReqBO.setCreateOperName(reqBO.getUsername());
        UacNoTaskAuditCreateInfoReqBO infoReqBO = new UacNoTaskAuditCreateInfoReqBO();
        infoReqBO.setUsername(reqBO.getUsername());
        infoReqBO.setCreateOperId(String.valueOf(reqBO.getUserId()));
        infoReqBO.setRemark("\u5f02\u5e38\u8ba2\u5355\u9700\u8981\u5ba1\u6279");
        infoReqBO.setOrderId(orderId);
        infoReqBO.setObjType(UocConstant.OBJ_TYPE.ABNORMAL);
        infoReqBO.setObjNum("1");
        ApprovalObjBO approvalObjBO = new ApprovalObjBO();
        approvalObjBO.setObjType(UocConstant.OBJ_TYPE.ABNORMAL);
        approvalObjBO.setObjId(String.valueOf(id));
        ArrayList<ApprovalObjBO> objBOS = new ArrayList<ApprovalObjBO>(1);
        objBOS.add(approvalObjBO);
        infoReqBO.setApprovalObjInfo(objBOS);
        ArrayList<UacNoTaskAuditCreateInfoReqBO> infoReqBOS = new ArrayList<UacNoTaskAuditCreateInfoReqBO>(1);
        infoReqBOS.add(infoReqBO);
        noTaskAuditCreateReqBO.setCreateBusiReqBO(infoReqBOS);
        UacNoTaskAuditCreateRspBO uacNoTaskAuditCreateRspBO = this.uacNoTaskAuditCreateAbilityService.auditOrderCreate(noTaskAuditCreateReqBO);
        if (!"0000".equals(uacNoTaskAuditCreateRspBO.getRespCode())) {
            throw new UocProBusinessException("102009", "\u8c03\u7528\u5ba1\u6279\u521b\u5efa\u5931\u8d25" + uacNoTaskAuditCreateRspBO.getRespDesc());
        }
        ordAbnormalPO.setStepId(uacNoTaskAuditCreateRspBO.getStepId());
        this.ordAbnormalMapper.updateById(ordAbnormalPO);
    }

    private void validationParam(UocPebAbnormalCreateReqBO reqBO) {
        if (null == reqBO) {
            throw new UocProBusinessException("100002", "\u7535\u5b50\u8d85\u5e02\u5f02\u5e38\u5355\u5904\u7406\u7533\u8bf7\uff08reqBO\uff09\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        List abnormalShipList = reqBO.getAbnormalShipList();
        if (CollectionUtils.isEmpty((Collection)abnormalShipList)) {
            throw new UocProBusinessException("100002", "\u7535\u5b50\u8d85\u5e02\u5f02\u5e38\u5355\u5904\u7406\u7533\u8bf7\u53d1\u8d27\u5355\u6d88\u606f\uff08abnormalShipList\uff09\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        if (null == reqBO.getBusiType()) {
            throw new UocProBusinessException("100002", "\u7535\u5b50\u8d85\u5e02\u5f02\u5e38\u5355\u5904\u7406\u53d8\u66f4\u7c7b\u578b\uff08busiType\uff09\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        if (!"1".equals(reqBO.getBusiType()) && !"2".equals(reqBO.getBusiType())) {
            throw new UocProBusinessException("100002", "\u7535\u5b50\u8d85\u5e02\u5f02\u5e38\u5355\u5904\u7406\u53d8\u66f4\u7c7b\u578b\u9519\u8bef\uff01");
        }
    }

    private void isExists(Long orderId) {
        OrdAbnormalPO abnormalPO = new OrdAbnormalPO();
        abnormalPO.setOrderId(orderId);
        abnormalPO.setAbnormalState(UocConstant.ABNORMAL_STATE.AUDIT);
        List list = this.ordAbnormalMapper.getList(abnormalPO);
        if (CollectionUtils.isNotEmpty((Collection)list)) {
            throw new UocProBusinessException("100002", "\u540c\u4e00\u8ba2\u5355\u5b58\u5728\u672a\u5b8c\u6210\u7684\u53d8\u66f4\u8bb0\u5f55\u65f6\uff0c\u4e0d\u5141\u8bb8\u518d\u6b21\u53d1\u8d77\u53d8\u66f4");
        }
    }
}

