/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.uoc.common.comb.impl;

import com.alibaba.fastjson.JSON;
import com.ohaotian.plugin.mq.proxy.ProxyMessage;
import com.ohaotian.plugin.mq.proxy.ProxyMessageProducer;
import com.tydic.uoc.base.constants.UocConstant;
import com.tydic.uoc.base.constants.UocCoreConstant;
import com.tydic.uoc.base.exception.UocProBusinessException;
import com.tydic.uoc.base.utils.OrderPropertiesUtil;
import com.tydic.uoc.common.ability.bo.UocPebExtRetailerNoticeShipReqBO;
import com.tydic.uoc.common.ability.bo.UocPebExtRetailerNoticeShipRspBO;
import com.tydic.uoc.common.ability.bo.UocPebOrdIdxSyncReqBO;
import com.tydic.uoc.common.ability.bo.UocPebShipArrivalConfirmReqBO;
import com.tydic.uoc.common.ability.bo.UocPebShipArrivalConfirmRspBO;
import com.tydic.uoc.common.busi.api.UocPebExtRetailerNoticeShipBusiService;
import com.tydic.uoc.common.busi.api.UocPebShipArrivalConfirmBusiService;
import com.tydic.uoc.common.comb.api.UocPebShipArrivalConfirmCombService;
import com.tydic.uoc.dao.OrdQueryIndexMapper;
import com.tydic.uoc.dao.OrdShipMapper;
import com.tydic.uoc.po.OrdQueryIndexPO;
import com.tydic.uoc.po.OrdShipPO;
import java.util.Collection;
import java.util.List;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

@Service(value="uocPebShipArrivalConfirmCombService")
public class UocPebShipArrivalConfirmCombServiceImpl
implements UocPebShipArrivalConfirmCombService {
    @Autowired
    private UocPebExtRetailerNoticeShipBusiService extRetailerNoticeShipBusiService;
    @Autowired
    private UocPebShipArrivalConfirmBusiService uocPebShipArrivalConfirmBusiService;
    @Value(value="${UOC_PEB_ORDER_SYNC_TOPIC}")
    private String orderSyncTopic;
    @Value(value="${UOC_PEB_ORDER_SYNC_TAG}")
    private String orderSyncTag;
    @Resource(name="uocPebSyncOrderListMqServiceProvider")
    private ProxyMessageProducer uocPebSyncOrderListMqServiceProvider;
    @Autowired
    private OrdQueryIndexMapper ordQueryIndexMapper;
    @Autowired
    private OrdShipMapper ordShipMapper;

    @Override
    public UocPebShipArrivalConfirmRspBO dealShipArrivalConfirm(UocPebShipArrivalConfirmReqBO reqBO) {
        this.validateParam(reqBO);
        this.crateInvoice(reqBO);
        UocPebShipArrivalConfirmRspBO rspBO = new UocPebShipArrivalConfirmRspBO();
        UocPebShipArrivalConfirmRspBO uocPebShipArrivalConfirmRspBO = this.uocPebShipArrivalConfirmBusiService.dealShipArrivalConfirm(reqBO);
        if (!"0000".equals(uocPebShipArrivalConfirmRspBO.getRespCode())) {
            throw new UocProBusinessException("103024", "\u8c03\u7528\u7535\u5b50\u8d85\u5e02\u81ea\u4e3b\u5230\u8d27\u767b\u8bb0\u4e1a\u52a1\u670d\u52a1\u5931\u8d25\u539f\u56e0\uff1a" + uocPebShipArrivalConfirmRspBO.getRespDesc());
        }
        if (null == reqBO.getIsSync() || reqBO.getIsSync().booleanValue()) {
            UocPebOrdIdxSyncReqBO saleOrdIdxSyncReqBO = this.bulidOrdIdxSyncReqBOParam(reqBO.getOrderId(), uocPebShipArrivalConfirmRspBO.getSaleVoucherId(), UocConstant.OBJ_TYPE.SALE);
            this.uocPebSyncOrderListMqServiceProvider.send(new ProxyMessage(this.orderSyncTopic, this.orderSyncTag, JSON.toJSONString((Object)saleOrdIdxSyncReqBO)));
            if (CollectionUtils.isNotEmpty((Collection)rspBO.getShipVoucherIdList())) {
                for (Long shipVoucherId : uocPebShipArrivalConfirmRspBO.getShipVoucherIdList()) {
                    UocPebOrdIdxSyncReqBO uocPebOrdIdxSyncReqBO = this.bulidOrdIdxSyncReqBOParam(reqBO.getOrderId(), shipVoucherId, UocConstant.OBJ_TYPE.SHIP);
                    this.uocPebSyncOrderListMqServiceProvider.send(new ProxyMessage(this.orderSyncTopic, this.orderSyncTag, JSON.toJSONString((Object)uocPebOrdIdxSyncReqBO)));
                }
            }
        }
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("\u7535\u5b50\u8d85\u5e02\u81ea\u4e3b\u5230\u8d27\u767b\u8bb0\u7ec4\u5408\u670d\u52a1\u6210\u529f\uff01");
        return rspBO;
    }

    private void validateParam(UocPebShipArrivalConfirmReqBO reqBO) {
        if (null == reqBO) {
            throw new UocProBusinessException("100002", "\u7535\u5b50\u8d85\u5e02\u81ea\u4e3b\u5230\u8d27\u767b\u8bb0\u7ec4\u5408\u670d\u52a1\u5165\u53c2\uff08reqBO\uff09\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        if (null == reqBO.getOrderId()) {
            throw new UocProBusinessException("100002", "\u7535\u5b50\u8d85\u5e02\u81ea\u4e3b\u5230\u8d27\u767b\u8bb0\u7ec4\u5408\u670d\u52a1\u5165\u53c2\u8ba2\u5355ID\uff08orderId\uff09\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        if (null == reqBO.getOperId()) {
            throw new UocProBusinessException("100002", "\u7535\u5b50\u8d85\u5e02\u81ea\u4e3b\u5230\u8d27\u767b\u8bb0\u7ec4\u5408\u670d\u52a1\u5165\u53c2\u64cd\u4f5c\u4eba\uff08operId\uff09\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
    }

    private UocPebOrdIdxSyncReqBO bulidOrdIdxSyncReqBOParam(Long orderId, Long objId, Integer objType) {
        UocPebOrdIdxSyncReqBO ordIdxSyncReqBO = new UocPebOrdIdxSyncReqBO();
        ordIdxSyncReqBO.setOrderId(orderId);
        ordIdxSyncReqBO.setObjId(objId);
        ordIdxSyncReqBO.setObjType(objType);
        return ordIdxSyncReqBO;
    }

    private void crateInvoice(UocPebShipArrivalConfirmReqBO reqBO) {
        OrdShipPO ordShipPO = new OrdShipPO();
        ordShipPO.setOrderId(reqBO.getOrderId());
        List ordShipPOList = this.ordShipMapper.getList(ordShipPO);
        if (CollectionUtils.isNotEmpty((Collection)ordShipPOList)) {
            reqBO.setExtOrderId(((OrdShipPO)ordShipPOList.get(0)).getExtOrderId());
            return;
        }
        UocPebExtRetailerNoticeShipReqBO extRetailerNoticeShipReqBO = new UocPebExtRetailerNoticeShipReqBO();
        OrdQueryIndexPO ordQueryIndexPO = new OrdQueryIndexPO();
        ordQueryIndexPO.setOrderId(reqBO.getOrderId());
        ordQueryIndexPO.setObjType(UocCoreConstant.OBJ_TYPE.SALE);
        List ordQueryIndexPOList = this.ordQueryIndexMapper.getList(ordQueryIndexPO);
        if (CollectionUtils.isNotEmpty((Collection)ordQueryIndexPOList)) {
            reqBO.setExtOrderId(((OrdQueryIndexPO)ordQueryIndexPOList.get(0)).getOutOrderNo());
            extRetailerNoticeShipReqBO.setExtOrderId(((OrdQueryIndexPO)ordQueryIndexPOList.get(0)).getOutOrderNo());
            extRetailerNoticeShipReqBO.setSupplierId(Long.valueOf(OrderPropertiesUtil.getProperty((String)"SUPPLIER_JD_ID")));
            extRetailerNoticeShipReqBO.setOrderId(reqBO.getOrderId());
            UocPebExtRetailerNoticeShipRspBO extRetailerNoticeShipRspBO = this.extRetailerNoticeShipBusiService.executeUpdateOrCreateShip(extRetailerNoticeShipReqBO);
            if (!"0000".equals(extRetailerNoticeShipRspBO.getRespCode())) {
                throw new UocProBusinessException("100001", "\u4eac\u4e1c\u786e\u8ba4\u6536\u8d27\u521b\u5efa\u53d1\u8d27\u5355\u5931\u8d25");
            }
        } else {
            throw new UocProBusinessException("100001", "\u672a\u67e5\u8be2\u5230\u8be5\u8ba2\u5355\u7684\u5916\u90e8\u8ba2\u5355\u7f16\u53f7");
        }
    }
}

