/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.order.extend.consumer;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.ohaotian.plugin.common.util.DateUtils;
import com.ohaotian.plugin.common.util.MoneyUtils;
import com.ohaotian.plugin.mq.proxy.DefaultProxyMessageConfig;
import com.ohaotian.plugin.mq.proxy.ProxyMessage;
import com.ohaotian.plugin.mq.proxy.ProxyMessageConsumer;
import com.ohaotian.plugin.mq.proxy.ProxyMessageProducer;
import com.ohaotian.plugin.mq.proxy.status.ProxyConsumerStatus;
import com.tydic.order.extend.aop.OrderLogRecord;
import com.tydic.order.extend.bo.es.PebExtOrdIdxSyncReqBO;
import com.tydic.order.extend.bo.notify.PebExtSendMessageReqBO;
import com.tydic.order.extend.bo.saleorder.FieldValueBO;
import com.tydic.order.extend.bo.saleorder.OrdInterLogBO;
import com.tydic.order.extend.bo.saleorder.PebExtFieldInReqBO;
import com.tydic.order.extend.bo.saleorder.PebExtSerPriceReqBO;
import com.tydic.order.extend.bo.saleorder.PebExtSerPriceRspBO;
import com.tydic.order.extend.bo.saleorder.PebExtThirdSupplierSkuInfo;
import com.tydic.order.extend.bo.saleorder.PebExtThirdSupplierSubmitOrderSaleItemRspBO;
import com.tydic.order.extend.busi.msg.PebExtOrderRemindBusiService;
import com.tydic.order.extend.busi.notify.PebExtSendMessageBusiService;
import com.tydic.order.extend.busi.order.PebExtPushFscAddPayAbleService;
import com.tydic.order.extend.busi.saleorder.PebExtFieldInBusiService;
import com.tydic.order.extend.comb.saleorder.PebExtPushSaleOrderInfoCreditCombService;
import com.tydic.order.extend.comb.saleorder.PebExtSerPriceCombService;
import com.tydic.order.extend.constant.PebExtConstant;
import com.tydic.order.extend.dao.OrdEcpPlanItemMapper;
import com.tydic.order.extend.dao.OrdEcpPlanMapper;
import com.tydic.order.extend.dao.po.OrdEcpPlanItemPO;
import com.tydic.order.extend.dao.po.OrdEcpPlanPO;
import com.tydic.order.pec.atom.el.order.UocAddExtMapAtomService;
import com.tydic.order.pec.atom.el.order.bo.QrySaleReqBO;
import com.tydic.order.pec.atom.el.order.bo.UocAddOrdExtMapReqBO;
import com.tydic.order.pec.atom.el.order.bo.UocAddOrdExtMapRsqBO;
import com.tydic.order.pec.atom.es.order.UocQrySaleOrderAtomService;
import com.tydic.order.pec.atom.es.unicall.UocPebUniCallIntfAtomService;
import com.tydic.order.pec.atom.es.unicall.bo.UnicallInterfaceDefBO;
import com.tydic.order.pec.atom.es.unicall.bo.UocPebUniCallIntfReqBO;
import com.tydic.order.pec.atom.es.unicall.bo.UocPebUniCallIntfRspBO;
import com.tydic.order.pec.bo.es.order.UocPebAgainAddShippingCartReqBO;
import com.tydic.order.pec.bo.sale.UocSyncStatisticsInfoCombReqBO;
import com.tydic.order.pec.busi.es.order.UocPebOrderCancelBusiService;
import com.tydic.order.pec.busi.es.order.UocPebPreOrderSubmitBsuiService;
import com.tydic.order.pec.busi.es.order.bo.UocPebOrderCancelReqBO;
import com.tydic.order.pec.comb.es.order.UocPebAgainAddShippingCartCombService;
import com.tydic.order.pec.comb.sale.UocSyncStatisticsInfoCombService;
import com.tydic.order.third.intf.ability.contract.PebIntfQueryContractSupplierService;
import com.tydic.order.third.intf.ability.contract.PebIntfSettlementModeExceptQryListService;
import com.tydic.order.third.intf.ability.esb.ecp.PebIntfCreatePurchaseOrderAbilityService;
import com.tydic.order.third.intf.ability.fsc.PebIntfBusiAddCreditLineService;
import com.tydic.order.third.intf.ability.umc.PebIntfMemDetailQueryAbilityService;
import com.tydic.order.third.intf.ability.umc.PebIntfQueryParentOrgNotDepartmentAbilityService;
import com.tydic.order.third.intf.ability.umc.PebIntfWalletConsumeAbilityService;
import com.tydic.order.third.intf.ability.usc.PebIntfGoodsListDelAbilityService;
import com.tydic.order.third.intf.bo.contract.SettlementModeExceptBO;
import com.tydic.order.third.intf.bo.contract.SettlementModeExceptFscBO;
import com.tydic.order.third.intf.bo.contract.SettlementModeExceptFscQryListReqBO;
import com.tydic.order.third.intf.bo.contract.SettlementModeExceptFscQryListRspBO;
import com.tydic.order.third.intf.bo.contract.UocProQueryContractSupplierInfoRspBO;
import com.tydic.order.third.intf.bo.esb.ecp.PebIntfCreatePurchaseOrderAbilityReqBo;
import com.tydic.order.third.intf.bo.esb.ecp.PebIntfCreatePurchaseOrderAbilityRspBo;
import com.tydic.order.third.intf.bo.esb.ecp.PebIntfCreatePurchaseOrderAuthInfoBo;
import com.tydic.order.third.intf.bo.esb.ecp.PebIntfCreatePurchaseOrderContractDetailInfoBo;
import com.tydic.order.third.intf.bo.esb.ecp.PebIntfCreatePurchaseOrderContractInfoBo;
import com.tydic.order.third.intf.bo.fsc.AddCreditLineReqBO;
import com.tydic.order.third.intf.bo.fsc.AddCreditLineRspBO;
import com.tydic.order.third.intf.bo.pay.BusiAddPayConfigExceptRspBO;
import com.tydic.order.third.intf.bo.umc.EnterpriseOrgDetailReqBO;
import com.tydic.order.third.intf.bo.umc.EnterpriseOrgDetailRspBO;
import com.tydic.order.third.intf.bo.umc.MemDetailQueryReqBO;
import com.tydic.order.third.intf.bo.umc.MemDetailQueryRspBO;
import com.tydic.order.third.intf.bo.umc.WalletConsumeReqBO;
import com.tydic.order.third.intf.bo.umc.WalletConsumeRspBO;
import com.tydic.order.uoc.atom.core.UocCoreQryTacheIntfAtomService;
import com.tydic.order.uoc.atom.core.bo.UocCoreQryTacheIntfReqBO;
import com.tydic.order.uoc.atom.core.bo.UocCoreQryTacheIntfRspBO;
import com.tydic.order.uoc.bo.InterfaceDefBO;
import com.tydic.order.uoc.bo.order.OrdSaleRspBO;
import com.tydic.order.uoc.constant.UocConstant;
import com.tydic.order.uoc.constant.UocCoreConstant;
import com.tydic.order.uoc.dao.OrdExtMapMapper;
import com.tydic.order.uoc.dao.OrdStakeholderMapper;
import com.tydic.order.uoc.dao.OrderMapper;
import com.tydic.order.uoc.dao.po.OrdExtMapPO;
import com.tydic.order.uoc.dao.po.OrdStakeholderPO;
import com.tydic.order.uoc.dao.po.OrderPO;
import com.tydic.order.uoc.utils.OrderGenerateIdUtil;
import com.tydic.uoc.base.bo.UocProBaseRspBo;
import com.tydic.uoc.base.exception.UocProBusinessException;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;

public class PebCreateOrderConsumer
extends DefaultProxyMessageConfig
implements ProxyMessageConsumer {
    private Logger logger = LoggerFactory.getLogger(PebCreateOrderConsumer.class);
    @Autowired
    private UocCoreQryTacheIntfAtomService uocCoreQryTacheIntfAtomService;
    @Autowired
    private UocQrySaleOrderAtomService saleOrderAtomService;
    @Autowired
    private UocPebUniCallIntfAtomService uocPebUniCallIntfAtomService;
    @Autowired
    private UocPebOrderCancelBusiService uocPebOrderCancelBusiService;
    @Autowired
    private UocPebPreOrderSubmitBsuiService uocPebPreOrderSubmitBsuiService;
    @Value(value="${UOC_PEB_ORDER_SYNC_TOPIC}")
    private String orderSyncTopic;
    @Value(value="${UOC_PEB_ORDER_SYNC_TAG}")
    private String orderSyncTag;
    @Resource(name="uocPebSyncOrderListMqServiceProvider")
    private ProxyMessageProducer uocPebSyncOrderListMqServiceProvider;
    @Autowired
    private UocAddExtMapAtomService uocAddExtMapAtomService;
    @Autowired
    private PebExtOrderRemindBusiService pebExtOrderRemindBusiService;
    @Autowired
    private PebExtFieldInBusiService pebExtFieldInBusiService;
    @Autowired
    private PebIntfCreatePurchaseOrderAbilityService pebIntfCreatePurchaseOrderAbilityService;
    @Autowired
    private OrdEcpPlanMapper ordEcpPlanMapper;
    @Autowired
    private OrdEcpPlanItemMapper ordEcpPlanItemMapper;
    @Autowired
    private OrderMapper orderMapper;
    @Value(value="${ecp.jgbh:test}")
    private String jgbh;
    @Value(value="${ecp.sqbh:test}")
    private String sqbh;
    @Autowired
    private UocPebAgainAddShippingCartCombService uocPebAgainAddShippingCartCombService;
    @Autowired
    private PebIntfMemDetailQueryAbilityService pebIntfMemDetailQueryAbilityService;
    @Autowired
    private PebIntfQueryContractSupplierService pebIntfQueryContractSupplierService;
    @Autowired
    private OrdStakeholderMapper ordStakeholderMapper;
    @Autowired
    private PebExtSerPriceCombService pebExtSerPriceCombService;
    @Autowired
    private OrdExtMapMapper ordExtMapMapper;
    @Autowired
    private OrderGenerateIdUtil idUtil;
    @Autowired
    private UocSyncStatisticsInfoCombService uocSyncStatisticsInfoCombService;
    @Autowired
    private PebIntfWalletConsumeAbilityService pebIntfWalletConsumeAbilityService;
    @Autowired
    private PebIntfSettlementModeExceptQryListService pebIntfSettlementModeExceptQryListService;
    @Autowired
    private PebExtPushSaleOrderInfoCreditCombService pebExtPushSaleOrderInfoCreditCombService;
    @Value(value="${busiMode:0}")
    private String initBusiMode;
    @Value(value="${staff.welfare.pay.config.enable:false}")
    private boolean payConfig;
    @Autowired
    private PebIntfBusiAddCreditLineService pebIntfBusiAddCreditLineService;
    @Autowired
    private PebExtSendMessageBusiService pebExtSendMessageBusiService;
    @Autowired
    private PebIntfQueryParentOrgNotDepartmentAbilityService pebIntfQueryParentOrgNotDepartmentAbilityService;
    @Value(value="${UOC_NOTIFY_ORDER_TOPIC}")
    private String notifyTopic;
    @Value(value="${UOC_NOTIFY_ORDER_TAG}")
    private String notifyTag;
    @Resource(name="notifyOrderMsgProvider")
    private ProxyMessageProducer notifyOrderMsgProvider;
    @Value(value="${uoc.saveJdOrgId:false}")
    private Boolean saveJdOrgId;
    @Autowired
    private PebIntfGoodsListDelAbilityService pebIntfGoodsListDelAbilityService;
    @Autowired
    private PebExtPushFscAddPayAbleService pebExtPushFscAddPayAbleService;

    public ProxyConsumerStatus onMessage(ProxyMessage proxyMessage) {
        try {
            PebExtThirdSupplierSubmitOrderSaleItemRspBO rspBO = (PebExtThirdSupplierSubmitOrderSaleItemRspBO)JSON.parseObject((String)proxyMessage.getContent(), PebExtThirdSupplierSubmitOrderSaleItemRspBO.class);
            if (rspBO.getPay() != null && rspBO.getPay().booleanValue()) {
                this.order(rspBO);
                return ProxyConsumerStatus.CONSUME_SUCCESS;
            }
            this.logger.debug("\u8ba2\u5355\u4e0b\u5355\u6d88\u8d39\u8005\u5165\u53c2" + JSON.toJSONString((Object)rspBO));
            QrySaleReqBO qrySaleReqBO = new QrySaleReqBO();
            qrySaleReqBO.setOrderId(rspBO.getOrderId());
            qrySaleReqBO.setSaleId(Long.valueOf(rspBO.getSaleOrderId()));
            OrdSaleRspBO saleRspBO = this.saleOrderAtomService.qry(qrySaleReqBO);
            HashMap<String, String> skuAndPlanItemIdMap = new HashMap<String, String>();
            for (PebExtThirdSupplierSkuInfo pebExtThirdSupplierSkuInfo : rspBO.getSaleOrderItemList()) {
                if (!StringUtils.isNotBlank((CharSequence)pebExtThirdSupplierSkuInfo.getPlanItemNo())) continue;
                skuAndPlanItemIdMap.put(pebExtThirdSupplierSkuInfo.getSkuId(), pebExtThirdSupplierSkuInfo.getPlanItemNo());
            }
            try {
                if (rspBO.getIsSuccess() != null && !rspBO.getIsSuccess().booleanValue()) {
                    UocPebOrderCancelReqBO cancelReqBO = new UocPebOrderCancelReqBO();
                    cancelReqBO.setOrderId(rspBO.getOrderId());
                    cancelReqBO.setSaleVoucherId(Long.valueOf(rspBO.getSaleOrderId()));
                    cancelReqBO.setIsCancelWF(Boolean.valueOf(false));
                    cancelReqBO.setCancelDesc(rspBO.getRemark());
                    cancelReqBO.setCancelReason(rspBO.getRemark());
                    this.updateOrder(saleRspBO.getOrderId());
                    this.uocPebOrderCancelBusiService.dealOrderCancel(cancelReqBO);
                }
                UocCoreQryTacheIntfReqBO reqBO = new UocCoreQryTacheIntfReqBO();
                reqBO.setFlowFlag(UocConstant.FLOW_FLAG.POSITIVE);
                reqBO.setTacheCode(saleRspBO.getSaleState() + "");
                this.logger.error("\u8ba2\u5355\u4e0b\u5355\u6d88\u8d39\u67e5\u8be2\u5230\u73af\u8282\u5165\u53c2\uff1a" + JSON.toJSONString((Object)reqBO));
                UocCoreQryTacheIntfRspBO intfRspBO = this.uocCoreQryTacheIntfAtomService.qryTacheIntf(reqBO);
                this.logger.error("\u8ba2\u5355\u4e0b\u5355\u6d88\u8d39\u67e5\u8be2\u5230\u73af\u8282\uff1a" + JSON.toJSONString((Object)intfRspBO));
                if (CollectionUtils.isEmpty((Collection)intfRspBO.getInterfaceList())) {
                    this.uocPebOrdIdxSync(rspBO);
                    return ProxyConsumerStatus.CONSUME_SUCCESS;
                }
                boolean finish = false;
                for (InterfaceDefBO defBO : intfRspBO.getInterfaceList()) {
                    UocPebUniCallIntfReqBO callIntfReqBO = new UocPebUniCallIntfReqBO();
                    UnicallInterfaceDefBO interfaceDefBO = new UnicallInterfaceDefBO();
                    BeanUtils.copyProperties((Object)defBO, (Object)interfaceDefBO);
                    callIntfReqBO.setInterfaceDef(interfaceDefBO);
                    callIntfReqBO.setOrderId(rspBO.getOrderId());
                    callIntfReqBO.setObjId(Long.valueOf(rspBO.getSaleOrderId()));
                    callIntfReqBO.setObjType(UocConstant.OBJ_TYPE.SALE);
                    UocPebUniCallIntfRspBO uocPebUniCallIntfRspBO = this.uocPebUniCallIntfAtomService.dealUniCallIntf(callIntfReqBO);
                    this.logger.debug(interfaceDefBO.getInterDesc() + "\u7edf\u4e00\u63a5\u53e3\u56de\u53c2\uff1a" + JSON.toJSONString((Object)uocPebUniCallIntfRspBO));
                    if ("0000".equals(uocPebUniCallIntfRspBO.getRespCode())) continue;
                    finish = true;
                    String desc = StringUtils.isNotBlank((CharSequence)uocPebUniCallIntfRspBO.getCallResult()) ? interfaceDefBO.getInterDesc() + "\u5931\u8d25\u3002" + uocPebUniCallIntfRspBO.getCallResult() : interfaceDefBO.getInterDesc() + "\u5931\u8d25\u3002" + uocPebUniCallIntfRspBO.getRespDesc();
                    this.cancel(saleRspBO, rspBO.getUserId(), desc, skuAndPlanItemIdMap, rspBO.getOrgPath());
                    break;
                }
                if (!finish) {
                    qrySaleReqBO = new QrySaleReqBO();
                    qrySaleReqBO.setOrderId(rspBO.getOrderId());
                    qrySaleReqBO.setSaleId(Long.valueOf(rspBO.getSaleOrderId()));
                    saleRspBO = this.saleOrderAtomService.qry(qrySaleReqBO);
                    if ((UocConstant.SALE_ORDER_STATUS.PENDING_APPROVAL.equals(saleRspBO.getSaleState()) || UocConstant.SALE_ORDER_STATUS.PAYING.equals(saleRspBO.getSaleState())) && rspBO.getIsPreOrder().equals(UocConstant.PRE_ORDER.NO)) {
                        this.addPreFalg(saleRspBO);
                    }
                    PebExtSendMessageReqBO pebExtSendMessageReqBO = new PebExtSendMessageReqBO();
                    pebExtSendMessageReqBO.setNotifyBusiness(PebExtConstant.NOTIFY_BUSINESS.ORDER_CREATE_SUCCESS);
                    pebExtSendMessageReqBO.setOrderType(PebExtConstant.NOTIFY_ORDER_TYPE.ORDER_STORE);
                    pebExtSendMessageReqBO.setNotifyType(PebExtConstant.NOTIFY_TYPE.ORDER_NOTIFY);
                    pebExtSendMessageReqBO.setSaleVoucherNo(saleRspBO.getSaleVoucherNo());
                    pebExtSendMessageReqBO.setOrderId(saleRspBO.getOrderId());
                    pebExtSendMessageReqBO.setUserId(rspBO.getUserId());
                    this.notifyOrderMsgProvider.send(new ProxyMessage(this.notifyTopic, this.notifyTag, JSONObject.toJSONString((Object)pebExtSendMessageReqBO)));
                }
            }
            catch (Exception e) {
                this.cancel(saleRspBO, rspBO.getUserId(), e.getMessage(), skuAndPlanItemIdMap, rspBO.getOrgPath());
                this.logger.error("\u8ba2\u5355\u4e0b\u5355\u6d88\u8d39\u5931\u8d25\uff0c\u8ba2\u5355id\uff1a" + rspBO.getOrderId() + ",msg\uff1a" + e.getMessage());
            }
            this.uocPebOrdIdxSync(rspBO);
            this.logger.debug("\u8ba2\u5355\u4e0b\u5355\u6d88\u8d39\u5b8c\u6210");
        }
        catch (Exception e) {
            this.logger.error("\u8ba2\u5355\u4e0b\u5355\u6d88\u8d39\u5931\u8d25\uff0c\u8ba2\u5355\u6d88\u8d39\u5165\u53c2\u4e0d\u5bf9");
        }
        return ProxyConsumerStatus.CONSUME_SUCCESS;
    }

    private void updateOrder(Long orderId) {
        OrderPO orderPO = new OrderPO();
        orderPO.setOrderId(orderId);
        orderPO.setProcState("8888");
        this.orderMapper.updateById(orderPO);
    }

    private void order(PebExtThirdSupplierSubmitOrderSaleItemRspBO rspBO) {
        this.logger.debug("\u8ba2\u5355\u4e0b\u5355\u6d88\u8d39\u8005\u5165\u53c2" + JSON.toJSONString((Object)rspBO));
        QrySaleReqBO qrySaleReqBO = new QrySaleReqBO();
        qrySaleReqBO.setOrderId(rspBO.getOrderId());
        qrySaleReqBO.setSaleId(Long.valueOf(rspBO.getSaleOrderId()));
        OrdSaleRspBO saleRspBO = this.saleOrderAtomService.qry(qrySaleReqBO);
        try {
            if (rspBO.getIsSuccess() != null && !rspBO.getIsSuccess().booleanValue()) {
                UocPebOrderCancelReqBO cancelReqBO = new UocPebOrderCancelReqBO();
                cancelReqBO.setOrderId(rspBO.getOrderId());
                cancelReqBO.setSaleVoucherId(Long.valueOf(rspBO.getSaleOrderId()));
                cancelReqBO.setIsCancelWF(Boolean.valueOf(false));
                cancelReqBO.setCancelDesc(rspBO.getRemark());
                cancelReqBO.setCancelReason(rspBO.getRemark());
                this.updateOrder(saleRspBO.getOrderId());
                this.uocPebOrderCancelBusiService.dealOrderCancel(cancelReqBO);
            }
            UocProQueryContractSupplierInfoRspBO contractRspBO = new UocProQueryContractSupplierInfoRspBO();
            contractRspBO.setIntroduceType(rspBO.getIntroduceType());
            contractRspBO.setIntroduceTypeStr(rspBO.getIntroduceTypeStr());
            contractRspBO.setEcpAgreementCode(rspBO.getEcpAgreementCode());
            contractRspBO.setEntAgreementCode(rspBO.getEntAgreementCode());
            this.savePurModAndStr(contractRspBO, rspBO.getOrderId());
            UocPebUniCallIntfReqBO callIntfReqBO = new UocPebUniCallIntfReqBO();
            UnicallInterfaceDefBO interfaceDefBO = new UnicallInterfaceDefBO();
            interfaceDefBO.setIsAllowException(Integer.valueOf(1));
            interfaceDefBO.setInterCode("PcChargebacksRequest");
            interfaceDefBO.setInterMethod("dealEBConfirmOrder");
            interfaceDefBO.setInterType(Integer.valueOf(1));
            interfaceDefBO.setInterDesc("\u7ed3\u7b97\u4e2d\u5fc3\u6263\u6b3e");
            callIntfReqBO.setInterfaceDef(interfaceDefBO);
            callIntfReqBO.setOrderId(rspBO.getOrderId());
            callIntfReqBO.setObjType(UocConstant.OBJ_TYPE.SALE);
            callIntfReqBO.setObjId(saleRspBO.getSaleVoucherId());
            this.uocPebUniCallIntfAtomService.dealUniCallIntf(callIntfReqBO);
            this.serPrice(saleRspBO, rspBO.getUserId());
            PebExtFieldInReqBO inReqBO = new PebExtFieldInReqBO();
            inReqBO.setOrderId(rspBO.getOrderId());
            inReqBO.setObjId(saleRspBO.getSaleVoucherId());
            inReqBO.setStatus(PebExtConstant.P_ORDER_PAYING);
            this.pebExtFieldInBusiService.dealUpdateSale(inReqBO);
            try {
                if (rspBO.getGoodsListDelReqBO() != null) {
                    this.pebIntfGoodsListDelAbilityService.delGoodsList(rspBO.getGoodsListDelReqBO());
                }
            }
            catch (Exception exception) {}
        }
        catch (Exception e) {
            this.logger.error("\u8ba2\u5355\u4e0b\u5355\u6d88\u8d39\u5931\u8d25\uff0c\u8ba2\u5355id\uff1a" + rspBO.getOrderId() + ",msg\uff1a" + e.getMessage());
        }
    }

    private void push(BusiAddPayConfigExceptRspBO rspBO, PebExtThirdSupplierSubmitOrderSaleItemRspBO itemRspBO, BigDecimal fee, Long countId, String busiMode) {
        if ("1".equals(busiMode)) {
            return;
        }
        if ("2".equals(rspBO.getPayType())) {
            if (rspBO.getBalance() == null) {
                this.savePush(itemRspBO, "0");
                return;
            }
            if (rspBO.getBalance().compareTo(fee) < 0) {
                itemRspBO.setIsSuccess(Boolean.valueOf(false));
                itemRspBO.setRemark("\u60a8\u7684\u5269\u4f59\u6388\u4fe1\u989d\u5ea6\u4e0d\u8db3\uff0c\u8bf7\u5c3d\u5feb\u8fd8\u6b3e");
                return;
            }
            AddCreditLineReqBO reqBO = new AddCreditLineReqBO();
            reqBO.setAccountId(countId);
            reqBO.setChangeType("0");
            reqBO.setChangeInfo(fee.negate());
            reqBO.setOrderCode(itemRspBO.getSaleOrderCode());
            reqBO.setOrderId(itemRspBO.getOrderId());
            reqBO.setPayConfigDetailId(rspBO.getPayConfigDetailId());
            AddCreditLineRspBO lineRspBO = this.pebIntfBusiAddCreditLineService.addCreditLine(reqBO);
            if (!"0000".equals(lineRspBO.getRespCode())) {
                itemRspBO.setIsSuccess(Boolean.valueOf(false));
                itemRspBO.setRemark("\u6263\u51cf\u6388\u4fe1\u5931\u8d25" + lineRspBO.getRespDesc());
                return;
            }
            this.savePush(itemRspBO, "2");
        } else {
            this.savePush(itemRspBO, "0");
        }
    }

    private void savePush(PebExtThirdSupplierSubmitOrderSaleItemRspBO itemRspBO, String desc) {
        PebExtFieldInReqBO pebExtFieldInReqBO = new PebExtFieldInReqBO();
        pebExtFieldInReqBO.setObjType(UocCoreConstant.OBJ_TYPE.ORDER);
        pebExtFieldInReqBO.setOrderId(itemRspBO.getOrderId());
        pebExtFieldInReqBO.setObjId(itemRspBO.getOrderId());
        ArrayList<FieldValueBO> fieldValueBOS = new ArrayList<FieldValueBO>();
        FieldValueBO valueBO = new FieldValueBO();
        valueBO.setFieldValue(desc);
        valueBO.setFieldCode("creditLine");
        valueBO.setFieldName("\u63a8\u9001\u6388\u4fe1\u989d\u5ea6");
        fieldValueBOS.add(valueBO);
        pebExtFieldInReqBO.setExtFieldList(fieldValueBOS);
        this.pebExtFieldInBusiService.dealCoreExtFieldIn(pebExtFieldInReqBO);
    }

    private boolean wallet(PebExtThirdSupplierSubmitOrderSaleItemRspBO reqBO, Map<String, String> skuAndPlanItemIdMap, OrdSaleRspBO saleRspBO) {
        if (reqBO.getFl() != null && !reqBO.getFl().booleanValue()) {
            return true;
        }
        WalletConsumeReqBO walletConsumeReqBO = new WalletConsumeReqBO();
        walletConsumeReqBO.setConsumeAmount(reqBO.getFee());
        walletConsumeReqBO.setCheckFlag(Integer.valueOf(0));
        walletConsumeReqBO.setMemId(reqBO.getMemId());
        walletConsumeReqBO.setWalletType(Integer.valueOf(5));
        walletConsumeReqBO.setOrderId(reqBO.getOrderId().toString());
        walletConsumeReqBO.setActivityCode(reqBO.getActiveId());
        WalletConsumeRspBO rspBO = this.pebIntfWalletConsumeAbilityService.walletConsume(walletConsumeReqBO);
        if (!"0000".equals(rspBO.getRespCode())) {
            this.cancel(saleRspBO, reqBO.getUserId(), "\u6263\u51cf\u79ef\u5206\u5931\u8d25" + rspBO.getRespCode(), skuAndPlanItemIdMap, reqBO.getOrgPath());
            return false;
        }
        return true;
    }

    private String getBusiMode(PebExtThirdSupplierSubmitOrderSaleItemRspBO rspBO, Long contractId) {
        String busiMode = this.initBusiMode;
        OrderPO orderPO = this.orderMapper.getModelById(rspBO.getOrderId().longValue());
        if (rspBO.getFl() != null && rspBO.getFl().booleanValue() && !this.payConfig) {
            busiMode = "0";
        } else if (PebExtConstant.OrderType.DA.equals(orderPO.getOrderType())) {
            busiMode = "1";
        } else {
            SettlementModeExceptFscQryListReqBO listReqBO = new SettlementModeExceptFscQryListReqBO();
            ArrayList<SettlementModeExceptFscBO> fscBOS = new ArrayList<SettlementModeExceptFscBO>();
            SettlementModeExceptFscBO fscBO = new SettlementModeExceptFscBO();
            fscBO.setExceptOrgId(rspBO.getOrgId());
            fscBO.setSubType("0");
            fscBO.setContractId(contractId);
            fscBO.setSupplierNo(rspBO.getGoodsSupplierId());
            fscBOS.add(fscBO);
            listReqBO.setSettlementModeExceptFscQryListBoList(fscBOS);
            SettlementModeExceptFscQryListRspBO listRspBO = this.pebIntfSettlementModeExceptQryListService.qrySettlementModeReceptOrSettlement(listReqBO);
            if (!"0000".equals(listRspBO.getRespCode())) {
                throw new UocProBusinessException("8888", "\u67e5\u8be2\u4ea4\u6613\u6a21\u5f0f\u62a5\u9519" + listRspBO.getRespDesc());
            }
            for (SettlementModeExceptBO exceptBO : listRspBO.getSettlementModeExceptFscQryListRspBoList()) {
                if (!contractId.equals(exceptBO.getContractId())) continue;
                busiMode = exceptBO.getBusiMode();
                break;
            }
        }
        PebExtFieldInReqBO pebExtFieldInReqBO = new PebExtFieldInReqBO();
        pebExtFieldInReqBO.setObjType(UocCoreConstant.OBJ_TYPE.ORDER);
        pebExtFieldInReqBO.setObjId(rspBO.getOrderId());
        pebExtFieldInReqBO.setOrderId(rspBO.getOrderId());
        ArrayList<FieldValueBO> fieldValueBOS = new ArrayList<FieldValueBO>();
        FieldValueBO valueBO = new FieldValueBO();
        valueBO.setFieldValue(busiMode);
        valueBO.setFieldCode("busiMode");
        valueBO.setFieldName("\u4ea4\u6613\u6a21\u5f0f");
        fieldValueBOS.add(valueBO);
        if (this.saveJdOrgId != null && this.saveJdOrgId.booleanValue() && "1".equals(busiMode)) {
            FieldValueBO jdOrgId = new FieldValueBO();
            jdOrgId.setId(Long.valueOf(this.idUtil.nextId()));
            jdOrgId.setFieldValue(rspBO.getCompanyId().toString());
            jdOrgId.setFieldName("jd_token\u5355\u4f4did");
            jdOrgId.setFieldCode("jdOrgId");
            fieldValueBOS.add(jdOrgId);
        }
        pebExtFieldInReqBO.setExtFieldList(fieldValueBOS);
        this.pebExtFieldInBusiService.dealCoreExtFieldIn(pebExtFieldInReqBO);
        return busiMode;
    }

    @OrderLogRecord(description="\u65b0\u589e")
    private UocProBaseRspBo serPrice(OrdSaleRspBO saleRspBO, Long userId) {
        PebExtSerPriceRspBO rspBO3;
        PebExtSerPriceRspBO rspBO2;
        PebExtSerPriceReqBO reqBO = new PebExtSerPriceReqBO();
        reqBO.setPush(Boolean.valueOf(false));
        reqBO.setOrderId(saleRspBO.getOrderId());
        PebExtSerPriceRspBO rspBO = this.pebExtSerPriceCombService.serPrice(reqBO);
        if (!("0000".equals(rspBO.getRespCode()) || "0000".equals((rspBO2 = this.pebExtSerPriceCombService.serPrice(reqBO)).getRespCode()) || "0000".equals((rspBO3 = this.pebExtSerPriceCombService.serPrice(reqBO)).getRespCode()))) {
            UocProBaseRspBo rspInfoBO = new UocProBaseRspBo();
            rspInfoBO.setRespCode("8888");
            rspInfoBO.setRespDesc("\u8d85\u5e02\u8ba2\u5355\u521b\u5efa\u5931\u8d25,\u8c03\u7528\u7ed3\u7b97\u4e2d\u5fc3\u4fdd\u5b58\u6210\u4ea4\u670d\u52a1\u8d39\u5931\u8d25!" + rspBO3.getRespDesc());
            return rspInfoBO;
        }
        UocProBaseRspBo rspInfoBO = new UocProBaseRspBo();
        rspInfoBO.setRespCode("0000");
        rspInfoBO.setRespDesc("\u8d85\u5e02\u4fdd\u5b58\u6210\u4ea4\u670d\u52a1\u8d39\u6210\u529f");
        return rspInfoBO;
    }

    private void addCart(Long orderId, Long saleId, Long userId, Map<String, String> skuAndPlanItemIdMap, String orgPath) {
        UocPebAgainAddShippingCartReqBO reqBO = new UocPebAgainAddShippingCartReqBO();
        reqBO.setOrderId(orderId);
        reqBO.setSaleVoucherId(saleId);
        reqBO.setUserId(userId);
        reqBO.setSkuIdAndPlanItemNo(skuAndPlanItemIdMap);
        reqBO.setOrgPath(orgPath);
        try {
            this.uocPebAgainAddShippingCartCombService.againAddShippingCart(reqBO);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void savePurModAndStr(UocProQueryContractSupplierInfoRspBO contractRspBO, Long orderId) {
        OrdExtMapPO ordExtMapPO;
        ArrayList<OrdExtMapPO> list = new ArrayList<OrdExtMapPO>();
        if (null != contractRspBO.getIntroduceType()) {
            ordExtMapPO = new OrdExtMapPO();
            ordExtMapPO.setId(Long.valueOf(this.idUtil.nextId()));
            ordExtMapPO.setFieldValue(String.valueOf(contractRspBO.getIntroduceType()));
            ordExtMapPO.setFieldName("\u91c7\u8d2d\u65b9\u5f0f");
            ordExtMapPO.setFieldCode("purMod");
            ordExtMapPO.setOrderId(orderId);
            ordExtMapPO.setObjId(orderId);
            ordExtMapPO.setObjType(PebExtConstant.OBJ_TYPE.EXT);
            list.add(ordExtMapPO);
        }
        if (StringUtils.isNotBlank((CharSequence)contractRspBO.getIntroduceTypeStr())) {
            ordExtMapPO = new OrdExtMapPO();
            ordExtMapPO.setId(Long.valueOf(this.idUtil.nextId()));
            ordExtMapPO.setFieldValue(contractRspBO.getIntroduceTypeStr());
            ordExtMapPO.setFieldName("\u91c7\u8d2d\u65b9\u5f0f\u7ffb\u8bd1");
            ordExtMapPO.setFieldCode("purModStr");
            ordExtMapPO.setOrderId(orderId);
            ordExtMapPO.setObjId(orderId);
            ordExtMapPO.setObjType(PebExtConstant.OBJ_TYPE.EXT);
            list.add(ordExtMapPO);
        }
        if (StringUtils.isNotBlank((CharSequence)contractRspBO.getEntAgreementCode())) {
            OrdExtMapPO ent = new OrdExtMapPO();
            ent.setId(Long.valueOf(this.idUtil.nextId()));
            ent.setFieldValue(contractRspBO.getEntAgreementCode());
            ent.setFieldName("\u4f01\u4e1a\u534f\u8bae\u7f16\u53f7");
            ent.setFieldCode("entAgreementCode");
            ent.setOrderId(orderId);
            ent.setObjId(orderId);
            ent.setObjType(PebExtConstant.OBJ_TYPE.EXT);
            list.add(ent);
        }
        if (StringUtils.isNotBlank((CharSequence)contractRspBO.getEntAgreementCode())) {
            OrdExtMapPO esContractCodeExtMap = new OrdExtMapPO();
            esContractCodeExtMap.setId(Long.valueOf(this.idUtil.nextId()));
            esContractCodeExtMap.setOrderId(orderId);
            esContractCodeExtMap.setObjId(orderId);
            esContractCodeExtMap.setObjType(UocConstant.OBJ_TYPE.ORDER);
            esContractCodeExtMap.setFieldCode("ecpAgreementCode");
            esContractCodeExtMap.setFieldValue(contractRspBO.getEcpAgreementCode());
            esContractCodeExtMap.setFieldName("\u8d85\u5e02\u5408\u540c\u7f16\u53f7");
            list.add(esContractCodeExtMap);
        }
        if (list.size() > 0) {
            this.ordExtMapMapper.insertBatch(list);
        }
    }

    private void pushEcp(OrdSaleRspBO saleRspBO, List<PebExtThirdSupplierSkuInfo> saleOrderItemList, Long userId, UocProQueryContractSupplierInfoRspBO contractRspBO, String ecpPurType, String createName, Map<String, String> skuAndPlanItemIdMap, OrdStakeholderPO stakeholderPO) {
        PebIntfCreatePurchaseOrderAbilityReqBo reqBo = new PebIntfCreatePurchaseOrderAbilityReqBo();
        PebIntfCreatePurchaseOrderAuthInfoBo authInfoBo = new PebIntfCreatePurchaseOrderAuthInfoBo();
        PebIntfCreatePurchaseOrderContractInfoBo htxx = new PebIntfCreatePurchaseOrderContractInfoBo();
        reqBo.setMAPHTXX(htxx);
        ArrayList<PebIntfCreatePurchaseOrderContractDetailInfoBo> cghtjhmxlist = new ArrayList<PebIntfCreatePurchaseOrderContractDetailInfoBo>();
        htxx.setCGHTJHMXLIST(cghtjhmxlist);
        reqBo.setMAPSQXX(authInfoBo);
        EnterpriseOrgDetailReqBO detailReqBO = new EnterpriseOrgDetailReqBO();
        detailReqBO.setOrgIdWeb(Long.valueOf(stakeholderPO.getPurNo()));
        EnterpriseOrgDetailRspBO detailRspBO = this.pebIntfQueryParentOrgNotDepartmentAbilityService.queryEnterpriseOrgByDetail(detailReqBO);
        if (detailRspBO.getUmcEnterpriseOrgAbilityBO() != null) {
            htxx.setCGRJGBH(detailRspBO.getUmcEnterpriseOrgAbilityBO().getErpOrgCode());
        }
        authInfoBo.setJGBH(this.jgbh);
        authInfoBo.setSQBH(this.sqbh);
        OrderPO orderPO = this.orderMapper.getModelById(saleRspBO.getOrderId().longValue());
        htxx.setCZBS("I");
        htxx.setZDYHTBH(saleRspBO.getSaleVoucherNo());
        try {
            htxx.setCGR(this.getEmpCod(userId));
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (StringUtils.isBlank((CharSequence)htxx.getCGR())) {
            htxx.setCGR(createName);
        }
        htxx.setDDSCSJ(Long.valueOf(DateUtils.dateToStr((Date)orderPO.getCreateTime(), (String)"yyyyMMddHHmmss")));
        htxx.setHTYJGBSJ(Long.valueOf(DateUtils.dateToStr((Date)new Date(orderPO.getCreateTime().getTime() + 5184000000L), (String)"yyyyMMddHHmmss")));
        try {
            htxx.setHTJE(MoneyUtils.Long2BigDecimal((Long)saleRspBO.getSaleFee()));
            htxx.setYSJE(MoneyUtils.Long2BigDecimal((Long)saleRspBO.getSaleFee()));
        }
        catch (Exception exception) {
            // empty catch block
        }
        htxx.setHTJELX("156");
        htxx.setBEIZ(orderPO.getOrderDesc());
        htxx.setWBXTBH(saleRspBO.getSaleVoucherNo());
        htxx.setJZCGLX(ecpPurType);
        htxx.setPTZHTBH(contractRspBO.getEcpAgreementCode());
        Map<Long, OrdEcpPlanItemPO> itemPOMap = null;
        if (saleOrderItemList.get(0).getPlanItemId() != null && saleOrderItemList.get(0).getPlanItemId() != 0L) {
            OrdEcpPlanPO ordEcpPlanPO = this.ordEcpPlanMapper.getModelById(saleOrderItemList.get(0).getPlanId().longValue());
            htxx.setZXJHBH(ordEcpPlanPO.getZxlsjhbh());
            OrdEcpPlanItemPO planItemPO = new OrdEcpPlanItemPO();
            planItemPO.setPlanId(ordEcpPlanPO.getPlanId());
            List list = this.ordEcpPlanItemMapper.getList(planItemPO);
            itemPOMap = list.stream().collect(Collectors.toMap(OrdEcpPlanItemPO::getPlanItemId, a -> a));
        }
        for (PebExtThirdSupplierSkuInfo skuInfo : saleOrderItemList) {
            PebIntfCreatePurchaseOrderContractDetailInfoBo infoBo = new PebIntfCreatePurchaseOrderContractDetailInfoBo();
            cghtjhmxlist.add(infoBo);
            infoBo.setCGWXMC(skuInfo.getSkuName());
            infoBo.setSL(skuInfo.getPurchaseCount());
            infoBo.setJLDW(skuInfo.getMeasureName());
            infoBo.setDJ(skuInfo.getSkuSalePrice().divide(new BigDecimal(10000)));
            infoBo.setZJ(infoBo.getDJ().multiply(skuInfo.getPurchaseCount()));
            if (itemPOMap != null) {
                infoBo.setWZJHBH(itemPOMap.get(skuInfo.getPlanItemId()).getJhmxbh());
                infoBo.setGGXHXMTZ(itemPOMap.get(skuInfo.getPlanItemId()).getWxfl());
            }
            infoBo.setWLBH(skuInfo.getSkuMaterialId());
            infoBo.setWXFL(skuInfo.getSkuMaterialName());
        }
        try {
            PebIntfCreatePurchaseOrderAbilityRspBo rspBo = new PebIntfCreatePurchaseOrderAbilityRspBo();
            rspBo = this.push(reqBo, rspBo);
            if ("0000".equals(rspBo.getRespCode())) {
                this.saveExt(saleRspBO.getOrderId(), "1");
            } else {
                this.saveExt(saleRspBO.getOrderId(), rspBo.getRespDesc());
            }
            this.saveLog(saleRspBO.getOrderId(), saleRspBO.getSaleVoucherId(), JSON.toJSONString((Object)reqBo), JSON.toJSONString((Object)rspBo), "\u4e0b\u5355\u540c\u6b65ecp\u7cfb\u7edf", rspBo.getRespCode());
        }
        catch (Exception e) {
            this.logger.error("\u8c03\u7528ecp\u91c7\u8d2d\u8ba2\u8ba2\u5355\u6570\u636e\u7ec4\u88c5\u5931\u8d25" + e);
            this.saveExt(saleRspBO.getOrderId(), "\u7ec4\u88c5\u53c2\u6570\u62a5\u9519");
        }
    }

    private PebIntfCreatePurchaseOrderAbilityRspBo push(PebIntfCreatePurchaseOrderAbilityReqBo reqBo, PebIntfCreatePurchaseOrderAbilityRspBo rspBo) {
        return this.pebIntfCreatePurchaseOrderAbilityService.createPurchaseOrder(reqBo);
    }

    private void saveLog(Long orderId, Long saleId, String in, String out, String code, String errCode) {
        if (StringUtils.isBlank((CharSequence)in)) {
            in = "in";
        }
        if (StringUtils.isBlank((CharSequence)out)) {
            out = "out";
        }
        int max = 3096;
        if (in.length() > max) {
            in = in.substring(0, max - 1);
        }
        if (out.length() > max) {
            out = out.substring(0, max - 1);
        }
        OrdInterLogBO logBO = new OrdInterLogBO();
        logBO.setCallCount(Integer.valueOf(1));
        logBO.setCallState("1");
        logBO.setCallTime(new Date());
        logBO.setCreateLoginId("1");
        logBO.setErrCode(errCode);
        logBO.setErrDetail("1");
        logBO.setFlowFlag(Integer.valueOf(1));
        logBO.setInContent(in);
        logBO.setInterCode(code);
        logBO.setInterSn("1");
        logBO.setOutContent(out);
        logBO.setRetTime(new Date());
        logBO.setOrderId(orderId);
        logBO.setObjId(saleId);
        logBO.setObjType(UocConstant.OBJ_TYPE.SALE);
        PebExtFieldInReqBO reqBO = new PebExtFieldInReqBO();
        reqBO.setLog(logBO);
        try {
            this.pebExtFieldInBusiService.dealSaveLog(reqBO);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void cancel(OrdSaleRspBO saleRspBO, Long userId, String desc, Map<String, String> skuAndPlanItemIdMap, String orgPath) {
        UocPebOrderCancelReqBO cancelReqBO = new UocPebOrderCancelReqBO();
        cancelReqBO.setOrderId(saleRspBO.getOrderId());
        cancelReqBO.setSaleVoucherId(saleRspBO.getSaleVoucherId());
        cancelReqBO.setIsCancelWF(Boolean.valueOf(false));
        cancelReqBO.setFailCode("8888");
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("cancelFlag", "1");
        cancelReqBO.setVariables(map);
        cancelReqBO.setCancelDesc(desc);
        cancelReqBO.setCancelReason(desc);
        this.updateOrder(saleRspBO.getOrderId());
        this.uocPebOrderCancelBusiService.dealOrderCancel(cancelReqBO);
        this.addCart(saleRspBO.getOrderId(), saleRspBO.getSaleVoucherId(), userId, skuAndPlanItemIdMap, orgPath);
    }

    private String getEmpCod(Long userId) {
        MemDetailQueryReqBO reqBO = new MemDetailQueryReqBO();
        reqBO.setUserIdWeb(userId);
        MemDetailQueryRspBO rspBO = this.pebIntfMemDetailQueryAbilityService.memDetailQuery(reqBO);
        return rspBO.getUmcMemDetailInfoAbilityRspBO().getOccupation();
    }

    private void saveExt(Long orderId, String val) {
        PebExtFieldInReqBO pebExtFieldInReqBO = new PebExtFieldInReqBO();
        pebExtFieldInReqBO.setObjType(UocCoreConstant.OBJ_TYPE.ORDER);
        pebExtFieldInReqBO.setObjId(orderId);
        pebExtFieldInReqBO.setOrderId(orderId);
        ArrayList<FieldValueBO> fieldValueBOS = new ArrayList<FieldValueBO>();
        FieldValueBO valueBO = new FieldValueBO();
        valueBO.setFieldValue(val);
        valueBO.setFieldCode("isSuccess");
        valueBO.setFieldName("\u662f\u5426\u63a8\u9001ecp");
        fieldValueBOS.add(valueBO);
        pebExtFieldInReqBO.setExtFieldList(fieldValueBOS);
        this.pebExtFieldInBusiService.dealCoreExtFieldIn(pebExtFieldInReqBO);
    }

    private void addPreFalg(OrdSaleRspBO order) {
        UocAddOrdExtMapReqBO reqBO = new UocAddOrdExtMapReqBO();
        reqBO.setOrderId(order.getOrderId());
        reqBO.setObjId(order.getOrderId());
        reqBO.setObjType(UocConstant.OBJ_TYPE.ORDER);
        reqBO.setFieldCode("preOrder");
        reqBO.setFieldValue(String.valueOf(UocConstant.PRE_ORDER.NO));
        try {
            UocAddOrdExtMapRsqBO rsqBO = this.uocAddExtMapAtomService.add(reqBO);
            if (!"0000".equals(rsqBO.getRespCode())) {
                this.logger.error("\u8ba2\u5355\u4e0b\u5355\u8bbe\u7f6e\u9884\u8ba2\u5355\u6807\u8bc6\u6d88\u8d39\u5931\u8d25,\u8ba2\u5355id:" + order.getOrderId() + "msg\uff1a" + rsqBO.getRespDesc());
            }
        }
        catch (Exception e) {
            this.logger.error("\u8ba2\u5355\u4e0b\u5355\u8bbe\u7f6e\u9884\u8ba2\u5355\u6807\u8bc6\u6d88\u8d39\u5931\u8d25,\u8ba2\u5355id:" + order.getOrderId() + "msg\uff1a" + e.getMessage());
        }
    }

    private void uocPebOrdIdxSync(PebExtThirdSupplierSubmitOrderSaleItemRspBO rspBO) {
        try {
            PebExtOrdIdxSyncReqBO reqBO = new PebExtOrdIdxSyncReqBO();
            reqBO.setObjId(Long.valueOf(rspBO.getSaleOrderId()));
            reqBO.setOrderId(rspBO.getOrderId());
            reqBO.setObjType(UocConstant.OBJ_TYPE.SALE);
            reqBO.setIsStatistics(Boolean.valueOf(false));
            this.uocPebSyncOrderListMqServiceProvider.send(new ProxyMessage(this.orderSyncTopic, this.orderSyncTag, JSON.toJSONString((Object)reqBO)));
            UocSyncStatisticsInfoCombReqBO syncStatisticsInfoCombReqBO = new UocSyncStatisticsInfoCombReqBO();
            syncStatisticsInfoCombReqBO.setOrderId(rspBO.getOrderId());
            syncStatisticsInfoCombReqBO.setSaleVoucherId(Long.valueOf(rspBO.getSaleOrderId()));
            syncStatisticsInfoCombReqBO.setIsLess(Boolean.valueOf(false));
            this.uocSyncStatisticsInfoCombService.syncStatisticsInfo(syncStatisticsInfoCombReqBO);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

