/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.order.impl.busi.saleorder;

import com.alibaba.fastjson.JSON;
import com.tydic.order.atom.PebExtQrySkuInfoAndPriceAtomService;
import com.tydic.order.atom.order.bo.SkuInfoRspBO;
import com.tydic.order.bo.common.UmcSettlementModeBO;
import com.tydic.order.bo.common.UocProMergeOrderFailedCommodityBo;
import com.tydic.order.bo.order.UocCoreActiveReqBO;
import com.tydic.order.bo.saleorder.PebExtAddressInfoIntfceReqBO;
import com.tydic.order.bo.saleorder.PebExtSaleOrderInfoIntfceReqBO;
import com.tydic.order.bo.saleorder.PebExtThirdSupplierCreateOrderReqBO;
import com.tydic.order.bo.saleorder.PebExtThirdSupplierCreateOrderRspBO;
import com.tydic.order.bo.saleorder.PebExtThirdSupplierSkuInfo;
import com.tydic.order.bo.saleorder.atom.PebExtQrySkuInfoAndPriceReqBO;
import com.tydic.order.bo.saleorder.atom.PebExtQrySkuInfoAndPriceRspBO;
import com.tydic.order.bo.saleorder.common.SaleOrderItemIntfceBO;
import com.tydic.order.busi.saleorder.PebExtThCreateOrderCheckBusiService;
import com.tydic.order.constant.PebExtConstant;
import com.tydic.order.constant.UocConstant;
import com.tydic.order.extend.dao.OrdEcpPlanMapper;
import com.tydic.order.extend.dao.po.OrdEcpPlanPO;
import com.tydic.order.impl.utils.OrderGenerateIdUtil;
import com.tydic.order.impl.utils.OrderPropertiesUtil;
import com.tydic.order.third.intf.ability.act.PebIntfQueryActivityDetailAbilityService;
import com.tydic.order.third.intf.ability.fsc.PebIntfPayConfigDetailQryDetailService;
import com.tydic.order.third.intf.ability.umc.PebIntfSgOrgAmountDeductAbilityService;
import com.tydic.order.third.intf.ability.umc.PebIntfWalletConsumeAbilityService;
import com.tydic.order.third.intf.bo.act.QueryActivityDetailReqBO;
import com.tydic.order.third.intf.bo.act.QueryActivityDetailRspBO;
import com.tydic.order.third.intf.bo.fsc.BusiAddPayConfigExceptReqBO;
import com.tydic.order.third.intf.bo.pay.BusiAddPayConfigExceptRspBO;
import com.tydic.order.third.intf.bo.umc.WalletConsumeReqBO;
import com.tydic.order.third.intf.bo.umc.WalletConsumeRspBO;
import com.tydic.order.uoc.dao.OrdInterLogMapper;
import com.tydic.order.uoc.dao.po.OrdInterLogPO;
import com.tydic.uoc.base.exception.UocProBusinessException;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

@Service
public class PebExtThCreateOrderCheckBusiServiceImpl
implements PebExtThCreateOrderCheckBusiService {
    @Autowired
    private PebExtQrySkuInfoAndPriceAtomService uocPebQrySkuInfoAndPriceAtomService;
    @Autowired
    private PebIntfSgOrgAmountDeductAbilityService pebIntfSgOrgAmountDeductAbilityService;
    @Autowired
    private OrdInterLogMapper ordInterLogMapper;
    @Autowired
    private OrderGenerateIdUtil idUtil;
    private static final Logger log = LoggerFactory.getLogger(PebExtThCreateOrderCheckBusiService.class);
    @Autowired
    private OrdEcpPlanMapper ordEcpPlanMapper;
    @Value(value="${busiMode:0}")
    private String busiMode;
    @Autowired
    private PebIntfWalletConsumeAbilityService pebIntfWalletConsumeAbilityService;
    @Autowired
    private PebIntfPayConfigDetailQryDetailService pebIntfPayConfigDetailQryDetailService;
    @Autowired
    private PebIntfQueryActivityDetailAbilityService pebIntfQueryActivityDetailAbilityService;
    @Value(value="${staff.welfare.pay.config.enable:false}")
    private boolean payConfig;

    public PebExtThirdSupplierCreateOrderRspBO dealPebCreateOrderCheck(PebExtThirdSupplierCreateOrderReqBO reqBO) {
        PebExtThirdSupplierCreateOrderRspBO rspBO = new PebExtThirdSupplierCreateOrderRspBO();
        ArrayList<String> skuIds = new ArrayList<String>();
        this.act(reqBO);
        this.getPay(reqBO);
        PebExtQrySkuInfoAndPriceReqBO pebExtQrySkuInfoAndPriceReqBO = this.buildQrySkuInfoAndPriceParam(reqBO, skuIds);
        pebExtQrySkuInfoAndPriceReqBO.setSettlementModeList(reqBO.getSettlementModeList());
        PebExtQrySkuInfoAndPriceRspBO pebExtQrySkuInfoAndPriceRspBO = this.uocPebQrySkuInfoAndPriceAtomService.qrySkuInfoAndPrice(pebExtQrySkuInfoAndPriceReqBO);
        if (!"0000".equals(pebExtQrySkuInfoAndPriceRspBO.getRespCode())) {
            throw new UocProBusinessException("8888", "\u5546\u54c1\u4fe1\u606f\u67e5\u8be2\u5931\u8d25!" + pebExtQrySkuInfoAndPriceRspBO.getRespDesc());
        }
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("\u6210\u529f");
        this.saveFailedSku(rspBO, skuIds, pebExtQrySkuInfoAndPriceRspBO.getSkuInfoMapList(), reqBO);
        HashMap<Long, BigDecimal> plan = new HashMap<Long, BigDecimal>();
        this.dealSkuInfo(pebExtQrySkuInfoAndPriceRspBO.getSkuInfoMapList(), reqBO, plan);
        return rspBO;
    }

    private void act(PebExtThirdSupplierCreateOrderReqBO reqBO) {
        if (CollectionUtils.isEmpty((Collection)reqBO.getActiveBOList())) {
            return;
        }
        QueryActivityDetailReqBO detailReqBO = new QueryActivityDetailReqBO();
        detailReqBO.setActiveId(Long.valueOf(((UocCoreActiveReqBO)reqBO.getActiveBOList().get(0)).getActiveId()));
        QueryActivityDetailRspBO detailRspBO = this.pebIntfQueryActivityDetailAbilityService.queryActiveDetailNew(detailReqBO);
        if (!"0000".equals(detailRspBO.getRespCode())) {
            throw new UocProBusinessException("10005", "\u67e5\u8be2\u6d3b\u52a8\u5931\u8d25" + detailRspBO.getRespDesc());
        }
        if (detailRspBO.getActivityDetailInfoBO() == null) {
            throw new UocProBusinessException("10005", "\u67e5\u8be2\u6d3b\u52a8\u4e3a\u7a7a");
        }
        if (detailRspBO.getActivityDetailInfoBO().getActivityBo() == null) {
            throw new UocProBusinessException("10005", "\u67e5\u8be2\u6d3b\u52a8\u4e3a\u7a7a");
        }
        Integer status = 4;
        if (!status.equals(detailRspBO.getActivityDetailInfoBO().getActivityBo().getActiveStatus())) {
            throw new UocProBusinessException("10005", "\u60a8\u6240\u53c2\u4e0e\u7684\u6d3b\u52a8\u5df2\u5931\u6548\uff0c\u8bf7\u77e5\u6653");
        }
        if (StringUtils.isBlank((CharSequence)((UocCoreActiveReqBO)reqBO.getActiveBOList().get(0)).getTypeName())) {
            ((UocCoreActiveReqBO)reqBO.getActiveBOList().get(0)).setTypeName(detailRspBO.getActivityDetailInfoBO().getActivityBo().getActiveField2Str());
        }
        reqBO.setActiveNo(detailRspBO.getActivityDetailInfoBO().getActivityBo().getActiveCode());
    }

    private void getPay(PebExtThirdSupplierCreateOrderReqBO reqBO) {
        BusiAddPayConfigExceptReqBO exceptReqBO = new BusiAddPayConfigExceptReqBO();
        if (CollectionUtils.isNotEmpty((Collection)reqBO.getActiveBOList())) {
            exceptReqBO.setPayBusiType("3");
        } else {
            exceptReqBO.setPayBusiType("0");
        }
        if (PebExtConstant.OrderType.DA.equals(reqBO.getOrderType())) {
            exceptReqBO.setPayBusiType("7");
        }
        exceptReqBO.setExceptId(reqBO.getCompanyId());
        String in = "0";
        String out = "1";
        String p = "0";
        String dept = "1";
        switch (reqBO.getMemUserType()) {
            case "1": {
                exceptReqBO.setPaySubClass(out);
                exceptReqBO.setPaySubType(p);
                break;
            }
            case "2": {
                exceptReqBO.setPaySubClass(out);
                exceptReqBO.setPaySubType(dept);
                break;
            }
            case "3": {
                exceptReqBO.setPaySubClass(in);
                exceptReqBO.setPaySubType(p);
                break;
            }
            default: {
                exceptReqBO.setPaySubClass(in);
                exceptReqBO.setPaySubType(dept);
            }
        }
        BusiAddPayConfigExceptRspBO rspBO = this.pebIntfPayConfigDetailQryDetailService.qryPayConfigDetailOrPayConfig(exceptReqBO);
        if (!"0000".equals(rspBO.getRespCode())) {
            throw new UocProBusinessException(rspBO.getRespCode(), "\u67e5\u8be2\u652f\u4ed8\u914d\u7f6e\u5931\u8d25\uff1a" + rspBO.getRespDesc());
        }
        if (rspBO.getBalance() == null || "2".equals(rspBO.getPayType())) {
            // empty if block
        }
        reqBO.setPayType(Integer.valueOf(Integer.parseInt(rspBO.getPayType())));
        reqBO.setPayConfig(rspBO);
    }

    private void check(PebExtThirdSupplierCreateOrderReqBO reqBO) {
        if (CollectionUtils.isEmpty((Collection)reqBO.getActiveBOList())) {
            return;
        }
        WalletConsumeReqBO walletConsumeReqBO = new WalletConsumeReqBO();
        walletConsumeReqBO.setConsumeAmount(reqBO.getTotalAmount());
        walletConsumeReqBO.setCheckFlag(Integer.valueOf(1));
        walletConsumeReqBO.setMemId(reqBO.getMemId());
        walletConsumeReqBO.setWalletType(Integer.valueOf(5));
        walletConsumeReqBO.setActivityCode(((UocCoreActiveReqBO)reqBO.getActiveBOList().get(0)).getActiveId());
        WalletConsumeRspBO rspBO = this.pebIntfWalletConsumeAbilityService.walletConsume(walletConsumeReqBO);
        if (!"0000".equals(rspBO.getRespCode())) {
            throw new UocProBusinessException(rspBO.getRespCode(), rspBO.getRespDesc());
        }
    }

    private void checkMode(PebExtThirdSupplierCreateOrderReqBO reqBO) {
        if (CollectionUtils.isNotEmpty((Collection)reqBO.getSettlementModeList())) {
            for (UmcSettlementModeBO modeBO : reqBO.getSettlementModeList()) {
                if (!modeBO.getSubtype().equals(PebExtConstant.Subtype.AGR)) continue;
                reqBO.setBusiMode(modeBO.getBusiMode());
                return;
            }
        }
        if (StringUtils.isBlank((CharSequence)reqBO.getBusiMode())) {
            reqBO.setBusiMode(this.busiMode);
        }
    }

    private void checkPlan(Map<Long, BigDecimal> plan, PebExtThirdSupplierCreateOrderReqBO reqBO) {
        if (plan.size() == 0) {
            return;
        }
        for (Long id : plan.keySet()) {
            OrdEcpPlanPO ecpPlanPO = this.ordEcpPlanMapper.getModelById(id.longValue());
            ArrayList<String> list = new ArrayList<String>();
            if (ecpPlanPO == null) {
                this.getStr(list, reqBO, id);
                throw new UocProBusinessException("8888", "\u8ba1\u5212\u660e\u7ec6\u7f16\u53f7\u4e3a\uff1a" + ((Object)list).toString() + "\u7684\u8ba1\u5212\u4e0d\u5b58\u5728");
            }
            if (!ecpPlanPO.getStatus().equals(PebExtConstant.PlanStatus.DOING) && !ecpPlanPO.getStatus().equals(PebExtConstant.PlanStatus.TODO)) {
                this.getStr(list, reqBO, id);
                throw new UocProBusinessException("8888", "\u8ba1\u5212\u660e\u7ec6\u7f16\u53f7\u4e3a\uff1a" + ((Object)list).toString() + "\u8ba1\u5212\u5f53\u524d\u72b6\u6001\u4e0d\u80fd\u4e0b\u5355");
            }
            if (ecpPlanPO.getUsed() == null) {
                ecpPlanPO.setUsed(BigDecimal.ZERO);
            }
            if (ecpPlanPO.getYsje().subtract(ecpPlanPO.getUsed()).multiply(new BigDecimal(10000)).multiply(new BigDecimal(10000)).subtract(plan.get(id)).compareTo(BigDecimal.ZERO) >= 1) continue;
            this.getStr(list, reqBO, id);
            throw new UocProBusinessException("8888", "\u8ba1\u5212\u660e\u7ec6\u7f16\u53f7\u4e3a\uff1a" + ((Object)list).toString() + "\u4e0b\u5355\u540e\u6267\u884c\u91d1\u989d\u5927\u4e8e\u9884\u7b97\u91d1\u989d");
        }
    }

    private void getStr(List<String> list, PebExtThirdSupplierCreateOrderReqBO reqBO, Long planId) {
        for (PebExtThirdSupplierSkuInfo skuInfo : reqBO.getSaleOrderItemList()) {
            if (!planId.equals(skuInfo.getPlanId())) continue;
            list.add(skuInfo.getPlanItemNo());
        }
    }

    private void dealSkuInfo(List<Map<Long, Object>> skuInfoMapList, PebExtThirdSupplierCreateOrderReqBO reqBO, Map<Long, BigDecimal> plan) {
        ArrayList<PebExtThirdSupplierSkuInfo> saleOrderItemList = new ArrayList<PebExtThirdSupplierSkuInfo>(reqBO.getSaleOrderItemList().size());
        long total = 0L;
        ArrayList<String> soldOut = new ArrayList<String>();
        ArrayList<String> inventoryShortage = new ArrayList<String>();
        for (PebExtThirdSupplierSkuInfo skuInfo : reqBO.getSaleOrderItemList()) {
            for (Map<Long, Object> map : skuInfoMapList) {
                SkuInfoRspBO rspBO = (SkuInfoRspBO)map.get(Long.valueOf(skuInfo.getSkuId()));
                if (rspBO == null || !skuInfo.getSkuId().equals(rspBO.getSkuId())) continue;
                BigDecimal itemFee = skuInfo.getPurchaseCount().multiply(rspBO.getSkuSalePrice());
                total += itemFee.longValue();
                PebExtThirdSupplierSkuInfo pebExtThirdSupplierSkuInfo = this.copy(rspBO, skuInfo, reqBO);
                saleOrderItemList.add(pebExtThirdSupplierSkuInfo);
                if (skuInfo.getPlanItemId() != null && skuInfo.getPlanItemId() != 0L) {
                    if (plan.get(skuInfo.getPlanId()) == null) {
                        plan.put(skuInfo.getPlanId(), skuInfo.getPurchaseCount().multiply(skuInfo.getSkuSalePrice()));
                    } else {
                        BigDecimal price = plan.get(skuInfo.getPlanId());
                        price = price.add(skuInfo.getPurchaseCount().multiply(skuInfo.getSkuSalePrice()));
                        plan.put(skuInfo.getPlanId(), price);
                    }
                }
                if (rspBO.getSoldNumber() == null || rspBO.getSoldNumber().compareTo(new BigDecimal(-1)) == 0) continue;
                if (rspBO.getSoldNumber().compareTo(BigDecimal.ZERO) == 0) {
                    soldOut.add(rspBO.getSkuExtSkuId());
                    continue;
                }
                if (rspBO.getSoldNumber().compareTo(skuInfo.getPurchaseCount()) >= 0) continue;
                inventoryShortage.add(rspBO.getSkuExtSkuId());
            }
        }
        if (soldOut.size() > 0 || inventoryShortage.size() > 0) {
            String msg = "";
            if (soldOut.size() > 0) {
                msg = msg + "\u5546\u54c1\u7f16\u7801\u4e3a\uff1a" + ((Object)soldOut).toString() + "\u7684\u5546\u54c1\u65e0\u8d27\u3002";
            }
            if (inventoryShortage.size() > 0) {
                msg = msg + "\u5546\u54c1\u7f16\u7801\u4e3a\uff1a" + ((Object)inventoryShortage).toString() + "\u7684\u5546\u54c1\u5e93\u5b58\u4e0d\u8db3\u3002";
            }
            msg = msg + "\u8bf7\u91cd\u65b0\u9009\u8d2d\u5546\u54c1";
            throw new UocProBusinessException("8888", msg);
        }
        for (PebExtThirdSupplierSkuInfo skuInfo : saleOrderItemList) {
            List list;
            if (reqBO.getSplitGoods().size() > 0 && (list = (List)reqBO.getSplitGoods().get(skuInfo.getGoodsSupplierId())) != null) {
                for (PebExtThirdSupplierSkuInfo supplierSkuInfo : list) {
                    if (!supplierSkuInfo.getSkuId().equals(skuInfo.getSkuId())) continue;
                    BeanUtils.copyProperties((Object)skuInfo, (Object)supplierSkuInfo);
                }
            }
            if (reqBO.getJcSplitGoods().size() > 0 && (list = (List)reqBO.getJcSplitGoods().get(skuInfo.getGoodsSupplierId())) != null) {
                for (PebExtThirdSupplierSkuInfo supplierSkuInfo : list) {
                    if (!supplierSkuInfo.getSkuId().equals(skuInfo.getSkuId())) continue;
                    BeanUtils.copyProperties((Object)skuInfo, (Object)supplierSkuInfo);
                }
            }
            if (reqBO.getPlanSplitGoods().size() > 0 && (list = (List)reqBO.getPlanSplitGoods().get(skuInfo.getGoodsSupplierId())) != null) {
                for (PebExtThirdSupplierSkuInfo supplierSkuInfo : list) {
                    if (!supplierSkuInfo.getSkuId().equals(skuInfo.getSkuId())) continue;
                    BeanUtils.copyProperties((Object)skuInfo, (Object)supplierSkuInfo);
                }
            }
            if (reqBO.getJcPlanSplitGoods().size() > 0 && (list = (List)reqBO.getJcPlanSplitGoods().get(skuInfo.getGoodsSupplierId())) != null) {
                for (PebExtThirdSupplierSkuInfo supplierSkuInfo : list) {
                    if (!supplierSkuInfo.getSkuId().equals(skuInfo.getSkuId())) continue;
                    BeanUtils.copyProperties((Object)skuInfo, (Object)supplierSkuInfo);
                }
            }
            if (reqBO.getMroSplitGoods().size() > 0 && (list = (List)reqBO.getMroSplitGoods().get(skuInfo.getGoodsSupplierId())) != null) {
                for (PebExtThirdSupplierSkuInfo supplierSkuInfo : list) {
                    if (!supplierSkuInfo.getSkuId().equals(skuInfo.getSkuId())) continue;
                    BeanUtils.copyProperties((Object)skuInfo, (Object)supplierSkuInfo);
                }
            }
            if (reqBO.getJcMroSplitGoods().size() > 0 && (list = (List)reqBO.getJcMroSplitGoods().get(skuInfo.getGoodsSupplierId())) != null) {
                for (PebExtThirdSupplierSkuInfo supplierSkuInfo : list) {
                    if (!supplierSkuInfo.getSkuId().equals(skuInfo.getSkuId())) continue;
                    BeanUtils.copyProperties((Object)skuInfo, (Object)supplierSkuInfo);
                }
            }
            if (reqBO.getMroPlanSplitGoods().size() > 0 && (list = (List)reqBO.getMroPlanSplitGoods().get(skuInfo.getGoodsSupplierId())) != null) {
                for (PebExtThirdSupplierSkuInfo supplierSkuInfo : list) {
                    if (!supplierSkuInfo.getSkuId().equals(skuInfo.getSkuId())) continue;
                    BeanUtils.copyProperties((Object)skuInfo, (Object)supplierSkuInfo);
                }
            }
            if (reqBO.getJcMroPlanSplitGoods().size() <= 0 || (list = (List)reqBO.getJcMroPlanSplitGoods().get(skuInfo.getGoodsSupplierId())) == null) continue;
            for (PebExtThirdSupplierSkuInfo supplierSkuInfo : list) {
                if (!supplierSkuInfo.getSkuId().equals(skuInfo.getSkuId())) continue;
                BeanUtils.copyProperties((Object)skuInfo, (Object)supplierSkuInfo);
            }
        }
        reqBO.setSaleOrderItemList(saleOrderItemList);
        total /= 10000L;
    }

    private PebExtThirdSupplierSkuInfo copy(SkuInfoRspBO source, PebExtThirdSupplierSkuInfo skuInfo, PebExtThirdSupplierCreateOrderReqBO reqBO) {
        PebExtThirdSupplierSkuInfo pebExtThirdSupplierSkuInfo = new PebExtThirdSupplierSkuInfo();
        BeanUtils.copyProperties((Object)source, (Object)pebExtThirdSupplierSkuInfo);
        pebExtThirdSupplierSkuInfo.setComparisonGoodsNo(skuInfo.getComparisonGoodsNo());
        pebExtThirdSupplierSkuInfo.setGoodsSupplierId(skuInfo.getGoodsSupplierId());
        pebExtThirdSupplierSkuInfo.setPlanItemId(skuInfo.getPlanItemId());
        pebExtThirdSupplierSkuInfo.setSkuMaterialId(skuInfo.getSkuMaterialId());
        pebExtThirdSupplierSkuInfo.setSkuMaterialName(skuInfo.getSkuMaterialName());
        pebExtThirdSupplierSkuInfo.setSkuMaterialTypeId(skuInfo.getSkuMaterialTypeId());
        pebExtThirdSupplierSkuInfo.setSkuMaterialTypeName(skuInfo.getSkuMaterialTypeName());
        pebExtThirdSupplierSkuInfo.setPurchaseCount(skuInfo.getPurchaseCount());
        pebExtThirdSupplierSkuInfo.setPurchType(skuInfo.getPurchType());
        pebExtThirdSupplierSkuInfo.setChannel(skuInfo.getChannel());
        pebExtThirdSupplierSkuInfo.setPlanId(skuInfo.getPlanId());
        pebExtThirdSupplierSkuInfo.setVendorOrderType(skuInfo.getVendorOrderType());
        pebExtThirdSupplierSkuInfo.setIsMro(skuInfo.getIsMro());
        pebExtThirdSupplierSkuInfo.setSkuMaterialFee(skuInfo.getSkuMaterialFee());
        pebExtThirdSupplierSkuInfo.setSkuMaterialTotalFee(skuInfo.getSkuMaterialTotalFee());
        pebExtThirdSupplierSkuInfo.setSkuMaterialCount(skuInfo.getSkuMaterialCount());
        pebExtThirdSupplierSkuInfo.setSkuMaterialBrand(skuInfo.getSkuMaterialBrand());
        pebExtThirdSupplierSkuInfo.setSkuMaterialRemark(skuInfo.getSkuMaterialRemark());
        pebExtThirdSupplierSkuInfo.setContractId(source.getContractId());
        return pebExtThirdSupplierSkuInfo;
    }

    private void saveFailedSku(PebExtThirdSupplierCreateOrderRspBO rspBO, List<String> skuIds, List<Map<Long, Object>> skuInfoMapList, PebExtThirdSupplierCreateOrderReqBO reqBO) {
        Map<String, List<PebExtThirdSupplierSkuInfo>> items = reqBO.getSaleOrderItemList().stream().collect(Collectors.groupingBy(SkuInfoRspBO::getSkuId));
        if (skuInfoMapList != null && skuInfoMapList.size() > 0) {
            ArrayList<String> outSku = new ArrayList<String>();
            for (Map<Long, Object> map : skuInfoMapList) {
                for (Long key : map.keySet()) {
                    outSku.add(String.valueOf(key));
                }
            }
            if (outSku.size() >= skuIds.size()) {
                return;
            }
            StringBuilder sb = new StringBuilder();
            for (String id : skuIds) {
                if (outSku.contains(id)) continue;
                UocProMergeOrderFailedCommodityBo failCommodityBo = new UocProMergeOrderFailedCommodityBo();
                failCommodityBo.setImageUrl(items.get(id).get(0).getSkuMainPicUrl());
                failCommodityBo.setFailReason("\u5546\u54c1\u4e0d\u5b58\u5728\u6216\u5546\u54c1\u5f02\u5e38");
                failCommodityBo.setSkuName(items.get(id).get(0).getSkuName());
                failCommodityBo.setSupplierName(items.get(id).get(0).getSkuSupplierName());
                failCommodityBo.setSkuId(id);
                failCommodityBo.setSupplierId(items.get(id).get(0).getGoodsSupplierId());
                rspBO.getFailedCommodityBoList().add(failCommodityBo);
                sb.append(id).append(",");
            }
            OrdInterLogPO ordInterLogPO = new OrdInterLogPO();
            ordInterLogPO.setId(Long.valueOf(this.idUtil.nextId()));
            ordInterLogPO.setObjType(UocConstant.OBJ_TYPE.ORDER);
            ordInterLogPO.setOutContent(sb.toString() + "\u5546\u54c1\u6570\u636e\u6ca1\u67e5\u8be2\u5230");
            ordInterLogPO.setInContent(sb.toString());
            ordInterLogPO.setObjId(Long.valueOf(1L));
            ordInterLogPO.setOrderId(Long.valueOf(1L));
            ordInterLogPO.setInterSn("\u5546\u54c1\u63a5\u53e3");
            ordInterLogPO.setInterCode("sku");
            ordInterLogPO.setCreateTime(new Date());
            ordInterLogPO.setRetTime(new Date());
            ordInterLogPO.setCreateTime(new Date());
            ordInterLogPO.setErrDetail("\u5546\u54c1\u5f02\u5e38");
            try {
                this.ordInterLogMapper.insert(ordInterLogPO);
            }
            catch (Exception exception) {
                // empty catch block
            }
            rspBO.setRespCode("8888");
            rspBO.setRespDesc("\u5546\u54c1\u7801\u4e3a:" + sb.toString() + "\u7684\u5546\u54c1\u5f02\u5e38\uff0c\u8bf7\u9009\u62e9\u5176\u4ed6\u5546\u54c1\u6216\u8005\u7a0d\u540e\u518d\u8bd5");
            log.debug("\u5165\u53c2\u5546\u54c1" + JSON.toJSONString(skuIds));
            log.debug("\u51fa\u53c2\u5546\u54c1" + JSON.toJSONString(skuInfoMapList));
        }
    }

    private PebExtQrySkuInfoAndPriceReqBO buildQrySkuInfoAndPriceParam(PebExtThirdSupplierCreateOrderReqBO reqBO, List<String> skuIds) {
        PebExtAddressInfoIntfceReqBO addressInfo;
        PebExtQrySkuInfoAndPriceReqBO pebExtQrySkuInfoAndPriceReqBO = new PebExtQrySkuInfoAndPriceReqBO();
        pebExtQrySkuInfoAndPriceReqBO.setPurchaseAccountId(reqBO.getUserId());
        pebExtQrySkuInfoAndPriceReqBO.setUserId(reqBO.getUserId());
        pebExtQrySkuInfoAndPriceReqBO.setParentOrgIdIn(reqBO.getParentOrgIdIn());
        pebExtQrySkuInfoAndPriceReqBO.setRootOrgIdIn(reqBO.getRootOrgIdIn());
        pebExtQrySkuInfoAndPriceReqBO.setUserId(reqBO.getUserId());
        pebExtQrySkuInfoAndPriceReqBO.setOrgIdIn(reqBO.getOrgIdIn());
        pebExtQrySkuInfoAndPriceReqBO.setCompanyId(reqBO.getCompanyId());
        pebExtQrySkuInfoAndPriceReqBO.setIsprofess(reqBO.getIsprofess());
        pebExtQrySkuInfoAndPriceReqBO.setPsDiscountRate(reqBO.getPsDiscountRate());
        pebExtQrySkuInfoAndPriceReqBO.setOrderType(reqBO.getOrderType());
        if (CollectionUtils.isNotEmpty((Collection)reqBO.getActiveBOList()) && !this.payConfig) {
            pebExtQrySkuInfoAndPriceReqBO.setCompanyId(null);
            pebExtQrySkuInfoAndPriceReqBO.setIsprofess(null);
        }
        if (StringUtils.isNotBlank((CharSequence)(addressInfo = reqBO.getAddressInfo()).getReceiverCountyId())) {
            pebExtQrySkuInfoAndPriceReqBO.setCounty(Long.valueOf(addressInfo.getReceiverCountyId()));
        }
        if (StringUtils.isNotBlank((CharSequence)addressInfo.getReceiverProvinceId())) {
            pebExtQrySkuInfoAndPriceReqBO.setProvince(Long.valueOf(addressInfo.getReceiverProvinceId()));
        }
        if (StringUtils.isNotBlank((CharSequence)addressInfo.getReceiverCityId())) {
            pebExtQrySkuInfoAndPriceReqBO.setCity(Long.valueOf(addressInfo.getReceiverCityId()));
        }
        if (StringUtils.isNotBlank((CharSequence)addressInfo.getReceiverTownId())) {
            pebExtQrySkuInfoAndPriceReqBO.setTown(Long.valueOf(addressInfo.getReceiverTownId()));
        } else {
            pebExtQrySkuInfoAndPriceReqBO.setTown(Long.valueOf(0L));
        }
        Map<String, List<PebExtThirdSupplierSkuInfo>> skuInfo = reqBO.getSaleOrderItemList().stream().collect(Collectors.groupingBy(PebExtThirdSupplierSkuInfo::getGoodsSupplierId));
        ArrayList<PebExtSaleOrderInfoIntfceReqBO> saleOrderInfoList = new ArrayList<PebExtSaleOrderInfoIntfceReqBO>();
        HashMap splitGoods = new HashMap();
        HashMap planSplitGoods = new HashMap();
        HashMap jcSplitGoods = new HashMap();
        HashMap jcPlanSplitGoods = new HashMap();
        HashMap mroSplitGoods = new HashMap();
        HashMap mroPlanSplitGoods = new HashMap();
        HashMap mroJcSplitGoods = new HashMap();
        HashMap mroJcPlanSplitGoods = new HashMap();
        reqBO.setSplitGoods(splitGoods);
        reqBO.setPlanSplitGoods(planSplitGoods);
        reqBO.setJcPlanSplitGoods(jcPlanSplitGoods);
        reqBO.setJcSplitGoods(jcSplitGoods);
        reqBO.setMroSplitGoods(mroSplitGoods);
        reqBO.setMroPlanSplitGoods(mroPlanSplitGoods);
        reqBO.setJcMroSplitGoods(mroJcSplitGoods);
        reqBO.setJcMroPlanSplitGoods(mroJcPlanSplitGoods);
        reqBO.setHasMro(Boolean.valueOf(false));
        for (String key : skuInfo.keySet()) {
            ArrayList<SaleOrderItemIntfceBO> saleOrderItemList = new ArrayList<SaleOrderItemIntfceBO>();
            ArrayList<PebExtThirdSupplierSkuInfo> supplierSkuInfo = new ArrayList<PebExtThirdSupplierSkuInfo>();
            ArrayList<PebExtThirdSupplierSkuInfo> planSupplierSkuInfo = new ArrayList<PebExtThirdSupplierSkuInfo>();
            ArrayList<PebExtThirdSupplierSkuInfo> jcSupplierSkuInfo = new ArrayList<PebExtThirdSupplierSkuInfo>();
            ArrayList<PebExtThirdSupplierSkuInfo> jcPlanSupplierSkuInfo = new ArrayList<PebExtThirdSupplierSkuInfo>();
            ArrayList<PebExtThirdSupplierSkuInfo> mroSupplierSkuInfo = new ArrayList<PebExtThirdSupplierSkuInfo>();
            ArrayList<PebExtThirdSupplierSkuInfo> mroPlanSupplierSkuInfo = new ArrayList<PebExtThirdSupplierSkuInfo>();
            ArrayList<PebExtThirdSupplierSkuInfo> jcMroSupplierSkuInfo = new ArrayList<PebExtThirdSupplierSkuInfo>();
            ArrayList<PebExtThirdSupplierSkuInfo> jcMroPlanSupplierSkuInfo = new ArrayList<PebExtThirdSupplierSkuInfo>();
            for (PebExtThirdSupplierSkuInfo goods : skuInfo.get(key)) {
                skuIds.add(goods.getSkuId());
                SaleOrderItemIntfceBO itemIntfceBO = new SaleOrderItemIntfceBO();
                itemIntfceBO.setSkuId(goods.getSkuId());
                itemIntfceBO.setSkuSalePrice(goods.getSkuSalePrice());
                itemIntfceBO.setSupplierShopId(goods.getSupplierShopId());
                itemIntfceBO.setSpuId(goods.getSpuId());
                itemIntfceBO.setPurchaseCount(goods.getPurchaseCount());
                itemIntfceBO.setCount(goods.getPurchaseCount());
                if (OrderPropertiesUtil.getProperty((String)"SUPPLIER_DELI_ID").equals(goods.getGoodsSupplierId()) && PebExtConstant.IsMro.YES.equals(goods.getIsMro())) {
                    reqBO.setHasMro(Boolean.valueOf(true));
                    if (PebExtConstant.PurchType.PLAN.equals(goods.getPurchType())) {
                        if (PebExtConstant.Channel.JC.equals(goods.getChannel())) {
                            jcMroPlanSupplierSkuInfo.add(goods);
                        } else {
                            mroPlanSupplierSkuInfo.add(goods);
                        }
                    } else if (PebExtConstant.Channel.JC.equals(goods.getChannel())) {
                        jcMroSupplierSkuInfo.add(goods);
                    } else {
                        mroSupplierSkuInfo.add(goods);
                    }
                } else if (PebExtConstant.PurchType.PLAN.equals(goods.getPurchType())) {
                    if (PebExtConstant.Channel.JC.equals(goods.getChannel())) {
                        jcPlanSupplierSkuInfo.add(goods);
                    } else {
                        planSupplierSkuInfo.add(goods);
                    }
                } else if (PebExtConstant.Channel.JC.equals(goods.getChannel())) {
                    jcSupplierSkuInfo.add(goods);
                } else {
                    supplierSkuInfo.add(goods);
                }
                saleOrderItemList.add(itemIntfceBO);
            }
            if (planSupplierSkuInfo.size() > 0) {
                planSplitGoods.put(key, planSupplierSkuInfo);
            }
            if (jcPlanSupplierSkuInfo.size() > 0) {
                jcPlanSplitGoods.put(key, jcPlanSupplierSkuInfo);
            }
            if (supplierSkuInfo.size() > 0) {
                splitGoods.put(key, supplierSkuInfo);
            }
            if (jcSupplierSkuInfo.size() > 0) {
                jcSplitGoods.put(key, jcSupplierSkuInfo);
            }
            if (mroPlanSupplierSkuInfo.size() > 0) {
                mroPlanSplitGoods.put(key, mroPlanSupplierSkuInfo);
            }
            if (jcMroPlanSupplierSkuInfo.size() > 0) {
                mroJcPlanSplitGoods.put(key, jcMroPlanSupplierSkuInfo);
            }
            if (mroSupplierSkuInfo.size() > 0) {
                mroSplitGoods.put(key, mroSupplierSkuInfo);
            }
            if (jcMroSupplierSkuInfo.size() > 0) {
                mroJcSplitGoods.put(key, jcMroSupplierSkuInfo);
            }
            PebExtSaleOrderInfoIntfceReqBO saleOrderInfoIntfceReqBO = new PebExtSaleOrderInfoIntfceReqBO();
            saleOrderInfoIntfceReqBO.setGoodsSupplierId(Long.valueOf(key));
            saleOrderInfoIntfceReqBO.setSaleOrderItemList(saleOrderItemList);
            saleOrderInfoList.add(saleOrderInfoIntfceReqBO);
        }
        pebExtQrySkuInfoAndPriceReqBO.setSaleOrderInfoList(saleOrderInfoList);
        pebExtQrySkuInfoAndPriceReqBO.setReceiverProvinceId(addressInfo.getReceiverProvinceId());
        pebExtQrySkuInfoAndPriceReqBO.setReceiverCityId(addressInfo.getReceiverCityId());
        return pebExtQrySkuInfoAndPriceReqBO;
    }
}

