/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.order.third.intf.busi.impl.esb.order;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.cgd.base.util.http.HSHttpHelper;
import com.cgd.base.util.http.HSNHttpHeader;
import com.cgd.base.util.http.HttpRetBean;
import com.tydic.order.third.intf.bo.esb.order.SubmitOrderCommonReqBO;
import com.tydic.order.third.intf.bo.esb.order.SubmitOrderReqBO;
import com.tydic.order.third.intf.bo.esb.order.SubmitOrderRspBO;
import com.tydic.order.third.intf.bo.esb.order.SubmitOrderVO;
import com.tydic.order.third.intf.busi.esb.order.PebIntfSubmitOrderFromBusiService;
import com.tydic.order.third.intf.utils.ESBParamUtil;
import com.tydic.order.third.intf.utils.PropertiesUtil;
import com.tydic.uoc.base.exception.UocProBusinessException;
import java.net.URI;
import org.apache.http.Header;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import org.springframework.util.StringUtils;

@Service(value="pebIntfSubmitOrderFromBusiService")
public class PebIntfSubmitOrderFromBusiServiceImpl
implements PebIntfSubmitOrderFromBusiService {
    private static final Logger LOGGER = LoggerFactory.getLogger(PebIntfSubmitOrderFromBusiServiceImpl.class);
    private final boolean IS_DEBUG_ENABLED = LOGGER.isDebugEnabled();

    public SubmitOrderRspBO submitOrder(SubmitOrderReqBO submitOrderReqBO) {
        SubmitOrderRspBO resolveRsp;
        try {
            String reqStr = this.initPostStr(submitOrderReqBO);
            String callUrl = null;
            callUrl = PropertiesUtil.getProperty("SUPPLIER_JD_ID").equals(submitOrderReqBO.getSupplierId().toString()) ? PropertiesUtil.getProperty("ESB_JD_SUBMIT_ORDER_URL") : PropertiesUtil.getProperty("ESB_SUBMIT_ORDER_URL");
            HttpRetBean httpRetBean = HSHttpHelper.doUrlPostRequest((URI)new URI(callUrl), (Header[])HSNHttpHeader.getRequestHeaders((String)"json"), (byte[])reqStr.getBytes("UTF-8"), (String)"UTF-8", (Boolean)false);
            if (httpRetBean.getStatus() != 200) {
                throw new UocProBusinessException("2000", "\u9884\u8ba2\u5355\u751f\u6210\u4e1a\u52a1\u670d\u52a1\u8c03\u7528ESB\u7edf\u4e00\u4e0b\u5355\u670d\u52a1\u63a5\u53e3\u5931\u8d25[http_status=" + httpRetBean.getStatus() + "], [http_url=" + PropertiesUtil.getProperty("ESB_SUBMIT_ORDER_URL") + "]");
            }
            String returnString = httpRetBean.getStr();
            if (StringUtils.isEmpty((Object)returnString)) {
                throw new UocProBusinessException("2001", "\u4e1a\u52a1\u670d\u52a1\u8c03\u7528ESB\u7edf\u4e00\u4e0b\u5355\u670d\u52a1\u63a5\u53e3\u7cfb\u7edf\u54cd\u5e94\u62a5\u6587\u4e3a\u7a7a\uff01");
            }
            resolveRsp = this.resolveRsp(returnString);
        }
        catch (Exception e) {
            LOGGER.error("\u9884\u8ba2\u5355\u751f\u6210\u4e1a\u52a1\u670d\u52a1\u8c03\u7528ESB\u7edf\u4e00\u4e0b\u5355\u670d\u52a1\u63a5\u53e3\u5f02\u5e38:" + e.getMessage());
            throw new UocProBusinessException("6000", "\u9884\u8ba2\u5355\u751f\u6210\u4e1a\u52a1\u670d\u52a1\u8c03\u7528ESB\u7edf\u4e00\u4e0b\u5355\u670d\u52a1\u63a5\u53e3\u5f02\u5e38");
        }
        return resolveRsp;
    }

    private String initPostStr(SubmitOrderReqBO submitOrderReqBO) {
        String esbReqParam;
        String hsn = PropertiesUtil.getProperty("SUPPLIER_ID_" + submitOrderReqBO.getSupplierId());
        if (PropertiesUtil.getProperty("SUPPLIER_JD_ID").equals(submitOrderReqBO.getSupplierId().toString())) {
            esbReqParam = ESBParamUtil.getEsbReqParam(submitOrderReqBO, hsn, "BUSINESS_ORDER");
        } else {
            if (PropertiesUtil.getProperty("SUPPLIER_QST_ID").equals(submitOrderReqBO.getSupplierId().toString())) {
                submitOrderReqBO.setSubmitOrg(submitOrderReqBO.getPurchaseName());
            }
            SubmitOrderCommonReqBO submitOrderCommonReqBO = new SubmitOrderCommonReqBO();
            SubmitOrderCommonReqBO transformation = submitOrderCommonReqBO.transformation(submitOrderReqBO);
            esbReqParam = ESBParamUtil.getEsbReqParam(transformation, hsn, "BUSINESS_ORDER");
        }
        if (this.IS_DEBUG_ENABLED) {
            LOGGER.debug("\u8c03\u7528\u9884\u8ba2\u5355\u751f\u6210ESB\u63a5\u53e3\u8bf7\u6c42\u62a5\u6587\uff1a" + esbReqParam);
        }
        return esbReqParam;
    }

    private SubmitOrderRspBO resolveRsp(String returnString) {
        LOGGER.debug("\u8c03\u7528\u9884\u8ba2\u5355\u751f\u6210ESB\u63a5\u53e3\u8fd4\u56de\u6570\u636e\uff1a" + returnString);
        SubmitOrderRspBO submitOrderRsp = new SubmitOrderRspBO();
        JSONObject rspJsonObject = JSONObject.parseObject((String)returnString);
        if (rspJsonObject.getBoolean("success").booleanValue()) {
            submitOrderRsp.setRespCode("0000");
            submitOrderRsp.setRespDesc("\u6210\u529f");
            JSONObject jsonObject = (JSONObject)rspJsonObject.get((Object)"result");
            SubmitOrderVO submitOrder = (SubmitOrderVO)JSON.parseObject((String)jsonObject.toJSONString(), SubmitOrderVO.class);
            submitOrderRsp.setResult(submitOrder);
            return submitOrderRsp;
        }
        submitOrderRsp.setRespCode((String)rspJsonObject.get((Object)"resultCode"));
        submitOrderRsp.setRespDesc((String)rspJsonObject.get((Object)"resultMessage"));
        return submitOrderRsp;
    }
}

