/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.order.third.intf.busi.impl.lm.afs;

import com.alibaba.fastjson.JSONObject;
import com.cgd.base.util.http.HSHttpHelper;
import com.cgd.base.util.http.HSNHttpHeader;
import com.cgd.base.util.http.HttpRetBean;
import com.tydic.order.third.intf.bo.lm.lm.afs.CancelRefundReqBO;
import com.tydic.order.third.intf.bo.lm.lm.afs.CancelRefundRspBO;
import com.tydic.order.third.intf.bo.lm.lm.afs.QryRefundOrderDetailReqBO;
import com.tydic.order.third.intf.bo.lm.lm.afs.QryRefundOrderDetailRspBO;
import com.tydic.order.third.intf.bo.lm.lm.afs.RefundApplicationDataRspBO;
import com.tydic.order.third.intf.busi.lm.afs.LmIntfCancelRefundBusiService;
import com.tydic.order.third.intf.busi.lm.afs.LmIntfQryRefundOrderDetailBusiService;
import com.tydic.order.third.intf.utils.LmSignUtil;
import com.tydic.order.third.intf.utils.PropertiesUtil;
import com.tydic.uoc.base.exception.UocProBusinessException;
import java.net.URI;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import org.apache.http.Header;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.StringUtils;

@Service(value="lmIntfCancelRefundBusiService")
public class LmIntfCancelRefundBusiServiceImpl
implements LmIntfCancelRefundBusiService {
    private static final Logger LOGGER = LoggerFactory.getLogger(LmIntfCancelRefundBusiServiceImpl.class);
    private final boolean IS_DEBUG_ENABLED = LOGGER.isDebugEnabled();
    @Autowired
    private LmIntfQryRefundOrderDetailBusiService lmIntfQryRefundOrderDetailBusiService;

    public CancelRefundRspBO cancelRefund(CancelRefundReqBO cancelRefundReqBO) {
        CancelRefundRspBO rspBO = new CancelRefundRspBO();
        String requestJsonStr = this.initRequestJsonStr(cancelRefundReqBO);
        try {
            HttpRetBean httpRetBean = HSHttpHelper.doUrlPostRequest((URI)new URI(PropertiesUtil.getProperty("LINKED_MALL_CANCEL_REFUND_URL")), (Header[])HSNHttpHeader.getRequestHeaders((String)"json"), (byte[])requestJsonStr.getBytes(StandardCharsets.UTF_8), (String)"UTF-8", (Boolean)false);
            if (httpRetBean.getStatus() != 200) {
                throw new RuntimeException("\u8c03\u7528LinkedMall\u53d6\u6d88\u9000\u6b3e\u7533\u8bf7\u4e1a\u52a1\u670d\u52a1\u5931\u8d25[http_status=" + httpRetBean.getStatus() + "], " + "[http_url=" + PropertiesUtil.getProperty("LINKED_MALL_CANCEL_REFUND_URL") + "]");
            }
            String returnString = httpRetBean.getStr();
            if (StringUtils.isEmpty((Object)returnString)) {
                throw new UocProBusinessException("2001", "\u8c03\u7528LinkedMall\u53d6\u6d88\u9000\u6b3e\u7533\u8bf7\u63a5\u53e3\u7cfb\u7edf\u54cd\u5e94\u62a5\u6587\u4e3a\u7a7a\uff01");
            }
            Thread.sleep(1000L);
            QryRefundOrderDetailReqBO refundOrderDetailReqBO = new QryRefundOrderDetailReqBO();
            if (!StringUtils.isEmpty((Object)cancelRefundReqBO.getTbUserId())) {
                refundOrderDetailReqBO.setTbUserId(cancelRefundReqBO.getTbUserId());
            }
            refundOrderDetailReqBO.setSubLmOrderId(cancelRefundReqBO.getSubLmOrderId());
            QryRefundOrderDetailRspBO qryRefundOrderDetailRspBO = this.lmIntfQryRefundOrderDetailBusiService.qryRefundOrderDetail(refundOrderDetailReqBO);
            if (qryRefundOrderDetailRspBO.getRefundApplicationDetail() != null) {
                if (qryRefundOrderDetailRspBO.getRefundApplicationDetail().getDisputeStatus() == 4) {
                    rspBO.setRespCode("0000");
                    rspBO.setRespDesc("\u64a4\u9500\u6210\u529f");
                    RefundApplicationDataRspBO refundApplicationDataRspBO = new RefundApplicationDataRspBO();
                    refundApplicationDataRspBO.setDisputeStatus(qryRefundOrderDetailRspBO.getRefundApplicationDetail().getDisputeStatus());
                    refundApplicationDataRspBO.setDisputeType(qryRefundOrderDetailRspBO.getRefundApplicationDetail().getDisputeType());
                    refundApplicationDataRspBO.setSubLmOrderId(cancelRefundReqBO.getSubLmOrderId());
                    rspBO.setRefundApplicationData(refundApplicationDataRspBO);
                }
            } else {
                rspBO.setRespCode("8888");
                rspBO.setRespDesc("\u64a4\u9500\u5931\u8d25");
            }
        }
        catch (Exception e) {
            LOGGER.error("\u8c03\u7528LM\u53d6\u6d88\u552e\u540e\u7533\u8bf7\u63a5\u53e3\u5f02\u5e38!", (Throwable)e);
            rspBO.setRespCode("8888");
            rspBO.setRespDesc("\u8c03\u7528LM\u53d6\u6d88\u552e\u540e\u7533\u8bf7\u63a5\u53e3\u5f02\u5e38");
            return rspBO;
        }
        return rspBO;
    }

    private String initRequestJsonStr(CancelRefundReqBO cancelRefundReqBO) {
        String sign;
        String appKey = PropertiesUtil.getProperty("lmAppKey");
        String appSecret = PropertiesUtil.getProperty("lmAppSecret");
        HashMap<String, String> mapParamas = new HashMap<String, String>();
        mapParamas.put("appKey", appKey);
        if (!StringUtils.isEmpty((Object)cancelRefundReqBO.getTbUserId())) {
            mapParamas.put("tbUserId", cancelRefundReqBO.getTbUserId());
        }
        mapParamas.put("subLmOrderId", cancelRefundReqBO.getSubLmOrderId());
        mapParamas.put("disputeId", String.valueOf(cancelRefundReqBO.getDisputeId()));
        try {
            sign = LmSignUtil.getSign(mapParamas, appSecret);
        }
        catch (Exception e) {
            throw new UocProBusinessException("8888", "\u8c03\u7528\u53d6\u6d88\u9000\u6b3e\u7533\u8bf7\u63a5\u53e3\u8f6c\u6362\u7b7e\u540d\u5931\u8d25");
        }
        JSONObject jsonObject = new JSONObject();
        jsonObject.put("appKey", (Object)appKey);
        jsonObject.put("sign", (Object)sign);
        if (!StringUtils.isEmpty((Object)cancelRefundReqBO.getTbUserId())) {
            jsonObject.put("tbUserId", (Object)cancelRefundReqBO.getTbUserId());
        }
        jsonObject.put("subLmOrderId", (Object)cancelRefundReqBO.getSubLmOrderId());
        jsonObject.put("disputeId", (Object)cancelRefundReqBO.getDisputeId());
        String jsonStr = jsonObject.toJSONString();
        if (this.IS_DEBUG_ENABLED) {
            LOGGER.debug("\u8c03\u7528LinkedMall\u53d6\u6d88\u9000\u6b3e\u7533\u8bf7\u63a5\u53e3\u8bf7\u6c42\u62a5\u6587\uff1a" + jsonStr);
        }
        return jsonStr;
    }

    private CancelRefundRspBO resolveRsp(String returnString) {
        if (this.IS_DEBUG_ENABLED) {
            LOGGER.debug("\u8c03\u7528LinkedMall\u53d6\u6d88\u9000\u6b3e\u7533\u8bf7\u63a5\u53e3\u8fd4\u56de\u62a5\u6587\uff1a" + returnString);
        }
        CancelRefundRspBO rspBO = new CancelRefundRspBO();
        JSONObject jsonObjectReturn = JSONObject.parseObject((String)returnString);
        if (!"0000".equals(jsonObjectReturn.getString("code"))) {
            rspBO.setRespCode(jsonObjectReturn.getString("code"));
            rspBO.setRespDesc("LinkedMall\u53d6\u6d88\u9000\u6b3e\u7533\u8bf7\u5931\u8d25!" + jsonObjectReturn.getString("message"));
            return rspBO;
        }
        JSONObject jsonData = (JSONObject)jsonObjectReturn.get((Object)"data");
        if (jsonData == null) {
            rspBO.setRespCode("2003");
            rspBO.setRespDesc("LinkedMall\u53d6\u6d88\u9000\u6b3e\u7533\u8bf7\u5931\u8d25:\u672a\u8fd4\u56dedata\u6570\u636e!");
            return rspBO;
        }
        JSONObject jsonRefundApplicationData = (JSONObject)jsonData.get((Object)"RefundApplicationData");
        RefundApplicationDataRspBO refundApplicationDataRspBO = null;
        if (jsonRefundApplicationData == null) {
            rspBO.setRespCode("2003");
            rspBO.setRespDesc("LinkedMall\u53d6\u6d88\u9000\u6b3e\u7533\u8bf7\u5931\u8d25:\u672a\u8fd4\u56de\u9006\u5411\u7533\u8bf7\u4fe1\u606f");
        } else {
            refundApplicationDataRspBO = (RefundApplicationDataRspBO)JSONObject.parseObject((String)jsonRefundApplicationData.toJSONString(), RefundApplicationDataRspBO.class);
            rspBO.setRespCode(jsonObjectReturn.getString("code"));
            rspBO.setRespDesc("LinkedMall\u53d6\u6d88\u9000\u6b3e\u6210\u529f!");
        }
        rspBO.setRefundApplicationData(refundApplicationDataRspBO);
        return rspBO;
    }
}

