/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.order.third.intf.busi.impl.lm.afs;

import com.alibaba.fastjson.JSONObject;
import com.cgd.base.util.http.HSHttpHelper;
import com.cgd.base.util.http.HSNHttpHeader;
import com.cgd.base.util.http.HttpRetBean;
import com.tydic.order.third.intf.bo.lm.lm.afs.InitApplyRefundDataRspBO;
import com.tydic.order.third.intf.bo.lm.lm.afs.RefundRenderOrderReqBO;
import com.tydic.order.third.intf.bo.lm.lm.afs.RefundRenderOrderRspBO;
import com.tydic.order.third.intf.busi.lm.afs.LmIntfRefundRenderOrderBusiService;
import com.tydic.order.third.intf.utils.LmSignUtil;
import com.tydic.order.third.intf.utils.PropertiesUtil;
import com.tydic.uoc.base.exception.UocProBusinessException;
import java.net.URI;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import org.apache.http.Header;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import org.springframework.util.StringUtils;

@Service(value="lmIntfRefundRenderOrderBusiService")
public class LmIntfRefundRenderOrderBusiServiceImpl
implements LmIntfRefundRenderOrderBusiService {
    private static final Logger LOGGER = LoggerFactory.getLogger(LmIntfRefundRenderOrderBusiServiceImpl.class);
    private final boolean IS_DEBUG_ENABLED = LOGGER.isDebugEnabled();

    public RefundRenderOrderRspBO renfundRenderOrder(RefundRenderOrderReqBO refundRenderOrderReqBO) {
        RefundRenderOrderRspBO rspBO = new RefundRenderOrderRspBO();
        String requestJsonStr = this.initRequestJsonStr(refundRenderOrderReqBO);
        try {
            HttpRetBean httpRetBean = HSHttpHelper.doUrlPostRequest((URI)new URI(PropertiesUtil.getProperty("LINKED_MALL_APPLY_REFUND_ORDER_URL")), (Header[])HSNHttpHeader.getRequestHeaders((String)"json"), (byte[])requestJsonStr.getBytes(StandardCharsets.UTF_8), (String)"UTF-8", (Boolean)false);
            if (httpRetBean.getStatus() != 200) {
                throw new RuntimeException("\u8c03\u7528LinkedMall\u8ba2\u5355\u9006\u5411\u6e32\u67d3\u4e1a\u52a1\u670d\u52a1\u5931\u8d25[http_status=" + httpRetBean.getStatus() + "], " + "[http_url=" + PropertiesUtil.getProperty("LINKED_MALL_APPLY_REFUND_ORDER_URL") + "]");
            }
            String returnString = httpRetBean.getStr();
            if (StringUtils.isEmpty((Object)returnString)) {
                throw new UocProBusinessException("2001", "\u8c03\u7528LinkedMall\u8ba2\u5355\u9006\u5411\u6e32\u67d3\u670d\u52a1\u63a5\u53e3\u7cfb\u7edf\u54cd\u5e94\u62a5\u6587\u4e3a\u7a7a\uff01");
            }
            rspBO = this.resolveRsp(returnString);
        }
        catch (Exception e) {
            LOGGER.error("\u8c03\u7528LM\u8ba2\u5355\u9006\u5411\u6e32\u67d3\u63a5\u53e3\u5f02\u5e38!", (Throwable)e);
            rspBO.setRespCode("8888");
            rspBO.setRespDesc("\u8c03\u7528LM\u8ba2\u5355\u9006\u5411\u6e32\u67d3\u63a5\u53e3\u5f02\u5e38");
        }
        return rspBO;
    }

    private String initRequestJsonStr(RefundRenderOrderReqBO refundRenderOrderReqBO) {
        String sign;
        String appKey = PropertiesUtil.getProperty("lmAppKey");
        String appSecret = PropertiesUtil.getProperty("lmAppSecret");
        HashMap<String, String> mapParamas = new HashMap<String, String>();
        mapParamas.put("appKey", appKey);
        if (!StringUtils.isEmpty((Object)refundRenderOrderReqBO.getTbUserId())) {
            mapParamas.put("tbUserId", refundRenderOrderReqBO.getTbUserId());
        }
        mapParamas.put("subLmOrderId", refundRenderOrderReqBO.getSubLmOrderId());
        mapParamas.put("bizClaimType", String.valueOf(refundRenderOrderReqBO.getBizClaimType()));
        mapParamas.put("goodsStatus", String.valueOf(refundRenderOrderReqBO.getGoodsStatus()));
        try {
            sign = LmSignUtil.getSign(mapParamas, appSecret);
        }
        catch (Exception e) {
            throw new UocProBusinessException("8888", "\u8c03\u7528\u8ba2\u5355\u9006\u5411\u6e32\u67d3\u63a5\u53e3\u8f6c\u6362\u7b7e\u540d\u5931\u8d25");
        }
        JSONObject jsonObject = new JSONObject();
        jsonObject.put("appKey", (Object)appKey);
        jsonObject.put("sign", (Object)sign);
        if (!StringUtils.isEmpty((Object)refundRenderOrderReqBO.getTbUserId())) {
            jsonObject.put("tbUserId", (Object)refundRenderOrderReqBO.getTbUserId());
        }
        jsonObject.put("subLmOrderId", (Object)refundRenderOrderReqBO.getSubLmOrderId());
        jsonObject.put("bizClaimType", (Object)refundRenderOrderReqBO.getBizClaimType());
        jsonObject.put("goodsStatus", (Object)refundRenderOrderReqBO.getGoodsStatus());
        String jsonStr = jsonObject.toJSONString();
        if (this.IS_DEBUG_ENABLED) {
            LOGGER.debug("\u8c03\u7528LinkedMall\u5546\u57ce\u8ba2\u5355\u9006\u5411\u6e32\u67d3\u63a5\u53e3\u8bf7\u6c42\u62a5\u6587\uff1a" + jsonStr);
        }
        return jsonStr;
    }

    private RefundRenderOrderRspBO resolveRsp(String returnString) {
        if (this.IS_DEBUG_ENABLED) {
            LOGGER.debug("\u8c03\u7528LinkedMall\u5546\u57ce\u8ba2\u5355\u9006\u5411\u6e32\u67d3\u63a5\u53e3\u8fd4\u56de\u62a5\u6587\uff1a" + returnString);
        }
        RefundRenderOrderRspBO rspBO = new RefundRenderOrderRspBO();
        JSONObject jsonObjectReturn = JSONObject.parseObject((String)returnString);
        if (!"0000".equals(jsonObjectReturn.getString("code"))) {
            rspBO.setRespCode(jsonObjectReturn.getString("code"));
            if (jsonObjectReturn.getString("message").contains("\u539f\u56e0")) {
                String originMessag = jsonObjectReturn.getString("message");
                String errorMsg = originMessag.substring(originMessag.indexOf("\u539f\u56e0"), originMessag.length() - 1);
                rspBO.setRespDesc("LinkedMall\u8ba2\u5355\u9006\u5411\u6e32\u67d3\u5931\u8d25!" + errorMsg);
            } else {
                rspBO.setRespDesc("LinkedMall\u8ba2\u5355\u9006\u5411\u6e32\u67d3\u5931\u8d25!" + jsonObjectReturn.getString("message"));
            }
            return rspBO;
        }
        JSONObject jsonData = (JSONObject)jsonObjectReturn.get((Object)"data");
        if (jsonData == null) {
            rspBO.setRespCode("2003");
            rspBO.setRespDesc("LinkedMall\u8ba2\u5355\u9006\u5411\u6e32\u67d3\u5931\u8d25:\u672a\u8fd4\u56dedata\u6570\u636e!");
            return rspBO;
        }
        JSONObject jsonInitApplyRefund = (JSONObject)jsonData.get((Object)"InitApplyRefundData");
        InitApplyRefundDataRspBO initApplyRefundDataRspBO = null;
        if (jsonInitApplyRefund == null) {
            rspBO.setRespCode("2002");
            rspBO.setRespDesc("LinkedMall\u8ba2\u5355\u9006\u5411\u6e32\u67d3\u5931\u8d25:\u672a\u8fd4\u56de\u9006\u5411\u6e32\u67d3\u521d\u59cb\u5316\u4fe1\u606f");
        } else {
            initApplyRefundDataRspBO = (InitApplyRefundDataRspBO)JSONObject.parseObject((String)jsonInitApplyRefund.toJSONString(), InitApplyRefundDataRspBO.class);
            rspBO.setRespCode(jsonObjectReturn.getString("code"));
            rspBO.setRespDesc("LinkedMall\u8ba2\u5355\u9006\u5411\u6e32\u67d3\u6210\u529f!");
        }
        rspBO.setInitApplyRefundData(initApplyRefundDataRspBO);
        return rspBO;
    }
}

