/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.order.third.intf.ability.impl.esb.afs;

import com.alibaba.fastjson.JSONObject;
import com.cgd.base.util.http.HSHttpHelper;
import com.cgd.base.util.http.HSNHttpHeader;
import com.cgd.base.util.http.HttpRetBean;
import com.tydic.order.third.intf.ability.esb.afs.PebIntfAfsConfirmAbitilyService;
import com.tydic.order.third.intf.bo.esb.afs.PebIntfAfsConfirmReqBO;
import com.tydic.order.third.intf.bo.esb.afs.PebIntfAfsConfirmRspBO;
import com.tydic.order.third.intf.utils.ESBParamUtil;
import com.tydic.order.third.intf.utils.PropertiesUtil;
import com.tydic.uoc.base.exception.UocProBusinessException;
import java.net.URI;
import java.nio.charset.StandardCharsets;
import org.apache.http.Header;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import org.springframework.util.StringUtils;

@Service
public class PebIntfAfsConfirmAbitilyServiceImpl
implements PebIntfAfsConfirmAbitilyService {
    private static final Logger LOGGER = LoggerFactory.getLogger(PebIntfAfsConfirmAbitilyService.class);

    public PebIntfAfsConfirmRspBO confirmAfsOrder(PebIntfAfsConfirmReqBO reqBO) {
        PebIntfAfsConfirmRspBO rspBO;
        try {
            String reqStr = this.initPostStr(reqBO);
            HttpRetBean httpRetBean = HSHttpHelper.doUrlPostRequest((URI)new URI(PropertiesUtil.getProperty("ESB_SERVICE_JD_CONFIRM")), (Header[])HSNHttpHeader.getRequestHeaders((String)"json"), (byte[])reqStr.getBytes(StandardCharsets.UTF_8), (String)"UTF-8", (Boolean)false);
            if (httpRetBean.getStatus() != 200) {
                throw new UocProBusinessException("2000", "\u4eac\u4e1c\u552e\u540e\u786e\u8ba4ESB[http_status=" + httpRetBean.getStatus() + "], [http_url=" + PropertiesUtil.getProperty("ESB_SERVICE_JD_CONFIRM") + "]");
            }
            String returnString = httpRetBean.getStr();
            if (StringUtils.isEmpty((Object)returnString)) {
                throw new UocProBusinessException("2001", "\u4e1a\u52a1\u670d\u52a1\u8c03\u7528ESB \u4eac\u4e1c\u552e\u540e\u786e\u8ba4ESB\u63a5\u53e3\u7cfb\u7edf\u54cd\u5e94\u62a5\u6587\u4e3a\u7a7a\uff01");
            }
            rspBO = this.resolveRsp(returnString);
        }
        catch (Exception e) {
            LOGGER.error("\u4eac\u4e1c\u552e\u540e\u786e\u8ba4ESB:" + e.getMessage());
            throw new UocProBusinessException("6000", "\u4eac\u4e1c\u552e\u540e\u786e\u8ba4ESB\u63a5\u53e3\u5f02\u5e38");
        }
        return rspBO;
    }

    private String initPostStr(PebIntfAfsConfirmReqBO reqBO) {
        String hsn = PropertiesUtil.getProperty("SUPPLIER_ID_" + reqBO.getSupplierId());
        String esbReqParam = ESBParamUtil.getEsbReqParam(reqBO, hsn, "BUSINESS_ORDER");
        LOGGER.info("\u4eac\u4e1c\u552e\u540e\u786e\u8ba4ESB\u63a5\u53e3" + PropertiesUtil.getProperty("ESB_SERVICE_JD_CONFIRM") + "\u8bf7\u6c42\u62a5\u6587\uff1a" + esbReqParam);
        return esbReqParam;
    }

    private PebIntfAfsConfirmRspBO resolveRsp(String returnString) {
        LOGGER.debug("\u4eac\u4e1c\u552e\u540e\u786e\u8ba4ESB\u63a5\u53e3\u8fd4\u56de\u6570\u636e\uff1a" + returnString);
        PebIntfAfsConfirmRspBO rspBO = new PebIntfAfsConfirmRspBO();
        JSONObject rspJsonObject = JSONObject.parseObject((String)returnString);
        if (rspJsonObject.getBoolean("success").booleanValue()) {
            rspBO.setRespDesc("\u6210\u529f");
            rspBO.setRespCode("0000");
        } else {
            rspBO.setRespCode((String)rspJsonObject.get((Object)"resultCode"));
            rspBO.setRespDesc((String)rspJsonObject.get((Object)"resultMessage"));
        }
        return rspBO;
    }
}

