/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.order.third.intf.busi.impl.esb.delivery;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.cgd.base.util.JsonUtils;
import com.cgd.base.util.http.HSHttpHelper;
import com.cgd.base.util.http.HSNHttpHeader;
import com.cgd.base.util.http.HttpRetBean;
import com.ohaotian.plugin.common.util.DelFormatHelper;
import com.tydic.order.third.intf.bo.esb.delivery.OrderTrackBO;
import com.tydic.order.third.intf.bo.esb.delivery.QryDistributionReqBO;
import com.tydic.order.third.intf.bo.esb.delivery.QryDistributionRspBO;
import com.tydic.order.third.intf.busi.esb.delivery.PebIntfQryDistributionBusiService;
import com.tydic.order.third.intf.utils.ESBParamUtil;
import com.tydic.order.third.intf.utils.PropertiesUtil;
import com.tydic.uoc.base.exception.UocProBusinessException;
import java.net.URI;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.apache.http.Header;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service(value="pebIntfQryDistributionBusiService")
public class PebIntfQryDistributionBusiServiceImpl
implements PebIntfQryDistributionBusiService {
    private static final Logger LOGGER = LoggerFactory.getLogger(PebIntfQryDistributionBusiServiceImpl.class);
    private final boolean IS_DEBUG_ENABLED = LOGGER.isDebugEnabled();

    public QryDistributionRspBO qryDistributionService(QryDistributionReqBO qryDistributionReqBO) {
        QryDistributionRspBO rspBO;
        try {
            String reqStr = this.initPostStr(qryDistributionReqBO);
            HttpRetBean httpRetBean = HSHttpHelper.doUrlPostRequest((URI)new URI(PropertiesUtil.getProperty("ESB_QRY_ORDER_TRACK_URL")), (Header[])HSNHttpHeader.getRequestHeaders((String)"json"), (byte[])reqStr.getBytes("UTF-8"), (String)"UTF-8", (Boolean)false);
            if (httpRetBean.getStatus() != 200) {
                throw new RuntimeException("\u8c03\u7528ESB\u67e5\u8be2\u914d\u9001\u4fe1\u606f\u4e1a\u52a1\u670d\u52a1\u5931\u8d25[http_status=" + httpRetBean.getStatus() + "], " + "[http_url=" + PropertiesUtil.getProperty("ESB_QRY_ORDER_TRACK_URL") + "]");
            }
            String returnString = httpRetBean.getStr();
            if (StringUtils.isEmpty((CharSequence)returnString)) {
                throw new UocProBusinessException("2001", "\u8c03\u7528ESB\u67e5\u8be2\u914d\u9001\u4fe1\u606f\u63a5\u53e3\u7cfb\u7edf\u54cd\u5e94\u62a5\u6587\u4e3a\u7a7a\uff01");
            }
            rspBO = this.resolveRsp(returnString);
        }
        catch (Exception e) {
            LOGGER.error("\u8c03\u7528ESB\u67e5\u8be2\u914d\u9001\u4fe1\u606f\u670d\u52a1\u63a5\u53e3\u5f02\u5e38" + e);
            throw new UocProBusinessException("6000", "\u8c03\u7528ESB\u67e5\u8be2\u914d\u9001\u4fe1\u606f\u670d\u52a1\u63a5\u53e3\u5f02\u5e38");
        }
        return rspBO;
    }

    private String initPostStr(QryDistributionReqBO qryDistributionReqBO) {
        String hsn = PropertiesUtil.getProperty("SUPPLIER_ID_" + qryDistributionReqBO.getSupplierId());
        String esbReqParam = ESBParamUtil.getEsbReqParam(qryDistributionReqBO, hsn, "BUSINESS_ORDER");
        if (this.IS_DEBUG_ENABLED) {
            LOGGER.debug("\u8c03\u7528\u914d\u9001\u4fe1\u606f\u67e5\u8be2ESB\u63a5\u53e3\u8bf7\u6c42\u62a5\u6587\uff1a" + esbReqParam);
        }
        return esbReqParam;
    }

    private QryDistributionRspBO resolveRsp(String returnString) {
        LOGGER.debug("\u8c03\u7528\u914d\u9001\u4fe1\u606f\u67e5\u8be2ESB\u63a5\u53e3\u8fd4\u56de\u6570\u636e\uff1a" + returnString);
        QryDistributionRspBO rspBO = new QryDistributionRspBO();
        JSONObject jsonObject = JSONObject.parseObject((String)returnString);
        if (jsonObject.getBoolean("success").booleanValue()) {
            if ("0000".equals(jsonObject.get((Object)"resultCode"))) {
                rspBO.setRespCode("0000");
                rspBO.setRespDesc("\u6210\u529f");
                String jsonStr = JSONObject.toJSONString((Object)jsonObject.get((Object)"result"));
                if (StringUtils.isNotBlank((CharSequence)jsonStr)) {
                    String waybillCode;
                    OrderTrackBO[] jsonStringToJavaBean;
                    JSONObject object = JSONObject.parseObject((String)jsonStr);
                    String orderTrack = JSONObject.toJSONString((Object)object.get((Object)"orderTrack"));
                    String orderId = (String)JSONObject.parseObject((String)jsonStr).get((Object)"orderId");
                    if (StringUtils.isNotBlank((CharSequence)orderTrack) && null != (jsonStringToJavaBean = (OrderTrackBO[])JsonUtils.jsonStringToJavaBean((String)orderTrack, OrderTrackBO[].class)) && jsonStringToJavaBean.length > 0) {
                        List<OrderTrackBO> asList = Arrays.asList(jsonStringToJavaBean);
                        this.listSort(asList);
                        rspBO.setOrderTrackList(asList);
                    }
                    if ((waybillCode = object.getString("waybillCode")) != null) {
                        try {
                            JSONArray array = JSONArray.parseArray((String)waybillCode);
                            rspBO.setCarrier(array.getJSONObject(0).getString("carrier"));
                            rspBO.setDeliveryOrderId(array.getJSONObject(0).getString("deliveryOrderId"));
                        }
                        catch (Exception e) {
                            try {
                                JSONObject code = JSONObject.parseObject((String)waybillCode);
                                rspBO.setCarrier(code.getString("carrier"));
                                rspBO.setDeliveryOrderId(code.getString("deliveryOrderId"));
                            }
                            catch (Exception exception) {
                                // empty catch block
                            }
                        }
                    }
                    rspBO.setOrderId(orderId);
                    rspBO.setRespCode((String)jsonObject.get((Object)"resultCode"));
                    rspBO.setRespDesc((String)jsonObject.get((Object)"resultMessage"));
                }
            } else {
                rspBO.setRespCode("2000");
                rspBO.setRespDesc("\u8c03\u7528\u914d\u9001\u4fe1\u606f\u67e5\u8be2ESB\u63a5\u53e3\u5931\u8d25" + jsonObject.get((Object)"resultMessage"));
            }
        } else {
            rspBO.setRespCode((String)jsonObject.get((Object)"resultCode"));
            rspBO.setRespDesc((String)jsonObject.get((Object)"resultMessage"));
        }
        return rspBO;
    }

    private void listSort(List<OrderTrackBO> list) {
        Collections.sort(list, new Comparator<OrderTrackBO>(){

            @Override
            public int compare(OrderTrackBO o1, OrderTrackBO o2) {
                try {
                    Date dt1 = DelFormatHelper.fromSdfToDate((String)o1.getMsgTime());
                    Date dt2 = DelFormatHelper.fromSdfToDate((String)o2.getMsgTime());
                    if (dt1.getTime() < dt2.getTime()) {
                        return 1;
                    }
                    if (dt1.getTime() > dt2.getTime()) {
                        return -1;
                    }
                    return 0;
                }
                catch (Exception e) {
                    e.printStackTrace();
                    return 0;
                }
            }
        });
    }
}

