/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.order.third.intf.busi.impl.esb.delivery;

import com.alibaba.fastjson.JSONObject;
import com.cgd.base.util.JsonUtils;
import com.cgd.base.util.http.HSHttpHelper;
import com.cgd.base.util.http.HSNHttpHeader;
import com.cgd.base.util.http.HttpRetBean;
import com.tydic.order.third.intf.bo.esb.delivery.QryTransFeeReqBO;
import com.tydic.order.third.intf.bo.esb.delivery.QryTransFeeRspBO;
import com.tydic.order.third.intf.busi.esb.delivery.PebIntfQryTransportFeeBusiService;
import com.tydic.order.third.intf.utils.ESBParamUtil;
import com.tydic.order.third.intf.utils.PropertiesUtil;
import com.tydic.uoc.base.exception.UocProBusinessException;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.net.URI;
import org.apache.commons.lang3.StringUtils;
import org.apache.http.Header;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service(value="pebIntfQryTransportFeeBusiService")
public class PebIntfQryTransportFeeBusiServiceImpl
implements PebIntfQryTransportFeeBusiService {
    private static final Logger LOGGER = LoggerFactory.getLogger(PebIntfQryTransportFeeBusiServiceImpl.class);
    private final boolean IS_DEBUG_ENABLED = LOGGER.isDebugEnabled();

    public QryTransFeeRspBO queryTransFee(QryTransFeeReqBO qryTransFeeReqBO) {
        QryTransFeeRspBO rspBO;
        try {
            String reqStr = this.initPostStr(qryTransFeeReqBO);
            HttpRetBean httpRetBean = HSHttpHelper.doUrlPostRequest((URI)new URI(PropertiesUtil.getProperty("ESB_QRY_TRANS_FEE_URL")), (Header[])HSNHttpHeader.getRequestHeaders((String)"json"), (byte[])reqStr.getBytes("UTF-8"), (String)"UTF-8", (Boolean)false);
            if (httpRetBean.getStatus() != 200) {
                throw new RuntimeException("\u8c03\u7528ESB\u67e5\u8be2\u8fd0\u8d39\u4fe1\u606f\u4e1a\u52a1\u670d\u52a1\u5931\u8d25[http_status=" + httpRetBean.getStatus() + "], " + "[http_url=" + PropertiesUtil.getProperty("ESB_QRY_TRANS_FEE_URL") + "]");
            }
            String returnString = httpRetBean.getStr();
            if (StringUtils.isEmpty((CharSequence)returnString)) {
                throw new UocProBusinessException("2001", "\u8c03\u7528ESB\u67e5\u8be2\u8fd0\u8d39\u4fe1\u606f\u63a5\u53e3\u7cfb\u7edf\u54cd\u5e94\u62a5\u6587\u4e3a\u7a7a\uff01");
            }
            rspBO = this.resolveRsp(returnString);
        }
        catch (Exception e) {
            LOGGER.error("\u8c03\u7528ESB\u67e5\u8be2\u8fd0\u8d39\u4fe1\u606f\u670d\u52a1\u63a5\u53e3\u5f02\u5e38" + e);
            throw new UocProBusinessException("6000", "\u8c03\u7528ESB\u67e5\u8be2\u8fd0\u8d39\u4fe1\u606f\u670d\u52a1\u63a5\u53e3\u5f02\u5e38");
        }
        return rspBO;
    }

    private String initPostStr(QryTransFeeReqBO qryTransFeeReqBO) {
        String hsn = PropertiesUtil.getProperty("SUPPLIER_ID_" + qryTransFeeReqBO.getSupplierId());
        String esbReqParam = ESBParamUtil.getEsbReqParam(qryTransFeeReqBO, hsn, "BUSINESS_COMMODITY");
        if (this.IS_DEBUG_ENABLED) {
            LOGGER.debug("\u8c03\u7528\u67e5\u8be2\u8fd0\u8d39ESB\u63a5\u53e3\u8bf7\u6c42\u62a5\u6587\uff1a" + esbReqParam);
        }
        return esbReqParam;
    }

    private QryTransFeeRspBO resolveRsp(String returnString) {
        LOGGER.debug("\u8c03\u7528\u67e5\u8be2\u8fd0\u8d39ESB\u63a5\u53e3\u8fd4\u56de\u6570\u636e\uff1a" + returnString);
        QryTransFeeRspBO rspBO = new QryTransFeeRspBO();
        JSONObject jsonObject = JSONObject.parseObject((String)returnString);
        if (jsonObject.getBoolean("success").booleanValue()) {
            if (null != jsonObject.get((Object)"result")) {
                String jsonStr = JSONObject.toJSONString((Object)jsonObject.get((Object)"result"));
                rspBO = (QryTransFeeRspBO)JsonUtils.jsonStringToJavaBean((String)jsonStr, QryTransFeeRspBO.class);
                rspBO.setOriginalFreight(rspBO.getFreight());
                rspBO.setFreight((rspBO.getFreight() == null ? new BigDecimal(BigInteger.ZERO) : rspBO.getFreight()).multiply(new BigDecimal(1.04)).setScale(2, 1));
                rspBO.setRespCode("0000");
                rspBO.setRespDesc("\u6210\u529f");
            }
        } else {
            rspBO.setRespCode((String)jsonObject.get((Object)"resultCode"));
            rspBO.setRespDesc((String)jsonObject.get((Object)"resultMessage"));
        }
        return rspBO;
    }
}

