/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.order.third.intf.busi.impl.esb.other;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.cgd.base.util.http.HSHttpHelper;
import com.cgd.base.util.http.HSNHttpHeader;
import com.cgd.base.util.http.HttpRetBean;
import com.tydic.order.third.intf.bo.esb.other.BusiGetMsgReqBO;
import com.tydic.order.third.intf.bo.esb.other.BusiGetMsgRspBO;
import com.tydic.order.third.intf.bo.esb.other.Result;
import com.tydic.order.third.intf.bo.esb.other.ResultBO;
import com.tydic.order.third.intf.busi.esb.other.PebIntfGetMsgPushBusiService;
import com.tydic.order.third.intf.utils.ESBParamUtil;
import com.tydic.order.third.intf.utils.PropertiesUtil;
import com.tydic.uoc.base.exception.UocProBusinessException;
import java.net.URI;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.apache.http.Header;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import org.springframework.util.StringUtils;

@Service(value="pebIntfGetMsgPushBusiService")
public class PebIntfGetMsgPushBusiServiceImpl
implements PebIntfGetMsgPushBusiService {
    private static final Logger LOGGER = LoggerFactory.getLogger(PebIntfGetMsgPushBusiServiceImpl.class);
    private final boolean IS_DEBUG_ENABLED = LOGGER.isDebugEnabled();

    public BusiGetMsgRspBO getMsg(BusiGetMsgReqBO busiGetMsgReq) {
        try {
            String returnString;
            String reqStr = this.initReqStr(busiGetMsgReq);
            String hsn = PropertiesUtil.getProperty("SUPPLIER_ID_" + busiGetMsgReq.getSupplierId());
            String reqEsbStr = ESBParamUtil.getEsbReqStr(reqStr, hsn, "BUSINESS_ORDER");
            HttpRetBean httpRetBean = HSHttpHelper.doUrlPostRequest((URI)new URI(PropertiesUtil.getProperty("ESB_QRY_MSG_URL")), (Header[])HSNHttpHeader.getRequestHeaders((String)"json"), (byte[])reqEsbStr.getBytes("UTF-8"), (String)"UTF-8", (Boolean)false);
            if (httpRetBean.getStatus() != 200) {
                throw new RuntimeException("\u83b7\u53d6\u6d88\u606f\u63a8\u9001\u4fe1\u606f\u4e1a\u52a1-\u63a5\u53e3\u8fd4\u56de\u5931\u8d25[http_status=" + httpRetBean.getStatus() + "], [http_url=" + PropertiesUtil.getProperty("ESB_QRY_MSG_URL") + "]");
            }
            if (this.IS_DEBUG_ENABLED) {
                LOGGER.debug("\u83b7\u53d6\u6d88\u606f\u63a8\u9001\u4fe1\u606f\u4e1a\u52a1-\u63a5\u53e3\u8fd4\u56de\u54cd\u5e94\u62a5\u6587\uff1a" + httpRetBean.getStr());
            }
            if (StringUtils.isEmpty((Object)(returnString = httpRetBean.getStr()))) {
                throw new RuntimeException("\u83b7\u53d6\u6d88\u606f\u63a8\u9001\u4fe1\u606f\u4e1a\u52a1-\u7cfb\u7edf\u54cd\u5e94\u62a5\u6587\u4e3a\u7a7a\uff01");
            }
            BusiGetMsgRspBO resolveRsp = this.resolveRsp(returnString, busiGetMsgReq.getIsAnalysis());
            LOGGER.debug("\u63a8\u9001\u6d88\u606f\u51fa\u53c2 \u5f00\u59cb\u6253\u5370");
            List resultList = resolveRsp.getResult();
            if (null != resultList) {
                for (ResultBO resultBO : resultList) {
                    LOGGER.debug("resultBO\uff1a" + resultBO.toString());
                    if (null == resultBO.getResult()) continue;
                    LOGGER.debug("\u63a8\u9001\u6d88\u606f\u51fa\u53c2Result: " + resultBO.getResult().toString());
                }
            }
            LOGGER.debug("\u63a8\u9001\u6d88\u606f\u51fa\u53c2 \u6253\u5370\u7ed3\u675f");
            return resolveRsp;
        }
        catch (Exception e) {
            if (this.IS_DEBUG_ENABLED) {
                LOGGER.debug("\u83b7\u53d6\u6d88\u606f\u63a8\u9001\u4fe1\u606f\u4e1a\u52a1\u8c03\u7528\u5931\u8d25" + e);
            }
            throw new UocProBusinessException("6000", "\u83b7\u53d6\u6d88\u606f\u63a8\u9001\u4fe1\u606f\u4e1a\u52a1\u4e1a\u52a1\u5931\u8d25");
        }
    }

    private String initReqStr(BusiGetMsgReqBO busiQryMsgReqBO) {
        return "{\"type\":" + busiQryMsgReqBO.getType() + "}";
    }

    private BusiGetMsgRspBO resolveRsp(String returnString, boolean isAnalysis) {
        if (this.IS_DEBUG_ENABLED) {
            LOGGER.debug("\u662f\u5426\u5168\u91cf\u89e3\u6790\u5916\u90e8\u7535\u5546\u8fd4\u56de\u63a8\u9001\u6570\u636e:" + isAnalysis);
        }
        BusiGetMsgRspBO busiQryMsgRspBO = new BusiGetMsgRspBO();
        ArrayList<ResultBO> list = new ArrayList<ResultBO>();
        try {
            JSONObject rspJsonObject = JSONObject.parseObject((String)returnString);
            busiQryMsgRspBO.setSuccess(rspJsonObject.getBoolean("success").booleanValue());
            busiQryMsgRspBO.setResultCode(Integer.valueOf((String)rspJsonObject.get((Object)"resultCode")).intValue());
            busiQryMsgRspBO.setResultMessage((String)rspJsonObject.get((Object)"resultMessage"));
            JSONArray object = rspJsonObject.getJSONArray("result");
            if (null != object) {
                for (Object singleObject : object) {
                    JSONObject obj = (JSONObject)singleObject;
                    if (!isAnalysis) {
                        String id = obj.getString("id");
                        Long type = obj.getLong("type");
                        Date time = obj.getDate("time");
                        String result = obj.getString("result");
                        if (this.IS_DEBUG_ENABLED) {
                            LOGGER.debug("\u63a8\u9001id:" + id + ", " + "\u7c7b\u578btype:" + type + ", " + "\u63a8\u9001\u65f6\u95f4time:" + time.toString() + ", " + "\u4e0d\u89e3\u6790\u5b57\u7b26\u4e32result:" + result);
                        }
                        ResultBO temp = new ResultBO();
                        temp.setId(id);
                        temp.setTime(time);
                        temp.setType(type);
                        temp.setResultString(result);
                        temp.setResult(new Result());
                        list.add(temp);
                        continue;
                    }
                    String jsonStr = JSONObject.toJSONString((Object)obj);
                    if (StringUtils.isEmpty((Object)jsonStr)) continue;
                    ResultBO jsonStringToJavaBean = (ResultBO)JSON.parseObject((String)jsonStr, ResultBO.class);
                    list.add(jsonStringToJavaBean);
                }
                busiQryMsgRspBO.setResult(list);
            }
        }
        catch (Exception e) {
            if (this.IS_DEBUG_ENABLED) {
                LOGGER.debug("\u83b7\u53d6\u6d88\u606f\u63a8\u9001\u4fe1\u606f\u4e1a\u52a1\u63a5\u53e3\u89e3\u6790\u54cd\u5e94\u62a5\u6587\u51fa\u9519\uff1a" + e);
            }
            throw new RuntimeException("\u83b7\u53d6\u6d88\u606f\u63a8\u9001\u4fe1\u606f\u4e1a\u52a1\u63a5\u53e3\u89e3\u6790\u54cd\u5e94\u62a5\u6587\u51fa\u9519\uff1a" + e);
        }
        return busiQryMsgRspBO;
    }
}

