/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.order.third.intf.busi.impl.lm.order;

import com.alibaba.fastjson.JSONObject;
import com.cgd.base.util.http.HSHttpHelper;
import com.cgd.base.util.http.HSNHttpHeader;
import com.cgd.base.util.http.HttpRetBean;
import com.tydic.order.third.intf.bo.lm.order.OrderPayFscRspBO;
import com.tydic.order.third.intf.bo.lm.order.OrderPayReqBO;
import com.tydic.order.third.intf.busi.lm.order.LmIntfOrderPayBusiService;
import com.tydic.order.third.intf.utils.LmSignUtil;
import com.tydic.order.third.intf.utils.PropertiesUtil;
import com.tydic.uoc.base.exception.UocProBusinessException;
import java.net.URI;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import org.apache.http.Header;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import org.springframework.util.StringUtils;

@Service(value="lmIntfOrderPayBusiService")
public class LmIntfOrderPayBusiServiceImpl
implements LmIntfOrderPayBusiService {
    private Logger logger = LoggerFactory.getLogger(LmIntfOrderPayBusiServiceImpl.class);

    public OrderPayFscRspBO dealOrderPay(OrderPayReqBO reqBO) {
        OrderPayFscRspBO rspBO = new OrderPayFscRspBO();
        String requestJsonStr = this.initRequestJsonStr(reqBO);
        try {
            HttpRetBean httpRetBean = HSHttpHelper.doUrlPostRequest((URI)new URI(PropertiesUtil.getProperty("LINKED_MALL_ORDER_PAY_URL")), (Header[])HSNHttpHeader.getRequestHeaders((String)"json"), (byte[])requestJsonStr.getBytes(StandardCharsets.UTF_8), (String)"UTF-8", (Boolean)false);
            if (httpRetBean.getStatus() != 200) {
                throw new RuntimeException("\u8c03\u7528LinkedMall\u8ba2\u5355\u652f\u4ed8\u4e1a\u52a1\u670d\u52a1\u5931\u8d25[http_status=" + httpRetBean.getStatus() + "], " + "[http_url=" + PropertiesUtil.getProperty("LINKED_MALL_ORDER_PAY_URL") + "]");
            }
            String returnString = httpRetBean.getStr();
            if (StringUtils.isEmpty((Object)returnString)) {
                throw new UocProBusinessException("2001", "\u8c03\u7528LinkedMall\u8ba2\u5355\u652f\u4ed8\u670d\u52a1\u63a5\u53e3\u7cfb\u7edf\u54cd\u5e94\u62a5\u6587\u4e3a\u7a7a\uff01");
            }
            return this.resolveRsp(returnString, requestJsonStr);
        }
        catch (Exception e) {
            this.logger.error("\u8c03\u7528LM\u8ba2\u5355\u652f\u4ed8\u63a5\u53e3\u5f02\u5e38", (Throwable)e);
            rspBO.setRespCode("8888");
            rspBO.setRespDesc("\u8c03\u7528LM\u8ba2\u5355\u652f\u4ed8\u63a5\u53e3\u5f02\u5e38");
            return rspBO;
        }
    }

    private String initRequestJsonStr(OrderPayReqBO reqBO) {
        String sign;
        String appKey = PropertiesUtil.getProperty("lmAppKey");
        String appSecret = PropertiesUtil.getProperty("lmAppSecret");
        HashMap<String, String> mapParamas = new HashMap<String, String>(2);
        mapParamas.put("appKey", appKey);
        if (!StringUtils.isEmpty((Object)reqBO.getOutTradeId())) {
            mapParamas.put("outTradeId", reqBO.getOutTradeId());
        }
        mapParamas.put("lmOrderId", String.valueOf(reqBO.getLmOrderId()));
        try {
            sign = LmSignUtil.getSign(mapParamas, appSecret);
        }
        catch (Exception e) {
            throw new UocProBusinessException("8888", "\u8c03\u7528\u8ba2\u5355\u4e0b\u5355\u63a5\u53e3\u8f6c\u6362\u7b7e\u540d\u5931\u8d25");
        }
        JSONObject jsonObject = new JSONObject();
        jsonObject.put("appKey", (Object)appKey);
        jsonObject.put("sign", (Object)sign);
        if (!StringUtils.isEmpty((Object)reqBO.getOutTradeId())) {
            jsonObject.put("outTradeId", (Object)reqBO.getOutTradeId());
        }
        jsonObject.put("lmOrderId", (Object)reqBO.getLmOrderId());
        String jsonStr = jsonObject.toJSONString();
        this.logger.debug("\u8c03\u7528LinkedMall\u5546\u57ce\u8ba2\u5355\u652f\u4ed8\u63a5\u53e3\u8bf7\u6c42\u62a5\u6587" + jsonStr);
        return jsonStr;
    }

    private OrderPayFscRspBO resolveRsp(String returnString, String reqJson) {
        this.logger.debug("\u8c03\u7528LinkedMall\u5546\u57ce\u8ba2\u5355\u652f\u4ed8\u63a5\u53e3\u8fd4\u56de\u62a5\u6587\uff1a" + returnString);
        OrderPayFscRspBO rspBO = new OrderPayFscRspBO();
        rspBO.setResultJson(returnString);
        rspBO.setRequestJson(reqJson);
        JSONObject jsonObjectReturn = JSONObject.parseObject((String)returnString);
        if (!"0000".equals(jsonObjectReturn.getString("code"))) {
            rspBO.setRespCode(jsonObjectReturn.getString("code"));
            rspBO.setRespDesc("LinkedMall\u8ba2\u5355\u652f\u4ed8\u5931\u8d25!" + jsonObjectReturn.getString("message"));
            return rspBO;
        }
        rspBO.setRespCode(jsonObjectReturn.getString("code"));
        rspBO.setRespDesc("LinkedMall\u8ba2\u5355\u652f\u4ed8\u6210\u529f!");
        return rspBO;
    }
}

