/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.order.third.intf.busi.impl.lm.order;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.cgd.base.util.http.HSHttpHelper;
import com.cgd.base.util.http.HSNHttpHeader;
import com.cgd.base.util.http.HttpRetBean;
import com.tydic.order.third.intf.bo.lm.order.RenderOrderReqBO;
import com.tydic.order.third.intf.bo.lm.order.RenderOrderRspBO;
import com.tydic.order.third.intf.bo.lm.order.ThirdOrderSkuReqBO;
import com.tydic.order.third.intf.bo.lm.order.ThirdRenderOrderDeliveryInfoRspBO;
import com.tydic.order.third.intf.bo.lm.order.ThirdRenderOrderInfoRspBO;
import com.tydic.order.third.intf.bo.lm.order.ThirdRenderOrderItemInfoRspBO;
import com.tydic.order.third.intf.busi.lm.order.LmIntfRenderOrderBusiService;
import com.tydic.order.third.intf.utils.LmSignUtil;
import com.tydic.order.third.intf.utils.PropertiesUtil;
import com.tydic.uoc.base.exception.UocProBusinessException;
import java.net.URI;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.apache.http.Header;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import org.springframework.util.StringUtils;

@Service(value="lmIntfRenderOrderBusiService")
public class LmIntfRenderOrderBusiServiceImpl
implements LmIntfRenderOrderBusiService {
    private static final Logger LOGGER = LoggerFactory.getLogger(LmIntfRenderOrderBusiServiceImpl.class);
    private final boolean IS_DEBUG_ENABLED = LOGGER.isDebugEnabled();
    @Value(value="${isOpenLmTemp}")
    private Boolean isOpenLmTemp;

    public RenderOrderRspBO renderOrder(RenderOrderReqBO renderOrderReqBO) {
        RenderOrderRspBO rspBO = new RenderOrderRspBO();
        String requestJsonStr = this.initRequestJsonStr(renderOrderReqBO);
        if (this.isOpenLmTemp.booleanValue()) {
            Long itemId = ((ThirdOrderSkuReqBO)renderOrderReqBO.getItemList().get(0)).getItemId();
            Long skuId = ((ThirdOrderSkuReqBO)renderOrderReqBO.getItemList().get(0)).getSkuId();
            String returnString = "{\"code\":\"0000\",\"data\":{\"renderOrderInfos\":{\"lmItemInfos\":[{\"canSell\":true,\"itemId\":" + itemId + ",\"message\":\"\",\"quantity\":\"\",\"skuId\":" + skuId + "}],\"deliveryInfos\":null}},\"message\":\"\"}";
            rspBO = this.resolveRsp(returnString, requestJsonStr);
        } else {
            try {
                HttpRetBean httpRetBean = HSHttpHelper.doUrlPostRequest((URI)new URI(PropertiesUtil.getProperty("LINKED_MALL_RENDER_ORDER_URL")), (Header[])HSNHttpHeader.getRequestHeaders((String)"json"), (byte[])requestJsonStr.getBytes(StandardCharsets.UTF_8), (String)"UTF-8", (Boolean)false);
                if (httpRetBean.getStatus() != 200) {
                    throw new RuntimeException("\u8c03\u7528LinkedMall\u8ba2\u5355\u6e32\u67d3\u4e1a\u52a1\u670d\u52a1\u5931\u8d25[http_status=" + httpRetBean.getStatus() + "], " + "[http_url=" + PropertiesUtil.getProperty("LINKED_MALL_RENDER_ORDER_URL") + "]");
                }
                String returnString = httpRetBean.getStr();
                if (StringUtils.isEmpty((Object)returnString)) {
                    throw new UocProBusinessException("2001", "\u8c03\u7528LinkedMall\u8ba2\u5355\u6e32\u67d3\u670d\u52a1\u63a5\u53e3\u7cfb\u7edf\u54cd\u5e94\u62a5\u6587\u4e3a\u7a7a\uff01");
                }
                rspBO = this.resolveRsp(returnString, requestJsonStr);
            }
            catch (Exception e) {
                LOGGER.error("\u8c03\u7528LM\u8ba2\u5355\u6e32\u67d3\u63a5\u53e3\u5f02\u5e38!", (Throwable)e);
                rspBO.setRespCode("8888");
                rspBO.setRespDesc("\u8c03\u7528LM\u8ba2\u5355\u6e32\u67d3\u63a5\u53e3\u5f02\u5e38");
                return rspBO;
            }
        }
        return rspBO;
    }

    private String initRequestJsonStr(RenderOrderReqBO renderOrderReqBO) {
        String sign;
        String appKey = PropertiesUtil.getProperty("lmAppKey");
        String appSecret = PropertiesUtil.getProperty("lmAppSecret");
        HashMap<String, String> mapParamas = new HashMap<String, String>();
        mapParamas.put("appKey", appKey);
        if (!StringUtils.isEmpty((Object)renderOrderReqBO.getTbUserId())) {
            mapParamas.put("tbUserId", renderOrderReqBO.getTbUserId());
        }
        mapParamas.put("itemList", JSON.toJSONString((Object)renderOrderReqBO.getItemList()));
        mapParamas.put("deliveryAddress", JSON.toJSONString((Object)renderOrderReqBO.getDeliveryAddress()));
        try {
            sign = LmSignUtil.getSign(mapParamas, appSecret);
        }
        catch (Exception e) {
            throw new UocProBusinessException("8888", "\u8c03\u7528\u8ba2\u5355\u6e32\u67d3\u63a5\u53e3\u8f6c\u6362\u7b7e\u540d\u5931\u8d25");
        }
        JSONObject jsonObject = new JSONObject();
        jsonObject.put("appKey", (Object)appKey);
        jsonObject.put("sign", (Object)sign);
        if (!StringUtils.isEmpty((Object)renderOrderReqBO.getTbUserId())) {
            jsonObject.put("tbUserId", (Object)renderOrderReqBO.getTbUserId());
        }
        jsonObject.put("itemList", (Object)renderOrderReqBO.getItemList());
        jsonObject.put("deliveryAddress", mapParamas.get("deliveryAddress"));
        String jsonStr = jsonObject.toJSONString();
        if (this.IS_DEBUG_ENABLED) {
            LOGGER.debug("\u8c03\u7528LinkedMall\u5546\u57ce\u8ba2\u5355\u6e32\u67d3\u63a5\u53e3\u8bf7\u6c42\u62a5\u6587\uff1a" + jsonStr);
        }
        return jsonStr;
    }

    private RenderOrderRspBO resolveRsp(String returnString, String reqJson) {
        if (this.IS_DEBUG_ENABLED) {
            LOGGER.debug("\u8c03\u7528LinkedMall\u5546\u57ce\u8ba2\u5355\u6e32\u67d3\u63a5\u53e3\u8fd4\u56de\u62a5\u6587\uff1a" + returnString);
        }
        RenderOrderRspBO rspBO = new RenderOrderRspBO();
        rspBO.setResultJson(returnString);
        rspBO.setRequestJson(reqJson);
        JSONObject jsonObjectReturn = JSONObject.parseObject((String)returnString);
        if (!"0000".equals(jsonObjectReturn.getString("code"))) {
            rspBO.setRespCode(jsonObjectReturn.getString("code"));
            rspBO.setRespDesc("LinkedMall\u8ba2\u5355\u6e32\u67d3\u5931\u8d25!" + jsonObjectReturn.getString("message"));
            return rspBO;
        }
        JSONObject jsonData = (JSONObject)jsonObjectReturn.get((Object)"data");
        if (jsonData == null) {
            rspBO.setRespCode("2005");
            rspBO.setRespDesc("LinkedMall\u8ba2\u5355\u6e32\u67d3\u5931\u8d25:\u672a\u8fd4\u56deData\u6570\u636e!");
            return rspBO;
        }
        JSONObject jsonRenderInfo = (JSONObject)jsonData.get((Object)"renderOrderInfos");
        if (jsonRenderInfo == null) {
            rspBO.setRespCode("2005");
            rspBO.setRespDesc("LinkedMall\u8ba2\u5355\u6e32\u67d3\u5931\u8d25:\u672a\u8fd4\u56de\u6e32\u67d3\u4fe1\u606f!");
            return rspBO;
        }
        JSONArray jsonItemInfos = (JSONArray)jsonRenderInfo.get((Object)"lmItemInfos");
        if (jsonItemInfos == null) {
            rspBO.setRespCode("2005");
            rspBO.setRespDesc("LinkedMall\u8ba2\u5355\u6e32\u67d3\u5931\u8d25:\u672a\u8fd4\u56de\u6e32\u67d3\u5546\u54c1\u5217\u8868\u4fe1\u606f!");
            return rspBO;
        }
        ThirdRenderOrderInfoRspBO renderOrderInfoRspBO = new ThirdRenderOrderInfoRspBO();
        ArrayList<List> rendItemdLists = new ArrayList<List>();
        try {
            jsonItemInfos.getJSONObject(0);
            List renderOrderItemInfoRspBOS = JSONObject.parseArray((String)jsonItemInfos.toJSONString(), ThirdRenderOrderItemInfoRspBO.class);
            rendItemdLists.add(renderOrderItemInfoRspBOS);
        }
        catch (ClassCastException e) {
            for (int i = 0; i < jsonItemInfos.size(); ++i) {
                JSONArray jsonArray = jsonItemInfos.getJSONArray(i);
                List renderOrderItemInfoRspBOS = JSONObject.parseArray((String)jsonArray.toJSONString(), ThirdRenderOrderItemInfoRspBO.class);
                rendItemdLists.add(renderOrderItemInfoRspBOS);
            }
        }
        renderOrderInfoRspBO.setLmItemInfos(rendItemdLists);
        renderOrderInfoRspBO.setLmItemInfos(rendItemdLists);
        JSONArray jsonDeliveryInfos = (JSONArray)jsonRenderInfo.get((Object)"deliveryInfos");
        System.out.println(jsonDeliveryInfos);
        if (null == jsonDeliveryInfos) {
            renderOrderInfoRspBO.setDeliveryInfos(null);
        } else {
            List renderOrderDeliveryInfoRspBOS = JSONObject.parseArray((String)jsonDeliveryInfos.toJSONString(), ThirdRenderOrderDeliveryInfoRspBO.class);
            renderOrderInfoRspBO.setDeliveryInfos(renderOrderDeliveryInfoRspBOS);
        }
        rspBO.setRespCode(jsonObjectReturn.getString("code"));
        rspBO.setRespDesc("LinkedMall\u8ba2\u5355\u6e32\u67d3\u6210\u529f!");
        rspBO.setRenderOrderInfos(renderOrderInfoRspBO);
        return rspBO;
    }
}

