/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.order.extend.comb.impl.saleorder;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.ohaotian.plugin.mq.proxy.ProxyMessage;
import com.ohaotian.plugin.mq.proxy.ProxyMessageProducer;
import com.tydic.order.extend.bo.saleorder.PebExtRedundantSuppliesCreateOrderReqBO;
import com.tydic.order.extend.bo.saleorder.PebExtRedundantSuppliesCreateOrderRspBO;
import com.tydic.order.extend.bo.saleorder.PebExtRedundantSuppliesSkuInfo;
import com.tydic.order.extend.bo.saleorder.PebExtRsSubmitOrderSaleItemRspBO;
import com.tydic.order.extend.busi.saleorder.PebExtRedundantSuppliesCreateOrderBusiService;
import com.tydic.order.extend.busi.saleorder.PebRsCreateOrderCheckBusiService;
import com.tydic.order.extend.comb.saleorder.PebExtRedundantSuppliesCreateOrderCombService;
import com.tydic.order.pec.atom.es.order.bo.SkuInfoRspBO;
import com.tydic.order.pec.comb.es.order.bo.UocPebOrdIdxSyncReqBO;
import com.tydic.order.third.intf.ability.umc.PebIntfEnterpriseOrgDetailAbilityService;
import com.tydic.order.third.intf.ability.umc.PebIntfQryEnterpriseAccountDetailAbilityService;
import com.tydic.order.third.intf.ability.umc.PebIntfQryOrgEffAccountAbilityService;
import com.tydic.order.third.intf.ability.usc.PebIntfGoodsListDelAbilityService;
import com.tydic.order.third.intf.bo.umc.EnterpriseAccountBO;
import com.tydic.order.third.intf.bo.umc.EnterpriseOrgDetailReqBO;
import com.tydic.order.third.intf.bo.umc.EnterpriseOrgDetailRspBO;
import com.tydic.order.third.intf.bo.umc.QryEnterpriseAccountDetailReqBO;
import com.tydic.order.third.intf.bo.umc.QryEnterpriseAccountDetailRspBO;
import com.tydic.order.third.intf.bo.umc.QryOrgEffAccountReqBO;
import com.tydic.order.third.intf.bo.umc.QryOrgEffAccountRspBO;
import com.tydic.order.third.intf.bo.usc.GoodsInfoIdBO;
import com.tydic.order.third.intf.bo.usc.GoodsListDelReqBO;
import com.tydic.order.uoc.bo.order.UocCoreActiveReqBO;
import com.tydic.order.uoc.constant.UocCoreConstant;
import com.tydic.uoc.base.exception.UocProBusinessException;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

@Service
public class PebExtRedundantSuppliesCreateOrderCombServiceImpl
implements PebExtRedundantSuppliesCreateOrderCombService {
    private static final Logger log = LoggerFactory.getLogger(PebExtRedundantSuppliesCreateOrderCombServiceImpl.class);
    @Autowired
    private PebIntfQryOrgEffAccountAbilityService pebIntfQryOrgEffAccountAbilityService;
    @Autowired
    private PebRsCreateOrderCheckBusiService pebRsCreateOrderCheckBusiService;
    @Autowired
    private PebIntfQryEnterpriseAccountDetailAbilityService pebIntfQryEnterpriseAccountDetailAbilityService;
    @Autowired
    private PebExtRedundantSuppliesCreateOrderBusiService pebExtRedundantSuppliesCreateOrderBusiService;
    @Value(value="${UOC_PEB_ORDER_SYNC_TOPIC}")
    private String orderSyncTopic;
    @Value(value="${UOC_PEB_ORDER_SYNC_TAG}")
    private String orderSyncTag;
    @Resource(name="uocPebSyncOrderListMqServiceProvider")
    private ProxyMessageProducer uocPebSyncOrderListMqServiceProvider;
    @Resource(name="uocRsCreateOrderMsgProvider")
    private ProxyMessageProducer uocCreateOrderMsgProvider;
    @Value(value="${UOC_RS_ORDER_CREATE_TOPIC}")
    private String topic;
    @Value(value="${UOC_RS_ORDER_CREATE_TAG}")
    private String tag;
    @Autowired
    private PebIntfGoodsListDelAbilityService pebIntfGoodsListDelAbilityService;
    @Autowired
    private PebIntfEnterpriseOrgDetailAbilityService pebIntfEnterpriseOrgDetailAbilityService;

    public PebExtRedundantSuppliesCreateOrderRspBO dealPebExtRedundantSuppliesCreateOrder(PebExtRedundantSuppliesCreateOrderReqBO reqBO) {
        EnterpriseAccountBO umcEnterpriseAccountBO = this.qryEnterpriseAccountDetail(reqBO);
        reqBO.setPurchaserAccountOrgId(umcEnterpriseAccountBO.getOrgId());
        reqBO.setProPhone(umcEnterpriseAccountBO.getTelephone());
        reqBO.setProfessionalOrganizationId(umcEnterpriseAccountBO.getDeliveryCenterId());
        EnterpriseAccountBO enterpriseAccountBO = this.qryOrgEffAccount(umcEnterpriseAccountBO);
        if (enterpriseAccountBO != null) {
            reqBO.setProAccount(enterpriseAccountBO.getAccountId());
        }
        reqBO.setPayType(Integer.valueOf(Integer.parseInt("0")));
        reqBO.setEnterpriseAccountBO(umcEnterpriseAccountBO);
        PebExtRedundantSuppliesCreateOrderRspBO rspBO = this.pebRsCreateOrderCheckBusiService.dealPebZoneCreateOrder(reqBO);
        ArrayList<PebExtRsSubmitOrderSaleItemRspBO> submitOrderSaleItem = new ArrayList<PebExtRsSubmitOrderSaleItemRspBO>();
        rspBO.setSubmitOrderSaleItem(submitOrderSaleItem);
        Map ztGoods = reqBO.getZtGoods();
        Map shipGoods = reqBO.getShipGoods();
        this.create(submitOrderSaleItem, ztGoods, reqBO, rspBO);
        this.create(submitOrderSaleItem, shipGoods, reqBO, rspBO);
        return rspBO;
    }

    private void create(List<PebExtRsSubmitOrderSaleItemRspBO> submitOrderSaleItem, Map<String, List<PebExtRedundantSuppliesSkuInfo>> splitGoods, PebExtRedundantSuppliesCreateOrderReqBO reqBO, PebExtRedundantSuppliesCreateOrderRspBO rspBO) {
        for (String key : splitGoods.keySet()) {
            reqBO.setSaleOrderItemList(splitGoods.get(key));
            reqBO.setPrOrderId(rspBO.getOrderId());
            reqBO.setProcKey("cnnc_rs_sale_order_master_order_status");
            List<PebExtRedundantSuppliesSkuInfo> skuInfos = splitGoods.get(key);
            if (skuInfos.get(0).getContractId() != null) {
                Map<Long, List<PebExtRedundantSuppliesSkuInfo>> skuInfo = skuInfos.stream().collect(Collectors.groupingBy(SkuInfoRspBO::getContractId));
                for (Long contractId : skuInfo.keySet()) {
                    this.createOrder(reqBO, submitOrderSaleItem, skuInfo.get(contractId), key);
                }
                continue;
            }
            this.createOrder(reqBO, submitOrderSaleItem, skuInfos, key);
        }
    }

    private void createOrder(PebExtRedundantSuppliesCreateOrderReqBO reqBO, List<PebExtRsSubmitOrderSaleItemRspBO> submitOrderSaleItem, List<PebExtRedundantSuppliesSkuInfo> goods, String key) {
        EnterpriseOrgDetailReqBO queryReqBO = new EnterpriseOrgDetailReqBO();
        queryReqBO.setOrgIdWeb(Long.valueOf(key));
        EnterpriseOrgDetailRspBO detailRspBO = this.pebIntfEnterpriseOrgDetailAbilityService.queryEnterpriseOrgByDetail(queryReqBO);
        log.debug("\u67e5\u8be2\u5904\u7f6e\u65b9\u51fa\u53c2" + JSON.toJSONString((Object)detailRspBO));
        if (!detailRspBO.getRespCode().equals("0000")) {
            // empty if block
        }
        log.info("\u5197\u4f59\u7269\u8d44\u4e0b\u5355\u67e5\u8be2\u4f9b\u5e94\u5546\u4fe1\u606f:{}", (Object)JSON.toJSONString((Object)detailRspBO));
        if (detailRspBO.getUmcEnterpriseOrgAbilityBO() != null) {
            reqBO.setSupRelaMobile(detailRspBO.getUmcEnterpriseOrgAbilityBO().getPhone());
            reqBO.setSupRelaName(detailRspBO.getUmcEnterpriseOrgAbilityBO().getLinkMan());
        }
        PebExtRedundantSuppliesCreateOrderRspBO orderRspBO = this.pebExtRedundantSuppliesCreateOrderBusiService.dealPebExtRedundantSuppliesCreateOrder(reqBO);
        PebExtRsSubmitOrderSaleItemRspBO itemRspBO = new PebExtRsSubmitOrderSaleItemRspBO();
        if (!"0000".equals(orderRspBO.getRespCode())) {
            itemRspBO.setGoodSupplierName(orderRspBO.getGoodSupplierName());
            itemRspBO.setGoodsSupplierId(orderRspBO.getGoodsSupplierId());
            itemRspBO.setSuccess(Boolean.valueOf(false));
            itemRspBO.setFailMsg(orderRspBO.getRespDesc());
        } else {
            BeanUtils.copyProperties((Object)orderRspBO, (Object)itemRspBO);
            itemRspBO.setIsPreOrder(Integer.valueOf(0));
            itemRspBO.setUserId(reqBO.getUserId());
            itemRspBO.setOrgId(reqBO.getOrgId());
            itemRspBO.setToken(reqBO.getToken());
            itemRspBO.setOrderId(orderRspBO.getOrderId());
            itemRspBO.setSaleOrderId(orderRspBO.getSaleOrderId());
            itemRspBO.setTotalfee(reqBO.getTotalAmount().divide(new BigDecimal(10000)));
            itemRspBO.setFee(itemRspBO.getTotalfee());
            itemRspBO.setSaleOrderItemList(reqBO.getSaleOrderItemList());
            itemRspBO.setCreateName(reqBO.getCreateName());
            itemRspBO.setEcpPurType(reqBO.getEcpPurType());
            itemRspBO.setCompanyId(reqBO.getCompanyId());
            itemRspBO.setAgrId(((PebExtRedundantSuppliesSkuInfo)reqBO.getSaleOrderItemList().get(0)).getAgrId());
            itemRspBO.setMemId(reqBO.getMemId());
            itemRspBO.setMemUserType(reqBO.getMemUserType());
            if (CollectionUtils.isNotEmpty((Collection)reqBO.getActiveBOList())) {
                itemRspBO.setActiveId(((UocCoreActiveReqBO)reqBO.getActiveBOList().get(0)).getActiveId());
                itemRspBO.setFl(Boolean.valueOf(true));
            } else {
                itemRspBO.setFl(Boolean.valueOf(false));
            }
            ArrayList<GoodsInfoIdBO> goodsInfoIdAbilityBOList = new ArrayList<GoodsInfoIdBO>();
            GoodsListDelReqBO goodsListDelReqBO = new GoodsListDelReqBO();
            for (PebExtRedundantSuppliesSkuInfo skuInfo : reqBO.getSaleOrderItemList()) {
                GoodsInfoIdBO goodsInfoIdBO = new GoodsInfoIdBO();
                goodsInfoIdBO.setSkuId(skuInfo.getSkuId());
                goodsInfoIdAbilityBOList.add(goodsInfoIdBO);
                goodsListDelReqBO.setMemberId(String.valueOf(reqBO.getUserId()));
                goodsListDelReqBO.setGoodsInfoList(goodsInfoIdAbilityBOList);
            }
            try {
                this.pebIntfGoodsListDelAbilityService.delGoodsList(goodsListDelReqBO);
            }
            catch (Exception e) {
                log.debug("\u5220\u9664\u8d2d\u7269\u8f66\u5931\u8d25" + e);
            }
            this.uocCreateOrderMsgProvider.send(new ProxyMessage(this.topic, this.tag, JSONObject.toJSONString((Object)itemRspBO)));
            UocPebOrdIdxSyncReqBO combReqBO = new UocPebOrdIdxSyncReqBO();
            combReqBO.setOrderId(itemRspBO.getOrderId());
            combReqBO.setObjId(Long.valueOf(itemRspBO.getSaleOrderId()));
            combReqBO.setObjType(UocCoreConstant.OBJ_TYPE.SALE);
            combReqBO.setIsStatistics(Boolean.valueOf(false));
            this.uocPebSyncOrderListMqServiceProvider.send(new ProxyMessage(this.orderSyncTopic, this.orderSyncTag, JSON.toJSONString((Object)combReqBO)));
        }
        submitOrderSaleItem.add(itemRspBO);
    }

    private EnterpriseAccountBO qryOrgEffAccount(EnterpriseAccountBO enterpriseAccountBO) {
        QryOrgEffAccountReqBO qryOrgEffAccountReqBO = new QryOrgEffAccountReqBO();
        qryOrgEffAccountReqBO.setOrgIdWeb(enterpriseAccountBO.getDeliveryCenterId());
        log.debug("\u67e5\u8be2\u8fd0\u8425\u5546\u4fe1\u606f\u8c03\u7528" + JSON.toJSONString((Object)qryOrgEffAccountReqBO));
        QryOrgEffAccountRspBO rspBO = this.pebIntfQryOrgEffAccountAbilityService.qryOrgEffAccount(qryOrgEffAccountReqBO);
        log.debug("\u67e5\u8be2\u8fd0\u8425\u5546\u4fe1\u606f\u8c03\u7528" + JSON.toJSONString((Object)rspBO));
        if (CollectionUtils.isEmpty((Collection)rspBO.getRows())) {
            return null;
        }
        return (EnterpriseAccountBO)rspBO.getRows().get(0);
    }

    private EnterpriseAccountBO qryEnterpriseAccountDetail(PebExtRedundantSuppliesCreateOrderReqBO reqBO) {
        QryEnterpriseAccountDetailReqBO account = new QryEnterpriseAccountDetailReqBO();
        account.setAccountId(reqBO.getPurchaserAccount());
        try {
            QryEnterpriseAccountDetailRspBO rspBO = this.pebIntfQryEnterpriseAccountDetailAbilityService.qryEnterpriseAccountDetail(account);
            if (!"0000".equals(rspBO.getRespCode())) {
                throw new UocProBusinessException("8888", "\u67e5\u8be2\u8d26\u5957\u4fe1\u606f\u5931\u8d25" + rspBO.getRespDesc());
            }
            EnterpriseAccountBO accountBO = rspBO.getUmcEnterpriseAccountBO();
            if (accountBO == null) {
                throw new UocProBusinessException("8888", "\u67e5\u8be2\u8d26\u5957\u4fe1\u606f\u8be6\u60c5\u7ed3\u679c\u4e3a\u7a7a");
            }
            return accountBO;
        }
        catch (Exception e) {
            throw new UocProBusinessException("8888", "\u67e5\u8be2\u8d26\u5957\u4fe1\u606f\u5931\u8d25" + e.getMessage());
        }
    }
}

