/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.uoc.self.comb.impl;

import cn.hutool.core.util.ObjectUtil;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.ohaotian.plugin.mq.proxy.ProxyMessage;
import com.ohaotian.plugin.mq.proxy.ProxyMessageProducer;
import com.tydic.uoc.base.constants.PebExtConstant;
import com.tydic.uoc.base.constants.UocConstant;
import com.tydic.uoc.base.exception.UocProBusinessException;
import com.tydic.uoc.base.utils.UocProRspBoUtil;
import com.tydic.uoc.busibase.busi.api.PebIntfEnterpriseOrgDetailAbilityService;
import com.tydic.uoc.busibase.busi.api.PebIntfQryEnterpriseAccountDetailAbilityService;
import com.tydic.uoc.busibase.busi.api.PebIntfQryOrgEffAccountAbilityService;
import com.tydic.uoc.busibase.busi.api.PebIntfQrySupplierInfoListAbilityService;
import com.tydic.uoc.busibase.busi.bo.EnterpriseOrgDetailReqBO;
import com.tydic.uoc.busibase.busi.bo.EnterpriseOrgDetailRspBO;
import com.tydic.uoc.busibase.busi.bo.QryEnterpriseAccountDetailReqBO;
import com.tydic.uoc.busibase.busi.bo.QryEnterpriseAccountDetailRspBO;
import com.tydic.uoc.busibase.busi.bo.QryOrgEffAccountReqBO;
import com.tydic.uoc.busibase.busi.bo.QryOrgEffAccountRspBO;
import com.tydic.uoc.busibase.busi.bo.QrySupplierInfoListReqBO;
import com.tydic.uoc.busibase.busi.bo.QrySupplierInfoListRspBO;
import com.tydic.uoc.busibase.busi.bo.SupplierInfoBO;
import com.tydic.uoc.common.ability.bo.EnterpriseAccountBO;
import com.tydic.uoc.common.ability.bo.GoodsInfoIdBO;
import com.tydic.uoc.common.ability.bo.GoodsListDelReqBO;
import com.tydic.uoc.common.ability.bo.PebExtThirdSupplierSkuInfo;
import com.tydic.uoc.common.ability.bo.PebExtThirdSupplierSubmitOrderSaleItemRspBO;
import com.tydic.uoc.common.ability.bo.UocCoreActiveReqBO;
import com.tydic.uoc.common.ability.bo.UocPebOrdIdxSyncReqBO;
import com.tydic.uoc.common.busi.api.PebExtExecuteSyncPlanBusiService;
import com.tydic.uoc.common.busi.api.PebExtUpdatePlanBusiService;
import com.tydic.uoc.self.ability.bo.PebExtSelfCreateOrderReqBO;
import com.tydic.uoc.self.ability.bo.PebExtSelfCreateOrderRspBO;
import com.tydic.uoc.self.busi.api.PebExtSelfCreateOrderBusiService;
import com.tydic.uoc.self.busi.api.PebExtSelfCreateOrderCheckBusiService;
import com.tydic.uoc.self.comb.api.PebExtSelfCreateOrderCombService;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

@Service
public class PebExtSelfCreateOrderCombServiceImpl
implements PebExtSelfCreateOrderCombService {
    private static final Logger log = LoggerFactory.getLogger(PebExtSelfCreateOrderCombServiceImpl.class);
    @Autowired
    private PebIntfQryOrgEffAccountAbilityService pebIntfQryOrgEffAccountAbilityService;
    @Autowired
    private PebIntfQryEnterpriseAccountDetailAbilityService pebIntfQryEnterpriseAccountDetailAbilityService;
    @Resource(name="uocSelfCreateOrderMsgProvider")
    private ProxyMessageProducer uocSelfCreateOrderMsgProvider;
    @Value(value="${UOC_SELF_ORDER_CREATE_TOPIC}")
    private String topic;
    @Value(value="${UOC_SELF_ORDER_CREATE_TAG}")
    private String tag;
    @Value(value="${UOC_PEB_ORDER_SYNC_TOPIC}")
    private String orderSyncTopic;
    @Value(value="${UOC_PEB_ORDER_SYNC_TAG}")
    private String orderSyncTag;
    @Resource(name="uocPebSyncOrderListMqServiceProvider")
    private ProxyMessageProducer uocPebSyncOrderListMqServiceProvider;
    @Autowired
    private PebExtExecuteSyncPlanBusiService pebExtExecuteSyncPlanBusiService;
    @Autowired
    private PebExtUpdatePlanBusiService pebExtUpdatePlanBusiService;
    @Autowired
    private PebIntfEnterpriseOrgDetailAbilityService pebIntfEnterpriseOrgDetailAbilityService;
    @Autowired
    private PebExtSelfCreateOrderCheckBusiService pebExtSelfCreateOrderCheckBusiService;
    @Autowired
    private PebExtSelfCreateOrderBusiService pebExtSelfCreateOrderBusiService;
    @Autowired
    private PebIntfQrySupplierInfoListAbilityService pebIntfQrySupplierInfoListAbilityService;

    @Override
    public PebExtSelfCreateOrderRspBO dealPebExtSelfCreateOrder(PebExtSelfCreateOrderReqBO reqBO) {
        PebExtSelfCreateOrderRspBO rspBO;
        if (StringUtils.isBlank((CharSequence)reqBO.getOrderSource())) {
            reqBO.setOrderSource(UocConstant.ORDER_SOURCE.PROTOCOL_GENERATION.toString());
        }
        EnterpriseAccountBO umcEnterpriseAccountBO = this.qryEnterpriseAccountDetail(reqBO);
        reqBO.setPurchaserAccountOrgId(umcEnterpriseAccountBO.getOrgId());
        reqBO.setProfessionalOrganizationId(umcEnterpriseAccountBO.getDeliveryCenterId());
        reqBO.setEnterpriseAccountBO(umcEnterpriseAccountBO);
        EnterpriseOrgDetailReqBO detailReqBO = new EnterpriseOrgDetailReqBO();
        detailReqBO.setOrgIdWeb(umcEnterpriseAccountBO.getDeliveryCenterId());
        EnterpriseOrgDetailRspBO detailRspBO = this.pebIntfEnterpriseOrgDetailAbilityService.queryEnterpriseOrgByDetail(detailReqBO);
        if (!"0000".equals(detailRspBO.getRespCode())) {
            throw new UocProBusinessException("8888", "\u67e5\u8be2\u8fd0\u8425\u5355\u4f4d\u5931\u8d25" + detailRspBO.getRespDesc());
        }
        if (detailRspBO.getUmcEnterpriseOrgAbilityBO() == null) {
            throw new UocProBusinessException("8888", "\u67e5\u8be2\u8fd0\u8425\u5355\u4f4d\u4e3a\u7a7a");
        }
        reqBO.setProPhone(detailRspBO.getUmcEnterpriseOrgAbilityBO().getPhone());
        reqBO.setProName(detailRspBO.getUmcEnterpriseOrgAbilityBO().getOrgName());
        reqBO.setProPath(detailRspBO.getUmcEnterpriseOrgAbilityBO().getOrgTreePath());
        EnterpriseAccountBO enterpriseAccountBO = this.qryOrgEffAccount(umcEnterpriseAccountBO);
        if (enterpriseAccountBO != null) {
            reqBO.setProAccount(enterpriseAccountBO.getAccountId());
        }
        if (!"0000".equals((rspBO = this.pebExtSelfCreateOrderCheckBusiService.dealPebCreateOrderCheck(reqBO)).getRespCode())) {
            throw new UocProBusinessException("8888", rspBO.getRespDesc());
        }
        Map selfGoods = reqBO.getSelfGoods();
        Map fpGoods = reqBO.getFpGoods();
        Map otherGoods = reqBO.getOtherGoods();
        Map planSelfGoods = reqBO.getPlanSelfGoods();
        Map planFpGoods = reqBO.getPlanFpGoods();
        Map planOtherGoods = reqBO.getPlanOtherGoods();
        ArrayList<PebExtThirdSupplierSubmitOrderSaleItemRspBO> submitOrderSaleItem = new ArrayList<PebExtThirdSupplierSubmitOrderSaleItemRspBO>();
        rspBO.setSubmitOrderSaleItem(submitOrderSaleItem);
        this.planCreate(submitOrderSaleItem, planSelfGoods, reqBO, rspBO);
        this.planCreate(submitOrderSaleItem, planFpGoods, reqBO, rspBO);
        this.planCreate(submitOrderSaleItem, planOtherGoods, reqBO, rspBO);
        this.create(submitOrderSaleItem, selfGoods, reqBO, rspBO);
        this.create(submitOrderSaleItem, fpGoods, reqBO, rspBO);
        this.create(submitOrderSaleItem, otherGoods, reqBO, rspBO);
        for (PebExtThirdSupplierSubmitOrderSaleItemRspBO tempBo : submitOrderSaleItem) {
            Boolean success = tempBo.getSuccess();
            String failMsg = tempBo.getFailMsg();
            if (success == null || success.booleanValue()) continue;
            rspBO = (PebExtSelfCreateOrderRspBO)UocProRspBoUtil.failed((String)failMsg, PebExtSelfCreateOrderRspBO.class);
            return rspBO;
        }
        return rspBO;
    }

    private void planCreate(List<PebExtThirdSupplierSubmitOrderSaleItemRspBO> submitOrderSaleItem, Map<String, List<PebExtThirdSupplierSkuInfo>> splitGoods, PebExtSelfCreateOrderReqBO reqBO, PebExtSelfCreateOrderRspBO rspBO) {
        for (String key : splitGoods.keySet()) {
            Map<Long, List<PebExtThirdSupplierSkuInfo>> skuInfo = splitGoods.get(key).stream().filter(item -> !ObjectUtil.isEmpty((Object)item.getPlanId())).collect(Collectors.groupingBy(PebExtThirdSupplierSkuInfo::getPlanId));
            for (Long planId : skuInfo.keySet()) {
                List<PebExtThirdSupplierSkuInfo> goods = skuInfo.get(planId);
                if (!PebExtConstant.SourceAssort.ZY.equals(goods.get(0).getSourceAssort())) {
                    if (goods.get(0).getContractId() != null) {
                        Map<Long, List<PebExtThirdSupplierSkuInfo>> info = goods.stream().collect(Collectors.groupingBy(PebExtThirdSupplierSkuInfo::getContractId));
                        for (Long contractId : info.keySet()) {
                            this.createOrder(reqBO, submitOrderSaleItem, info.get(contractId), rspBO);
                        }
                        continue;
                    }
                    this.createOrder(reqBO, submitOrderSaleItem, goods, rspBO);
                    continue;
                }
                this.createOrder(reqBO, submitOrderSaleItem, goods, rspBO);
            }
        }
    }

    private void uocPebOrdIdxSync(PebExtSelfCreateOrderRspBO rspBO) {
        UocPebOrdIdxSyncReqBO reqBO = new UocPebOrdIdxSyncReqBO();
        reqBO.setOrderId(rspBO.getOrderId());
        reqBO.setIsStatistics(Boolean.valueOf(false));
        reqBO.setObjId(Long.valueOf(rspBO.getSaleOrderId()));
        reqBO.setObjType(UocConstant.OBJ_TYPE.SALE);
        this.uocPebSyncOrderListMqServiceProvider.send(new ProxyMessage(this.orderSyncTopic, this.orderSyncTag, JSON.toJSONString((Object)reqBO)));
    }

    private void create(List<PebExtThirdSupplierSubmitOrderSaleItemRspBO> submitOrderSaleItem, Map<String, List<PebExtThirdSupplierSkuInfo>> splitGoods, PebExtSelfCreateOrderReqBO reqBO, PebExtSelfCreateOrderRspBO rspBO) {
        for (String key : splitGoods.keySet()) {
            List<PebExtThirdSupplierSkuInfo> skuInfos = splitGoods.get(key);
            PebExtThirdSupplierSkuInfo goods = splitGoods.get(key).get(0);
            if (!PebExtConstant.SourceAssort.ZY.equals(goods.getSourceAssort())) {
                if (skuInfos.get(0).getContractId() != null) {
                    Map<Long, List<PebExtThirdSupplierSkuInfo>> skuInfo = skuInfos.stream().collect(Collectors.groupingBy(PebExtThirdSupplierSkuInfo::getContractId));
                    for (Long contractId : skuInfo.keySet()) {
                        this.createOrder(reqBO, submitOrderSaleItem, skuInfo.get(contractId), rspBO);
                    }
                    continue;
                }
                this.createOrder(reqBO, submitOrderSaleItem, skuInfos, rspBO);
                continue;
            }
            this.createOrder(reqBO, submitOrderSaleItem, skuInfos, rspBO);
        }
    }

    private void createPlanOrder(PebExtSelfCreateOrderReqBO reqBO, List<PebExtThirdSupplierSubmitOrderSaleItemRspBO> submitOrderSaleItem, List<PebExtThirdSupplierSkuInfo> goods, PebExtSelfCreateOrderRspBO rspBO) {
        reqBO.setSaleOrderItemList(goods);
        reqBO.setPrOrderId(rspBO.getOrderId());
        reqBO.setProcKey("cnnc_self_sale_order_master_order_status");
        reqBO.setJc(Boolean.valueOf(true));
        reqBO.setEcpPurType("1");
        PebExtSelfCreateOrderRspBO orderRspBO = this.pebExtSelfCreateOrderBusiService.dealPebExtSelfCreateOrder(reqBO);
        PebExtThirdSupplierSubmitOrderSaleItemRspBO itemRspBO = new PebExtThirdSupplierSubmitOrderSaleItemRspBO();
        if (!"0000".equals(orderRspBO.getRespCode())) {
            itemRspBO.setSuccess(Boolean.valueOf(false));
            itemRspBO.setFailMsg(orderRspBO.getRespDesc());
            itemRspBO.setGoodSupplierName(orderRspBO.getGoodSupplierName());
            itemRspBO.setGoodsSupplierId(orderRspBO.getGoodsSupplierId());
        } else {
            BeanUtils.copyProperties((Object)orderRspBO, (Object)itemRspBO);
            itemRspBO.setToken(reqBO.getToken());
            itemRspBO.setOrderId(orderRspBO.getOrderId());
            itemRspBO.setIsPreOrder(Integer.valueOf(0));
            itemRspBO.setUserId(reqBO.getUserId());
            itemRspBO.setOrgId(reqBO.getOrgId());
            itemRspBO.setSaleOrderId(orderRspBO.getSaleOrderId());
            itemRspBO.setSaleOrderItemList(goods);
            itemRspBO.setCreateName(reqBO.getCreateName());
            this.savePlan(reqBO.getSaleOrderItemList());
            itemRspBO.setEcpPurType(reqBO.getEcpPurType());
            itemRspBO.setOrgPath(reqBO.getOrgPath());
            itemRspBO.setCompanyId(reqBO.getCompanyId());
            itemRspBO.setMemId(reqBO.getMemId());
            itemRspBO.setPayConfig(reqBO.getPayConfig());
            itemRspBO.setAccountId(reqBO.getPurchaserAccount());
            if (CollectionUtils.isNotEmpty((Collection)reqBO.getActiveBOList())) {
                itemRspBO.setActiveId(((UocCoreActiveReqBO)reqBO.getActiveBOList().get(0)).getActiveId());
                itemRspBO.setFl(Boolean.valueOf(true));
            } else {
                itemRspBO.setFl(Boolean.valueOf(false));
            }
            this.uocPebOrdIdxSync(orderRspBO);
            ArrayList<GoodsInfoIdBO> goodsInfoIdAbilityBOList = new ArrayList<GoodsInfoIdBO>();
            GoodsListDelReqBO goodsListDelReqBO = new GoodsListDelReqBO();
            for (PebExtThirdSupplierSkuInfo info : reqBO.getSaleOrderItemList()) {
                GoodsInfoIdBO goodsInfoIdBO = new GoodsInfoIdBO();
                goodsInfoIdAbilityBOList.add(goodsInfoIdBO);
                goodsInfoIdBO.setSkuId(info.getSkuId());
                goodsListDelReqBO.setGoodsInfoList(goodsInfoIdAbilityBOList);
                goodsListDelReqBO.setMemberId(String.valueOf(reqBO.getUserId()));
            }
            itemRspBO.setGoodsListDelReqBO(goodsListDelReqBO);
            this.uocSelfCreateOrderMsgProvider.send(new ProxyMessage(this.topic, this.tag, JSONObject.toJSONString((Object)itemRspBO)));
        }
        submitOrderSaleItem.add(itemRspBO);
    }

    private void createOrder(PebExtSelfCreateOrderReqBO reqBO, List<PebExtThirdSupplierSubmitOrderSaleItemRspBO> submitOrderSaleItem, List<PebExtThirdSupplierSkuInfo> goods, PebExtSelfCreateOrderRspBO rspBO) {
        reqBO.setSaleOrderItemList(goods);
        reqBO.setPrOrderId(rspBO.getOrderId());
        reqBO.setProcKey("cnnc_self_sale_order_master_order_status");
        reqBO.setJc(Boolean.valueOf(false));
        reqBO.setEcpPurType("1");
        PebExtSelfCreateOrderRspBO orderRspBO = this.pebExtSelfCreateOrderBusiService.dealPebExtSelfCreateOrder(reqBO);
        PebExtThirdSupplierSubmitOrderSaleItemRspBO itemRspBO = new PebExtThirdSupplierSubmitOrderSaleItemRspBO();
        if (!"0000".equals(orderRspBO.getRespCode())) {
            itemRspBO.setGoodSupplierName(orderRspBO.getGoodSupplierName());
            itemRspBO.setGoodsSupplierId(orderRspBO.getGoodsSupplierId());
            itemRspBO.setSuccess(Boolean.valueOf(false));
            itemRspBO.setFailMsg(orderRspBO.getRespDesc());
        } else {
            BeanUtils.copyProperties((Object)orderRspBO, (Object)itemRspBO);
            itemRspBO.setIsPreOrder(Integer.valueOf(0));
            itemRspBO.setUserId(reqBO.getUserId());
            itemRspBO.setOrgId(reqBO.getOrgId());
            itemRspBO.setToken(reqBO.getToken());
            itemRspBO.setOrderId(orderRspBO.getOrderId());
            itemRspBO.setSaleOrderId(orderRspBO.getSaleOrderId());
            itemRspBO.setEcpPurType(reqBO.getEcpPurType());
            itemRspBO.setCreateName(reqBO.getCreateName());
            itemRspBO.setSaleOrderItemList(reqBO.getSaleOrderItemList());
            itemRspBO.setOrgPath(reqBO.getOrgPath());
            itemRspBO.setCompanyId(reqBO.getCompanyId());
            itemRspBO.setMemId(reqBO.getMemId());
            itemRspBO.setPayConfig(reqBO.getPayConfig());
            itemRspBO.setAccountId(reqBO.getPurchaserAccount());
            if (CollectionUtils.isNotEmpty((Collection)reqBO.getActiveBOList())) {
                itemRspBO.setActiveId(((UocCoreActiveReqBO)reqBO.getActiveBOList().get(0)).getActiveId());
                itemRspBO.setFl(Boolean.valueOf(true));
            } else {
                itemRspBO.setFl(Boolean.valueOf(false));
            }
            this.uocPebOrdIdxSync(orderRspBO);
            ArrayList<GoodsInfoIdBO> goodsInfoIdAbilityBOList = new ArrayList<GoodsInfoIdBO>();
            GoodsListDelReqBO goodsListDelReqBO = new GoodsListDelReqBO();
            for (PebExtThirdSupplierSkuInfo skuInfo : reqBO.getSaleOrderItemList()) {
                GoodsInfoIdBO goodsInfoIdBO = new GoodsInfoIdBO();
                goodsInfoIdBO.setSkuId(skuInfo.getSkuId());
                goodsInfoIdAbilityBOList.add(goodsInfoIdBO);
                goodsListDelReqBO.setMemberId(String.valueOf(reqBO.getUserId()));
                goodsListDelReqBO.setGoodsInfoList(goodsInfoIdAbilityBOList);
            }
            itemRspBO.setGoodsListDelReqBO(goodsListDelReqBO);
            this.uocSelfCreateOrderMsgProvider.send(new ProxyMessage(this.topic, this.tag, JSONObject.toJSONString((Object)itemRspBO)));
        }
        submitOrderSaleItem.add(itemRspBO);
    }

    private void savePlan(List<PebExtThirdSupplierSkuInfo> saleOrderItemList) {
    }

    private EnterpriseAccountBO qryEnterpriseAccountDetail(PebExtSelfCreateOrderReqBO reqBO) {
        QryEnterpriseAccountDetailReqBO account = new QryEnterpriseAccountDetailReqBO();
        account.setAccountId(reqBO.getPurchaserAccount());
        try {
            log.debug("\u8d26\u5957\u4fe1\u606f\u5165\u53c2\uff1a" + JSON.toJSONString((Object)account));
            QryEnterpriseAccountDetailRspBO rspBO = this.pebIntfQryEnterpriseAccountDetailAbilityService.qryEnterpriseAccountDetail(account);
            log.debug("\u8d26\u5957\u4fe1\u606f\u56de\u53c2\uff1a" + JSON.toJSONString((Object)rspBO));
            if (!"0000".equals(rspBO.getRespCode())) {
                throw new UocProBusinessException("8888", "\u67e5\u8be2\u8d26\u5957\u4fe1\u606f\u5931\u8d25" + rspBO.getRespDesc());
            }
            EnterpriseAccountBO accountBO = rspBO.getUmcEnterpriseAccountBO();
            if (accountBO == null) {
                throw new UocProBusinessException("8888", "\u67e5\u8be2\u8d26\u5957\u4fe1\u606f\u8be6\u60c5\u7ed3\u679c\u4e3a\u7a7a");
            }
            return accountBO;
        }
        catch (Exception e) {
            throw new UocProBusinessException("8888", "\u67e5\u8be2\u8d26\u5957\u4fe1\u606f\u5931\u8d25" + e.getMessage());
        }
    }

    private EnterpriseAccountBO qryOrgEffAccount(EnterpriseAccountBO enterpriseAccountBO) {
        QryOrgEffAccountReqBO qryOrgEffAccountReqBO = new QryOrgEffAccountReqBO();
        qryOrgEffAccountReqBO.setOrgIdWeb(enterpriseAccountBO.getDeliveryCenterId());
        log.debug("\u67e5\u8be2\u5e73\u53f0\u5546\u4fe1\u606f\u8c03\u7528" + JSON.toJSONString((Object)qryOrgEffAccountReqBO));
        QryOrgEffAccountRspBO rspBO = this.pebIntfQryOrgEffAccountAbilityService.qryOrgEffAccount(qryOrgEffAccountReqBO);
        log.debug("\u67e5\u8be2\u5e73\u53f0\u5546\u4fe1\u606f\u8c03\u7528" + JSON.toJSONString((Object)rspBO));
        if (CollectionUtils.isEmpty((Collection)rspBO.getRows())) {
            return null;
        }
        return (EnterpriseAccountBO)rspBO.getRows().get(0);
    }

    private SupplierInfoBO qrySupplierName(Long supplierId) {
        ArrayList<Long> supplierIds = new ArrayList<Long>();
        supplierIds.add(supplierId);
        QrySupplierInfoListReqBO qrySupplierInfoMapByIdsReqBO = new QrySupplierInfoListReqBO();
        qrySupplierInfoMapByIdsReqBO.setSupplierIds(supplierIds);
        QrySupplierInfoListRspBO supplierInfoList = this.pebIntfQrySupplierInfoListAbilityService.qrySupplierInfoList(qrySupplierInfoMapByIdsReqBO);
        if (CollectionUtils.isNotEmpty((Collection)supplierInfoList.getRows())) {
            return (SupplierInfoBO)supplierInfoList.getRows().get(0);
        }
        return null;
    }
}

