package com.tydic.first.api;

import com.google.common.collect.Lists;

import java.io.Serializable;
import java.util.List;

/**
 * 类名：RspPage
 * 标题：
 * 说明：
 * 时间：2023/11/3
 *
 * @author qinys
 * @copyright 2023 All rights reserved.
 **/
public class RspPage<T> implements Serializable {

    private static final long serialVersionUID = 1L;

    /** 结果列表 */
    private List<T> rows;

    /** 总记录数 */
    private Long recordsTotal;

    /** 每页数目 */
    private Integer pageSize;

    /** 页码 */
    private Integer pageNo;

    /** 总页数 */
    private Long total;

    /** 当前页记录数 */
    private Integer pageCout;

    @SuppressWarnings("unused")
    private RspPage() {
    }

    /** pageSize:每页数目,pageNo:页码,rows:结果集,recordsTotal:总记录数 */
    public RspPage(Integer pageSize, Integer pageNo, List<T> rows, Long recordsTotal) {
        this.pageSize = pageSize;
        this.pageNo = pageNo;
        doCheck();
        this.recordsTotal = recordsTotal;
        this.rows = rows == null ? Lists.newArrayList() : rows;
        setTotalPage();
    }

    /**设置总记录数*/
    private void setTotalPage() {
        if (this.getRecordsTotal() == 0) {
            this.total = 0L;
        } else {
            this.total = this.getRecordsTotal() / this.getPageSize() + (this.getRecordsTotal() % this.getPageSize() == 0 ? 0 : 1);
        }
    }

    private void doCheck() {
        if (null == this.pageSize || this.pageSize < 1) {
            throw new IllegalArgumentException("the pageSize value was illegal.");
        }
        if (null == this.pageNo || this.pageNo < 1) {
            throw new IllegalArgumentException("the pageNo value was illegal.");
        }
    }

    /** {@linkplain #rows} */
    public List<T> getRows() {
        return null == rows ? Lists.newArrayList() : rows;
    }

    /** {@linkplain #recordsTotal} */
    public Long getRecordsTotal() {
        if (null == recordsTotal || recordsTotal <= 0) {
            recordsTotal = 0L;
        }
        return recordsTotal;
    }

    /** {@linkplain #pageSize} */
    public Integer getPageSize() {
        return pageSize;
    }

    /** {@linkplain #pageNo} */
    public Integer getPageNo() {
        return pageNo;
    }

    /** {@linkplain #total} */
    public Long getTotal() {
        return total;
    }

    /** {@linkplain #pageCout} */
    public Integer getPageCout() {
        pageCout = null == rows ? 0 : rows.size();
        return pageCout;
    }

    @Override
    public String toString() {
        return "Page [rows=" + rows + ", recordsTotal=" + recordsTotal + ", pageSize=" + pageSize + ", pageNo="
                + pageNo + ", total=" + total + ", pageCout=" + pageCout + "]";
    }

}
