package com.tydic.first.api.activity.po;

import java.math.BigDecimal;
import java.util.Date;
import lombok.Data;

/**
 * 类名：ActivityUserPo
 * 标题：
 * 说明：
 * 时间：2024/4/15 20:38
 *
 * @author yangyf
**/

/**
 * 活动用户信息表
 */
@Data
public class ActivityUserPo {
    /**
     * 业务系统用户唯一标识别，业务系统内保证唯一
     */
    private String userId;

    /**
     * 姓名
     */
    private String name;

    /**
     * 邮箱。员工号、邮箱、手机号三者中至少一个必传
     */
    private String email;

    /**
     * 手机号。员工号、邮箱、手机号三者中至少一个必传
     */
    private String mobile;

    /**
     * 员工号。员工号、邮箱、手机号三者中至少一个必传
     */
    private String employeeId;

    /**
     * 性别，0表示女，1表示男
     */
    private String gender;

    /**
     * 已分配金额
     */
    private BigDecimal income;

    /**
     * 所属部门，多个部门用逗号隔开
     */
    private String departmentId;

    /**
     * 用户所属组织ID
     */
    private Long userOrgId;

    /**
     * 用户所属组织名称
     */
    private String userOrgName;

    /**
     * 积分状态（0：正常，1：冻结）
     */
    private Integer scoresType;

    /**
     * 发放积分（第一次的发放）
     */
    private BigDecimal giveScores;

    /**
     * 已使用积分
     */
    private BigDecimal usedScores;

    /**
     * 剩余可用积分
     */
    private BigDecimal balanceScores;

    /**
     * 删除标志  0:未删除；1：已删除
     */
    private Integer delFlag;

    /**
     * 活动id
     */
    private String activityCode;

    /**
     * 备注
     */
    private String remark;

    /**
     * 生日
     */
    private Date birthDay;

    /**
     * 入职日期
     */
    private Date entryDay;

    /**
     * 用户pin
     */
    private String bcode;
}