package com.tydic.first.api.order.bo;

import com.tydic.first.api.order.po.domain.OrderItem;
import lombok.Data;
import lombok.NoArgsConstructor;

import java.util.List;

/**
 * 标题：OrderDetailsBO
 * 说明：
 * 时间：2023/11/21 16:11
 *
 * @author hcl
 **/
@NoArgsConstructor
@Data
public class OrderDetailsBO {

    private OrderDetail orderDetail;
    private IonsigneeInfo ionsigneeInfo;
    private InvoiceInfo invoiceInfo;


    private List<OrderItem> orderItemList;



    @NoArgsConstructor
    @Data
    public static class OrderDetail {
        private String companyName;
        private String orderId;

        private String thirdOrder;
        private String paymentType;
        //订单备注
        private String remark;
        //采购人
        private String puchaseAccount;
        //电话
        private String purchaseMobile;
    }

    @NoArgsConstructor
    @Data
    public static class IonsigneeInfo {
        //收货人
        private String name;
        //电话
        private String mobile;

        private String province;
        private String city;
        private String county;
        private String town;
        private String address;
    }


    @NoArgsConstructor
    @Data
    public static class InvoiceInfo {
        /**
         * 收票人
         */
        private String invoiceName;
        private String invoicePhone;
        private String invoiceProvice;
        private String invoiceCity;
        private String invoiceCounty;
        private String invoiceAddress;

        /**
         * 发票信息
         */
        private String invoiceType;
        private String companyName;
    }


}
