package com.tydic.first.api.order.bo.fjdm;


import com.fasterxml.jackson.annotation.JsonFormat;
import com.tydic.first.api.BaseEntity;
import lombok.Data;

import javax.validation.constraints.NotBlank;
import java.math.BigDecimal;
import java.util.Date;
import java.util.List;

/**
 * 非京东order请求
 *
 * @author hcl
 * @version 1.0
 * @date 2023年10月31日
 */
@Data
public class FjdOrderReqBO extends BaseEntity {

    private String remark;
    /**
     * 会员id
     */
    private Long memberId;

    /**
     * 商城订单号
     */
    @NotBlank(message = "thirdOrder不能为空")
    private String thirdOrder;

    @NotBlank(message = "thirdOrderNo不能为空")
    private String thirdOrderNo;

    /**
     * 订单号
     */
    private String orderId;

    /**
     * 用户名
     */
    @NotBlank(message = "name不能为空")
    private String name;

    /**
     * 一级地址
     */
    private String province;

    /**
     * 二级地址
     */
    @NotBlank(message = "city不能为空")
    private String city;

    /**
     * 三级地址
     */
    @NotBlank(message = "county不能为空")
    private String county;

    /**
     * 四级地址
     */
    @NotBlank(message = "town不能为空")
    private String town;

    /**
     * 一级地址名称
     */
    private String provinceName;

    /**
     * 二级地址名称
     */
    private String cityName;

    /**
     * 三级地址名称
     */
    private String countyName;

    /**
     * 四级地址名称
     */
    private String townName;

    /**
     * 详细地址
     */
    @NotBlank(message = "address不能为空")
    private String address;

    /**
     * 收货人邮编
     */
    private String zip;

    /**
     * 座机号
     */
    private String phone;

    /**
     * 手机号
     */
    @NotBlank(message = "mobile不能为空")
    private String mobile;

    /**
     * 邮箱
     */
    private String email;

    /**
     * 采购单位
     */
    private String purchaseId;

    /**
     * 采购单位名称
     */
    private String purchaseName;

    /**
     * 下单人
     */
    private String puchaseAccount;

    /**
     * 下单人联系电话
     */
    private String purchaseMobile;

    /**
     * 是否预占库存
     */
//    @NotBlank(message = "submitState不能为空")
    private Integer submitState;

    /**
     * 下单价格模式
     */
//    @NotBlank(message = "doOrderPriceMode不能为空")
    private BigDecimal doOrderPriceMode;

    /**
     * 配送预约日期
     */
    private Long promiseDate;

    /**
     * 送达时间
     */
    @JsonFormat(pattern = "yyyy-MM-dd", timezone = "GMT+8")
    private Date deliveryDate;

    /**
     * 开票方式
     */
    private String invoiceState;

    /**
     * 发票类型
     */
    private String invoiceType;

    /**
     * 抬头类型
     */
    private String selectedInvoiceTitle;

    /**
     * 发票抬头
     */
    private String companyName;

    /**
     * 发票内容
     */
    private String invoiceContent;

    /**
     * 支付方式【1-&gt;支付宝；2-&gt;微信；3-&gt;银联； 4-&gt;货到付款；】
     */
    private Integer paymentType;

    /**
     * 是否使用余额
     */
    private Long isUseBalance;

    /**
     * 收票人姓名
     */
    private String invoiceName;

    /**
     * 收票人电话
     */
    private String invoicePhone;

    /**
     * 订单总额
     */
    private String invoiceProvice;

    /**
     * 应付总额
     */
    private String invoiceCity;

    /**
     * 运费金额
     */
    private String invoiceCounty;

    /**
     * 订单来源[0-&gt;PC订单；1-&gt;app订单]
     */
    private String invoiceProviceName;

    /**
     * 订单状态【0-&gt;待付款；1-&gt;待发货；2-&gt;已发货；3-&gt;已完成；4-&gt;已关闭；5-&gt;无效订单】
     */
    private String invoiceCityName;

    /**
     * 物流公司(配送方式)
     */
    private String invoiceCountyName;

    /**
     * 物流单号
     */
    private String invoiceAddress;

    /**
     * 确认收货状态[0-&gt;未确认；1-&gt;已确认]
     */
    private Integer confirmStatus;

    /**
     * 删除状态【0-&gt;未删除；1-&gt;已删除】
     */
    private Integer deleteStatus;

    /**
     * 支付时间
     */
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss", timezone = "GMT+8")
    private Date paymentTime;

    /**
     * 确认收货时间
     */
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss", timezone = "GMT+8")
    private Date receiveTime;

    /**
     * 修改时间
     */
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss", timezone = "GMT+8")
    private Date modifyTime;

    /**
     * 父订单
     */
    private String pOrder;

    /**
     * 商品明细
     */
    private List<OrderItemBO> sku;
}
