package com.tydic.first.api.order.bo.fjdm;

import com.fasterxml.jackson.annotation.JsonFormat;
import com.fasterxml.jackson.annotation.JsonInclude;
import lombok.Data;

import java.io.Serializable;
import java.util.Date;


@Data
public class PushMessageBO implements Serializable {

    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss", timezone = "GMT+8")
    private Date time;

    /**
     * 消息类型
     */

    private Integer type;


    private int id;


    /**
     * 消息推送json
     */
    @JsonInclude(JsonInclude.Include.NON_EMPTY)
    private String result;

    /** 类型（1：订单2：发货单） */
    @JsonInclude(JsonInclude.Include.NON_EMPTY)
    private String orderType;


    /** 父订单id */
    @JsonInclude(JsonInclude.Include.NON_EMPTY)
    private String pOrder;


}
