package com.tydic.first.api.order.bo.jdm;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.tydic.first.api.order.po.domain.OrderTrackBO;
import lombok.Data;
import lombok.NoArgsConstructor;

import java.util.List;

/**
 * 标题：FJdOrderTrackRspBO
 * 说明：
 * 时间：2023/11/03 15:10
 *
 * @author hcl
 **/
@NoArgsConstructor
@Data
public class JdOrderTrackRspBO {


    @JsonProperty("orderTrack")
    private List<OrderTrackBO> orderTrack;
    @JsonProperty("waybillCode")
    private List<WaybillCode> waybillCode;
    @JsonProperty("jdOrderId")
    private String jdOrderId;


    @NoArgsConstructor
    @Data
    public static class WaybillCode {
        @JsonProperty("carrier")
        private String carrier;
        @JsonProperty("orderId")
        private String orderId;
        @JsonProperty("parentId")
        private String parentId;
        @JsonProperty("deliveryOrderId")
        private String deliveryOrderId;
    }
}
