package com.tydic.first.api.order.bo.jdm;

import com.fasterxml.jackson.annotation.JsonProperty;
import lombok.Data;
import lombok.NoArgsConstructor;

import java.math.BigDecimal;
import java.util.List;

/**
 * 标题：noSlipBO商城没拆单
 * 说明：
 * 时间：2023/11/01 15:00
 *
 * @author hcl
 **/
@NoArgsConstructor
@Data
public class OrderNoSlipBO {

    @JsonProperty("orderState")
    private Integer orderState;
    @JsonProperty("jdOrderState")
    private Integer jdOrderState;
    @JsonProperty("state")
    private Integer state;
    @JsonProperty("submitState")
    private Integer submitState;
    @JsonProperty("orderPrice")
    private BigDecimal orderPrice;
    @JsonProperty("orderNakedPrice")
    private BigDecimal orderNakedPrice;
    @JsonProperty("baseFreight")
    private String baseFreight;
    @JsonProperty("freight")
    private BigDecimal freight;
    @JsonProperty("sku")
    private List<Sku> sku;
    @JsonProperty("type")
    private Integer type;
    @JsonProperty("orderTaxPrice")
    private BigDecimal orderTaxPrice;
    @JsonProperty("orderId")
    private String orderId;
    @JsonProperty("jdOrderId")
    private String jdOrderId;
    private Long pOrder;
    private Integer paymentType;
    /**
     * 订单类型
     */
    private Integer orderType;

    @NoArgsConstructor
    @Data
    public static class Sku {
        @JsonProperty("category")
        private Long category;
        @JsonProperty("num")
        private Integer num;
        @JsonProperty("price")
        private BigDecimal price;
        @JsonProperty("tax")
        private Integer tax;
        @JsonProperty("oid")
        private Integer oid;
        @JsonProperty("name")
        private String name;
        @JsonProperty("taxPrice")
        private BigDecimal taxPrice;
        @JsonProperty("skuId")
        private String skuId;
        @JsonProperty("nakedPrice")
        private BigDecimal nakedPrice;
        @JsonProperty("type")
        private Integer type;
    }
}
