package com.tydic.first.api.order.po.domain;

import java.math.BigDecimal;
import java.util.Date;

import com.fasterxml.jackson.annotation.JsonFormat;
import lombok.Data;

/**
 * 订单对象 order
 *
 * @author hcl
 * @date 2022-09-26
 */
@Data
public class Order {
    private static final long serialVersionUID = 1L;

    /**
     * id
     */
    private Long id;

    /**
     * 订单类型。1是父订单 2是子订单。
     */
    private Integer type;
    private String remark;
    /**
     * 会员id
     */
    private Long memberId;

    /**
     * 商城订单号
     */
    private String thirdOrder;

    /**
     * 订单号
     */
    private String orderId;

    /**
     * 用户名
     */
    private String name;

    /**
     * 一级地址
     */
    private String province;

    /**
     * 二级地址
     */
    private String city;

    /**
     * 三级地址
     */
    private String county;

    /**
     * 四级地址
     */
    private String town;

    /**
     * 一级地址名称
     */
    private String provinceName;

    /**
     * 二级地址名称
     */
    private String cityName;

    /**
     * 三级地址名称
     */
    private String countyName;

    /**
     * 四级地址名称
     */
    private String townName;

    /**
     * 详细地址
     */
    private String address;

    /**
     * 收货人邮编
     */
    private String zip;

    /**
     * 座机号
     */
    private String phone;

    /**
     * 手机号
     */
    private String mobile;

    /**
     * 邮箱
     */
    private String email;

    /**
     * 采购单位
     */
    private String purchaseId;

    /**
     * 采购单位名称
     */
    private String purchaseName;

    /**
     * 下单人
     */
    private String puchaseAccount;

    /**
     * 下单人联系电话
     */
    private String purchaseMobile;

    /**
     * 是否预占库存0:是1：不是
     */
    private Integer submitState;

    /**
     * 下单价格模式
     */
    private BigDecimal doOrderPriceMode;

    /**
     * 配送预约日期
     */
    private Long promiseDate;

    /**
     * 送达时间
     */
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss", timezone = "GMT+8")
    private Date deliveryDate;

    /**
     * 开票方式
     */
    private String invoiceState;

    /**
     * 发票类型
     */
    private String invoiceType;

    /**
     * 抬头类型
     */
    private String selectedInvoiceTitle;

    /**
     * 发票抬头
     */
    private String companyName;

    /**
     * 发票内容
     */
    private String invoiceContent;

    /**
     * 支付方式【1-&gt;支付宝；2-&gt;微信；3-&gt;银联； 4-&gt;货到付款；】
     */
    private Integer paymentType;

    /**
     * 是否使用余额
     */
    private Long isUseBalance;

    /**
     * 收票人姓名
     */
    private String invoiceName;

    /**
     * 收票人电话
     */
    private String invoicePhone;

    /**
     * 收票人所在省
     */
    private String invoiceProvice;

    /**
     * 增值票收票人所在市
     */
    private String invoiceCity;

    /**
     * 增值票收票人所在区/县
     */
    private String invoiceCounty;

    /**
     * 收票人所在省名称
     */
    private String invoiceProviceName;

    /**
     * 增值票收票人所在市
     */
    private String invoiceCityName;

    /**
     * 增值票收票人所在区/县
     */
    private String invoiceCountyName;

    /**
     * 增值票收票人所在地址
     */
    private String invoiceAddress;

    /**
     * 确认收货状态[0-&gt;未确认；1-&gt;已确认]
     */
    private Integer confirmStatus;

    /**
     * 删除状态【0-&gt;未删除；1-&gt;已删除】
     */
    private Integer deleteStatus;

    /**
     * 支付时间
     */
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss", timezone = "GMT+8")
    private Date paymentTime;

    /**
     * 确认收货时间
     */
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss", timezone = "GMT+8")
    private Date receiveTime;

    /**
     * 修改时间
     */
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss", timezone = "GMT+8")
    private Date modifyTime;

    /**
     * 父订单
     */
    private String pOrder;
    /**
     * 是否京东 0:非京东 1京东2 苏宁
     */
    private String hsn;

    /**
     * 订单状态【0->待付款；1->待发货；2->已发货；3->已完成；4->已关闭；5->发货单发货前取消中
     */
    private Integer status;

    /**
     * 京东订单类型：订单类别。
     * 查询参数queryExts中包含orderType。
     * 参考枚举值如下：京东订单类型：订单类别。1.普通商品2.大家电3.实物礼品卡4.售后换新单5.厂家直送订单6.FBP订单7.生鲜11.ibs订单20.电子卡21.机票22.酒店23.合约机号卡24.火车票[@文祥：更新新订单类型；父单子单的订单类型形成规则。特殊说明虚拟订单，虚拟订单通常有专门的查询接口]
     */
    private Integer orderType;

}
