package com.tydic.first.api.order.po.domain;

import com.fasterxml.jackson.annotation.JsonFormat;
import lombok.Data;
import lombok.experimental.Accessors;

import java.util.Date;
import java.io.Serializable;

/**
 * 推送消息(PushMessage)实体类
 *
 * @author hcl
 * @since 2023-10-19 16:29:07
 */
@Data
@Accessors(chain = true)
public class PushMessage implements Serializable {
    private static final long serialVersionUID = -24917782581047078L;

    private Integer id;
    /**
     * 推送时间
     */
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss", timezone = "GMT+8")
    private Date time;
    /**
     * 消息类型
     */
    private Integer type;
    /**
     * 0正常1失效
     */
    private Integer state;
    /**
     * 消息推送json
     */
    private String pushResult;
    /**
     * 0非京东1京东2苏宁
     */
    private String hsn;
    /**
     * 更新时间
     */
    private Date updateTime;

    private String extFiled1;

    private String extFiled2;

    private String extFiled3;

    private String extFiled4;

    /**
     * type类型的表述
     */
    private String typeDescription;

}

