package com.tydic.first.api.product.bo.jdm;

import lombok.Data;

import java.io.Serializable;
import java.util.List;
import java.util.Map;

/**
 * 类名：GetDetailJdmRspBo
 * 标题：
 * 说明：
 * 时间：2023/10/16
 *
 * @author qinys
 * @copyright 2023 All rights reserved.
 **/
@Data
public class GetDetailJdmRspBo implements Serializable {

    private static final long serialVersionUID = 1L;

    /**
     * 商品编码
     */
    private String sku;

    /**
     * 品牌名称
     */
    private String brandName;

    /**
     * 售卖单位
     */
    private String saleUnit;

    /**
     * 重量
     */
    private String weight;

    /**
     * 产地
     */
    private String productArea;

    /**
     * 商品详情页大字段
     */
    private String introduction;

    /**
     * 包装清单
     */
    private String wareQD;

    /**
     * 主图
     */
    private String imagePath;

    /**
     * 规格参数
     */
    private String param;

    private List<Map<String, String>> paramJson;

    /**
     * 主站上下架状态 (1上架 0下架)
     */
    private String state;

    /**
     * UPC码区分实物、图书、音像、三种场景
     */
    private String upc;

    /**
     * 分类示例"670;729;4837"
     */
    private String category;

    /**
     * 商品名称
     */
    private String name;

    /**
     * 拓展字段集合
     */
    private int isSelf;
    private Integer isFactoryShip;
    private String taxCode;
    private String upc69;
    private String taxInfo;
    private String LowestBuy;
    private String appintroduce;
    private String shouhou;
    private String isEnergySaving;
    private String ChinaCatalog;
    private int isJDLogistics;
    private String seoModel;

    private String wserve;
    private String jdPcUrl;
    private String inquiryCode;

}
