package com.tydic.first.api.product.po;

import lombok.Data;

import java.io.Serializable;
import java.util.Date;

/**
 * 类名：ProductSkuPo
 * 标题：商品表;product_sku表持久层实体类
 * 说明：商品表;product_sku表持久层实体类
 * 时间：2023/10/13
 *
 * @author qinys
 * @copyright 2023 All rights reserved.
 **/
@Data
public class ProductSkuPo implements Serializable {

    private static final long serialVersionUID = 1L;

    /**
     * 商品编号
     */
    private Long skuId;

    /**
     * 所拷贝的商品id
     */
    private Long copySkuId;

    /**
     * 产品编号
     */
    private Long spuId;

    /**
     * 主图地址
     */
    private String imagePath;

    /**
     * 单品名称
     */
    private String name;

    /**
     * 销售单位
     */
    private String saleUnit;

    /**
     * 销售结算单位是否一致。1：一致 0：不一致 默认一致
     */
    private Integer type;

    /**
     * 结算单位。销售单位结果单位不一致时，必须传输
     */
    private String settleUnit;

    /**
     * 结算转换率。
     */
    private String settleRate;

    /**
     * 分子
     */
    private Integer molecule;

    /**
     * 分母
     */
    private Integer denominator;

    /**
     * 条形码
     */
    private String upc;

    /**
     * 预计发货日。Mro专用 单位：天 如果有现货则传0
     */
    private Integer deliveryTime;

    /**
     * 上下架状态。1：上架 0：下架
     */
    private Integer state;

    /**
     * 重量
     */
    private String weight;

    /**
     * 单品描述。HTML页面，可直接展现
     */
    private String introduction;

    /**
     * 最小起订量。Mro专用 京东叫LowestBuy
     */
    private Integer moq;

    /**
     * 最小增量
     */
    private Integer mincrement;

    /**
     * 制造商型号。Mro专用
     */
    private String mfgSku;

    /**
     * 规格
     */
    private String spec;

    /**
     * 型号
     */
    private String model;

    /**
     * 京东规格参数
     */
    private String param;

    /**
     * 电商标识符jdm,fjdm,snm
     */
    private String hsn;

    /**
     * 京东稽核地址
     */
    private String jdSkuUrl;

    /**
     * 京东稽核真实skuId
     */
    private String jdSku;

    /**
     * 质保信息
     */
    private String wserve;

    /**
     * 京东商城c端详情访问地址
     */
    private String jdPcUrl;

    /**
     * 询价单选中编号
     */
    private String inquiryCode;

    /**
     * 创建人
     */
    private Long createUserId;

    /**
     * 创建时间
     */
    private Date createTime;

    /**
     * 更新人
     */
    private Long updateUserId;

    /**
     * 更新时间
     */
    private Date updateTime;

    /**
     * 询价单id
     */
    private Long inquiryId;
}