/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.first.api;

import com.google.common.collect.Lists;
import java.io.Serializable;
import java.util.List;

public class RspPage<T>
implements Serializable {
    private static final long serialVersionUID = 1L;
    private List<T> rows;
    private Long recordsTotal;
    private Integer pageSize;
    private Integer pageNo;
    private Long total;
    private Integer pageCout;

    private RspPage() {
    }

    public RspPage(Integer pageSize, Integer pageNo, List<T> rows, Long recordsTotal) {
        this.pageSize = pageSize;
        this.pageNo = pageNo;
        this.doCheck();
        this.recordsTotal = recordsTotal;
        this.rows = rows == null ? Lists.newArrayList() : rows;
        this.setTotalPage();
    }

    private void setTotalPage() {
        this.total = this.getRecordsTotal() == 0L ? Long.valueOf(0L) : Long.valueOf(this.getRecordsTotal() / (long)this.getPageSize().intValue() + (long)(this.getRecordsTotal() % (long)this.getPageSize().intValue() == 0L ? 0 : 1));
    }

    private void doCheck() {
        if (null == this.pageSize || this.pageSize < 1) {
            throw new IllegalArgumentException("the pageSize value was illegal.");
        }
        if (null == this.pageNo || this.pageNo < 1) {
            throw new IllegalArgumentException("the pageNo value was illegal.");
        }
    }

    public List<T> getRows() {
        return null == this.rows ? Lists.newArrayList() : this.rows;
    }

    public Long getRecordsTotal() {
        if (null == this.recordsTotal || this.recordsTotal <= 0L) {
            this.recordsTotal = 0L;
        }
        return this.recordsTotal;
    }

    public Integer getPageSize() {
        return this.pageSize;
    }

    public Integer getPageNo() {
        return this.pageNo;
    }

    public Long getTotal() {
        return this.total;
    }

    public Integer getPageCout() {
        this.pageCout = null == this.rows ? 0 : this.rows.size();
        return this.pageCout;
    }

    public String toString() {
        return "Page [rows=" + this.rows + ", recordsTotal=" + this.recordsTotal + ", pageSize=" + this.pageSize + ", pageNo=" + this.pageNo + ", total=" + this.total + ", pageCout=" + this.pageCout + "]";
    }
}

