/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.enquiry.ability.impl;

import cn.hutool.core.date.DateUtil;
import com.alibaba.fastjson.JSON;
import com.ohaotian.plugin.file.FileClient;
import com.ohaotian.plugin.file.fastdfs.FastdfsFileInfo;
import com.tydic.enquiry.api.EnquiryDealNoticeAbilityService;
import com.tydic.enquiry.api.bo.EnquiryDealConfirmItemPageRspBO;
import com.tydic.enquiry.api.bo.EnquiryDealNoticeDeatilRspBO;
import com.tydic.enquiry.api.bo.EnquiryDealNoticeMatchPageRspBO;
import com.tydic.enquiry.api.bo.EnquiryDealNoticeMatchRspBO;
import com.tydic.enquiry.api.bo.EnquiryDealNoticeMidMatchBO;
import com.tydic.enquiry.api.bo.EnquiryDealNoticePageRspBO;
import com.tydic.enquiry.api.bo.EnquiryDealNoticeQueryReqBO;
import com.tydic.enquiry.api.bo.EnquiryDealNoticeReqBO;
import com.tydic.enquiry.api.bo.EnquiryDealNoticeRspBO;
import com.tydic.enquiry.api.bo.EnquiryExecuteQuotePlanItemBO;
import com.tydic.enquiry.api.bo.EnquirySupplierConfirmItemBo;
import com.tydic.enquiry.api.bo.EnquirySupplierDealConfirmReqBO;
import com.tydic.enquiry.api.bo.GetDealNoticeRedisNoReqBO;
import com.tydic.enquiry.api.bo.GetDealNoticeRedisNoRspBO;
import com.tydic.enquiry.api.bo.ImportDealNoticeMatchMidItemReqBO;
import com.tydic.enquiry.api.bo.ImportDealNoticeMatchMidItemRspBO;
import com.tydic.enquiry.api.bo.PurchasePlanDealItemListQueryReqBO;
import com.tydic.enquiry.api.bo.PurchasePlanDealItemListQueryRspBO;
import com.tydic.enquiry.busi.api.EnquiryDealNoticeBusiService;
import com.tydic.enquiry.busi.api.EnquiryDealQuoteBusiService;
import com.tydic.enquiry.busi.api.EnquiryPdfPrintBusiService;
import com.tydic.enquiry.exceptions.BusinessException;
import com.tydic.enquiry.utils.BatchImportUtils;
import com.tydic.enquiry.utils.ExcelUtils;
import com.tydic.umcext.ability.fileDownload.CnncUmcFileImpLogAbilityService;
import com.tydic.umcext.ability.fileDownload.bo.CnncUmcFileImpLogAbilityReqBO;
import com.tydic.umcext.ability.fileDownload.bo.CnncUmcFileImpLogAbilityRspBO;
import com.tydic.umcext.ability.fileDownload.bo.CnncUmcFileImpLogDetailBO;
import com.tydic.umcext.ability.invoice.bo.BusinessChangeFileAnnoxBO;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Date;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import org.apache.commons.lang3.StringUtils;
import org.apache.poi.hssf.util.HSSFColor;
import org.apache.poi.ss.usermodel.BorderStyle;
import org.apache.poi.ss.usermodel.CellStyle;
import org.apache.poi.ss.usermodel.CellType;
import org.apache.poi.ss.usermodel.FillPatternType;
import org.apache.poi.ss.usermodel.Font;
import org.apache.poi.ss.usermodel.HorizontalAlignment;
import org.apache.poi.ss.usermodel.VerticalAlignment;
import org.apache.poi.util.IOUtils;
import org.apache.poi.xssf.streaming.SXSSFCell;
import org.apache.poi.xssf.streaming.SXSSFRow;
import org.apache.poi.xssf.streaming.SXSSFSheet;
import org.apache.poi.xssf.streaming.SXSSFWorkbook;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.util.CollectionUtils;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"ENQUIRY_GROUP/1.0.0/com.tydic.enquiry.api.EnquiryDealNoticeAbilityService"})
public class EnquiryDealNoticeAbilityServiceImpl
implements EnquiryDealNoticeAbilityService {
    private static final Logger log = LoggerFactory.getLogger(EnquiryDealNoticeAbilityServiceImpl.class);
    @Autowired
    private FileClient fileClient;
    private static final String PATH = "enquiry";
    public static final String FILE_TYPE_OSS = "OSS";
    public static final String FILE_TYPE_FASTDFS = "FASTDFS";
    @Value(value="${plugin.file.type}")
    private String fileType;
    @Value(value="${preFilePath}")
    private String preFilePath;
    @Value(value="${oss.fileUrl}")
    private String ossFileUrl;
    @Value(value="${fastdfs.httpTrackerHttpPort}")
    private String fastdfsHttpTrackerHttpPort;
    @Value(value="${fastdfs.trackerServers}")
    private String fastdfsTrackerServers;
    @Value(value="${export.file.public.url}")
    private String exportFilePublicUrl;
    @Autowired
    private CnncUmcFileImpLogAbilityService cnncUmcFileImpLogAbilityService;
    @Autowired
    EnquiryDealNoticeBusiService enquiryDealNoticeBusiService;
    @Autowired
    EnquiryPdfPrintBusiService enquiryPdfPrintBusiService;
    @Autowired
    EnquiryDealQuoteBusiService enquiryDealQuoteBusiService;

    @PostMapping(value={"saveDealNotice"})
    public EnquiryDealNoticeRspBO saveDealNotice(@RequestBody EnquiryDealNoticeReqBO reqBO) {
        return this.enquiryDealNoticeBusiService.saveDealNotice(reqBO);
    }

    @PostMapping(value={"queryNoticeList"})
    public EnquiryDealNoticePageRspBO queryNoticeList(@RequestBody EnquiryDealNoticeQueryReqBO reqBO) {
        return this.enquiryDealNoticeBusiService.queryNoticeList(reqBO);
    }

    @PostMapping(value={"queryNoticeDetail"})
    public EnquiryDealNoticeDeatilRspBO queryNoticeDetail(@RequestBody EnquiryDealNoticeQueryReqBO reqBO) {
        this.validParam(reqBO);
        return this.enquiryDealNoticeBusiService.queryNoticeDetail(reqBO);
    }

    @PostMapping(value={"queryNoticeQuoteItemList"})
    public EnquiryDealConfirmItemPageRspBO queryNoticeQuoteItemList(@RequestBody EnquiryDealNoticeQueryReqBO reqBO) {
        this.validParam(reqBO);
        return this.enquiryDealNoticeBusiService.queryNoticeQuoteItemList(reqBO);
    }

    @PostMapping(value={"printNoticeDetail"})
    public EnquiryDealNoticeRspBO printNoticeDetail(@RequestBody EnquiryDealNoticeQueryReqBO reqBO) {
        this.validParam(reqBO);
        return this.enquiryPdfPrintBusiService.printNoticeDetail(reqBO);
    }

    @PostMapping(value={"dealMatchPutShelf"})
    public EnquiryDealNoticeMatchRspBO dealMatchPutShelf(@RequestBody EnquirySupplierDealConfirmReqBO reqBO) {
        return this.enquiryDealNoticeBusiService.dealMatchPutShelf(reqBO);
    }

    @PostMapping(value={"dealMatchConfirm"})
    public EnquiryDealNoticeRspBO dealMatchConfirm(@RequestBody EnquirySupplierDealConfirmReqBO reqBO) {
        return this.enquiryDealNoticeBusiService.dealMatchConfirm(reqBO);
    }

    @PostMapping(value={"queryMatchList"})
    public EnquiryDealNoticeMatchPageRspBO queryMatchList(@RequestBody EnquiryDealNoticeQueryReqBO reqBO) {
        return this.enquiryDealNoticeBusiService.queryMatchList(reqBO);
    }

    @PostMapping(value={"dealMatchCancel"})
    public EnquiryDealNoticeRspBO dealMatchCancel(@RequestBody EnquirySupplierDealConfirmReqBO reqBO) {
        return this.enquiryDealNoticeBusiService.dealMatchCancel(reqBO);
    }

    @PostMapping(value={"queryNoPutShelfByTime"})
    public EnquiryDealNoticeRspBO queryNoPutShelfByTime(@RequestBody EnquiryDealNoticeQueryReqBO reqBO) {
        return this.enquiryDealNoticeBusiService.queryNoPutShelfByTime(reqBO);
    }

    private void validParam(EnquiryDealNoticeQueryReqBO reqBO) {
        if (reqBO.getDealNoticeId() == null) {
            throw new BusinessException("7777", "\u6210\u4ea4\u901a\u77e5\u4e66id\u4e0d\u80fd\u4e3a\u7a7a");
        }
    }

    @PostMapping(value={"queryPlanDealItemList"})
    public PurchasePlanDealItemListQueryRspBO queryPlanDealItemList(@RequestBody PurchasePlanDealItemListQueryReqBO reqBO) {
        return this.enquiryDealQuoteBusiService.queryPlanDealItemList(reqBO);
    }

    @PostMapping(value={"getDealNoticeRedisNo"})
    public GetDealNoticeRedisNoRspBO getDealNoticeRedisNo(@RequestBody GetDealNoticeRedisNoReqBO reqBO) {
        return this.enquiryDealNoticeBusiService.getDealNoticeRedisNo(reqBO);
    }

    @PostMapping(value={"dealDealMatchPutShelf"})
    public EnquiryDealNoticeMatchRspBO dealDealMatchPutShelf(@RequestBody EnquirySupplierDealConfirmReqBO reqBO) {
        return this.enquiryDealNoticeBusiService.dealDealMatchPutShelf(reqBO);
    }

    @PostMapping(value={"importDealMatchPutShelf"})
    public ImportDealNoticeMatchMidItemRspBO importDealMatchPutShelf(@RequestBody ImportDealNoticeMatchMidItemReqBO reqBO) {
        ImportDealNoticeMatchMidItemRspBO rspBO = new ImportDealNoticeMatchMidItemRspBO();
        rspBO.setIsSuccess("true");
        if (reqBO.getDealNoticeId() == null) {
            throw new BusinessException("7777", "\u62a5\u4ef7ID\u4e0d\u80fd\u4e3a\u7a7a!");
        }
        if (StringUtils.isBlank((CharSequence)reqBO.getRedisNo())) {
            throw new BusinessException("7777", "\u7f13\u5b58\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a!");
        }
        if (StringUtils.isBlank((CharSequence)reqBO.getFileUrl())) {
            throw new BusinessException("7777", "\u6587\u4ef6url\u4e0d\u80fd\u4e3a\u7a7a!");
        }
        ArrayList<String> title = new ArrayList<String>();
        ArrayList<List<String>> data = new ArrayList<List<String>>();
        ArrayList<EnquiryDealNoticeMidMatchBO> dealNoticeMidMatchBOList = new ArrayList<EnquiryDealNoticeMidMatchBO>();
        ArrayList<EnquiryDealNoticeMidMatchBO> errorDealNoticeMidMatchBOList = new ArrayList<EnquiryDealNoticeMidMatchBO>();
        List<Object> importDataMap = new ArrayList();
        ArrayList<Map<String, Object>> errorImportDataMap = new ArrayList<Map<String, Object>>();
        Long successCount = 0L;
        Long failedCount = 0L;
        try {
            BatchImportUtils<EnquiryDealNoticeMidMatchBO> batchImportUtils = new BatchImportUtils<EnquiryDealNoticeMidMatchBO>(title, data, EnquiryDealNoticeMidMatchBO.class);
            batchImportUtils.batchImport(reqBO.getFileUrl(), 0, 1, 2000);
            importDataMap = batchImportUtils.getImportDataMaps();
        }
        catch (Exception e) {
            e.printStackTrace();
            log.error("\u5bfc\u5165\u89e3\u6790\u6587\u4ef6\u6570\u636e\u5931\u8d25:{}", (Object)e.toString());
            rspBO.setRespCode("8888");
            rspBO.setRespDesc(e.toString());
            return rspBO;
        }
        List tempList = new ArrayList();
        ArrayList quoteItemIdList = new ArrayList();
        log.info("\u5bfc\u5165\u7ed3\u679c\u6570\u636e\uff1a" + importDataMap);
        if (CollectionUtils.isEmpty(importDataMap)) {
            rspBO.setRespCode("0000");
            rspBO.setRespDesc("\u89e3\u6790\u6587\u4ef6\u4e3a\u7a7a!");
            return rspBO;
        }
        try {
            tempList = JSON.parseArray((String)JSON.toJSONString(importDataMap), EnquiryDealNoticeMidMatchBO.class);
        }
        catch (Exception e) {
            log.error("\u6570\u636e\u89e3\u6790\u5931\u8d25:{}", (Object)e.toString());
            e.printStackTrace();
            rspBO.setRespCode("0000");
            rspBO.setRespDesc("\u6570\u636e\u89e3\u6790\u5931\u8d25:" + e.toString());
            return rspBO;
        }
        for (EnquiryDealNoticeMidMatchBO midItemBO : tempList) {
            if (!(!"0".equals(midItemBO.getImpResult()) || StringUtils.isEmpty((CharSequence)midItemBO.getProductCode()) && StringUtils.isEmpty((CharSequence)midItemBO.getOutsideProductCode()) && StringUtils.isEmpty((CharSequence)midItemBO.getAgreementItemCode()))) {
                dealNoticeMidMatchBOList.add(midItemBO);
                continue;
            }
            if ("0".equals(midItemBO.getImpResult()) && StringUtils.isEmpty((CharSequence)midItemBO.getProductCode()) && StringUtils.isEmpty((CharSequence)midItemBO.getOutsideProductCode()) && StringUtils.isEmpty((CharSequence)midItemBO.getAgreementItemCode())) {
                midItemBO.setImpResult("1");
                midItemBO.setImpRemark("\u5546\u54c1\u7f16\u7801\u3001\u5916\u90e8\u5546\u54c1\u7f16\u7801\u3001\u534f\u8bae\u660e\u7ec6\u7f16\u7801\u3001upc\u7801\u4e0d\u53ef\u90fd\u4e3a\u7a7a");
                errorDealNoticeMidMatchBOList.add(midItemBO);
                continue;
            }
            if (StringUtils.isEmpty((CharSequence)midItemBO.getProductCode()) && StringUtils.isEmpty((CharSequence)midItemBO.getOutsideProductCode()) && StringUtils.isEmpty((CharSequence)midItemBO.getAgreementItemCode())) {
                midItemBO.setImpRemark(StringUtils.isEmpty((CharSequence)midItemBO.getImpRemark()) ? "\u5546\u54c1\u7f16\u7801\u3001\u5916\u90e8\u5546\u54c1\u7f16\u7801\u3001\u534f\u8bae\u660e\u7ec6\u7f16\u7801\u3001upc\u7801\u4e0d\u53ef\u90fd\u4e3a\u7a7a" : midItemBO.getImpRemark() + ";\u5546\u54c1\u7f16\u7801\u3001\u5916\u90e8\u5546\u54c1\u7f16\u7801\u3001\u534f\u8bae\u660e\u7ec6\u7f16\u7801\u3001upc\u7801\u4e0d\u53ef\u90fd\u4e3a\u7a7a");
                errorDealNoticeMidMatchBOList.add(midItemBO);
                continue;
            }
            errorDealNoticeMidMatchBOList.add(midItemBO);
        }
        if (!CollectionUtils.isEmpty(dealNoticeMidMatchBOList)) {
            EnquirySupplierDealConfirmReqBO updateDealMatchMidItemReqBO = new EnquirySupplierDealConfirmReqBO();
            updateDealMatchMidItemReqBO.setDealNoticeId(reqBO.getDealNoticeId());
            updateDealMatchMidItemReqBO.setRedisNo(reqBO.getRedisNo());
            List confirmItemList = JSON.parseArray((String)JSON.toJSONString(dealNoticeMidMatchBOList), EnquirySupplierConfirmItemBo.class);
            updateDealMatchMidItemReqBO.setConfirmItemList(confirmItemList);
            EnquiryDealNoticeMatchRspBO updateMidItemRspBO = this.enquiryDealNoticeBusiService.dealDealMatchPutShelf(updateDealMatchMidItemReqBO);
            if (!"0000".equals(updateMidItemRspBO.getRespCode())) {
                rspBO.setRespCode("8888");
                rspBO.setRespDesc("\u66f4\u65b0\u62a5\u4ef7\u6570\u636e\u5931\u8d25:" + updateMidItemRspBO.getRespDesc());
                return rspBO;
            }
        }
        CnncUmcFileImpLogAbilityReqBO cnncUmcFileImpLogAbilityReqBO = new CnncUmcFileImpLogAbilityReqBO();
        ArrayList<Map<String, Object>> allImportDataMap = new ArrayList<Map<String, Object>>();
        if (!CollectionUtils.isEmpty(errorDealNoticeMidMatchBOList)) {
            int index = 0;
            for (EnquiryDealNoticeMidMatchBO itemBO : errorDealNoticeMidMatchBOList) {
                LinkedHashMap<String, Object> errorItem = new LinkedHashMap<String, Object>();
                errorItem.put("\u5e8f\u53f7", ++index);
                errorItem.put("\u6210\u4ea4\u901a\u77e5\u660e\u7ec6\u7f16\u53f7", itemBO.getDealConfirmItemId() != null ? itemBO.getDealConfirmItemId() : "");
                errorItem.put("\u5546\u54c1\u7f16\u7801", itemBO.getProductCode() != null ? itemBO.getProductCode() : "");
                errorItem.put("\u5916\u90e8\u5546\u54c1\u7f16\u7801", itemBO.getOutsideProductCode() != null ? itemBO.getOutsideProductCode() : "");
                errorItem.put("\u534f\u8bae\u660e\u7ec6\u7f16\u7801", itemBO.getAgreementItemCode() != null ? itemBO.getAgreementItemCode() : "");
                errorItem.put("UPC\u7801", itemBO.getUpcCode() != null ? itemBO.getUpcCode() : "");
                errorItem.put("\u5bfc\u5165\u7ed3\u679c", "\u5931\u8d25");
                errorItem.put("\u5931\u8d25\u539f\u56e0", itemBO.getImpRemark() != null ? itemBO.getImpRemark() : "");
                errorImportDataMap.add(errorItem);
            }
            rspBO.setIsSuccess("false");
            rspBO.setRemark("\u6210\u4ea4\u660e\u7ec6\u5bfc\u5165\u5931\u8d25\uff1a\u6570\u636e\u6821\u9a8c\u5931\u8d25");
            String url = this.uploadFile(errorImportDataMap, "\u6210\u4ea4\u660e\u7ec6\u5bfc\u5165\u7ed3\u679c" + new Date().getTime());
            ArrayList<BusinessChangeFileAnnoxBO> fileUrlList = new ArrayList<BusinessChangeFileAnnoxBO>();
            BusinessChangeFileAnnoxBO annoxBO = new BusinessChangeFileAnnoxBO();
            annoxBO.setName("\u6210\u4ea4\u660e\u7ec6\u5bfc\u5165\u7ed3\u679c");
            annoxBO.setPath(url);
            fileUrlList.add(annoxBO);
            cnncUmcFileImpLogAbilityReqBO.setFileUrl(fileUrlList);
        }
        if (!CollectionUtils.isEmpty(tempList)) {
            int index = 0;
            for (EnquiryDealNoticeMidMatchBO itemBO : tempList) {
                Long l;
                Long l2;
                LinkedHashMap<String, Object> item = new LinkedHashMap<String, Object>();
                item.put("\u5e8f\u53f7", ++index);
                item.put("\u6210\u4ea4\u901a\u77e5\u660e\u7ec6\u7f16\u53f7", itemBO.getDealConfirmItemId() != null ? itemBO.getDealConfirmItemId() : "");
                item.put("\u5546\u54c1\u7f16\u7801", itemBO.getProductCode() != null ? itemBO.getProductCode() : "");
                item.put("\u5916\u90e8\u5546\u54c1\u7f16\u7801", itemBO.getOutsideProductCode() != null ? itemBO.getOutsideProductCode() : "");
                item.put("\u534f\u8bae\u660e\u7ec6\u7f16\u7801", itemBO.getAgreementItemCode() != null ? itemBO.getAgreementItemCode() : "");
                item.put("UPC\u7801", itemBO.getUpcCode() != null ? itemBO.getUpcCode() : "");
                if ("0".equals(itemBO.getImpResult())) {
                    item.put("\u5bfc\u5165\u7ed3\u679c", "\u6210\u529f");
                    item.put("\u5931\u8d25\u539f\u56e0", "");
                    l2 = successCount;
                    l = successCount = Long.valueOf(successCount + 1L);
                } else {
                    item.put("\u5bfc\u5165\u7ed3\u679c", "\u5931\u8d25");
                    item.put("\u5931\u8d25\u539f\u56e0", itemBO.getImpRemark() != null ? itemBO.getImpRemark() : "");
                    l2 = failedCount;
                    l = failedCount = Long.valueOf(failedCount + 1L);
                }
                allImportDataMap.add(item);
            }
        }
        cnncUmcFileImpLogAbilityReqBO.setOutImpId(reqBO.getDealNoticeId());
        cnncUmcFileImpLogAbilityReqBO.setImpType("DEAL_NOTIC_ITEM");
        cnncUmcFileImpLogAbilityReqBO.setMemIdIn(reqBO.getMemIdIn());
        cnncUmcFileImpLogAbilityReqBO.setSuccessCount(successCount);
        cnncUmcFileImpLogAbilityReqBO.setFailureCount(failedCount);
        cnncUmcFileImpLogAbilityReqBO.setImpCount(Long.valueOf(successCount + failedCount));
        if (failedCount != 0L) {
            cnncUmcFileImpLogAbilityReqBO.setImpResult(Integer.valueOf(1));
            cnncUmcFileImpLogAbilityReqBO.setImpRemark("\u539f\u56e0\u8be6\u60c5\u8bf7\u67e5\u770b\u5217\u8868");
        } else {
            cnncUmcFileImpLogAbilityReqBO.setImpResult(Integer.valueOf(0));
            cnncUmcFileImpLogAbilityReqBO.setImpRemark("\u6210\u529f");
        }
        log.info("\u5bfc\u5165\u7ed3\u679c\u6570\u636e\uff1a" + allImportDataMap);
        this.createDataJson(cnncUmcFileImpLogAbilityReqBO, allImportDataMap);
        log.info("\u8c03\u7528\u4f1a\u5458\u5bfc\u5165\u8bb0\u5f55\u670d\u52a1\u5165\u53c2\u4e3a:" + JSON.toJSONString((Object)cnncUmcFileImpLogAbilityReqBO));
        CnncUmcFileImpLogAbilityRspBO cnncUmcFileImpLogAbilityRspBO = this.cnncUmcFileImpLogAbilityService.fileImpLogAdd(cnncUmcFileImpLogAbilityReqBO);
        log.info("\u8c03\u7528\u4f1a\u5458\u5bfc\u5165\u8bb0\u5f55\u670d\u52a1\u51fa\u53c2\u4e3a:" + JSON.toJSONString((Object)cnncUmcFileImpLogAbilityRspBO));
        if (!"0000".equals(cnncUmcFileImpLogAbilityRspBO.getRespCode())) {
            rspBO.setRespCode("8888");
            rspBO.setRespDesc(cnncUmcFileImpLogAbilityRspBO.getRespDesc());
        }
        rspBO.setImpId(cnncUmcFileImpLogAbilityRspBO.getImpId().toString());
        rspBO.setRespCode("0000");
        rspBO.setRespDesc(cnncUmcFileImpLogAbilityRspBO.getRespDesc());
        return rspBO;
    }

    private void createDataJson(CnncUmcFileImpLogAbilityReqBO cnncUmcFileImpLogAbilityReqBO, List<Map<String, Object>> exportData) {
        StringBuilder headBuilder = new StringBuilder();
        if (exportData != null && exportData.size() > 0) {
            boolean firstRow = true;
            ArrayList<CnncUmcFileImpLogDetailBO> logDetailBOS = new ArrayList<CnncUmcFileImpLogDetailBO>();
            for (Map<String, Object> row : exportData) {
                CnncUmcFileImpLogDetailBO detailBO = new CnncUmcFileImpLogDetailBO();
                StringBuilder builder = new StringBuilder();
                Iterator<Map.Entry<String, Object>> it = row.entrySet().iterator();
                int size = row.size();
                int count = 1;
                while (it.hasNext()) {
                    Map.Entry<String, Object> entry = it.next();
                    if (firstRow) {
                        if (count == size) {
                            firstRow = false;
                            headBuilder.append((Object)entry.getKey());
                        } else {
                            headBuilder.append((Object)entry.getKey()).append("##");
                        }
                    }
                    builder.append(StringUtils.isBlank((CharSequence)entry.getValue().toString()) ? " " : entry.getValue());
                    if (count != size) {
                        builder.append("##");
                    }
                    ++count;
                }
                detailBO.setDataJson(builder.toString());
                if (row.get("\u5bfc\u5165\u7ed3\u679c").toString().equals("\u6210\u529f")) {
                    detailBO.setStatus(Integer.valueOf(0));
                } else {
                    detailBO.setStatus(Integer.valueOf(1));
                    detailBO.setFailureReasons(row.get("\u5931\u8d25\u539f\u56e0").toString());
                }
                logDetailBOS.add(detailBO);
            }
            cnncUmcFileImpLogAbilityReqBO.setLogDetails(logDetailBOS);
            cnncUmcFileImpLogAbilityReqBO.setDataColumns(headBuilder.toString());
        }
    }

    public String uploadFile(List<Map<String, Object>> data, String name) {
        String string;
        SXSSFWorkbook workbook = ExcelUtils.createWorkbook(data, name);
        ByteArrayOutputStream out = null;
        ByteArrayInputStream in = null;
        String result = "";
        String uploadPath = PATH;
        String fileName = UUID.randomUUID() + ".xlsx";
        try {
            out = new ByteArrayOutputStream();
            workbook.write((OutputStream)out);
            byte[] buff = out.toByteArray();
            in = new ByteArrayInputStream(buff);
            result = this.fileClient.uploadFileByInputStream(uploadPath, fileName, (InputStream)in);
            out.flush();
            String fullFilePath = "";
            if (FILE_TYPE_OSS.equals(this.fileType)) {
                fullFilePath = this.preFilePath + result;
            } else if (FILE_TYPE_FASTDFS.equals(this.fileType)) {
                FastdfsFileInfo fastdfsFileInfo = FastdfsFileInfo.toFastdfsFileInfo((String)result);
                fullFilePath = this.exportFilePublicUrl + "/" + fastdfsFileInfo.getGroupName() + "/" + fastdfsFileInfo.getFileName();
            }
            string = fullFilePath;
        }
        catch (IOException e) {
            try {
                throw new BusinessException("22051", "\u6587\u4ef6\u4e0a\u4f20\u5931\u8d25\uff01");
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(in);
                IOUtils.closeQuietly((Closeable)out);
                throw throwable;
            }
        }
        IOUtils.closeQuietly((Closeable)in);
        IOUtils.closeQuietly((Closeable)out);
        return string;
    }

    @PostMapping(value={"downImportNoticeQuoteItemList"})
    public EnquiryDealConfirmItemPageRspBO downImportNoticeQuoteItemList(@RequestBody EnquiryDealNoticeQueryReqBO reqBO) {
        this.validParam(reqBO);
        EnquiryDealConfirmItemPageRspBO rspBO = new EnquiryDealConfirmItemPageRspBO();
        rspBO = this.enquiryDealNoticeBusiService.queryNoticeQuoteItemList(reqBO);
        SXSSFWorkbook workbook = this.doCreateExcel(rspBO.getRows());
        String fullFilePath = "";
        ByteArrayOutputStream out = null;
        ByteArrayInputStream in = null;
        String result = "";
        String uploadPath = PATH;
        String fileName = UUID.randomUUID() + ".xlsx";
        try {
            out = new ByteArrayOutputStream();
            workbook.write((OutputStream)out);
            byte[] buff = out.toByteArray();
            in = new ByteArrayInputStream(buff);
            result = this.fileClient.uploadFileByInputStream(uploadPath, fileName, (InputStream)in);
            out.flush();
            if (FILE_TYPE_OSS.equals(this.fileType)) {
                fullFilePath = this.preFilePath + result;
            } else if (FILE_TYPE_FASTDFS.equals(this.fileType)) {
                FastdfsFileInfo fastdfsFileInfo = FastdfsFileInfo.toFastdfsFileInfo((String)result);
                fullFilePath = this.exportFilePublicUrl + "/" + fastdfsFileInfo.getGroupName() + "/" + fastdfsFileInfo.getFileName();
            }
        }
        catch (IOException e) {
            try {
                throw new BusinessException("22051", "\u6587\u4ef6\u4e0a\u4f20\u5931\u8d25\uff01");
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(in);
                IOUtils.closeQuietly((Closeable)out);
                throw throwable;
            }
        }
        IOUtils.closeQuietly((Closeable)in);
        IOUtils.closeQuietly((Closeable)out);
        rspBO.setUrl(fullFilePath);
        return rspBO;
    }

    private SXSSFWorkbook doCreateExcel(List<EnquiryExecuteQuotePlanItemBO> quotePlanItemBOList) {
        SXSSFWorkbook workbook = new SXSSFWorkbook();
        String sheetName = "\u6210\u4ea4\u901a\u77e5\u660e\u7ec6";
        CellStyle dataStyle = EnquiryDealNoticeAbilityServiceImpl.getStyleInCommon(workbook, HSSFColor.HSSFColorPredefined.GREY_25_PERCENT.getIndex(), (short)11, "\u5b8b\u4f53", true, HorizontalAlignment.CENTER, BorderStyle.THIN);
        SXSSFSheet sheet = workbook.createSheet(sheetName);
        sheet.setDefaultColumnWidth(20);
        String[] headers = new String[]{"\u5e8f\u53f7", "\u5546\u54c1\u7f16\u7801", "\u5916\u90e8\u5546\u54c1\u7f16\u7801", "\u534f\u8bae\u660e\u7ec6\u7f16\u7801", "upc\u7801", "\u6210\u4ea4\u901a\u77e5\u660e\u7ec6\u7f16\u53f7", "\u62a5\u4ef7\u6709\u6548\u671f", "\u627f\u8bfa\u4ea4\u8d27\u671f", "\u91c7\u8d2d\u7269\u9879\u901a\u7528\u540d\u79f0", "\u89c4\u683c\u578b\u53f7", "\u62a5\u4ef7\u6570\u91cf", "\u62a5\u4ef7\u5355\u4ef7", "\u62a5\u4ef7\u603b\u4ef7\uff08\u5143\uff09", "\u7269\u6599\u5c0f\u7c7b", "\u7269\u8d44\u7f16\u7801", "\u54c1\u724c", "\u5546\u54c1\u578b\u53f7\u6216\u5176\u4ed6\u4fe1\u606f", "\u9700\u6c42\u660e\u7ec6\u7f16\u53f7", "\u751f\u4ea7\u5382\u5bb6", "\u6570\u91cf", "\u9884\u7b97\u5355\u4ef7\uff08\u5143\uff09", "\u9884\u7b97\u91d1\u989d\uff08\u5143\uff09", "\u4ea4\u8d27\u671f\u8981\u6c42", "\u6267\u884c\u6807\u51c6", "\u63a8\u8350\u54c1\u724c/\u5236\u9020\u5546", "\u5b89\u5168\u7b49\u7ea7", "\u8d28\u4fdd\u7b49\u7ea7", "\u7b2c\u4e09\u65b9\u68c0\u9a8c\u8bc1\u4e66", "\u5305\u88c5\u65b9\u5f0f", "\u914d\u5957\u670d\u52a1\uff08\u5b89\u88c5\u7b49\uff09", "\u8d28\u4fdd\u5468\u671f", "\u5176\u4ed6\u6280\u672f\u8981\u6c42", "\u5386\u53f2\u91c7\u8d2d\u5355\u4ef7", "\u5907\u6ce8", "\u53c2\u8003\u5546\u54c1\u7f16\u7801", "\u6807\u51c6\u5e93\u76ee\u5f55\u540d\u79f0", "\u6700\u9ad8\u9650\u4ef7", "\u5b89\u5168\u5e93\u5b58", "\u7269\u8d44\u7f16\u7801\u8ba1\u91cf\u5355\u4f4d", "\u6700\u957f\u4ea4\u8d27\u5468\u671f\uff08\u5929\uff09", "\u9644\u4ef6"};
        SXSSFRow row = sheet.createRow(0);
        for (int i = 0; i < headers.length; i = (int)((short)(i + 1))) {
            SXSSFCell cell = row.createCell(i);
            if (i != 1 && i != 2 && i != 3 && i != 4) {
                dataStyle = EnquiryDealNoticeAbilityServiceImpl.getStyleInCommon(workbook, HSSFColor.HSSFColorPredefined.GREY_25_PERCENT.getIndex(), (short)11, "\u5b8b\u4f53", true, HorizontalAlignment.CENTER, BorderStyle.NONE);
                cell.setCellStyle(dataStyle);
            } else {
                dataStyle = EnquiryDealNoticeAbilityServiceImpl.getStyleInCommon(workbook, HSSFColor.HSSFColorPredefined.WHITE.getIndex(), (short)11, "\u5b8b\u4f53", true, HorizontalAlignment.CENTER, BorderStyle.THIN);
                cell.setCellStyle(dataStyle);
            }
            cell.setCellValue(headers[i]);
        }
        int index = 0;
        for (int i = 0; i < quotePlanItemBOList.size(); ++i) {
            row = sheet.createRow(++index);
            EnquiryExecuteQuotePlanItemBO item = quotePlanItemBOList.get(i);
            for (int column = 0; column < headers.length; ++column) {
                SXSSFCell cell = row.createCell(column);
                cell.setCellType(CellType.STRING);
                if (column != 1 && column != 2 && column != 3 && column != 4) {
                    dataStyle = EnquiryDealNoticeAbilityServiceImpl.getStyleInCommon(workbook, HSSFColor.HSSFColorPredefined.GREY_25_PERCENT.getIndex(), (short)11, "\u5b8b\u4f53", true, HorizontalAlignment.CENTER, BorderStyle.NONE);
                    cell.setCellStyle(dataStyle);
                } else {
                    dataStyle = EnquiryDealNoticeAbilityServiceImpl.getStyleInCommon(workbook, HSSFColor.HSSFColorPredefined.WHITE.getIndex(), (short)11, "\u5b8b\u4f53", true, HorizontalAlignment.CENTER, BorderStyle.THIN);
                    cell.setCellStyle(dataStyle);
                }
                if (column == 0) {
                    cell.setCellValue(String.valueOf(i + 1));
                    continue;
                }
                if (column == 5) {
                    cell.setCellValue(this.convertNullToString(item.getDealConfirmItemId()));
                    continue;
                }
                if (column == 6) {
                    cell.setCellValue(this.convertNullToString(item.getQuotedEffTime()));
                    continue;
                }
                if (column == 7) {
                    cell.setCellValue(this.convertNullToString(item.getPromiseDeliveryDaysName()));
                    continue;
                }
                if (column == 8) {
                    cell.setCellValue(this.convertNullToString(item.getWlmc()));
                    continue;
                }
                if (column == 9) {
                    cell.setCellValue(this.convertNullToString(item.getGgxh()));
                    continue;
                }
                if (column == 10) {
                    cell.setCellValue(this.convertNullToString(item.getQuoteNumbers()));
                    continue;
                }
                if (column == 11) {
                    cell.setCellValue(this.convertNullToString(item.getQuotePrice()));
                    continue;
                }
                if (column == 12) {
                    cell.setCellValue(this.convertNullToString(item.getQuoteMoney()));
                    continue;
                }
                if (column == 13) {
                    cell.setCellValue(this.convertNullToString(item.getWxflDescribe()));
                    continue;
                }
                if (column == 14) {
                    cell.setCellValue(this.convertNullToString(item.getWlbhDescribe()));
                    continue;
                }
                if (column == 15) {
                    cell.setCellValue(this.convertNullToString(item.getBrand()));
                    continue;
                }
                if (column == 16) {
                    cell.setCellValue(this.convertNullToString(item.getJhmxbh()));
                    continue;
                }
                if (column == 17) {
                    cell.setCellValue(this.convertNullToString(item.getManufacturer()));
                    continue;
                }
                if (column == 18) {
                    cell.setCellValue(this.convertNullToString(item.getProductModelAndOther()));
                    continue;
                }
                if (column == 19) {
                    cell.setCellValue(this.convertNullToString(item.getSl()));
                    continue;
                }
                if (column == 20) {
                    cell.setCellValue(this.convertNullToString(item.getBudgetPrice()));
                    continue;
                }
                if (column == 21) {
                    cell.setCellValue(this.convertNullToString(item.getBudgetMoney()));
                    continue;
                }
                if (column == 22) {
                    cell.setCellValue(this.convertNullToString(item.getYqdhrq()));
                    continue;
                }
                if (column == 23) {
                    cell.setCellValue(this.convertNullToString(item.getZxbz()));
                    continue;
                }
                if (column == 24) {
                    cell.setCellValue(this.convertNullToString(item.getZzsmc()));
                    continue;
                }
                if (column == 25) {
                    cell.setCellValue(this.convertNullToString(item.getAqdj()));
                    continue;
                }
                if (column == 26) {
                    cell.setCellValue(this.convertNullToString(item.getZbdj()));
                    continue;
                }
                if (column == 27) {
                    cell.setCellValue(this.convertNullToString(item.getDsfjczmName()));
                    continue;
                }
                if (column == 28) {
                    cell.setCellValue(this.convertNullToString(item.getBzfsName()));
                    continue;
                }
                if (column == 29) {
                    cell.setCellValue(this.convertNullToString(item.getPtfwName()));
                    continue;
                }
                if (column == 30) {
                    cell.setCellValue(this.convertNullToString(item.getZbzq()));
                    continue;
                }
                if (column == 31) {
                    cell.setCellValue(this.convertNullToString(item.getQtjsyq()));
                    continue;
                }
                if (column == 32) {
                    cell.setCellValue(this.convertNullToString(item.getLscgdj()));
                    continue;
                }
                if (column == 33) {
                    cell.setCellValue(this.convertNullToString(item.getBz()));
                    continue;
                }
                if (column == 34) {
                    cell.setCellValue(this.convertNullToString(item.getCkspbm()));
                    continue;
                }
                if (column == 35) {
                    cell.setCellValue(this.convertNullToString(item.getBzkmlmc()));
                    continue;
                }
                if (column == 36) {
                    cell.setCellValue(this.convertNullToString(item.getZgxj()));
                    continue;
                }
                if (column == 37) {
                    cell.setCellValue(this.convertNullToString(item.getAqkc()));
                    continue;
                }
                if (column == 38) {
                    cell.setCellValue(this.convertNullToString(item.getWzbmjldw()));
                    continue;
                }
                if (column == 39) {
                    cell.setCellValue(this.convertNullToString(item.getJhzq()));
                    continue;
                }
                if (column != 40) continue;
            }
        }
        return workbook;
    }

    private String convertNullToString(Object valObj) {
        String valStr = "";
        if (valObj != null) {
            if (valObj instanceof Date) {
                return DateUtil.format((Date)((Date)valObj), (String)"yyyy-MM-dd HH:mm:ss");
            }
            return valObj.toString();
        }
        return valStr;
    }

    public static CellStyle getStyleInCommon(SXSSFWorkbook workbook, short fillForegroundColor, short fontHeightInPoints, String fontName, boolean wrapText, HorizontalAlignment alignment, BorderStyle borderStyle) {
        CellStyle cellStyle = workbook.createCellStyle();
        cellStyle.setFillForegroundColor(fillForegroundColor);
        cellStyle.setFillPattern(FillPatternType.SOLID_FOREGROUND);
        cellStyle.setAlignment(alignment);
        cellStyle.setBorderBottom(borderStyle);
        cellStyle.setBorderLeft(borderStyle);
        cellStyle.setBorderRight(borderStyle);
        cellStyle.setBorderTop(borderStyle);
        cellStyle.setVerticalAlignment(VerticalAlignment.CENTER);
        cellStyle.setWrapText(wrapText);
        Font titleFont = workbook.createFont();
        titleFont.setColor(HSSFColor.HSSFColorPredefined.BLACK.getIndex());
        titleFont.setFontHeightInPoints(fontHeightInPoints);
        titleFont.setFontName(fontName);
        cellStyle.setFont(titleFont);
        return cellStyle;
    }
}

