/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.enquiry.ability.impl;

import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.date.DateUtil;
import com.tydic.enquiry.api.EnquiryQryHolidayAbilityService;
import com.tydic.enquiry.api.bo.EnquiryQryHolidayListAbilityReqBO;
import com.tydic.enquiry.api.bo.EnquiryQryHolidayListAbilityRspBO;
import com.tydic.enquiry.dao.BasHoliDayMapper;
import com.tydic.enquiry.dao.po.BasHoliDayPO;
import com.tydic.enquiry.utils.WorkdayUtils;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"ENQUIRY_GROUP/1.0.0/com.tydic.enquiry.api.EnquiryQryHolidayAbilityService"})
public class EnquiryQryHolidayAbilityServiceImpl
implements EnquiryQryHolidayAbilityService {
    @Autowired
    private BasHoliDayMapper basHoliDayMapper;

    @PostMapping(value={"qryHolidayList"})
    public EnquiryQryHolidayListAbilityRspBO qryHolidayList(@RequestBody EnquiryQryHolidayListAbilityReqBO reqBO) {
        EnquiryQryHolidayListAbilityRspBO rspBO = new EnquiryQryHolidayListAbilityRspBO();
        BasHoliDayPO basHoliDayPO = new BasHoliDayPO();
        basHoliDayPO.setHoliDay(reqBO.getHolidayDate());
        List<BasHoliDayPO> holidayPos = this.basHoliDayMapper.getList(basHoliDayPO);
        rspBO.setHolidayList(holidayPos.stream().map(BasHoliDayPO::getHoliDay).collect(Collectors.toList()));
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("\u6210\u529f");
        return rspBO;
    }

    @PostMapping(value={"qryWorkDay"})
    public EnquiryQryHolidayListAbilityRspBO qryWorkDay(@RequestBody EnquiryQryHolidayListAbilityReqBO reqBO) {
        Integer count = reqBO.getIntervalDays();
        if (count == null) {
            count = 0;
        }
        String formDay = "yyyyMMdd";
        BasHoliDayPO basHoliDayPO = new BasHoliDayPO();
        basHoliDayPO.setHoliDayStart(new Date());
        List<BasHoliDayPO> holidayPos = this.basHoliDayMapper.getList(basHoliDayPO);
        ArrayList<String> legalHolidayList = new ArrayList<String>();
        if (CollUtil.isNotEmpty(holidayPos)) {
            for (BasHoliDayPO holiDayPO : holidayPos) {
                legalHolidayList.add(DateUtil.format((Date)holiDayPO.getHoliDay(), (String)formDay));
            }
        }
        WorkdayUtils workdayUtils = new WorkdayUtils();
        workdayUtils.setLegalHolidayList(legalHolidayList);
        Date date = workdayUtils.getWorkday(new Date(), count);
        String dateStr = DateUtil.format((Date)date, (String)formDay);
        EnquiryQryHolidayListAbilityRspBO rspBO = new EnquiryQryHolidayListAbilityRspBO();
        rspBO.setWorkDay(dateStr);
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("\u6210\u529f");
        return rspBO;
    }
}

