/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.enquiry.ability.impl;

import cn.hutool.core.bean.BeanUtil;
import cn.hutool.core.collection.CollUtil;
import com.alibaba.fastjson.JSON;
import com.ohaotian.plugin.db.Page;
import com.ohaotian.plugin.db.Sequence;
import com.tydic.agreement.ability.AgrQryAgreementByPageAbilityService;
import com.tydic.agreement.ability.AgrQryAgreementSkuByPageAbilityService;
import com.tydic.contract.api.supplier.service.QuerySupplierByCategoryIdService;
import com.tydic.enquiry.api.EnquiryQrySupplierSaleAbilityService;
import com.tydic.enquiry.api.ExecuteBillTimeTaskService;
import com.tydic.enquiry.api.bo.BaseAllOperLogReqBO;
import com.tydic.enquiry.api.bo.BaseAllOperLogRspBO;
import com.tydic.enquiry.api.bo.BasePhaseReqBO;
import com.tydic.enquiry.api.bo.EnquiryLogReqBO;
import com.tydic.enquiry.api.bo.EnquiryQrySupplierSaleReqBO;
import com.tydic.enquiry.api.bo.EnquiryQrySupplierSaleRspBO;
import com.tydic.enquiry.api.bo.ExecuteBillTimeTaskServiceReqBO;
import com.tydic.enquiry.api.bo.ExecuteBillTimeTaskServiceRspBO;
import com.tydic.enquiry.busi.api.BaseAllOperLogBusiService;
import com.tydic.enquiry.constant.EnquiryCommonUtil;
import com.tydic.enquiry.constant.EnquiryConstant;
import com.tydic.enquiry.constant.EnquiryEnumConstant;
import com.tydic.enquiry.dao.DIqrRegistMarginMapper;
import com.tydic.enquiry.dao.ExecuteBillMapper;
import com.tydic.enquiry.dao.ExecuteItemMapper;
import com.tydic.enquiry.dao.ExecutePackMapper;
import com.tydic.enquiry.dao.ExecuteSupJoinMapper;
import com.tydic.enquiry.dao.SupQuoteItemMapper;
import com.tydic.enquiry.dao.SupQuoteMapper;
import com.tydic.enquiry.dao.SupQuotePackMapper;
import com.tydic.enquiry.dao.po.DIqrRegistMarginPO;
import com.tydic.enquiry.dao.po.ExecuteBillPO;
import com.tydic.enquiry.dao.po.ExecuteItemPO;
import com.tydic.enquiry.dao.po.ExecutePackPO;
import com.tydic.enquiry.dao.po.ExecuteSupJoinPO;
import com.tydic.enquiry.dao.po.SupQuoteItemPO;
import com.tydic.enquiry.dao.po.SupQuotePO;
import com.tydic.enquiry.dao.po.SupQuotePackPO;
import com.tydic.enquiry.exceptions.BusinessException;
import com.tydic.order.extend.ability.plan.PebExtPlanItemUpdateAbilityService;
import com.tydic.order.extend.bo.plan.PebExtPlanItemUpdateReqBO;
import com.tydic.order.extend.bo.plan.PebExtPlanItemUpdateRspBO;
import com.tydic.order.extend.constant.PebExtConstant;
import com.tydic.umcext.ability.org.UmcZhEnterpriseOrgQueryAbilityService;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.CollectionUtils;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"ENQUIRY_GROUP/1.0.0/com.tydic.enquiry.api.ExecuteBillTimeTaskService"})
public class ExecuteBillTimeTaskServiceImpl
implements ExecuteBillTimeTaskService {
    private static final Logger log = LoggerFactory.getLogger(ExecuteBillTimeTaskServiceImpl.class);
    @Autowired
    private SupQuoteMapper supQuoteMapper;
    @Autowired
    private ExecuteBillMapper executeBillMapper;
    @Autowired
    private ExecuteItemMapper executeItemMapper;
    @Autowired
    private ExecuteSupJoinMapper executeSupJoinMapper;
    @Autowired
    private SupQuoteItemMapper supQuoteItemMapper;
    @Autowired
    private ExecutePackMapper executePackMapper;
    @Autowired
    private SupQuotePackMapper supQuotePackMapper;
    @Autowired
    private DIqrRegistMarginMapper dIqrRegistMarginMapper;
    @Autowired
    private QuerySupplierByCategoryIdService querySupplierByCategoryIdService;
    @Autowired
    private AgrQryAgreementByPageAbilityService agrQryAgreementByPageAbilityService;
    @Autowired
    private AgrQryAgreementSkuByPageAbilityService agrQryAgreementSkuByPageAbilityService;
    @Autowired
    private UmcZhEnterpriseOrgQueryAbilityService umcZhEnterpriseOrgQueryAbilityService;
    @Autowired
    private BaseAllOperLogBusiService baseAllOperLogBusiService;
    @Autowired
    private PebExtPlanItemUpdateAbilityService pebExtPlanItemUpdateAbilityService;
    @Autowired
    private EnquiryQrySupplierSaleAbilityService enquiryQrySupplierSaleAbilityService;

    @PostMapping(value={"executeBillTimeTask"})
    public ExecuteBillTimeTaskServiceRspBO executeBillTimeTask(@RequestBody ExecuteBillTimeTaskServiceReqBO reqBO) {
        List<ExecuteBillPO> executeValidBillPOS = this.executeBillMapper.selectValidBill();
        List<ExecuteBillPO> executeStartValidBillPOS = this.executeBillMapper.selectStartValidBill();
        List<ExecuteBillPO> executeInValidBillPOS = this.executeBillMapper.selectInValidBill();
        return this.dealExecuteBillTimeTask(reqBO, executeValidBillPOS, executeStartValidBillPOS, executeInValidBillPOS);
    }

    @PostMapping(value={"addBillTimeTaskTest"})
    public ExecuteBillTimeTaskServiceRspBO addBillTimeTaskTest(@RequestBody ExecuteBillTimeTaskServiceReqBO reqBO) {
        Long executeId = reqBO.getExecuteId();
        ArrayList<ExecuteBillPO> executeValidBillPOS = new ArrayList<ExecuteBillPO>();
        ExecuteBillPO executeBillPO = this.executeBillMapper.selectByPrimaryKey(executeId);
        ArrayList<ExecuteBillPO> executeInValidBillPOS = new ArrayList<ExecuteBillPO>();
        ArrayList<ExecuteBillPO> executeStartValidBillPOS = new ArrayList<ExecuteBillPO>();
        int n = EnquiryCommonUtil.getEndFlag(executeBillPO);
        if (n > 0) {
            if ("2003".equals(executeBillPO.getExecuteStatus())) {
                executeInValidBillPOS.add(executeBillPO);
            }
        } else if ("2012".equals(executeBillPO.getExecuteStatus()) && executeBillPO.getGenerateQuoteFlag() == 1) {
            executeStartValidBillPOS.add(executeBillPO);
        } else {
            executeValidBillPOS.add(executeBillPO);
        }
        return this.dealExecuteBillTimeTask(reqBO, executeValidBillPOS, executeStartValidBillPOS, executeInValidBillPOS);
    }

    private ExecuteBillTimeTaskServiceRspBO dealExecuteBillTimeTask(ExecuteBillTimeTaskServiceReqBO reqBO, List<ExecuteBillPO> executeValidBillPOS, List<ExecuteBillPO> executeStartValidBillPOS, List<ExecuteBillPO> executeInValidBillPOS) {
        ExecuteBillPO updateExecuteBillPO;
        ExecuteBillTimeTaskServiceRspBO rspBO = new ExecuteBillTimeTaskServiceRspBO();
        if (!CollectionUtils.isEmpty(executeStartValidBillPOS)) {
            updateExecuteBillPO = new ExecuteBillPO();
            for (ExecuteBillPO executeBillPO : executeStartValidBillPOS) {
                updateExecuteBillPO.setExecuteId(executeBillPO.getExecuteId());
                updateExecuteBillPO.setExecuteStatus("2003");
                this.executeBillMapper.updateByPrimaryKeySelective(updateExecuteBillPO);
                ExecuteItemPO itemQueryPO = new ExecuteItemPO();
                itemQueryPO.setExecuteId(executeBillPO.getExecuteId());
                List<ExecuteItemPO> executeItemPOList = this.executeItemMapper.selectBy(itemQueryPO);
                List<Long> executeItemIdList = executeItemPOList.stream().map(ExecuteItemPO::getExecuteItemId).collect(Collectors.toList());
                this.saveQuotationLog(reqBO, executeBillPO.getExecuteId(), executeItemIdList, EnquiryEnumConstant.BasPhaseStatusEnum.WORKING.getCode(), 1);
            }
        }
        if (!CollectionUtils.isEmpty(executeValidBillPOS)) {
            ExecuteSupJoinPO executeSupJoinPO = new ExecuteSupJoinPO();
            ExecuteBillPO updateExecuteBillPO2 = new ExecuteBillPO();
            for (ExecuteBillPO executeBillPO : executeValidBillPOS) {
                try {
                    executeSupJoinPO.setExecuteId(executeBillPO.getExecuteId());
                    List<ExecuteSupJoinPO> executeSupJoinPOList = this.executeSupJoinMapper.selectListByCondition(executeSupJoinPO);
                    String orgId = executeBillPO.getExecuteOrgId();
                    if (executeBillPO.getConfirmDealType().equals("3") || executeBillPO.getConfirmDealType().equals("2")) {
                        List<ExecutePackPO> executePackPOS = this.executePackMapper.selectByExecuteId(executeBillPO.getExecuteId(), null);
                        for (ExecuteSupJoinPO executeSupJoinPO1 : executeSupJoinPOList) {
                            this.addQuotationBill(reqBO, executeSupJoinPO1.getSupplierId(), executeSupJoinPO1.getSupplierName(), executeBillPO, executePackPOS);
                        }
                    } else {
                        HashSet projectIdSet = new HashSet();
                        ArrayList<ExecuteItemPO> supQuoteItemPOList = new ArrayList<ExecuteItemPO>();
                        Map enquiryProjectSupplierSaleList = new HashMap();
                        HashMap enquirySupplierIdMap = new HashMap();
                        ExecuteItemPO executeItemPO = new ExecuteItemPO();
                        executeItemPO.setExecuteId(executeBillPO.getExecuteId());
                        Page page = new Page(1, 1000);
                        List<ExecuteItemPO> supQuoteItemPOS = this.executeItemMapper.qryByPage(executeItemPO, (Page<ExecuteItemPO>)page);
                        if (page.getTotalPages() == 1) {
                            supQuoteItemPOList.addAll(supQuoteItemPOS);
                        }
                        if (page.getTotalPages() > 1) {
                            for (int i = 2; i <= page.getTotalPages(); ++i) {
                                page.setPageNo(i);
                                supQuoteItemPOS = this.executeItemMapper.qryByPage(executeItemPO, (Page<ExecuteItemPO>)page);
                                supQuoteItemPOList.addAll(supQuoteItemPOS);
                            }
                        }
                        for (ExecuteItemPO executeItem : supQuoteItemPOS) {
                            if (StringUtils.isEmpty((CharSequence)executeItem.getProjectIdJson())) continue;
                            List projectIds = JSON.parseArray((String)executeItem.getProjectIdJson(), Long.class);
                            projectIdSet.addAll(projectIds);
                        }
                        EnquiryQrySupplierSaleReqBO qrySupplierSaleReqBO = new EnquiryQrySupplierSaleReqBO();
                        ArrayList projectIdList = new ArrayList();
                        projectIdList.addAll(projectIdSet);
                        qrySupplierSaleReqBO.setProjectIdList(projectIdList);
                        qrySupplierSaleReqBO.setOrgId(Long.valueOf(orgId));
                        EnquiryQrySupplierSaleRspBO enquiryQrySupplierSaleRspBO = this.enquiryQrySupplierSaleAbilityService.qrySupplierSaleByProjectIdList(qrySupplierSaleReqBO);
                        enquiryProjectSupplierSaleList = enquiryQrySupplierSaleRspBO.getEnquiryProjectSupplierSaleList();
                        for (Long projectId : enquiryProjectSupplierSaleList.keySet()) {
                            ArrayList<String> supplierIds = new ArrayList<String>();
                            for (Object enquirySupplierSaleBO : (List)enquiryProjectSupplierSaleList.get(projectId)) {
                                supplierIds.add(enquirySupplierSaleBO.getSupplierId());
                            }
                            enquirySupplierIdMap.put(projectId, supplierIds);
                        }
                        List<ExecutePackPO> executePackPOS = this.executePackMapper.selectByExecuteId(executeBillPO.getExecuteId(), null);
                        for (ExecuteSupJoinPO executeSupJoinPO1 : executeSupJoinPOList) {
                            Object enquirySupplierSaleBO;
                            HashSet<ExecuteItemPO> saleList = new HashSet<ExecuteItemPO>();
                            enquirySupplierSaleBO = supQuoteItemPOS.iterator();
                            block10: while (enquirySupplierSaleBO.hasNext()) {
                                ExecuteItemPO executeItem = (ExecuteItemPO)enquirySupplierSaleBO.next();
                                Object projectIds = new ArrayList();
                                if (!StringUtils.isEmpty((CharSequence)executeItem.getProjectIdJson())) {
                                    projectIds = JSON.parseArray((String)executeItem.getProjectIdJson(), Long.class);
                                }
                                Iterator iterator = projectIds.iterator();
                                while (iterator.hasNext()) {
                                    Long projectId = (Long)iterator.next();
                                    if (enquirySupplierIdMap.get(projectId) == null || !((List)enquirySupplierIdMap.get(projectId)).contains(executeSupJoinPO1.getSupplierId().toString())) continue;
                                    saleList.add(executeItem);
                                    continue block10;
                                }
                            }
                            if (executeBillPO.getExecuteType().equals("2")) {
                                HashSet<Long> packIdList = new HashSet<Long>();
                                HashMap<Long, Integer> packCount = new HashMap<Long, Integer>();
                                for (ExecuteItemPO itemPO2 : saleList) {
                                    packIdList.add(itemPO2.getPackId());
                                    if (packCount.containsKey(itemPO2.getPackId())) {
                                        packCount.put(itemPO2.getPackId(), (Integer)packCount.get(itemPO2.getPackId()) + 1);
                                        continue;
                                    }
                                    packCount.put(itemPO2.getPackId(), 1);
                                }
                                log.info("\u4f9b\u5e94\u5546id" + executeSupJoinPO1.getSupplierId() + ";packCount=" + packCount);
                                log.info("\u4f9b\u5e94\u5546id" + executeSupJoinPO1.getSupplierId() + ";packIdList=" + packIdList);
                                if (CollectionUtils.isEmpty(packIdList)) continue;
                                ArrayList<Long> deletePackId = new ArrayList<Long>();
                                ArrayList<ExecutePackPO> addQuotePackPOS = new ArrayList<ExecutePackPO>();
                                addQuotePackPOS.addAll(executePackPOS);
                                for (ExecutePackPO executePackPO2 : executePackPOS) {
                                    if (executePackPO2.getItemCount() != null && packCount.get(executePackPO2.getPackId()) != null && ((Integer)packCount.get(executePackPO2.getPackId())).intValue() == executePackPO2.getItemCount().intValue()) continue;
                                    deletePackId.add(executePackPO2.getPackId());
                                }
                                if (!CollectionUtils.isEmpty(deletePackId)) {
                                    log.info("deletePackId={}", (Object)JSON.toJSONString(deletePackId));
                                    saleList.removeIf(itemPO -> deletePackId.contains(itemPO.getPackId()));
                                    addQuotePackPOS.removeIf(executePackPO -> deletePackId.contains(executePackPO.getPackId()));
                                }
                                if (CollectionUtils.isEmpty(saleList)) continue;
                                log.info("saleList={}", (Object)JSON.toJSONString(saleList));
                                log.info("executePackPOS={}", (Object)JSON.toJSONString(executePackPOS));
                                this.addQuotationBill(reqBO, executeSupJoinPO1.getSupplierId(), executeSupJoinPO1.getSupplierName(), executeBillPO, new ArrayList<ExecuteItemPO>(saleList), addQuotePackPOS);
                                continue;
                            }
                            log.info("saleList={}", (Object)JSON.toJSONString(saleList));
                            this.addQuotationBill(reqBO, executeSupJoinPO1.getSupplierId(), executeSupJoinPO1.getSupplierName(), executeBillPO, new ArrayList<ExecuteItemPO>(saleList), null);
                        }
                    }
                    updateExecuteBillPO2.setExecuteId(executeBillPO.getExecuteId());
                    updateExecuteBillPO2.setGenerateQuoteFlag(1);
                    this.executeBillMapper.updateByPrimaryKeySelective(updateExecuteBillPO2);
                    ExecuteItemPO itemQueryPO = new ExecuteItemPO();
                    itemQueryPO.setExecuteId(executeBillPO.getExecuteId());
                    List<ExecuteItemPO> executeItemPOList = this.executeItemMapper.selectBy(itemQueryPO);
                    List<Long> executeItemIdList = executeItemPOList.stream().map(ExecuteItemPO::getExecuteItemId).collect(Collectors.toList());
                    this.saveQuotationLog(reqBO, executeBillPO.getExecuteId(), executeItemIdList, EnquiryEnumConstant.BasPhaseStatusEnum.NOSTART.getCode(), 1);
                }
                catch (Exception e) {
                    e.printStackTrace();
                    log.error("\u5b9a\u65f6\u4efb\u52a1\u6267\u884c\u5931\u8d25:" + e.toString());
                }
            }
        }
        if (!CollectionUtils.isEmpty(executeInValidBillPOS)) {
            updateExecuteBillPO = new ExecuteBillPO();
            Integer roundOne = 1;
            for (ExecuteBillPO executeBillPO : executeInValidBillPOS) {
                Long executeId = executeBillPO.getExecuteId();
                if (roundOne.equals(executeBillPO.getExecuteRound())) {
                    SupQuotePO quoteQueryPO = new SupQuotePO();
                    quoteQueryPO.setExecuteId(executeId);
                    quoteQueryPO.setQuoteStatus(EnquiryConstant.QuoteStatus.YES);
                    if (executeBillPO.getExecuteType().equals("1")) {
                        quoteQueryPO.setQuoteRound(1);
                    }
                    HashSet<Long> supIdList = new HashSet<Long>();
                    List<SupQuotePO> supQuotePOList = this.supQuoteMapper.selectByCondition(quoteQueryPO);
                    int leastQuoteNumber = 1;
                    if (executeBillPO.getLeastQuoteNumber() != null) {
                        leastQuoteNumber = executeBillPO.getLeastQuoteNumber();
                    }
                    if (!CollectionUtils.isEmpty(supQuotePOList)) {
                        for (SupQuotePO supQuotePO : supQuotePOList) {
                            supIdList.add(supQuotePO.getSupplierId());
                        }
                    }
                    if (CollectionUtils.isEmpty(supQuotePOList) || supIdList.size() < leastQuoteNumber) {
                        log.error(executeId + "\u62a5\u4ef7\u5bb6\u6570\u4e0d\u8db3,\u5f53\u524d:" + supQuotePOList.size() + "\u5bb6\u4f9b\u5e94\u5546\u62a5\u4ef7,\u5c0f\u4e8e\uff08" + leastQuoteNumber + ")\u5bb6");
                        updateExecuteBillPO.setExecuteId(executeId);
                        updateExecuteBillPO.setExecuteStatus("2008");
                        updateExecuteBillPO.setFailFlag((byte)1);
                        updateExecuteBillPO.setExecuteFailReason("\u62a5\u4ef7\u5bb6\u6570\u4e0d\u8db3");
                        this.executeBillMapper.updateByPrimaryKeySelective(updateExecuteBillPO);
                        ExecuteItemPO itemQueryPO = new ExecuteItemPO();
                        itemQueryPO.setExecuteId(executeId);
                        List<ExecuteItemPO> executeItemPOList = this.executeItemMapper.selectBy(itemQueryPO);
                        List planItemIdList = executeItemPOList.stream().map(ExecuteItemPO::getPlanDetailId).collect(Collectors.toList());
                        PebExtPlanItemUpdateReqBO updatePlanItemReqBO = new PebExtPlanItemUpdateReqBO();
                        updatePlanItemReqBO.setPlanItemIdList(planItemIdList);
                        updatePlanItemReqBO.setUpdateType(PebExtConstant.PlanExecuteUpdateType.EXECUTE_FAIL);
                        updatePlanItemReqBO.setExecuteStatus("1");
                        updatePlanItemReqBO.setExecuteFailReason("\u62a5\u4ef7\u5bb6\u6570\u4e0d\u8db3");
                        PebExtPlanItemUpdateRspBO planItemUpdateRspBO = this.pebExtPlanItemUpdateAbilityService.dealPebExtPlanItemUpdate(updatePlanItemReqBO);
                        if (!"0000".equals(planItemUpdateRspBO.getRespCode())) {
                            throw new BusinessException("8888", "\u8ba1\u5212\u660e\u7ec6\u6267\u884c\u5931\u8d25\u66f4\u65b0\u5931\u8d25\uff1a" + planItemUpdateRspBO.getRespDesc());
                        }
                        List<Long> executeItemIdList = executeItemPOList.stream().map(ExecuteItemPO::getExecuteItemId).collect(Collectors.toList());
                        this.saveQuotationLog(reqBO, executeId, executeItemIdList, EnquiryEnumConstant.BasPhaseStatusEnum.FINISH.getCode(), 2);
                        this.saveFailQuotationLog(reqBO, executeItemIdList, EnquiryEnumConstant.BasPhaseStatusEnum.EXCEPT.getCode(), 2, "\u62a5\u4ef7\u5bb6\u6570\u4e0d\u8db3");
                        this.saveFailExecuteLog(reqBO, executeId, executeItemIdList, EnquiryEnumConstant.BasPhaseStatusEnum.EXCEPT.getCode(), 2, "\u62a5\u4ef7\u5bb6\u6570\u4e0d\u8db3");
                        continue;
                    }
                }
                updateExecuteBillPO.setExecuteId(executeId);
                updateExecuteBillPO.setExecuteStatus("2004");
                this.executeBillMapper.updateByPrimaryKeySelective(updateExecuteBillPO);
                ExecuteItemPO itemQueryPO = new ExecuteItemPO();
                itemQueryPO.setExecuteId(executeId);
                List<ExecuteItemPO> executeItemPOList = this.executeItemMapper.selectBy(itemQueryPO);
                List<Long> executeItemIdList = executeItemPOList.stream().map(ExecuteItemPO::getExecuteItemId).collect(Collectors.toList());
                this.saveQuotationLog(reqBO, executeId, executeItemIdList, EnquiryEnumConstant.BasPhaseStatusEnum.FINISH.getCode(), 2);
            }
        }
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("\u6210\u529f");
        return rspBO;
    }

    private void addQuotationBill(ExecuteBillTimeTaskServiceReqBO reqBO, Long supplierId, String supplierName, ExecuteBillPO executeBillPO, List<ExecutePackPO> executePackPOS) {
        SupQuotePO newSupQuotePO = new SupQuotePO();
        newSupQuotePO.setQuoteId(Sequence.getInstance().nextId());
        newSupQuotePO.setUpperQuoteId(null);
        newSupQuotePO.setSupplierId(supplierId);
        newSupQuotePO.setSupplierName(supplierName);
        newSupQuotePO.setExecuteId(executeBillPO.getExecuteId());
        newSupQuotePO.setQuoteRound(1);
        newSupQuotePO.setQuoteStatus(EnquiryConstant.QuoteStatus.NO);
        newSupQuotePO.setHisStatus(EnquiryConstant.QuoteHisStatus.NOW);
        newSupQuotePO.setCreateTime(new Date());
        newSupQuotePO.setQuoteCount(0);
        this.supQuoteMapper.insert(newSupQuotePO);
        HashMap<Long, Long> quotePackIdMap = new HashMap<Long, Long>();
        this.addQuotationPack(executeBillPO, executePackPOS, newSupQuotePO, quotePackIdMap);
        ExecuteItemPO executeItemPO = new ExecuteItemPO();
        executeItemPO.setExecuteId(executeBillPO.getExecuteId());
        Page page = new Page(1, 1000);
        List<ExecuteItemPO> supQuoteItemPOS = this.executeItemMapper.qryByPage(executeItemPO, (Page<ExecuteItemPO>)page);
        ArrayList<Long> executeItemIdList = new ArrayList<Long>();
        if (page.getTotalPages() == 1) {
            this.copyQuoteItem(supQuoteItemPOS, newSupQuotePO.getQuoteId(), quotePackIdMap);
            List tempItemIdList = supQuoteItemPOS.stream().map(ExecuteItemPO::getExecuteItemId).collect(Collectors.toList());
            CollUtil.addAll(executeItemIdList, tempItemIdList);
        }
        if (page.getTotalPages() > 1) {
            for (int i = 2; i <= page.getTotalPages(); ++i) {
                page.setPageNo(i);
                supQuoteItemPOS = this.executeItemMapper.qryByPage(executeItemPO, (Page<ExecuteItemPO>)page);
                this.copyQuoteItem(supQuoteItemPOS, newSupQuotePO.getQuoteId(), quotePackIdMap);
                List tempItemIdList = supQuoteItemPOS.stream().map(ExecuteItemPO::getExecuteItemId).collect(Collectors.toList());
                CollUtil.addAll(executeItemIdList, tempItemIdList);
            }
        }
        Long executeId = executeBillPO.getExecuteId();
        this.saveQuotationLog(reqBO, executeId, executeItemIdList, EnquiryEnumConstant.BasPhaseStatusEnum.WORKING.getCode(), 1);
    }

    private void addQuotationBill(ExecuteBillTimeTaskServiceReqBO reqBO, Long supplierId, String supplierName, ExecuteBillPO executeBillPO, List<ExecuteItemPO> executeItemPOS, List<ExecutePackPO> executePackPOS) {
        SupQuotePO newSupQuotePO = new SupQuotePO();
        newSupQuotePO.setQuoteId(Sequence.getInstance().nextId());
        newSupQuotePO.setUpperQuoteId(null);
        newSupQuotePO.setSupplierId(supplierId);
        newSupQuotePO.setSupplierName(supplierName);
        newSupQuotePO.setExecuteId(executeBillPO.getExecuteId());
        newSupQuotePO.setQuoteRound(1);
        newSupQuotePO.setQuoteStatus(EnquiryConstant.QuoteStatus.NO);
        newSupQuotePO.setHisStatus(EnquiryConstant.QuoteHisStatus.NOW);
        newSupQuotePO.setCreateTime(new Date());
        newSupQuotePO.setQuoteCount(0);
        this.supQuoteMapper.insert(newSupQuotePO);
        HashMap<Long, Long> quotePackIdMap = new HashMap<Long, Long>();
        this.addQuotationPack(executeBillPO, executePackPOS, newSupQuotePO, quotePackIdMap);
        this.copyQuoteItem(executeItemPOS, newSupQuotePO.getQuoteId(), quotePackIdMap);
        Long executeId = executeBillPO.getExecuteId();
        List<Long> executeItemIdList = executeItemPOS.stream().map(ExecuteItemPO::getExecuteItemId).collect(Collectors.toList());
        this.saveQuotationLog(reqBO, executeId, executeItemIdList, EnquiryEnumConstant.BasPhaseStatusEnum.WORKING.getCode(), 1);
    }

    private void addQuotationPack(ExecuteBillPO executeBillPO, List<ExecutePackPO> executePackPOS, SupQuotePO newSupQuotePO, Map<Long, Long> quotePackIdMap) {
        if (!CollectionUtils.isEmpty(executePackPOS)) {
            BigDecimal totalAmount = new BigDecimal("0");
            for (ExecutePackPO executePackPO : executePackPOS) {
                SupQuotePackPO quotePackPO = new SupQuotePackPO();
                quotePackPO.setExecuteId(executeBillPO.getExecuteId());
                Long packId = executePackPO.getPackId();
                quotePackPO.setPackId(executePackPO.getPackId());
                Long quotePackId = Sequence.getInstance().nextId();
                quotePackPO.setQuotePackId(quotePackId);
                quotePackPO.setDeleteFlag(EnquiryConstant.deleteFlag.NORMAL);
                quotePackPO.setQuotePackMoney(null);
                quotePackPO.setQuoteRound(1);
                quotePackPO.setQuoteId(newSupQuotePO.getQuoteId());
                this.supQuotePackMapper.insert(quotePackPO);
                quotePackIdMap.put(packId, quotePackId);
                if (executePackPO.getPackBudgetMoney() == null) continue;
                totalAmount = totalAmount.add(executePackPO.getPackBudgetMoney());
            }
            if (executeBillPO.getBondFlag() != null && executeBillPO.getBondFlag().toString().equals("1")) {
                log.info("\u63d2\u5165\u4fdd\u8bc1\u91d1\u7f34\u7eb3\u8868=" + newSupQuotePO.getSupplierId());
                DIqrRegistMarginPO dIqrRegistMarginPO = new DIqrRegistMarginPO();
                dIqrRegistMarginPO.setRegistPkgId(Sequence.getInstance().nextId());
                dIqrRegistMarginPO.setRegistId(dIqrRegistMarginPO.getRegistPkgId());
                dIqrRegistMarginPO.setSupplierId(newSupQuotePO.getSupplierId());
                dIqrRegistMarginPO.setSupplierName(newSupQuotePO.getSupplierName());
                dIqrRegistMarginPO.setExecutePkgId(newSupQuotePO.getExecuteId().toString());
                dIqrRegistMarginPO.setPayStatus("0");
                dIqrRegistMarginPO.setValidStatus(1);
                if (executeBillPO.getBondProportion() != null) {
                    dIqrRegistMarginPO.setMarginAmount(totalAmount.multiply(executeBillPO.getBondProportion()).divide(new BigDecimal(100), 2, 4));
                }
                this.dIqrRegistMarginMapper.insert(dIqrRegistMarginPO);
            }
        }
    }

    private void copyQuoteItem(List<ExecuteItemPO> executeItemPOS, Long quoteId, Map<Long, Long> quotePackIdMap) {
        ArrayList<SupQuoteItemPO> newSupQuoteItemPOS = new ArrayList<SupQuoteItemPO>();
        for (ExecuteItemPO itemPO : executeItemPOS) {
            SupQuoteItemPO newItemPO = new SupQuoteItemPO();
            newItemPO.setExecuteId(itemPO.getExecuteId());
            Long packId = itemPO.getPackId();
            newItemPO.setPackId(packId);
            if (quotePackIdMap.get(packId) != null) {
                newItemPO.setQuotePackId(quotePackIdMap.get(packId));
            }
            newItemPO.setPlanDetailId(itemPO.getPlanDetailId());
            newItemPO.setPlanId(itemPO.getPlanId());
            newItemPO.setQuoteId(quoteId);
            newItemPO.setQuoteNumbers(itemPO.getSl());
            newItemPO.setSl(itemPO.getSl());
            newItemPO.setQuoteRound(1);
            newItemPO.setExecuteItemId(itemPO.getExecuteItemId());
            newItemPO.setExecuteItemId(itemPO.getExecuteItemId());
            newItemPO.setDeleteFlag(EnquiryConstant.deleteFlag.NORMAL);
            newItemPO.setQuoteStatus(EnquiryConstant.QuoteStatus.NO);
            newSupQuoteItemPOS.add(newItemPO);
        }
        if (!CollectionUtils.isEmpty(newSupQuoteItemPOS)) {
            this.supQuoteItemMapper.insertBatch(newSupQuoteItemPOS);
        }
    }

    private void addItemListToMap(Map<String, List<ExecuteItemPO>> itemBOMap, String key, ExecuteItemPO executeItemPO) {
        List<ExecuteItemPO> ItemBOList = itemBOMap.get(key);
        if (ItemBOList == null) {
            ItemBOList = new ArrayList<ExecuteItemPO>();
        }
        ItemBOList.add(executeItemPO);
        itemBOMap.put(key, ItemBOList);
    }

    private void saveQuotationLog(ExecuteBillTimeTaskServiceReqBO reqBO, Long executeId, List<Long> executeItemIdList, String status, int dealResult) {
        EnquiryLogReqBO enquiryLogReqBO;
        BaseAllOperLogRspBO logRspBO;
        BasePhaseReqBO executePhaseReqBO = new BasePhaseReqBO();
        BeanUtil.copyProperties((Object)reqBO, (Object)executePhaseReqBO);
        executePhaseReqBO.setBusiType("1");
        executePhaseReqBO.setStepNum(EnquiryConstant.BasPhaseExecute.THREE);
        executePhaseReqBO.setRelateId(executeId.toString());
        executePhaseReqBO.setStatus(status);
        BasePhaseReqBO demanderPhaseReqBO = new BasePhaseReqBO();
        BeanUtil.copyProperties((Object)reqBO, (Object)demanderPhaseReqBO);
        demanderPhaseReqBO.setBusiType("2");
        demanderPhaseReqBO.setStepNum(EnquiryConstant.BasPhaseCompete.SIX);
        demanderPhaseReqBO.setExecuteItemIdList(executeItemIdList);
        demanderPhaseReqBO.setStatus(status);
        BaseAllOperLogReqBO allOperLogReqBO = null;
        if (dealResult == 2) {
            allOperLogReqBO = new BaseAllOperLogReqBO();
            BeanUtil.copyProperties((Object)reqBO, (Object)allOperLogReqBO);
            allOperLogReqBO.setOperateBusiEnum(EnquiryEnumConstant.AllOperateBusiEnum.TYPE1601);
            allOperLogReqBO.setExecuteItemIdList(executeItemIdList);
        }
        if (!"0000".equals((logRspBO = this.baseAllOperLogBusiService.saveAllOperateLog(enquiryLogReqBO = EnquiryLogReqBO.builder().executePhaseReqBO(executePhaseReqBO).demanderPhaseReqBO(demanderPhaseReqBO).allOperLogReqBO(allOperLogReqBO).build())).getRespCode())) {
            throw new BusinessException("8888", logRspBO.getRespDesc());
        }
    }

    private void saveFailExecuteLog(ExecuteBillTimeTaskServiceReqBO reqBO, Long executeId, List<Long> executeItemIdList, String status, int dealResult, String failRemark) {
        BasePhaseReqBO executePhaseReqBO = new BasePhaseReqBO();
        BeanUtil.copyProperties((Object)reqBO, (Object)executePhaseReqBO);
        executePhaseReqBO.setBusiType("1");
        executePhaseReqBO.setStepNum(EnquiryConstant.BasPhaseExecute.FINISH);
        executePhaseReqBO.setRelateId(executeId.toString());
        executePhaseReqBO.setStatus(status);
        executePhaseReqBO.setRemark(failRemark);
        EnquiryLogReqBO enquiryLogReqBO = EnquiryLogReqBO.builder().executePhaseReqBO(executePhaseReqBO).demanderPhaseReqBO(null).allOperLogReqBO(null).build();
        BaseAllOperLogRspBO logRspBO = this.baseAllOperLogBusiService.saveAllOperateLog(enquiryLogReqBO);
        if (!"0000".equals(logRspBO.getRespCode())) {
            throw new BusinessException("8888", logRspBO.getRespDesc());
        }
    }

    private void saveFailQuotationLog(ExecuteBillTimeTaskServiceReqBO reqBO, List<Long> executeItemIdList, String status, int dealResult, String failRemark) {
        EnquiryLogReqBO enquiryLogReqBO;
        BaseAllOperLogRspBO logRspBO;
        BasePhaseReqBO demanderPhaseReqBO = new BasePhaseReqBO();
        BeanUtil.copyProperties((Object)reqBO, (Object)demanderPhaseReqBO);
        demanderPhaseReqBO.setBusiType("2");
        demanderPhaseReqBO.setStepNum(EnquiryConstant.BasPhaseCompete.FOUR);
        demanderPhaseReqBO.setExecuteItemIdList(executeItemIdList);
        demanderPhaseReqBO.setStatus(status);
        demanderPhaseReqBO.setRemark(failRemark);
        BaseAllOperLogReqBO allOperLogReqBO = null;
        if (dealResult == 2) {
            allOperLogReqBO = new BaseAllOperLogReqBO();
            BeanUtil.copyProperties((Object)reqBO, (Object)allOperLogReqBO);
            allOperLogReqBO.setOperateBusiEnum(EnquiryEnumConstant.AllOperateBusiEnum.TYPE1801);
            allOperLogReqBO.setExecuteItemIdList(executeItemIdList);
        }
        if (!"0000".equals((logRspBO = this.baseAllOperLogBusiService.saveAllOperateLog(enquiryLogReqBO = EnquiryLogReqBO.builder().executePhaseReqBO(null).demanderPhaseReqBO(demanderPhaseReqBO).allOperLogReqBO(allOperLogReqBO).build())).getRespCode())) {
            throw new BusinessException("8888", logRspBO.getRespDesc());
        }
    }
}

