/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.enquiry.ability.impl;

import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.util.StrUtil;
import com.alibaba.fastjson.JSON;
import com.ohaotian.plugin.file.FileClient;
import com.ohaotian.plugin.file.fastdfs.FastdfsFileInfo;
import com.tydic.enquiry.api.ImportQuotationMidItemAbilityService;
import com.tydic.enquiry.api.bo.EnquriyOrgSupTagBO;
import com.tydic.enquiry.api.bo.ImportQuotationMidItemReqBO;
import com.tydic.enquiry.api.bo.ImportQuotationMidItemRspBO;
import com.tydic.enquiry.api.bo.QuotationMidItemBO;
import com.tydic.enquiry.api.bo.UpdateQuotationMidItemReqBO;
import com.tydic.enquiry.api.bo.UpdateQuotationMidItemRspBO;
import com.tydic.enquiry.busi.api.UpdateQuotationMidItemBusiService;
import com.tydic.enquiry.busi.impl.plan.BlackSupinfoCommonService;
import com.tydic.enquiry.constant.EnquiryEnumConstant;
import com.tydic.enquiry.dao.ExecuteItemMapper;
import com.tydic.enquiry.dao.SupQuoteItemMapper;
import com.tydic.enquiry.dao.SupQuoteMapper;
import com.tydic.enquiry.dao.po.ExecuteItemPO;
import com.tydic.enquiry.dao.po.SupQuoteItemPO;
import com.tydic.enquiry.dao.po.SupQuotePO;
import com.tydic.enquiry.exceptions.BusinessException;
import com.tydic.enquiry.utils.BatchImportUtils;
import com.tydic.enquiry.utils.ExcelUtils;
import com.tydic.umcext.ability.fileDownload.CnncUmcFileImpLogAbilityService;
import com.tydic.umcext.ability.fileDownload.bo.CnncUmcFileImpLogAbilityReqBO;
import com.tydic.umcext.ability.fileDownload.bo.CnncUmcFileImpLogAbilityRspBO;
import com.tydic.umcext.ability.fileDownload.bo.CnncUmcFileImpLogDetailBO;
import com.tydic.umcext.ability.invoice.bo.BusinessChangeFileAnnoxBO;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import org.apache.commons.lang3.StringUtils;
import org.apache.poi.util.IOUtils;
import org.apache.poi.xssf.streaming.SXSSFWorkbook;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.util.CollectionUtils;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"ENQUIRY_GROUP/1.0.0/com.tydic.enquiry.api.ImportQuotationMidItemAbilityService"})
public class ImportQuotationMidItemAbilityServiceImpl
implements ImportQuotationMidItemAbilityService {
    private static final Logger log = LoggerFactory.getLogger(ImportQuotationMidItemAbilityServiceImpl.class);
    @Value(value="${plugin.file.type}")
    private String fileType;
    @Autowired
    private FileClient fileClient;
    @Value(value="${preFilePath}")
    private String preFilePath;
    @Value(value="${oss.fileUrl}")
    private String ossFileUrl;
    @Value(value="${fastdfs.httpTrackerHttpPort}")
    private String fastdfsHttpTrackerHttpPort;
    @Value(value="${fastdfs.trackerServers}")
    private String fastdfsTrackerServers;
    @Value(value="${export.file.public.url}")
    private String exportFilePublicUrl;
    public static final String OSS = "OSS";
    public static final String FASTDFS = "FASTDFS";
    @Autowired
    private CnncUmcFileImpLogAbilityService cnncUmcFileImpLogAbilityService;
    @Autowired
    private UpdateQuotationMidItemBusiService updateQuotationMidItemBusiService;
    @Autowired
    private SupQuoteItemMapper supQuoteItemMapper;
    @Autowired
    private SupQuoteMapper supQuoteMapper;
    @Autowired
    private ExecuteItemMapper executeItemMapper;
    @Autowired
    private BlackSupinfoCommonService blackSupinfoCommonService;

    @PostMapping(value={"importQuotation"})
    public ImportQuotationMidItemRspBO importQuotation(@RequestBody ImportQuotationMidItemReqBO reqBO) {
        ImportQuotationMidItemRspBO rspBO = new ImportQuotationMidItemRspBO();
        SupQuotePO supQuotePO = this.supQuoteMapper.selectByPrimaryKey(reqBO.getQuoteId());
        if (supQuotePO == null) {
            rspBO.setRespCode("8888");
            rspBO.setRespDesc("\u62a5\u4ef7\u5355\u4e0d\u5b58\u5728!");
            return rspBO;
        }
        rspBO.setIsSuccess("true");
        if (reqBO.getExecuteId() == null && reqBO.getExecuteBillId() == null) {
            throw new BusinessException("7777", "\u6267\u884c\u5355id \uff08ExecuteId\uff09 \u4e0d\u80fd\u4e3a\u7a7a!");
        }
        if (reqBO.getQuoteId() == null) {
            throw new BusinessException("7777", "\u62a5\u4ef7ID\u4e0d\u80fd\u4e3a\u7a7a!");
        }
        if (StringUtils.isBlank((CharSequence)reqBO.getRedisNo())) {
            throw new BusinessException("7777", "\u7f13\u5b58\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a!");
        }
        if (StringUtils.isBlank((CharSequence)reqBO.getUrl()) && StringUtils.isBlank((CharSequence)reqBO.getFileUrl())) {
            throw new BusinessException("7777", "\u6587\u4ef6url\u4e0d\u80fd\u4e3a\u7a7a!");
        }
        if (reqBO.getExecuteId() == null) {
            reqBO.setExecuteId(reqBO.getExecuteBillId());
        }
        if (StringUtils.isBlank((CharSequence)reqBO.getUrl())) {
            reqBO.setUrl(reqBO.getFileUrl());
        }
        ArrayList<String> title = new ArrayList<String>();
        ArrayList<List<String>> data = new ArrayList<List<String>>();
        ArrayList<QuotationMidItemBO> quotationMidItemBOList = new ArrayList<QuotationMidItemBO>();
        ArrayList<QuotationMidItemBO> errorQuotationMidItemBOList = new ArrayList<QuotationMidItemBO>();
        List<Object> importDataMap = new ArrayList();
        ArrayList<Map<String, Object>> errorImportDataMap = new ArrayList<Map<String, Object>>();
        Long successCount = 0L;
        Long failedCount = 0L;
        try {
            BatchImportUtils<QuotationMidItemBO> batchImportUtils = new BatchImportUtils<QuotationMidItemBO>(title, data, QuotationMidItemBO.class);
            batchImportUtils.batchImport(reqBO.getUrl(), 2, 1, 2000);
            importDataMap = batchImportUtils.getImportDataMaps();
        }
        catch (Exception e) {
            e.printStackTrace();
            log.error("\u5bfc\u5165\u89e3\u6790\u6587\u4ef6\u6570\u636e\u5931\u8d25:{}", (Object)e.toString());
            rspBO.setRespCode("8888");
            rspBO.setRespDesc(e.toString());
            return rspBO;
        }
        List tempList = new ArrayList();
        ArrayList<Long> quoteItemIdList = new ArrayList<Long>();
        log.info("\u5bfc\u5165\u7ed3\u679c\u6570\u636e\uff1a" + importDataMap);
        if (CollectionUtils.isEmpty(importDataMap)) {
            rspBO.setRespCode("0000");
            rspBO.setRespDesc("\u89e3\u6790\u6587\u4ef6\u4e3a\u7a7a!");
            return rspBO;
        }
        try {
            tempList = JSON.parseArray((String)JSON.toJSONString(importDataMap), QuotationMidItemBO.class);
        }
        catch (Exception e) {
            log.error("\u6570\u636e\u89e3\u6790\u5931\u8d25:{}", (Object)e.toString());
            e.printStackTrace();
            rspBO.setRespCode("0000");
            rspBO.setRespDesc("\u6570\u636e\u89e3\u6790\u5931\u8d25:" + e.toString());
            return rspBO;
        }
        for (QuotationMidItemBO midItemBO : tempList) {
            if ("0".equals(midItemBO.getImpResult())) {
                if (!StringUtils.isEmpty((CharSequence)midItemBO.getPromiseDeliveryDaysStr())) {
                    midItemBO.setPromiseDeliveryDays(Integer.valueOf(midItemBO.getPromiseDeliveryDaysStr()));
                }
                if (!StringUtils.isEmpty((CharSequence)midItemBO.getQuotePriceStr())) {
                    BigDecimal quotePrice = new BigDecimal(midItemBO.getQuotePriceStr());
                    midItemBO.setQuotePrice(quotePrice);
                }
                if (!StringUtils.isEmpty((CharSequence)midItemBO.getQuoteIsDeviate())) {
                    midItemBO.setQuoteIsDeviateStr(midItemBO.getQuoteIsDeviate());
                    midItemBO.setQuoteIsDeviate(EnquiryEnumConstant.QuoteIsDeviateEnum.getCode((String)midItemBO.getQuoteIsDeviate()));
                }
                quoteItemIdList.add(midItemBO.getQuoteItemId());
                continue;
            }
            if (midItemBO.getQuoteItemId() != null) {
                quoteItemIdList.add(midItemBO.getQuoteItemId());
            }
            errorQuotationMidItemBOList.add(midItemBO);
        }
        HashSet<String> orgIdSet = new HashSet<String>();
        if (!CollectionUtils.isEmpty(quoteItemIdList)) {
            String demandOrgId;
            SupQuoteItemPO allSupItemQryBO = new SupQuoteItemPO();
            allSupItemQryBO.setQuoteId(reqBO.getQuoteId());
            List<SupQuoteItemPO> allQuoteItems = this.supQuoteItemMapper.selectListBy(allSupItemQryBO);
            HashMap<Long, Long> allQuoteItemMap = new HashMap<Long, Long>();
            ArrayList executeItemIdList = new ArrayList();
            for (SupQuoteItemPO quoteItemPO : allQuoteItems) {
                executeItemIdList.add(quoteItemPO.getExecuteItemId());
                allQuoteItemMap.put(quoteItemPO.getExecuteItemId(), quoteItemPO.getQuoteItemId());
            }
            HashMap<Long, ExecuteItemPO> executeItemPOMap = new HashMap<Long, ExecuteItemPO>();
            if (CollUtil.isNotEmpty((Collection)executeItemIdList)) {
                ExecuteItemPO record = new ExecuteItemPO();
                record.setExecuteItemIdList(executeItemIdList);
                List<ExecuteItemPO> ExecuteItemPOList = this.executeItemMapper.getList(record);
                if (CollUtil.isNotEmpty(ExecuteItemPOList)) {
                    for (ExecuteItemPO executeItemPO : ExecuteItemPOList) {
                        executeItemPOMap.put(executeItemPO.getExecuteItemId(), executeItemPO);
                    }
                }
            }
            SupQuoteItemPO supQuoteItemPO = new SupQuoteItemPO();
            supQuoteItemPO.setQuoteItemIdList(quoteItemIdList);
            List<SupQuoteItemPO> quoteItemPOS = this.supQuoteItemMapper.selectListBy(supQuoteItemPO);
            HashMap impQuoteItemMap = new HashMap();
            HashMap<Long, SupQuoteItemPO> quoteItemMap = new HashMap<Long, SupQuoteItemPO>();
            for (SupQuoteItemPO quoteItemPO : quoteItemPOS) {
                Long executeItemId = quoteItemPO.getExecuteItemId();
                if (allQuoteItemMap.containsKey(executeItemId)) {
                    executeItemIdList.add(quoteItemPO.getExecuteItemId());
                    impQuoteItemMap.put(quoteItemPO.getQuoteItemId(), allQuoteItemMap.get(executeItemId));
                }
                quoteItemMap.put(quoteItemPO.getQuoteItemId(), quoteItemPO);
            }
            for (QuotationMidItemBO quotationMidItemBO : tempList) {
                Long quoteItemId = quotationMidItemBO.getQuoteItemId();
                SupQuoteItemPO quoteItemPO = (SupQuoteItemPO)quoteItemMap.get(quoteItemId);
                if (quoteItemPO == null) continue;
                Long executeItemId = quoteItemPO.getExecuteItemId();
                quotationMidItemBO.setExecuteItemId(executeItemId);
                ExecuteItemPO executeItemPO = (ExecuteItemPO)executeItemPOMap.get(executeItemId);
                if (executeItemPO == null) continue;
                demandOrgId = executeItemPO.getDemandOrgId();
                quotationMidItemBO.setDemandOrgId(demandOrgId);
                orgIdSet.add(demandOrgId);
            }
            Long supplierId = supQuotePO.getSupplierId();
            Map<String, List<EnquriyOrgSupTagBO>> allOrgBlackMap = this.blackSupinfoCommonService.getOrgBlackSupMap(orgIdSet, supplierId);
            for (QuotationMidItemBO quotationMidItemBO : tempList) {
                Long quoteItemId = quotationMidItemBO.getQuoteItemId();
                if (!"0".equals(quotationMidItemBO.getImpResult())) continue;
                String errorMsg = "";
                if (impQuoteItemMap.containsKey(quoteItemId)) {
                    quotationMidItemBO.setQuoteItemId((Long)impQuoteItemMap.get(quoteItemId));
                } else {
                    errorMsg = "\u62a5\u4ef7\u660e\u7ec6\u7f16\u53f7\uff1a" + quoteItemId + "\u4e0d\u4e3a\u6b64\u62a5\u4ef7\u5355\u62a5\u4ef7\u660e\u7ec6";
                }
                demandOrgId = quotationMidItemBO.getDemandOrgId();
                String key = demandOrgId + "_" + supplierId;
                List<EnquriyOrgSupTagBO> blackList = allOrgBlackMap.get(key);
                if (CollUtil.isNotEmpty(blackList)) {
                    errorMsg = "\u62a5\u4ef7\u660e\u7ec6\u7f16\u53f7\uff1a" + quoteItemId + "\u9ed1\u7070\u540d\u5355\u4f9b\u5e94\u5546\uff0c\u4e0d\u53ef\u62a5\u4ef7";
                } else if (quotationMidItemBO.getQuotePrice().compareTo(BigDecimal.ZERO) <= 0) {
                    errorMsg = "\u62a5\u4ef7\u5fc5\u987b\u5927\u4e8e0";
                } else if (EnquiryEnumConstant.QuoteIsDeviateEnum.YPL.getCode().equals(quotationMidItemBO.getQuoteIsDeviate()) && StringUtils.isEmpty((CharSequence)quotationMidItemBO.getQuoteDeviateDescribe())) {
                    errorMsg = "\u62a5\u4ef7\u660e\u7ec6\u7f16\u53f7\uff1a" + quoteItemId + "\u62a5\u4ef7\u6709\u504f\u79bb\uff0c\u504f\u79bb\u63cf\u8ff0\u4e0d\u80fd\u4e3a\u7a7a";
                }
                if (StrUtil.isNotBlank((CharSequence)errorMsg)) {
                    quotationMidItemBO.setImpResult("1");
                    quotationMidItemBO.setImpRemark(errorMsg);
                    errorQuotationMidItemBOList.add(quotationMidItemBO);
                    continue;
                }
                quotationMidItemBOList.add(quotationMidItemBO);
            }
        }
        if (!CollectionUtils.isEmpty(quotationMidItemBOList)) {
            UpdateQuotationMidItemReqBO updateQuotationMidItemReqBO = new UpdateQuotationMidItemReqBO();
            updateQuotationMidItemReqBO.setQuotationMidItemList(quotationMidItemBOList);
            updateQuotationMidItemReqBO.setRedisNo(reqBO.getRedisNo());
            updateQuotationMidItemReqBO.setExecuteId(reqBO.getExecuteId());
            updateQuotationMidItemReqBO.setPackId(reqBO.getPackId());
            updateQuotationMidItemReqBO.setQuoteId(reqBO.getQuoteId());
            updateQuotationMidItemReqBO.setIsCheckSku("1");
            UpdateQuotationMidItemRspBO updateQuotationMidItemRspBO = this.updateQuotationMidItemBusiService.updateQuotationMidItem(updateQuotationMidItemReqBO);
            if (!"0000".equals(updateQuotationMidItemRspBO.getRespCode())) {
                rspBO.setRespCode("8888");
                rspBO.setRespDesc("\u66f4\u65b0\u62a5\u4ef7\u6570\u636e\u5931\u8d25:" + updateQuotationMidItemRspBO.getRespDesc());
                return rspBO;
            }
        }
        CnncUmcFileImpLogAbilityReqBO cnncUmcFileImpLogAbilityReqBO = new CnncUmcFileImpLogAbilityReqBO();
        ArrayList<Map<String, Object>> allImportDataMap = new ArrayList<Map<String, Object>>();
        if (!CollectionUtils.isEmpty(errorQuotationMidItemBOList)) {
            int index = 0;
            for (QuotationMidItemBO quotationMidItemBO : errorQuotationMidItemBOList) {
                LinkedHashMap<String, Object> errorItem = new LinkedHashMap<String, Object>();
                errorItem.put("\u5e8f\u53f7", ++index);
                errorItem.put("\u62a5\u4ef7\u660e\u7ec6\u7f16\u53f7", quotationMidItemBO.getQuoteItemId() != null ? quotationMidItemBO.getQuoteItemId() : "");
                errorItem.put("\u54c1\u724c", quotationMidItemBO.getBrand() != null ? quotationMidItemBO.getBrand() : "");
                errorItem.put("\u751f\u4ea7\u5382\u5bb6", quotationMidItemBO.getManufacturer() != null ? quotationMidItemBO.getManufacturer() : "");
                errorItem.put("\u5546\u54c1\u578b\u53f7\u6216\u5176\u4ed6\u4fe1\u606f", quotationMidItemBO.getProductModelAndOther() != null ? quotationMidItemBO.getProductModelAndOther() : "");
                errorItem.put("\u662f\u5426\u504f\u79bb", quotationMidItemBO.getQuoteIsDeviateStr() != null ? quotationMidItemBO.getQuoteIsDeviateStr() : "");
                errorItem.put("\u504f\u79bb\u63cf\u8ff0", quotationMidItemBO.getQuoteDeviateDescribe() != null ? quotationMidItemBO.getQuoteDeviateDescribe() : "");
                errorItem.put("\u5546\u54c1\u7f16\u7801", quotationMidItemBO.getProductCode() != null ? quotationMidItemBO.getProductCode() : "");
                errorItem.put("\u5916\u90e8\u5546\u54c1\u7f16\u7801", quotationMidItemBO.getOutsideProductCode() != null ? quotationMidItemBO.getOutsideProductCode() : "");
                errorItem.put("\u534f\u8bae\u660e\u7ec6\u7f16\u7801", quotationMidItemBO.getAgreementItemCode() != null ? quotationMidItemBO.getAgreementItemCode() : "");
                errorItem.put("UPC\u7801", quotationMidItemBO.getUpcCode() != null ? quotationMidItemBO.getUpcCode() : "");
                errorItem.put("\u627f\u8bfa\u4ea4\u8d27\u671f", quotationMidItemBO.getPromiseDeliveryDaysStr() != null ? quotationMidItemBO.getPromiseDeliveryDaysStr() : "");
                errorItem.put("\u62a5\u4ef7\u91d1\u989d", quotationMidItemBO.getQuotePriceStr() != null ? quotationMidItemBO.getQuotePriceStr() : "");
                errorItem.put("\u5bfc\u5165\u7ed3\u679c", "\u5931\u8d25");
                errorItem.put("\u5931\u8d25\u539f\u56e0", quotationMidItemBO.getImpRemark() != null ? quotationMidItemBO.getImpRemark() : "");
                errorImportDataMap.add(errorItem);
            }
            rspBO.setIsSuccess("false");
            rspBO.setRemark("\u62a5\u4ef7\u5bfc\u5165\u5931\u8d25\uff1a\u6570\u636e\u6821\u9a8c\u5931\u8d25");
            String url = this.uploadFile(errorImportDataMap, "\u62a5\u4ef7\u660e\u7ec6\u5bfc\u5165\u7ed3\u679c" + System.currentTimeMillis());
            ArrayList<BusinessChangeFileAnnoxBO> fileUrlList = new ArrayList<BusinessChangeFileAnnoxBO>();
            BusinessChangeFileAnnoxBO annoxBO = new BusinessChangeFileAnnoxBO();
            annoxBO.setName("\u62a5\u4ef7\u660e\u7ec6\u5bfc\u5165\u7ed3\u679c");
            annoxBO.setPath(url);
            fileUrlList.add(annoxBO);
            cnncUmcFileImpLogAbilityReqBO.setFileUrl(fileUrlList);
        }
        if (!CollectionUtils.isEmpty(tempList)) {
            int index = 0;
            for (QuotationMidItemBO quotationMidItemBO : tempList) {
                Object object;
                Long l;
                LinkedHashMap<String, Object> item = new LinkedHashMap<String, Object>();
                item.put("\u5e8f\u53f7", ++index);
                item.put("\u62a5\u4ef7\u660e\u7ec6\u7f16\u53f7", quotationMidItemBO.getQuoteItemId() != null ? quotationMidItemBO.getQuoteItemId() : "");
                item.put("\u54c1\u724c", quotationMidItemBO.getBrand() != null ? quotationMidItemBO.getBrand() : "");
                item.put("\u751f\u4ea7\u5382\u5bb6", quotationMidItemBO.getManufacturer() != null ? quotationMidItemBO.getManufacturer() : "");
                item.put("\u5546\u54c1\u578b\u53f7\u6216\u5176\u4ed6\u4fe1\u606f", quotationMidItemBO.getProductModelAndOther() != null ? quotationMidItemBO.getProductModelAndOther() : "");
                item.put("\u662f\u5426\u504f\u79bb", quotationMidItemBO.getQuoteIsDeviateStr() != null ? quotationMidItemBO.getQuoteIsDeviateStr() : "");
                item.put("\u504f\u79bb\u63cf\u8ff0", quotationMidItemBO.getQuoteDeviateDescribe() != null ? quotationMidItemBO.getQuoteDeviateDescribe() : "");
                item.put("\u5546\u54c1\u7f16\u7801", quotationMidItemBO.getProductCode() != null ? quotationMidItemBO.getProductCode() : "");
                item.put("\u5916\u90e8\u5546\u54c1\u7f16\u7801", quotationMidItemBO.getOutsideProductCode() != null ? quotationMidItemBO.getOutsideProductCode() : "");
                item.put("\u534f\u8bae\u660e\u7ec6\u7f16\u7801", quotationMidItemBO.getAgreementItemCode() != null ? quotationMidItemBO.getAgreementItemCode() : "");
                item.put("UPC\u7801", quotationMidItemBO.getUpcCode() != null ? quotationMidItemBO.getUpcCode() : "");
                item.put("\u627f\u8bfa\u4ea4\u8d27\u671f", quotationMidItemBO.getPromiseDeliveryDaysStr() != null ? quotationMidItemBO.getPromiseDeliveryDaysStr() : "");
                item.put("\u62a5\u4ef7\u91d1\u989d", quotationMidItemBO.getQuotePriceStr() != null ? quotationMidItemBO.getQuotePriceStr() : "");
                if ("0".equals(quotationMidItemBO.getImpResult())) {
                    item.put("\u5bfc\u5165\u7ed3\u679c", "\u6210\u529f");
                    item.put("\u5931\u8d25\u539f\u56e0", "");
                    l = successCount;
                    successCount = successCount + 1L;
                    object = successCount;
                } else {
                    item.put("\u5bfc\u5165\u7ed3\u679c", "\u5931\u8d25");
                    item.put("\u5931\u8d25\u539f\u56e0", quotationMidItemBO.getImpRemark() != null ? quotationMidItemBO.getImpRemark() : "");
                    l = failedCount;
                    failedCount = failedCount + 1L;
                    object = failedCount;
                }
                allImportDataMap.add(item);
            }
        }
        cnncUmcFileImpLogAbilityReqBO.setOutImpId(reqBO.getQuoteId());
        cnncUmcFileImpLogAbilityReqBO.setImpType("EXECUTE_QUOTE");
        cnncUmcFileImpLogAbilityReqBO.setMemIdIn(reqBO.getMemIdIn());
        cnncUmcFileImpLogAbilityReqBO.setSuccessCount(successCount);
        cnncUmcFileImpLogAbilityReqBO.setFailureCount(failedCount);
        cnncUmcFileImpLogAbilityReqBO.setImpCount(Long.valueOf(successCount + failedCount));
        if (failedCount != 0L) {
            cnncUmcFileImpLogAbilityReqBO.setImpResult(Integer.valueOf(1));
            cnncUmcFileImpLogAbilityReqBO.setImpRemark("\u539f\u56e0\u8be6\u60c5\u8bf7\u67e5\u770b\u5217\u8868");
        } else {
            cnncUmcFileImpLogAbilityReqBO.setImpResult(Integer.valueOf(0));
            cnncUmcFileImpLogAbilityReqBO.setImpRemark("\u6210\u529f");
        }
        log.info("\u5bfc\u5165\u7ed3\u679c\u6570\u636e\uff1a" + allImportDataMap);
        this.createDataJson(cnncUmcFileImpLogAbilityReqBO, allImportDataMap);
        log.info("\u8c03\u7528\u4f1a\u5458\u5bfc\u5165\u8bb0\u5f55\u670d\u52a1\u5165\u53c2\u4e3a:" + JSON.toJSONString((Object)cnncUmcFileImpLogAbilityReqBO));
        CnncUmcFileImpLogAbilityRspBO cnncUmcFileImpLogAbilityRspBO = this.cnncUmcFileImpLogAbilityService.fileImpLogAdd(cnncUmcFileImpLogAbilityReqBO);
        log.info("\u8c03\u7528\u4f1a\u5458\u5bfc\u5165\u8bb0\u5f55\u670d\u52a1\u51fa\u53c2\u4e3a:" + JSON.toJSONString((Object)cnncUmcFileImpLogAbilityRspBO));
        if (!"0000".equals(cnncUmcFileImpLogAbilityRspBO.getRespCode())) {
            rspBO.setRespCode("8888");
            rspBO.setRespDesc(cnncUmcFileImpLogAbilityRspBO.getRespDesc());
        }
        rspBO.setImpId(cnncUmcFileImpLogAbilityRspBO.getImpId().toString());
        rspBO.setRespCode("0000");
        rspBO.setRespDesc(cnncUmcFileImpLogAbilityRspBO.getRespDesc());
        return rspBO;
    }

    private void createDataJson(CnncUmcFileImpLogAbilityReqBO cnncUmcFileImpLogAbilityReqBO, List<Map<String, Object>> exportData) {
        StringBuilder headBuilder = new StringBuilder();
        if (exportData != null && exportData.size() > 0) {
            boolean firstRow = true;
            ArrayList<CnncUmcFileImpLogDetailBO> logDetailBOS = new ArrayList<CnncUmcFileImpLogDetailBO>();
            for (Map<String, Object> row : exportData) {
                CnncUmcFileImpLogDetailBO detailBO = new CnncUmcFileImpLogDetailBO();
                StringBuilder builder = new StringBuilder();
                Iterator<Map.Entry<String, Object>> it = row.entrySet().iterator();
                int size = row.size();
                int count = 1;
                while (it.hasNext()) {
                    Map.Entry<String, Object> entry = it.next();
                    if (firstRow) {
                        if (count == size) {
                            firstRow = false;
                            headBuilder.append((Object)entry.getKey());
                        } else {
                            headBuilder.append((Object)entry.getKey()).append("##");
                        }
                    }
                    builder.append(StringUtils.isBlank((CharSequence)entry.getValue().toString()) ? " " : entry.getValue());
                    if (count != size) {
                        builder.append("##");
                    }
                    ++count;
                }
                detailBO.setDataJson(builder.toString());
                if (row.get("\u5bfc\u5165\u7ed3\u679c").toString().equals("\u6210\u529f")) {
                    detailBO.setStatus(Integer.valueOf(0));
                } else {
                    detailBO.setStatus(Integer.valueOf(1));
                    detailBO.setFailureReasons(row.get("\u5931\u8d25\u539f\u56e0").toString());
                }
                logDetailBOS.add(detailBO);
            }
            cnncUmcFileImpLogAbilityReqBO.setLogDetails(logDetailBOS);
            cnncUmcFileImpLogAbilityReqBO.setDataColumns(headBuilder.toString());
        }
    }

    public String uploadFile(List<Map<String, Object>> data, String name) {
        String string;
        SXSSFWorkbook workbook = ExcelUtils.createWorkbook(data, name);
        ByteArrayOutputStream out = null;
        ByteArrayInputStream in = null;
        String result = "";
        String uploadPath = "enquiry";
        String fileName = UUID.randomUUID() + ".xlsx";
        try {
            out = new ByteArrayOutputStream();
            workbook.write((OutputStream)out);
            byte[] buff = out.toByteArray();
            in = new ByteArrayInputStream(buff);
            result = this.fileClient.uploadFileByInputStream(uploadPath, fileName, (InputStream)in);
            out.flush();
            String fullFilePath = "";
            if (OSS.equals(this.fileType)) {
                fullFilePath = this.preFilePath + result;
            } else if (FASTDFS.equals(this.fileType)) {
                FastdfsFileInfo fastdfsFileInfo = FastdfsFileInfo.toFastdfsFileInfo((String)result);
                fullFilePath = this.exportFilePublicUrl + "/" + fastdfsFileInfo.getGroupName() + "/" + fastdfsFileInfo.getFileName();
            }
            string = fullFilePath;
        }
        catch (IOException e) {
            try {
                throw new BusinessException("22051", "\u6587\u4ef6\u4e0a\u4f20\u5931\u8d25\uff01");
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(in);
                IOUtils.closeQuietly((Closeable)out);
                throw throwable;
            }
        }
        IOUtils.closeQuietly((Closeable)in);
        IOUtils.closeQuietly((Closeable)out);
        return string;
    }
}

