/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.enquiry.ability.impl;

import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.date.DateUtil;
import com.itextpdf.text.BaseColor;
import com.itextpdf.text.Document;
import com.itextpdf.text.DocumentException;
import com.itextpdf.text.Font;
import com.itextpdf.text.PageSize;
import com.itextpdf.text.pdf.BaseFont;
import com.itextpdf.text.pdf.PdfPTable;
import com.itextpdf.text.pdf.PdfWriter;
import com.ohaotian.plugin.base.exception.ZTBusinessException;
import com.ohaotian.plugin.file.FileClient;
import com.ohaotian.plugin.file.fastdfs.FastdfsFileInfo;
import com.tydic.enquiry.api.EnquiryDealConfirmAbilityService;
import com.tydic.enquiry.api.PurchaseExecuteBillPdfAbilityService;
import com.tydic.enquiry.api.bo.BaseAllOperLogBO;
import com.tydic.enquiry.api.bo.BaseAllOperLogPageRspBO;
import com.tydic.enquiry.api.bo.BaseAllOperLogQueryBO;
import com.tydic.enquiry.api.bo.EnquiryDealConfirmItemPageRspBO;
import com.tydic.enquiry.api.bo.EnquiryDealConfirmReqBO;
import com.tydic.enquiry.api.bo.EnquiryExecuteQuotePlanItemBO;
import com.tydic.enquiry.api.bo.ExecuteQuotePlanItemBo;
import com.tydic.enquiry.api.bo.ExecuteSupJoinBo;
import com.tydic.enquiry.api.bo.PurchaseExecuteBillBo;
import com.tydic.enquiry.api.bo.PurchaseExecuteItemBO;
import com.tydic.enquiry.api.bo.PurchaseExecutePackBo;
import com.tydic.enquiry.api.bo.QryQuotationItemListByPageReqBO;
import com.tydic.enquiry.api.bo.QryQuotationItemListByPageRspBO;
import com.tydic.enquiry.api.bo.QueryPurchaseExecuteBillReqBO;
import com.tydic.enquiry.api.bo.QueryPurchaseExecuteBillRspBO;
import com.tydic.enquiry.api.bo.QueryPurchaseExecuteItemListReqBO;
import com.tydic.enquiry.api.bo.QueryPurchaseExecuteItemListRspBO;
import com.tydic.enquiry.api.bo.QueryPurchaseExecuteListReqBO;
import com.tydic.enquiry.api.bo.QueryPurchaseExecuteListRspBO;
import com.tydic.enquiry.api.bo.QuotationItemBO;
import com.tydic.enquiry.busi.api.BaseAllOperLogBusiService;
import com.tydic.enquiry.busi.api.PurchaseExecuteBillQueryBusiService;
import com.tydic.enquiry.busi.api.QryQuotationItemListByPageBusiService;
import com.tydic.enquiry.busi.api.QueryPurchaseExecuteItemListBusiService;
import com.tydic.enquiry.busi.api.QueryPurchaseExecuteListBusiService;
import com.tydic.enquiry.busi.utils.PdfUtil;
import com.tydic.enquiry.busi.utils.WatermarkInfoBO;
import com.tydic.enquiry.constant.EnquiryCommonUtil;
import com.tydic.enquiry.constant.EnquiryConstant;
import com.tydic.enquiry.exceptions.BusinessException;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import org.apache.http.HttpEntity;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClientBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.util.CollectionUtils;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"ENQUIRY_GROUP/1.0.0/com.tydic.enquiry.api.PurchaseExecuteBillPdfAbilityService"})
public class PurchaseExecuteBillPdfAbilityServiceImpl
implements PurchaseExecuteBillPdfAbilityService {
    private static final Logger log = LoggerFactory.getLogger(PurchaseExecuteBillPdfAbilityServiceImpl.class);
    @Autowired
    private FileClient fileClient;
    private static final String PATH = "enquiry";
    public static final String FILE_TYPE_OSS = "OSS";
    public static final String FILE_TYPE_FASTDFS = "FASTDFS";
    @Value(value="${plugin.file.type}")
    private String fileType;
    @Value(value="${oss.fileUrl}")
    private String ossFileUrl;
    @Value(value="${fastdfs.downloadUrl}")
    private String fastdfsDownloadUrl;
    @Value(value="${fastdfs.serverdownloadUrl}")
    private String serverdownloadUrl;
    @Autowired
    private PurchaseExecuteBillQueryBusiService purchaseExecuteBillQueryBusiService;
    @Autowired
    private QueryPurchaseExecuteItemListBusiService queryPurchaseExecuteItemListBusiService;
    @Autowired
    private QueryPurchaseExecuteListBusiService queryPurchaseExecuteListBusiService;
    @Autowired
    private BaseAllOperLogBusiService baseAllOperLogBusiService;
    @Autowired
    private EnquiryDealConfirmAbilityService enquiryDealConfirmAbilityService;
    @Autowired
    private QryQuotationItemListByPageBusiService qryQuotationItemListByPageBusiService;

    @PostMapping(value={"printPurchaseExecuteBillPdf"})
    public QueryPurchaseExecuteBillRspBO printPurchaseExecuteBillPdf(@RequestBody QueryPurchaseExecuteBillReqBO reqBO) {
        QueryPurchaseExecuteBillRspBO queryPurchaseExecuteBillRspBO = this.purchaseExecuteBillQueryBusiService.queryPurchaseExecuteBill(reqBO);
        QueryPurchaseExecuteItemListReqBO itemReqBO = new QueryPurchaseExecuteItemListReqBO();
        itemReqBO.setPageNo(Integer.valueOf(1));
        itemReqBO.setPageSize(Integer.valueOf(2000));
        itemReqBO.setExecuteId(reqBO.getExecuteId());
        itemReqBO.setIsProfessionalOrgExt(reqBO.getIsProfessionalOrgExt());
        ArrayList<PurchaseExecuteItemBO> purchaseExecuteItemBOList = new ArrayList<PurchaseExecuteItemBO>();
        QueryPurchaseExecuteItemListRspBO queryPurchaseExecuteItemListRspBO = this.queryPurchaseExecuteItemListBusiService.queryPurchaseExecuteItemList(itemReqBO);
        if (queryPurchaseExecuteItemListRspBO != null && queryPurchaseExecuteItemListRspBO.getRows() != null) {
            purchaseExecuteItemBOList.addAll(queryPurchaseExecuteItemListRspBO.getRows());
        }
        if (queryPurchaseExecuteItemListRspBO != null && queryPurchaseExecuteItemListRspBO.getTotal() != null && queryPurchaseExecuteItemListRspBO.getTotal() > 1) {
            for (int pageNo = 2; pageNo < queryPurchaseExecuteItemListRspBO.getTotal(); ++pageNo) {
                itemReqBO.setPageNo(Integer.valueOf(pageNo));
                itemReqBO.setPageSize(Integer.valueOf(2000));
                queryPurchaseExecuteItemListRspBO = this.queryPurchaseExecuteItemListBusiService.queryPurchaseExecuteItemList(itemReqBO);
                purchaseExecuteItemBOList.addAll(queryPurchaseExecuteItemListRspBO.getRows());
            }
        }
        String url = "";
        if ("2001".equals(queryPurchaseExecuteBillRspBO.getPurchaseExecuteBillBo().getExecuteStatus()) || "2002".equals(queryPurchaseExecuteBillRspBO.getPurchaseExecuteBillBo().getExecuteStatus()) || "2011".equals(queryPurchaseExecuteBillRspBO.getPurchaseExecuteBillBo().getExecuteStatus())) {
            try {
                GregorianCalendar quoteStartTimeCal;
                Date quoteStartTime = new Date();
                Date quoteEndTime = new Date();
                if (queryPurchaseExecuteBillRspBO.getPurchaseExecuteBillBo().getQuoteTimeDaysAppr() != null) {
                    quoteStartTimeCal = new GregorianCalendar();
                    quoteStartTimeCal.setTime(quoteStartTime);
                    ((Calendar)quoteStartTimeCal).add(5, queryPurchaseExecuteBillRspBO.getPurchaseExecuteBillBo().getQuoteTimeDaysAppr());
                    quoteStartTime = quoteStartTimeCal.getTime();
                }
                if (queryPurchaseExecuteBillRspBO.getPurchaseExecuteBillBo().getQuoteTimeAppr() != null) {
                    SimpleDateFormat quoteStartTimeFormat = new SimpleDateFormat("yyyy-MM-dd");
                    SimpleDateFormat quoteStartTimeStrFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
                    String quoteStartTimeStr = quoteStartTimeFormat.format(quoteStartTime);
                    quoteStartTimeStr = quoteStartTimeStr + " " + queryPurchaseExecuteBillRspBO.getPurchaseExecuteBillBo().getQuoteTimeAppr();
                    quoteStartTime = quoteStartTimeStrFormat.parse(quoteStartTimeStr);
                }
                if (queryPurchaseExecuteBillRspBO.getPurchaseExecuteBillBo().getQuoteTimeDays() != null) {
                    quoteStartTimeCal = new GregorianCalendar();
                    quoteStartTimeCal.setTime(quoteStartTime);
                    ((Calendar)quoteStartTimeCal).add(5, queryPurchaseExecuteBillRspBO.getPurchaseExecuteBillBo().getQuoteTimeDays());
                    quoteEndTime = quoteStartTimeCal.getTime();
                }
                long time = quoteEndTime.getTime() - quoteStartTime.getTime();
                long hour = time / 3600000L;
                long min = time / 60000L - hour * 60L;
                long s = time / 1000L - hour * 60L * 60L - min * 60L;
                queryPurchaseExecuteBillRspBO.getPurchaseExecuteBillBo().setQuoteTimeLong(hour + "\u5c0f\u65f6" + min + "\u5206" + s + "\u79d2");
                queryPurchaseExecuteBillRspBO.getPurchaseExecuteBillBo().setQuoteStartTime(quoteStartTime);
                queryPurchaseExecuteBillRspBO.getPurchaseExecuteBillBo().setQuoteEndTime(quoteEndTime);
            }
            catch (ParseException e) {
                log.error("\u65f6\u95f4\u683c\u5f0f\u8f6c\u6362\u9519\u8bef");
            }
        }
        url = "1".equals(queryPurchaseExecuteBillRspBO.getPurchaseExecuteBillBo().getExecuteType()) ? this.doPurchaseExecutePdf(queryPurchaseExecuteBillRspBO, reqBO, purchaseExecuteItemBOList) : this.doBiddingExecutePdf(queryPurchaseExecuteBillRspBO, reqBO, purchaseExecuteItemBOList);
        queryPurchaseExecuteBillRspBO.setPdfUrl(url);
        return queryPurchaseExecuteBillRspBO;
    }

    private String doPurchaseExecutePdf(QueryPurchaseExecuteBillRspBO queryPurchaseExecuteBillRspBO, QueryPurchaseExecuteBillReqBO reqBO, List<PurchaseExecuteItemBO> purchaseExecuteItemBOList) {
        String exportUrl;
        BaseFont baseFont;
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        Document document = new Document(PageSize.A4.rotate(), -75.0f, -75.0f, 15.0f, 40.0f);
        PdfWriter pdfWriter = null;
        try {
            pdfWriter = PdfWriter.getInstance((Document)document, (OutputStream)byteArrayOutputStream);
        }
        catch (DocumentException e) {
            e.printStackTrace();
        }
        try {
            baseFont = BaseFont.createFont((String)"STSong-Light", (String)"UniGB-UCS2-H", (boolean)false);
        }
        catch (Exception e) {
            throw new BusinessException("0100", "\u5b9a\u4e49\u5b57\u4f53\u51fa\u9519", e);
        }
        Font titleFont = new Font(baseFont, 14.0f, 1);
        Font contentFont = new Font(baseFont, 8.0f, 0);
        int COLUMNS = 80;
        String orgType = reqBO.getIsProfessionalOrgExt();
        if ("2".equals(orgType)) {
            COLUMNS -= 4;
        }
        document.open();
        this.doAddTextWatermark(pdfWriter, reqBO.getName());
        LinkedList<PdfPTable> tableList = new LinkedList<PdfPTable>();
        PdfPTable titleTable = new PdfPTable(1);
        tableList.add(titleTable);
        PdfUtil.addCellToTable(titleTable, "\u8bae\u4ef7\u5355\u4fe1\u606f", titleFont, 1, 5, Float.valueOf(40.0f), 1, 0);
        PdfPTable pdfPTable1 = new PdfPTable(COLUMNS);
        tableList.add(pdfPTable1);
        PdfUtil.addCellToTable(pdfPTable1, "\u8bae\u4ef7\u5355\u7f16\u53f7\uff1a" + this.getValueStr(queryPurchaseExecuteBillRspBO.getPurchaseExecuteBillBo().getExecuteCode()), contentFont, 0, 5, Float.valueOf(15.0f), 26, 0);
        PdfUtil.addCellToTable(pdfPTable1, "\u8bae\u4ef7\u5355\u540d\u79f0\uff1a" + this.getValueStr(queryPurchaseExecuteBillRspBO.getPurchaseExecuteBillBo().getExecuteName()), contentFont, 0, 5, Float.valueOf(15.0f), 28, 0);
        PdfUtil.addCellToTable(pdfPTable1, "\u5355\u636e\u72b6\u6001\uff1a" + this.getValueStr(queryPurchaseExecuteBillRspBO.getPurchaseExecuteBillBo().getExecuteStatusName()), contentFont, 0, 5, Float.valueOf(15.0f), 26, 0);
        PdfPTable pdfPTable2 = new PdfPTable(COLUMNS);
        tableList.add(pdfPTable2);
        PdfUtil.addCellToTable(pdfPTable2, "\u8bae\u4ef7\u6b21\u6570\uff1a" + this.getValueStr(queryPurchaseExecuteBillRspBO.getPurchaseExecuteBillBo().getExecuteRound()), contentFont, 0, 5, Float.valueOf(15.0f), COLUMNS, 0);
        List projectNameList = queryPurchaseExecuteBillRspBO.getPurchaseExecuteBillBo().getProjectNameList();
        if (CollUtil.isNotEmpty((Collection)projectNameList)) {
            for (int i = 0; i < projectNameList.size(); ++i) {
                PdfPTable pdfPTable21;
                if (i == 0) {
                    pdfPTable21 = new PdfPTable(COLUMNS);
                    tableList.add(pdfPTable21);
                    PdfUtil.addCellToTable(pdfPTable21, "\u9879\u76ee\uff1a" + this.getValueStr(projectNameList.get(i)), contentFont, 0, 5, Float.valueOf(15.0f), COLUMNS, 0);
                    continue;
                }
                pdfPTable21 = new PdfPTable(COLUMNS);
                tableList.add(pdfPTable21);
                PdfUtil.addCellToTable(pdfPTable21, "             " + this.getValueStr(projectNameList.get(i)), contentFont, 0, 5, Float.valueOf(15.0f), COLUMNS, 0);
            }
        }
        PdfPTable pdfPTable22 = new PdfPTable(COLUMNS);
        tableList.add(pdfPTable22);
        PdfUtil.addCellToTable(pdfPTable22, "\u7ed3\u7b97\u5e01\u79cd\uff1a" + this.getValueStr(queryPurchaseExecuteBillRspBO.getPurchaseExecuteBillBo().getAccountCurrencyName()), contentFont, 0, 5, Float.valueOf(15.0f), 26, 0);
        PdfUtil.addCellToTable(pdfPTable22, "\u9996\u8f6e\u672a\u62a5\u4ef7\u65f6\u518d\u6b21\u62a5\u4ef7\u662f\u5426\u5141\u8bb8\u62a5\u4ef7\uff1a" + this.getValueStr(queryPurchaseExecuteBillRspBO.getPurchaseExecuteBillBo().getNeedFirstQuoteFlagName()), contentFont, 0, 5, Float.valueOf(15.0f), 28, 0);
        PdfUtil.addCellToTable(pdfPTable22, "\u9884\u7b97\u4fe1\u606f\u662f\u5426\u516c\u5e03\uff1a" + this.getValueStr(queryPurchaseExecuteBillRspBO.getPurchaseExecuteBillBo().getPublishBudgetFlagName()), contentFont, 0, 5, Float.valueOf(15.0f), 26, 0);
        PdfPTable pdfPTable4 = new PdfPTable(COLUMNS);
        tableList.add(pdfPTable4);
        PdfUtil.addCellToTable(pdfPTable4, "\u8bae\u4ef7\u6d3b\u52a8\u6700\u5c11\u62a5\u4ef7\u5bb6\u6570\uff1a" + this.getValueStr(queryPurchaseExecuteBillRspBO.getPurchaseExecuteBillBo().getLeastQuoteNumber()), contentFont, 0, 5, Float.valueOf(15.0f), 26, 0);
        PdfPTable pdfPTable21 = new PdfPTable(COLUMNS);
        tableList.add(pdfPTable21);
        if ("2001".equals(queryPurchaseExecuteBillRspBO.getPurchaseExecuteBillBo().getExecuteStatus()) || "2002".equals(queryPurchaseExecuteBillRspBO.getPurchaseExecuteBillBo().getExecuteStatus()) || "2011".equals(queryPurchaseExecuteBillRspBO.getPurchaseExecuteBillBo().getExecuteStatus())) {
            PdfUtil.addCellToTable(pdfPTable21, "\u62a5\u4ef7\u65f6\u95f4\u8981\u6c42\uff1a\u5ba1\u6279\u5b8c\u6210\u540e" + this.getValueStr(queryPurchaseExecuteBillRspBO.getPurchaseExecuteBillBo().getQuoteTimeDaysAppr()) + "\u5929" + queryPurchaseExecuteBillRspBO.getPurchaseExecuteBillBo().getQuoteTimeAppr() + ";\u5f00\u59cb\u540e" + queryPurchaseExecuteBillRspBO.getPurchaseExecuteBillBo().getQuoteTimeDays() + "\u5929" + queryPurchaseExecuteBillRspBO.getPurchaseExecuteBillBo().getQuoteTime() + "\u7ed3\u675f\uff1b\u6301\u7eed\u65f6\u95f4\uff1a" + queryPurchaseExecuteBillRspBO.getPurchaseExecuteBillBo().getQuoteTimeLong() + "\uff1b\u4eca\u65e5\u5ba1\u6279\u5b8c\u6210\uff0c\u9884\u8ba1\u62a5\u4ef7\u65f6\u95f4\u4e3a" + this.getValueStr(queryPurchaseExecuteBillRspBO.getPurchaseExecuteBillBo().getQuoteStartTime()) + " \u81f3 " + this.getValueStr(queryPurchaseExecuteBillRspBO.getPurchaseExecuteBillBo().getQuoteEndTime()), contentFont, 0, 5, Float.valueOf(15.0f), COLUMNS, 0);
        } else {
            PdfUtil.addCellToTable(pdfPTable21, "\u62a5\u4ef7\u65f6\u95f4\u8981\u6c42\uff1a" + this.getValueStr(queryPurchaseExecuteBillRspBO.getPurchaseExecuteBillBo().getQuoteStartTime()) + " \u81f3 " + this.getValueStr(queryPurchaseExecuteBillRspBO.getPurchaseExecuteBillBo().getQuoteEndTime()), contentFont, 0, 5, Float.valueOf(15.0f), COLUMNS, 0);
        }
        PdfPTable pdfPTable3 = new PdfPTable(COLUMNS);
        tableList.add(pdfPTable3);
        PdfUtil.addCellToTable(pdfPTable3, "\u4f9b\u5e94\u5546\u4e0a\u67b6\u5468\u671f\uff08\u5929\uff09\uff1a" + this.getValueStr(queryPurchaseExecuteBillRspBO.getPurchaseExecuteBillBo().getPutShelfDays()), contentFont, 0, 5, Float.valueOf(15.0f), COLUMNS, 0);
        PdfPTable pdfPTable31 = new PdfPTable(COLUMNS);
        tableList.add(pdfPTable31);
        PdfUtil.addCellToTable(pdfPTable31, "           \u63d0\u793a\uff1a\u751f\u6210\u6210\u4ea4\u901a\u77e5\u548c\u540e\u4f9b\u5e94\u5546\u9700\u5728\u6b64\u65f6\u95f4\u5185\u5b8c\u6210\u5546\u54c1\u5339\u914d\u6ca1\u5426\u5219\u9700\u91cd\u65b0\u9009\u5b9a\u4f9b\u5e94\u5546", contentFont, 0, 5, Float.valueOf(15.0f), COLUMNS, 0);
        PdfPTable pdfPTable42 = new PdfPTable(COLUMNS);
        tableList.add(pdfPTable42);
        PdfUtil.addCellToTable(pdfPTable42, "\u786e\u8ba4\u65b9\u5f0f\uff1a" + this.getValueStr(queryPurchaseExecuteBillRspBO.getPurchaseExecuteBillBo().getConfirmDealTypeName()), contentFont, 0, 5, Float.valueOf(15.0f), COLUMNS, 0);
        PdfPTable pdfPTable41 = new PdfPTable(COLUMNS);
        tableList.add(pdfPTable41);
        PdfUtil.addCellToTable(pdfPTable41, "     " + EnquiryCommonUtil.getConfirmDealTypeTip(queryPurchaseExecuteBillRspBO.getPurchaseExecuteBillBo().getConfirmDealType()), contentFont, 0, 5, Float.valueOf(15.0f), COLUMNS, 0);
        PdfPTable titleTable5 = new PdfPTable(COLUMNS);
        tableList.add(titleTable5);
        PdfUtil.addCellToTable(titleTable5, "\u660e\u7ec6\u4fe1\u606f", contentFont, 1, 5, Float.valueOf(40.0f), COLUMNS, 0);
        PdfPTable pdfPTable10 = new PdfPTable(COLUMNS);
        tableList.add(pdfPTable10);
        PdfUtil.addCellToTable(pdfPTable10, null, contentFont, 0, 5, Float.valueOf(20.0f), COLUMNS, 0);
        if (CollUtil.isNotEmpty(purchaseExecuteItemBOList)) {
            PdfPTable pdfPTable6 = new PdfPTable(COLUMNS);
            tableList.add(pdfPTable6);
            PdfUtil.addCellToTable(pdfPTable6, "\u5e8f\u53f7", contentFont, 0, 5, Float.valueOf(40.0f), 1, null);
            PdfUtil.addCellToTable(pdfPTable6, "\u9700\u6c42\u660e\u7ec6\u7f16\u53f7", contentFont, 0, 5, Float.valueOf(40.0f), 3, null);
            PdfUtil.addCellToTable(pdfPTable6, "\u91c7\u8d2d\u7269\u9879\u901a\u7528\u540d\u79f0", contentFont, 0, 5, Float.valueOf(40.0f), 3, null);
            PdfUtil.addCellToTable(pdfPTable6, "\u7269\u6599\u5c0f\u7c7b", contentFont, 0, 5, Float.valueOf(40.0f), 3, null);
            PdfUtil.addCellToTable(pdfPTable6, "\u7269\u8d44\u7f16\u7801", contentFont, 0, 5, Float.valueOf(40.0f), 4, null);
            PdfUtil.addCellToTable(pdfPTable6, "\u89c4\u683c\u578b\u53f7", contentFont, 0, 5, Float.valueOf(40.0f), 3, null);
            PdfUtil.addCellToTable(pdfPTable6, "ECP\u9879\u76ee", contentFont, 0, 5, Float.valueOf(40.0f), 3, null);
            PdfUtil.addCellToTable(pdfPTable6, "\u6240\u5c5e\u8ba1\u5212", contentFont, 0, 5, Float.valueOf(40.0f), 3, null);
            PdfUtil.addCellToTable(pdfPTable6, "\u9700\u6c42\u5355\u4f4d", contentFont, 0, 5, Float.valueOf(40.0f), 3, null);
            PdfUtil.addCellToTable(pdfPTable6, "\u8ba1\u5212\u6765\u6e90", contentFont, 0, 5, Float.valueOf(40.0f), 3, null);
            PdfUtil.addCellToTable(pdfPTable6, "\u6570\u91cf", contentFont, 0, 5, Float.valueOf(40.0f), 2, null);
            PdfUtil.addCellToTable(pdfPTable6, "\u8ba1\u91cf\u5355\u4f4d", contentFont, 0, 5, Float.valueOf(40.0f), 2, null);
            PdfUtil.addCellToTable(pdfPTable6, "\u914d\u9001\u5730\u5740", contentFont, 0, 5, Float.valueOf(40.0f), 3, null);
            PdfUtil.addCellToTable(pdfPTable6, "\u8981\u6c42\u5230\u8d27\u65e5\u671f", contentFont, 0, 5, Float.valueOf(40.0f), 3, null);
            PdfUtil.addCellToTable(pdfPTable6, "\u6267\u884c\u6807\u51c6", contentFont, 0, 5, Float.valueOf(40.0f), 2, null);
            PdfUtil.addCellToTable(pdfPTable6, "\u63a8\u8350\u54c1\u724c/\u5236\u9020\u5546", contentFont, 0, 5, Float.valueOf(40.0f), 2, null);
            PdfUtil.addCellToTable(pdfPTable6, "\u5b89\u5168\u7b49\u7ea7", contentFont, 0, 5, Float.valueOf(40.0f), 2, null);
            PdfUtil.addCellToTable(pdfPTable6, "\u8d28\u4fdd\u7b49\u7ea7", contentFont, 0, 5, Float.valueOf(40.0f), 2, null);
            PdfUtil.addCellToTable(pdfPTable6, "\u7b2c\u4e09\u65b9\u68c0\u9a8c\u8bc1\u4e66", contentFont, 0, 5, Float.valueOf(40.0f), 2, null);
            PdfUtil.addCellToTable(pdfPTable6, "\u5305\u88c5\u65b9\u5f0f", contentFont, 0, 5, Float.valueOf(40.0f), 2, null);
            PdfUtil.addCellToTable(pdfPTable6, "\u914d\u5957\u670d\u52a1\uff08\u5b89\u88c5\u7b49\uff09", contentFont, 0, 5, Float.valueOf(40.0f), 2, null);
            PdfUtil.addCellToTable(pdfPTable6, "\u8d28\u4fdd\u5468\u671f", contentFont, 0, 5, Float.valueOf(40.0f), 2, null);
            PdfUtil.addCellToTable(pdfPTable6, "\u5176\u4ed6\u6280\u672f\u8981\u6c42", contentFont, 0, 5, Float.valueOf(40.0f), 2, null);
            if (!"2".equals(orgType)) {
                PdfUtil.addCellToTable(pdfPTable6, "\u5386\u53f2\u91c7\u8d2d\u5355\u4ef7", contentFont, 0, 5, Float.valueOf(40.0f), 2, null);
                PdfUtil.addCellToTable(pdfPTable6, "\u9884\u7b97\u91d1\u989d\uff08\u5143\uff09", contentFont, 0, 5, Float.valueOf(40.0f), 2, null);
            }
            PdfUtil.addCellToTable(pdfPTable6, "\u5907\u6ce8", contentFont, 0, 5, Float.valueOf(40.0f), 2, null);
            PdfUtil.addCellToTable(pdfPTable6, "\u53c2\u8003\u5546\u54c1\u7f16\u7801", contentFont, 0, 5, Float.valueOf(40.0f), 2, null);
            PdfUtil.addCellToTable(pdfPTable6, "\u6807\u51c6\u5e93\u76ee\u5f55\u540d\u79f0", contentFont, 0, 5, Float.valueOf(40.0f), 2, null);
            PdfUtil.addCellToTable(pdfPTable6, "\u6700\u9ad8\u9650\u4ef7", contentFont, 0, 5, Float.valueOf(40.0f), 2, null);
            PdfUtil.addCellToTable(pdfPTable6, "\u5b89\u5168\u5e93\u5b58", contentFont, 0, 5, Float.valueOf(40.0f), 2, null);
            PdfUtil.addCellToTable(pdfPTable6, "\u6700\u957f\u4ea4\u8d27\u5468\u671f\uff08\u5929\uff09", contentFont, 0, 5, Float.valueOf(40.0f), 2, null);
            PdfUtil.addCellToTable(pdfPTable6, "\u7269\u8d44\u7f16\u7801\u8ba1\u91cf\u5355\u4f4d", contentFont, 0, 5, Float.valueOf(40.0f), 2, null);
            PdfUtil.addCellToTable(pdfPTable6, "\u62a5\u4ef7\u6709\u6548\u671f", contentFont, 0, 5, Float.valueOf(40.0f), 3, null);
            PdfUtil.addCellToTable(pdfPTable6, "\u9644\u4ef6", contentFont, 0, 5, Float.valueOf(40.0f), 3, null);
            int count = 1;
            for (PurchaseExecuteItemBO totalBO : purchaseExecuteItemBOList) {
                if (totalBO.getProjectCode() == null) {
                    totalBO.setProjectCode("");
                }
                if (totalBO.getProjectName() == null) {
                    totalBO.setProjectName("");
                }
                PdfPTable pdfPTable7 = new PdfPTable(COLUMNS);
                tableList.add(pdfPTable7);
                PdfUtil.addCellToTable(pdfPTable7, String.valueOf(count), contentFont, 0, 5, Float.valueOf(100.0f), 1, null);
                PdfUtil.addCellToTable(pdfPTable7, this.getValueStr(totalBO.getJhmxbh()), contentFont, 0, 5, Float.valueOf(100.0f), 3, null);
                PdfUtil.addCellToTable(pdfPTable7, this.getValueStr(totalBO.getWlmc()), contentFont, 0, 5, Float.valueOf(100.0f), 3, null);
                PdfUtil.addCellToTable(pdfPTable7, this.getValueStr(totalBO.getWxfl() + "-" + totalBO.getWxflStr()), contentFont, 0, 5, Float.valueOf(100.0f), 3, null);
                PdfUtil.addCellToTable(pdfPTable7, this.getValueStr(totalBO.getWlbh() + "-" + totalBO.getWlbhStr()), contentFont, 0, 5, Float.valueOf(100.0f), 4, null);
                PdfUtil.addCellToTable(pdfPTable7, this.getValueStr(totalBO.getGgxh()), contentFont, 0, 5, Float.valueOf(100.0f), 3, null);
                PdfUtil.addCellToTable(pdfPTable7, this.getValueStr(totalBO.getProjectCode() + "-" + totalBO.getProjectName()), contentFont, 0, 5, Float.valueOf(100.0f), 3, null);
                PdfUtil.addCellToTable(pdfPTable7, this.getValueStr(totalBO.getZxlsjhbh() + "-" + totalBO.getJhmc()), contentFont, 0, 5, Float.valueOf(100.0f), 3, null);
                PdfUtil.addCellToTable(pdfPTable7, this.getValueStr(totalBO.getDemanderOrgName()), contentFont, 0, 5, Float.valueOf(100.0f), 3, null);
                PdfUtil.addCellToTable(pdfPTable7, this.getValueStr(totalBO.getJhlyName()), contentFont, 0, 5, Float.valueOf(100.0f), 3, null);
                PdfUtil.addCellToTable(pdfPTable7, this.getValueStr(totalBO.getSl()), contentFont, 0, 5, Float.valueOf(100.0f), 2, null);
                PdfUtil.addCellToTable(pdfPTable7, this.getValueStr(totalBO.getDw()), contentFont, 0, 5, Float.valueOf(100.0f), 2, null);
                PdfUtil.addCellToTable(pdfPTable7, this.getValueStr(totalBO.getDistributeAddress()), contentFont, 0, 5, Float.valueOf(100.0f), 3, null);
                PdfUtil.addCellToTable(pdfPTable7, this.getValueStr(totalBO.getYqdhrq()), contentFont, 0, 5, Float.valueOf(100.0f), 3, null);
                PdfUtil.addCellToTable(pdfPTable7, this.getValueStr(totalBO.getZxbz()), contentFont, 0, 5, Float.valueOf(100.0f), 2, null);
                PdfUtil.addCellToTable(pdfPTable7, this.getValueStr(totalBO.getZzsmc()), contentFont, 0, 5, Float.valueOf(100.0f), 2, null);
                PdfUtil.addCellToTable(pdfPTable7, this.getValueStr(totalBO.getAqdj()), contentFont, 0, 5, Float.valueOf(100.0f), 2, null);
                PdfUtil.addCellToTable(pdfPTable7, this.getValueStr(totalBO.getZbdj()), contentFont, 0, 5, Float.valueOf(100.0f), 2, null);
                PdfUtil.addCellToTable(pdfPTable7, this.getValueStr(totalBO.getDsfjczmName()), contentFont, 0, 5, Float.valueOf(100.0f), 2, null);
                PdfUtil.addCellToTable(pdfPTable7, this.getValueStr(totalBO.getBzfsName()), contentFont, 0, 5, Float.valueOf(100.0f), 2, null);
                PdfUtil.addCellToTable(pdfPTable7, this.getValueStr(totalBO.getPtfwName()), contentFont, 0, 5, Float.valueOf(100.0f), 2, null);
                PdfUtil.addCellToTable(pdfPTable7, this.getValueStr(totalBO.getZbzq()), contentFont, 0, 5, Float.valueOf(100.0f), 2, null);
                PdfUtil.addCellToTable(pdfPTable7, this.getValueStr(totalBO.getQtjsyq()), contentFont, 0, 5, Float.valueOf(100.0f), 2, null);
                if (!"2".equals(orgType)) {
                    PdfUtil.addCellToTable(pdfPTable7, this.getValueStr(totalBO.getLscgdj()), contentFont, 0, 5, Float.valueOf(100.0f), 2, null);
                    PdfUtil.addCellToTable(pdfPTable7, this.getValueStr(totalBO.getYsje()), contentFont, 0, 5, Float.valueOf(100.0f), 2, null);
                }
                PdfUtil.addCellToTable(pdfPTable7, this.getValueStr(totalBO.getBz()), contentFont, 0, 5, Float.valueOf(100.0f), 2, null);
                PdfUtil.addCellToTable(pdfPTable7, this.getValueStr(totalBO.getCkspbm()), contentFont, 0, 5, Float.valueOf(100.0f), 2, null);
                PdfUtil.addCellToTable(pdfPTable7, this.getValueStr(totalBO.getBzkmlmc()), contentFont, 0, 5, Float.valueOf(100.0f), 2, null);
                PdfUtil.addCellToTable(pdfPTable7, this.getValueStr(totalBO.getZgxj()), contentFont, 0, 5, Float.valueOf(100.0f), 2, null);
                PdfUtil.addCellToTable(pdfPTable7, this.getValueStr(totalBO.getAqkc()), contentFont, 0, 5, Float.valueOf(100.0f), 2, null);
                PdfUtil.addCellToTable(pdfPTable7, this.getValueStr(totalBO.getJhzq()), contentFont, 0, 5, Float.valueOf(100.0f), 2, null);
                PdfUtil.addCellToTable(pdfPTable7, this.getValueStr(totalBO.getWzbmjldw()), contentFont, 0, 5, Float.valueOf(100.0f), 2, null);
                PdfUtil.addCellToTable(pdfPTable7, this.getValueStr(totalBO.getQuotedEffTimeStr()), contentFont, 0, 5, Float.valueOf(100.0f), 3, null);
                PdfUtil.addCellToTable(pdfPTable7, "", contentFont, 0, 5, Float.valueOf(100.0f), 3, null);
                ++count;
            }
        }
        if (!"2".equals(orgType)) {
            PdfPTable pdfPTable8 = new PdfPTable(1);
            tableList.add(pdfPTable8);
            PdfUtil.addCellToTable(pdfPTable8, null, contentFont, 0, 5, Float.valueOf(20.0f), COLUMNS, 0);
            if (CollUtil.isNotEmpty((Collection)queryPurchaseExecuteBillRspBO.getExecuteSupJoinBo())) {
                PdfPTable pdfPTable9 = new PdfPTable(queryPurchaseExecuteBillRspBO.getExecuteSupJoinBo().size());
                tableList.add(pdfPTable9);
                PdfUtil.addCellToTable(pdfPTable9, "\u53c2\u4e0e\u8bae\u4ef7\u4f9b\u5e94\u5546\uff1a" + this.getValueStr(((ExecuteSupJoinBo)queryPurchaseExecuteBillRspBO.getExecuteSupJoinBo().get(0)).getSupplierName()), contentFont, 0, 5, Float.valueOf(15.0f), COLUMNS, 0);
                for (int i = 0; i < queryPurchaseExecuteBillRspBO.getExecuteSupJoinBo().size(); ++i) {
                    PdfUtil.addCellToTable(pdfPTable9, "               " + this.getValueStr(((ExecuteSupJoinBo)queryPurchaseExecuteBillRspBO.getExecuteSupJoinBo().get(i)).getSupplierName()), contentFont, 0, 5, Float.valueOf(15.0f), COLUMNS, 0);
                }
            }
        }
        PdfUtil.addTableListToDoc(document, tableList);
        document.close();
        byte[] pdfBytes = byteArrayOutputStream.toByteArray();
        ByteArrayInputStream inputStream = new ByteArrayInputStream(pdfBytes);
        String fileName = UUID.randomUUID().toString().replaceAll("-", "") + ".pdf";
        String path = this.fileClient.uploadFileByInputStream(PATH, fileName, (InputStream)inputStream);
        if (FILE_TYPE_OSS.equals(this.fileType)) {
            exportUrl = this.ossFileUrl + path;
        } else if (FILE_TYPE_FASTDFS.equals(this.fileType)) {
            FastdfsFileInfo fastdfsFileInfo = FastdfsFileInfo.toFastdfsFileInfo((String)path);
            exportUrl = this.fastdfsDownloadUrl + "/" + fastdfsFileInfo.getGroupName() + "/" + fastdfsFileInfo.getFileName();
        } else {
            throw new ZTBusinessException("\u6682\u4e0d\u652f\u6301\u7684\u6587\u4ef6\u670d\u52a1\u5668\u7c7b\u578b");
        }
        return exportUrl;
    }

    private String doBiddingExecutePdf(QueryPurchaseExecuteBillRspBO queryPurchaseExecuteBillRspBO, QueryPurchaseExecuteBillReqBO reqBO, List<PurchaseExecuteItemBO> purchaseExecuteItemBOList) {
        String exportUrl;
        BaseFont baseFont;
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        Document document = new Document(PageSize.A4.rotate(), -75.0f, -75.0f, 15.0f, 40.0f);
        PdfWriter pdfWriter = null;
        try {
            pdfWriter = PdfWriter.getInstance((Document)document, (OutputStream)byteArrayOutputStream);
        }
        catch (DocumentException e) {
            e.printStackTrace();
        }
        try {
            baseFont = BaseFont.createFont((String)"STSong-Light", (String)"UniGB-UCS2-H", (boolean)false);
        }
        catch (Exception e) {
            throw new BusinessException("0100", "\u5b9a\u4e49\u5b57\u4f53\u51fa\u9519", e);
        }
        Font titleFont = new Font(baseFont, 14.0f, 1);
        Font contentFont = new Font(baseFont, 8.0f, 0);
        int COLUMNS = 80;
        String orgType = reqBO.getIsProfessionalOrgExt();
        if ("2".equals(orgType)) {
            COLUMNS -= 4;
        }
        document.open();
        this.doAddTextWatermark(pdfWriter, reqBO.getName());
        LinkedList<PdfPTable> tableList = new LinkedList<PdfPTable>();
        PdfPTable titleTable = new PdfPTable(1);
        tableList.add(titleTable);
        PdfUtil.addCellToTable(titleTable, "\u7ade\u4ef7\u5355\u4fe1\u606f", titleFont, 1, 5, Float.valueOf(40.0f), 1, 0);
        PdfPTable pdfPTable1 = new PdfPTable(COLUMNS);
        tableList.add(pdfPTable1);
        PdfUtil.addCellToTable(pdfPTable1, "\u7ade\u4ef7\u5355\u7f16\u53f7\uff1a" + this.getValueStr(queryPurchaseExecuteBillRspBO.getPurchaseExecuteBillBo().getExecuteCode()), contentFont, 0, 5, Float.valueOf(15.0f), 26, 0);
        PdfUtil.addCellToTable(pdfPTable1, "\u7ade\u4ef7\u5355\u540d\u79f0\uff1a" + this.getValueStr(queryPurchaseExecuteBillRspBO.getPurchaseExecuteBillBo().getExecuteName()), contentFont, 0, 5, Float.valueOf(15.0f), 28, 0);
        PdfUtil.addCellToTable(pdfPTable1, "\u5355\u636e\u72b6\u6001\uff1a" + this.getValueStr(queryPurchaseExecuteBillRspBO.getPurchaseExecuteBillBo().getExecuteStatusName()), contentFont, 0, 5, Float.valueOf(15.0f), 26, 0);
        List projectNameList = queryPurchaseExecuteBillRspBO.getPurchaseExecuteBillBo().getProjectNameList();
        if (CollUtil.isNotEmpty((Collection)projectNameList)) {
            for (int i = 0; i < projectNameList.size(); ++i) {
                PdfPTable pdfPTable20;
                if (i == 0) {
                    pdfPTable20 = new PdfPTable(COLUMNS);
                    tableList.add(pdfPTable20);
                    PdfUtil.addCellToTable(pdfPTable20, "\u9879\u76ee\uff1a" + this.getValueStr(projectNameList.get(i)), contentFont, 0, 5, Float.valueOf(15.0f), COLUMNS, 0);
                    continue;
                }
                pdfPTable20 = new PdfPTable(COLUMNS);
                tableList.add(pdfPTable20);
                PdfUtil.addCellToTable(pdfPTable20, "             " + this.getValueStr(projectNameList.get(i)), contentFont, 0, 5, Float.valueOf(15.0f), COLUMNS, 0);
            }
        }
        PdfPTable pdfPTable20 = new PdfPTable(COLUMNS);
        tableList.add(pdfPTable20);
        PdfUtil.addCellToTable(pdfPTable20, "\u7ed3\u7b97\u5e01\u79cd\uff1a" + this.getValueStr(queryPurchaseExecuteBillRspBO.getPurchaseExecuteBillBo().getAccountCurrencyName()), contentFont, 0, 5, Float.valueOf(15.0f), 26, 0);
        PdfUtil.addCellToTable(pdfPTable20, "\u662f\u5426\u9700\u8981\u4fdd\u8bc1\u91d1\uff1a" + this.getValueStr(queryPurchaseExecuteBillRspBO.getPurchaseExecuteBillBo().getBondFlagName()), contentFont, 0, 5, Float.valueOf(15.0f), 28, 0);
        PdfUtil.addCellToTable(pdfPTable20, "\u6bcf\u6b21\u7ade\u4ef7\u62a5\u4ef7\u9012\u51cf\u91cf\uff1a" + this.getValueStr(queryPurchaseExecuteBillRspBO.getPurchaseExecuteBillBo().getBiddingDecreaseTypeName()), contentFont, 0, 5, Float.valueOf(15.0f), 26, 0);
        PdfPTable pdfPTable21 = new PdfPTable(COLUMNS);
        tableList.add(pdfPTable21);
        if (queryPurchaseExecuteBillRspBO.getPurchaseExecuteBillBo().getBiddingDecreaseType() != null && EnquiryConstant.BiddingDecreaseType.COMPARED_QUOTE_TYPE_2.intValue() == queryPurchaseExecuteBillRspBO.getPurchaseExecuteBillBo().getBiddingDecreaseType().intValue()) {
            PdfUtil.addCellToTable(pdfPTable21, "\u603b\u62a5\u4ef7/\u5355\u9879\u62a5\u4ef7\u5fc5\u987b\u6bd4\uff1a" + this.getValueStr(queryPurchaseExecuteBillRspBO.getPurchaseExecuteBillBo().getBiddingDecreaseMethodName()) + "\u4f4e" + this.getValueStr(queryPurchaseExecuteBillRspBO.getPurchaseExecuteBillBo().getBiddingDecrease()) + "\u5143", contentFont, 0, 5, Float.valueOf(15.0f), 26, 0);
        } else {
            PdfUtil.addCellToTable(pdfPTable21, "\u603b\u62a5\u4ef7/\u5355\u9879\u62a5\u4ef7\u5fc5\u987b\u6bd4\uff1a" + this.getValueStr(queryPurchaseExecuteBillRspBO.getPurchaseExecuteBillBo().getBiddingDecreaseMethodName()) + "\u4f4e" + this.getValueStr(queryPurchaseExecuteBillRspBO.getPurchaseExecuteBillBo().getBiddingDecrease()) + "%", contentFont, 0, 5, Float.valueOf(15.0f), 26, 0);
        }
        PdfUtil.addCellToTable(pdfPTable21, "\u662f\u5426\u542f\u7528\u5ef6\u65f6\u7ade\u4ef7\u89c4\u5219\uff1a" + this.getValueStr(queryPurchaseExecuteBillRspBO.getPurchaseExecuteBillBo().getTimeDelayFlagName()), contentFont, 0, 5, Float.valueOf(15.0f), 28, 0);
        PdfUtil.addCellToTable(pdfPTable21, "\u7ade\u4ef7\u6d3b\u52a8\u6700\u5c11\u62a5\u4ef7\u5bb6\u6570\uff1a" + this.getValueStr(queryPurchaseExecuteBillRspBO.getPurchaseExecuteBillBo().getLeastQuoteNumber()), contentFont, 0, 5, Float.valueOf(15.0f), 26, 0);
        PdfPTable pdfPTable22 = new PdfPTable(COLUMNS);
        tableList.add(pdfPTable22);
        PdfUtil.addCellToTable(pdfPTable22, "\u8bf4\u660e\uff1a" + this.getValueStr(queryPurchaseExecuteBillRspBO.getPurchaseExecuteBillBo().getRemarks()), contentFont, 0, 5, Float.valueOf(15.0f), 26, 0);
        PdfPTable pdfPTable23 = new PdfPTable(COLUMNS);
        tableList.add(pdfPTable23);
        if ("2001".equals(queryPurchaseExecuteBillRspBO.getPurchaseExecuteBillBo().getExecuteStatus()) || "2002".equals(queryPurchaseExecuteBillRspBO.getPurchaseExecuteBillBo().getExecuteStatus()) || "2011".equals(queryPurchaseExecuteBillRspBO.getPurchaseExecuteBillBo().getExecuteStatus())) {
            PdfUtil.addCellToTable(pdfPTable23, "\u62a5\u4ef7\u65f6\u95f4\u8981\u6c42\uff1a\u5ba1\u6279\u5b8c\u6210\u540e" + this.getValueStr(queryPurchaseExecuteBillRspBO.getPurchaseExecuteBillBo().getQuoteTimeDaysAppr()) + "\u5929" + queryPurchaseExecuteBillRspBO.getPurchaseExecuteBillBo().getQuoteTimeAppr() + ";\u5f00\u59cb\u540e" + queryPurchaseExecuteBillRspBO.getPurchaseExecuteBillBo().getQuoteTimeDays() + "\u5929" + queryPurchaseExecuteBillRspBO.getPurchaseExecuteBillBo().getQuoteTime() + "\u7ed3\u675f\uff1b\u6301\u7eed\u65f6\u95f4\uff1a" + queryPurchaseExecuteBillRspBO.getPurchaseExecuteBillBo().getQuoteTimeLong() + "\uff1b\u4eca\u65e5\u5ba1\u6279\u5b8c\u6210\uff0c\u9884\u8ba1\u62a5\u4ef7\u65f6\u95f4\u4e3a" + this.getValueStr(queryPurchaseExecuteBillRspBO.getPurchaseExecuteBillBo().getQuoteStartTime()) + " \u81f3 " + this.getValueStr(queryPurchaseExecuteBillRspBO.getPurchaseExecuteBillBo().getQuoteEndTime()), contentFont, 0, 5, Float.valueOf(15.0f), COLUMNS, 0);
        } else {
            PdfUtil.addCellToTable(pdfPTable23, "\u62a5\u4ef7\u65f6\u95f4\u8981\u6c42\uff1a" + this.getValueStr(queryPurchaseExecuteBillRspBO.getPurchaseExecuteBillBo().getQuoteStartTime()) + " \u81f3 " + this.getValueStr(queryPurchaseExecuteBillRspBO.getPurchaseExecuteBillBo().getQuoteEndTime()), contentFont, 0, 5, Float.valueOf(15.0f), COLUMNS, 0);
        }
        PdfPTable pdfPTable3 = new PdfPTable(COLUMNS);
        tableList.add(pdfPTable3);
        PdfUtil.addCellToTable(pdfPTable3, "\u4f9b\u5e94\u5546\u4e0a\u67b6\u5468\u671f\uff08\u5929\uff09\uff1a" + this.getValueStr(queryPurchaseExecuteBillRspBO.getPurchaseExecuteBillBo().getPutShelfDays()), contentFont, 0, 5, Float.valueOf(15.0f), COLUMNS, 0);
        PdfPTable pdfPTable31 = new PdfPTable(COLUMNS);
        tableList.add(pdfPTable31);
        PdfUtil.addCellToTable(pdfPTable31, "           \u63d0\u793a\uff1a\u751f\u6210\u6210\u4ea4\u901a\u77e5\u548c\u540e\u4f9b\u5e94\u5546\u9700\u5728\u6b64\u65f6\u95f4\u5185\u5b8c\u6210\u5546\u54c1\u5339\u914d\u6ca1\u5426\u5219\u9700\u91cd\u65b0\u9009\u5b9a\u4f9b\u5e94\u5546", contentFont, 0, 5, Float.valueOf(15.0f), COLUMNS, 0);
        PdfPTable pdfPTable4 = new PdfPTable(COLUMNS);
        tableList.add(pdfPTable4);
        PdfUtil.addCellToTable(pdfPTable4, "\u786e\u8ba4\u65b9\u5f0f\uff1a" + this.getValueStr(queryPurchaseExecuteBillRspBO.getPurchaseExecuteBillBo().getConfirmDealTypeName()), contentFont, 0, 5, Float.valueOf(15.0f), COLUMNS, 0);
        PdfPTable pdfPTable41 = new PdfPTable(COLUMNS);
        tableList.add(pdfPTable41);
        PdfUtil.addCellToTable(pdfPTable41, "     " + EnquiryCommonUtil.getConfirmDealTypeTip(queryPurchaseExecuteBillRspBO.getPurchaseExecuteBillBo().getConfirmDealType()), contentFont, 0, 5, Float.valueOf(15.0f), COLUMNS, 0);
        PdfPTable pdfPTable42 = new PdfPTable(COLUMNS);
        tableList.add(pdfPTable42);
        PdfUtil.addCellToTable(pdfPTable42, "\u6e29\u99a8\u63d0\u793a\uff1a\u7ade\u4ef7\u62a5\u4ef7\u65f6\u95f4\u7ed3\u675f\u524d5\u5206\u949f\u5185\u6709\u4f9b\u5e94\u5546\u8fdb\u884c\u518d\u6b21\u62a5\u4ef7\uff0c\u5219\u7ade\u4ef7\u7ed3\u675f\u65f6\u95f4\u81ea\u52a8\u5ef6\u8fdf\u4e94\u5206\u949f\u7ed3\u675f", contentFont, 0, 5, Float.valueOf(15.0f), COLUMNS, 0);
        PdfPTable titleTable5 = new PdfPTable(COLUMNS);
        tableList.add(titleTable5);
        PdfUtil.addCellToTable(titleTable5, "\u660e\u7ec6\u4fe1\u606f", contentFont, 1, 5, Float.valueOf(40.0f), COLUMNS, 0);
        PdfPTable pdfPTable10 = new PdfPTable(COLUMNS);
        tableList.add(pdfPTable10);
        PdfUtil.addCellToTable(pdfPTable10, null, contentFont, 0, 5, Float.valueOf(20.0f), COLUMNS, 0);
        if (CollUtil.isNotEmpty(purchaseExecuteItemBOList)) {
            PdfPTable pdfPTable6 = new PdfPTable(COLUMNS);
            tableList.add(pdfPTable6);
            PdfUtil.addCellToTable(pdfPTable6, "\u5e8f\u53f7", contentFont, 0, 5, Float.valueOf(40.0f), 1, null);
            PdfUtil.addCellToTable(pdfPTable6, "\u9700\u6c42\u660e\u7ec6\u7f16\u53f7", contentFont, 0, 5, Float.valueOf(40.0f), 3, null);
            PdfUtil.addCellToTable(pdfPTable6, "\u91c7\u8d2d\u7269\u9879\u901a\u7528\u540d\u79f0", contentFont, 0, 5, Float.valueOf(40.0f), 3, null);
            PdfUtil.addCellToTable(pdfPTable6, "\u7269\u6599\u5c0f\u7c7b", contentFont, 0, 5, Float.valueOf(40.0f), 3, null);
            PdfUtil.addCellToTable(pdfPTable6, "\u7269\u8d44\u7f16\u7801", contentFont, 0, 5, Float.valueOf(40.0f), 4, null);
            PdfUtil.addCellToTable(pdfPTable6, "\u89c4\u683c\u578b\u53f7", contentFont, 0, 5, Float.valueOf(40.0f), 3, null);
            PdfUtil.addCellToTable(pdfPTable6, "ECP\u9879\u76ee", contentFont, 0, 5, Float.valueOf(40.0f), 3, null);
            PdfUtil.addCellToTable(pdfPTable6, "\u6240\u5c5e\u8ba1\u5212", contentFont, 0, 5, Float.valueOf(40.0f), 3, null);
            PdfUtil.addCellToTable(pdfPTable6, "\u9700\u6c42\u5355\u4f4d", contentFont, 0, 5, Float.valueOf(40.0f), 3, null);
            PdfUtil.addCellToTable(pdfPTable6, "\u8ba1\u5212\u6765\u6e90", contentFont, 0, 5, Float.valueOf(40.0f), 3, null);
            PdfUtil.addCellToTable(pdfPTable6, "\u6570\u91cf", contentFont, 0, 5, Float.valueOf(40.0f), 2, null);
            PdfUtil.addCellToTable(pdfPTable6, "\u8ba1\u91cf\u5355\u4f4d", contentFont, 0, 5, Float.valueOf(40.0f), 2, null);
            PdfUtil.addCellToTable(pdfPTable6, "\u914d\u9001\u5730\u5740", contentFont, 0, 5, Float.valueOf(40.0f), 3, null);
            PdfUtil.addCellToTable(pdfPTable6, "\u8981\u6c42\u5230\u8d27\u65e5\u671f", contentFont, 0, 5, Float.valueOf(40.0f), 3, null);
            PdfUtil.addCellToTable(pdfPTable6, "\u6267\u884c\u6807\u51c6", contentFont, 0, 5, Float.valueOf(40.0f), 2, null);
            PdfUtil.addCellToTable(pdfPTable6, "\u63a8\u8350\u54c1\u724c/\u5236\u9020\u5546", contentFont, 0, 5, Float.valueOf(40.0f), 2, null);
            PdfUtil.addCellToTable(pdfPTable6, "\u5b89\u5168\u7b49\u7ea7", contentFont, 0, 5, Float.valueOf(40.0f), 2, null);
            PdfUtil.addCellToTable(pdfPTable6, "\u8d28\u4fdd\u7b49\u7ea7", contentFont, 0, 5, Float.valueOf(40.0f), 2, null);
            PdfUtil.addCellToTable(pdfPTable6, "\u7b2c\u4e09\u65b9\u68c0\u9a8c\u8bc1\u4e66", contentFont, 0, 5, Float.valueOf(40.0f), 2, null);
            PdfUtil.addCellToTable(pdfPTable6, "\u5305\u88c5\u65b9\u5f0f", contentFont, 0, 5, Float.valueOf(40.0f), 2, null);
            PdfUtil.addCellToTable(pdfPTable6, "\u914d\u5957\u670d\u52a1\uff08\u5b89\u88c5\u7b49\uff09", contentFont, 0, 5, Float.valueOf(40.0f), 2, null);
            PdfUtil.addCellToTable(pdfPTable6, "\u8d28\u4fdd\u5468\u671f", contentFont, 0, 5, Float.valueOf(40.0f), 2, null);
            PdfUtil.addCellToTable(pdfPTable6, "\u5176\u4ed6\u6280\u672f\u8981\u6c42", contentFont, 0, 5, Float.valueOf(40.0f), 2, null);
            if (!"2".equals(orgType)) {
                PdfUtil.addCellToTable(pdfPTable6, "\u5386\u53f2\u91c7\u8d2d\u5355\u4ef7", contentFont, 0, 5, Float.valueOf(40.0f), 2, null);
                PdfUtil.addCellToTable(pdfPTable6, "\u9884\u7b97\u91d1\u989d\uff08\u5143\uff09", contentFont, 0, 5, Float.valueOf(40.0f), 2, null);
            }
            PdfUtil.addCellToTable(pdfPTable6, "\u5907\u6ce8", contentFont, 0, 5, Float.valueOf(40.0f), 2, null);
            PdfUtil.addCellToTable(pdfPTable6, "\u53c2\u8003\u5546\u54c1\u7f16\u7801", contentFont, 0, 5, Float.valueOf(40.0f), 2, null);
            PdfUtil.addCellToTable(pdfPTable6, "\u6807\u51c6\u5e93\u76ee\u5f55\u540d\u79f0", contentFont, 0, 5, Float.valueOf(40.0f), 2, null);
            PdfUtil.addCellToTable(pdfPTable6, "\u6700\u9ad8\u9650\u4ef7", contentFont, 0, 5, Float.valueOf(40.0f), 2, null);
            PdfUtil.addCellToTable(pdfPTable6, "\u5b89\u5168\u5e93\u5b58", contentFont, 0, 5, Float.valueOf(40.0f), 2, null);
            PdfUtil.addCellToTable(pdfPTable6, "\u6700\u957f\u4ea4\u8d27\u5468\u671f\uff08\u5929\uff09", contentFont, 0, 5, Float.valueOf(40.0f), 2, null);
            PdfUtil.addCellToTable(pdfPTable6, "\u7269\u8d44\u7f16\u7801\u8ba1\u91cf\u5355\u4f4d", contentFont, 0, 5, Float.valueOf(40.0f), 2, null);
            PdfUtil.addCellToTable(pdfPTable6, "\u62a5\u4ef7\u6709\u6548\u671f", contentFont, 0, 5, Float.valueOf(40.0f), 3, null);
            PdfUtil.addCellToTable(pdfPTable6, "\u9644\u4ef6", contentFont, 0, 5, Float.valueOf(40.0f), 3, null);
            int count = 1;
            for (PurchaseExecuteItemBO totalBO : purchaseExecuteItemBOList) {
                if (totalBO.getProjectCode() == null) {
                    totalBO.setProjectCode("");
                }
                if (totalBO.getProjectName() == null) {
                    totalBO.setProjectName("");
                }
                PdfPTable pdfPTable7 = new PdfPTable(COLUMNS);
                tableList.add(pdfPTable7);
                PdfUtil.addCellToTable(pdfPTable7, String.valueOf(count), contentFont, 0, 5, Float.valueOf(100.0f), 1, null);
                PdfUtil.addCellToTable(pdfPTable7, this.getValueStr(totalBO.getJhmxbh()), contentFont, 0, 5, Float.valueOf(100.0f), 3, null);
                PdfUtil.addCellToTable(pdfPTable7, this.getValueStr(totalBO.getWlmc()), contentFont, 0, 5, Float.valueOf(100.0f), 3, null);
                PdfUtil.addCellToTable(pdfPTable7, this.getValueStr(totalBO.getWxfl() + "-" + totalBO.getWxflStr()), contentFont, 0, 5, Float.valueOf(100.0f), 3, null);
                PdfUtil.addCellToTable(pdfPTable7, this.getValueStr(totalBO.getWlbh() + "-" + totalBO.getWlbhStr()), contentFont, 0, 5, Float.valueOf(100.0f), 4, null);
                PdfUtil.addCellToTable(pdfPTable7, this.getValueStr(totalBO.getGgxh()), contentFont, 0, 5, Float.valueOf(100.0f), 3, null);
                PdfUtil.addCellToTable(pdfPTable7, this.getValueStr(totalBO.getProjectCode() + "-" + totalBO.getProjectName()), contentFont, 0, 5, Float.valueOf(100.0f), 3, null);
                PdfUtil.addCellToTable(pdfPTable7, this.getValueStr(totalBO.getZxlsjhbh() + "-" + totalBO.getJhmc()), contentFont, 0, 5, Float.valueOf(100.0f), 3, null);
                PdfUtil.addCellToTable(pdfPTable7, this.getValueStr(totalBO.getDemanderOrgName()), contentFont, 0, 5, Float.valueOf(100.0f), 3, null);
                PdfUtil.addCellToTable(pdfPTable7, this.getValueStr(totalBO.getJhlyName()), contentFont, 0, 5, Float.valueOf(100.0f), 3, null);
                PdfUtil.addCellToTable(pdfPTable7, this.getValueStr(totalBO.getSl()), contentFont, 0, 5, Float.valueOf(100.0f), 2, null);
                PdfUtil.addCellToTable(pdfPTable7, this.getValueStr(totalBO.getDw()), contentFont, 0, 5, Float.valueOf(100.0f), 2, null);
                PdfUtil.addCellToTable(pdfPTable7, this.getValueStr(totalBO.getDistributeAddress()), contentFont, 0, 5, Float.valueOf(100.0f), 3, null);
                PdfUtil.addCellToTable(pdfPTable7, this.getValueStr(totalBO.getYqdhrq()), contentFont, 0, 5, Float.valueOf(100.0f), 3, null);
                PdfUtil.addCellToTable(pdfPTable7, this.getValueStr(totalBO.getZxbz()), contentFont, 0, 5, Float.valueOf(100.0f), 2, null);
                PdfUtil.addCellToTable(pdfPTable7, this.getValueStr(totalBO.getZzsmc()), contentFont, 0, 5, Float.valueOf(100.0f), 2, null);
                PdfUtil.addCellToTable(pdfPTable7, this.getValueStr(totalBO.getAqdj()), contentFont, 0, 5, Float.valueOf(100.0f), 2, null);
                PdfUtil.addCellToTable(pdfPTable7, this.getValueStr(totalBO.getZbdj()), contentFont, 0, 5, Float.valueOf(100.0f), 2, null);
                PdfUtil.addCellToTable(pdfPTable7, this.getValueStr(totalBO.getDsfjczmName()), contentFont, 0, 5, Float.valueOf(100.0f), 2, null);
                PdfUtil.addCellToTable(pdfPTable7, this.getValueStr(totalBO.getBzfsName()), contentFont, 0, 5, Float.valueOf(100.0f), 2, null);
                PdfUtil.addCellToTable(pdfPTable7, this.getValueStr(totalBO.getPtfwName()), contentFont, 0, 5, Float.valueOf(100.0f), 2, null);
                PdfUtil.addCellToTable(pdfPTable7, this.getValueStr(totalBO.getZbzq()), contentFont, 0, 5, Float.valueOf(100.0f), 2, null);
                PdfUtil.addCellToTable(pdfPTable7, this.getValueStr(totalBO.getQtjsyq()), contentFont, 0, 5, Float.valueOf(100.0f), 2, null);
                if (!"2".equals(orgType)) {
                    PdfUtil.addCellToTable(pdfPTable7, this.getValueStr(totalBO.getLscgdj()), contentFont, 0, 5, Float.valueOf(100.0f), 2, null);
                    PdfUtil.addCellToTable(pdfPTable7, this.getValueStr(totalBO.getYsje()), contentFont, 0, 5, Float.valueOf(100.0f), 2, null);
                }
                PdfUtil.addCellToTable(pdfPTable7, this.getValueStr(totalBO.getBz()), contentFont, 0, 5, Float.valueOf(100.0f), 2, null);
                PdfUtil.addCellToTable(pdfPTable7, this.getValueStr(totalBO.getCkspbm()), contentFont, 0, 5, Float.valueOf(100.0f), 2, null);
                PdfUtil.addCellToTable(pdfPTable7, this.getValueStr(totalBO.getBzkmlmc()), contentFont, 0, 5, Float.valueOf(100.0f), 2, null);
                PdfUtil.addCellToTable(pdfPTable7, this.getValueStr(totalBO.getZgxj()), contentFont, 0, 5, Float.valueOf(100.0f), 2, null);
                PdfUtil.addCellToTable(pdfPTable7, this.getValueStr(totalBO.getAqkc()), contentFont, 0, 5, Float.valueOf(100.0f), 2, null);
                PdfUtil.addCellToTable(pdfPTable7, this.getValueStr(totalBO.getJhzq()), contentFont, 0, 5, Float.valueOf(100.0f), 2, null);
                PdfUtil.addCellToTable(pdfPTable7, this.getValueStr(totalBO.getWzbmjldw()), contentFont, 0, 5, Float.valueOf(100.0f), 2, null);
                PdfUtil.addCellToTable(pdfPTable7, this.getValueStr(totalBO.getQuotedEffTimeStr()), contentFont, 0, 5, Float.valueOf(100.0f), 3, null);
                PdfUtil.addCellToTable(pdfPTable7, "", contentFont, 0, 5, Float.valueOf(100.0f), 3, null);
                ++count;
            }
        }
        PdfPTable titleTable81 = new PdfPTable(COLUMNS);
        tableList.add(titleTable81);
        PdfUtil.addCellToTable(titleTable81, "\u7ade\u4ef7\u8d77\u59cb\u4ef7\u683c\uff08\u5143\uff09", contentFont, 0, 5, Float.valueOf(40.0f), COLUMNS, 0);
        if (CollUtil.isNotEmpty((Collection)queryPurchaseExecuteBillRspBO.getPurchaseExecutePackBo())) {
            for (int i = 0; i < queryPurchaseExecuteBillRspBO.getPurchaseExecutePackBo().size(); ++i) {
                PdfPTable pdfPTable91 = new PdfPTable(COLUMNS);
                tableList.add(pdfPTable91);
                PdfUtil.addCellToTable(pdfPTable91, "                       " + this.getValueStr(((PurchaseExecutePackBo)queryPurchaseExecuteBillRspBO.getPurchaseExecutePackBo().get(i)).getPackCode()) + "\uff1a" + this.getValueStr(((PurchaseExecutePackBo)queryPurchaseExecuteBillRspBO.getPurchaseExecutePackBo().get(i)).getPackBudgetMoney()), contentFont, 0, 5, Float.valueOf(15.0f), COLUMNS, 0);
            }
        }
        if (!"2".equals(orgType)) {
            PdfPTable pdfPTable8 = new PdfPTable(1);
            tableList.add(pdfPTable8);
            PdfUtil.addCellToTable(pdfPTable8, null, contentFont, 0, 5, Float.valueOf(20.0f), COLUMNS, 0);
            if (CollUtil.isNotEmpty((Collection)queryPurchaseExecuteBillRspBO.getExecuteSupJoinBo())) {
                PdfPTable pdfPTable9 = new PdfPTable(COLUMNS);
                tableList.add(pdfPTable9);
                PdfUtil.addCellToTable(pdfPTable9, "\u53c2\u4e0e\u8bae\u4ef7\u4f9b\u5e94\u5546\uff1a" + this.getValueStr(((ExecuteSupJoinBo)queryPurchaseExecuteBillRspBO.getExecuteSupJoinBo().get(0)).getSupplierName()), contentFont, 0, 5, Float.valueOf(15.0f), COLUMNS, 0);
                for (int i = 0; i < queryPurchaseExecuteBillRspBO.getExecuteSupJoinBo().size(); ++i) {
                    PdfUtil.addCellToTable(pdfPTable9, "                       " + this.getValueStr(((ExecuteSupJoinBo)queryPurchaseExecuteBillRspBO.getExecuteSupJoinBo().get(i)).getSupplierName()), contentFont, 0, 5, Float.valueOf(15.0f), COLUMNS, 0);
                }
            }
        }
        PdfUtil.addTableListToDoc(document, tableList);
        document.close();
        byte[] pdfBytes = byteArrayOutputStream.toByteArray();
        ByteArrayInputStream inputStream = new ByteArrayInputStream(pdfBytes);
        String fileName = UUID.randomUUID().toString().replaceAll("-", "") + ".pdf";
        String path = this.fileClient.uploadFileByInputStream(PATH, fileName, (InputStream)inputStream);
        if (FILE_TYPE_OSS.equals(this.fileType)) {
            exportUrl = this.ossFileUrl + path;
        } else if (FILE_TYPE_FASTDFS.equals(this.fileType)) {
            FastdfsFileInfo fastdfsFileInfo = FastdfsFileInfo.toFastdfsFileInfo((String)path);
            exportUrl = this.fastdfsDownloadUrl + "/" + fastdfsFileInfo.getGroupName() + "/" + fastdfsFileInfo.getFileName();
        } else {
            throw new ZTBusinessException("\u6682\u4e0d\u652f\u6301\u7684\u6587\u4ef6\u670d\u52a1\u5668\u7c7b\u578b");
        }
        return exportUrl;
    }

    @PostMapping(value={"printPurchaseExecuteBillQueryPdf"})
    public QueryPurchaseExecuteBillRspBO printPurchaseExecuteBillQueryPdf(@RequestBody QueryPurchaseExecuteBillReqBO reqBO) {
        QueryPurchaseExecuteBillRspBO queryPurchaseExecuteBillRspBO = this.purchaseExecuteBillQueryBusiService.queryPurchaseExecuteBill(reqBO);
        if ("2001".equals(queryPurchaseExecuteBillRspBO.getPurchaseExecuteBillBo().getExecuteStatus()) || "2002".equals(queryPurchaseExecuteBillRspBO.getPurchaseExecuteBillBo().getExecuteStatus()) || "2011".equals(queryPurchaseExecuteBillRspBO.getPurchaseExecuteBillBo().getExecuteStatus())) {
            try {
                GregorianCalendar quoteStartTimeCal;
                Date quoteStartTime = new Date();
                Date quoteEndTime = new Date();
                if (queryPurchaseExecuteBillRspBO.getPurchaseExecuteBillBo().getQuoteTimeDaysAppr() != null) {
                    quoteStartTimeCal = new GregorianCalendar();
                    quoteStartTimeCal.setTime(quoteStartTime);
                    ((Calendar)quoteStartTimeCal).add(5, queryPurchaseExecuteBillRspBO.getPurchaseExecuteBillBo().getQuoteTimeDaysAppr());
                    quoteStartTime = quoteStartTimeCal.getTime();
                }
                if (queryPurchaseExecuteBillRspBO.getPurchaseExecuteBillBo().getQuoteTimeAppr() != null) {
                    SimpleDateFormat quoteStartTimeFormat = new SimpleDateFormat("yyyy-MM-dd");
                    SimpleDateFormat quoteStartTimeStrFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
                    String quoteStartTimeStr = quoteStartTimeFormat.format(quoteStartTime);
                    quoteStartTimeStr = quoteStartTimeStr + " " + queryPurchaseExecuteBillRspBO.getPurchaseExecuteBillBo().getQuoteTimeAppr();
                    quoteStartTime = quoteStartTimeStrFormat.parse(quoteStartTimeStr);
                }
                if (queryPurchaseExecuteBillRspBO.getPurchaseExecuteBillBo().getQuoteTimeDays() != null) {
                    quoteStartTimeCal = new GregorianCalendar();
                    quoteStartTimeCal.setTime(quoteStartTime);
                    ((Calendar)quoteStartTimeCal).add(5, queryPurchaseExecuteBillRspBO.getPurchaseExecuteBillBo().getQuoteTimeDays());
                    quoteEndTime = quoteStartTimeCal.getTime();
                }
                long time = quoteEndTime.getTime() - quoteStartTime.getTime();
                long hour = time / 3600000L;
                long min = time / 60000L - hour * 60L;
                long s = time / 1000L - hour * 60L * 60L - min * 60L;
                queryPurchaseExecuteBillRspBO.getPurchaseExecuteBillBo().setQuoteTimeLong(hour + "\u5c0f\u65f6" + min + "\u5206" + s + "\u79d2");
                queryPurchaseExecuteBillRspBO.getPurchaseExecuteBillBo().setQuoteStartTime(quoteStartTime);
                queryPurchaseExecuteBillRspBO.getPurchaseExecuteBillBo().setQuoteEndTime(quoteEndTime);
            }
            catch (ParseException e) {
                log.error("\u65f6\u95f4\u683c\u5f0f\u8f6c\u6362\u9519\u8bef");
            }
        }
        EnquiryDealConfirmReqBO enquiryReqBO = new EnquiryDealConfirmReqBO();
        BeanUtils.copyProperties((Object)reqBO, (Object)enquiryReqBO);
        enquiryReqBO.setExecuteId(reqBO.getExecuteId());
        enquiryReqBO.setPlanItemId(reqBO.getPlanItemId());
        enquiryReqBO.setPlanId(reqBO.getPlanId());
        EnquiryDealConfirmItemPageRspBO enquiryRspBO = this.enquiryDealConfirmAbilityService.queryDealConfirmItemList(enquiryReqBO);
        ArrayList<ExecuteQuotePlanItemBo> qryQuotationItemList = new ArrayList<ExecuteQuotePlanItemBo>();
        QryQuotationItemListByPageReqBO quoteItemReqBO = new QryQuotationItemListByPageReqBO();
        quoteItemReqBO.setExecuteId(reqBO.getExecuteId());
        enquiryReqBO.setPlanItemId(reqBO.getPlanItemId());
        enquiryReqBO.setPlanId(reqBO.getPlanId());
        quoteItemReqBO.setPageNo(Integer.valueOf(1));
        quoteItemReqBO.setPageSize(Integer.valueOf(2000));
        QryQuotationItemListByPageRspBO qryQuotationItemListByPageRspBO = this.qryQuotationItemListByPageBusiService.qryQuotationItemListByPage(quoteItemReqBO);
        if (qryQuotationItemListByPageRspBO != null && qryQuotationItemListByPageRspBO.getRows() != null) {
            qryQuotationItemList.addAll(qryQuotationItemListByPageRspBO.getRows());
        }
        if (qryQuotationItemListByPageRspBO != null && qryQuotationItemListByPageRspBO.getTotal() != null && qryQuotationItemListByPageRspBO.getTotal() > 1) {
            for (int i = 2; i < qryQuotationItemListByPageRspBO.getTotal(); ++i) {
                quoteItemReqBO.setPageNo(Integer.valueOf(2));
                qryQuotationItemListByPageRspBO = this.qryQuotationItemListByPageBusiService.qryQuotationItemListByPage(quoteItemReqBO);
                if (qryQuotationItemListByPageRspBO == null || qryQuotationItemListByPageRspBO.getRows() == null) continue;
                qryQuotationItemList.addAll(qryQuotationItemListByPageRspBO.getRows());
            }
        }
        BaseAllOperLogQueryBO operLogReqBO = new BaseAllOperLogQueryBO();
        operLogReqBO.setRelateId(reqBO.getExecuteId());
        operLogReqBO.setPlanItemId(reqBO.getPlanItemId());
        operLogReqBO.setPlanId(reqBO.getPlanId());
        operLogReqBO.setPageNo(Integer.valueOf(-1));
        BaseAllOperLogPageRspBO baseAllOperLogPageRspBO = this.baseAllOperLogBusiService.queryPurchaseExecuteOperLog(operLogReqBO);
        String url = "";
        url = "1".equals(queryPurchaseExecuteBillRspBO.getPurchaseExecuteBillBo().getExecuteType()) ? this.doPurchaseExecuteQueryPdf(queryPurchaseExecuteBillRspBO, reqBO, enquiryRspBO.getRows(), qryQuotationItemList, baseAllOperLogPageRspBO.getRows()) : this.doBiddingExecuteQueryPdf(queryPurchaseExecuteBillRspBO, reqBO, enquiryRspBO.getRows(), qryQuotationItemList, baseAllOperLogPageRspBO.getRows());
        queryPurchaseExecuteBillRspBO.setPdfUrl(url);
        return queryPurchaseExecuteBillRspBO;
    }

    private String doPurchaseExecuteQueryPdf(QueryPurchaseExecuteBillRspBO queryPurchaseExecuteBillRspBO, QueryPurchaseExecuteBillReqBO reqBO, List<EnquiryExecuteQuotePlanItemBO> executeQuotePlanItemBOList, List<ExecuteQuotePlanItemBo> executeQuotePlanItemBoList, List<BaseAllOperLogBO> list) {
        String exportUrl;
        BaseFont baseFont;
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        Document document = new Document(PageSize.A4.rotate(), -75.0f, -75.0f, 15.0f, 40.0f);
        PdfWriter pdfWriter = null;
        try {
            pdfWriter = PdfWriter.getInstance((Document)document, (OutputStream)byteArrayOutputStream);
        }
        catch (DocumentException e) {
            e.printStackTrace();
        }
        try {
            baseFont = BaseFont.createFont((String)"STSong-Light", (String)"UniGB-UCS2-H", (boolean)false);
        }
        catch (Exception e) {
            throw new BusinessException("0100", "\u5b9a\u4e49\u5b57\u4f53\u51fa\u9519", e);
        }
        Font titleFont = new Font(baseFont, 14.0f, 1);
        Font contentFont = new Font(baseFont, 8.0f, 0);
        int COLUMNS = 80;
        document.open();
        this.doAddTextWatermark(pdfWriter, reqBO.getName());
        LinkedList<PdfPTable> tableList = new LinkedList<PdfPTable>();
        PdfPTable titleTable = new PdfPTable(1);
        tableList.add(titleTable);
        PdfUtil.addCellToTable(titleTable, "\u8bae\u4ef7\u5355\u4fe1\u606f", titleFont, 1, 5, Float.valueOf(40.0f), 1, 0);
        PdfPTable pdfPTable1 = new PdfPTable(80);
        tableList.add(pdfPTable1);
        PdfUtil.addCellToTable(pdfPTable1, "\u8bae\u4ef7\u5355\u7f16\u53f7\uff1a" + this.getValueStr(queryPurchaseExecuteBillRspBO.getPurchaseExecuteBillBo().getExecuteCode()), contentFont, 0, 5, Float.valueOf(15.0f), 26, 0);
        PdfUtil.addCellToTable(pdfPTable1, "\u8bae\u4ef7\u5355\u540d\u79f0\uff1a" + this.getValueStr(queryPurchaseExecuteBillRspBO.getPurchaseExecuteBillBo().getExecuteName()), contentFont, 0, 5, Float.valueOf(15.0f), 28, 0);
        PdfUtil.addCellToTable(pdfPTable1, "\u5355\u636e\u72b6\u6001\uff1a" + this.getValueStr(queryPurchaseExecuteBillRspBO.getPurchaseExecuteBillBo().getExecuteStatusName()), contentFont, 0, 5, Float.valueOf(15.0f), 26, 0);
        PdfPTable pdfPTable2 = new PdfPTable(80);
        tableList.add(pdfPTable2);
        PdfUtil.addCellToTable(pdfPTable2, "\u8bae\u4ef7\u6b21\u6570\uff1a" + this.getValueStr(queryPurchaseExecuteBillRspBO.getPurchaseExecuteBillBo().getExecuteRound()), contentFont, 0, 5, Float.valueOf(15.0f), 80, 0);
        List projectNameList = queryPurchaseExecuteBillRspBO.getPurchaseExecuteBillBo().getProjectNameList();
        if (CollUtil.isNotEmpty((Collection)projectNameList)) {
            for (int i = 0; i < projectNameList.size(); ++i) {
                PdfPTable pdfPTable21;
                if (i == 0) {
                    pdfPTable21 = new PdfPTable(80);
                    tableList.add(pdfPTable21);
                    PdfUtil.addCellToTable(pdfPTable21, "\u9879\u76ee\uff1a" + this.getValueStr(projectNameList.get(i)), contentFont, 0, 5, Float.valueOf(15.0f), 80, 0);
                    continue;
                }
                pdfPTable21 = new PdfPTable(80);
                tableList.add(pdfPTable21);
                PdfUtil.addCellToTable(pdfPTable21, "             " + this.getValueStr(projectNameList.get(i)), contentFont, 0, 5, Float.valueOf(15.0f), 80, 0);
            }
        }
        PdfPTable pdfPTable22 = new PdfPTable(80);
        tableList.add(pdfPTable22);
        PdfUtil.addCellToTable(pdfPTable22, "\u7ed3\u7b97\u5e01\u79cd\uff1a" + this.getValueStr(queryPurchaseExecuteBillRspBO.getPurchaseExecuteBillBo().getAccountCurrencyName()), contentFont, 0, 5, Float.valueOf(15.0f), 26, 0);
        PdfUtil.addCellToTable(pdfPTable22, "\u9996\u8f6e\u672a\u62a5\u4ef7\u65f6\u518d\u6b21\u62a5\u4ef7\u662f\u5426\u5141\u8bb8\u62a5\u4ef7\uff1a" + this.getValueStr(queryPurchaseExecuteBillRspBO.getPurchaseExecuteBillBo().getNeedFirstQuoteFlagName()), contentFont, 0, 5, Float.valueOf(15.0f), 28, 0);
        PdfUtil.addCellToTable(pdfPTable22, "\u9884\u7b97\u4fe1\u606f\u662f\u5426\u516c\u5e03\uff1a" + this.getValueStr(queryPurchaseExecuteBillRspBO.getPurchaseExecuteBillBo().getPublishBudgetFlagName()), contentFont, 0, 5, Float.valueOf(15.0f), 26, 0);
        PdfPTable pdfPTable4 = new PdfPTable(80);
        tableList.add(pdfPTable4);
        PdfUtil.addCellToTable(pdfPTable4, "\u8bae\u4ef7\u6d3b\u52a8\u6700\u5c11\u62a5\u4ef7\u5bb6\u6570\uff1a" + this.getValueStr(queryPurchaseExecuteBillRspBO.getPurchaseExecuteBillBo().getLeastQuoteNumber()), contentFont, 0, 5, Float.valueOf(15.0f), 26, 0);
        PdfPTable pdfPTable21 = new PdfPTable(80);
        tableList.add(pdfPTable21);
        if ("2001".equals(queryPurchaseExecuteBillRspBO.getPurchaseExecuteBillBo().getExecuteStatus()) || "2002".equals(queryPurchaseExecuteBillRspBO.getPurchaseExecuteBillBo().getExecuteStatus()) || "2011".equals(queryPurchaseExecuteBillRspBO.getPurchaseExecuteBillBo().getExecuteStatus())) {
            PdfUtil.addCellToTable(pdfPTable21, "\u62a5\u4ef7\u65f6\u95f4\u8981\u6c42\uff1a\u5ba1\u6279\u5b8c\u6210\u540e" + this.getValueStr(queryPurchaseExecuteBillRspBO.getPurchaseExecuteBillBo().getQuoteTimeDaysAppr()) + "\u5929" + queryPurchaseExecuteBillRspBO.getPurchaseExecuteBillBo().getQuoteTimeAppr() + ";\u5f00\u59cb\u540e" + queryPurchaseExecuteBillRspBO.getPurchaseExecuteBillBo().getQuoteTimeDays() + "\u5929" + queryPurchaseExecuteBillRspBO.getPurchaseExecuteBillBo().getQuoteTime() + "\u7ed3\u675f\uff1b\u6301\u7eed\u65f6\u95f4\uff1a" + queryPurchaseExecuteBillRspBO.getPurchaseExecuteBillBo().getQuoteTimeLong() + "\uff1b\u4eca\u65e5\u5ba1\u6279\u5b8c\u6210\uff0c\u9884\u8ba1\u62a5\u4ef7\u65f6\u95f4\u4e3a" + this.getValueStr(queryPurchaseExecuteBillRspBO.getPurchaseExecuteBillBo().getQuoteStartTime()) + " \u81f3 " + this.getValueStr(queryPurchaseExecuteBillRspBO.getPurchaseExecuteBillBo().getQuoteEndTime()), contentFont, 0, 5, Float.valueOf(15.0f), 80, 0);
        } else {
            PdfUtil.addCellToTable(pdfPTable21, "\u62a5\u4ef7\u65f6\u95f4\u8981\u6c42\uff1a" + this.getValueStr(queryPurchaseExecuteBillRspBO.getPurchaseExecuteBillBo().getQuoteStartTime()) + " \u81f3 " + this.getValueStr(queryPurchaseExecuteBillRspBO.getPurchaseExecuteBillBo().getQuoteEndTime()), contentFont, 0, 5, Float.valueOf(15.0f), 80, 0);
        }
        PdfPTable pdfPTable3 = new PdfPTable(80);
        tableList.add(pdfPTable3);
        PdfUtil.addCellToTable(pdfPTable3, "\u4f9b\u5e94\u5546\u4e0a\u67b6\u5468\u671f\uff08\u5929\uff09\uff1a" + this.getValueStr(queryPurchaseExecuteBillRspBO.getPurchaseExecuteBillBo().getPutShelfDays()), contentFont, 0, 5, Float.valueOf(15.0f), 80, 0);
        PdfPTable pdfPTable31 = new PdfPTable(80);
        tableList.add(pdfPTable31);
        PdfUtil.addCellToTable(pdfPTable31, "           \u63d0\u793a\uff1a\u751f\u6210\u6210\u4ea4\u901a\u77e5\u548c\u540e\u4f9b\u5e94\u5546\u9700\u5728\u6b64\u65f6\u95f4\u5185\u5b8c\u6210\u5546\u54c1\u5339\u914d\u6ca1\u5426\u5219\u9700\u91cd\u65b0\u9009\u5b9a\u4f9b\u5e94\u5546", contentFont, 0, 5, Float.valueOf(15.0f), 80, 0);
        PdfPTable pdfPTable42 = new PdfPTable(80);
        tableList.add(pdfPTable42);
        PdfUtil.addCellToTable(pdfPTable42, "\u786e\u8ba4\u65b9\u5f0f\uff1a" + this.getValueStr(queryPurchaseExecuteBillRspBO.getPurchaseExecuteBillBo().getConfirmDealTypeName()), contentFont, 0, 5, Float.valueOf(15.0f), 80, 0);
        PdfPTable pdfPTable41 = new PdfPTable(80);
        tableList.add(pdfPTable41);
        PdfUtil.addCellToTable(pdfPTable41, "     " + EnquiryCommonUtil.getConfirmDealTypeTip(queryPurchaseExecuteBillRspBO.getPurchaseExecuteBillBo().getConfirmDealType()), contentFont, 0, 5, Float.valueOf(15.0f), 80, 0);
        PdfPTable pdfPTable101 = new PdfPTable(80);
        tableList.add(pdfPTable101);
        PdfUtil.addCellToTable(pdfPTable101, null, contentFont, 0, 5, Float.valueOf(20.0f), 80, 0);
        PdfPTable titleTable51 = new PdfPTable(80);
        tableList.add(titleTable51);
        PdfUtil.addCellToTable(titleTable51, "\u62a5\u4ef7\uff08\u660e\u7ec6\u4fe1\u606f\uff09", contentFont, 0, 5, Float.valueOf(40.0f), 80, 0);
        PdfPTable pdfPTable8 = new PdfPTable(83);
        tableList.add(pdfPTable8);
        PdfUtil.addCellToTable(pdfPTable8, "\u5e8f\u53f7", contentFont, 0, 5, Float.valueOf(40.0f), 1, null);
        PdfUtil.addCellToTable(pdfPTable8, "\u7269\u6599\u5c0f\u7c7b", contentFont, 0, 5, Float.valueOf(40.0f), 4, null);
        PdfUtil.addCellToTable(pdfPTable8, "\u7269\u8d44\u7f16\u7801", contentFont, 0, 5, Float.valueOf(40.0f), 4, null);
        PdfUtil.addCellToTable(pdfPTable8, "\u91c7\u8d2d\u7269\u9879\u901a\u7528\u540d\u79f0", contentFont, 0, 5, Float.valueOf(40.0f), 4, null);
        PdfUtil.addCellToTable(pdfPTable8, "\u9700\u6c42\u660e\u7ec6\u7f16\u53f7", contentFont, 0, 5, Float.valueOf(40.0f), 4, null);
        PdfUtil.addCellToTable(pdfPTable8, "\u89c4\u683c\u578b\u53f7", contentFont, 0, 5, Float.valueOf(40.0f), 4, null);
        PdfUtil.addCellToTable(pdfPTable8, "\u6570\u91cf", contentFont, 0, 5, Float.valueOf(40.0f), 3, null);
        PdfUtil.addCellToTable(pdfPTable8, "\u9884\u7b97\u91d1\u989d\uff08\u5143\uff09", contentFont, 0, 5, Float.valueOf(40.0f), 4, null);
        PdfUtil.addCellToTable(pdfPTable8, "\u8981\u6c42\u5230\u8d27\u65e5\u671f", contentFont, 0, 5, Float.valueOf(40.0f), 4, null);
        PdfUtil.addCellToTable(pdfPTable8, "\u62a5\u4ef7\u8f6e\u6b21", contentFont, 0, 5, Float.valueOf(40.0f), 3, null);
        PdfUtil.addCellToTable(pdfPTable8, "\u4f9b\u5e94\u5546", contentFont, 0, 5, Float.valueOf(40.0f), 4, null);
        PdfUtil.addCellToTable(pdfPTable8, "\u662f\u5426\u5df2\u62a5\u4ef7", contentFont, 0, 5, Float.valueOf(40.0f), 3, null);
        PdfUtil.addCellToTable(pdfPTable8, "\u62a5\u4ef7\u603b\u4ef7", contentFont, 0, 5, Float.valueOf(40.0f), 3, null);
        PdfUtil.addCellToTable(pdfPTable8, "\u62a5\u4ef7\u5355\u4ef7", contentFont, 0, 5, Float.valueOf(40.0f), 3, null);
        PdfUtil.addCellToTable(pdfPTable8, "\u627f\u8bfa\u4ea4\u8d27\u671f", contentFont, 0, 5, Float.valueOf(40.0f), 4, null);
        PdfUtil.addCellToTable(pdfPTable8, "\u54c1\u724c", contentFont, 0, 5, Float.valueOf(40.0f), 3, null);
        PdfUtil.addCellToTable(pdfPTable8, "\u5382\u5546", contentFont, 0, 5, Float.valueOf(40.0f), 3, null);
        PdfUtil.addCellToTable(pdfPTable8, "\u5546\u54c1\u578b\u53f7\u6216\u5176\u4ed6\u4fe1\u606f", contentFont, 0, 5, Float.valueOf(40.0f), 3, null);
        PdfUtil.addCellToTable(pdfPTable8, "\u5546\u54c1\u7f16\u7801", contentFont, 0, 5, Float.valueOf(40.0f), 3, null);
        PdfUtil.addCellToTable(pdfPTable8, "\u5916\u90e8\u5546\u54c1\u7f16\u7801", contentFont, 0, 5, Float.valueOf(40.0f), 3, null);
        PdfUtil.addCellToTable(pdfPTable8, "\u534f\u8bae\u660e\u7ec6\u7f16\u7801", contentFont, 0, 5, Float.valueOf(40.0f), 3, null);
        PdfUtil.addCellToTable(pdfPTable8, "UPC\u7801", contentFont, 0, 5, Float.valueOf(40.0f), 3, null);
        PdfUtil.addCellToTable(pdfPTable8, "\u4f9b\u5e94\u5546\u8054\u7cfb\u4eba", contentFont, 0, 5, Float.valueOf(40.0f), 3, null);
        PdfUtil.addCellToTable(pdfPTable8, "\u4f9b\u5e94\u5546\u8054\u7cfb\u7535\u8bdd", contentFont, 0, 5, Float.valueOf(40.0f), 3, null);
        PdfUtil.addCellToTable(pdfPTable8, "\u62a5\u4ef7\u65f6\u95f4", contentFont, 0, 5, Float.valueOf(40.0f), 4, null);
        if (CollUtil.isNotEmpty(executeQuotePlanItemBoList)) {
            int count = 1;
            for (ExecuteQuotePlanItemBo totalBO : executeQuotePlanItemBoList) {
                PurchaseExecuteItemBO purchaseExecuteItemBO = totalBO.getExecuteItemBO();
                List quoteItemList = totalBO.getQuoteItemList();
                Iterator iterator = quoteItemList.iterator();
                while (iterator.hasNext()) {
                    QuotationItemBO quotationItemBO = (QuotationItemBO)iterator.next();
                    PdfPTable pdfPTable9 = new PdfPTable(83);
                    tableList.add(pdfPTable9);
                    PdfUtil.addCellToTable(pdfPTable9, String.valueOf(count), contentFont, 0, 5, Float.valueOf(100.0f), 1, null);
                    PdfUtil.addCellToTable(pdfPTable9, this.getValueStr(purchaseExecuteItemBO.getWxfl() + "-" + purchaseExecuteItemBO.getWxflStr()), contentFont, 0, 5, Float.valueOf(100.0f), 4, null);
                    PdfUtil.addCellToTable(pdfPTable9, this.getValueStr(purchaseExecuteItemBO.getWlbh() + "-" + purchaseExecuteItemBO.getWlbhStr()), contentFont, 0, 5, Float.valueOf(100.0f), 4, null);
                    PdfUtil.addCellToTable(pdfPTable9, this.getValueStr(purchaseExecuteItemBO.getWlmc()), contentFont, 0, 5, Float.valueOf(100.0f), 4, null);
                    PdfUtil.addCellToTable(pdfPTable9, this.getValueStr(purchaseExecuteItemBO.getJhmxbh()), contentFont, 0, 5, Float.valueOf(100.0f), 4, null);
                    PdfUtil.addCellToTable(pdfPTable9, this.getValueStr(purchaseExecuteItemBO.getGgxh()), contentFont, 0, 5, Float.valueOf(100.0f), 4, null);
                    PdfUtil.addCellToTable(pdfPTable9, this.getValueStr(purchaseExecuteItemBO.getSl()), contentFont, 0, 5, Float.valueOf(100.0f), 3, null);
                    PdfUtil.addCellToTable(pdfPTable9, this.getValueStr(purchaseExecuteItemBO.getYsje()), contentFont, 0, 5, Float.valueOf(100.0f), 4, null);
                    PdfUtil.addCellToTable(pdfPTable9, this.getValueStr(purchaseExecuteItemBO.getYqdhrq()), contentFont, 0, 5, Float.valueOf(100.0f), 4, null);
                    PdfUtil.addCellToTable(pdfPTable9, this.getValueStr(quotationItemBO.getQuoteRound()), contentFont, 0, 5, Float.valueOf(100.0f), 3, null);
                    PdfUtil.addCellToTable(pdfPTable9, this.getValueStr(quotationItemBO.getSupplierName()), contentFont, 0, 5, Float.valueOf(100.0f), 4, null);
                    PdfUtil.addCellToTable(pdfPTable9, this.getValueStr(quotationItemBO.getIsQuote()), contentFont, 0, 5, Float.valueOf(100.0f), 3, null);
                    PdfUtil.addCellToTable(pdfPTable9, this.getValueStr(quotationItemBO.getQuoteMoneyStr()), contentFont, 0, 5, Float.valueOf(100.0f), 3, null);
                    PdfUtil.addCellToTable(pdfPTable9, this.getValueStr(quotationItemBO.getQuotePriceStr()), contentFont, 0, 5, Float.valueOf(100.0f), 3, null);
                    PdfUtil.addCellToTable(pdfPTable9, this.getValueStr(quotationItemBO.getPromiseDeliveryDaysStr() == null ? "" : "\u8ba2\u5355\u751f\u6548\u540e:" + quotationItemBO.getPromiseDeliveryDaysStr() + "\u5929"), contentFont, 0, 5, Float.valueOf(100.0f), 4, null);
                    PdfUtil.addCellToTable(pdfPTable9, this.getValueStr(quotationItemBO.getBrand()), contentFont, 0, 5, Float.valueOf(100.0f), 3, null);
                    PdfUtil.addCellToTable(pdfPTable9, this.getValueStr(quotationItemBO.getManufacturer()), contentFont, 0, 5, Float.valueOf(100.0f), 3, null);
                    PdfUtil.addCellToTable(pdfPTable9, this.getValueStr(quotationItemBO.getProductModelAndOther()), contentFont, 0, 5, Float.valueOf(100.0f), 3, null);
                    PdfUtil.addCellToTable(pdfPTable9, this.getValueStr(quotationItemBO.getProductCode()), contentFont, 0, 5, Float.valueOf(100.0f), 3, null);
                    PdfUtil.addCellToTable(pdfPTable9, this.getValueStr(quotationItemBO.getOutsideProductCode()), contentFont, 0, 5, Float.valueOf(100.0f), 3, null);
                    PdfUtil.addCellToTable(pdfPTable9, this.getValueStr(quotationItemBO.getAgreementItemCode()), contentFont, 0, 5, Float.valueOf(100.0f), 3, null);
                    PdfUtil.addCellToTable(pdfPTable9, this.getValueStr(quotationItemBO.getUpcCode()), contentFont, 0, 5, Float.valueOf(100.0f), 3, null);
                    PdfUtil.addCellToTable(pdfPTable9, this.getValueStr(quotationItemBO.getSupplierContactsName()), contentFont, 0, 5, Float.valueOf(100.0f), 3, null);
                    PdfUtil.addCellToTable(pdfPTable9, this.getValueStr(quotationItemBO.getSupplierContactsMobile()), contentFont, 0, 5, Float.valueOf(100.0f), 3, null);
                    PdfUtil.addCellToTable(pdfPTable9, this.getValueStr(quotationItemBO.getQuoteTimeStr()), contentFont, 0, 5, Float.valueOf(100.0f), 4, null);
                    ++count;
                }
            }
        }
        PdfPTable pdfPTable10 = new PdfPTable(80);
        tableList.add(pdfPTable10);
        PdfUtil.addCellToTable(pdfPTable10, null, contentFont, 0, 5, Float.valueOf(20.0f), 80, 0);
        PdfPTable titleTable5 = new PdfPTable(80);
        tableList.add(titleTable5);
        PdfUtil.addCellToTable(titleTable5, "\u786e\u8ba4\u6210\u4ea4\uff08\u660e\u7ec6\u4fe1\u606f\uff09", contentFont, 0, 5, Float.valueOf(40.0f), 80, 0);
        PdfPTable pdfPTable9 = new PdfPTable(42);
        tableList.add(pdfPTable9);
        PdfUtil.addCellToTable(pdfPTable9, "\u5e8f\u53f7", contentFont, 0, 5, Float.valueOf(80.0f), 1, null);
        PdfUtil.addCellToTable(pdfPTable9, "\u5546\u54c1\u4e0a\u67b6\u72b6\u6001", contentFont, 0, 5, Float.valueOf(80.0f), 1, null);
        PdfUtil.addCellToTable(pdfPTable9, "\u62a5\u4ef7\u6709\u6548\u671f", contentFont, 0, 5, Float.valueOf(80.0f), 1, null);
        PdfUtil.addCellToTable(pdfPTable9, "\u627f\u8bfa\u4ea4\u8d27\u671f", contentFont, 0, 5, Float.valueOf(80.0f), 1, null);
        PdfUtil.addCellToTable(pdfPTable9, "\u91c7\u8d2d\u7269\u9879\u901a\u7528\u540d\u79f0", contentFont, 0, 5, Float.valueOf(80.0f), 1, null);
        PdfUtil.addCellToTable(pdfPTable9, "\u89c4\u683c\u578b\u53f7", contentFont, 0, 5, Float.valueOf(80.0f), 1, null);
        PdfUtil.addCellToTable(pdfPTable9, "\u62a5\u4ef7\u6570\u91cf", contentFont, 0, 5, Float.valueOf(80.0f), 1, null);
        PdfUtil.addCellToTable(pdfPTable9, "\u62a5\u4ef7\u5355\u4ef7", contentFont, 0, 5, Float.valueOf(80.0f), 1, null);
        PdfUtil.addCellToTable(pdfPTable9, "\u62a5\u4ef7\u603b\u4ef7\uff08\u5143\uff09", contentFont, 0, 5, Float.valueOf(80.0f), 1, null);
        PdfUtil.addCellToTable(pdfPTable9, "\u7269\u6599\u5c0f\u7c7b", contentFont, 0, 5, Float.valueOf(80.0f), 1, null);
        PdfUtil.addCellToTable(pdfPTable9, "\u7269\u8d44\u7f16\u7801", contentFont, 0, 5, Float.valueOf(80.0f), 1, null);
        PdfUtil.addCellToTable(pdfPTable9, "\u54c1\u724c", contentFont, 0, 5, Float.valueOf(80.0f), 1, null);
        PdfUtil.addCellToTable(pdfPTable9, "\u9700\u6c42\u660e\u7ec6\u7f16\u53f7", contentFont, 0, 5, Float.valueOf(80.0f), 1, null);
        PdfUtil.addCellToTable(pdfPTable9, "\u751f\u4ea7\u5382\u5bb6", contentFont, 0, 5, Float.valueOf(80.0f), 1, null);
        PdfUtil.addCellToTable(pdfPTable9, "\u5546\u54c1\u578b\u53f7\u6216\u5176\u4ed6\u4fe1\u606f", contentFont, 0, 5, Float.valueOf(80.0f), 1, null);
        PdfUtil.addCellToTable(pdfPTable9, "\u5546\u54c1\u7f16\u7801", contentFont, 0, 5, Float.valueOf(80.0f), 1, null);
        PdfUtil.addCellToTable(pdfPTable9, "\u5916\u90e8\u5546\u54c1\u7f16\u7801", contentFont, 0, 5, Float.valueOf(80.0f), 1, null);
        PdfUtil.addCellToTable(pdfPTable9, "\u534f\u8bae\u660e\u7ec6\u7f16\u7801", contentFont, 0, 5, Float.valueOf(80.0f), 1, null);
        PdfUtil.addCellToTable(pdfPTable9, "upc\u7801", contentFont, 0, 5, Float.valueOf(80.0f), 1, null);
        PdfUtil.addCellToTable(pdfPTable9, "\u6570\u91cf", contentFont, 0, 5, Float.valueOf(80.0f), 1, null);
        PdfUtil.addCellToTable(pdfPTable9, "\u9884\u7b97\u5355\u4ef7", contentFont, 0, 5, Float.valueOf(80.0f), 1, null);
        PdfUtil.addCellToTable(pdfPTable9, "\u9884\u7b97\u91d1\u989d", contentFont, 0, 5, Float.valueOf(80.0f), 1, null);
        PdfUtil.addCellToTable(pdfPTable9, "\u4ea4\u8d27\u671f\u8981\u6c42", contentFont, 0, 5, Float.valueOf(80.0f), 1, null);
        PdfUtil.addCellToTable(pdfPTable9, "\u6267\u884c\u6807\u51c6", contentFont, 0, 5, Float.valueOf(80.0f), 1, null);
        PdfUtil.addCellToTable(pdfPTable9, "\u63a8\u8350\u54c1\u724c/\u5236\u9020\u5546", contentFont, 0, 5, Float.valueOf(80.0f), 1, null);
        PdfUtil.addCellToTable(pdfPTable9, "\u5b89\u5168\u7b49\u7ea7", contentFont, 0, 5, Float.valueOf(80.0f), 1, null);
        PdfUtil.addCellToTable(pdfPTable9, "\u8d28\u4fdd\u7b49\u7ea7", contentFont, 0, 5, Float.valueOf(80.0f), 1, null);
        PdfUtil.addCellToTable(pdfPTable9, "\u7b2c\u4e09\u65b9\u68c0\u9a8c\u8bc1\u4e66", contentFont, 0, 5, Float.valueOf(80.0f), 1, null);
        PdfUtil.addCellToTable(pdfPTable9, "\u5305\u88c5\u65b9\u5f0f", contentFont, 0, 5, Float.valueOf(80.0f), 1, null);
        PdfUtil.addCellToTable(pdfPTable9, "\u914d\u5957\u670d\u52a1\uff08\u5b89\u88c5\u7b49\uff09", contentFont, 0, 5, Float.valueOf(80.0f), 1, null);
        PdfUtil.addCellToTable(pdfPTable9, "\u8d28\u4fdd\u5468\u671f", contentFont, 0, 5, Float.valueOf(80.0f), 1, null);
        PdfUtil.addCellToTable(pdfPTable9, "\u5176\u4ed6\u6280\u672f\u8981\u6c42", contentFont, 0, 5, Float.valueOf(80.0f), 1, null);
        PdfUtil.addCellToTable(pdfPTable9, "\u5386\u53f2\u91c7\u8d2d\u5355\u4ef7", contentFont, 0, 5, Float.valueOf(80.0f), 1, null);
        PdfUtil.addCellToTable(pdfPTable9, "\u5907\u6ce8", contentFont, 0, 5, Float.valueOf(80.0f), 1, null);
        PdfUtil.addCellToTable(pdfPTable9, "\u53c2\u8003\u5546\u54c1\u7f16\u7801", contentFont, 0, 5, Float.valueOf(80.0f), 1, null);
        PdfUtil.addCellToTable(pdfPTable9, "\u6807\u51c6\u5e93\u76ee\u5f55\u540d\u79f0", contentFont, 0, 5, Float.valueOf(80.0f), 1, null);
        PdfUtil.addCellToTable(pdfPTable9, "\u6700\u9ad8\u9650\u4ef7", contentFont, 0, 5, Float.valueOf(80.0f), 1, null);
        PdfUtil.addCellToTable(pdfPTable9, "\u5b89\u5168\u5e93\u5b58", contentFont, 0, 5, Float.valueOf(80.0f), 1, null);
        PdfUtil.addCellToTable(pdfPTable9, "\u6700\u957f\u4ea4\u8d27\u5468\u671f\uff08\u5929\uff09", contentFont, 0, 5, Float.valueOf(80.0f), 1, null);
        PdfUtil.addCellToTable(pdfPTable9, "\u7269\u8d44\u7f16\u7801\u8ba1\u91cf\u5355\u4f4d", contentFont, 0, 5, Float.valueOf(80.0f), 1, null);
        PdfUtil.addCellToTable(pdfPTable9, "\u786e\u8ba4\u4f9b\u5e94\u5546", contentFont, 0, 5, Float.valueOf(40.0f), 1, null);
        PdfUtil.addCellToTable(pdfPTable9, "\u786e\u8ba4\u5907\u6ce8", contentFont, 0, 5, Float.valueOf(40.0f), 1, null);
        if (CollUtil.isNotEmpty(executeQuotePlanItemBOList)) {
            int count = 1;
            for (EnquiryExecuteQuotePlanItemBO quoteItemBo : executeQuotePlanItemBOList) {
                PdfPTable pdfPTable11 = new PdfPTable(42);
                tableList.add(pdfPTable11);
                PdfUtil.addCellToTable(pdfPTable11, String.valueOf(count), contentFont, 0, 5, Float.valueOf(100.0f), 1, null);
                PdfUtil.addCellToTable(pdfPTable11, this.getValueStr(quoteItemBo.getPutSelfStatus()), contentFont, 0, 5, Float.valueOf(100.0f), 1, null);
                PdfUtil.addCellToTable(pdfPTable11, this.getValueStr(quoteItemBo.getQuotedEffTime()), contentFont, 0, 5, Float.valueOf(100.0f), 1, null);
                PdfUtil.addCellToTable(pdfPTable11, this.getValueStr(quoteItemBo.getPromiseDeliveryDaysName()), contentFont, 0, 5, Float.valueOf(100.0f), 1, null);
                PdfUtil.addCellToTable(pdfPTable11, this.getValueStr(quoteItemBo.getWlmc()), contentFont, 0, 5, Float.valueOf(100.0f), 1, null);
                PdfUtil.addCellToTable(pdfPTable11, this.getValueStr(quoteItemBo.getGgxh()), contentFont, 0, 5, Float.valueOf(100.0f), 1, null);
                PdfUtil.addCellToTable(pdfPTable11, this.getValueStr(quoteItemBo.getQuoteNumbers()), contentFont, 0, 5, Float.valueOf(100.0f), 1, null);
                PdfUtil.addCellToTable(pdfPTable11, this.getValueStr(quoteItemBo.getQuotePrice()), contentFont, 0, 5, Float.valueOf(100.0f), 1, null);
                PdfUtil.addCellToTable(pdfPTable11, this.getValueStr(quoteItemBo.getQuoteMoney()), contentFont, 0, 5, Float.valueOf(100.0f), 1, null);
                PdfUtil.addCellToTable(pdfPTable11, this.getValueStr(quoteItemBo.getWxflName()), contentFont, 0, 5, Float.valueOf(100.0f), 1, null);
                PdfUtil.addCellToTable(pdfPTable11, this.getValueStr(quoteItemBo.getWlbhName()), contentFont, 0, 5, Float.valueOf(100.0f), 1, null);
                PdfUtil.addCellToTable(pdfPTable11, this.getValueStr(quoteItemBo.getBrand()), contentFont, 0, 5, Float.valueOf(100.0f), 1, null);
                PdfUtil.addCellToTable(pdfPTable11, this.getValueStr(quoteItemBo.getJhmxbh()), contentFont, 0, 5, Float.valueOf(100.0f), 1, null);
                PdfUtil.addCellToTable(pdfPTable11, this.getValueStr(quoteItemBo.getManufacturer()), contentFont, 0, 5, Float.valueOf(100.0f), 1, null);
                PdfUtil.addCellToTable(pdfPTable11, this.getValueStr(quoteItemBo.getProductModelAndOther()), contentFont, 0, 5, Float.valueOf(100.0f), 1, null);
                PdfUtil.addCellToTable(pdfPTable11, this.getValueStr(quoteItemBo.getProductCode()), contentFont, 0, 5, Float.valueOf(100.0f), 1, null);
                PdfUtil.addCellToTable(pdfPTable11, this.getValueStr(quoteItemBo.getOutsideProductCode()), contentFont, 0, 5, Float.valueOf(100.0f), 1, null);
                PdfUtil.addCellToTable(pdfPTable11, this.getValueStr(quoteItemBo.getAgreementItemCode()), contentFont, 0, 5, Float.valueOf(100.0f), 1, null);
                PdfUtil.addCellToTable(pdfPTable11, this.getValueStr(quoteItemBo.getUpcCode()), contentFont, 0, 5, Float.valueOf(100.0f), 1, null);
                PdfUtil.addCellToTable(pdfPTable11, this.getValueStr(quoteItemBo.getSl()), contentFont, 0, 5, Float.valueOf(100.0f), 1, null);
                PdfUtil.addCellToTable(pdfPTable11, this.getValueStr(quoteItemBo.getBudgetPrice()), contentFont, 0, 5, Float.valueOf(100.0f), 1, null);
                PdfUtil.addCellToTable(pdfPTable11, this.getValueStr(quoteItemBo.getBudgetMoney()), contentFont, 0, 5, Float.valueOf(100.0f), 1, null);
                PdfUtil.addCellToTable(pdfPTable11, this.getValueStr(quoteItemBo.getYqdhrq()), contentFont, 0, 5, Float.valueOf(100.0f), 1, null);
                PdfUtil.addCellToTable(pdfPTable11, this.getValueStr(quoteItemBo.getZxbz()), contentFont, 0, 5, Float.valueOf(100.0f), 1, null);
                PdfUtil.addCellToTable(pdfPTable11, this.getValueStr(quoteItemBo.getZzsmc()), contentFont, 0, 5, Float.valueOf(100.0f), 1, null);
                PdfUtil.addCellToTable(pdfPTable11, this.getValueStr(quoteItemBo.getAqdj()), contentFont, 0, 5, Float.valueOf(100.0f), 1, null);
                PdfUtil.addCellToTable(pdfPTable11, this.getValueStr(quoteItemBo.getZbdj()), contentFont, 0, 5, Float.valueOf(100.0f), 1, null);
                PdfUtil.addCellToTable(pdfPTable11, this.getValueStr(quoteItemBo.getDsfjczmName()), contentFont, 0, 5, Float.valueOf(100.0f), 1, null);
                PdfUtil.addCellToTable(pdfPTable11, this.getValueStr(quoteItemBo.getBzfsName()), contentFont, 0, 5, Float.valueOf(100.0f), 1, null);
                PdfUtil.addCellToTable(pdfPTable11, this.getValueStr(quoteItemBo.getPtfwName()), contentFont, 0, 5, Float.valueOf(100.0f), 1, null);
                PdfUtil.addCellToTable(pdfPTable11, this.getValueStr(quoteItemBo.getZbzq()), contentFont, 0, 5, Float.valueOf(100.0f), 1, null);
                PdfUtil.addCellToTable(pdfPTable11, this.getValueStr(quoteItemBo.getQtjsyq()), contentFont, 0, 5, Float.valueOf(100.0f), 1, null);
                PdfUtil.addCellToTable(pdfPTable11, this.getValueStr(quoteItemBo.getLscgdj()), contentFont, 0, 5, Float.valueOf(100.0f), 1, null);
                PdfUtil.addCellToTable(pdfPTable11, this.getValueStr(quoteItemBo.getBz()), contentFont, 0, 5, Float.valueOf(100.0f), 1, null);
                PdfUtil.addCellToTable(pdfPTable11, this.getValueStr(quoteItemBo.getCkspbm()), contentFont, 0, 5, Float.valueOf(100.0f), 1, null);
                PdfUtil.addCellToTable(pdfPTable11, this.getValueStr(quoteItemBo.getBzkmlmc()), contentFont, 0, 5, Float.valueOf(100.0f), 1, null);
                PdfUtil.addCellToTable(pdfPTable11, this.getValueStr(quoteItemBo.getZgxj()), contentFont, 0, 5, Float.valueOf(100.0f), 1, null);
                PdfUtil.addCellToTable(pdfPTable11, this.getValueStr(quoteItemBo.getAqkc()), contentFont, 0, 5, Float.valueOf(100.0f), 1, null);
                PdfUtil.addCellToTable(pdfPTable11, this.getValueStr(quoteItemBo.getJhzq()), contentFont, 0, 5, Float.valueOf(100.0f), 1, null);
                PdfUtil.addCellToTable(pdfPTable11, this.getValueStr(quoteItemBo.getDw()), contentFont, 0, 5, Float.valueOf(100.0f), 1, null);
                PdfUtil.addCellToTable(pdfPTable11, this.getValueStr(quoteItemBo.getSupplierName()), contentFont, 0, 5, Float.valueOf(100.0f), 1, null);
                PdfUtil.addCellToTable(pdfPTable11, this.getValueStr(quoteItemBo.getConfirmRemark()), contentFont, 0, 5, Float.valueOf(100.0f), 1, null);
                ++count;
            }
        }
        PdfPTable pdfPTable17 = new PdfPTable(80);
        tableList.add(pdfPTable17);
        PdfUtil.addCellToTable(pdfPTable17, null, contentFont, 0, 5, Float.valueOf(20.0f), 80, 0);
        PdfPTable titleTable18 = new PdfPTable(80);
        tableList.add(titleTable18);
        PdfUtil.addCellToTable(titleTable18, "\u6267\u884c\u8bb0\u5f55", contentFont, 0, 5, Float.valueOf(40.0f), 80, 0);
        PdfPTable pdfPTable19 = new PdfPTable(7);
        tableList.add(pdfPTable19);
        PdfUtil.addCellToTable(pdfPTable19, "\u5e8f\u53f7", contentFont, 0, 5, Float.valueOf(40.0f), 1, null);
        PdfUtil.addCellToTable(pdfPTable19, "\u64cd\u4f5c\u73af\u8282", contentFont, 0, 5, Float.valueOf(40.0f), 1, null);
        PdfUtil.addCellToTable(pdfPTable19, "\u64cd\u4f5c\u884c\u4e3a", contentFont, 0, 5, Float.valueOf(40.0f), 1, null);
        PdfUtil.addCellToTable(pdfPTable19, "\u64cd\u4f5c\u4eba", contentFont, 0, 5, Float.valueOf(40.0f), 1, null);
        PdfUtil.addCellToTable(pdfPTable19, "\u64cd\u4f5c\u65f6\u95f4", contentFont, 0, 5, Float.valueOf(40.0f), 1, null);
        PdfUtil.addCellToTable(pdfPTable19, "\u6240\u5c5e\u5355\u4f4d", contentFont, 0, 5, Float.valueOf(40.0f), 1, null);
        PdfUtil.addCellToTable(pdfPTable19, "\u5904\u7406\u610f\u89c1", contentFont, 0, 5, Float.valueOf(40.0f), 1, null);
        if (CollUtil.isNotEmpty(list)) {
            int count = 1;
            for (BaseAllOperLogBO itemBO : list) {
                PdfPTable pdfPTable11 = new PdfPTable(7);
                tableList.add(pdfPTable11);
                PdfUtil.addCellToTable(pdfPTable11, String.valueOf(count), contentFont, 0, 5, Float.valueOf(80.0f), 1, null);
                PdfUtil.addCellToTable(pdfPTable11, this.getValueStr(itemBO.getOperBehavior()), contentFont, 0, 5, Float.valueOf(80.0f), 1, null);
                PdfUtil.addCellToTable(pdfPTable11, this.getValueStr(itemBO.getBusiStepName()), contentFont, 0, 5, Float.valueOf(80.0f), 1, null);
                PdfUtil.addCellToTable(pdfPTable11, this.getValueStr(itemBO.getOperName()), contentFont, 0, 5, Float.valueOf(80.0f), 1, null);
                PdfUtil.addCellToTable(pdfPTable11, this.getValueStr(itemBO.getOperTime()), contentFont, 0, 5, Float.valueOf(80.0f), 1, null);
                PdfUtil.addCellToTable(pdfPTable11, this.getValueStr(itemBO.getOperOrgName()), contentFont, 0, 5, Float.valueOf(80.0f), 1, null);
                PdfUtil.addCellToTable(pdfPTable11, this.getValueStr(itemBO.getRemark()), contentFont, 0, 5, Float.valueOf(80.0f), 1, null);
                ++count;
            }
        }
        PdfUtil.addTableListToDoc(document, tableList);
        document.close();
        byte[] pdfBytes = byteArrayOutputStream.toByteArray();
        ByteArrayInputStream inputStream = new ByteArrayInputStream(pdfBytes);
        String fileName = UUID.randomUUID().toString().replaceAll("-", "") + ".pdf";
        String path = this.fileClient.uploadFileByInputStream(PATH, fileName, (InputStream)inputStream);
        if (FILE_TYPE_OSS.equals(this.fileType)) {
            exportUrl = this.ossFileUrl + path;
        } else if (FILE_TYPE_FASTDFS.equals(this.fileType)) {
            FastdfsFileInfo fastdfsFileInfo = FastdfsFileInfo.toFastdfsFileInfo((String)path);
            exportUrl = this.fastdfsDownloadUrl + "/" + fastdfsFileInfo.getGroupName() + "/" + fastdfsFileInfo.getFileName();
        } else {
            throw new ZTBusinessException("\u6682\u4e0d\u652f\u6301\u7684\u6587\u4ef6\u670d\u52a1\u5668\u7c7b\u578b");
        }
        return exportUrl;
    }

    private String doBiddingExecuteQueryPdf(QueryPurchaseExecuteBillRspBO queryPurchaseExecuteBillRspBO, QueryPurchaseExecuteBillReqBO reqBO, List<EnquiryExecuteQuotePlanItemBO> executeQuotePlanItemBOList, List<ExecuteQuotePlanItemBo> executeQuotePlanItemBoList, List<BaseAllOperLogBO> list) {
        String exportUrl;
        BaseFont baseFont;
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        Document document = new Document(PageSize.A4.rotate(), -75.0f, -75.0f, 15.0f, 40.0f);
        PdfWriter pdfWriter = null;
        try {
            pdfWriter = PdfWriter.getInstance((Document)document, (OutputStream)byteArrayOutputStream);
        }
        catch (DocumentException e) {
            e.printStackTrace();
        }
        try {
            baseFont = BaseFont.createFont((String)"STSong-Light", (String)"UniGB-UCS2-H", (boolean)false);
        }
        catch (Exception e) {
            throw new BusinessException("0100", "\u5b9a\u4e49\u5b57\u4f53\u51fa\u9519", e);
        }
        Font titleFont = new Font(baseFont, 14.0f, 1);
        Font contentFont = new Font(baseFont, 8.0f, 0);
        int COLUMNS = 80;
        document.open();
        this.doAddTextWatermark(pdfWriter, reqBO.getName());
        LinkedList<PdfPTable> tableList = new LinkedList<PdfPTable>();
        PdfPTable titleTable = new PdfPTable(1);
        tableList.add(titleTable);
        PdfUtil.addCellToTable(titleTable, "\u7ade\u4ef7\u5355\u4fe1\u606f", titleFont, 1, 5, Float.valueOf(40.0f), 1, 0);
        PdfPTable pdfPTable1 = new PdfPTable(80);
        tableList.add(pdfPTable1);
        PdfUtil.addCellToTable(pdfPTable1, "\u7ade\u4ef7\u5355\u7f16\u53f7\uff1a" + this.getValueStr(queryPurchaseExecuteBillRspBO.getPurchaseExecuteBillBo().getExecuteCode()), contentFont, 0, 5, Float.valueOf(15.0f), 26, 0);
        PdfUtil.addCellToTable(pdfPTable1, "\u7ade\u4ef7\u5355\u540d\u79f0\uff1a" + this.getValueStr(queryPurchaseExecuteBillRspBO.getPurchaseExecuteBillBo().getExecuteName()), contentFont, 0, 5, Float.valueOf(15.0f), 28, 0);
        PdfUtil.addCellToTable(pdfPTable1, "\u5355\u636e\u72b6\u6001\uff1a" + this.getValueStr(queryPurchaseExecuteBillRspBO.getPurchaseExecuteBillBo().getExecuteStatusName()), contentFont, 0, 5, Float.valueOf(15.0f), 26, 0);
        List projectNameList = queryPurchaseExecuteBillRspBO.getPurchaseExecuteBillBo().getProjectNameList();
        if (CollUtil.isNotEmpty((Collection)projectNameList)) {
            for (int i = 0; i < projectNameList.size(); ++i) {
                PdfPTable pdfPTable20;
                if (i == 0) {
                    pdfPTable20 = new PdfPTable(80);
                    tableList.add(pdfPTable20);
                    PdfUtil.addCellToTable(pdfPTable20, "\u9879\u76ee\uff1a" + this.getValueStr(projectNameList.get(i)), contentFont, 0, 5, Float.valueOf(15.0f), 80, 0);
                    continue;
                }
                pdfPTable20 = new PdfPTable(80);
                tableList.add(pdfPTable20);
                PdfUtil.addCellToTable(pdfPTable20, "             " + this.getValueStr(projectNameList.get(i)), contentFont, 0, 5, Float.valueOf(15.0f), 80, 0);
            }
        }
        PdfPTable pdfPTable20 = new PdfPTable(80);
        tableList.add(pdfPTable20);
        PdfUtil.addCellToTable(pdfPTable20, "\u7ed3\u7b97\u5e01\u79cd\uff1a" + this.getValueStr(queryPurchaseExecuteBillRspBO.getPurchaseExecuteBillBo().getAccountCurrencyName()), contentFont, 0, 5, Float.valueOf(15.0f), 26, 0);
        PdfUtil.addCellToTable(pdfPTable20, "\u662f\u5426\u9700\u8981\u4fdd\u8bc1\u91d1\uff1a" + this.getValueStr(queryPurchaseExecuteBillRspBO.getPurchaseExecuteBillBo().getBondFlagName()), contentFont, 0, 5, Float.valueOf(15.0f), 28, 0);
        PdfUtil.addCellToTable(pdfPTable20, "\u6bcf\u6b21\u7ade\u4ef7\u62a5\u4ef7\u9012\u51cf\u91cf\uff1a" + this.getValueStr(queryPurchaseExecuteBillRspBO.getPurchaseExecuteBillBo().getBiddingDecreaseTypeName()), contentFont, 0, 5, Float.valueOf(15.0f), 26, 0);
        PdfPTable pdfPTable21 = new PdfPTable(80);
        tableList.add(pdfPTable21);
        if (queryPurchaseExecuteBillRspBO.getPurchaseExecuteBillBo().getBiddingDecreaseType() != null && EnquiryConstant.BiddingDecreaseType.COMPARED_QUOTE_TYPE_2.intValue() == queryPurchaseExecuteBillRspBO.getPurchaseExecuteBillBo().getBiddingDecreaseType().intValue()) {
            PdfUtil.addCellToTable(pdfPTable21, "\u603b\u62a5\u4ef7/\u5355\u9879\u62a5\u4ef7\u5fc5\u987b\u6bd4\uff1a" + this.getValueStr(queryPurchaseExecuteBillRspBO.getPurchaseExecuteBillBo().getBiddingDecreaseMethodName()) + "\u4f4e" + this.getValueStr(queryPurchaseExecuteBillRspBO.getPurchaseExecuteBillBo().getBiddingDecrease()) + "\u5143", contentFont, 0, 5, Float.valueOf(15.0f), 26, 0);
        } else {
            PdfUtil.addCellToTable(pdfPTable21, "\u603b\u62a5\u4ef7/\u5355\u9879\u62a5\u4ef7\u5fc5\u987b\u6bd4\uff1a" + this.getValueStr(queryPurchaseExecuteBillRspBO.getPurchaseExecuteBillBo().getBiddingDecreaseMethodName()) + "\u4f4e" + this.getValueStr(queryPurchaseExecuteBillRspBO.getPurchaseExecuteBillBo().getBiddingDecrease()) + "%", contentFont, 0, 5, Float.valueOf(15.0f), 26, 0);
        }
        PdfUtil.addCellToTable(pdfPTable21, "\u662f\u5426\u542f\u7528\u5ef6\u65f6\u7ade\u4ef7\u89c4\u5219\uff1a" + this.getValueStr(queryPurchaseExecuteBillRspBO.getPurchaseExecuteBillBo().getTimeDelayFlagName()), contentFont, 0, 5, Float.valueOf(15.0f), 28, 0);
        PdfUtil.addCellToTable(pdfPTable21, "\u7ade\u4ef7\u6d3b\u52a8\u6700\u5c11\u62a5\u4ef7\u5bb6\u6570\uff1a" + this.getValueStr(queryPurchaseExecuteBillRspBO.getPurchaseExecuteBillBo().getLeastQuoteNumber()), contentFont, 0, 5, Float.valueOf(15.0f), 26, 0);
        PdfPTable pdfPTable22 = new PdfPTable(80);
        tableList.add(pdfPTable22);
        PdfUtil.addCellToTable(pdfPTable22, "\u8bf4\u660e\uff1a" + this.getValueStr(queryPurchaseExecuteBillRspBO.getPurchaseExecuteBillBo().getRemarks()), contentFont, 0, 5, Float.valueOf(15.0f), 26, 0);
        PdfPTable pdfPTable23 = new PdfPTable(80);
        tableList.add(pdfPTable23);
        if ("2001".equals(queryPurchaseExecuteBillRspBO.getPurchaseExecuteBillBo().getExecuteStatus()) || "2002".equals(queryPurchaseExecuteBillRspBO.getPurchaseExecuteBillBo().getExecuteStatus()) || "2011".equals(queryPurchaseExecuteBillRspBO.getPurchaseExecuteBillBo().getExecuteStatus())) {
            PdfUtil.addCellToTable(pdfPTable23, "\u62a5\u4ef7\u65f6\u95f4\u8981\u6c42\uff1a\u5ba1\u6279\u5b8c\u6210\u540e" + this.getValueStr(queryPurchaseExecuteBillRspBO.getPurchaseExecuteBillBo().getQuoteTimeDaysAppr()) + "\u5929" + queryPurchaseExecuteBillRspBO.getPurchaseExecuteBillBo().getQuoteTimeAppr() + ";\u5f00\u59cb\u540e" + queryPurchaseExecuteBillRspBO.getPurchaseExecuteBillBo().getQuoteTimeDays() + "\u5929" + queryPurchaseExecuteBillRspBO.getPurchaseExecuteBillBo().getQuoteTime() + "\u7ed3\u675f\uff1b\u6301\u7eed\u65f6\u95f4\uff1a" + queryPurchaseExecuteBillRspBO.getPurchaseExecuteBillBo().getQuoteTimeLong() + "\uff1b\u4eca\u65e5\u5ba1\u6279\u5b8c\u6210\uff0c\u9884\u8ba1\u62a5\u4ef7\u65f6\u95f4\u4e3a" + this.getValueStr(queryPurchaseExecuteBillRspBO.getPurchaseExecuteBillBo().getQuoteStartTime()) + " \u81f3 " + this.getValueStr(queryPurchaseExecuteBillRspBO.getPurchaseExecuteBillBo().getQuoteEndTime()), contentFont, 0, 5, Float.valueOf(15.0f), 80, 0);
        } else {
            PdfUtil.addCellToTable(pdfPTable23, "\u62a5\u4ef7\u65f6\u95f4\u8981\u6c42\uff1a" + this.getValueStr(queryPurchaseExecuteBillRspBO.getPurchaseExecuteBillBo().getQuoteStartTime()) + " \u81f3 " + this.getValueStr(queryPurchaseExecuteBillRspBO.getPurchaseExecuteBillBo().getQuoteEndTime()), contentFont, 0, 5, Float.valueOf(15.0f), 80, 0);
        }
        PdfPTable pdfPTable3 = new PdfPTable(80);
        tableList.add(pdfPTable3);
        PdfUtil.addCellToTable(pdfPTable3, "\u4f9b\u5e94\u5546\u4e0a\u67b6\u5468\u671f\uff08\u5929\uff09\uff1a" + this.getValueStr(queryPurchaseExecuteBillRspBO.getPurchaseExecuteBillBo().getPutShelfDays()), contentFont, 0, 5, Float.valueOf(15.0f), 80, 0);
        PdfPTable pdfPTable31 = new PdfPTable(80);
        tableList.add(pdfPTable31);
        PdfUtil.addCellToTable(pdfPTable31, "           \u63d0\u793a\uff1a\u751f\u6210\u6210\u4ea4\u901a\u77e5\u548c\u540e\u4f9b\u5e94\u5546\u9700\u5728\u6b64\u65f6\u95f4\u5185\u5b8c\u6210\u5546\u54c1\u5339\u914d\u6ca1\u5426\u5219\u9700\u91cd\u65b0\u9009\u5b9a\u4f9b\u5e94\u5546", contentFont, 0, 5, Float.valueOf(15.0f), 80, 0);
        PdfPTable pdfPTable4 = new PdfPTable(80);
        tableList.add(pdfPTable4);
        PdfUtil.addCellToTable(pdfPTable4, "\u786e\u8ba4\u65b9\u5f0f\uff1a" + this.getValueStr(queryPurchaseExecuteBillRspBO.getPurchaseExecuteBillBo().getConfirmDealTypeName()), contentFont, 0, 5, Float.valueOf(15.0f), 80, 0);
        PdfPTable pdfPTable41 = new PdfPTable(80);
        tableList.add(pdfPTable41);
        PdfUtil.addCellToTable(pdfPTable41, "     " + EnquiryCommonUtil.getConfirmDealTypeTip(queryPurchaseExecuteBillRspBO.getPurchaseExecuteBillBo().getConfirmDealType()), contentFont, 0, 5, Float.valueOf(15.0f), 80, 0);
        PdfPTable pdfPTable42 = new PdfPTable(80);
        tableList.add(pdfPTable42);
        PdfUtil.addCellToTable(pdfPTable42, "\u6e29\u99a8\u63d0\u793a\uff1a\u7ade\u4ef7\u62a5\u4ef7\u65f6\u95f4\u7ed3\u675f\u524d5\u5206\u949f\u5185\u6709\u4f9b\u5e94\u5546\u8fdb\u884c\u518d\u6b21\u62a5\u4ef7\uff0c\u5219\u7ade\u4ef7\u7ed3\u675f\u65f6\u95f4\u81ea\u52a8\u5ef6\u8fdf\u4e94\u5206\u949f\u7ed3\u675f", contentFont, 0, 5, Float.valueOf(15.0f), 80, 0);
        PdfPTable pdfPTable101 = new PdfPTable(80);
        tableList.add(pdfPTable101);
        PdfUtil.addCellToTable(pdfPTable101, null, contentFont, 0, 5, Float.valueOf(20.0f), 80, 0);
        PdfPTable titleTable51 = new PdfPTable(80);
        tableList.add(titleTable51);
        PdfUtil.addCellToTable(titleTable51, "\u62a5\u4ef7\uff08\u660e\u7ec6\u4fe1\u606f\uff09", contentFont, 0, 5, Float.valueOf(40.0f), 80, 0);
        PdfPTable pdfPTable8 = new PdfPTable(83);
        tableList.add(pdfPTable8);
        PdfUtil.addCellToTable(pdfPTable8, "\u5e8f\u53f7", contentFont, 0, 5, Float.valueOf(40.0f), 1, null);
        PdfUtil.addCellToTable(pdfPTable8, "\u7269\u6599\u5c0f\u7c7b", contentFont, 0, 5, Float.valueOf(40.0f), 4, null);
        PdfUtil.addCellToTable(pdfPTable8, "\u7269\u8d44\u7f16\u7801", contentFont, 0, 5, Float.valueOf(40.0f), 4, null);
        PdfUtil.addCellToTable(pdfPTable8, "\u91c7\u8d2d\u7269\u9879\u901a\u7528\u540d\u79f0", contentFont, 0, 5, Float.valueOf(40.0f), 4, null);
        PdfUtil.addCellToTable(pdfPTable8, "\u9700\u6c42\u660e\u7ec6\u7f16\u53f7", contentFont, 0, 5, Float.valueOf(40.0f), 4, null);
        PdfUtil.addCellToTable(pdfPTable8, "\u89c4\u683c\u578b\u53f7", contentFont, 0, 5, Float.valueOf(40.0f), 4, null);
        PdfUtil.addCellToTable(pdfPTable8, "\u6570\u91cf", contentFont, 0, 5, Float.valueOf(40.0f), 3, null);
        PdfUtil.addCellToTable(pdfPTable8, "\u9884\u7b97\u91d1\u989d\uff08\u5143\uff09", contentFont, 0, 5, Float.valueOf(40.0f), 4, null);
        PdfUtil.addCellToTable(pdfPTable8, "\u8981\u6c42\u5230\u8d27\u65e5\u671f", contentFont, 0, 5, Float.valueOf(40.0f), 4, null);
        PdfUtil.addCellToTable(pdfPTable8, "\u62a5\u4ef7\u8f6e\u6b21", contentFont, 0, 5, Float.valueOf(40.0f), 3, null);
        PdfUtil.addCellToTable(pdfPTable8, "\u4f9b\u5e94\u5546", contentFont, 0, 5, Float.valueOf(40.0f), 4, null);
        PdfUtil.addCellToTable(pdfPTable8, "\u662f\u5426\u5df2\u62a5\u4ef7", contentFont, 0, 5, Float.valueOf(40.0f), 3, null);
        PdfUtil.addCellToTable(pdfPTable8, "\u62a5\u4ef7\u603b\u4ef7", contentFont, 0, 5, Float.valueOf(40.0f), 3, null);
        PdfUtil.addCellToTable(pdfPTable8, "\u62a5\u4ef7\u5355\u4ef7", contentFont, 0, 5, Float.valueOf(40.0f), 3, null);
        PdfUtil.addCellToTable(pdfPTable8, "\u627f\u8bfa\u4ea4\u8d27\u671f", contentFont, 0, 5, Float.valueOf(40.0f), 4, null);
        PdfUtil.addCellToTable(pdfPTable8, "\u54c1\u724c", contentFont, 0, 5, Float.valueOf(40.0f), 3, null);
        PdfUtil.addCellToTable(pdfPTable8, "\u5382\u5546", contentFont, 0, 5, Float.valueOf(40.0f), 3, null);
        PdfUtil.addCellToTable(pdfPTable8, "\u5546\u54c1\u578b\u53f7\u6216\u5176\u4ed6\u4fe1\u606f", contentFont, 0, 5, Float.valueOf(40.0f), 3, null);
        PdfUtil.addCellToTable(pdfPTable8, "\u5546\u54c1\u7f16\u7801", contentFont, 0, 5, Float.valueOf(40.0f), 3, null);
        PdfUtil.addCellToTable(pdfPTable8, "\u5916\u90e8\u5546\u54c1\u7f16\u7801", contentFont, 0, 5, Float.valueOf(40.0f), 3, null);
        PdfUtil.addCellToTable(pdfPTable8, "\u534f\u8bae\u660e\u7ec6\u7f16\u7801", contentFont, 0, 5, Float.valueOf(40.0f), 3, null);
        PdfUtil.addCellToTable(pdfPTable8, "UPC\u7801", contentFont, 0, 5, Float.valueOf(40.0f), 3, null);
        PdfUtil.addCellToTable(pdfPTable8, "\u4f9b\u5e94\u5546\u8054\u7cfb\u4eba", contentFont, 0, 5, Float.valueOf(40.0f), 3, null);
        PdfUtil.addCellToTable(pdfPTable8, "\u4f9b\u5e94\u5546\u8054\u7cfb\u7535\u8bdd", contentFont, 0, 5, Float.valueOf(40.0f), 3, null);
        PdfUtil.addCellToTable(pdfPTable8, "\u62a5\u4ef7\u65f6\u95f4", contentFont, 0, 5, Float.valueOf(40.0f), 4, null);
        if (CollUtil.isNotEmpty(executeQuotePlanItemBoList)) {
            int count = 1;
            for (ExecuteQuotePlanItemBo totalBO : executeQuotePlanItemBoList) {
                PurchaseExecuteItemBO purchaseExecuteItemBO = totalBO.getExecuteItemBO();
                List quoteItemList = totalBO.getQuoteItemList();
                Iterator iterator = quoteItemList.iterator();
                while (iterator.hasNext()) {
                    QuotationItemBO quotationItemBO = (QuotationItemBO)iterator.next();
                    PdfPTable pdfPTable9 = new PdfPTable(83);
                    tableList.add(pdfPTable9);
                    PdfUtil.addCellToTable(pdfPTable9, String.valueOf(count), contentFont, 0, 5, Float.valueOf(100.0f), 1, null);
                    PdfUtil.addCellToTable(pdfPTable9, this.getValueStr(purchaseExecuteItemBO.getWxfl() + "-" + purchaseExecuteItemBO.getWxflStr()), contentFont, 0, 5, Float.valueOf(100.0f), 4, null);
                    PdfUtil.addCellToTable(pdfPTable9, this.getValueStr(purchaseExecuteItemBO.getWlbh() + "-" + purchaseExecuteItemBO.getWlbhStr()), contentFont, 0, 5, Float.valueOf(100.0f), 4, null);
                    PdfUtil.addCellToTable(pdfPTable9, this.getValueStr(purchaseExecuteItemBO.getWlmc()), contentFont, 0, 5, Float.valueOf(100.0f), 4, null);
                    PdfUtil.addCellToTable(pdfPTable9, this.getValueStr(purchaseExecuteItemBO.getJhmxbh()), contentFont, 0, 5, Float.valueOf(100.0f), 4, null);
                    PdfUtil.addCellToTable(pdfPTable9, this.getValueStr(purchaseExecuteItemBO.getGgxh()), contentFont, 0, 5, Float.valueOf(100.0f), 4, null);
                    PdfUtil.addCellToTable(pdfPTable9, this.getValueStr(purchaseExecuteItemBO.getSl()), contentFont, 0, 5, Float.valueOf(100.0f), 3, null);
                    PdfUtil.addCellToTable(pdfPTable9, this.getValueStr(purchaseExecuteItemBO.getYsje()), contentFont, 0, 5, Float.valueOf(100.0f), 4, null);
                    PdfUtil.addCellToTable(pdfPTable9, this.getValueStr(purchaseExecuteItemBO.getYqdhrq()), contentFont, 0, 5, Float.valueOf(100.0f), 4, null);
                    PdfUtil.addCellToTable(pdfPTable9, this.getValueStr(quotationItemBO.getQuoteRound()), contentFont, 0, 5, Float.valueOf(100.0f), 3, null);
                    PdfUtil.addCellToTable(pdfPTable9, this.getValueStr(quotationItemBO.getSupplierName()), contentFont, 0, 5, Float.valueOf(100.0f), 4, null);
                    PdfUtil.addCellToTable(pdfPTable9, this.getValueStr(quotationItemBO.getIsQuote()), contentFont, 0, 5, Float.valueOf(100.0f), 3, null);
                    PdfUtil.addCellToTable(pdfPTable9, this.getValueStr(quotationItemBO.getQuoteMoneyStr()), contentFont, 0, 5, Float.valueOf(100.0f), 3, null);
                    PdfUtil.addCellToTable(pdfPTable9, this.getValueStr(quotationItemBO.getQuotePriceStr()), contentFont, 0, 5, Float.valueOf(100.0f), 3, null);
                    PdfUtil.addCellToTable(pdfPTable9, this.getValueStr(quotationItemBO.getPromiseDeliveryDaysStr() == null ? "" : "\u8ba2\u5355\u751f\u6548\u540e:" + quotationItemBO.getPromiseDeliveryDaysStr() + "\u5929"), contentFont, 0, 5, Float.valueOf(100.0f), 4, null);
                    PdfUtil.addCellToTable(pdfPTable9, this.getValueStr(quotationItemBO.getBrand()), contentFont, 0, 5, Float.valueOf(100.0f), 3, null);
                    PdfUtil.addCellToTable(pdfPTable9, this.getValueStr(quotationItemBO.getManufacturer()), contentFont, 0, 5, Float.valueOf(100.0f), 3, null);
                    PdfUtil.addCellToTable(pdfPTable9, this.getValueStr(quotationItemBO.getProductModelAndOther()), contentFont, 0, 5, Float.valueOf(100.0f), 3, null);
                    PdfUtil.addCellToTable(pdfPTable9, this.getValueStr(quotationItemBO.getProductCode()), contentFont, 0, 5, Float.valueOf(100.0f), 3, null);
                    PdfUtil.addCellToTable(pdfPTable9, this.getValueStr(quotationItemBO.getOutsideProductCode()), contentFont, 0, 5, Float.valueOf(100.0f), 3, null);
                    PdfUtil.addCellToTable(pdfPTable9, this.getValueStr(quotationItemBO.getAgreementItemCode()), contentFont, 0, 5, Float.valueOf(100.0f), 3, null);
                    PdfUtil.addCellToTable(pdfPTable9, this.getValueStr(quotationItemBO.getUpcCode()), contentFont, 0, 5, Float.valueOf(100.0f), 3, null);
                    PdfUtil.addCellToTable(pdfPTable9, this.getValueStr(quotationItemBO.getSupplierContactsName()), contentFont, 0, 5, Float.valueOf(100.0f), 3, null);
                    PdfUtil.addCellToTable(pdfPTable9, this.getValueStr(quotationItemBO.getSupplierContactsMobile()), contentFont, 0, 5, Float.valueOf(100.0f), 3, null);
                    PdfUtil.addCellToTable(pdfPTable9, this.getValueStr(quotationItemBO.getQuoteTimeStr()), contentFont, 0, 5, Float.valueOf(100.0f), 4, null);
                }
                ++count;
            }
        }
        PdfPTable pdfPTable10 = new PdfPTable(80);
        tableList.add(pdfPTable10);
        PdfUtil.addCellToTable(pdfPTable10, null, contentFont, 0, 5, Float.valueOf(20.0f), 80, 0);
        PdfPTable titleTable5 = new PdfPTable(80);
        tableList.add(titleTable5);
        PdfUtil.addCellToTable(titleTable5, "\u786e\u8ba4\u6210\u4ea4\uff08\u660e\u7ec6\u4fe1\u606f\uff09", contentFont, 0, 5, Float.valueOf(40.0f), 80, 0);
        PdfPTable pdfPTable9 = new PdfPTable(42);
        tableList.add(pdfPTable9);
        PdfUtil.addCellToTable(pdfPTable9, "\u5e8f\u53f7", contentFont, 0, 5, Float.valueOf(80.0f), 1, null);
        PdfUtil.addCellToTable(pdfPTable9, "\u5546\u54c1\u4e0a\u67b6\u72b6\u6001", contentFont, 0, 5, Float.valueOf(80.0f), 1, null);
        PdfUtil.addCellToTable(pdfPTable9, "\u62a5\u4ef7\u6709\u6548\u671f", contentFont, 0, 5, Float.valueOf(80.0f), 1, null);
        PdfUtil.addCellToTable(pdfPTable9, "\u627f\u8bfa\u4ea4\u8d27\u671f", contentFont, 0, 5, Float.valueOf(80.0f), 1, null);
        PdfUtil.addCellToTable(pdfPTable9, "\u91c7\u8d2d\u7269\u9879\u901a\u7528\u540d\u79f0", contentFont, 0, 5, Float.valueOf(80.0f), 1, null);
        PdfUtil.addCellToTable(pdfPTable9, "\u89c4\u683c\u578b\u53f7", contentFont, 0, 5, Float.valueOf(80.0f), 1, null);
        PdfUtil.addCellToTable(pdfPTable9, "\u62a5\u4ef7\u6570\u91cf", contentFont, 0, 5, Float.valueOf(80.0f), 1, null);
        PdfUtil.addCellToTable(pdfPTable9, "\u62a5\u4ef7\u5355\u4ef7", contentFont, 0, 5, Float.valueOf(80.0f), 1, null);
        PdfUtil.addCellToTable(pdfPTable9, "\u62a5\u4ef7\u603b\u4ef7\uff08\u5143\uff09", contentFont, 0, 5, Float.valueOf(80.0f), 1, null);
        PdfUtil.addCellToTable(pdfPTable9, "\u7269\u6599\u5c0f\u7c7b", contentFont, 0, 5, Float.valueOf(80.0f), 1, null);
        PdfUtil.addCellToTable(pdfPTable9, "\u7269\u8d44\u7f16\u7801", contentFont, 0, 5, Float.valueOf(80.0f), 1, null);
        PdfUtil.addCellToTable(pdfPTable9, "\u54c1\u724c", contentFont, 0, 5, Float.valueOf(80.0f), 1, null);
        PdfUtil.addCellToTable(pdfPTable9, "\u9700\u6c42\u660e\u7ec6\u7f16\u53f7", contentFont, 0, 5, Float.valueOf(80.0f), 1, null);
        PdfUtil.addCellToTable(pdfPTable9, "\u751f\u4ea7\u5382\u5bb6", contentFont, 0, 5, Float.valueOf(80.0f), 1, null);
        PdfUtil.addCellToTable(pdfPTable9, "\u5546\u54c1\u578b\u53f7\u6216\u5176\u4ed6\u4fe1\u606f", contentFont, 0, 5, Float.valueOf(80.0f), 1, null);
        PdfUtil.addCellToTable(pdfPTable9, "\u5546\u54c1\u7f16\u7801", contentFont, 0, 5, Float.valueOf(80.0f), 1, null);
        PdfUtil.addCellToTable(pdfPTable9, "\u5916\u90e8\u5546\u54c1\u7f16\u7801", contentFont, 0, 5, Float.valueOf(80.0f), 1, null);
        PdfUtil.addCellToTable(pdfPTable9, "\u534f\u8bae\u660e\u7ec6\u7f16\u7801", contentFont, 0, 5, Float.valueOf(80.0f), 1, null);
        PdfUtil.addCellToTable(pdfPTable9, "upc\u7801", contentFont, 0, 5, Float.valueOf(80.0f), 1, null);
        PdfUtil.addCellToTable(pdfPTable9, "\u6570\u91cf", contentFont, 0, 5, Float.valueOf(80.0f), 1, null);
        PdfUtil.addCellToTable(pdfPTable9, "\u9884\u7b97\u5355\u4ef7", contentFont, 0, 5, Float.valueOf(80.0f), 1, null);
        PdfUtil.addCellToTable(pdfPTable9, "\u9884\u7b97\u91d1\u989d", contentFont, 0, 5, Float.valueOf(80.0f), 1, null);
        PdfUtil.addCellToTable(pdfPTable9, "\u4ea4\u8d27\u671f\u8981\u6c42", contentFont, 0, 5, Float.valueOf(80.0f), 1, null);
        PdfUtil.addCellToTable(pdfPTable9, "\u6267\u884c\u6807\u51c6", contentFont, 0, 5, Float.valueOf(80.0f), 1, null);
        PdfUtil.addCellToTable(pdfPTable9, "\u63a8\u8350\u54c1\u724c/\u5236\u9020\u5546", contentFont, 0, 5, Float.valueOf(80.0f), 1, null);
        PdfUtil.addCellToTable(pdfPTable9, "\u5b89\u5168\u7b49\u7ea7", contentFont, 0, 5, Float.valueOf(80.0f), 1, null);
        PdfUtil.addCellToTable(pdfPTable9, "\u8d28\u4fdd\u7b49\u7ea7", contentFont, 0, 5, Float.valueOf(80.0f), 1, null);
        PdfUtil.addCellToTable(pdfPTable9, "\u7b2c\u4e09\u65b9\u68c0\u9a8c\u8bc1\u4e66", contentFont, 0, 5, Float.valueOf(80.0f), 1, null);
        PdfUtil.addCellToTable(pdfPTable9, "\u5305\u88c5\u65b9\u5f0f", contentFont, 0, 5, Float.valueOf(80.0f), 1, null);
        PdfUtil.addCellToTable(pdfPTable9, "\u914d\u5957\u670d\u52a1\uff08\u5b89\u88c5\u7b49\uff09", contentFont, 0, 5, Float.valueOf(80.0f), 1, null);
        PdfUtil.addCellToTable(pdfPTable9, "\u8d28\u4fdd\u5468\u671f", contentFont, 0, 5, Float.valueOf(80.0f), 1, null);
        PdfUtil.addCellToTable(pdfPTable9, "\u5176\u4ed6\u6280\u672f\u8981\u6c42", contentFont, 0, 5, Float.valueOf(80.0f), 1, null);
        PdfUtil.addCellToTable(pdfPTable9, "\u5386\u53f2\u91c7\u8d2d\u5355\u4ef7", contentFont, 0, 5, Float.valueOf(80.0f), 1, null);
        PdfUtil.addCellToTable(pdfPTable9, "\u5907\u6ce8", contentFont, 0, 5, Float.valueOf(80.0f), 1, null);
        PdfUtil.addCellToTable(pdfPTable9, "\u53c2\u8003\u5546\u54c1\u7f16\u7801", contentFont, 0, 5, Float.valueOf(80.0f), 1, null);
        PdfUtil.addCellToTable(pdfPTable9, "\u6807\u51c6\u5e93\u76ee\u5f55\u540d\u79f0", contentFont, 0, 5, Float.valueOf(80.0f), 1, null);
        PdfUtil.addCellToTable(pdfPTable9, "\u6700\u9ad8\u9650\u4ef7", contentFont, 0, 5, Float.valueOf(80.0f), 1, null);
        PdfUtil.addCellToTable(pdfPTable9, "\u5b89\u5168\u5e93\u5b58", contentFont, 0, 5, Float.valueOf(80.0f), 1, null);
        PdfUtil.addCellToTable(pdfPTable9, "\u6700\u957f\u4ea4\u8d27\u5468\u671f\uff08\u5929\uff09", contentFont, 0, 5, Float.valueOf(80.0f), 1, null);
        PdfUtil.addCellToTable(pdfPTable9, "\u7269\u8d44\u7f16\u7801\u8ba1\u91cf\u5355\u4f4d", contentFont, 0, 5, Float.valueOf(80.0f), 1, null);
        PdfUtil.addCellToTable(pdfPTable9, "\u786e\u8ba4\u4f9b\u5e94\u5546", contentFont, 0, 5, Float.valueOf(40.0f), 7, null);
        PdfUtil.addCellToTable(pdfPTable9, "\u786e\u8ba4\u5907\u6ce8", contentFont, 0, 5, Float.valueOf(40.0f), 7, null);
        if (CollUtil.isNotEmpty(executeQuotePlanItemBOList)) {
            int count = 1;
            for (EnquiryExecuteQuotePlanItemBO quoteItemBo : executeQuotePlanItemBOList) {
                PdfPTable pdfPTable11 = new PdfPTable(42);
                tableList.add(pdfPTable11);
                PdfUtil.addCellToTable(pdfPTable11, String.valueOf(count), contentFont, 0, 5, Float.valueOf(100.0f), 1, null);
                PdfUtil.addCellToTable(pdfPTable11, this.getValueStr(quoteItemBo.getPutSelfStatus()), contentFont, 0, 5, Float.valueOf(100.0f), 1, null);
                PdfUtil.addCellToTable(pdfPTable11, this.getValueStr(quoteItemBo.getQuotedEffTime()), contentFont, 0, 5, Float.valueOf(100.0f), 1, null);
                PdfUtil.addCellToTable(pdfPTable11, this.getValueStr(quoteItemBo.getPromiseDeliveryDaysName()), contentFont, 0, 5, Float.valueOf(100.0f), 1, null);
                PdfUtil.addCellToTable(pdfPTable11, this.getValueStr(quoteItemBo.getWlmc()), contentFont, 0, 5, Float.valueOf(100.0f), 1, null);
                PdfUtil.addCellToTable(pdfPTable11, this.getValueStr(quoteItemBo.getGgxh()), contentFont, 0, 5, Float.valueOf(100.0f), 1, null);
                PdfUtil.addCellToTable(pdfPTable11, this.getValueStr(quoteItemBo.getQuoteNumbers()), contentFont, 0, 5, Float.valueOf(100.0f), 1, null);
                PdfUtil.addCellToTable(pdfPTable11, this.getValueStr(quoteItemBo.getQuotePrice()), contentFont, 0, 5, Float.valueOf(100.0f), 1, null);
                PdfUtil.addCellToTable(pdfPTable11, this.getValueStr(quoteItemBo.getQuoteMoney()), contentFont, 0, 5, Float.valueOf(100.0f), 1, null);
                PdfUtil.addCellToTable(pdfPTable11, this.getValueStr(quoteItemBo.getWxflName()), contentFont, 0, 5, Float.valueOf(100.0f), 1, null);
                PdfUtil.addCellToTable(pdfPTable11, this.getValueStr(quoteItemBo.getWlbhName()), contentFont, 0, 5, Float.valueOf(100.0f), 1, null);
                PdfUtil.addCellToTable(pdfPTable11, this.getValueStr(quoteItemBo.getBrand()), contentFont, 0, 5, Float.valueOf(100.0f), 1, null);
                PdfUtil.addCellToTable(pdfPTable11, this.getValueStr(quoteItemBo.getJhmxbh()), contentFont, 0, 5, Float.valueOf(100.0f), 1, null);
                PdfUtil.addCellToTable(pdfPTable11, this.getValueStr(quoteItemBo.getManufacturer()), contentFont, 0, 5, Float.valueOf(100.0f), 1, null);
                PdfUtil.addCellToTable(pdfPTable11, this.getValueStr(quoteItemBo.getProductModelAndOther()), contentFont, 0, 5, Float.valueOf(100.0f), 1, null);
                PdfUtil.addCellToTable(pdfPTable11, this.getValueStr(quoteItemBo.getProductCode()), contentFont, 0, 5, Float.valueOf(100.0f), 1, null);
                PdfUtil.addCellToTable(pdfPTable11, this.getValueStr(quoteItemBo.getOutsideProductCode()), contentFont, 0, 5, Float.valueOf(100.0f), 1, null);
                PdfUtil.addCellToTable(pdfPTable11, this.getValueStr(quoteItemBo.getAgreementItemCode()), contentFont, 0, 5, Float.valueOf(100.0f), 1, null);
                PdfUtil.addCellToTable(pdfPTable11, this.getValueStr(quoteItemBo.getUpcCode()), contentFont, 0, 5, Float.valueOf(100.0f), 1, null);
                PdfUtil.addCellToTable(pdfPTable11, this.getValueStr(quoteItemBo.getSl()), contentFont, 0, 5, Float.valueOf(100.0f), 1, null);
                PdfUtil.addCellToTable(pdfPTable11, this.getValueStr(quoteItemBo.getBudgetPrice()), contentFont, 0, 5, Float.valueOf(100.0f), 1, null);
                PdfUtil.addCellToTable(pdfPTable11, this.getValueStr(quoteItemBo.getBudgetMoney()), contentFont, 0, 5, Float.valueOf(100.0f), 1, null);
                PdfUtil.addCellToTable(pdfPTable11, this.getValueStr(quoteItemBo.getYqdhrq()), contentFont, 0, 5, Float.valueOf(100.0f), 1, null);
                PdfUtil.addCellToTable(pdfPTable11, this.getValueStr(quoteItemBo.getZxbz()), contentFont, 0, 5, Float.valueOf(100.0f), 1, null);
                PdfUtil.addCellToTable(pdfPTable11, this.getValueStr(quoteItemBo.getZzsmc()), contentFont, 0, 5, Float.valueOf(100.0f), 1, null);
                PdfUtil.addCellToTable(pdfPTable11, this.getValueStr(quoteItemBo.getAqdj()), contentFont, 0, 5, Float.valueOf(100.0f), 1, null);
                PdfUtil.addCellToTable(pdfPTable11, this.getValueStr(quoteItemBo.getZbdj()), contentFont, 0, 5, Float.valueOf(100.0f), 1, null);
                PdfUtil.addCellToTable(pdfPTable11, this.getValueStr(quoteItemBo.getDsfjczmName()), contentFont, 0, 5, Float.valueOf(100.0f), 1, null);
                PdfUtil.addCellToTable(pdfPTable11, this.getValueStr(quoteItemBo.getBzfsName()), contentFont, 0, 5, Float.valueOf(100.0f), 1, null);
                PdfUtil.addCellToTable(pdfPTable11, this.getValueStr(quoteItemBo.getPtfwName()), contentFont, 0, 5, Float.valueOf(100.0f), 1, null);
                PdfUtil.addCellToTable(pdfPTable11, this.getValueStr(quoteItemBo.getZbzq()), contentFont, 0, 5, Float.valueOf(100.0f), 1, null);
                PdfUtil.addCellToTable(pdfPTable11, this.getValueStr(quoteItemBo.getQtjsyq()), contentFont, 0, 5, Float.valueOf(100.0f), 1, null);
                PdfUtil.addCellToTable(pdfPTable11, this.getValueStr(quoteItemBo.getLscgdj()), contentFont, 0, 5, Float.valueOf(100.0f), 1, null);
                PdfUtil.addCellToTable(pdfPTable11, this.getValueStr(quoteItemBo.getBz()), contentFont, 0, 5, Float.valueOf(100.0f), 1, null);
                PdfUtil.addCellToTable(pdfPTable11, this.getValueStr(quoteItemBo.getCkspbm()), contentFont, 0, 5, Float.valueOf(100.0f), 1, null);
                PdfUtil.addCellToTable(pdfPTable11, this.getValueStr(quoteItemBo.getBzkmlmc()), contentFont, 0, 5, Float.valueOf(100.0f), 1, null);
                PdfUtil.addCellToTable(pdfPTable11, this.getValueStr(quoteItemBo.getZgxj()), contentFont, 0, 5, Float.valueOf(100.0f), 1, null);
                PdfUtil.addCellToTable(pdfPTable11, this.getValueStr(quoteItemBo.getAqkc()), contentFont, 0, 5, Float.valueOf(100.0f), 1, null);
                PdfUtil.addCellToTable(pdfPTable11, this.getValueStr(quoteItemBo.getJhzq()), contentFont, 0, 5, Float.valueOf(100.0f), 1, null);
                PdfUtil.addCellToTable(pdfPTable11, this.getValueStr(quoteItemBo.getDw()), contentFont, 0, 5, Float.valueOf(100.0f), 1, null);
                PdfUtil.addCellToTable(pdfPTable11, this.getValueStr(quoteItemBo.getSupplierName()), contentFont, 0, 5, Float.valueOf(100.0f), 1, null);
                PdfUtil.addCellToTable(pdfPTable11, this.getValueStr(quoteItemBo.getConfirmRemark()), contentFont, 0, 5, Float.valueOf(100.0f), 1, null);
                ++count;
            }
        }
        PdfPTable pdfPTable17 = new PdfPTable(80);
        tableList.add(pdfPTable17);
        PdfUtil.addCellToTable(pdfPTable17, null, contentFont, 0, 5, Float.valueOf(20.0f), 80, 0);
        PdfPTable titleTable18 = new PdfPTable(80);
        tableList.add(titleTable18);
        PdfUtil.addCellToTable(titleTable18, "\u6267\u884c\u8bb0\u5f55", contentFont, 0, 5, Float.valueOf(40.0f), 80, 0);
        PdfPTable pdfPTable19 = new PdfPTable(7);
        tableList.add(pdfPTable19);
        PdfUtil.addCellToTable(pdfPTable19, "\u5e8f\u53f7", contentFont, 0, 5, Float.valueOf(40.0f), 1, null);
        PdfUtil.addCellToTable(pdfPTable19, "\u64cd\u4f5c\u73af\u8282", contentFont, 0, 5, Float.valueOf(40.0f), 1, null);
        PdfUtil.addCellToTable(pdfPTable19, "\u64cd\u4f5c\u884c\u4e3a", contentFont, 0, 5, Float.valueOf(40.0f), 1, null);
        PdfUtil.addCellToTable(pdfPTable19, "\u64cd\u4f5c\u4eba", contentFont, 0, 5, Float.valueOf(40.0f), 1, null);
        PdfUtil.addCellToTable(pdfPTable19, "\u64cd\u4f5c\u65f6\u95f4", contentFont, 0, 5, Float.valueOf(40.0f), 1, null);
        PdfUtil.addCellToTable(pdfPTable19, "\u6240\u5c5e\u5355\u4f4d", contentFont, 0, 5, Float.valueOf(40.0f), 1, null);
        PdfUtil.addCellToTable(pdfPTable19, "\u5904\u7406\u610f\u89c1", contentFont, 0, 5, Float.valueOf(40.0f), 1, null);
        if (CollUtil.isNotEmpty(list)) {
            int count = 1;
            for (BaseAllOperLogBO itemBO : list) {
                PdfPTable pdfPTable11 = new PdfPTable(7);
                tableList.add(pdfPTable11);
                PdfUtil.addCellToTable(pdfPTable11, String.valueOf(count), contentFont, 0, 5, Float.valueOf(80.0f), 1, null);
                PdfUtil.addCellToTable(pdfPTable11, this.getValueStr(itemBO.getOperBehavior()), contentFont, 0, 5, Float.valueOf(80.0f), 1, null);
                PdfUtil.addCellToTable(pdfPTable11, this.getValueStr(itemBO.getBusiStepName()), contentFont, 0, 5, Float.valueOf(80.0f), 1, null);
                PdfUtil.addCellToTable(pdfPTable11, this.getValueStr(itemBO.getOperName()), contentFont, 0, 5, Float.valueOf(80.0f), 1, null);
                PdfUtil.addCellToTable(pdfPTable11, this.getValueStr(itemBO.getOperTime()), contentFont, 0, 5, Float.valueOf(80.0f), 1, null);
                PdfUtil.addCellToTable(pdfPTable11, this.getValueStr(itemBO.getOperOrgName()), contentFont, 0, 5, Float.valueOf(80.0f), 1, null);
                PdfUtil.addCellToTable(pdfPTable11, this.getValueStr(itemBO.getRemark()), contentFont, 0, 5, Float.valueOf(80.0f), 1, null);
                ++count;
            }
        }
        PdfUtil.addTableListToDoc(document, tableList);
        document.close();
        byte[] pdfBytes = byteArrayOutputStream.toByteArray();
        ByteArrayInputStream inputStream = new ByteArrayInputStream(pdfBytes);
        String fileName = UUID.randomUUID().toString().replaceAll("-", "") + ".pdf";
        String path = this.fileClient.uploadFileByInputStream(PATH, fileName, (InputStream)inputStream);
        if (FILE_TYPE_OSS.equals(this.fileType)) {
            exportUrl = this.ossFileUrl + path;
        } else if (FILE_TYPE_FASTDFS.equals(this.fileType)) {
            FastdfsFileInfo fastdfsFileInfo = FastdfsFileInfo.toFastdfsFileInfo((String)path);
            exportUrl = this.fastdfsDownloadUrl + "/" + fastdfsFileInfo.getGroupName() + "/" + fastdfsFileInfo.getFileName();
        } else {
            throw new ZTBusinessException("\u6682\u4e0d\u652f\u6301\u7684\u6587\u4ef6\u670d\u52a1\u5668\u7c7b\u578b");
        }
        return exportUrl;
    }

    private String getValueStr(Object valObj) {
        String valStr = "-";
        if (valObj != null) {
            if (valObj instanceof Date) {
                return DateUtil.format((Date)((Date)valObj), (String)"yyyy-MM-dd HH:mm:ss");
            }
            return valObj.toString();
        }
        return valStr;
    }

    private void doAddTextWatermark(PdfWriter pdfWriter, String userName) {
        ArrayList<WatermarkInfoBO> watermarkInfoList = new ArrayList<WatermarkInfoBO>();
        WatermarkInfoBO watermarkInfoBO = new WatermarkInfoBO();
        watermarkInfoList.add(watermarkInfoBO);
        watermarkInfoBO.setWaterMarkText("\u6253\u5370\u65f6\u95f4\uff1a" + DateUtil.format((Date)new Date(), (String)"yyyy-MM-dd HH:mm:ss"));
        watermarkInfoBO.setX(300.0f);
        watermarkInfoBO.setY(310.0f);
        watermarkInfoBO.setRotation(30.0f);
        watermarkInfoBO = new WatermarkInfoBO();
        watermarkInfoList.add(watermarkInfoBO);
        watermarkInfoBO.setWaterMarkText("\u6253\u5370\u4eba\uff1a" + userName);
        watermarkInfoBO.setX(320.0f);
        watermarkInfoBO.setY(270.0f);
        watermarkInfoBO.setRotation(30.0f);
        watermarkInfoBO = new WatermarkInfoBO();
        watermarkInfoList.add(watermarkInfoBO);
        watermarkInfoBO.setWaterMarkText("\u7f51\u5740\uff1awww.cnncmall.com");
        watermarkInfoBO.setX(340.0f);
        watermarkInfoBO.setY(230.0f);
        watermarkInfoBO.setRotation(30.0f);
        PdfUtil.addTextWatermark(pdfWriter, watermarkInfoList, 0.5f, 0, BaseColor.GRAY, null, 20.0f);
    }

    @PostMapping(value={"printAllPurchaseExecuteBillQueryPdf"})
    public QueryPurchaseExecuteBillRspBO printAllPurchaseExecuteBillQueryPdf(@RequestBody QueryPurchaseExecuteBillReqBO reqBO) {
        QueryPurchaseExecuteBillRspBO rspBO = new QueryPurchaseExecuteBillRspBO();
        QueryPurchaseExecuteListReqBO queryPurchaseExecuteList = new QueryPurchaseExecuteListReqBO();
        queryPurchaseExecuteList.setPlanId(reqBO.getPlanId());
        queryPurchaseExecuteList.setPlanItemId(reqBO.getPlanItemId());
        QueryPurchaseExecuteListRspBO queryPurchaseExecuteListRspBO = this.queryPurchaseExecuteListBusiService.queryPurchaseExecuteListByPlan(queryPurchaseExecuteList);
        if (queryPurchaseExecuteListRspBO == null || CollectionUtils.isEmpty((Collection)queryPurchaseExecuteListRspBO.getRows())) {
            rspBO.setRespCode("8888");
            rspBO.setRespDesc("\u5f53\u524d\u8ba1\u5212\u4e0d\u5b58\u5728\u6267\u884c\u5355\u4fe1\u606f");
            return rspBO;
        }
        ArrayList<String> urlStrList = new ArrayList<String>();
        HashMap<String, String> executeBillUrlStr = new HashMap<String, String>();
        for (PurchaseExecuteBillBo purchaseExecuteBillBo : queryPurchaseExecuteListRspBO.getRows()) {
            reqBO.setExecuteId(purchaseExecuteBillBo.getExecuteId());
            QueryPurchaseExecuteBillRspBO queryPurchaseExecuteBillRspBO = this.purchaseExecuteBillQueryBusiService.queryPurchaseExecuteBill(reqBO);
            if ("2001".equals(queryPurchaseExecuteBillRspBO.getPurchaseExecuteBillBo().getExecuteStatus()) || "2002".equals(queryPurchaseExecuteBillRspBO.getPurchaseExecuteBillBo().getExecuteStatus()) || "2011".equals(queryPurchaseExecuteBillRspBO.getPurchaseExecuteBillBo().getExecuteStatus())) {
                try {
                    GregorianCalendar quoteStartTimeCal;
                    Date quoteStartTime = new Date();
                    Date quoteEndTime = new Date();
                    if (queryPurchaseExecuteBillRspBO.getPurchaseExecuteBillBo().getQuoteTimeDaysAppr() != null) {
                        quoteStartTimeCal = new GregorianCalendar();
                        quoteStartTimeCal.setTime(quoteStartTime);
                        ((Calendar)quoteStartTimeCal).add(5, queryPurchaseExecuteBillRspBO.getPurchaseExecuteBillBo().getQuoteTimeDaysAppr());
                        quoteStartTime = quoteStartTimeCal.getTime();
                    }
                    if (queryPurchaseExecuteBillRspBO.getPurchaseExecuteBillBo().getQuoteTimeAppr() != null) {
                        SimpleDateFormat quoteStartTimeFormat = new SimpleDateFormat("yyyy-MM-dd");
                        SimpleDateFormat quoteStartTimeStrFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
                        String quoteStartTimeStr = quoteStartTimeFormat.format(quoteStartTime);
                        quoteStartTimeStr = quoteStartTimeStr + " " + queryPurchaseExecuteBillRspBO.getPurchaseExecuteBillBo().getQuoteTimeAppr();
                        quoteStartTime = quoteStartTimeStrFormat.parse(quoteStartTimeStr);
                    }
                    if (queryPurchaseExecuteBillRspBO.getPurchaseExecuteBillBo().getQuoteTimeDays() != null) {
                        quoteStartTimeCal = new GregorianCalendar();
                        quoteStartTimeCal.setTime(quoteStartTime);
                        ((Calendar)quoteStartTimeCal).add(5, queryPurchaseExecuteBillRspBO.getPurchaseExecuteBillBo().getQuoteTimeDays());
                        quoteEndTime = quoteStartTimeCal.getTime();
                    }
                    long time = quoteEndTime.getTime() - quoteStartTime.getTime();
                    long hour = time / 3600000L;
                    long min = time / 60000L - hour * 60L;
                    long s = time / 1000L - hour * 60L * 60L - min * 60L;
                    queryPurchaseExecuteBillRspBO.getPurchaseExecuteBillBo().setQuoteTimeLong(hour + "\u5c0f\u65f6" + min + "\u5206" + s + "\u79d2");
                    queryPurchaseExecuteBillRspBO.getPurchaseExecuteBillBo().setQuoteStartTime(quoteStartTime);
                    queryPurchaseExecuteBillRspBO.getPurchaseExecuteBillBo().setQuoteEndTime(quoteEndTime);
                }
                catch (ParseException e) {
                    log.error("\u65f6\u95f4\u683c\u5f0f\u8f6c\u6362\u9519\u8bef");
                }
            }
            EnquiryDealConfirmReqBO enquiryReqBO = new EnquiryDealConfirmReqBO();
            BeanUtils.copyProperties((Object)reqBO, (Object)enquiryReqBO);
            enquiryReqBO.setExecuteId(reqBO.getExecuteId());
            enquiryReqBO.setPlanItemId(reqBO.getPlanItemId());
            enquiryReqBO.setPlanId(reqBO.getPlanId());
            EnquiryDealConfirmItemPageRspBO enquiryRspBO = this.enquiryDealConfirmAbilityService.queryDealConfirmItemList(enquiryReqBO);
            ArrayList<ExecuteQuotePlanItemBo> qryQuotationItemList = new ArrayList<ExecuteQuotePlanItemBo>();
            QryQuotationItemListByPageReqBO quoteItemReqBO = new QryQuotationItemListByPageReqBO();
            quoteItemReqBO.setExecuteId(reqBO.getExecuteId());
            enquiryReqBO.setPlanItemId(reqBO.getPlanItemId());
            enquiryReqBO.setPlanId(reqBO.getPlanId());
            quoteItemReqBO.setPageNo(Integer.valueOf(1));
            quoteItemReqBO.setPageSize(Integer.valueOf(2000));
            QryQuotationItemListByPageRspBO qryQuotationItemListByPageRspBO = this.qryQuotationItemListByPageBusiService.qryQuotationItemListByPage(quoteItemReqBO);
            if (qryQuotationItemListByPageRspBO != null && qryQuotationItemListByPageRspBO.getRows() != null) {
                qryQuotationItemList.addAll(qryQuotationItemListByPageRspBO.getRows());
            }
            if (qryQuotationItemListByPageRspBO != null && qryQuotationItemListByPageRspBO.getTotal() != null && qryQuotationItemListByPageRspBO.getTotal() > 1) {
                for (int i = 2; i < qryQuotationItemListByPageRspBO.getTotal(); ++i) {
                    quoteItemReqBO.setPageNo(Integer.valueOf(2));
                    qryQuotationItemListByPageRspBO = this.qryQuotationItemListByPageBusiService.qryQuotationItemListByPage(quoteItemReqBO);
                    if (qryQuotationItemListByPageRspBO == null || qryQuotationItemListByPageRspBO.getRows() == null) continue;
                    qryQuotationItemList.addAll(qryQuotationItemListByPageRspBO.getRows());
                }
            }
            BaseAllOperLogQueryBO operLogReqBO = new BaseAllOperLogQueryBO();
            operLogReqBO.setRelateId(reqBO.getExecuteId());
            operLogReqBO.setPlanItemId(reqBO.getPlanItemId());
            operLogReqBO.setPlanId(reqBO.getPlanId());
            operLogReqBO.setPageNo(Integer.valueOf(-1));
            BaseAllOperLogPageRspBO baseAllOperLogPageRspBO = this.baseAllOperLogBusiService.queryPurchaseExecuteOperLog(operLogReqBO);
            String url = "";
            url = "1".equals(queryPurchaseExecuteBillRspBO.getPurchaseExecuteBillBo().getExecuteType()) ? this.doPurchaseExecuteQueryPdf(queryPurchaseExecuteBillRspBO, reqBO, enquiryRspBO.getRows(), qryQuotationItemList, baseAllOperLogPageRspBO.getRows()) : this.doBiddingExecuteQueryPdf(queryPurchaseExecuteBillRspBO, reqBO, enquiryRspBO.getRows(), qryQuotationItemList, baseAllOperLogPageRspBO.getRows());
            executeBillUrlStr.put(purchaseExecuteBillBo.getExecuteCode(), url);
            urlStrList.add(url);
        }
        String zipUrl = this.batchDownload(executeBillUrlStr);
        rspBO.setPdfUrl(zipUrl);
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("\u6253\u5305\u4e0b\u8f7d\u6210\u529f");
        return rspBO;
    }

    public String batchDownload(Map<String, String> executeBillUrlStr) {
        String exportUrl;
        block33: {
            String rootPathStr = UUID.randomUUID().toString().replaceAll("-", "") + "temp" + System.currentTimeMillis();
            File directoryFile = new File(rootPathStr);
            if (!directoryFile.exists()) {
                directoryFile.mkdir();
            }
            CloseableHttpClient httpClient = HttpClientBuilder.create().build();
            for (String executeCode : executeBillUrlStr.keySet()) {
                String url = executeBillUrlStr.get(executeCode).replace(this.fastdfsDownloadUrl, this.serverdownloadUrl);
                log.info("\u6279\u91cf\u6587\u4ef6\u4e0b\u8f7d\u5730\u5740\uff1a" + url);
                HttpGet httpGet = new HttpGet(url);
                CloseableHttpResponse response = null;
                InputStream content = null;
                FileOutputStream fileOutputStream = null;
                try {
                    response = httpClient.execute((HttpUriRequest)httpGet);
                    if (response.getStatusLine().getStatusCode() == 200) {
                        int len;
                        HttpEntity responseEntity = response.getEntity();
                        File downloadFile = new File(rootPathStr + "/" + executeCode + "\u6267\u884c\u5355pdf.pdf");
                        content = responseEntity.getContent();
                        fileOutputStream = new FileOutputStream(downloadFile);
                        byte[] buff = new byte[1024];
                        while ((len = content.read(buff)) != -1) {
                            fileOutputStream.write(buff, 0, len);
                        }
                        fileOutputStream.flush();
                        continue;
                    }
                    throw new ZTBusinessException("\u6279\u91cf\u4e0b\u8f7d\u5931\u8d25\uff1a\u8c03\u7528\u94fe\u63a5\u8fd4\u56de\u5931\u8d25\uff01");
                }
                catch (IOException e) {
                    throw new ZTBusinessException("\u6279\u91cf\u4e0b\u8f7d\u5931\u8d25\uff1a\u8c03\u7528\u94fe\u63a5\u5931\u8d25\uff01");
                }
                finally {
                    if (fileOutputStream != null) {
                        try {
                            fileOutputStream.close();
                        }
                        catch (IOException e) {
                            e.printStackTrace();
                        }
                    }
                    if (content != null) {
                        try {
                            content.close();
                        }
                        catch (IOException e) {
                            e.printStackTrace();
                        }
                    }
                    if (response == null) continue;
                    try {
                        response.close();
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                }
            }
            if (httpClient != null) {
                try {
                    httpClient.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
            exportUrl = "";
            try {
                String zipFileName = UUID.randomUUID().toString().replaceAll("-", "") + ".zip";
                File zipFile = new File(rootPathStr + "/" + zipFileName);
                this.generateZipFile(directoryFile.listFiles(), zipFile);
                FileInputStream inputStream = new FileInputStream(zipFile);
                String path = this.fileClient.uploadFileByInputStream(PATH, zipFileName, (InputStream)inputStream);
                if (FILE_TYPE_OSS.equals(this.fileType)) {
                    exportUrl = this.ossFileUrl + path;
                    break block33;
                }
                if (FILE_TYPE_FASTDFS.equals(this.fileType)) {
                    FastdfsFileInfo fastdfsFileInfo = FastdfsFileInfo.toFastdfsFileInfo((String)path);
                    exportUrl = this.fastdfsDownloadUrl + "/" + fastdfsFileInfo.getGroupName() + "/" + fastdfsFileInfo.getFileName();
                    break block33;
                }
                throw new ZTBusinessException("\u6682\u4e0d\u652f\u6301\u7684\u6587\u4ef6\u670d\u52a1\u5668\u7c7b\u578b");
            }
            catch (Exception e) {
                throw new ZTBusinessException("\u6279\u91cf\u4e0b\u8f7d\u5931\u8d25\uff1a\u538b\u7f29\u4e0a\u4f20\u6587\u4ef6\u751f\u6210\u5931\u8d25\uff01");
            }
            finally {
                this.deleteTempFile(directoryFile);
            }
        }
        return exportUrl;
    }

    private boolean deleteTempFile(File file) {
        if (file.isDirectory()) {
            File[] subFiles = file.listFiles();
            if (subFiles != null) {
                int subFileCount = subFiles.length;
                int deleteFileCount = 0;
                for (File subFile : subFiles) {
                    if (!subFile.delete()) continue;
                    ++deleteFileCount;
                }
                if (subFileCount == deleteFileCount) {
                    return file.delete();
                }
                return false;
            }
            return file.delete();
        }
        return file.delete();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void generateZipFile(File[] subFiles, File zipFile) {
        if (!zipFile.exists()) {
            try {
                zipFile.createNewFile();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        FileOutputStream fileOutputStream = null;
        ZipOutputStream zipOutputStream = null;
        FileInputStream fileInputStream = null;
        try {
            fileOutputStream = new FileOutputStream(zipFile);
            zipOutputStream = new ZipOutputStream(fileOutputStream);
            ZipEntry zipEntry = null;
            if (subFiles != null) {
                for (File subFile : subFiles) {
                    int len;
                    fileInputStream = new FileInputStream(subFile);
                    zipEntry = new ZipEntry(subFile.getName());
                    zipOutputStream.putNextEntry(zipEntry);
                    byte[] buff = new byte[1024];
                    while ((len = fileInputStream.read(buff)) != -1) {
                        zipOutputStream.write(buff, 0, len);
                    }
                }
                zipOutputStream.closeEntry();
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        finally {
            try {
                if (zipOutputStream != null) {
                    zipOutputStream.close();
                }
                if (fileOutputStream != null) {
                    fileOutputStream.close();
                }
                if (fileInputStream != null) {
                    fileInputStream.close();
                }
            }
            catch (IOException e) {
                e.printStackTrace();
                throw new ZTBusinessException("\u6279\u91cf\u4e0b\u8f7d\u5931\u8d25\uff1a\u538b\u7f29\u6587\u4ef6\u751f\u6210\u5931\u8d25\uff01");
            }
        }
    }
}

