/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.enquiry.ability.impl;

import cn.hutool.core.bean.BeanUtil;
import com.alibaba.fastjson.JSON;
import com.ohaotian.plugin.db.Page;
import com.tydic.enquiry.api.QryMarginPayListPageService;
import com.tydic.enquiry.api.bo.MarginPayBO;
import com.tydic.enquiry.api.bo.QryMarginPayListPageReqBO;
import com.tydic.enquiry.api.bo.QryMarginPayListPageRspBO;
import com.tydic.enquiry.api.bo.QryMarginPayReqBO;
import com.tydic.enquiry.api.bo.QryMarginPayRspBO;
import com.tydic.enquiry.busi.api.QryMarginPayBusiService;
import com.tydic.enquiry.constant.EnquiryEnumConstant;
import com.tydic.enquiry.dao.DIqrRegistMarginMapper;
import com.tydic.enquiry.dao.po.DIqrRegistMarginPO;
import com.tydic.enquiry.exceptions.BusinessException;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.CollectionUtils;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"ENQUIRY_GROUP/1.0.0/com.tydic.enquiry.api.QryMarginPayListPageService"})
public class QryMarginPayListPageServiceImpl
implements QryMarginPayListPageService {
    private static final Logger log = LoggerFactory.getLogger(QryMarginPayListPageServiceImpl.class);
    @Autowired
    private DIqrRegistMarginMapper dIqrRegistMarginMapper;
    @Autowired
    private QryMarginPayBusiService qryMarginPayBusiService;

    @PostMapping(value={"qryMarginPayListPage"})
    public QryMarginPayListPageRspBO qryMarginPayListPage(@RequestBody QryMarginPayListPageReqBO reqBO) {
        QryMarginPayListPageRspBO rspBO = new QryMarginPayListPageRspBO();
        Page page = new Page(reqBO.getPageNo().intValue(), reqBO.getPageSize().intValue());
        DIqrRegistMarginPO record = new DIqrRegistMarginPO();
        BeanUtil.copyProperties((Object)reqBO, (Object)record);
        record.setOrderBy("REGIST_PKG_ID DESC");
        List<MarginPayBO> marginPayBOS = this.dIqrRegistMarginMapper.selectListPageByCondition(record, (Page<MarginPayBO>)page);
        if (CollectionUtils.isEmpty(marginPayBOS)) {
            rspBO.setRows(marginPayBOS);
            rspBO.setPageNo(Integer.valueOf(page.getPageNo()));
            rspBO.setRecordsTotal(Integer.valueOf(page.getTotalCount()));
            rspBO.setTotal(Integer.valueOf(page.getTotalPages()));
            rspBO.setRespCode("0000");
            rspBO.setRespDesc("\u6210\u529f");
            return rspBO;
        }
        QryMarginPayReqBO qryMarginPayBO = new QryMarginPayReqBO();
        qryMarginPayBO.setSupplierId(reqBO.getSupplierId());
        qryMarginPayBO.setSupId(reqBO.getSupId());
        QryMarginPayRspBO qryMarginPayRspBO = this.qryMarginPayBusiService.qryMarginPay(qryMarginPayBO);
        try {
            log.info("\u4fdd\u8bc1\u91d1\u4fe1\u606f\u67e5\u8be2marginPayBOS=" + JSON.toJSONString(marginPayBOS));
            log.info("\u4fdd\u8bc1\u91d1\u4fe1\u606f\u67e5\u8be2qryMarginPayRspBO=" + JSON.toJSONString((Object)qryMarginPayRspBO));
            for (MarginPayBO marginPayBO : marginPayBOS) {
                if (!StringUtils.isEmpty((CharSequence)marginPayBO.getExecuteType())) {
                    marginPayBO.setExecuteTypeName(EnquiryEnumConstant.ExecuteTypeEnum.getDesc((String)marginPayBO.getExecuteType()));
                }
                if (!StringUtils.isEmpty((CharSequence)marginPayBO.getPayStatus())) {
                    marginPayBO.setPayStatusName(EnquiryEnumConstant.PayStatusEnum.getDesc((String)marginPayBO.getPayStatus()));
                }
                if (qryMarginPayRspBO == null) continue;
                marginPayBO.setReceAccountName(qryMarginPayRspBO.getReceAccountName());
                marginPayBO.setReceBankAccount(qryMarginPayRspBO.getReceBankAccount());
                marginPayBO.setReceBankName(qryMarginPayRspBO.getReceBankName());
            }
        }
        catch (Exception e) {
            throw new BusinessException("7777", "\u5b57\u6bb5\u8f6c\u8bd1\u5931\u8d25", e);
        }
        rspBO.setRows(marginPayBOS);
        rspBO.setPageNo(Integer.valueOf(page.getPageNo()));
        rspBO.setRecordsTotal(Integer.valueOf(page.getTotalCount()));
        rspBO.setTotal(Integer.valueOf(page.getTotalPages()));
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("\u6210\u529f");
        return rspBO;
    }
}

