/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.enquiry.ability.impl;

import com.tydic.enquiry.api.QryMarginPayService;
import com.tydic.enquiry.api.bo.QryMarginPayReqBO;
import com.tydic.enquiry.api.bo.QryMarginPayRspBO;
import com.tydic.enquiry.dao.DIqrRegistMarginMapper;
import com.tydic.enquiry.dao.po.DIqrRegistMarginPO;
import com.tydic.payment.pay.ability.PayProGetMerchantPayeeInfoAbilityService;
import com.tydic.payment.pay.ability.bo.PayProGetMerchantPayeeInfoAbilityReqBo;
import com.tydic.payment.pay.ability.bo.PayProGetMerchantPayeeInfoAbilityRspBo;
import com.tydic.payment.pay.ability.bo.PayProPayInsParaDataBo;
import com.tydic.pfscext.api.pay.QryPayMerchantInfoService;
import com.tydic.pfscext.api.pay.bo.QryPayMerchantInfoReqBO;
import com.tydic.pfscext.api.pay.bo.QryPayMerchantInfoRspBO;
import java.util.Collection;
import java.util.Iterator;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"ENQUIRY_GROUP/1.0.0/com.tydic.enquiry.api.QryMarginPayService"})
public class QryMarginPayServiceImpl
implements QryMarginPayService {
    private static final Logger log = LoggerFactory.getLogger(QryMarginPayServiceImpl.class);
    @Autowired
    QryPayMerchantInfoService qryPayMerchantInfoService;
    @Autowired
    PayProGetMerchantPayeeInfoAbilityService payProGetMerchantPayeeInfoAbilityService;
    @Autowired
    private DIqrRegistMarginMapper dIqrRegistMarginMapper;
    @Value(value="${SYS_PRO_NO:null}")
    private Long proNo;

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @PostMapping(value={"qryMarginPayWindow"})
    public QryMarginPayRspBO qryMarginPayWindow(@RequestBody QryMarginPayReqBO reqBO) {
        QryPayMerchantInfoRspBO qryPayMerchantInfoRspBO;
        QryMarginPayRspBO rspBO = new QryMarginPayRspBO();
        try {
            qryPayMerchantInfoRspBO = this.getPayMerchantInfo();
        }
        catch (Exception e) {
            rspBO.setRespCode("8888");
            rspBO.setRespDesc(e.getMessage());
            return rspBO;
        }
        PayProGetMerchantPayeeInfoAbilityReqBo payProGetMerchantPayeeInfoAbilityReqBo = new PayProGetMerchantPayeeInfoAbilityReqBo();
        payProGetMerchantPayeeInfoAbilityReqBo.setBusiCode(qryPayMerchantInfoRspBO.getBusiCode());
        payProGetMerchantPayeeInfoAbilityReqBo.setMerchantId(String.valueOf(qryPayMerchantInfoRspBO.getMerchantId()));
        payProGetMerchantPayeeInfoAbilityReqBo.setPaymentInsId("19");
        PayProGetMerchantPayeeInfoAbilityRspBo payeeInfo = this.payProGetMerchantPayeeInfoAbilityService.getPayeeInfo(payProGetMerchantPayeeInfoAbilityReqBo);
        if (payeeInfo == null) {
            log.error("\u672a\u83b7\u53d6\u5230\u5546\u6237\u94f6\u884c\u8d26\u6237\u914d\u7f6e\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u8fdb\u884c\u914d\u7f6e");
            rspBO.setRespCode("8888");
            rspBO.setRespDesc("\u672a\u83b7\u53d6\u5230\u5546\u6237\u94f6\u884c\u8d26\u6237\u914d\u7f6e\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u8fdb\u884c\u914d\u7f6e");
            return rspBO;
        }
        rspBO.setReceChannelId(payeeInfo.getPaymentInsId());
        rspBO.setReceChannelName(payeeInfo.getPaymentInsName());
        if (!CollectionUtils.isNotEmpty((Collection)payeeInfo.getPayeeInfos())) {
            log.error("\u672a\u83b7\u53d6\u5230\u5546\u6237\u94f6\u884c\u8d26\u6237\u914d\u7f6e\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u8fdb\u884c\u914d\u7f6e");
            rspBO.setRespCode("8888");
            rspBO.setRespDesc("\u672a\u83b7\u53d6\u5230\u5546\u6237\u94f6\u884c\u8d26\u6237\u914d\u7f6e\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u8fdb\u884c\u914d\u7f6e");
            return rspBO;
        }
        for (PayProPayInsParaDataBo payProPayInsParaDataBo : payeeInfo.getPayeeInfos()) {
            if (payProPayInsParaDataBo.getParameterCode().equals("accountNo")) {
                rspBO.setReceBankAccount(payProPayInsParaDataBo.getParameterValue());
            }
            if (payProPayInsParaDataBo.getParameterCode().equals("accountName")) {
                rspBO.setReceAccountName(payProPayInsParaDataBo.getParameterValue());
            }
            if (!payProPayInsParaDataBo.getParameterCode().equals("icbcBankName")) continue;
            rspBO.setReceBankName(payProPayInsParaDataBo.getParameterValue());
        }
        DIqrRegistMarginPO dIqrRegistMarginPO = new DIqrRegistMarginPO();
        dIqrRegistMarginPO.setExecutePkgId(reqBO.getExecuteId().toString());
        dIqrRegistMarginPO.setSupplierId(reqBO.getSupplierId());
        DIqrRegistMarginPO registMarginPO = this.dIqrRegistMarginMapper.selectByPrimaryInquiryIdandSupId(dIqrRegistMarginPO);
        if (registMarginPO == null) {
            rspBO.setRespCode("8888");
            rspBO.setRespDesc("\u4f9b\u5e94\u5546\u4fdd\u8bc1\u91d1\u7f34\u7eb3\u8bb0\u5f55\u4e0d\u5b58\u5728!");
            return rspBO;
        }
        BeanUtils.copyProperties((Object)registMarginPO, (Object)rspBO);
        rspBO.setProNo(String.valueOf(this.proNo));
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("\u6210\u529f");
        return rspBO;
    }

    private QryPayMerchantInfoRspBO getPayMerchantInfo() throws Exception {
        if (this.proNo == null) {
            throw new Exception("\u83b7\u53d6\u8fd0\u8425\u673a\u6784\u7f16\u53f7\u5931\u8d25");
        }
        QryPayMerchantInfoReqBO qryPayMerchantInfoReqBO = new QryPayMerchantInfoReqBO();
        qryPayMerchantInfoReqBO.setOrgId(this.proNo);
        QryPayMerchantInfoRspBO qryPayMerchantInfoRspBO = this.qryPayMerchantInfoService.qryPayMerchantInfo(qryPayMerchantInfoReqBO);
        if (qryPayMerchantInfoRspBO != null && !"0000".equals(qryPayMerchantInfoRspBO.getRespCode())) {
            throw new Exception("\u672a\u83b7\u53d6\u5230\u5546\u6237\u53ca\u7cfb\u7edf\u7f16\u7801\u914d\u7f6e\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u8fdb\u884c\u914d\u7f6e");
        }
        if (qryPayMerchantInfoRspBO != null && qryPayMerchantInfoRspBO.getMerchantId() == null || StringUtils.isEmpty((CharSequence)qryPayMerchantInfoRspBO.getBusiCode())) {
            throw new Exception("\u672a\u83b7\u53d6\u5230\u5546\u6237\u53ca\u7cfb\u7edf\u7f16\u7801\u914d\u7f6e\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u8fdb\u884c\u914d\u7f6e");
        }
        return qryPayMerchantInfoRspBO;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @PostMapping(value={"qryMarginPay"})
    public QryMarginPayRspBO qryMarginPay(@RequestBody QryMarginPayReqBO reqBO) {
        QryPayMerchantInfoRspBO qryPayMerchantInfoRspBO;
        QryMarginPayRspBO rspBO = new QryMarginPayRspBO();
        try {
            qryPayMerchantInfoRspBO = this.getPayMerchantInfo();
        }
        catch (Exception e) {
            rspBO.setRespCode("8888");
            rspBO.setRespDesc(e.getMessage());
            return rspBO;
        }
        PayProGetMerchantPayeeInfoAbilityReqBo payProGetMerchantPayeeInfoAbilityReqBo = new PayProGetMerchantPayeeInfoAbilityReqBo();
        payProGetMerchantPayeeInfoAbilityReqBo.setBusiCode(qryPayMerchantInfoRspBO.getBusiCode());
        payProGetMerchantPayeeInfoAbilityReqBo.setMerchantId(String.valueOf(qryPayMerchantInfoRspBO.getMerchantId()));
        payProGetMerchantPayeeInfoAbilityReqBo.setPaymentInsId("19");
        PayProGetMerchantPayeeInfoAbilityRspBo payeeInfo = this.payProGetMerchantPayeeInfoAbilityService.getPayeeInfo(payProGetMerchantPayeeInfoAbilityReqBo);
        if (payeeInfo == null) {
            log.error("\u672a\u83b7\u53d6\u5230\u5546\u6237\u94f6\u884c\u8d26\u6237\u914d\u7f6e\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u8fdb\u884c\u914d\u7f6e");
            rspBO.setRespCode("8888");
            rspBO.setRespDesc("\u672a\u83b7\u53d6\u5230\u5546\u6237\u94f6\u884c\u8d26\u6237\u914d\u7f6e\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u8fdb\u884c\u914d\u7f6e");
            return rspBO;
        }
        rspBO.setReceChannelId(payeeInfo.getPaymentInsId());
        rspBO.setReceChannelName(payeeInfo.getPaymentInsName());
        if (!CollectionUtils.isNotEmpty((Collection)payeeInfo.getPayeeInfos())) {
            log.error("\u672a\u83b7\u53d6\u5230\u5546\u6237\u94f6\u884c\u8d26\u6237\u914d\u7f6e\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u8fdb\u884c\u914d\u7f6e");
            rspBO.setRespCode("8888");
            rspBO.setRespDesc("\u672a\u83b7\u53d6\u5230\u5546\u6237\u94f6\u884c\u8d26\u6237\u914d\u7f6e\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u8fdb\u884c\u914d\u7f6e");
            return rspBO;
        }
        Iterator iterator = payeeInfo.getPayeeInfos().iterator();
        while (true) {
            if (!iterator.hasNext()) {
                rspBO.setRespCode("0000");
                rspBO.setRespDesc("\u6210\u529f");
                return rspBO;
            }
            PayProPayInsParaDataBo payProPayInsParaDataBo = (PayProPayInsParaDataBo)iterator.next();
            if (payProPayInsParaDataBo.getParameterCode().equals("accountNo")) {
                rspBO.setReceBankAccount(payProPayInsParaDataBo.getParameterValue());
            }
            if (payProPayInsParaDataBo.getParameterCode().equals("accountName")) {
                rspBO.setReceAccountName(payProPayInsParaDataBo.getParameterValue());
            }
            if (!payProPayInsParaDataBo.getParameterCode().equals("icbcBankName")) continue;
            rspBO.setReceBankName(payProPayInsParaDataBo.getParameterValue());
        }
    }
}

