/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.enquiry.ability.impl;

import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.util.StrUtil;
import com.alibaba.fastjson.JSON;
import com.tydic.agreement.ability.AgrQryAgreementByPageAbilityService;
import com.tydic.agreement.ability.bo.AgrQryAgreementByPageAbilityReqBO;
import com.tydic.agreement.ability.bo.AgrQryAgreementByPageAbilityRspBO;
import com.tydic.agreement.common.bo.AgrAgreementBO;
import com.tydic.enquiry.api.QryProjectInfoListPageAbilityService;
import com.tydic.enquiry.api.bo.ProjectInfoBO;
import com.tydic.enquiry.api.bo.QryProjectInfoListPageReqBO;
import com.tydic.enquiry.api.bo.QryProjectInfoListPageRspBO;
import com.tydic.enquiry.dao.ProjectInfoMapper;
import com.tydic.enquiry.dao.po.ProjectInfoPO;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.util.CollectionUtils;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"ENQUIRY_GROUP/1.0.0/com.tydic.enquiry.api.QryProjectInfoListPageAbilityService"})
public class QryProjectInfoListPageAbilityServiceImpl
implements QryProjectInfoListPageAbilityService {
    @Autowired
    private ProjectInfoMapper projectInfoMapper;
    @Autowired
    private AgrQryAgreementByPageAbilityService agrQryAgreementByPageAbilityService;
    @Value(value="${cnsc_org_id}")
    private Long cnscOrgId;

    @PostMapping(value={"qryProjectInfoListPage"})
    public QryProjectInfoListPageRspBO qryProjectInfoListPage(@RequestBody QryProjectInfoListPageReqBO reqBO) {
        QryProjectInfoListPageRspBO rspBO = new QryProjectInfoListPageRspBO();
        List projectInfoBOS = new ArrayList();
        ProjectInfoPO projectInfoPO = new ProjectInfoPO();
        HashSet<Long> projectIdSet = new HashSet<Long>();
        HashSet<String> projectCodeSet = new HashSet<String>();
        if (reqBO.getProjectId() != null) {
            projectIdSet.add(reqBO.getProjectId());
        }
        if (reqBO.getProjectIdList() != null) {
            projectIdSet.addAll(reqBO.getProjectIdList());
        }
        if (StrUtil.isNotBlank((CharSequence)reqBO.getProjectCode())) {
            projectCodeSet.add(reqBO.getProjectCode());
        }
        if (reqBO.getProjectCodeList() != null) {
            projectCodeSet.addAll(reqBO.getProjectCodeList());
        }
        if (CollUtil.isNotEmpty(projectIdSet)) {
            projectInfoPO.setProjectIdList(CollUtil.newArrayList(projectIdSet));
        }
        if (CollUtil.isNotEmpty(projectCodeSet)) {
            projectInfoPO.setProjectCodeList(CollUtil.newArrayList(projectCodeSet));
        }
        projectInfoPO.setProjectName(reqBO.getProjectName());
        if ("0".equals(reqBO.getIsProfessionalOrgExt())) {
            ArrayList<String> orgIds = new ArrayList<String>();
            if (reqBO.getCompanyId() != null) {
                orgIds.add(reqBO.getCompanyId().toString());
            }
            orgIds.add(this.cnscOrgId.toString());
            projectInfoPO.setDemanderOrgIds(orgIds);
        } else {
            projectInfoPO.setDemanderOrgId(reqBO.getCompanyId() == null ? null : reqBO.getCompanyId().toString());
        }
        List<ProjectInfoPO> poList = this.projectInfoMapper.selectListPageByCondition(projectInfoPO);
        if (!CollectionUtils.isEmpty(poList)) {
            projectInfoBOS = JSON.parseArray((String)JSON.toJSONString(poList), ProjectInfoBO.class);
        }
        rspBO.setProjectInfoList(projectInfoBOS);
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("\u6210\u529f");
        return rspBO;
    }

    @PostMapping(value={"qryProjectInfoListPageWithScope"})
    public QryProjectInfoListPageRspBO qryProjectInfoListPageWithScope(@RequestBody QryProjectInfoListPageReqBO reqBO) {
        QryProjectInfoListPageRspBO rspBO = new QryProjectInfoListPageRspBO();
        HashSet<ProjectInfoBO> projectInfoBOS = new HashSet<ProjectInfoBO>();
        AgrQryAgreementByPageAbilityReqBO agrQryAgreementByPageAbilityReqBO = new AgrQryAgreementByPageAbilityReqBO();
        agrQryAgreementByPageAbilityReqBO.setPageQueryFlag(Boolean.valueOf(false));
        agrQryAgreementByPageAbilityReqBO.setOrgPath(reqBO.getOrgPath());
        AgrQryAgreementByPageAbilityRspBO agrQryAgreementByPageAbilityRspBO = this.agrQryAgreementByPageAbilityService.qryAgreementInfoWithScopeByPage(agrQryAgreementByPageAbilityReqBO);
        if (!agrQryAgreementByPageAbilityRspBO.getRespCode().equals("0000")) {
            rspBO.setRespCode("8888");
            rspBO.setRespDesc("\u534f\u8bae\u5e94\u7528\u8303\u56f4\u67e5\u8be2\u5931\u8d25:" + agrQryAgreementByPageAbilityRspBO.getRespDesc());
            return rspBO;
        }
        ArrayList<Long> projectIdList = new ArrayList<Long>();
        if (!CollectionUtils.isEmpty((Collection)agrQryAgreementByPageAbilityRspBO.getRows())) {
            for (AgrAgreementBO agrAgreementBO : agrQryAgreementByPageAbilityRspBO.getRows()) {
                ProjectInfoBO projectInfoBO = new ProjectInfoBO();
                if (agrAgreementBO.getEcpProjectId() == null || agrAgreementBO.getEcpProjectId().equals("")) continue;
                projectIdList.add(Long.valueOf(agrAgreementBO.getEcpProjectId()));
            }
        }
        ProjectInfoPO projectInfoPO = new ProjectInfoPO();
        projectInfoPO.setProjectId(reqBO.getProjectId());
        projectInfoPO.setProjectName(reqBO.getProjectName());
        projectInfoPO.setDistributionGoodsType("1");
        List<ProjectInfoPO> poList = this.projectInfoMapper.selectListPageByCondition(projectInfoPO);
        if (!CollectionUtils.isEmpty(poList)) {
            for (ProjectInfoPO projectInfoPO1 : poList) {
                ProjectInfoBO projectInfoBO = new ProjectInfoBO();
                projectInfoBO.setProjectId(projectInfoPO1.getProjectId());
                projectInfoBO.setProjectName(projectInfoPO1.getProjectName());
                projectInfoBO.setProjectCode(projectInfoPO1.getProjectCode());
                projectInfoBOS.add(projectInfoBO);
            }
        }
        if (!CollectionUtils.isEmpty(projectIdList)) {
            projectInfoPO.setProjectIdList(projectIdList);
            projectInfoPO.setDistributionGoodsType(null);
            List<ProjectInfoPO> agreeList = this.projectInfoMapper.selectListPageByCondition(projectInfoPO);
            if (!CollectionUtils.isEmpty(agreeList)) {
                for (ProjectInfoPO projectInfoPO1 : agreeList) {
                    ProjectInfoBO projectInfoBO = new ProjectInfoBO();
                    projectInfoBO.setProjectId(projectInfoPO1.getProjectId());
                    projectInfoBO.setProjectName(projectInfoPO1.getProjectName());
                    projectInfoBO.setProjectCode(projectInfoPO1.getProjectCode());
                    projectInfoBOS.add(projectInfoBO);
                }
            }
        }
        rspBO.setProjectInfoList(new ArrayList(projectInfoBOS));
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("\u6210\u529f");
        return rspBO;
    }
}

