/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.enquiry.ability.impl;

import com.ohaotian.plugin.base.exception.ZTBusinessException;
import com.ohaotian.plugin.common.util.DateUtils;
import com.tydic.enquiry.api.RecvRefMarginPayService;
import com.tydic.enquiry.api.bo.RecvRefMarginPayReqBO;
import com.tydic.enquiry.api.bo.RecvRefMarginPayRspBO;
import com.tydic.enquiry.dao.DIqrRegistMarginMapper;
import com.tydic.enquiry.dao.DIqrTransSerialMapper;
import com.tydic.enquiry.dao.po.DIqrRegistMarginPO;
import com.tydic.enquiry.dao.po.DIqrTransSerialPO;
import java.util.Date;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"ENQUIRY_GROUP/1.0.0/com.tydic.enquiry.api.RecvRefMarginPayService"})
public class RecvRefMarginPayServiceImpl
implements RecvRefMarginPayService {
    private static final Logger log = LoggerFactory.getLogger(RecvRefMarginPayServiceImpl.class);
    @Autowired
    private DIqrTransSerialMapper dIqrTransSerialMapper;
    @Autowired
    private DIqrRegistMarginMapper dIqrRegistMarginMapper;

    @Transactional(rollbackFor={Exception.class})
    @PostMapping(value={"submitMarginPay"})
    public RecvRefMarginPayRspBO submitMarginPay(@RequestBody RecvRefMarginPayReqBO reqBO) {
        RecvRefMarginPayRspBO rspBO = new RecvRefMarginPayRspBO();
        Date operDate = new Date();
        DIqrRegistMarginPO dIqrRegistMarginPO = new DIqrRegistMarginPO();
        if (StringUtils.isBlank((CharSequence)reqBO.getOutOrderId())) {
            rspBO.setRespCode("8888");
            rspBO.setRespDesc("\u5916\u90e8\u8ba2\u5355ID\u4e3a\u7a7a!");
            return rspBO;
        }
        List<DIqrRegistMarginPO> registMarginPO = this.dIqrRegistMarginMapper.selectRegistMarginByRegistId(Long.valueOf(reqBO.getOutOrderId()));
        if (CollectionUtils.isEmpty(registMarginPO)) {
            rspBO.setRespCode("8888");
            rspBO.setRespDesc("\u8be5\u5355\u636e\u6ca1\u6709\u4fdd\u8bc1\u91d1\u6570\u636e!");
            return rspBO;
        }
        dIqrRegistMarginPO.setPayStatus("1");
        dIqrRegistMarginPO.setMarginAmount(registMarginPO.get(0).getMarginAmount());
        dIqrRegistMarginPO.setPayUserId(reqBO.getOperId());
        dIqrRegistMarginPO.setOutOrderId(reqBO.getOutOrderId());
        dIqrRegistMarginPO.setMarginOrderId(reqBO.getMarginOrderId());
        dIqrRegistMarginPO.setPayUserName(reqBO.getOperName());
        dIqrRegistMarginPO.setPayDate(operDate);
        dIqrRegistMarginPO.setRegistId(registMarginPO.get(0).getRegistId());
        this.dIqrRegistMarginMapper.updateByPrimaryRegistId(dIqrRegistMarginPO);
        DIqrTransSerialPO dIqrTransSerialPO = new DIqrTransSerialPO();
        BeanUtils.copyProperties((Object)reqBO.getMarginSnBO(), (Object)dIqrTransSerialPO);
        dIqrTransSerialPO.setRegistId(registMarginPO.get(0).getRegistId());
        dIqrTransSerialPO.setCreateDate(new Date());
        dIqrTransSerialPO.setTradeTime(DateUtils.strToDateyyyyMMddHHmmss((String)reqBO.getMarginSnBO().getTradeTime()));
        dIqrTransSerialPO.setPayBusiType(reqBO.getPayFlag());
        dIqrTransSerialPO.setTotalFee(reqBO.getMarginSnBO().getTotalFee());
        dIqrTransSerialPO.setRealFee(reqBO.getMarginSnBO().getRealFee());
        if ("1".equals(reqBO.getPayFlag())) {
            dIqrTransSerialPO.setPayBusiTypeName("\u4ed8\u6b3e");
            dIqrTransSerialPO.setPayOperId(reqBO.getUserId());
            dIqrTransSerialPO.setPayOperName(reqBO.getName());
        } else {
            dIqrTransSerialPO.setPayBusiTypeName("\u9000\u6b3e");
            dIqrTransSerialPO.setOriOutOrderId(reqBO.getExecuteId() + "_" + reqBO.getSupplierId());
            dIqrTransSerialPO.setPayOperId(reqBO.getUserId());
            dIqrTransSerialPO.setPayOperName(reqBO.getName());
            dIqrTransSerialPO.setRefundUserId(reqBO.getUserId());
            dIqrTransSerialPO.setRefundUserName(reqBO.getName());
        }
        int transSnResult = this.dIqrTransSerialMapper.insertSelective(dIqrTransSerialPO);
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("\u6210\u529f");
        return rspBO;
    }

    @PostMapping(value={"updateMarginOutOrderId"})
    public RecvRefMarginPayRspBO updateMarginOutOrderId(@RequestBody RecvRefMarginPayReqBO recvRefMarginPayReqBO) {
        DIqrTransSerialPO dIqrTransSerialQry;
        RecvRefMarginPayRspBO rspBO = new RecvRefMarginPayRspBO();
        if ("1".equals(recvRefMarginPayReqBO.getPayFlag())) {
            DIqrRegistMarginPO dIqrRegistMarginPO = new DIqrRegistMarginPO();
            dIqrRegistMarginPO.setExecutePkgId(recvRefMarginPayReqBO.getExecuteId().toString());
            dIqrRegistMarginPO.setSupplierId(recvRefMarginPayReqBO.getSupplierId());
            DIqrRegistMarginPO registMarginPO = this.dIqrRegistMarginMapper.selectByPrimaryInquiryIdandSupId(dIqrRegistMarginPO);
            if (registMarginPO == null) {
                rspBO.setRespCode("8888");
                rspBO.setRespDesc("\u8be5\u5355\u636e\u6ca1\u6709\u4fdd\u8bc1\u91d1\u6570\u636e!");
                return rspBO;
            }
            dIqrRegistMarginPO.setOutOrderId(recvRefMarginPayReqBO.getOutOrderId());
            dIqrRegistMarginPO.setMarginOrderId(recvRefMarginPayReqBO.getMarginOrderId());
            this.dIqrRegistMarginMapper.updateByPrimaryInquiryIdandSupId(dIqrRegistMarginPO);
        }
        if ("2".equals(recvRefMarginPayReqBO.getPayFlag()) && (dIqrTransSerialQry = this.dIqrTransSerialMapper.selectByPrimaryKey(recvRefMarginPayReqBO.getOutOrderId())) != null && !"190".equals(dIqrTransSerialQry.getPayMethod())) {
            Date operDate = new Date();
            DIqrTransSerialPO dIqrTransSerialPO = new DIqrTransSerialPO();
            BeanUtils.copyProperties((Object)dIqrTransSerialQry, (Object)dIqrTransSerialPO);
            dIqrTransSerialPO.setRegistId(dIqrTransSerialQry.getRegistId());
            dIqrTransSerialPO.setCreateDate(operDate);
            dIqrTransSerialPO.setTradeTime(operDate);
            dIqrTransSerialPO.setPayBusiType(recvRefMarginPayReqBO.getPayFlag());
            dIqrTransSerialPO.setTotalFee(recvRefMarginPayReqBO.getRefundFee());
            dIqrTransSerialPO.setRealFee(recvRefMarginPayReqBO.getRefundFee());
            dIqrTransSerialPO.setPayBusiTypeName("\u9000\u6b3e");
            dIqrTransSerialPO.setRefundUserId(recvRefMarginPayReqBO.getUserId());
            dIqrTransSerialPO.setRefundUserName(recvRefMarginPayReqBO.getUsername());
            dIqrTransSerialPO.setOriOutOrderId(recvRefMarginPayReqBO.getOutOrderId());
            dIqrTransSerialPO.setOutOrderId(recvRefMarginPayReqBO.getRefundOutOrderId());
            int transSnResult = this.dIqrTransSerialMapper.insertSelective(dIqrTransSerialPO);
            if (transSnResult < 0) {
                log.error("==\u8bb0\u5f55\u4ea4\u6613\u6d41\u6c34\u4fe1\u606f\u5931\u8d25\uff01\uff01\uff01\uff1aregistId=" + recvRefMarginPayReqBO.getRegistId());
                throw new ZTBusinessException("\u8bb0\u5f55\u4ea4\u6613\u6d41\u6c34\u4fe1\u606f\u5931\u8d25\uff01\uff01\uff01");
            }
        }
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("\u6210\u529f");
        return rspBO;
    }
}

