/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.enquiry.busi.impl;

import cn.hutool.core.bean.BeanUtil;
import cn.hutool.core.collection.CollUtil;
import com.ohaotian.plugin.db.Page;
import com.tydic.enquiry.api.bo.BasePhaseExecuteBO;
import com.tydic.enquiry.api.bo.BasePhaseItemBO;
import com.tydic.enquiry.api.bo.BasePhaseItemDelReqBO;
import com.tydic.enquiry.api.bo.BasePhaseItemPageRspBO;
import com.tydic.enquiry.api.bo.BasePhaseQueryReqBO;
import com.tydic.enquiry.api.bo.BasePhaseReqBO;
import com.tydic.enquiry.api.bo.BasePhaseRspBO;
import com.tydic.enquiry.busi.api.BasePhaseBusiService;
import com.tydic.enquiry.constant.EnquiryCommonUtil;
import com.tydic.enquiry.constant.EnquiryConstant;
import com.tydic.enquiry.constant.EnquiryEnumConstant;
import com.tydic.enquiry.dao.BasPhaseExecuteItemLogMapper;
import com.tydic.enquiry.dao.BasPhaseExecuteLogMapper;
import com.tydic.enquiry.dao.BasPhaseInfoMapper;
import com.tydic.enquiry.dao.ExecuteItemMapper;
import com.tydic.enquiry.dao.po.BasPhaseExecuteItemLogPO;
import com.tydic.enquiry.dao.po.BasPhaseExecuteLogPO;
import com.tydic.enquiry.dao.po.BasPhaseInfoPO;
import com.tydic.enquiry.dao.po.ExecuteItemPO;
import com.tydic.enquiry.exceptions.BusinessException;
import com.tydic.uac.util.GenerateIdUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class BasePhaseBusiServiceImpl
implements BasePhaseBusiService {
    private static final Logger log = LoggerFactory.getLogger(BasePhaseBusiServiceImpl.class);
    @Autowired
    private BasPhaseInfoMapper basPhaseInfoMapper;
    @Autowired
    private BasPhaseExecuteLogMapper basPhaseExecuteLogMapper;
    @Autowired
    private BasPhaseExecuteItemLogMapper basPhaseExecuteItemLogMapper;
    @Autowired
    private GenerateIdUtil idUtil;
    @Autowired
    private ExecuteItemMapper executeItemMapper;

    @Override
    public BasePhaseRspBO savePhaseInfo(BasePhaseReqBO reqBO) {
        return null;
    }

    @Override
    public BasePhaseRspBO savePhaseExecuteInfo(BasePhaseReqBO reqBO) {
        BasePhaseRspBO rspBO = new BasePhaseRspBO();
        try {
            List executeItemIdList = reqBO.getExecuteItemIdList();
            Map<Long, ExecuteItemPO> itemMap = this.getExecuteItemMap(executeItemIdList);
            ArrayList<BasPhaseExecuteLogPO> addExecuteLogList = new ArrayList<BasPhaseExecuteLogPO>();
            ArrayList<BasPhaseExecuteLogPO> updateExecuteLogList = new ArrayList<BasPhaseExecuteLogPO>();
            ArrayList<BasPhaseExecuteItemLogPO> addExecuteItemLogList = new ArrayList<BasPhaseExecuteItemLogPO>();
            if (CollUtil.isEmpty((Collection)executeItemIdList) && reqBO.getRelateId() != null) {
                executeItemIdList = CollUtil.newArrayList((Object[])new Long[]{Long.valueOf(reqBO.getRelateId())});
            }
            for (Long executeItemId : executeItemIdList) {
                List basePhaseItemList;
                Long executeLogId;
                BasPhaseExecuteLogPO executeLogPO;
                Integer stepNum;
                boolean demandFlow;
                String relateId = EnquiryCommonUtil.valNull(executeItemId);
                ExecuteItemPO itemPO = itemMap.get(executeItemId);
                if (itemPO != null) {
                    String planItemId = EnquiryCommonUtil.valNull(itemPO.getPlanDetailId());
                    reqBO.setPlanItemId(planItemId);
                }
                reqBO.setRelateId(relateId);
                String busiType = reqBO.getBusiType();
                if (busiType == null) {
                    throw new BusinessException("7777", "\u73af\u8282\u7c7b\u578b\u4e0d\u80fd\u4e3a\u7a7a\uff01");
                }
                boolean bl = demandFlow = busiType.equals("2") || busiType.equals("3") || busiType.equals("4");
                if (reqBO.getRelateId() == null) {
                    if ("1".equals(busiType)) {
                        throw new BusinessException("7777", "\u6267\u884c\u5355id\u4e0d\u80fd\u4e3a\u7a7a\uff01");
                    }
                    if (demandFlow) {
                        throw new BusinessException("7777", "\u6267\u884c\u660e\u7ec6id\u4e0d\u80fd\u4e3a\u7a7a\uff01");
                    }
                }
                if ((stepNum = reqBO.getStepNum()) == null) {
                    throw new BusinessException("7777", "\u4f20\u5165\u6267\u884c\u8282\u70b9\u6570\u4e0d\u80fd\u4e3a\u7a7a\uff01");
                }
                int stepOne = 1;
                int stepTwo = 2;
                if (demandFlow) {
                    BasPhaseExecuteLogPO myLogTwo;
                    String defaultBusiType = "3";
                    if (stepNum == stepOne) {
                        busiType = defaultBusiType;
                    } else if (stepNum == stepTwo && (myLogTwo = this.getExecuteLog(reqBO, busiType, stepTwo)) == null && (busiType.equals("2") || busiType.equals("4"))) {
                        BasPhaseExecuteLogPO otherLogOne = this.getExecuteLog(reqBO, defaultBusiType, stepOne);
                        BasPhaseInfoPO myPhaseInfoOne = this.getBasPhaseInfoPO(reqBO, busiType, stepOne);
                        if (otherLogOne != null) {
                            otherLogOne.setPhaseCode(myPhaseInfoOne.getPhaseCode());
                            updateExecuteLogList.add(otherLogOne);
                        }
                    }
                }
                if ((executeLogPO = this.getExecuteLog(reqBO, busiType, stepNum)) == null) {
                    BasPhaseInfoPO phaseInfoPO = this.getBasPhaseInfoPO(reqBO, busiType, stepNum);
                    executeLogPO = new BasPhaseExecuteLogPO();
                    executeLogId = this.idUtil.nextId();
                    executeLogPO.setPhaseExecuteLogId(executeLogId);
                    executeLogPO.setPhaseCode(phaseInfoPO.getPhaseCode());
                    executeLogPO.setRelateId(reqBO.getRelateId());
                    executeLogPO.setPhaseExecuteStatus(reqBO.getStatus());
                    executeLogPO.setExecuteRemarks(reqBO.getRemark());
                    executeLogPO.setDeleteFlag(EnquiryConstant.deleteFlag.NORMAL);
                    executeLogPO.setExtFiled1(reqBO.getPlanItemId());
                    this.setOperateInfo(reqBO, executeLogPO);
                    addExecuteLogList.add(executeLogPO);
                } else {
                    executeLogId = executeLogPO.getPhaseExecuteLogId();
                    executeLogPO.setPhaseExecuteStatus(reqBO.getStatus());
                    executeLogPO.setExecuteRemarks(reqBO.getRemark());
                    executeLogPO.setExtFiled1(reqBO.getPlanItemId());
                    this.setOperateInfo(reqBO, executeLogPO);
                    updateExecuteLogList.add(executeLogPO);
                }
                if (!CollUtil.isNotEmpty((Collection)(basePhaseItemList = reqBO.getPhaseItemList()))) continue;
                int n = 1;
                for (BasePhaseItemBO basePhaseItemBO : basePhaseItemList) {
                    this.checkItemPar(busiType, stepNum, n, basePhaseItemBO);
                    BasPhaseExecuteItemLogPO basPhaseExecuteItemLogPO = new BasPhaseExecuteItemLogPO();
                    BeanUtil.copyProperties((Object)basePhaseItemBO, (Object)basPhaseExecuteItemLogPO);
                    basPhaseExecuteItemLogPO.setPhaseExecuteItemLogId(this.idUtil.nextId());
                    basPhaseExecuteItemLogPO.setPhaseExecuteLogId(executeLogId);
                    basPhaseExecuteItemLogPO.setCreateTime(new Date());
                    addExecuteItemLogList.add(basPhaseExecuteItemLogPO);
                }
            }
            if (CollUtil.isNotEmpty(addExecuteLogList)) {
                this.basPhaseExecuteLogMapper.insertBatch(addExecuteLogList);
            }
            if (CollUtil.isNotEmpty(updateExecuteLogList)) {
                this.basPhaseExecuteLogMapper.updateBatch(updateExecuteLogList);
            }
            if (CollUtil.isNotEmpty(addExecuteItemLogList)) {
                this.basPhaseExecuteItemLogMapper.insertBatch(addExecuteItemLogList);
            }
        }
        catch (Exception e) {
            log.error("\u63d2\u5165\u64cd\u4f5c\u6d41\u7a0b\u65e5\u5fd7\u9519\u8bef", (Throwable)e);
            if (e instanceof BusinessException) {
                BusinessException b = (BusinessException)e;
                rspBO.setRespCode(b.getMsgCode());
                rspBO.setRespDesc(b.getMessage());
            } else {
                rspBO.setRespCode("8888");
                rspBO.setRespDesc(e.toString());
            }
            return rspBO;
        }
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("\u4fdd\u5b58\u6d41\u7a0b\u6267\u884c\u4fe1\u606f\u6210\u529f");
        return rspBO;
    }

    private Map<Long, ExecuteItemPO> getExecuteItemMap(List<Long> executeItemIdList) {
        Map<Long, ExecuteItemPO> itemMap = new HashMap<Long, ExecuteItemPO>();
        if (CollUtil.isNotEmpty(executeItemIdList)) {
            ExecuteItemPO itemQueryPO = new ExecuteItemPO();
            itemQueryPO.setExecuteItemIdList(executeItemIdList);
            List<ExecuteItemPO> executeItemPOList = this.executeItemMapper.selectBy(itemQueryPO);
            if (CollUtil.isNotEmpty(executeItemPOList)) {
                itemMap = executeItemPOList.stream().collect(Collectors.toMap(ExecuteItemPO::getExecuteItemId, e -> e));
            }
        }
        return itemMap;
    }

    @Override
    public BasePhaseRspBO queryPhaseExecuteInfo(BasePhaseQueryReqBO reqBO) {
        Integer flowType = reqBO.getFlowType();
        if (flowType == null) {
            throw new BusinessException("7777", "\u6d41\u7a0b\u7c7b\u578b\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        int execute = 1;
        int demandFlow = 2;
        String relateId = reqBO.getRelateId();
        if (relateId == null) {
            if (flowType == execute) {
                throw new BusinessException("7777", "\u6267\u884c\u5355id\u4e0d\u80fd\u4e3a\u7a7a\uff01");
            }
            if (flowType == demandFlow) {
                throw new BusinessException("7777", "\u6267\u884c\u660e\u7ec6id\u4e0d\u80fd\u4e3a\u7a7a\uff01");
            }
        }
        BasPhaseExecuteLogPO executeLogQueryPO = new BasPhaseExecuteLogPO();
        executeLogQueryPO.setRelateId(relateId);
        List<BasPhaseExecuteLogPO> executeLogPOList = this.basPhaseExecuteLogMapper.selectLogBy(executeLogQueryPO);
        HashMap<Integer, BasPhaseExecuteLogPO> stepMap = new HashMap<Integer, BasPhaseExecuteLogPO>();
        for (BasPhaseExecuteLogPO basPhaseExecuteLogPO : executeLogPOList) {
            stepMap.put(basPhaseExecuteLogPO.getRanking(), basPhaseExecuteLogPO);
        }
        String defaultBusiType = "3";
        BasePhaseRspBO rspBO = new BasePhaseRspBO();
        ArrayList<BasePhaseExecuteBO> phaseExecuteBOList = new ArrayList<BasePhaseExecuteBO>();
        BasPhaseInfoPO phaseInfoQuery = new BasPhaseInfoPO();
        if (flowType == execute) {
            phaseInfoQuery.setBusiType("1");
        } else if (flowType == demandFlow) {
            if (stepMap.containsKey(2)) {
                BasPhaseExecuteLogPO executeLogTwo = (BasPhaseExecuteLogPO)stepMap.get(2);
                phaseInfoQuery.setBusiType(executeLogTwo.getBusiType());
            } else {
                phaseInfoQuery.setBusiType(defaultBusiType);
            }
        }
        List<BasPhaseInfoPO> phaseInfoPOList = this.basPhaseInfoMapper.selectListBy(phaseInfoQuery);
        for (BasPhaseInfoPO basPhaseInfoPO : phaseInfoPOList) {
            Integer stepNum = basPhaseInfoPO.getRanking();
            BasePhaseExecuteBO basePhaseExecuteBO = new BasePhaseExecuteBO();
            basePhaseExecuteBO.setPhaseName(basPhaseInfoPO.getPhaseName());
            basePhaseExecuteBO.setBusiType(basPhaseInfoPO.getBusiType());
            basePhaseExecuteBO.setStepNum(stepNum);
            BasPhaseExecuteLogPO executeLogPO = (BasPhaseExecuteLogPO)stepMap.get(stepNum);
            this.setShowDetail(basePhaseExecuteBO, basPhaseInfoPO);
            this.setShowStatus(basePhaseExecuteBO, basPhaseInfoPO, executeLogPO);
            phaseExecuteBOList.add(basePhaseExecuteBO);
        }
        rspBO.setPhaseExecuteBOList(phaseExecuteBOList);
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("\u6d41\u7a0b\u73af\u8282\u4fe1\u606f\u67e5\u8be2\u6210\u529f");
        return rspBO;
    }

    @Override
    public BasePhaseItemPageRspBO queryExecuteItemInfo(BasePhaseQueryReqBO reqBO) {
        String busiType = reqBO.getBusiType();
        if (busiType == null) {
            throw new BusinessException("7777", "\u73af\u8282\u7c7b\u578b\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        String relateId = reqBO.getRelateId();
        if (relateId == null) {
            throw new BusinessException("7777", "\u6267\u884c\u5355id\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        BasPhaseExecuteItemLogPO executeItemQueryPO = new BasPhaseExecuteItemLogPO();
        executeItemQueryPO.setBusiType(busiType);
        executeItemQueryPO.setRanking(reqBO.getStepNum());
        executeItemQueryPO.setRelateId(relateId);
        Page page = new Page(reqBO.getPageNo().intValue(), reqBO.getPageSize().intValue());
        List<BasPhaseExecuteItemLogPO> itemLogPOList = this.basPhaseExecuteItemLogMapper.selectBy(executeItemQueryPO, (Page<BasPhaseExecuteItemLogPO>)page);
        BasePhaseItemPageRspBO busiRspBO = new BasePhaseItemPageRspBO();
        if (CollUtil.isEmpty(itemLogPOList)) {
            busiRspBO.setRespCode("0000");
            busiRspBO.setRespDesc("\u67e5\u8be2\u7ed3\u679c\u4e3a\u7a7a\uff01");
            return busiRspBO;
        }
        ArrayList<BasePhaseItemBO> rows = new ArrayList<BasePhaseItemBO>();
        for (BasPhaseExecuteItemLogPO itemLogPO : itemLogPOList) {
            BasePhaseItemBO itemBO = new BasePhaseItemBO();
            BeanUtil.copyProperties((Object)itemLogPO, (Object)itemBO);
            itemBO.setNextStepStr(EnquiryEnumConstant.NextStepStatusEnum.getDesc((String)itemBO.getNextStep()));
            rows.add(itemBO);
        }
        busiRspBO.setRows(rows);
        busiRspBO.setTotal(Integer.valueOf(page.getTotalPages()));
        busiRspBO.setRecordsTotal(Integer.valueOf(page.getTotalCount()));
        busiRspBO.setPageNo(Integer.valueOf(page.getPageNo()));
        busiRspBO.setRespCode("0000");
        busiRspBO.setRespDesc("\u8be6\u7ec6\u8fdb\u5ea6\u67e5\u8be2\u6210\u529f\uff01");
        return busiRspBO;
    }

    @Override
    public BasePhaseRspBO deleteExecuteItemInfo(BasePhaseItemDelReqBO reqBO) {
        BasePhaseItemDelReqBO executeItemDelPO = new BasePhaseItemDelReqBO();
        BeanUtil.copyProperties((Object)reqBO, (Object)executeItemDelPO);
        this.basPhaseExecuteItemLogMapper.deleteBy(executeItemDelPO);
        BasePhaseRspBO busiRspBO = new BasePhaseRspBO();
        busiRspBO.setRespCode("0000");
        busiRspBO.setRespDesc("\u8be6\u7ec6\u8fdb\u5ea6\u5220\u9664\u6210\u529f\uff01");
        return busiRspBO;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void setShowStatus(BasePhaseExecuteBO resultBO, BasPhaseInfoPO phaseInfoPO, BasPhaseExecuteLogPO executeLogPO) {
        boolean setUserFlag;
        String noStart = EnquiryEnumConstant.BasPhaseStatusEnum.NOSTART.getCode();
        String working = EnquiryEnumConstant.BasPhaseStatusEnum.WORKING.getCode();
        String finish = EnquiryEnumConstant.BasPhaseStatusEnum.FINISH.getCode();
        String except = EnquiryEnumConstant.BasPhaseStatusEnum.EXCEPT.getCode();
        String busiType = phaseInfoPO.getBusiType();
        Integer setpNum = phaseInfoPO.getRanking();
        if (executeLogPO == null) {
            resultBO.setPhaseExecuteStatus(noStart);
            resultBO.setPhaseExecuteStatusStr(EnquiryEnumConstant.BasPhaseStatusEnum.NOSTART.getDesc());
            boolean setUserFlag2 = this.noShowUser(busiType, setpNum);
            if (!setUserFlag2) return;
        }
        resultBO.setPhaseExecuteStatus(executeLogPO.getPhaseExecuteStatus());
        resultBO.setPhaseExecuteStatusStr(EnquiryEnumConstant.BasPhaseStatusEnum.getDesc((String)executeLogPO.getPhaseExecuteStatus()));
        if (working.equals(executeLogPO.getPhaseExecuteStatus()) && resultBO.getIsShowDetail() == 0) {
            resultBO.setExecuteUserNames(executeLogPO.getCreateUserName());
        }
        if (!finish.equals(executeLogPO.getPhaseExecuteStatus()) && !except.equals(executeLogPO.getPhaseExecuteStatus()) || !(setUserFlag = this.noShowUser(busiType, setpNum))) return;
        resultBO.setExecuteUserNames(executeLogPO.getCreateUserName());
        resultBO.setExecuteTime(executeLogPO.getCreateTime());
        resultBO.setFailReason(executeLogPO.getExecuteRemarks());
    }

    private boolean noShowUser(String busiType, Integer setpNum) {
        boolean setUserFlag = true;
        if ("1".equals(busiType)) {
            if (EnquiryConstant.BasPhaseExecute.THREE.equals(setpNum)) {
                setUserFlag = false;
            }
        } else if ("2".equals(busiType) && EnquiryConstant.BasPhaseCompete.SIX.equals(setpNum)) {
            setUserFlag = false;
        }
        return setUserFlag;
    }

    private void setShowDetail(BasePhaseExecuteBO resultBO, BasPhaseInfoPO basPhaseInfoPO) {
        String busiType = basPhaseInfoPO.getBusiType();
        Integer stepNum = basPhaseInfoPO.getRanking();
        if ("1".equals(busiType)) {
            if (EnquiryConstant.BasPhaseExecute.FIVE.equals(stepNum)) {
                resultBO.setIsShowDetail(Integer.valueOf(1));
            } else if (EnquiryConstant.BasPhaseExecute.SIX.equals(stepNum)) {
                resultBO.setIsShowDetail(Integer.valueOf(1));
            }
        } else if ("2".equals(busiType)) {
            if (EnquiryConstant.BasPhaseCompete.NINE.equals(stepNum)) {
                resultBO.setIsShowDetail(Integer.valueOf(1));
            } else if (EnquiryConstant.BasPhaseCompete.Ten.equals(stepNum)) {
                resultBO.setIsShowDetail(Integer.valueOf(1));
            }
        }
    }

    private BasPhaseInfoPO getBasPhaseInfoPO(BasePhaseReqBO reqBO, String busiType, Integer stepNum) {
        BasPhaseInfoPO phaseInfoQuery = new BasPhaseInfoPO();
        phaseInfoQuery.setBusiType(busiType);
        phaseInfoQuery.setRanking(stepNum);
        List<BasPhaseInfoPO> phaseInfoPOList = this.basPhaseInfoMapper.selectListBy(phaseInfoQuery);
        BasPhaseInfoPO phaseInfoPO = (BasPhaseInfoPO)CollUtil.getFirst(phaseInfoPOList);
        if (phaseInfoPO == null) {
            throw new BusinessException("7777", "\u6d41\u7a0b\u73af\u8282\u4e0d\u5b58\u5728\uff01");
        }
        return phaseInfoPO;
    }

    private BasPhaseExecuteLogPO getExecuteLog(BasePhaseReqBO reqBO, String busiType, Integer stepNum) {
        BasPhaseExecuteLogPO executeLogQueryPO = new BasPhaseExecuteLogPO();
        executeLogQueryPO.setRelateId(reqBO.getRelateId());
        executeLogQueryPO.setBusiType(busiType);
        executeLogQueryPO.setRanking(stepNum);
        List<BasPhaseExecuteLogPO> executeLogPOList = this.basPhaseExecuteLogMapper.selectLogBy(executeLogQueryPO);
        return (BasPhaseExecuteLogPO)CollUtil.getFirst(executeLogPOList);
    }

    private void checkItemPar(String busiType, Integer stepNum, int n, BasePhaseItemBO basePhaseItemBO) {
        String errorMsgPre = "\u7b2c" + n + "\u6761\u6267\u884c\u660e\u7ec6\u4e2d";
        if (basePhaseItemBO.getDealBusId() == null) {
            throw new BusinessException("7777", errorMsgPre + "\u3010dealBusId\u3011\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        if (basePhaseItemBO.getDealBusCode() == null) {
            throw new BusinessException("7777", errorMsgPre + "\u3010dealBusCode\u3011\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        if ("1".equals(busiType)) {
            if (EnquiryConstant.BasPhaseExecute.FIVE.equals(stepNum)) {
                if (basePhaseItemBO.getDemanderOrgName() == null) {
                    throw new BusinessException("7777", errorMsgPre + "\u3010demanderOrgName\u3011\u4e0d\u80fd\u4e3a\u7a7a\uff01");
                }
            } else if (EnquiryConstant.BasPhaseExecute.SIX.equals(stepNum) && basePhaseItemBO.getSupplierName() == null) {
                throw new BusinessException("7777", errorMsgPre + "\u3010supplierName\u3011\u4e0d\u80fd\u4e3a\u7a7a\uff01");
            }
        }
        if (basePhaseItemBO.getNextStep() == null) {
            throw new BusinessException("7777", errorMsgPre + "\u3010nextStep\u3011\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
    }

    private void setOperateInfo(BasePhaseReqBO reqBO, BasPhaseExecuteLogPO executeLogPO) {
        executeLogPO.setCreateUserId(EnquiryCommonUtil.valNull(reqBO.getUserId()));
        executeLogPO.setCreateUserName(reqBO.getName());
        executeLogPO.setCreateTime(new Date());
    }
}

