/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.enquiry.busi.impl;

import com.ohaotian.plugin.db.Sequence;
import com.tydic.enquiry.api.bo.EnquiryPurchaseApprovalExceptionOperateBO;
import com.tydic.enquiry.api.bo.EnquiryPurchaseApprovalExceptionUpdateReqBO;
import com.tydic.enquiry.api.bo.EnquiryPurchaseApprovalExceptionUpdateRspBO;
import com.tydic.enquiry.busi.api.EnquiryApprovalConfigureModifyBusiService;
import com.tydic.enquiry.constant.EnquiryConstant;
import com.tydic.enquiry.dao.PurchaseApprovalConfigureMapper;
import com.tydic.enquiry.dao.PurchaseApprovalExceptionMapper;
import com.tydic.enquiry.dao.po.PurchaseApprovalConfigurePO;
import com.tydic.enquiry.dao.po.PurchaseApprovalExceptionPO;
import com.tydic.enquiry.exceptions.BusinessException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class EnquiryApprovalConfigureModifyBusiServiceImpl
implements EnquiryApprovalConfigureModifyBusiService {
    @Autowired
    private PurchaseApprovalConfigureMapper purchaseApprovalConfigureMapper;
    @Autowired
    private PurchaseApprovalExceptionMapper purchaseApprovalExceptionMapper;

    @Override
    public EnquiryPurchaseApprovalExceptionUpdateRspBO modifyApproval(EnquiryPurchaseApprovalExceptionUpdateReqBO reqBO) {
        EnquiryPurchaseApprovalExceptionUpdateRspBO rspBO = new EnquiryPurchaseApprovalExceptionUpdateRspBO();
        PurchaseApprovalConfigurePO record = new PurchaseApprovalConfigurePO();
        PurchaseApprovalConfigurePO configurePO = this.purchaseApprovalConfigureMapper.selectByPrimaryKey(reqBO.getApprovalId());
        if (configurePO == null) {
            throw new BusinessException("7777", reqBO.getApprovalId() + "\u5ba1\u6838\u914d\u7f6eID\u4e0d\u5b58\u5728\uff01");
        }
        record.setApprovalId(reqBO.getApprovalId());
        record.setIsApproval(reqBO.getIsApproval());
        record.setCreateUserId(reqBO.getUserId());
        record.setCreateUserName(reqBO.getName());
        record.setCreateTime(new Date());
        this.purchaseApprovalConfigureMapper.updateByPrimaryKeySelective(record);
        this.modifyException(reqBO);
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("\u6210\u529f");
        return rspBO;
    }

    private void modifyException(EnquiryPurchaseApprovalExceptionUpdateReqBO reqBO) {
        this.purchaseApprovalExceptionMapper.delByApprovalId(reqBO.getApprovalId());
        ArrayList<PurchaseApprovalExceptionPO> approvalExceptionPOS = new ArrayList<PurchaseApprovalExceptionPO>();
        if (!CollectionUtils.isEmpty((Collection)reqBO.getExceptionBOList())) {
            for (EnquiryPurchaseApprovalExceptionOperateBO bo : reqBO.getExceptionBOList()) {
                PurchaseApprovalExceptionPO po = new PurchaseApprovalExceptionPO();
                BeanUtils.copyProperties((Object)bo, (Object)po);
                po.setDeleteFlag(EnquiryConstant.deleteFlag.NORMAL);
                po.setApprovalId(reqBO.getApprovalId());
                if (null == bo.getExceptionId()) {
                    po.setExceptionId(Sequence.getInstance().nextId());
                }
                approvalExceptionPOS.add(po);
            }
            this.purchaseApprovalExceptionMapper.insertBatch(approvalExceptionPOS);
        }
    }
}

