/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.enquiry.busi.impl;

import com.alibaba.fastjson.JSON;
import com.tydic.enquiry.busi.api.EnquiryActiveAuditOperateService;
import com.tydic.enquiry.busi.api.bo.AuditCreateReqBO;
import com.tydic.enquiry.busi.api.bo.AuditCreateRspBO;
import com.tydic.enquiry.busi.api.bo.InvokeAuditReqBO;
import com.tydic.enquiry.busi.api.bo.InvokeAuditRspBO;
import com.tydic.enquiry.dao.AuditMapper;
import com.tydic.enquiry.dao.po.AuditPO;
import com.tydic.enquiry.exceptions.BusinessException;
import com.tydic.uac.ability.UacNoTaskAuditCreateAbilityService;
import com.tydic.uac.ability.UacNoTaskAuditOrderAuditAbilityService;
import com.tydic.uac.ability.bo.UacNoTaskAuditCreateInfoReqBO;
import com.tydic.uac.ability.bo.UacNoTaskAuditCreateReqBO;
import com.tydic.uac.ability.bo.UacNoTaskAuditCreateRspBO;
import com.tydic.uac.ability.bo.UacNoTaskAuditOrderAuditReqBO;
import com.tydic.uac.ability.bo.UacNoTaskAuditOrderAuditRspBO;
import com.tydic.uac.bo.common.ApprovalObjBO;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class EnquiryAuditOperateServiceImpl
implements EnquiryActiveAuditOperateService {
    private static final Logger log = LoggerFactory.getLogger(EnquiryAuditOperateServiceImpl.class);
    @Autowired
    private UacNoTaskAuditCreateAbilityService uacNoTaskAuditCreateAbilityService;
    @Autowired
    private UacNoTaskAuditOrderAuditAbilityService uacNoTaskAuditOrderAuditAbilityService;
    @Autowired
    private AuditMapper auditMapper;

    @Override
    public AuditCreateRspBO createAuditOrder(AuditCreateReqBO reqBO) {
        AuditCreateRspBO rspBO = new AuditCreateRspBO();
        if (reqBO.getObjType() == null) {
            throw new BusinessException("8888", "\u521b\u5efa\u5ba1\u6279\u5355\u53c2\u6570 objType \u4e3a\u7a7a\uff01");
        }
        if (StringUtils.isBlank((CharSequence)reqBO.getObjId())) {
            throw new BusinessException("8888", "\u521b\u5efa\u5ba1\u6279\u5355\u53c2\u6570 objId \u4e3a\u7a7a\uff01");
        }
        try {
            ArrayList<ApprovalObjBO> approvalObjInfo = new ArrayList<ApprovalObjBO>();
            ApprovalObjBO approvalObjBO = new ApprovalObjBO();
            approvalObjBO.setObjType(reqBO.getObjType());
            approvalObjBO.setObjId(reqBO.getObjId());
            approvalObjInfo.add(approvalObjBO);
            ArrayList<UacNoTaskAuditCreateInfoReqBO> uacNoTaskAuditCreateInfoReqBOs = new ArrayList<UacNoTaskAuditCreateInfoReqBO>();
            UacNoTaskAuditCreateInfoReqBO uacNoTaskAuditCreateInfoReqBO = new UacNoTaskAuditCreateInfoReqBO();
            uacNoTaskAuditCreateInfoReqBO.setObjType(reqBO.getObjType());
            uacNoTaskAuditCreateInfoReqBO.setObjNum(reqBO.getObjNum());
            uacNoTaskAuditCreateInfoReqBO.setOrderId(reqBO.getOrderId());
            uacNoTaskAuditCreateInfoReqBO.setRemark(reqBO.getRemark());
            uacNoTaskAuditCreateInfoReqBO.setApprovalObjInfo(approvalObjInfo);
            uacNoTaskAuditCreateInfoReqBOs.add(uacNoTaskAuditCreateInfoReqBO);
            UacNoTaskAuditCreateReqBO uacNoTaskAuditCreateReqBO = new UacNoTaskAuditCreateReqBO();
            uacNoTaskAuditCreateReqBO.setIsSaveCreateLog(Boolean.valueOf(true));
            uacNoTaskAuditCreateReqBO.setCreateOperDept(reqBO.getOrgName());
            uacNoTaskAuditCreateReqBO.setCreateOperId(reqBO.getUserId());
            uacNoTaskAuditCreateReqBO.setCreateOperName(reqBO.getUserName());
            uacNoTaskAuditCreateReqBO.setCreateBusiReqBO(uacNoTaskAuditCreateInfoReqBOs);
            uacNoTaskAuditCreateReqBO.setProcDefId(reqBO.getProcDefId());
            uacNoTaskAuditCreateReqBO.setProcDefKey(reqBO.getProcDefKey());
            uacNoTaskAuditCreateReqBO.setVariables(reqBO.getVariables());
            log.info("\u8c03\u7528\u5ba1\u6279\u6a21\u5757\u65e0\u6d41\u7a0b\u5ba1\u6279\u5355\u521b\u5efaAPI\u5165\u53c2\uff1a" + JSON.toJSONString((Object)uacNoTaskAuditCreateReqBO));
            UacNoTaskAuditCreateRspBO uacNoTaskAuditCreateRspBO = this.uacNoTaskAuditCreateAbilityService.auditOrderCreate(uacNoTaskAuditCreateReqBO);
            rspBO.setStepId(uacNoTaskAuditCreateRspBO.getStepId());
            log.info("\u8c03\u7528\u5ba1\u6279\u6a21\u5757\u65e0\u6d41\u7a0b\u5ba1\u6279\u5355\u521b\u5efaAPI\u51fa\u53c2\uff1a" + JSON.toJSONString((Object)uacNoTaskAuditCreateRspBO));
            if (!"0000".equals(uacNoTaskAuditCreateRspBO.getRespCode())) {
                throw new BusinessException(uacNoTaskAuditCreateRspBO.getRespCode(), uacNoTaskAuditCreateRspBO.getRespDesc());
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            rspBO.setRespCode("8888");
            rspBO.setRespDesc("\u5ba1\u6279\u6d41\u521b\u5efa\u5931\u8d25:" + e.toString());
            return rspBO;
        }
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("\u6210\u529f");
        return rspBO;
    }

    @Override
    public InvokeAuditRspBO dealAuditOrder(InvokeAuditReqBO reqBO) {
        InvokeAuditRspBO rspBO = new InvokeAuditRspBO();
        if (reqBO.getObjType() == null) {
            throw new BusinessException("8888", "\u5ba1\u6279\u53c2\u6570 objType \u4e3a\u7a7a\uff01");
        }
        if (CollectionUtils.isEmpty(reqBO.getObjIds())) {
            throw new BusinessException("8888", "\u5ba1\u6279\u53c2\u6570 objIds \u4e3a\u7a7a\uff01");
        }
        HashMap<Long, Boolean> auditFinishMap = new HashMap<Long, Boolean>();
        HashMap auditStepIdMap = new HashMap();
        try {
            HashMap<String, HashSet<Long>> result = new HashMap<String, HashSet<Long>>();
            AuditPO auditPO = new AuditPO();
            auditPO.setObjType(reqBO.getObjType());
            auditPO.setObjIds(reqBO.getObjIds());
            auditPO.setTabValue(1);
            auditPO.setStationCodes(reqBO.getStationCodes());
            List<AuditPO> AuditPOs = this.auditMapper.getAuditInfoByObjIds(auditPO);
            if (CollectionUtils.isEmpty(AuditPOs)) {
                throw new BusinessException("8888", "\u6d41\u7a0b\u5ba1\u6279\u5355\u4e0d\u5b58\u5728\uff01");
            }
            HashSet<Long> auditSize = new HashSet<Long>();
            for (AuditPO po : AuditPOs) {
                HashSet<Long> IdSet = (HashSet<Long>)result.get(po.getStepId());
                if (null == IdSet) {
                    IdSet = new HashSet<Long>();
                }
                IdSet.add(po.getObjId());
                result.put(po.getStepId(), IdSet);
                auditSize.add(po.getObjId());
            }
            if (auditSize.size() < reqBO.getObjIds().size()) {
                reqBO.getObjIds().removeAll(auditSize);
                throw new BusinessException("8888", "\u3010" + reqBO.getObjIds() + "\u3011\u4e0d\u5b58\u5728\u6d41\u7a0b\u4fe1\u606f");
            }
            for (String stepId : result.keySet()) {
                ArrayList objIds = new ArrayList((Collection)result.get(stepId));
                UacNoTaskAuditOrderAuditReqBO uacNoTaskAuditOrderAuditReqBO = new UacNoTaskAuditOrderAuditReqBO();
                uacNoTaskAuditOrderAuditReqBO.setObjId(objIds);
                uacNoTaskAuditOrderAuditReqBO.setStepId(stepId);
                uacNoTaskAuditOrderAuditReqBO.setAuditResult(reqBO.getAuditResult());
                uacNoTaskAuditOrderAuditReqBO.setAuditAdvice(reqBO.getAuditAdvice());
                uacNoTaskAuditOrderAuditReqBO.setOperId(reqBO.getUserId().toString());
                uacNoTaskAuditOrderAuditReqBO.setUsername(reqBO.getUserName());
                uacNoTaskAuditOrderAuditReqBO.setOperDept(reqBO.getOrgName());
                uacNoTaskAuditOrderAuditReqBO.setObjType(reqBO.getObjType());
                uacNoTaskAuditOrderAuditReqBO.setMsgFlag(Integer.valueOf(1));
                log.info("\u8c03\u7528\u5ba1\u6279\u6a21\u5757\u65e0\u6d41\u7a0b\u5ba1\u6279\u5355\u5ba1\u6279\u5165\u53c2\uff1a" + JSON.toJSONString((Object)uacNoTaskAuditOrderAuditReqBO));
                UacNoTaskAuditOrderAuditRspBO uacNoTaskAuditOrderAuditRspBO = this.uacNoTaskAuditOrderAuditAbilityService.dealAudit(uacNoTaskAuditOrderAuditReqBO);
                log.info("\u8c03\u7528\u5ba1\u6279\u6a21\u5757\u65e0\u6d41\u7a0b\u5ba1\u6279\u5355\u5ba1\u6279\u51fa\u53c2\uff1a" + JSON.toJSONString((Object)uacNoTaskAuditOrderAuditRspBO));
                if (!"0000".equals(uacNoTaskAuditOrderAuditRspBO.getRespCode())) {
                    throw new BusinessException(uacNoTaskAuditOrderAuditRspBO.getRespCode(), uacNoTaskAuditOrderAuditRspBO.getRespDesc());
                }
                objIds.forEach(objId -> auditFinishMap.put((Long)objId, uacNoTaskAuditOrderAuditRspBO.getNoneInstanceBO().getFinish()));
                objIds.forEach(objId -> auditStepIdMap.put(objId, stepId));
            }
        }
        catch (Exception e) {
            rspBO.setRespCode("8888");
            if (e instanceof BusinessException) {
                rspBO.setRespDesc("\u5ba1\u6279\u5931\u8d25:" + e.getMessage());
            } else {
                rspBO.setRespDesc("\u5ba1\u6279\u5931\u8d25:" + e.toString());
            }
            return rspBO;
        }
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("\u6210\u529f");
        rspBO.setAuditFinishMap(auditFinishMap);
        return rspBO;
    }
}

