/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.enquiry.busi.impl;

import cn.hutool.core.bean.BeanUtil;
import cn.hutool.core.util.NumberUtil;
import com.tydic.enquiry.api.bo.ConfParaBO;
import com.tydic.enquiry.api.bo.EnquiryConfigParaReqBO;
import com.tydic.enquiry.api.bo.EnquiryConfigParaRspBO;
import com.tydic.enquiry.busi.api.EnquiryConfigParaBusiService;
import com.tydic.enquiry.dao.ConfParaPOMapper;
import com.tydic.enquiry.dao.po.ConfParaPO;
import com.tydic.enquiry.exceptions.BusinessException;
import java.util.Date;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class EnquiryConfigParaBusiServiceImpl
implements EnquiryConfigParaBusiService {
    @Autowired
    private ConfParaPOMapper confParaPOMapper;

    @Override
    public EnquiryConfigParaRspBO queryExceptPrice(EnquiryConfigParaReqBO reqBO) {
        ConfParaPO queryPO = new ConfParaPO();
        queryPO.setConfCode("exceptPrice");
        ConfParaPO confParaPO = this.confParaPOMapper.selectBy(queryPO);
        ConfParaBO confParaBO = new ConfParaBO();
        BeanUtil.copyProperties((Object)confParaPO, (Object)confParaBO);
        if (confParaPO != null) {
            confParaBO.setOperateUserId(confParaPO.getCreateUserId());
            confParaBO.setOperateUserName(confParaPO.getCreateUserName());
            confParaBO.setOperateTime(confParaPO.getCreateTime());
            if (confParaPO.getUpdateUserId() != null) {
                confParaBO.setOperateUserId(confParaPO.getUpdateUserId());
                confParaBO.setOperateUserName(confParaPO.getUpdateUserName());
                confParaBO.setOperateTime(confParaPO.getUpdateTime());
            }
        }
        EnquiryConfigParaRspBO rspBO = new EnquiryConfigParaRspBO();
        rspBO.setConfParaBO(confParaBO);
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("\u6210\u529f");
        return rspBO;
    }

    @Override
    public EnquiryConfigParaRspBO updateExceptPrice(EnquiryConfigParaReqBO reqBO) {
        Long confId = reqBO.getConfId();
        if (confId == null) {
            throw new BusinessException("8888", "\u914d\u7f6eid\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        ConfParaPO confParaPO = this.confParaPOMapper.selectByPrimaryKey(confId);
        if (confParaPO == null) {
            throw new BusinessException("8888", "\u5f02\u5e38\u4f4e\u4ef7\u53c2\u6570\u914d\u7f6e\u4e0d\u5b58\u5728\uff01");
        }
        Double confVal = reqBO.getConfVal();
        if ("exceptPrice".equals(confParaPO.getConfCode())) {
            this.checkConfigVal(confVal);
        }
        confParaPO.setConfVal(confVal);
        confParaPO.setUpdateUserId(reqBO.getUserId());
        confParaPO.setUpdateUserName(reqBO.getName());
        confParaPO.setUpdateTime(new Date());
        this.confParaPOMapper.updateByPrimaryKeySelective(confParaPO);
        EnquiryConfigParaRspBO rspBO = new EnquiryConfigParaRspBO();
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("\u6210\u529f");
        return rspBO;
    }

    private void checkConfigVal(Double confVal) {
        if (confVal == null) {
            throw new BusinessException("8888", "\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        String configValStr = String.valueOf(confVal);
        if (NumberUtil.isNumber((CharSequence)configValStr)) {
            if (confVal < 0.0) {
                throw new BusinessException("8888", "\u53c2\u6570\u503c\u4e0d\u80fd\u5c0f\u4e8e0\uff01");
            }
            if (confVal == 0.0) {
                throw new BusinessException("8888", "\u53c2\u6570\u503c\u4e0d\u80fd\u4e3a0\uff01");
            }
            if (confVal > 100.0) {
                throw new BusinessException("8888", "\u53c2\u6570\u503c\u4e0d\u80fd\u5927\u4e8e100\uff01");
            }
            Pattern pattern = Pattern.compile("^(([1-9]{1}\\d*)|([0]{1}))(\\.(\\d){0,2})?$");
            Matcher match = pattern.matcher(configValStr);
            if (!match.matches()) {
                throw new BusinessException("8888", "\u53c2\u6570\u503c\u6700\u591a\u5305\u542b\u4e24\u4f4d\u5c0f\u6570\uff01");
            }
        }
    }
}

