/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.enquiry.busi.impl;

import com.ohaotian.plugin.db.Page;
import com.ohaotian.plugin.db.Sequence;
import com.tydic.enquiry.api.bo.EnquiryCreateQuoteBillReqBO;
import com.tydic.enquiry.api.bo.EnquiryCreateQuoteBillRspBO;
import com.tydic.enquiry.busi.api.EnquiryCreateQuoteBillBusiService;
import com.tydic.enquiry.constant.EnquiryConstant;
import com.tydic.enquiry.dao.ExecuteBillMapper;
import com.tydic.enquiry.dao.ExecuteItemMapper;
import com.tydic.enquiry.dao.ExecuteSupJoinMapper;
import com.tydic.enquiry.dao.SupQuoteItemMapper;
import com.tydic.enquiry.dao.SupQuoteMapper;
import com.tydic.enquiry.dao.po.ExecuteBillPO;
import com.tydic.enquiry.dao.po.ExecuteItemPO;
import com.tydic.enquiry.dao.po.ExecuteSupJoinPO;
import com.tydic.enquiry.dao.po.SupQuoteItemPO;
import com.tydic.enquiry.dao.po.SupQuotePO;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class EnquiryCreateQuoteBillBusiServiceImpl
implements EnquiryCreateQuoteBillBusiService {
    @Autowired
    private ExecuteItemMapper executeItemMapper;
    @Autowired
    private ExecuteBillMapper executeBillMapper;
    @Autowired
    private SupQuoteMapper supQuoteMapper;
    @Autowired
    private ExecuteSupJoinMapper executeSupJoinMapper;
    @Autowired
    private SupQuoteItemMapper supQuoteItemMapper;

    @Override
    public EnquiryCreateQuoteBillRspBO createQuoteBill(EnquiryCreateQuoteBillReqBO reqBO) {
        EnquiryCreateQuoteBillRspBO rspBO = new EnquiryCreateQuoteBillRspBO();
        ExecuteBillPO executeBillPO = this.executeBillMapper.selectByPrimaryKey(reqBO.getExecuteId());
        if (executeBillPO == null) {
            rspBO.setRespCode("8888");
            rspBO.setRespDesc("\u6267\u884c\u5355\u4e0d\u5b58\u5728!");
            return rspBO;
        }
        ExecuteSupJoinPO executeSupJoinPO = new ExecuteSupJoinPO();
        executeSupJoinPO.setExecuteId(reqBO.getExecuteId());
        List<ExecuteSupJoinPO> executeSupJoinPOList = this.executeSupJoinMapper.selectListByCondition(executeSupJoinPO);
        ExecuteItemPO executeItemPO = new ExecuteItemPO();
        executeItemPO.setExecuteId(reqBO.getExecuteId());
        Date now = new Date();
        Page page = new Page(1, 1000);
        List<ExecuteItemPO> executeItemPOList = this.executeItemMapper.qryByPage(executeItemPO, (Page<ExecuteItemPO>)page);
        if (page.getTotalPages() == 1) {
            for (ExecuteSupJoinPO supJoinPO : executeSupJoinPOList) {
                this.insert(executeItemPOList, supJoinPO, reqBO.getExecuteId(), now);
            }
        }
        if (page.getTotalPages() > 1) {
            for (int i = 2; i <= page.getTotalPages(); ++i) {
                page.setPageNo(i);
                executeItemPOList = this.executeItemMapper.qryByPage(executeItemPO, (Page<ExecuteItemPO>)page);
                for (ExecuteSupJoinPO supJoinPO : executeSupJoinPOList) {
                    this.insert(executeItemPOList, supJoinPO, reqBO.getExecuteId(), now);
                }
            }
        }
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("\u6210\u529f");
        return rspBO;
    }

    private void insert(List<ExecuteItemPO> executeItemPOS, ExecuteSupJoinPO executeSupJoinPO, Long executeId, Date date) {
        Long quoteId = Sequence.getInstance().nextId();
        SupQuotePO newSupQuotePO = new SupQuotePO();
        newSupQuotePO.setQuoteId(quoteId);
        newSupQuotePO.setSupplierId(executeSupJoinPO.getSupplierId());
        newSupQuotePO.setSupplierName(executeSupJoinPO.getSupplierName());
        newSupQuotePO.setExecuteId(executeId);
        newSupQuotePO.setQuoteRound(1);
        newSupQuotePO.setQuoteStatus(EnquiryConstant.QuoteStatus.NO);
        newSupQuotePO.setHisStatus(EnquiryConstant.QuoteHisStatus.NOW);
        newSupQuotePO.setDeleteFlag(EnquiryConstant.deleteFlag.NORMAL);
        newSupQuotePO.setCreateTime(date);
        this.supQuoteMapper.insert(newSupQuotePO);
        ArrayList<SupQuoteItemPO> supQuoteItemPOS = new ArrayList<SupQuoteItemPO>();
        for (ExecuteItemPO executeItemPO : executeItemPOS) {
            SupQuoteItemPO supQuoteItemPO = new SupQuoteItemPO();
            supQuoteItemPO.setQuoteId(quoteId);
            supQuoteItemPO.setExecuteId(executeItemPO.getExecuteId());
            supQuoteItemPO.setExecuteItemId(executeItemPO.getExecuteItemId());
            supQuoteItemPO.setPackId(executeItemPO.getPackId());
            supQuoteItemPO.setPlanId(executeItemPO.getPlanId());
            supQuoteItemPO.setPlanDetailId(executeItemPO.getPlanDetailId());
            supQuoteItemPO.setQuoteStatus(EnquiryConstant.QuoteStatus.NO);
            supQuoteItemPO.setDeleteFlag(EnquiryConstant.deleteFlag.NORMAL);
        }
        this.supQuoteItemMapper.insertBatch(supQuoteItemPOS);
    }
}

