/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.enquiry.busi.impl;

import cn.hutool.core.bean.BeanUtil;
import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.util.NumberUtil;
import com.ohaotian.plugin.db.Page;
import com.tydic.enquiry.api.bo.BaseAllOperLogReqBO;
import com.tydic.enquiry.api.bo.BaseAllOperLogRspBO;
import com.tydic.enquiry.api.bo.BasePhaseItemBO;
import com.tydic.enquiry.api.bo.BasePhaseReqBO;
import com.tydic.enquiry.api.bo.CodeEnquiryReqBO;
import com.tydic.enquiry.api.bo.CodeEnquiryRspBO;
import com.tydic.enquiry.api.bo.DealConfirmReviewBO;
import com.tydic.enquiry.api.bo.EnquiryConfirmBO;
import com.tydic.enquiry.api.bo.EnquiryConfirmReviewDetailRspBO;
import com.tydic.enquiry.api.bo.EnquiryDealConfirmResultRspBO;
import com.tydic.enquiry.api.bo.EnquiryDealConfirmReviewPageRspBO;
import com.tydic.enquiry.api.bo.EnquiryDealConfirmReviewReqBO;
import com.tydic.enquiry.api.bo.EnquiryDealConfirmReviewRspBO;
import com.tydic.enquiry.api.bo.EnquiryDealNoticePageRspBO;
import com.tydic.enquiry.api.bo.EnquiryDealNoticeQueryReqBO;
import com.tydic.enquiry.api.bo.EnquiryDealNoticeReqBO;
import com.tydic.enquiry.api.bo.EnquiryDealNoticeRspBO;
import com.tydic.enquiry.api.bo.EnquiryExecuteItemRspBO;
import com.tydic.enquiry.api.bo.EnquiryLogReqBO;
import com.tydic.enquiry.api.bo.EnquiryPlanCodePageRspBO;
import com.tydic.enquiry.api.bo.UpdateExecuteItemStatusReqBO;
import com.tydic.enquiry.busi.api.BaseAllOperLogBusiService;
import com.tydic.enquiry.busi.api.EnquiryActiveAuditOperateService;
import com.tydic.enquiry.busi.api.EnquiryDealConfirmDetailBusiService;
import com.tydic.enquiry.busi.api.EnquiryDealConfirmReviewBusiService;
import com.tydic.enquiry.busi.api.EnquiryDealNoticeBusiService;
import com.tydic.enquiry.busi.api.EnquiryExecuteItemBusiService;
import com.tydic.enquiry.busi.api.bo.AuditCreateReqBO;
import com.tydic.enquiry.busi.api.bo.AuditCreateRspBO;
import com.tydic.enquiry.busi.api.bo.DealConfirmReviewBusiBO;
import com.tydic.enquiry.busi.api.bo.DealConfirmReviewBusiReqBO;
import com.tydic.enquiry.busi.api.bo.DealPlanSupplierBusiBO;
import com.tydic.enquiry.busi.api.bo.InvokeAuditReqBO;
import com.tydic.enquiry.busi.api.bo.InvokeAuditRspBO;
import com.tydic.enquiry.busi.api.sequence.SeqCodeCreateBusiService;
import com.tydic.enquiry.busi.utils.BigDecimalUtils;
import com.tydic.enquiry.common.EnquiryReqBO;
import com.tydic.enquiry.constant.EnquiryCommonUtil;
import com.tydic.enquiry.constant.EnquiryConstant;
import com.tydic.enquiry.constant.EnquiryEnumConstant;
import com.tydic.enquiry.dao.DealConfirmItemMapper;
import com.tydic.enquiry.dao.DealConfirmMapper;
import com.tydic.enquiry.dao.DealConfirmReviewItemMapper;
import com.tydic.enquiry.dao.DealConfirmReviewMapper;
import com.tydic.enquiry.dao.ExecuteBillMapper;
import com.tydic.enquiry.dao.ExecuteConfirmMemMapper;
import com.tydic.enquiry.dao.ExecuteItemMapper;
import com.tydic.enquiry.dao.PurchaseApprovalConfigureMapper;
import com.tydic.enquiry.dao.PurchaseApprovalExceptionMapper;
import com.tydic.enquiry.dao.po.DealConfirmItemPO;
import com.tydic.enquiry.dao.po.DealConfirmPO;
import com.tydic.enquiry.dao.po.DealConfirmReviewItemPO;
import com.tydic.enquiry.dao.po.DealConfirmReviewPO;
import com.tydic.enquiry.dao.po.ExecuteBillPO;
import com.tydic.enquiry.dao.po.ExecuteConfirmMemPO;
import com.tydic.enquiry.dao.po.ExecuteItemPO;
import com.tydic.enquiry.dao.po.PurchaseApprovalConfigurePO;
import com.tydic.enquiry.dao.po.PurchaseApprovalExceptionPO;
import com.tydic.enquiry.exceptions.BusinessException;
import com.tydic.order.extend.constant.PebExtConstant;
import com.tydic.uac.util.GenerateIdUtil;
import com.tydic.umcext.ability.org.UmcZhEnterpriseOrgQueryAbilityService;
import com.tydic.umcext.ability.org.bo.UmcZhEnterpriseOrgAbilityBO;
import com.tydic.umcext.ability.org.bo.UmcZhEnterpriseOrgDetailAbilityRspBO;
import com.tydic.umcext.ability.org.bo.UmcZhEnterpriseOrgQueryAbilityReqBO;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class EnquiryDealConfirmReviewBusiServiceImpl
implements EnquiryDealConfirmReviewBusiService {
    private static final Logger log = LoggerFactory.getLogger(EnquiryDealConfirmReviewBusiServiceImpl.class);
    @Autowired
    private GenerateIdUtil idUtil;
    @Autowired
    DealConfirmMapper dealConfirmMapper;
    @Autowired
    DealConfirmItemMapper dealConfirmItemMapper;
    @Autowired
    DealConfirmReviewMapper dealConfirmReviewMapper;
    @Autowired
    DealConfirmReviewItemMapper dealConfirmReviewItemMapper;
    @Autowired
    ExecuteItemMapper executeItemMapper;
    @Autowired
    ExecuteBillMapper executeBillMapper;
    @Autowired
    EnquiryDealConfirmDetailBusiService enquiryDealConfirmDetailBusiService;
    @Autowired
    EnquiryDealNoticeBusiService enquiryDealNoticeBusiService;
    @Autowired
    private UmcZhEnterpriseOrgQueryAbilityService umcZhEnterpriseOrgQueryAbilityService;
    @Autowired
    EnquiryActiveAuditOperateService enquiryActiveAuditOperateService;
    @Autowired
    ExecuteConfirmMemMapper executeConfirmMemMapper;
    @Autowired
    private BaseAllOperLogBusiService baseAllOperLogBusiService;
    @Autowired
    private EnquiryExecuteItemBusiService executeItemBusiService;
    @Autowired
    private SeqCodeCreateBusiService seqCodeCreateBusiService;
    @Autowired
    PurchaseApprovalConfigureMapper purchaseApprovalConfigureMapper;
    @Autowired
    private PurchaseApprovalExceptionMapper purchaseApprovalExceptionMapper;
    private static final Byte PURCHASE_BYTE = new Byte("1");
    private static final Byte OPERATE_BYTE = new Byte("2");

    @Override
    public EnquiryDealConfirmReviewRspBO saveConfirmReviewInfo(EnquiryDealConfirmReviewReqBO reqBO) {
        List<PurchaseApprovalExceptionPO> exceptionPOList;
        EnquiryDealConfirmReviewRspBO busiRspBO = new EnquiryDealConfirmReviewRspBO();
        Long confirmTempId = reqBO.getDealConfirmId();
        DealConfirmPO confirmPO = this.dealConfirmMapper.selectByPrimaryKey(confirmTempId);
        if (confirmPO == null) {
            busiRspBO.setRespCode("8888");
            busiRspBO.setRespDesc("\u786e\u8ba4\u6210\u4ea4\u8bb0\u5f55\u4e0d\u5b58\u5728\uff01");
            return busiRspBO;
        }
        Long executeId = confirmPO.getExecuteId();
        ExecuteBillPO executeBillPO = this.executeBillMapper.selectByPrimaryKey(executeId);
        if (executeBillPO == null) {
            busiRspBO.setRespCode("8888");
            busiRspBO.setRespDesc("\u6267\u884c\u5355\u4e0d\u5b58\u5728\uff01");
            return busiRspBO;
        }
        String executeOrgId = executeBillPO.getExecuteOrgId();
        Byte executeOrgType = null;
        UmcZhEnterpriseOrgQueryAbilityReqBO umcZhEnterpriseOrgQueryAbilityReqBO = new UmcZhEnterpriseOrgQueryAbilityReqBO();
        umcZhEnterpriseOrgQueryAbilityReqBO.setOrgIdWeb(Long.valueOf(Long.parseLong(executeOrgId)));
        UmcZhEnterpriseOrgDetailAbilityRspBO umcZhEnterpriseOrgDetailAbilityRspBO = this.umcZhEnterpriseOrgQueryAbilityService.queryEnterpriseOrgByDetail(umcZhEnterpriseOrgQueryAbilityReqBO);
        if ("0000".equals(umcZhEnterpriseOrgDetailAbilityRspBO.getRespCode())) {
            UmcZhEnterpriseOrgAbilityBO orgAbilityBO = umcZhEnterpriseOrgDetailAbilityRspBO.getUmcEnterpriseOrgAbilityBO();
            if (orgAbilityBO != null) {
                String orgType = orgAbilityBO.getIsProfessionalOrg();
                if ("0".equals(orgType)) {
                    executeOrgType = OPERATE_BYTE;
                } else if ("1".equals(orgType)) {
                    executeOrgType = PURCHASE_BYTE;
                }
                log.info("executeOrgType:" + executeOrgType);
            }
        } else {
            busiRspBO.setRespCode("8888");
            busiRspBO.setRespDesc(umcZhEnterpriseOrgDetailAbilityRspBO.getRespDesc());
            return busiRspBO;
        }
        confirmPO.setExecuteOrgType(executeOrgType);
        PurchaseApprovalConfigurePO purchaseApprovalConfigurePO = new PurchaseApprovalConfigurePO();
        purchaseApprovalConfigurePO.setCode("confirmApproval");
        List<PurchaseApprovalConfigurePO> configurePOList = this.purchaseApprovalConfigureMapper.qryList(purchaseApprovalConfigurePO);
        if (CollUtil.isEmpty(configurePOList)) {
            busiRspBO.setRespCode("8888");
            busiRspBO.setRespDesc("\u6210\u4ea4\u786e\u8ba4\u5ba1\u6279\u914d\u7f6e\u4e0d\u5b58\u5728\uff01");
            return busiRspBO;
        }
        PurchaseApprovalConfigurePO configurePO = (PurchaseApprovalConfigurePO)CollUtil.getFirst(configurePOList);
        int isApproval = configurePO.getIsApproval().intValue();
        if (PURCHASE_BYTE.equals(executeOrgType) && CollUtil.isNotEmpty(exceptionPOList = this.getExceptionOrgList(CollUtil.newArrayList((Object[])new String[]{executeOrgId})))) {
            PurchaseApprovalExceptionPO exceptionPO = (PurchaseApprovalExceptionPO)CollUtil.getFirst(exceptionPOList);
            isApproval = exceptionPO.getIsApproval().intValue();
        }
        if (isApproval == 1) {
            return this.dealConfirmApprovalInfo(reqBO, confirmPO);
        }
        return this.dealNoApprovalInfo(reqBO, confirmPO, executeBillPO);
    }

    private EnquiryDealConfirmReviewRspBO dealConfirmApprovalInfo(EnquiryDealConfirmReviewReqBO reqBO, DealConfirmPO confirmPO) {
        EnquiryDealConfirmReviewRspBO busiRspBO = new EnquiryDealConfirmReviewRspBO();
        DealConfirmItemPO confirmItemQueryPO = new DealConfirmItemPO();
        confirmItemQueryPO.setDealConfirmId(confirmPO.getDealConfirmId());
        List<DealConfirmItemPO> confirmItemList = this.dealConfirmItemMapper.selectListBy(confirmItemQueryPO);
        if (CollUtil.isEmpty(confirmItemList)) {
            busiRspBO.setRespCode("8888");
            busiRspBO.setRespDesc(confirmPO.getDealConfirmId() + "\u6210\u4ea4\u660e\u7ec6\u4e0d\u5b58\u5728\uff01");
            return busiRspBO;
        }
        List<Long> itemIdList = confirmItemList.stream().map(DealConfirmItemPO::getExecuteItemId).collect(Collectors.toList());
        ExecuteItemPO itemQueryPO = new ExecuteItemPO();
        itemQueryPO.setExecuteItemIdList(itemIdList);
        List<ExecuteItemPO> itemPOList = this.executeItemMapper.selectBy(itemQueryPO);
        Set orgIdSet = itemPOList.stream().map(ExecuteItemPO::getDemandOrgId).collect(Collectors.toSet());
        HashSet<String> executeUserIdSet = new HashSet<String>();
        HashMap<Long, ExecuteItemPO> executeItemMap = new HashMap<Long, ExecuteItemPO>();
        List<PurchaseApprovalExceptionPO> exceptionPOList = this.getExceptionOrgList(CollUtil.newArrayList(orgIdSet));
        Set<Object> noUnitIdSet = new HashSet();
        if (CollUtil.isNotEmpty(exceptionPOList)) {
            noUnitIdSet = exceptionPOList.stream().map(PurchaseApprovalExceptionPO::getUnitId).collect(Collectors.toSet());
        }
        for (ExecuteItemPO executeItemPO : itemPOList) {
            Long orgId;
            executeItemPO.setNoApprovalFlag(new Byte("0"));
            if (CollUtil.isNotEmpty(noUnitIdSet) && NumberUtil.isNumber((CharSequence)executeItemPO.getDemandOrgId()) && noUnitIdSet.contains(orgId = Long.valueOf(Long.parseLong(executeItemPO.getDemandOrgId())))) {
                executeItemPO.setNoApprovalFlag(new Byte("1"));
            }
            executeItemMap.put(executeItemPO.getExecuteItemId(), executeItemPO);
        }
        for (DealConfirmItemPO dealConfirmItemPO : confirmItemList) {
            Long executeItemId = dealConfirmItemPO.getExecuteItemId();
            if (!executeItemMap.containsKey(executeItemId)) continue;
            ExecuteItemPO executeItemPO = (ExecuteItemPO)executeItemMap.get(executeItemId);
            String executeUserId = executeItemPO.getExecuteUserId();
            dealConfirmItemPO.setPlanId(executeItemPO.getPlanId());
            dealConfirmItemPO.setExecuteUserId(executeItemPO.getExecuteUserId());
            dealConfirmItemPO.setNoApprovalFlag(executeItemPO.getNoApprovalFlag());
            executeUserIdSet.add(executeUserId);
        }
        if (CollUtil.isNotEmpty(confirmItemList)) {
            if ("1".equals(confirmPO.getDealType()) || "2".equals(confirmPO.getDealType())) {
                Map<Long, List<DealConfirmItemPO>> planMap = confirmItemList.stream().collect(Collectors.groupingBy(DealConfirmItemPO::getPlanId));
                for (Map.Entry<Long, List<DealConfirmItemPO>> entry : planMap.entrySet()) {
                    List<DealConfirmItemPO> planDealItemList = entry.getValue();
                    Long planId = entry.getKey();
                    this.saveConfirmReview(reqBO, confirmPO, planDealItemList, planId, null, 0);
                }
            } else if ("3".equals(confirmPO.getDealType())) {
                this.saveConfirmReview(reqBO, confirmPO, confirmItemList, null, executeUserIdSet, 1);
            }
            confirmPO.setDealConfirmStatus("2");
            this.dealConfirmMapper.updateByPrimaryKeySelective(confirmPO);
            busiRspBO.setRespCode("0000");
            busiRspBO.setRespDesc("\u4fdd\u5b58\u5ba1\u6279\u5355\u6210\u529f\uff01");
            return busiRspBO;
        }
        busiRspBO.setRespCode("8888");
        busiRspBO.setRespDesc("\u4fdd\u5b58\u5ba1\u6279\u5355\u5931\u8d25\uff01");
        return busiRspBO;
    }

    private List<PurchaseApprovalExceptionPO> getExceptionOrgList(List<String> orgIdList) {
        ArrayList<Long> unitIdList = new ArrayList<Long>();
        HashSet<Long> unitIdSet = new HashSet<Long>();
        for (String orgId : orgIdList) {
            if (!NumberUtil.isNumber((CharSequence)orgId)) continue;
            unitIdSet.add(Long.parseLong(orgId));
        }
        CollUtil.addAll(unitIdList, unitIdSet);
        PurchaseApprovalExceptionPO queryPO = new PurchaseApprovalExceptionPO();
        queryPO.setUnitIdList(unitIdList);
        return this.purchaseApprovalExceptionMapper.qryList(queryPO);
    }

    private EnquiryDealConfirmReviewRspBO dealNoApprovalInfo(EnquiryDealConfirmReviewReqBO reqBO, DealConfirmPO confirmPO, ExecuteBillPO executeBillPO) {
        EnquiryDealConfirmReviewRspBO busiRspBO = new EnquiryDealConfirmReviewRspBO();
        DealConfirmItemPO confirmItemPO = new DealConfirmItemPO();
        confirmItemPO.setDealConfirmId(confirmPO.getDealConfirmId());
        List<DealConfirmItemPO> confirmItemList = this.dealConfirmItemMapper.selectListBy(confirmItemPO);
        ArrayList<Long> executeItemIdList = new ArrayList<Long>();
        ArrayList<Long> confirmItemIdList = new ArrayList<Long>();
        for (DealConfirmItemPO confirmItem : confirmItemList) {
            confirmItem.setDealConfirmStatus("5");
            confirmItem.setExecuteStatus("2014");
            this.dealConfirmItemMapper.updateByPrimaryKeySelective(confirmItem);
            executeItemIdList.add(confirmItem.getExecuteItemId());
            confirmItemIdList.add(confirmItem.getDealConfirmItemId());
        }
        UpdateExecuteItemStatusReqBO executeItemStatusReqBO = UpdateExecuteItemStatusReqBO.builder().executeItemIdList(executeItemIdList).executeStatus("2013").planExecuteUpdateType(PebExtConstant.PlanExecuteUpdateType.SUPPLIER_CONFIRM).planExecuteStatus("8").build();
        EnquiryExecuteItemRspBO itemRspBO = this.executeItemBusiService.updateExecuteItemStatus(executeItemStatusReqBO);
        if (!"0000".equals(itemRspBO.getRespCode())) {
            throw new BusinessException("8888", itemRspBO.getRespDesc());
        }
        EnquiryDealNoticeReqBO enquiryDealNoticeReqBO = new EnquiryDealNoticeReqBO();
        enquiryDealNoticeReqBO.setDealConfirmId(confirmPO.getDealConfirmId());
        enquiryDealNoticeReqBO.setConfirmItemIdList(confirmItemIdList);
        enquiryDealNoticeReqBO.setExecuteId(confirmPO.getExecuteId());
        EnquiryDealNoticeRspBO rspBO = this.enquiryDealNoticeBusiService.saveDealNotice(enquiryDealNoticeReqBO);
        if (!"0000".equals(rspBO.getRespCode())) {
            throw new BusinessException(rspBO.getRespCode(), rspBO.getRespDesc());
        }
        executeBillPO.setNoticeFlag(new Byte("1"));
        this.executeBillMapper.updateByPrimaryKeySelective(executeBillPO);
        reqBO.setDealConfirmReviewCode("\u786e\u8ba4\u6210\u4ea4\u4e0d\u5ba1\u6279");
        reqBO.setExecuteId(confirmPO.getExecuteId());
        String confirmStatus = "12";
        this.saveConfirmApprovalLog(reqBO, 0, confirmStatus, executeItemIdList);
        busiRspBO.setRespCode("0000");
        busiRspBO.setRespDesc("\u4fdd\u5b58\u5ba1\u6279\u5355\u6210\u529f\uff01");
        return busiRspBO;
    }

    @Override
    public EnquiryDealConfirmReviewPageRspBO queryList(EnquiryDealConfirmReviewReqBO reqBO) {
        EnquiryDealConfirmReviewPageRspBO busiRspBO = new EnquiryDealConfirmReviewPageRspBO();
        busiRspBO.setRespCode("0000");
        busiRspBO.setRespDesc("\u67e5\u8be2\u7ed3\u679c\u4e3a\u7a7a\uff01");
        List statusList = reqBO.getStatusList();
        if (statusList != null) {
            List<String> userTypeList = EnquiryCommonUtil.getUserType((EnquiryReqBO)reqBO, reqBO.getPermission());
            if (CollUtil.isEmpty(userTypeList)) {
                throw new BusinessException("8888", "\u5f53\u524d\u7528\u6237\u3010" + reqBO.getName() + "\u3011\u6ca1\u6709\u914d\u7f6e\u5ba1\u6279\u5c97\u4f4d");
            }
            Page page = new Page(reqBO.getPageNo().intValue(), reqBO.getPageSize().intValue());
            String WAITING_APPROVAL = "2";
            String APPROVING = "3";
            DealConfirmReviewBusiReqBO reviewQueryBO = new DealConfirmReviewBusiReqBO();
            BeanUtil.copyProperties((Object)reqBO, (Object)reviewQueryBO);
            if (statusList.contains(WAITING_APPROVAL)) {
                reviewQueryBO.setStatusList(null);
                reviewQueryBO.setDealConfirmStatus(null);
                reviewQueryBO.setExecuteOrgId(null);
                if (userTypeList.contains("4") || userTypeList.contains("1")) {
                    reviewQueryBO.setExecuteDepartId(String.valueOf(reqBO.getCompanyId()));
                    reviewQueryBO.setExecuteOrgId(String.valueOf(reqBO.getOrgId()));
                    reviewQueryBO.setDealConfirmStatus(WAITING_APPROVAL);
                }
                if (userTypeList.contains("2")) {
                    ExecuteConfirmMemPO executeConfirmMemPO = new ExecuteConfirmMemPO();
                    executeConfirmMemPO.setStationId(EnquiryCommonUtil.valNull(reqBO.getMemIdIn()));
                    List<ExecuteConfirmMemPO> memList = this.executeConfirmMemMapper.selectBy(executeConfirmMemPO);
                    log.info("\u5f53\u524d\u7528\u6237\u767b\u9646memId\u3010" + reqBO.getMemIdIn() + "\u3011");
                    if (CollUtil.isEmpty(memList)) {
                        throw new BusinessException("8888", "\u5f53\u524d\u7528\u6237\u3010" + reqBO.getName() + "\u3011\u6ca1\u6709\u5ba1\u6279\u914d\u7f6e\u6267\u884c\u4eba");
                    }
                    ArrayList<String> createUserList = new ArrayList<String>();
                    for (ExecuteConfirmMemPO memPO : memList) {
                        createUserList.add(EnquiryCommonUtil.valNull(memPO.getExecuteUserId()));
                    }
                    reviewQueryBO.setCreateUserList(createUserList);
                }
                if (userTypeList.contains("3")) {
                    reviewQueryBO.setStatusList(CollUtil.newArrayList((Object[])new String[]{WAITING_APPROVAL, APPROVING}));
                    reviewQueryBO.setExecuteUserList(CollUtil.newArrayList((Object[])new String[]{String.valueOf(reqBO.getUserId())}));
                }
                reviewQueryBO.setUserTypeList(userTypeList);
            } else {
                reviewQueryBO.setQueryFlag(3);
                reviewQueryBO.setUserId(reqBO.getUserId());
            }
            List<DealConfirmReviewBusiBO> confirmReviewList = this.dealConfirmReviewMapper.selectReviewBy(reviewQueryBO, (Page<DealConfirmReviewBusiBO>)page);
            ArrayList<DealConfirmReviewBO> rows = new ArrayList<DealConfirmReviewBO>();
            EnquiryReqBO pageReq = new EnquiryReqBO();
            int pageNo = pageReq.getPageNo();
            int pageSize = pageReq.getPageNo();
            if (CollUtil.isEmpty(confirmReviewList)) {
                return busiRspBO;
            }
            String APPROVAL_SUCCESS = "5";
            int num = 1;
            for (DealConfirmReviewBusiBO reviewBusiBO : confirmReviewList) {
                DealConfirmReviewBO newBO = new DealConfirmReviewBO();
                BeanUtil.copyProperties((Object)reviewBusiBO, (Object)newBO);
                EnquiryDealConfirmReviewReqBO reviewReqBO = new EnquiryDealConfirmReviewReqBO();
                reviewReqBO.setDealConfirmReviewId(reviewBusiBO.getDealConfirmReviewId());
                reviewReqBO.setPageNo(Integer.valueOf(pageNo));
                reviewReqBO.setPageNo(Integer.valueOf(pageSize));
                EnquiryPlanCodePageRspBO planCodePageRspBO = this.queryPlanCodeList(reviewReqBO);
                newBO.setPlanCodeList(planCodePageRspBO.getRows());
                if (statusList.contains(WAITING_APPROVAL)) {
                    newBO.setDealConfirmStatus("2");
                }
                if (APPROVAL_SUCCESS.equals(newBO.getDealConfirmStatus())) {
                    EnquiryDealNoticeQueryReqBO noticeQueryReqBO = new EnquiryDealNoticeQueryReqBO();
                    EnquiryReqBO userReqBO = new EnquiryReqBO();
                    BeanUtil.copyProperties((Object)reqBO, (Object)userReqBO);
                    BeanUtil.copyProperties((Object)userReqBO, (Object)noticeQueryReqBO);
                    noticeQueryReqBO.setPermission(reqBO.getPermission());
                    noticeQueryReqBO.setPageNo(Integer.valueOf(-1));
                    noticeQueryReqBO.setDealConfirmReviewId(reviewBusiBO.getDealConfirmReviewId());
                    EnquiryDealNoticePageRspBO dealNoticePageRspBO = this.enquiryDealNoticeBusiService.queryNoticeList(noticeQueryReqBO);
                    newBO.setNoticeList(dealNoticePageRspBO.getRows());
                }
                newBO.setSeqNumber(Integer.valueOf(num));
                newBO.setDealConfirmStatusStr(EnquiryEnumConstant.DealConfirmStatusEnum.getDesc((String)newBO.getDealConfirmStatus()));
                newBO.setExecuteTypeStr(EnquiryEnumConstant.ExecuteTypeEnum.getDesc((String)newBO.getExecuteType()));
                rows.add(newBO);
                ++num;
            }
            busiRspBO.setRows(rows);
            busiRspBO.setTotal(Integer.valueOf(page.getTotalPages()));
            busiRspBO.setRecordsTotal(Integer.valueOf(page.getTotalCount()));
            busiRspBO.setPageNo(Integer.valueOf(page.getPageNo()));
            busiRspBO.setRespCode("0000");
            busiRspBO.setRespDesc("\u5ba1\u6279\u5217\u8868\u67e5\u8be2\u6210\u529f\uff01");
        }
        return busiRspBO;
    }

    @Override
    public EnquiryConfirmReviewDetailRspBO queryDetailInfo(EnquiryDealConfirmReviewReqBO reqBO) {
        Page page = new Page(reqBO.getPageNo().intValue(), reqBO.getPageSize().intValue());
        DealConfirmReviewBusiReqBO reviewQueryBO = new DealConfirmReviewBusiReqBO();
        reviewQueryBO.setDealConfirmReviewId(reqBO.getDealConfirmReviewId());
        List<DealConfirmReviewBusiBO> confirmReviewList = this.dealConfirmReviewMapper.selectReviewBy(reviewQueryBO, (Page<DealConfirmReviewBusiBO>)page);
        EnquiryConfirmReviewDetailRspBO busiRspBO = new EnquiryConfirmReviewDetailRspBO();
        if (CollUtil.isEmpty(confirmReviewList)) {
            busiRspBO.setRespCode("0000");
            busiRspBO.setRespDesc("\u67e5\u8be2\u7ed3\u679c\u4e3a\u7a7a\uff01");
            return busiRspBO;
        }
        DealConfirmReviewBusiBO dealConfirmReviewBusiBO = (DealConfirmReviewBusiBO)CollUtil.getFirst(confirmReviewList);
        DealConfirmReviewBO dealConfirmReviewBO = new DealConfirmReviewBO();
        BeanUtil.copyProperties((Object)dealConfirmReviewBusiBO, (Object)dealConfirmReviewBO);
        dealConfirmReviewBO.setOperatorResult(EnquiryEnumConstant.ApprovalResultEnum.getDesc((String)dealConfirmReviewBO.getOperatorResult()));
        dealConfirmReviewBO.setPurchaserResult(EnquiryEnumConstant.ApprovalResultEnum.getDesc((String)dealConfirmReviewBO.getPurchaserResult()));
        busiRspBO.setConfirmReviewBO(dealConfirmReviewBO);
        EnquiryDealConfirmReviewReqBO reviewReqBO = new EnquiryDealConfirmReviewReqBO();
        reviewReqBO.setExecuteId(dealConfirmReviewBusiBO.getExecuteId());
        reviewReqBO.setDealConfirmReviewId(reqBO.getDealConfirmReviewId());
        reviewReqBO.setPageNo(reqBO.getPageNo());
        reviewReqBO.setPageSize(reqBO.getPageSize());
        EnquiryDealConfirmResultRspBO confirmResultRspBO = this.enquiryDealConfirmDetailBusiService.queryConfirmResultList(reviewReqBO);
        busiRspBO.setConfirmPlanItemBOList(confirmResultRspBO.getConfirmPlanItemBOList());
        Long confirmId = dealConfirmReviewBusiBO.getDealConfirmId();
        DealConfirmPO confirmPO = this.dealConfirmMapper.selectByPrimaryKey(confirmId);
        EnquiryConfirmBO confirmBO = this.enquiryDealConfirmDetailBusiService.getConfirmBO(confirmPO);
        busiRspBO.setConfirmBO(confirmBO);
        busiRspBO.setRespCode("0000");
        busiRspBO.setRespDesc("\u5ba1\u6279\u8be6\u60c5\u67e5\u8be2\u6210\u529f\uff01");
        return busiRspBO;
    }

    @Override
    public EnquiryPlanCodePageRspBO queryPlanCodeList(EnquiryDealConfirmReviewReqBO reqBO) {
        EnquiryPlanCodePageRspBO rspBO = new EnquiryPlanCodePageRspBO();
        DealConfirmReviewBusiReqBO confirmReviewBusiReqBO = new DealConfirmReviewBusiReqBO();
        confirmReviewBusiReqBO.setDealConfirmReviewId(reqBO.getDealConfirmReviewId());
        Page page = new Page(reqBO.getPageNo().intValue(), reqBO.getPageSize().intValue());
        List<DealPlanSupplierBusiBO> supplierBusiList = this.dealConfirmReviewItemMapper.queryPlanCodeBy(confirmReviewBusiReqBO, (Page<DealPlanSupplierBusiBO>)page);
        ArrayList<String> planCodeList = new ArrayList<String>();
        for (DealPlanSupplierBusiBO supplierBusiBO : supplierBusiList) {
            planCodeList.add(supplierBusiBO.getPlanCode());
        }
        rspBO.setRows(planCodeList);
        rspBO.setPageNo(Integer.valueOf(page.getPageNo()));
        rspBO.setRecordsTotal(Integer.valueOf(page.getTotalCount()));
        rspBO.setTotal(Integer.valueOf(page.getTotalPages()));
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("\u6210\u529f");
        return rspBO;
    }

    @Override
    public EnquiryDealConfirmReviewRspBO dealApprovalConfirm(EnquiryDealConfirmReviewReqBO reqBO) {
        boolean approvalFlag;
        Long confirmReviewId = reqBO.getDealConfirmReviewId();
        DealConfirmReviewPO confirmReviewPO = this.dealConfirmReviewMapper.selectByPrimaryKey(confirmReviewId);
        if (confirmReviewPO == null) {
            throw new BusinessException("8888", "\u5ba1\u6279\u8bb0\u5f55\u4e0d\u5b58\u5728\uff01");
        }
        if (reqBO.getApprovalResult() == null) {
            throw new BusinessException("8888", "\u5ba1\u6279\u7ed3\u679c\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        boolean bl = approvalFlag = "2".equals(confirmReviewPO.getDealConfirmStatus()) || "3".equals(confirmReviewPO.getDealConfirmStatus());
        if (!approvalFlag) {
            throw new BusinessException("8888", "\u5ba1\u6279\u5355\u5df2\u5ba1\u6279\uff01");
        }
        Long executeId = confirmReviewPO.getExecuteId();
        Byte executeOrgType = confirmReviewPO.getExecuteOrgType();
        reqBO.setExecuteId(executeId);
        EnquiryDealConfirmReviewRspBO busiRspBO = new EnquiryDealConfirmReviewRspBO();
        List<String> userTypeList = EnquiryCommonUtil.getUserType((EnquiryReqBO)reqBO, reqBO.getPermission());
        if (PURCHASE_BYTE.equals(executeOrgType)) {
            InvokeAuditRspBO auditRspBO;
            Boolean finishFlag;
            if ((userTypeList.contains("1") || userTypeList.contains("4")) && (finishFlag = (auditRspBO = this.dealAuditOrder(reqBO, confirmReviewId, EnquiryConstant.AuditObjType.PURCHASEMANAGER_CONFIRM_APPROVAL)).getAuditFinishMap().get(confirmReviewId)).booleanValue()) {
                this.dealPurchaseManagerConfirmApprovalFinish(reqBO, confirmReviewPO);
            }
        } else if (userTypeList.contains("2")) {
            InvokeAuditRspBO auditRspBO = this.dealAuditOrder(reqBO, confirmReviewId, EnquiryConstant.AuditObjType.OPERATION_CONFIRM_APPROVAL);
            Boolean finishFlag = auditRspBO.getAuditFinishMap().get(confirmReviewId);
            if (finishFlag.booleanValue()) {
                this.dealOperationConfirmApprovalFinish(reqBO, confirmReviewPO);
            }
        } else if (userTypeList.contains("3")) {
            InvokeAuditRspBO auditRspBO;
            Boolean finishFlag;
            ExecuteBillPO executeBillPO = this.executeBillMapper.selectByPrimaryKey(executeId);
            Long reviewId = confirmReviewId;
            if ("3".equals(executeBillPO.getConfirmDealType())) {
                DealConfirmReviewItemPO reviewItemPO = new DealConfirmReviewItemPO();
                reviewItemPO.setDealConfirmReviewId(confirmReviewId);
                reviewItemPO.setExecuteUserId(String.valueOf(reqBO.getUserId()));
                DealConfirmReviewItemPO childPO = this.dealConfirmReviewItemMapper.selectChildItemBy(reviewItemPO);
                if (childPO.getDealConfirmReviewChildId() == null) {
                    throw new BusinessException("8888", "\u5ba1\u6279\u5355\u5b50\u5355\u4e0d\u5b58\u5728\uff01");
                }
                reviewId = childPO.getDealConfirmReviewChildId();
            }
            if ((finishFlag = (auditRspBO = this.dealAuditOrder(reqBO, reviewId, EnquiryConstant.AuditObjType.PURCHASER_CONFIRM_APPROVAL)).getAuditFinishMap().get(reviewId)).booleanValue()) {
                this.dealPurchaserConfirmApprovalFinish(reqBO, confirmReviewPO);
            }
        } else {
            throw new BusinessException("8888", "\u5ba1\u6279\u5931\u8d25,\u6ca1\u6709\u914d\u7f6e\u5ba1\u6279\u5c97\u4f4d");
        }
        busiRspBO.setRespCode("0000");
        busiRspBO.setRespDesc("\u5ba1\u6279\u6210\u529f\uff01");
        return busiRspBO;
    }

    private void saveConfirmReview(EnquiryDealConfirmReviewReqBO reqBO, DealConfirmPO confirmPO, List<DealConfirmItemPO> dealConfirmItemPOList, Long planId, Set<String> executeIdSet, int wholeFlag) {
        Long reviewId = this.idUtil.nextId();
        ArrayList<Long> childReviewIdList = new ArrayList<Long>();
        BigDecimal total = this.saveConfirmReviewItem(dealConfirmItemPOList, reviewId, childReviewIdList, executeIdSet, wholeFlag);
        DealConfirmReviewPO dealConfirmReviewPO = new DealConfirmReviewPO();
        dealConfirmReviewPO.setDealConfirmReviewId(reviewId);
        CodeEnquiryReqBO codeEnquiryReqBO = new CodeEnquiryReqBO();
        codeEnquiryReqBO.setParaCode("3001");
        codeEnquiryReqBO.setSystemId("ENQURIY");
        CodeEnquiryRspBO codeEnquiryRspBO = this.seqCodeCreateBusiService.createSeqCode(codeEnquiryReqBO);
        if (!"0000".equals(codeEnquiryRspBO.getRespCode())) {
            throw new BusinessException("8888", "\u521b\u5efa\u7f16\u53f7\u5931\u8d25\uff1a" + codeEnquiryRspBO.getRespDesc());
        }
        String codeStr = codeEnquiryRspBO.getDocCode();
        dealConfirmReviewPO.setDealConfirmReviewCode(codeStr);
        dealConfirmReviewPO.setDealType(confirmPO.getDealType());
        dealConfirmReviewPO.setDealConfirmId(confirmPO.getDealConfirmId());
        dealConfirmReviewPO.setPlanId(planId);
        dealConfirmReviewPO.setDealMoney(total);
        Long executeId = confirmPO.getExecuteId();
        dealConfirmReviewPO.setExecuteId(executeId);
        DealConfirmItemPO itemPO = (DealConfirmItemPO)CollUtil.getFirst(dealConfirmItemPOList);
        ExecuteItemPO queryPO = new ExecuteItemPO();
        queryPO.setExecuteId(itemPO.getExecuteId());
        queryPO.setExecuteItemId(itemPO.getExecuteItemId());
        ExecuteItemPO executeItemPO = this.executeItemMapper.selectDemanderBy(queryPO);
        dealConfirmReviewPO.setExecuteOrgId(executeItemPO.getExecuteOrgId());
        dealConfirmReviewPO.setExecuteOrgName(executeItemPO.getExecuteOrgName());
        dealConfirmReviewPO.setExecuteDepartId(executeItemPO.getExecuteDepartId());
        dealConfirmReviewPO.setExecuteDepartName(executeItemPO.getExecuteDepartName());
        dealConfirmReviewPO.setDemanderOrgId(executeItemPO.getDemandOrgId());
        dealConfirmReviewPO.setDemanderOrgName(executeItemPO.getDemandOrgName());
        dealConfirmReviewPO.setDemanderDepartId(executeItemPO.getDemanderDepartId());
        dealConfirmReviewPO.setDemanderDepartName(executeItemPO.getDemanderDepartName());
        String approvalResult = "0";
        dealConfirmReviewPO.setOperatorResult(approvalResult);
        dealConfirmReviewPO.setPurchaserResult(approvalResult);
        dealConfirmReviewPO.setExecuteOrgType(confirmPO.getExecuteOrgType());
        this.setConfirmReviewUser(dealConfirmReviewPO, (EnquiryReqBO)reqBO);
        dealConfirmReviewPO.setDealConfirmStatus("2");
        dealConfirmReviewPO.setDeleteFlag(EnquiryConstant.deleteFlag.NORMAL);
        this.dealConfirmReviewMapper.insert(dealConfirmReviewPO);
        Byte executeOrgType = confirmPO.getExecuteOrgType();
        reqBO.setDealConfirmId(confirmPO.getDealConfirmId());
        reqBO.setExecuteId(executeId);
        if (executeOrgType != null) {
            int orgType = executeOrgType.intValue();
            if (orgType == 1) {
                this.createAuditOrder(reqBO, reviewId, EnquiryConstant.AuditObjType.PURCHASEMANAGER_CONFIRM_APPROVAL, "purchaseManagerConfirmApproval");
            } else if (orgType == 2) {
                this.createAuditOrder(reqBO, reviewId, EnquiryConstant.AuditObjType.OPERATION_CONFIRM_APPROVAL, "operationConfirmApproval");
                if (wholeFlag == 1) {
                    for (Long childId : childReviewIdList) {
                        this.createAuditOrder(reqBO, childId, EnquiryConstant.AuditObjType.PURCHASER_CONFIRM_APPROVAL, "purchaserConfirmApproval");
                    }
                } else {
                    this.createAuditOrder(reqBO, reviewId, EnquiryConstant.AuditObjType.PURCHASER_CONFIRM_APPROVAL, "purchaserConfirmApproval");
                }
            }
        }
        ArrayList<Long> executeItemIdList = new ArrayList<Long>();
        for (DealConfirmItemPO confirmItemPO : dealConfirmItemPOList) {
            executeItemIdList.add(confirmItemPO.getExecuteItemId());
        }
        reqBO.setDealConfirmReviewId(reviewId);
        reqBO.setDealConfirmReviewCode(dealConfirmReviewPO.getDealConfirmReviewCode());
        this.saveConfirmApprovalLog(reqBO, 0, "2", executeItemIdList);
    }

    private BigDecimal saveConfirmReviewItem(List<DealConfirmItemPO> dealConfirmItemPOList, Long reviewId, List<Long> childReviewIdList, Set<String> executeIdSet, int wholeFlag) {
        BigDecimal total = BigDecimal.ZERO;
        HashMap<String, Long> childMap = new HashMap<String, Long>();
        if (wholeFlag == 1) {
            for (String userId : executeIdSet) {
                Long childId = this.idUtil.nextId();
                childMap.put(userId, childId);
                childReviewIdList.add(childId);
            }
        }
        for (DealConfirmItemPO dealConfirmItemPO : dealConfirmItemPOList) {
            DealConfirmReviewItemPO confirmReviewItemPO = new DealConfirmReviewItemPO();
            Long itemId = this.idUtil.nextId();
            BeanUtil.copyProperties((Object)dealConfirmItemPO, (Object)confirmReviewItemPO);
            String executeUserId = dealConfirmItemPO.getExecuteUserId();
            if (wholeFlag == 1 && childMap.containsKey(executeUserId)) {
                Long childId = (Long)childMap.get(executeUserId);
                confirmReviewItemPO.setDealConfirmReviewChildId(childId);
            }
            confirmReviewItemPO.setDealConfirmReviewId(reviewId);
            confirmReviewItemPO.setDealConfirmReviewItemId(itemId);
            confirmReviewItemPO.setPurchaserResult("0");
            confirmReviewItemPO.setDeleteFlag(EnquiryConstant.deleteFlag.NORMAL);
            total = total.add(BigDecimalUtils.ifNullSet0(dealConfirmItemPO.getDealMoney()));
            this.dealConfirmReviewItemMapper.insert(confirmReviewItemPO);
        }
        return total;
    }

    private void createAuditOrder(EnquiryDealConfirmReviewReqBO reqBO, Long reviewId, Integer auditType, String procDefKey) {
        AuditCreateReqBO auditCreateReqBO = new AuditCreateReqBO();
        auditCreateReqBO.setObjId(reviewId.toString());
        auditCreateReqBO.setOrderId(reviewId);
        auditCreateReqBO.setOrgId(reqBO.getOrgIdIn());
        auditCreateReqBO.setOrgName(reqBO.getOrgName());
        auditCreateReqBO.setUserId(String.valueOf(reqBO.getUserId()));
        auditCreateReqBO.setUserName(reqBO.getName());
        auditCreateReqBO.setProcDefKey(procDefKey);
        auditCreateReqBO.setObjType(auditType);
        AuditCreateRspBO auditCreateRspBO = this.enquiryActiveAuditOperateService.createAuditOrder(auditCreateReqBO);
        if (!"0000".equals(auditCreateRspBO.getRespCode())) {
            log.error("\u786e\u8ba4\u5ba1\u6279id\u3010" + reviewId + "\u3011\u521b\u5efa\u5ba1\u6279\u6d41\u7a0b\u5931\u8d25\uff0c" + auditCreateRspBO.getRespDesc());
            throw new BusinessException("8888", auditCreateRspBO.getRespDesc());
        }
    }

    private void setConfirmReviewUser(DealConfirmReviewPO dealConfirmReviewPO, EnquiryReqBO enquiryReqBO) {
        dealConfirmReviewPO.setCreateUserId(EnquiryCommonUtil.valNull(enquiryReqBO.getUserId()));
        dealConfirmReviewPO.setCreateUserName(enquiryReqBO.getName());
        dealConfirmReviewPO.setCreateTime(new Date());
    }

    private InvokeAuditRspBO dealAuditOrder(EnquiryDealConfirmReviewReqBO reqBO, Long confirmReviewId, Integer auditObjType) {
        InvokeAuditReqBO invokeAuditReqBO = new InvokeAuditReqBO();
        if (reqBO.getUserIdIn() == null) {
            reqBO.setUserIdIn(Long.valueOf(0L));
        }
        BeanUtils.copyProperties((Object)reqBO, (Object)((Object)invokeAuditReqBO));
        if (reqBO.getApprovalResult() == 1) {
            invokeAuditReqBO.setAuditResult(0);
        } else {
            invokeAuditReqBO.setAuditResult(1);
        }
        invokeAuditReqBO.setAuditAdvice(reqBO.getRemarks());
        invokeAuditReqBO.setObjIds(new HashSet<Long>(Collections.singleton(confirmReviewId)));
        invokeAuditReqBO.setObjType(auditObjType);
        InvokeAuditRspBO auditRspBO = this.enquiryActiveAuditOperateService.dealAuditOrder(invokeAuditReqBO);
        if (!"0000".equals(auditRspBO.getRespCode())) {
            throw new BusinessException("8888", auditRspBO.getRespDesc());
        }
        return auditRspBO;
    }

    private void dealPurchaseManagerConfirmApprovalFinish(EnquiryDealConfirmReviewReqBO reqBO, DealConfirmReviewPO confirmReviewPO) {
        Date approvalTime = new Date();
        DealConfirmReviewItemPO dealConfirmReviewItemPO = new DealConfirmReviewItemPO();
        dealConfirmReviewItemPO.setDealConfirmReviewId(confirmReviewPO.getDealConfirmReviewId());
        List<DealConfirmReviewItemPO> dealConfirmReviewItemPOList = this.dealConfirmReviewItemMapper.selectItemBy(dealConfirmReviewItemPO);
        ArrayList<Long> executeItemIdList = new ArrayList<Long>();
        for (DealConfirmReviewItemPO itemPO : dealConfirmReviewItemPOList) {
            this.updateReviewItemPurchaserInfo(reqBO, itemPO, approvalTime);
            executeItemIdList.add(itemPO.getExecuteItemId());
        }
        String confirmStatus = confirmReviewPO.getDealConfirmStatus();
        String approvalResult = String.valueOf(reqBO.getApprovalResult());
        confirmReviewPO.setUpdateTime(approvalTime);
        if ("1".equals(approvalResult)) {
            confirmStatus = "5";
            this.dealApprovalSuccessResult(confirmReviewPO);
        } else if ("2".equals(approvalResult)) {
            confirmStatus = "4";
            this.dealApprovalFailResult(confirmReviewPO, null, reqBO.getUserName(), reqBO.getUserId());
        }
        confirmReviewPO.setDealConfirmStatus(confirmStatus);
        this.updateReviewPurchaserInfo(reqBO, confirmReviewPO, approvalTime);
        reqBO.setDealConfirmReviewCode(confirmReviewPO.getDealConfirmReviewCode());
        reqBO.setApprovalTime(approvalTime);
        this.saveConfirmApprovalLog(reqBO, 1, confirmStatus, executeItemIdList);
    }

    private void dealOperationConfirmApprovalFinish(EnquiryDealConfirmReviewReqBO reqBO, DealConfirmReviewPO confirmReviewPO) {
        DealConfirmReviewItemPO dealConfirmReviewItemPO;
        Date approvalTime = new Date();
        String confirmStatus = confirmReviewPO.getDealConfirmStatus();
        String approvalResult = String.valueOf(reqBO.getApprovalResult());
        String userId = String.valueOf(reqBO.getUserId());
        confirmReviewPO.setUpdateTime(approvalTime);
        if ("2".equals(approvalResult)) {
            confirmStatus = "4";
            this.dealApprovalFailResult(confirmReviewPO, null, reqBO.getUserName(), reqBO.getUserId());
        } else if ("1".equals(approvalResult)) {
            dealConfirmReviewItemPO = new DealConfirmReviewItemPO();
            dealConfirmReviewItemPO.setDealConfirmReviewId(confirmReviewPO.getDealConfirmReviewId());
            dealConfirmReviewItemPO.setPurchaserResult("0");
            boolean successFlag = false;
            List<DealConfirmReviewItemPO> noApprovalUserList = this.dealConfirmReviewItemMapper.selectNoApprovalUserBy(dealConfirmReviewItemPO);
            if (CollUtil.isEmpty(noApprovalUserList)) {
                successFlag = true;
            } else {
                HashSet<String> userSet = new HashSet<String>();
                for (DealConfirmReviewItemPO reviewItemPO : noApprovalUserList) {
                    if (reviewItemPO.getExecuteUserId().equals(userId)) continue;
                    userSet.add(reviewItemPO.getExecuteUserId());
                }
                if (userSet.size() == 0) {
                    successFlag = true;
                }
            }
            if (successFlag) {
                confirmStatus = "5";
                this.dealApprovalSuccessResult(confirmReviewPO);
            } else {
                confirmStatus = "3";
            }
        }
        confirmReviewPO.setDealConfirmStatus(confirmStatus);
        this.updateReviewOperationInfo(reqBO, confirmReviewPO, approvalTime);
        dealConfirmReviewItemPO = new DealConfirmReviewItemPO();
        dealConfirmReviewItemPO.setDealConfirmReviewId(confirmReviewPO.getDealConfirmReviewId());
        List<DealConfirmReviewItemPO> dealConfirmReviewItemPOList = this.dealConfirmReviewItemMapper.selectItemBy(dealConfirmReviewItemPO);
        ArrayList<Long> executeItemIdList = new ArrayList<Long>();
        for (DealConfirmReviewItemPO itemPO : dealConfirmReviewItemPOList) {
            executeItemIdList.add(itemPO.getExecuteItemId());
        }
        reqBO.setDealConfirmReviewCode(confirmReviewPO.getDealConfirmReviewCode());
        reqBO.setApprovalTime(approvalTime);
        this.saveConfirmApprovalLog(reqBO, 2, confirmStatus, executeItemIdList);
    }

    private void dealPurchaserConfirmApprovalFinish(EnquiryDealConfirmReviewReqBO reqBO, DealConfirmReviewPO confirmReviewPO) {
        Date approvalTime = new Date();
        String confirmStatus = confirmReviewPO.getDealConfirmStatus();
        String userId = String.valueOf(reqBO.getUserId());
        String approvalResult = String.valueOf(reqBO.getApprovalResult());
        confirmReviewPO.setUpdateTime(approvalTime);
        if ("2".equals(approvalResult)) {
            confirmStatus = "4";
            this.dealApprovalFailResult(confirmReviewPO, userId, reqBO.getUserName(), reqBO.getUserId());
        } else if ("1".equals(approvalResult)) {
            if ("1".equals(confirmReviewPO.getOperatorResult())) {
                DealConfirmReviewItemPO noApprovalUserQuery = new DealConfirmReviewItemPO();
                noApprovalUserQuery.setDealConfirmReviewId(confirmReviewPO.getDealConfirmReviewId());
                noApprovalUserQuery.setPurchaserResult("0");
                List<DealConfirmReviewItemPO> noApprovalUserList = this.dealConfirmReviewItemMapper.selectNoApprovalUserBy(noApprovalUserQuery);
                HashSet<String> userSet = new HashSet<String>();
                for (DealConfirmReviewItemPO reviewItemPO : noApprovalUserList) {
                    if (reviewItemPO.getExecuteUserId().equals(userId)) continue;
                    userSet.add(reviewItemPO.getExecuteUserId());
                }
                if (userSet.size() > 0) {
                    confirmStatus = "3";
                } else {
                    confirmStatus = "5";
                    this.dealApprovalSuccessResult(confirmReviewPO);
                }
            } else {
                confirmStatus = "3";
            }
        }
        DealConfirmReviewItemPO dealConfirmReviewItemPO = new DealConfirmReviewItemPO();
        dealConfirmReviewItemPO.setDealConfirmReviewId(confirmReviewPO.getDealConfirmReviewId());
        dealConfirmReviewItemPO.setExecuteUserId(userId);
        List<DealConfirmReviewItemPO> itemList = this.dealConfirmReviewItemMapper.selectItemBy(dealConfirmReviewItemPO);
        ArrayList<Long> executeItemIdList = new ArrayList<Long>();
        for (DealConfirmReviewItemPO itemPO : itemList) {
            this.updateReviewItemPurchaserInfo(reqBO, itemPO, approvalTime);
            executeItemIdList.add(itemPO.getExecuteItemId());
        }
        confirmReviewPO.setDealConfirmStatus(confirmStatus);
        this.updateReviewPurchaserInfo(reqBO, confirmReviewPO, approvalTime);
        reqBO.setDealConfirmReviewCode(confirmReviewPO.getDealConfirmReviewCode());
        reqBO.setApprovalTime(approvalTime);
        this.saveConfirmApprovalLog(reqBO, 1, confirmStatus, executeItemIdList);
    }

    private void dealApprovalFailResult(DealConfirmReviewPO confirmReviewPO, String userId, String userName, Long userIdIn) {
        DealConfirmItemPO confirmItemPO;
        String dealType = confirmReviewPO.getDealType();
        DealConfirmReviewItemPO dealConfirmReviewItemPO = new DealConfirmReviewItemPO();
        dealConfirmReviewItemPO.setDealConfirmReviewId(confirmReviewPO.getDealConfirmReviewId());
        dealConfirmReviewItemPO.setExecuteUserId(userId);
        List<DealConfirmReviewItemPO> reviewItemList = this.dealConfirmReviewItemMapper.selectItemBy(dealConfirmReviewItemPO);
        List executeItemIdList = reviewItemList.stream().map(DealConfirmReviewItemPO::getExecuteItemId).collect(Collectors.toList());
        UpdateExecuteItemStatusReqBO updateExecuteItemStatusReqBO = new UpdateExecuteItemStatusReqBO();
        if ("1".equals(dealType)) {
            List confirmItemIdList = reviewItemList.stream().map(DealConfirmReviewItemPO::getDealConfirmItemId).collect(Collectors.toList());
            if (CollUtil.isNotEmpty((Collection)confirmItemIdList)) {
                confirmItemPO = new DealConfirmItemPO();
                confirmItemPO.setItemIdList(confirmItemIdList);
                confirmItemPO.setDeleteFlag(EnquiryConstant.deleteFlag.DEL);
                this.dealConfirmItemMapper.updateDeleteFlag(confirmItemPO);
            }
            updateExecuteItemStatusReqBO = UpdateExecuteItemStatusReqBO.builder().executeItemIdList(executeItemIdList).executeStatus("2005").planExecuteUpdateType(PebExtConstant.PlanExecuteUpdateType.RESULT_REVIEW_REFUSE).planExecuteStatus("5").build();
        } else if ("2".equals(dealType)) {
            for (DealConfirmReviewItemPO reviewItemPO : reviewItemList) {
                reviewItemPO.setExecuteStatus("2008");
                this.dealConfirmReviewItemMapper.updateByPrimaryKeySelective(reviewItemPO);
            }
            List<Long> confrimItemIdList = reviewItemList.stream().map(DealConfirmReviewItemPO::getDealConfirmItemId).collect(Collectors.toList());
            confirmItemPO = new DealConfirmItemPO();
            confirmItemPO.setItemIdList(confrimItemIdList);
            List<DealConfirmItemPO> confirmItemList = this.dealConfirmItemMapper.selectListBy(confirmItemPO);
            for (DealConfirmItemPO confirmItem : confirmItemList) {
                confirmItem.setDealConfirmStatus("4");
                this.dealConfirmItemMapper.updateByPrimaryKeySelective(confirmItem);
            }
            updateExecuteItemStatusReqBO = UpdateExecuteItemStatusReqBO.builder().executeItemIdList(executeItemIdList).executeStatus("2008").remarks("\u672a\u786e\u8ba4\u4f9b\u5e94\u5546:\u786e\u8ba4\u5ba1\u6838\u9a73\u56de").planExecuteUpdateType(PebExtConstant.PlanExecuteUpdateType.EXECUTE_FAIL).planExecuteStatus("7").build();
        } else if ("3".equals(dealType)) {
            DealConfirmItemPO confirmItemPO2 = new DealConfirmItemPO();
            confirmItemPO2.setDealConfirmId(confirmReviewPO.getDealConfirmId());
            confirmItemPO2.setDeleteFlag(EnquiryConstant.deleteFlag.DEL);
            this.dealConfirmItemMapper.updateDeleteFlag(confirmItemPO2);
            updateExecuteItemStatusReqBO = UpdateExecuteItemStatusReqBO.builder().executeItemIdList(executeItemIdList).executeStatus("2005").planExecuteUpdateType(PebExtConstant.PlanExecuteUpdateType.RESULT_REVIEW_REFUSE).planExecuteStatus("5").build();
        }
        updateExecuteItemStatusReqBO.setUserId(userIdIn);
        updateExecuteItemStatusReqBO.setUserIdIn(userIdIn);
        updateExecuteItemStatusReqBO.setUserName(userName);
        EnquiryExecuteItemRspBO itemRspBO = this.executeItemBusiService.updateExecuteItemStatus(updateExecuteItemStatusReqBO);
        if (!"0000".equals(itemRspBO.getRespCode())) {
            throw new BusinessException("8888", itemRspBO.getRespDesc());
        }
        Long executeId = confirmReviewPO.getExecuteId();
        ExecuteBillPO executeBillPO = this.executeBillMapper.selectByPrimaryKey(executeId);
        executeBillPO.setConfirmFlag(new Byte("0"));
        this.executeBillMapper.updateByPrimaryKeySelective(executeBillPO);
    }

    private void dealApprovalSuccessResult(DealConfirmReviewPO confirmReviewPO) {
        Long confirmReviewId = confirmReviewPO.getDealConfirmReviewId();
        DealConfirmReviewItemPO dealConfirmReviewItemPO = new DealConfirmReviewItemPO();
        dealConfirmReviewItemPO.setDealConfirmReviewId(confirmReviewId);
        List<DealConfirmReviewItemPO> reviewItemList = this.dealConfirmReviewItemMapper.selectItemBy(dealConfirmReviewItemPO);
        List<Long> confirmItemIdList = reviewItemList.stream().map(DealConfirmReviewItemPO::getDealConfirmItemId).collect(Collectors.toList());
        DealConfirmItemPO confirmItemPO = new DealConfirmItemPO();
        confirmItemPO.setItemIdList(confirmItemIdList);
        List<DealConfirmItemPO> confirmItemList = this.dealConfirmItemMapper.selectListBy(confirmItemPO);
        ArrayList<Long> executeItemIdList = new ArrayList<Long>();
        ArrayList<Long> noticeConfirmItemList = new ArrayList<Long>();
        for (DealConfirmItemPO confirmItem : confirmItemList) {
            if ("15".equals(confirmItem.getDealConfirmStatus())) continue;
            confirmItem.setDealConfirmStatus("5");
            confirmItem.setExecuteStatus("2014");
            this.dealConfirmItemMapper.updateByPrimaryKeySelective(confirmItem);
            executeItemIdList.add(confirmItem.getExecuteItemId());
            noticeConfirmItemList.add(confirmItem.getDealConfirmItemId());
        }
        EnquiryDealNoticeReqBO enquiryDealNoticeReqBO = new EnquiryDealNoticeReqBO();
        enquiryDealNoticeReqBO.setDealConfirmId(confirmReviewPO.getDealConfirmId());
        enquiryDealNoticeReqBO.setConfirmItemIdList(noticeConfirmItemList);
        enquiryDealNoticeReqBO.setDealConfirmReviewId(confirmReviewId);
        enquiryDealNoticeReqBO.setExecuteId(confirmReviewPO.getExecuteId());
        EnquiryDealNoticeRspBO rspBO = this.enquiryDealNoticeBusiService.saveDealNotice(enquiryDealNoticeReqBO);
        if ("0000".equals(rspBO.getRespCode())) {
            ExecuteBillPO executeBillPO = this.executeBillMapper.selectByPrimaryKey(confirmReviewPO.getExecuteId());
            executeBillPO.setNoticeFlag(new Byte("1"));
            this.executeBillMapper.updateByPrimaryKeySelective(executeBillPO);
            UpdateExecuteItemStatusReqBO executeItemStatusReqBO = UpdateExecuteItemStatusReqBO.builder().executeItemIdList(executeItemIdList).executeStatus("2013").planExecuteUpdateType(PebExtConstant.PlanExecuteUpdateType.SUPPLIER_CONFIRM).planExecuteStatus("8").build();
            EnquiryExecuteItemRspBO itemRspBO = this.executeItemBusiService.updateExecuteItemStatus(executeItemStatusReqBO);
            if (!"0000".equals(itemRspBO.getRespCode())) {
                throw new BusinessException("8888", itemRspBO.getRespDesc());
            }
        } else {
            throw new BusinessException(rspBO.getRespCode(), rspBO.getRespDesc());
        }
    }

    private void updateReviewItemPurchaserInfo(EnquiryDealConfirmReviewReqBO reqBO, DealConfirmReviewItemPO itemPO, Date approvalTime) {
        itemPO.setPurchaserUserId(EnquiryCommonUtil.valNull(reqBO.getUserId()));
        itemPO.setPurchaserUserName(reqBO.getName());
        itemPO.setPurchaserTime(approvalTime);
        itemPO.setPurchaserResult(EnquiryCommonUtil.valNull(reqBO.getApprovalResult()));
        itemPO.setPurchaserRemarks(reqBO.getRemarks());
        this.dealConfirmReviewItemMapper.updateByPrimaryKeySelective(itemPO);
    }

    private void updateReviewPurchaserInfo(EnquiryDealConfirmReviewReqBO reqBO, DealConfirmReviewPO reviewPO, Date approvalTime) {
        reviewPO.setPurchaserUserId(EnquiryCommonUtil.valNull(reqBO.getUserId()));
        reviewPO.setPurchaserUserName(reqBO.getName());
        reviewPO.setPurchaserTime(approvalTime);
        reviewPO.setPurchaserResult(EnquiryCommonUtil.valNull(reqBO.getApprovalResult()));
        reviewPO.setPurchaserRemarks(reqBO.getRemarks());
        this.dealConfirmReviewMapper.updateByPrimaryKeySelective(reviewPO);
    }

    private void updateReviewOperationInfo(EnquiryDealConfirmReviewReqBO reqBO, DealConfirmReviewPO reviewPO, Date approvalTime) {
        reviewPO.setOperatorUserId(EnquiryCommonUtil.valNull(reqBO.getUserId()));
        reviewPO.setOperatorUserName(reqBO.getName());
        reviewPO.setOperatorTime(approvalTime);
        reviewPO.setOperatorResult(EnquiryCommonUtil.valNull(reqBO.getApprovalResult()));
        reviewPO.setOperatorRemarks(reqBO.getRemarks());
        this.dealConfirmReviewMapper.updateByPrimaryKeySelective(reviewPO);
    }

    private void saveConfirmApprovalLog(EnquiryDealConfirmReviewReqBO reqBO, int executeOrgType, String confirmStatus, List<Long> executeItemIdList) {
        EnquiryLogReqBO enquiryLogReqBO;
        BaseAllOperLogRspBO logRspBO;
        String status = EnquiryEnumConstant.BasPhaseStatusEnum.WORKING.getCode();
        EnquiryEnumConstant.AllOperateBusiEnum operateBusiEnum = null;
        EnquiryEnumConstant.AllExecuteOperateBusiEnum executeOperateBusiEnum = null;
        String nextStep = EnquiryEnumConstant.NextStepStatusEnum.WAITING_APPROVAL.getCode();
        boolean detailInfoFlag = true;
        Date purchaseApproveTime = null;
        Date operateApproveTime = null;
        Date approvalTime = reqBO.getApprovalTime();
        if ("12".equals(confirmStatus)) {
            status = EnquiryEnumConstant.BasPhaseStatusEnum.FINISH.getCode();
            detailInfoFlag = false;
        } else if ("3".equals(confirmStatus)) {
            nextStep = EnquiryEnumConstant.NextStepStatusEnum.APPROVALING.getCode();
        } else if ("5".equals(confirmStatus)) {
            status = EnquiryEnumConstant.BasPhaseStatusEnum.FINISH.getCode();
            if (executeOrgType == 1) {
                operateBusiEnum = EnquiryEnumConstant.AllOperateBusiEnum.TYPE1901;
                executeOperateBusiEnum = EnquiryEnumConstant.AllExecuteOperateBusiEnum.TYPE402;
            } else if (executeOrgType == 2) {
                operateBusiEnum = EnquiryEnumConstant.AllOperateBusiEnum.TYPE2001;
                executeOperateBusiEnum = EnquiryEnumConstant.AllExecuteOperateBusiEnum.TYPE402;
            }
            nextStep = EnquiryEnumConstant.NextStepStatusEnum.FINISH.getCode();
        } else if ("4".equals(confirmStatus)) {
            status = EnquiryEnumConstant.BasPhaseStatusEnum.FINISH.getCode();
            if (executeOrgType == 1) {
                operateBusiEnum = EnquiryEnumConstant.AllOperateBusiEnum.TYPE1902;
                executeOperateBusiEnum = EnquiryEnumConstant.AllExecuteOperateBusiEnum.TYPE401;
            } else if (executeOrgType == 2) {
                operateBusiEnum = EnquiryEnumConstant.AllOperateBusiEnum.TYPE2002;
                executeOperateBusiEnum = EnquiryEnumConstant.AllExecuteOperateBusiEnum.TYPE401;
            }
            nextStep = EnquiryEnumConstant.NextStepStatusEnum.FINISH.getCode();
        }
        if (executeOrgType == 1) {
            purchaseApproveTime = approvalTime;
        } else if (executeOrgType == 2) {
            operateApproveTime = approvalTime;
        }
        Long executeId = reqBO.getExecuteId();
        BasePhaseReqBO executePhaseReqBO = new BasePhaseReqBO();
        BeanUtil.copyProperties((Object)reqBO, (Object)executePhaseReqBO);
        executePhaseReqBO.setBusiType("1");
        executePhaseReqBO.setStepNum(EnquiryConstant.BasPhaseExecute.FIVE);
        executePhaseReqBO.setRelateId(executeId.toString());
        executePhaseReqBO.setStatus(status);
        if (detailInfoFlag) {
            ArrayList<BasePhaseItemBO> basePhaseItemBOList = new ArrayList<BasePhaseItemBO>();
            BasePhaseItemBO basePhaseItemBO = new BasePhaseItemBO();
            basePhaseItemBO.setDealBusId(reqBO.getDealConfirmReviewId());
            basePhaseItemBO.setDealBusCode(reqBO.getDealConfirmReviewCode());
            BeanUtil.copyProperties((Object)reqBO, (Object)basePhaseItemBO);
            basePhaseItemBO.setDemanderOrgId(reqBO.getOrgId());
            basePhaseItemBO.setDemanderOrgName(reqBO.getOrgName());
            basePhaseItemBO.setNextStep(nextStep);
            basePhaseItemBO.setPurchaseApproveTime(purchaseApproveTime);
            basePhaseItemBO.setOperateApproveTime(operateApproveTime);
            basePhaseItemBOList.add(basePhaseItemBO);
            executePhaseReqBO.setPhaseItemList(basePhaseItemBOList);
        }
        BasePhaseReqBO demanderPhaseReqBO = new BasePhaseReqBO();
        BeanUtil.copyProperties((Object)reqBO, (Object)demanderPhaseReqBO);
        demanderPhaseReqBO.setBusiType("2");
        demanderPhaseReqBO.setStepNum(EnquiryConstant.BasPhaseCompete.EIGHT);
        demanderPhaseReqBO.setExecuteItemIdList(executeItemIdList);
        demanderPhaseReqBO.setStatus(status);
        BaseAllOperLogReqBO allOperLogReqBO = null;
        if (operateBusiEnum != null) {
            allOperLogReqBO = new BaseAllOperLogReqBO();
            BeanUtil.copyProperties((Object)reqBO, (Object)allOperLogReqBO);
            allOperLogReqBO.setOperateBusiEnum(operateBusiEnum);
            allOperLogReqBO.setExecuteItemIdList(executeItemIdList);
            allOperLogReqBO.setRemark(reqBO.getRemarks());
        }
        BaseAllOperLogReqBO allExecuteOperLogReqBO = null;
        if (executeOperateBusiEnum != null) {
            allExecuteOperLogReqBO = new BaseAllOperLogReqBO();
            BeanUtil.copyProperties((Object)reqBO, (Object)allExecuteOperLogReqBO);
            allExecuteOperLogReqBO.setExecuteOperateBusiEnum(executeOperateBusiEnum);
            allExecuteOperLogReqBO.setExecuteItemIdList(executeItemIdList);
            allExecuteOperLogReqBO.setRemark(reqBO.getRemarks());
        }
        if (!"0000".equals((logRspBO = this.baseAllOperLogBusiService.saveAllOperateLog(enquiryLogReqBO = EnquiryLogReqBO.builder().executePhaseReqBO(executePhaseReqBO).demanderPhaseReqBO(demanderPhaseReqBO).allOperLogReqBO(allOperLogReqBO).allExecuteOperLogReqBO(allExecuteOperLogReqBO).build())).getRespCode())) {
            throw new BusinessException("8888", logRspBO.getRespDesc());
        }
    }
}

