/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.enquiry.busi.impl;

import cn.hutool.core.bean.BeanUtil;
import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.util.NumberUtil;
import cn.hutool.core.util.StrUtil;
import com.alibaba.fastjson.JSON;
import com.ohaotian.plugin.db.Page;
import com.tydic.agreement.ability.AgrQryAgreementSkuByPageAbilityService;
import com.tydic.agreement.ability.bo.AgrQryAgreementSkuByPageAbilityReqBO;
import com.tydic.agreement.ability.bo.AgrQryAgreementSkuByPageAbilityRspBO;
import com.tydic.agreement.common.bo.AgrAgreementSkuBO;
import com.tydic.commodity.ability.api.UccSkuExtensionMatchAbilityService;
import com.tydic.commodity.bo.ability.UccSkuExtensionMatchAbilityReqBO;
import com.tydic.commodity.bo.ability.UccSkuExtensionMatchAbilityRspBO;
import com.tydic.commodity.bo.ability.UccSkuIdAndExtIdBO;
import com.tydic.commodity.bo.ability.UccSkuQryBySkuIdsAbilityReqBO;
import com.tydic.commodity.bo.ability.UccSkuQryBySkuIdsAbilityRspBO;
import com.tydic.commodity.bo.ability.UccSkuQryBySkuIdsBO;
import com.tydic.enquiry.api.bo.BaseAllOperLogReqBO;
import com.tydic.enquiry.api.bo.BaseAllOperLogRspBO;
import com.tydic.enquiry.api.bo.BasePhaseItemBO;
import com.tydic.enquiry.api.bo.BasePhaseReqBO;
import com.tydic.enquiry.api.bo.CodeEnquiryReqBO;
import com.tydic.enquiry.api.bo.CodeEnquiryRspBO;
import com.tydic.enquiry.api.bo.EnquiryDealConfirmItemPageRspBO;
import com.tydic.enquiry.api.bo.EnquiryDealNoticeBO;
import com.tydic.enquiry.api.bo.EnquiryDealNoticeDeatilRspBO;
import com.tydic.enquiry.api.bo.EnquiryDealNoticeMatchBO;
import com.tydic.enquiry.api.bo.EnquiryDealNoticeMatchPageRspBO;
import com.tydic.enquiry.api.bo.EnquiryDealNoticeMatchRspBO;
import com.tydic.enquiry.api.bo.EnquiryDealNoticePageRspBO;
import com.tydic.enquiry.api.bo.EnquiryDealNoticeQueryReqBO;
import com.tydic.enquiry.api.bo.EnquiryDealNoticeReqBO;
import com.tydic.enquiry.api.bo.EnquiryDealNoticeRspBO;
import com.tydic.enquiry.api.bo.EnquiryExecuteItemRspBO;
import com.tydic.enquiry.api.bo.EnquiryExecuteQuotePlanItemBO;
import com.tydic.enquiry.api.bo.EnquiryLogReqBO;
import com.tydic.enquiry.api.bo.EnquiryQuateTotalBO;
import com.tydic.enquiry.api.bo.EnquirySupplierConfirmItemBo;
import com.tydic.enquiry.api.bo.EnquirySupplierDealConfirmReqBO;
import com.tydic.enquiry.api.bo.GetDealNoticeRedisNoReqBO;
import com.tydic.enquiry.api.bo.GetDealNoticeRedisNoRspBO;
import com.tydic.enquiry.api.bo.UpdateExecuteItemStatusReqBO;
import com.tydic.enquiry.busi.api.BaseAllOperLogBusiService;
import com.tydic.enquiry.busi.api.EnquiryDealConfirmDetailBusiService;
import com.tydic.enquiry.busi.api.EnquiryDealNoticeBusiService;
import com.tydic.enquiry.busi.api.EnquiryExecuteItemBusiService;
import com.tydic.enquiry.busi.api.bo.DealConfirmItemBusiBO;
import com.tydic.enquiry.busi.api.bo.DealConfirmItemBusiReqBO;
import com.tydic.enquiry.busi.api.bo.DealNoticeBusiBO;
import com.tydic.enquiry.busi.api.bo.DealNoticeBusiReqBO;
import com.tydic.enquiry.busi.api.bo.DealNoticeMatchBusiBO;
import com.tydic.enquiry.busi.api.bo.DealQuateTotalBusiBO;
import com.tydic.enquiry.busi.api.sequence.SeqCodeCreateBusiService;
import com.tydic.enquiry.busi.utils.BigDecimalUtils;
import com.tydic.enquiry.common.EnquiryReqBO;
import com.tydic.enquiry.constant.EnquiryCommonUtil;
import com.tydic.enquiry.constant.EnquiryConstant;
import com.tydic.enquiry.constant.EnquiryEnumConstant;
import com.tydic.enquiry.dao.DealConfirmItemMapper;
import com.tydic.enquiry.dao.DealNoticeItemMapper;
import com.tydic.enquiry.dao.DealNoticeMapper;
import com.tydic.enquiry.dao.DealNoticeMatchMapper;
import com.tydic.enquiry.dao.ExecuteBillMapper;
import com.tydic.enquiry.dao.SupQuoteItemMapper;
import com.tydic.enquiry.dao.po.DealConfirmItemPO;
import com.tydic.enquiry.dao.po.DealNoticeItemPO;
import com.tydic.enquiry.dao.po.DealNoticeMatchPO;
import com.tydic.enquiry.dao.po.DealNoticePO;
import com.tydic.enquiry.dao.po.ExecuteBillPO;
import com.tydic.enquiry.dao.po.SupQuoteItemPO;
import com.tydic.enquiry.exceptions.BusinessException;
import com.tydic.uac.util.GenerateIdUtil;
import com.tydic.uccext.service.UccSkuQryBySkuIdsAbilityService;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class EnquiryDealNoticeBusiServiceImpl
implements EnquiryDealNoticeBusiService {
    private static final Logger log = LoggerFactory.getLogger(EnquiryDealNoticeBusiServiceImpl.class);
    @Autowired
    DealConfirmItemMapper dealConfirmItemMapper;
    @Autowired
    DealNoticeMapper dealNoticeMapper;
    @Autowired
    DealNoticeItemMapper dealNoticeItemMapper;
    @Autowired
    private GenerateIdUtil idUtil;
    @Autowired
    DealNoticeMatchMapper dealNoticeMatchMapper;
    @Autowired
    ExecuteBillMapper executeBillMapper;
    @Autowired
    SupQuoteItemMapper supQuoteItemMapper;
    @Autowired
    private UccSkuExtensionMatchAbilityService uccSkuExtensionMatchAbilityService;
    @Autowired
    private AgrQryAgreementSkuByPageAbilityService agrQryAgreementSkuByPageAbilityService;
    @Autowired
    private UccSkuQryBySkuIdsAbilityService uccSkuQryBySkuIdsAbilityService;
    @Autowired
    private BaseAllOperLogBusiService baseAllOperLogBusiService;
    @Autowired
    private EnquiryExecuteItemBusiService executeItemBusiService;
    @Autowired
    private SeqCodeCreateBusiService seqCodeCreateBusiService;
    @Autowired
    private EnquiryDealConfirmDetailBusiService enquiryDealConfirmDetailBusiService;

    @Override
    public EnquiryDealNoticeRspBO saveDealNotice(EnquiryDealNoticeReqBO reqBO) {
        EnquiryDealNoticeRspBO rspBO = new EnquiryDealNoticeRspBO();
        rspBO.setRespCode("8888");
        String errorMsg = "\u4fdd\u5b58\u6210\u4ea4\u786e\u8ba4\u901a\u77e5\u5931\u8d25";
        List confirmItemIdList = reqBO.getConfirmItemIdList();
        if (CollUtil.isEmpty((Collection)confirmItemIdList)) {
            rspBO.setRespDesc(errorMsg + ",\u6210\u4ea4\u786e\u8ba4\u660e\u7ec6\u4e0d\u80fd\u4e3a\u7a7a\uff01");
            return rspBO;
        }
        DealConfirmItemPO itemPO = new DealConfirmItemPO();
        itemPO.setItemIdList(confirmItemIdList);
        List<DealNoticeBusiBO> confirmItemPOList = this.dealConfirmItemMapper.selectItemBy(itemPO);
        if (CollUtil.isEmpty(confirmItemPOList)) {
            rspBO.setRespDesc(errorMsg + ",\u6210\u4ea4\u786e\u8ba4\u660e\u7ec6\u4e0d\u5b58\u5728\uff01");
            return rspBO;
        }
        rspBO.setRespDesc(errorMsg);
        Long executeId = reqBO.getExecuteId();
        ExecuteBillPO executeBillPO = this.executeBillMapper.selectByPrimaryKey(executeId);
        if (executeBillPO == null) {
            throw new BusinessException("8888", "\u6267\u884c\u5355\u67e5\u8be2\u5931\u8d25");
        }
        Map<Long, List<DealNoticeBusiBO>> confirmItemMap = confirmItemPOList.stream().sorted(Comparator.comparing(DealNoticePO::getQuotedEffectiveTime, Comparator.nullsLast(Date::compareTo))).collect(Collectors.groupingBy(DealNoticePO::getSupplierId));
        for (Map.Entry<Long, List<DealNoticeBusiBO>> entry : confirmItemMap.entrySet()) {
            List<DealNoticeBusiBO> groupList = entry.getValue();
            Long noticeId = this.idUtil.nextId();
            BigDecimal sum = BigDecimal.ZERO;
            ArrayList<Long> executeItemIdList = new ArrayList<Long>();
            for (DealNoticeBusiBO dealConfirmItemPO : groupList) {
                DealNoticeItemPO dealNoticeItemPO = new DealNoticeItemPO();
                BeanUtil.copyProperties((Object)dealConfirmItemPO, (Object)dealNoticeItemPO);
                dealNoticeItemPO.setDealNoticeItemId(this.idUtil.nextId());
                dealNoticeItemPO.setDealNoticeId(noticeId);
                dealNoticeItemPO.setDeleteFlag(EnquiryConstant.deleteFlag.NORMAL);
                sum = sum.add(BigDecimalUtils.ifNullSet0(dealNoticeItemPO.getDealMoney()));
                this.dealNoticeItemMapper.insert(dealNoticeItemPO);
                executeItemIdList.add(dealConfirmItemPO.getExecuteItemId());
            }
            DealNoticePO dealNoticePO = new DealNoticePO();
            BeanUtil.copyProperties((Object)CollUtil.getFirst(groupList), (Object)dealNoticePO);
            List timePOList = ((Stream)groupList.stream().unordered()).sorted(Comparator.comparing(DealNoticePO::getQuoteTime, Comparator.nullsLast(Date::compareTo)).reversed()).collect(Collectors.toList());
            DealNoticePO maxTimePO = (DealNoticePO)CollUtil.getFirst(timePOList);
            dealNoticePO.setQuoteTime(maxTimePO.getQuoteTime());
            CodeEnquiryReqBO codeEnquiryReqBO = new CodeEnquiryReqBO();
            codeEnquiryReqBO.setParaCode("4001");
            codeEnquiryReqBO.setSystemId("ENQURIY");
            CodeEnquiryRspBO codeEnquiryRspBO = this.seqCodeCreateBusiService.createSeqCode(codeEnquiryReqBO);
            if (!"0000".equals(codeEnquiryRspBO.getRespCode())) {
                throw new BusinessException("8888", "\u521b\u5efa\u7f16\u53f7\u5931\u8d25\uff1a" + codeEnquiryRspBO.getRespDesc());
            }
            String codeStr = codeEnquiryRspBO.getDocCode();
            dealNoticePO.setDealNoticeCode(codeStr);
            dealNoticePO.setDealNoticeName(executeBillPO.getExecuteName() + "\u6210\u4ea4\u901a\u77e5");
            dealNoticePO.setDealNoticeId(noticeId);
            dealNoticePO.setDealMoney(sum);
            dealNoticePO.setCreateTime(new Date());
            dealNoticePO.setDealConfirmReviewId(reqBO.getDealConfirmReviewId());
            dealNoticePO.setDealBillStatus("1");
            dealNoticePO.setDeleteFlag(EnquiryConstant.deleteFlag.NORMAL);
            this.dealNoticeMapper.insert(dealNoticePO);
            reqBO.setDealNoticeId(noticeId);
            String workCode = EnquiryEnumConstant.BasPhaseStatusEnum.WORKING.getCode();
            this.saveMatchLog(reqBO, executeId, executeItemIdList, workCode, 0);
            this.saveNoticeItemLog(reqBO, dealNoticePO, executeItemIdList, workCode);
            ExecuteBillPO record = new ExecuteBillPO();
            record.setExecuteId(executeId);
            record.setNoticeFlag((byte)1);
            this.executeBillMapper.updateByPrimaryKeySelective(record);
        }
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("\u4fdd\u5b58\u6210\u4ea4\u786e\u8ba4\u901a\u77e5\u6210\u529f");
        return rspBO;
    }

    @Override
    public EnquiryDealNoticePageRspBO queryNoticeList(EnquiryDealNoticeQueryReqBO reqBO) {
        DealNoticeBusiReqBO dealNoticeBusiReqBO = new DealNoticeBusiReqBO();
        BeanUtil.copyProperties((Object)reqBO, (Object)dealNoticeBusiReqBO);
        EnquiryDealNoticePageRspBO busiRspBO = new EnquiryDealNoticePageRspBO();
        if (new Integer(1).equals(reqBO.getQryMemuFlag()) && "0".equals(reqBO.getIsProfessionalOrgExt())) {
            dealNoticeBusiReqBO.setQryAllFlag(1);
        } else if ("2".equals(reqBO.getIsProfessionalOrgExt())) {
            dealNoticeBusiReqBO.setQueryType(3);
            dealNoticeBusiReqBO.setSupplierId(reqBO.getSupId());
        } else {
            List<String> userTypeList = EnquiryCommonUtil.getUserType((EnquiryReqBO)reqBO, reqBO.getPermission());
            if (CollUtil.isEmpty(userTypeList)) {
                busiRspBO.setRespCode("0000");
                busiRspBO.setRespDesc("\u67e5\u8be2\u7ed3\u679c\u4e3a\u7a7a\uff01");
                return busiRspBO;
            }
            dealNoticeBusiReqBO.setExecuteUserId(String.valueOf(reqBO.getUserId()));
            dealNoticeBusiReqBO.setExecuteOrgIdList(CollUtil.newArrayList((Object[])new Long[]{reqBO.getOrgId()}));
            dealNoticeBusiReqBO.setExecuteDepartId(String.valueOf(reqBO.getCompanyId()));
            dealNoticeBusiReqBO.setUserTypeList(userTypeList);
        }
        Page page = new Page(reqBO.getPageNo().intValue(), reqBO.getPageSize().intValue());
        dealNoticeBusiReqBO.setOrderBy("create_time DESC,deal_notice_code desc");
        List<DealNoticePO> noticePOList = this.dealNoticeMapper.selectByCondtion(dealNoticeBusiReqBO, (Page<DealNoticePO>)page);
        if (CollectionUtils.isEmpty(noticePOList)) {
            busiRspBO.setRespCode("0000");
            busiRspBO.setRespDesc("\u67e5\u8be2\u7ed3\u679c\u4e3a\u7a7a\uff01");
            return busiRspBO;
        }
        ArrayList<EnquiryDealNoticeBO> rows = new ArrayList<EnquiryDealNoticeBO>();
        int num = 1;
        for (DealNoticePO dealNoticePO : noticePOList) {
            EnquiryDealNoticeBO noticeBO = new EnquiryDealNoticeBO();
            BeanUtil.copyProperties((Object)dealNoticePO, (Object)noticeBO);
            noticeBO.setExecuteTypeStr(EnquiryEnumConstant.ExecuteTypeEnum.getDesc((String)noticeBO.getExecuteType()));
            noticeBO.setDealBillStatusStr(EnquiryEnumConstant.DealNoticeStatusEnum.getDesc((String)noticeBO.getDealBillStatus()));
            noticeBO.setSeqNumber(Integer.valueOf(num));
            rows.add(noticeBO);
            ++num;
        }
        if (reqBO.getStatusList() != null && reqBO.getStatusList().contains("2")) {
            busiRspBO.setTabId(Integer.valueOf(2));
        }
        if (reqBO.getStatusList() != null && reqBO.getStatusList().contains("3")) {
            busiRspBO.setTabId(Integer.valueOf(3));
        }
        busiRspBO.setRows(rows);
        busiRspBO.setTotal(Integer.valueOf(page.getTotalPages()));
        busiRspBO.setRecordsTotal(Integer.valueOf(page.getTotalCount()));
        busiRspBO.setPageNo(Integer.valueOf(page.getPageNo()));
        busiRspBO.setRespCode("0000");
        busiRspBO.setRespDesc("\u901a\u77e5\u5206\u9875\u67e5\u8be2\u6210\u529f\uff01");
        return busiRspBO;
    }

    @Override
    public EnquiryDealNoticeDeatilRspBO queryNoticeDetail(EnquiryDealNoticeQueryReqBO reqBO) {
        Long noticeId = reqBO.getDealNoticeId();
        DealNoticeBusiReqBO dealNoticeBusiReqBO = new DealNoticeBusiReqBO();
        dealNoticeBusiReqBO.setDealNoticeId(noticeId);
        DealNoticePO noticePO = this.dealNoticeMapper.selectByCondtion(dealNoticeBusiReqBO);
        EnquiryDealNoticeDeatilRspBO busiRspBO = new EnquiryDealNoticeDeatilRspBO();
        if (noticePO == null) {
            busiRspBO.setRespCode("0000");
            busiRspBO.setRespDesc("\u67e5\u8be2\u7ed3\u679c\u4e3a\u7a7a\uff01");
            return busiRspBO;
        }
        BeanUtil.copyProperties((Object)noticePO, (Object)busiRspBO);
        busiRspBO.setDealBillStatusStr(EnquiryEnumConstant.DealNoticeStatusEnum.getDesc((String)noticePO.getDealBillStatus()));
        DealQuateTotalBusiBO totalBusiBO = this.dealNoticeMapper.selectTotalBy(dealNoticeBusiReqBO);
        EnquiryQuateTotalBO totalBO = new EnquiryQuateTotalBO();
        BeanUtil.copyProperties((Object)noticePO, (Object)totalBO);
        BeanUtil.copyProperties((Object)totalBusiBO, (Object)totalBO);
        totalBO.setDealTypeStr(EnquiryEnumConstant.ConfirmDealTypeEnum.getDesc((String)totalBO.getDealType()));
        ArrayList totalList = CollUtil.newArrayList((Object[])new EnquiryQuateTotalBO[]{totalBO});
        busiRspBO.setQuoteTotalList((List)totalList);
        busiRspBO.setRespCode("0000");
        busiRspBO.setRespDesc("\u901a\u77e5\u8be6\u60c5\u67e5\u8be2\u6210\u529f\uff01");
        return busiRspBO;
    }

    @Override
    public EnquiryDealConfirmItemPageRspBO queryNoticeQuoteItemList(EnquiryDealNoticeQueryReqBO reqBO) {
        Page page = new Page(reqBO.getPageNo().intValue(), reqBO.getPageSize().intValue());
        DealConfirmItemPO itemQueryPO = new DealConfirmItemPO();
        itemQueryPO.setDealNoticeId(reqBO.getDealNoticeId());
        List<DealConfirmItemBusiBO> quoteItemBusiBOList = this.dealConfirmItemMapper.selectNoticeExecuteItemBy(itemQueryPO, (Page<DealConfirmItemBusiBO>)page);
        EnquiryDealConfirmItemPageRspBO busiRspBO = new EnquiryDealConfirmItemPageRspBO();
        if (CollectionUtils.isEmpty(quoteItemBusiBOList)) {
            busiRspBO.setRespCode("0000");
            busiRspBO.setRespDesc("\u67e5\u8be2\u7ed3\u679c\u4e3a\u7a7a\uff01");
            return busiRspBO;
        }
        DealConfirmItemBusiReqBO itemBusiReqBO = new DealConfirmItemBusiReqBO();
        BeanUtil.copyProperties((Object)reqBO, (Object)((Object)itemBusiReqBO));
        itemBusiReqBO.setQuoteItemBusiBOList(quoteItemBusiBOList);
        List rows = this.enquiryDealConfirmDetailBusiService.getConfirmItemTransResultList(itemBusiReqBO).getQuotePlanItemBOS();
        if (!StringUtils.isEmpty((CharSequence)reqBO.getRedisNo())) {
            DealNoticeMatchPO matchPO = new DealNoticeMatchPO();
            matchPO.setDealNoticeId(reqBO.getDealNoticeId());
            matchPO.setRedisNo(reqBO.getRedisNo());
            List<DealNoticeMatchPO> dealNoticeMatchPOList = this.dealNoticeMatchMapper.selectMidListBy(matchPO);
            if (!CollectionUtils.isEmpty(dealNoticeMatchPOList)) {
                block0: for (EnquiryExecuteQuotePlanItemBO item : rows) {
                    for (DealNoticeMatchPO dealNoticeMatchPO : dealNoticeMatchPOList) {
                        if (dealNoticeMatchPO.getDealConfirmItemId().longValue() != item.getDealConfirmItemId().longValue()) continue;
                        item.setProductCode(dealNoticeMatchPO.getProductCode());
                        item.setOutsideProductCode(dealNoticeMatchPO.getOutsideProductCode());
                        item.setAgreementItemCode(dealNoticeMatchPO.getAgreementItemCode());
                        item.setUpcCode(dealNoticeMatchPO.getUpcCode());
                        continue block0;
                    }
                }
            }
        }
        busiRspBO.setRows(rows);
        busiRspBO.setTotal(Integer.valueOf(page.getTotalPages()));
        busiRspBO.setRecordsTotal(Integer.valueOf(page.getTotalCount()));
        busiRspBO.setPageNo(Integer.valueOf(page.getPageNo()));
        busiRspBO.setRespCode("0000");
        busiRspBO.setRespDesc("\u901a\u77e5\u62a5\u4ef7\u660e\u7ec6\u67e5\u8be2\u6210\u529f\uff01");
        return busiRspBO;
    }

    @Override
    public EnquiryDealNoticeMatchRspBO dealMatchPutShelf(EnquirySupplierDealConfirmReqBO reqBO) {
        Long dealNoticeId = reqBO.getDealNoticeId();
        if (dealNoticeId == null) {
            throw new BusinessException("8888", "\u6210\u4ea4\u901a\u77e5id\u4e0d\u80fd\u4e3a\u7a7a");
        }
        List confirmItemBoList = reqBO.getConfirmItemList();
        if (CollUtil.isEmpty((Collection)confirmItemBoList)) {
            throw new BusinessException("8888", "\u6210\u4ea4\u660e\u7ec6\u4e0d\u80fd\u4e3a\u7a7a");
        }
        List<Long> confirmItemIdList = confirmItemBoList.stream().map(EnquirySupplierConfirmItemBo::getDealConfirmItemId).collect(Collectors.toList());
        DealConfirmItemPO confirmItemQueryPO = new DealConfirmItemPO();
        confirmItemQueryPO.setItemIdList(confirmItemIdList);
        List<DealConfirmItemPO> confirmItemPOList = this.dealConfirmItemMapper.selectListBy(confirmItemQueryPO);
        if (CollUtil.isEmpty(confirmItemPOList)) {
            throw new BusinessException("8888", "\u6210\u4ea4\u660e\u7ec6\u90fd\u4e0d\u5b58\u5728");
        }
        DealConfirmItemPO dealConfirmItemPO = (DealConfirmItemPO)CollUtil.getFirst(confirmItemPOList);
        ExecuteBillPO executeBillPO = this.executeBillMapper.selectByPrimaryKey(dealConfirmItemPO.getExecuteId());
        Map<Long, DealConfirmItemPO> confrimMap = confirmItemPOList.stream().collect(Collectors.toMap(DealConfirmItemPO::getDealConfirmItemId, i -> i));
        ArrayList<DealNoticeMatchPO> matchPOList = new ArrayList<DealNoticeMatchPO>();
        int checkSkuType = 1;
        int checkAgreeType = 2;
        DealNoticeMatchPO qryMatchPO = new DealNoticeMatchPO();
        qryMatchPO.setDealNoticeId(reqBO.getDealNoticeId());
        qryMatchPO.setRedisNo(reqBO.getRedisNo());
        List<DealNoticeMatchPO> dealNoticeMatchPOList = this.dealNoticeMatchMapper.selectMidListBy(qryMatchPO);
        for (DealNoticeMatchPO dealNoticeMatchPO : dealNoticeMatchPOList) {
            Long confirmItemId = dealNoticeMatchPO.getDealConfirmItemId();
            DealConfirmItemPO confirmItemPO = confrimMap.get(confirmItemId);
            if (confirmItemPO == null) {
                throw new BusinessException("8888", "\u6210\u4ea4\u660e\u7ec6\u3010" + confirmItemId + "\u3011\u4e0d\u5b58\u5728");
            }
            String productCode = dealNoticeMatchPO.getProductCode();
            String string = dealNoticeMatchPO.getOutsideProductCode();
            String agreementItemCode = dealNoticeMatchPO.getAgreementItemCode();
            dealNoticeMatchPO.setDealNoticeId(dealNoticeId);
            dealNoticeMatchPO.setExecuteId(confirmItemPO.getExecuteId());
            dealNoticeMatchPO.setExecuteCode(executeBillPO.getExecuteCode());
            Long executeItemId = confirmItemPO.getExecuteItemId();
            dealNoticeMatchPO.setExecuteItemId(executeItemId);
            if (StrUtil.isNotBlank((CharSequence)productCode)) {
                dealNoticeMatchPO.setQueryType(checkSkuType);
            } else if (StrUtil.isNotBlank((CharSequence)string)) {
                dealNoticeMatchPO.setQueryType(checkSkuType);
            } else {
                if (StrUtil.isBlank((CharSequence)agreementItemCode)) {
                    throw new BusinessException("8888", "\u7269\u9879\u3010" + executeItemId + "\u3011\u8bf7\u8f93\u5165\u5546\u54c1\u7f16\u7801\u3001\u5916\u90e8\u5546\u54c1\u7f16\u7801\u3001\u534f\u8bae\u7f16\u7801\uff01");
                }
                dealNoticeMatchPO.setQueryType(checkAgreeType);
            }
            matchPOList.add(dealNoticeMatchPO);
        }
        Map<Integer, List<DealNoticeMatchPO>> matchMap = matchPOList.stream().collect(Collectors.groupingBy(DealNoticeMatchPO::getQueryType));
        Byte success = EnquiryConstant.DealMatchResult.SUCCESS.byteValue();
        Byte fail = EnquiryConstant.DealMatchResult.FAIL.byteValue();
        String errorMsg = "\u672a\u5339\u914d\u5230\u5546\u54c1/\u7269\u9879";
        for (Map.Entry entry : matchMap.entrySet()) {
            int queryType = (Integer)entry.getKey();
            List matchTypeList = (List)entry.getValue();
            if (queryType == checkSkuType) {
                this.getSkuMatchResultList(reqBO, executeBillPO, errorMsg, success, fail, matchTypeList);
                continue;
            }
            if (queryType != checkAgreeType) continue;
            this.getAgreeMatchResultList(reqBO, errorMsg, success, fail, matchTypeList);
        }
        DealNoticeMatchPO matchDelPO = new DealNoticeMatchPO();
        matchDelPO.setDealNoticeId(dealNoticeId);
        this.dealNoticeMatchMapper.deleteBy(matchDelPO);
        HashMap<Long, DealNoticeMatchPO> hashMap = new HashMap<Long, DealNoticeMatchPO>();
        for (DealNoticeMatchPO matchPO : matchPOList) {
            matchPO.setDealMatchId(this.idUtil.nextId());
            if (EnquiryConstant.DealMatchResult.SUCCESS.byteValue() == matchPO.getMatchResult().byteValue()) {
                hashMap.put(matchPO.getDealConfirmItemId(), matchPO);
            }
            matchPO.setMatchStatus(EnquiryConstant.ConfirmMatchResultFlag.FAIL.byteValue());
            this.dealNoticeMatchMapper.insert(matchPO);
        }
        if (CollUtil.isNotEmpty(hashMap)) {
            DealConfirmItemPO confirmQueryPO = new DealConfirmItemPO();
            confirmQueryPO.setItemIdList(new ArrayList<Long>(hashMap.keySet()));
            List<DealConfirmItemPO> confirmItemList = this.dealConfirmItemMapper.selectListBy(confirmQueryPO);
            HashMap<Long, DealNoticeMatchPO> supQuoteItemMap = new HashMap<Long, DealNoticeMatchPO>();
            for (DealConfirmItemPO dealConfirm : confirmItemList) {
                Long confirmItemId = dealConfirm.getDealConfirmItemId();
                DealNoticeMatchPO matchPO = (DealNoticeMatchPO)hashMap.get(confirmItemId);
                supQuoteItemMap.put(dealConfirm.getQuoteItemId(), matchPO);
            }
            SupQuoteItemPO itemQueryPO = new SupQuoteItemPO();
            itemQueryPO.setQuoteItemIdList(new ArrayList<Long>(supQuoteItemMap.keySet()));
            List<SupQuoteItemPO> supQuoteItemPOList = this.supQuoteItemMapper.selectListBy(itemQueryPO);
            for (SupQuoteItemPO supQuoteItemPO : supQuoteItemPOList) {
                Long quoteItemId = supQuoteItemPO.getQuoteItemId();
                DealNoticeMatchPO newItem = (DealNoticeMatchPO)supQuoteItemMap.get(quoteItemId);
                supQuoteItemPO.setProductCode(newItem.getProductCode());
                supQuoteItemPO.setOutsideProductCode(newItem.getOutsideProductCode());
                supQuoteItemPO.setAgreementItemCode(newItem.getAgreementItemCode());
                supQuoteItemPO.setUpcCode(newItem.getUpcCode());
                this.supQuoteItemMapper.updateByPrimaryKeySelective(supQuoteItemPO);
            }
        }
        EnquiryDealNoticeQueryReqBO noticeQueryReqBO = new EnquiryDealNoticeQueryReqBO();
        noticeQueryReqBO.setDealNoticeId(dealNoticeId);
        noticeQueryReqBO.setPageNo(reqBO.getPageNo());
        noticeQueryReqBO.setPageSize(reqBO.getPageSize());
        EnquiryDealNoticeMatchPageRspBO matchPageRspBO = this.queryMatchList(noticeQueryReqBO);
        EnquiryDealNoticeMatchRspBO matchRspBO = new EnquiryDealNoticeMatchRspBO();
        matchRspBO.setMatchPageRspBO(matchPageRspBO);
        matchRspBO.setRespCode("0000");
        matchRspBO.setRespDesc("\u5339\u914d\u5546\u54c1\u5b8c\u6210\uff01");
        return matchRspBO;
    }

    private void getSkuMatchResultList(EnquirySupplierDealConfirmReqBO reqBO, ExecuteBillPO executeBillPO, String errorMsg, Byte success, Byte fail, List<DealNoticeMatchPO> matchTypeList) {
        if (reqBO.getSupId() == null) {
            throw new BusinessException("8888", "\u4f9b\u5e94\u5546\u6237id\u3010supId\u3011\u4e0d\u80fd\u4e3a\u7a7a");
        }
        ArrayList<UccSkuIdAndExtIdBO> skuList = new ArrayList<UccSkuIdAndExtIdBO>();
        for (DealNoticeMatchPO dealNoticeMatchPO : matchTypeList) {
            UccSkuIdAndExtIdBO uccSkuIdAndExtIdBO = new UccSkuIdAndExtIdBO();
            if (StrUtil.isNotBlank((CharSequence)dealNoticeMatchPO.getProductCode())) {
                uccSkuIdAndExtIdBO.setSkuId(Long.valueOf(Long.parseLong(dealNoticeMatchPO.getProductCode())));
            }
            if (StrUtil.isNotBlank((CharSequence)dealNoticeMatchPO.getOutsideProductCode())) {
                uccSkuIdAndExtIdBO.setExtSkuId(dealNoticeMatchPO.getOutsideProductCode());
            }
            skuList.add(uccSkuIdAndExtIdBO);
        }
        UccSkuQryBySkuIdsAbilityReqBO uccSkuQryBySkuIdsAbilityReqBO = new UccSkuQryBySkuIdsAbilityReqBO();
        BeanUtil.copyProperties((Object)reqBO, (Object)uccSkuQryBySkuIdsAbilityReqBO);
        uccSkuQryBySkuIdsAbilityReqBO.setSourceCode(executeBillPO.getExecuteCode());
        uccSkuQryBySkuIdsAbilityReqBO.setSkuIdAndExtIdList(skuList);
        uccSkuQryBySkuIdsAbilityReqBO.setPageSize(skuList.size());
        UccSkuQryBySkuIdsAbilityRspBO skuQryBySkuIdsAbilityRspBO = this.uccSkuQryBySkuIdsAbilityService.qryBySkuIdAndExtIds(uccSkuQryBySkuIdsAbilityReqBO);
        List skuQryBySkuIdsBOList = skuQryBySkuIdsAbilityRspBO.getRows();
        if (CollUtil.isEmpty((Collection)skuQryBySkuIdsBOList)) {
            String rspError = "\u67e5\u8be2\u5546\u54c1\u5931\u8d25\uff0c" + skuQryBySkuIdsAbilityRspBO.getRespDesc();
            throw new BusinessException("8888", rspError);
        }
        HashMap<String, UccSkuQryBySkuIdsBO> skuMap = new HashMap<String, UccSkuQryBySkuIdsBO>();
        for (UccSkuQryBySkuIdsBO uccSkuQryBySkuIdsBO : skuQryBySkuIdsBOList) {
            skuMap.put(String.valueOf(uccSkuQryBySkuIdsBO.getSkuId()), uccSkuQryBySkuIdsBO);
            skuMap.put(String.valueOf(uccSkuQryBySkuIdsBO.getExtSkuId()), uccSkuQryBySkuIdsBO);
        }
        for (DealNoticeMatchPO dealNoticeMatchPO : matchTypeList) {
            String matchCode = this.getMatchCode(dealNoticeMatchPO.getProductCode(), dealNoticeMatchPO.getOutsideProductCode());
            if (skuMap.containsKey(matchCode)) {
                boolean matchOkStatue;
                UccSkuQryBySkuIdsBO skuQryBySkuIdsBO = (UccSkuQryBySkuIdsBO)skuMap.get(matchCode);
                log.info("\u672c\u5355\u4f4d\u4fe1\u606f" + reqBO.getSupId() + ";\u5546\u54c1\u4f9b\u5e94\u5546\u4fe1\u606f\u4e3a\uff1a" + skuQryBySkuIdsBO.getVendorId());
                if (StrUtil.isBlank((CharSequence)skuQryBySkuIdsBO.getSkuStatus())) {
                    dealNoticeMatchPO.setMatchResult(fail);
                    dealNoticeMatchPO.setRemarks(skuQryBySkuIdsBO.getFailReason());
                    continue;
                }
                if (!reqBO.getSupId().equals(skuQryBySkuIdsBO.getVendorId())) {
                    dealNoticeMatchPO.setMatchResult(fail);
                    dealNoticeMatchPO.setRemarks("\u7f16\u7801\u3010" + matchCode + "\u3011\u5bf9\u5e94\u7684\u5546\u54c1\u4e0d\u5c5e\u4e8e\u672c\u4f9b\u5e94\u5546\uff01");
                    continue;
                }
                String skuStatus = skuQryBySkuIdsBO.getSkuStatus();
                boolean bl = matchOkStatue = "15".equals(skuStatus) || "4".equals(skuStatus) || "1".equals(skuStatus) || "2".equals(skuStatus) || "3".equals(skuStatus);
                if (!matchOkStatue) {
                    dealNoticeMatchPO.setMatchResult(fail);
                    dealNoticeMatchPO.setRemarks("\u7f16\u7801\u3010" + matchCode + "\u3011\u5bf9\u5e94\u7684\u5546\u54c1\u4e0d\u4e3a\u5f85\u63d0\u4ea4\u3001\u5f85\u5ba1\u6279\u3001\u5f85\u4e0a\u67b6\u6216\u5df2\u4e0a\u67b6\uff01");
                    continue;
                }
                String productStatus = EnquiryCommonUtil.getProductStatus(skuStatus);
                dealNoticeMatchPO.setProductStatus(Byte.valueOf(productStatus));
                dealNoticeMatchPO.setSkuName(skuQryBySkuIdsBO.getSkuName());
                if (skuQryBySkuIdsBO.getSkuPrice() != null) {
                    BigDecimal multiple = new BigDecimal(10000);
                    dealNoticeMatchPO.setSalePrice(new BigDecimal(skuQryBySkuIdsBO.getSkuPrice()).divide(multiple, 2, 4));
                }
                dealNoticeMatchPO.setProductCode(String.valueOf(skuQryBySkuIdsBO.getSkuId()));
                dealNoticeMatchPO.setSupplierShopId(skuQryBySkuIdsBO.getSupplierShopId());
                dealNoticeMatchPO.setMatchResult(success);
                continue;
            }
            dealNoticeMatchPO.setMatchResult(fail);
            dealNoticeMatchPO.setRemarks(errorMsg);
        }
    }

    private void getAgreeMatchResultList(EnquirySupplierDealConfirmReqBO reqBO, String errorMsg, Byte success, Byte fail, List<DealNoticeMatchPO> matchTypeList) {
        if (reqBO.getSupId() == null) {
            throw new BusinessException("8888", "\u4f9b\u5e94\u5546\u6237id\u3010supId\u3011\u4e0d\u80fd\u4e3a\u7a7a");
        }
        ArrayList<Long> agreementIds = new ArrayList<Long>();
        for (DealNoticeMatchPO dealNoticeMatchPO : matchTypeList) {
            String agreeId = dealNoticeMatchPO.getAgreementItemCode();
            if (NumberUtil.isNumber((CharSequence)agreeId)) {
                agreementIds.add(Long.parseLong(agreeId));
                continue;
            }
            throw new BusinessException("8888", "\u534f\u8bae\u7f16\u7801\u3010" + agreeId + "\u3011\u4e0d\u5b58\u5728\uff01");
        }
        AgrQryAgreementSkuByPageAbilityReqBO agrQryAgreementSkuByPageAbilityReqBO = new AgrQryAgreementSkuByPageAbilityReqBO();
        BeanUtil.copyProperties((Object)reqBO, (Object)agrQryAgreementSkuByPageAbilityReqBO);
        agrQryAgreementSkuByPageAbilityReqBO.setPageQueryFlag(Boolean.valueOf(false));
        agrQryAgreementSkuByPageAbilityReqBO.setAgreementSkuIds(agreementIds);
        agrQryAgreementSkuByPageAbilityReqBO.setAgreementStatus(new ArrayList(Byte.parseByte("4")));
        AgrQryAgreementSkuByPageAbilityRspBO agrQryAgreementSkuByPageAbilityRspBO = this.agrQryAgreementSkuByPageAbilityService.qryAgreementSkuByPage(agrQryAgreementSkuByPageAbilityReqBO);
        List agrAgreementSkuBOList = agrQryAgreementSkuByPageAbilityRspBO.getRows();
        if (CollUtil.isEmpty((Collection)agrAgreementSkuBOList)) {
            String rspError = "\u67e5\u8be2\u534f\u8bae\u5546\u54c1\u5931\u8d25\uff0c" + agrQryAgreementSkuByPageAbilityRspBO.getRespDesc();
            throw new BusinessException("8888", rspError);
        }
        HashMap<String, AgrAgreementSkuBO> agreeMap = new HashMap<String, AgrAgreementSkuBO>();
        for (AgrAgreementSkuBO agrAgreementSkuBO : agrAgreementSkuBOList) {
            agreeMap.put(String.valueOf(agrAgreementSkuBO.getAgreementSkuId()), agrAgreementSkuBO);
        }
        for (DealNoticeMatchPO dealNoticeMatchPO : matchTypeList) {
            String agreeId = dealNoticeMatchPO.getAgreementItemCode();
            if (agreeMap.containsKey(agreeId)) {
                AgrAgreementSkuBO agrAgreementSkuBO = (AgrAgreementSkuBO)agreeMap.get(agreeId);
                log.info("\u672c\u5355\u4f4d\u4fe1\u606f" + reqBO.getSupId() + ";\u5546\u54c1\u4f9b\u5e94\u5546\u4fe1\u606f\u4e3a\uff1a" + agrAgreementSkuBO.getVendorId());
                if (!reqBO.getSupId().equals(agrAgreementSkuBO.getVendorId())) {
                    dealNoticeMatchPO.setMatchResult(fail);
                    dealNoticeMatchPO.setRemarks("\u534f\u8bae\u7f16\u7801\u3010" + agreeId + "\u3011\u5bf9\u5e94\u7684\u5546\u54c1\u4e0d\u5c5e\u4e8e\u672c\u4f9b\u5e94\u5546\uff01");
                    continue;
                }
                dealNoticeMatchPO.setSkuName(agrAgreementSkuBO.getItemName());
                if (agrAgreementSkuBO.getSalePrice() != null) {
                    BigDecimal multiple = new BigDecimal(10000);
                    dealNoticeMatchPO.setSalePrice(new BigDecimal(agrAgreementSkuBO.getSalePrice()).divide(multiple, 2, 4));
                }
                dealNoticeMatchPO.setAgreementSkuId(agrAgreementSkuBO.getAgreementSkuId());
                dealNoticeMatchPO.setMatchResult(success);
                continue;
            }
            dealNoticeMatchPO.setMatchResult(fail);
            dealNoticeMatchPO.setRemarks(errorMsg);
        }
    }

    private String getMatchCode(String skuId, String extSkuId) {
        String skuCode = "";
        if (StrUtil.isNotBlank((CharSequence)skuId)) {
            skuCode = skuId;
        } else if (StrUtil.isNotBlank((CharSequence)extSkuId)) {
            skuCode = extSkuId;
        }
        return skuCode;
    }

    @Override
    public EnquiryDealNoticeRspBO dealMatchConfirm(EnquirySupplierDealConfirmReqBO reqBO) {
        Long dealNoticeId = reqBO.getDealNoticeId();
        if (dealNoticeId == null) {
            throw new BusinessException("8888", "\u6210\u4ea4\u901a\u77e5id\u4e0d\u80fd\u4e3a\u7a7a");
        }
        DealNoticePO noticePO = this.dealNoticeMapper.selectByPrimaryKey(dealNoticeId);
        if (noticePO == null) {
            throw new BusinessException("8888", "\u6210\u4ea4\u901a\u77e5\u4e0d\u5b58\u5728");
        }
        ExecuteBillPO executeBillPO = this.executeBillMapper.selectByPrimaryKey(noticePO.getExecuteId());
        DealNoticeMatchPO matchPO = new DealNoticeMatchPO();
        matchPO.setDealNoticeId(reqBO.getDealNoticeId());
        Page page = new Page(-1, reqBO.getPageSize().intValue());
        List<DealNoticeMatchBusiBO> matchPOList = this.dealNoticeMatchMapper.selectBy(matchPO, (Page<DealNoticeMatchBusiBO>)page);
        int failCount = 0;
        ArrayList<DealNoticeMatchBusiBO> noAuditMatchList = new ArrayList<DealNoticeMatchBusiBO>();
        for (DealNoticeMatchBusiBO noticeMatchPO : matchPOList) {
            if (noticeMatchPO.getProductStatus() != null) {
                int productStatus = noticeMatchPO.getProductStatus().intValue();
                if (EnquiryConstant.MatchProductStatus.WAITING_APPROVAL == productStatus || EnquiryConstant.MatchProductStatus.WAITING_SUBMIT == productStatus) {
                    noAuditMatchList.add(noticeMatchPO);
                }
            }
            if (noticeMatchPO.getMatchResult() != null) {
                int matchResult = noticeMatchPO.getMatchResult().intValue();
                if (EnquiryConstant.DealMatchResult.SUCCESS != matchResult) {
                    ++failCount;
                }
            }
            noticeMatchPO.setMatchStatus(EnquiryConstant.ConfirmMatchResultFlag.SUCCESS.byteValue());
            this.dealNoticeMatchMapper.updateByPrimaryKeySelective(noticeMatchPO);
        }
        if (failCount > 0) {
            throw new BusinessException("8888", "\u6709\u5339\u914d\u5931\u8d25\u7684\u4e0a\u67b6\u4fe1\u606f\uff0c\u5339\u914d\u672a\u5b8c\u6210");
        }
        if (CollUtil.isNotEmpty(noAuditMatchList)) {
            ArrayList<String> skuIdList = new ArrayList<String>();
            ArrayList<String> extSkuIdList = new ArrayList<String>();
            for (DealNoticeMatchBusiBO noticeMatchPO : noAuditMatchList) {
                if (noticeMatchPO.getOutsideProductCode() == null) {
                    skuIdList.add("");
                } else {
                    skuIdList.add(noticeMatchPO.getProductCode());
                }
                if (noticeMatchPO.getOutsideProductCode() == null) {
                    extSkuIdList.add("");
                    continue;
                }
                extSkuIdList.add(noticeMatchPO.getOutsideProductCode());
            }
            String sourceCode = executeBillPO.getExecuteCode();
            String skuIds = CollUtil.join(skuIdList, (CharSequence)",");
            String extSkuIds = CollUtil.join(extSkuIdList, (CharSequence)",");
            String demandUnitName = executeBillPO.getExecuteOrgName();
            Integer quoteNumber = executeBillPO.getSubmitQuoteNumber();
            String source = "1";
            if (quoteNumber != null && quoteNumber > 1) {
                source = "2";
            }
            UccSkuExtensionMatchAbilityReqBO uccSkuExtensionMatchAbilityReqBO = new UccSkuExtensionMatchAbilityReqBO();
            BeanUtil.copyProperties((Object)reqBO, (Object)uccSkuExtensionMatchAbilityReqBO);
            uccSkuExtensionMatchAbilityReqBO.setSkuIds(skuIds);
            uccSkuExtensionMatchAbilityReqBO.setExtSkuIds(extSkuIds);
            uccSkuExtensionMatchAbilityReqBO.setSourceCode(sourceCode);
            uccSkuExtensionMatchAbilityReqBO.setDemandUnitName(demandUnitName);
            uccSkuExtensionMatchAbilityReqBO.setDealNoticeId(noticePO.getDealNoticeId());
            uccSkuExtensionMatchAbilityReqBO.setDealNoticeCode(noticePO.getDealNoticeCode());
            UccSkuExtensionMatchAbilityRspBO uccSkuExtensionMatchAbilityRspBO = this.uccSkuExtensionMatchAbilityService.uccSkuMatch(uccSkuExtensionMatchAbilityReqBO);
            if (!"0000".equals(uccSkuExtensionMatchAbilityRspBO.getRespCode())) {
                throw new BusinessException("8888", uccSkuExtensionMatchAbilityRspBO.getRespDesc());
            }
        }
        DealNoticeItemPO dealNoticeItemPO = new DealNoticeItemPO();
        dealNoticeItemPO.setDealNoticeId(noticePO.getDealNoticeId());
        List<DealNoticeItemPO> dealNoticeItemList = this.dealNoticeItemMapper.selectBy(dealNoticeItemPO);
        List<Long> confirmItemIdList = dealNoticeItemList.stream().map(DealNoticeItemPO::getDealConfirmItemId).collect(Collectors.toList());
        DealConfirmItemPO dealConfirmItemPO = new DealConfirmItemPO();
        dealConfirmItemPO.setItemIdList(confirmItemIdList);
        List<DealConfirmItemPO> confirmItemList = this.dealConfirmItemMapper.selectListBy(dealConfirmItemPO);
        ArrayList<Long> executeItemIdList = new ArrayList<Long>();
        for (DealConfirmItemPO confirmItem : confirmItemList) {
            confirmItem.setExecuteStatus("2013");
            this.dealConfirmItemMapper.updateByPrimaryKeySelective(confirmItem);
            executeItemIdList.add(confirmItem.getExecuteItemId());
        }
        EnquiryDealNoticeReqBO dealNoticeReqBO = new EnquiryDealNoticeReqBO();
        BeanUtil.copyProperties((Object)reqBO, (Object)dealNoticeReqBO);
        dealNoticeReqBO.setDealConfirmId(noticePO.getDealConfirmId());
        this.saveMatchSuccessLog(dealNoticeReqBO, executeItemIdList, executeBillPO.getExecuteId());
        EnquiryDealNoticeRspBO dealNoticeRspBO = new EnquiryDealNoticeRspBO();
        dealNoticeRspBO.setRespCode("0000");
        dealNoticeRspBO.setRespDesc("\u5339\u914d\u7ed3\u679c\u786e\u8ba4\u6210\u529f\uff01");
        return dealNoticeRspBO;
    }

    @Override
    public EnquiryDealNoticeMatchPageRspBO queryMatchList(EnquiryDealNoticeQueryReqBO reqBO) {
        Long dealNoticeId = reqBO.getDealNoticeId();
        if (dealNoticeId == null) {
            throw new BusinessException("8888", "\u6210\u4ea4\u901a\u77e5id\u4e0d\u80fd\u4e3a\u7a7a");
        }
        DealNoticeMatchPO matchPO = new DealNoticeMatchPO();
        matchPO.setDealNoticeId(reqBO.getDealNoticeId());
        Page page = new Page(reqBO.getPageNo().intValue(), reqBO.getPageSize().intValue());
        List<DealNoticeMatchBusiBO> matchPOList = this.dealNoticeMatchMapper.selectBy(matchPO, (Page<DealNoticeMatchBusiBO>)page);
        EnquiryDealNoticeMatchPageRspBO busiRspBO = new EnquiryDealNoticeMatchPageRspBO();
        if (CollUtil.isEmpty(matchPOList)) {
            busiRspBO.setRespCode("0000");
            busiRspBO.setRespDesc("\u67e5\u8be2\u7ed3\u679c\u4e3a\u7a7a\uff01");
            return busiRspBO;
        }
        ArrayList<EnquiryDealNoticeMatchBO> rows = new ArrayList<EnquiryDealNoticeMatchBO>();
        for (DealNoticeMatchBusiBO noticeMatchPO : matchPOList) {
            EnquiryDealNoticeMatchBO matchBO = new EnquiryDealNoticeMatchBO();
            BeanUtil.copyProperties((Object)noticeMatchPO, (Object)matchBO);
            if (matchBO.getWxfl() != null) {
                matchBO.setWxflName(matchBO.getWxfl() + "_" + matchBO.getWxflStr());
            }
            if (matchBO.getWlbh() != null) {
                matchBO.setWlbhName(matchBO.getWlbh() + "_" + matchBO.getWlbhStr());
            }
            matchBO.setMatchResultStr(EnquiryEnumConstant.DealMatchResultEnum.getDesc((String)EnquiryCommonUtil.valNull(matchBO.getMatchResult())));
            matchBO.setProductStatusStr(EnquiryEnumConstant.MatchProductStatusEnum.getDesc((String)EnquiryCommonUtil.valNull(matchBO.getProductStatus())));
            rows.add(matchBO);
        }
        busiRspBO.setRows(rows);
        busiRspBO.setTotal(Integer.valueOf(page.getTotalPages()));
        busiRspBO.setRecordsTotal(Integer.valueOf(page.getTotalCount()));
        busiRspBO.setPageNo(Integer.valueOf(page.getPageNo()));
        busiRspBO.setRespCode("0000");
        busiRspBO.setRespDesc("\u5339\u914d\u5206\u9875\u67e5\u8be2\u6210\u529f\uff01");
        return busiRspBO;
    }

    @Override
    public EnquiryDealNoticeRspBO dealMatchCancel(EnquirySupplierDealConfirmReqBO reqBO) {
        Long dealNoticeId = reqBO.getDealNoticeId();
        if (dealNoticeId == null) {
            throw new BusinessException("8888", "\u6210\u4ea4\u901a\u77e5id\u4e0d\u80fd\u4e3a\u7a7a");
        }
        DealNoticeMatchPO matchDelPO = new DealNoticeMatchPO();
        matchDelPO.setDealNoticeId(dealNoticeId);
        this.dealNoticeMatchMapper.deleteBy(matchDelPO);
        EnquiryDealNoticeRspBO dealNoticeRspBO = new EnquiryDealNoticeRspBO();
        dealNoticeRspBO.setRespCode("0000");
        dealNoticeRspBO.setRespDesc("\u53d6\u6d88\u5339\u914d\u6210\u529f\uff01");
        return dealNoticeRspBO;
    }

    @Override
    public EnquiryDealNoticeRspBO queryNoPutShelfByTime(EnquiryDealNoticeQueryReqBO reqBO) {
        List<DealNoticePO> noticePOList = this.dealNoticeMapper.getOverPutShelfList();
        log.info("\u8d85\u8fc7\u4e0a\u67b6\u5468\u671f:" + JSON.toJSONString(noticePOList));
        ArrayList<Long> noMatchList = new ArrayList<Long>();
        if (CollUtil.isNotEmpty(noticePOList)) {
            List noticeMatchList;
            Set noticeIdSet = noticePOList.stream().map(DealNoticePO::getDealNoticeId).collect(Collectors.toSet());
            DealNoticeMatchPO dealNoticeMatchPO = new DealNoticeMatchPO();
            dealNoticeMatchPO.setDealNoticeIdList(CollUtil.newArrayList(noticeIdSet));
            List<DealNoticeMatchPO> matchList = this.dealNoticeMatchMapper.selectListBy(dealNoticeMatchPO);
            HashMap matchMap = new HashMap();
            if (CollUtil.isNotEmpty(matchList)) {
                for (DealNoticeMatchPO matchPO : matchList) {
                    Long noticeId = matchPO.getDealNoticeId();
                    noticeMatchList = matchMap.containsKey(noticeId) ? (List)matchMap.get(noticeId) : new ArrayList();
                    noticeMatchList.add(matchPO);
                    matchMap.put(noticeId, noticeMatchList);
                }
            }
            for (Long noticeId : noticeIdSet) {
                if (matchMap.containsKey(noticeId)) {
                    noticeMatchList = (ArrayList)matchMap.get(noticeId);
                    int failCount = 0;
                    for (DealNoticeMatchPO matchPO : noticeMatchList) {
                        int matchResult = matchPO.getMatchResult().intValue();
                        if (EnquiryConstant.DealMatchResult.SUCCESS == matchResult) continue;
                        ++failCount;
                    }
                    if (failCount <= 0) continue;
                    noMatchList.add(noticeId);
                    continue;
                }
                noMatchList.add(noticeId);
            }
        }
        EnquiryDealNoticeRspBO rspBO = new EnquiryDealNoticeRspBO();
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("\u67e5\u8be2\u5339\u914d\u5931\u8d25\u6570\u636e\u5b8c\u6210\uff01");
        rspBO.setNoticeIdList(noMatchList);
        return rspBO;
    }

    private void saveMatchSuccessLog(EnquiryDealNoticeReqBO reqBO, List<Long> executeItemIdList, Long executeId) {
        Long confirmId = reqBO.getDealConfirmId();
        DealConfirmItemPO confirmItemQueryPO = new DealConfirmItemPO();
        confirmItemQueryPO.setDealConfirmId(confirmId);
        confirmItemQueryPO.setExecuteItemIdList(executeItemIdList);
        List<DealConfirmItemPO> confirmItemPOList = this.dealConfirmItemMapper.selectListBy(confirmItemQueryPO);
        Map<Long, List<DealConfirmItemPO>> confrimMap = confirmItemPOList.stream().collect(Collectors.groupingBy(DealConfirmItemPO::getExecuteItemId));
        ArrayList<Long> workIngList = new ArrayList<Long>();
        ArrayList<Long> finishList = new ArrayList<Long>();
        for (Map.Entry<Long, List<DealConfirmItemPO>> entry : confrimMap.entrySet()) {
            Long executeItem = entry.getKey();
            List<DealConfirmItemPO> itemList = entry.getValue();
            String waitMatch = "2014";
            Map<String, Long> nameMap = itemList.stream().collect(Collectors.groupingBy(DealConfirmItemPO::getExecuteStatus, Collectors.counting()));
            Long wailtCount = 0L;
            if (nameMap.containsKey(waitMatch)) {
                wailtCount = nameMap.get(waitMatch);
            }
            if (wailtCount > 0L) {
                workIngList.add(executeItem);
                continue;
            }
            finishList.add(executeItem);
        }
        if (CollUtil.isNotEmpty(workIngList)) {
            this.saveMatchLog(reqBO, executeId, workIngList, EnquiryEnumConstant.BasPhaseStatusEnum.WORKING.getCode(), 1);
        }
        if (CollUtil.isNotEmpty(finishList)) {
            this.saveMatchLog(reqBO, executeId, finishList, EnquiryEnumConstant.BasPhaseStatusEnum.FINISH.getCode(), 2);
            UpdateExecuteItemStatusReqBO executeItemStatusReqBO = UpdateExecuteItemStatusReqBO.builder().executeItemIdList(finishList).executeStatus("2013").planExecuteUpdateType(null).planExecuteStatus(null).build();
            EnquiryExecuteItemRspBO itemRspBO = this.executeItemBusiService.updateExecuteItemStatus(executeItemStatusReqBO);
            if (!"0000".equals(itemRspBO.getRespCode())) {
                throw new BusinessException("8888", itemRspBO.getRespDesc());
            }
        }
    }

    private void saveMatchLog(EnquiryDealNoticeReqBO reqBO, Long executeId, List<Long> executeItemIdList, String demanderStatus, int matchResult) {
        EnquiryLogReqBO enquiryLogReqBO;
        BaseAllOperLogRspBO logRspBO;
        Long noticeId = reqBO.getDealNoticeId();
        if (noticeId == null) {
            throw new BusinessException("8888", "\u6210\u4ea4\u901a\u77e5\u4e66id\u4e0d\u80fd\u4e3a\u7a7a");
        }
        DealNoticePO dealNoticePO = this.dealNoticeMapper.selectByPrimaryKey(noticeId);
        String executeStatus = EnquiryEnumConstant.BasPhaseStatusEnum.WORKING.getCode();
        BasePhaseReqBO executePhaseReqBO = new BasePhaseReqBO();
        BeanUtil.copyProperties((Object)reqBO, (Object)executePhaseReqBO);
        executePhaseReqBO.setBusiType("1");
        executePhaseReqBO.setStepNum(EnquiryConstant.BasPhaseExecute.SIX);
        executePhaseReqBO.setRelateId(executeId.toString());
        executePhaseReqBO.setStatus(executeStatus);
        if (matchResult == 0) {
            ArrayList<BasePhaseItemBO> basePhaseItemBOList = new ArrayList<BasePhaseItemBO>();
            BasePhaseItemBO basePhaseItemBO = new BasePhaseItemBO();
            basePhaseItemBO.setDealBusId(dealNoticePO.getDealNoticeId());
            basePhaseItemBO.setDealBusCode(dealNoticePO.getDealNoticeCode());
            BeanUtil.copyProperties((Object)reqBO, (Object)basePhaseItemBO);
            basePhaseItemBO.setSupplierId(dealNoticePO.getSupplierId());
            basePhaseItemBO.setSupplierName(dealNoticePO.getSupplierName());
            String nextStep = EnquiryEnumConstant.NextStepStatusEnum.WAITING_CONFIRM.getCode();
            basePhaseItemBO.setNextStep(nextStep);
            basePhaseItemBOList.add(basePhaseItemBO);
            executePhaseReqBO.setPhaseItemList(basePhaseItemBOList);
        }
        BasePhaseReqBO demanderPhaseReqBO = new BasePhaseReqBO();
        BeanUtil.copyProperties((Object)reqBO, (Object)demanderPhaseReqBO);
        demanderPhaseReqBO.setBusiType("2");
        demanderPhaseReqBO.setStepNum(EnquiryConstant.BasPhaseCompete.NINE);
        demanderPhaseReqBO.setExecuteItemIdList(executeItemIdList);
        demanderPhaseReqBO.setStatus(demanderStatus);
        ArrayList<BasePhaseItemBO> basePhaseItemBOList = new ArrayList<BasePhaseItemBO>();
        BasePhaseItemBO basePhaseItemBO = new BasePhaseItemBO();
        basePhaseItemBO.setDealBusId(dealNoticePO.getDealNoticeId());
        basePhaseItemBO.setDealBusCode(dealNoticePO.getDealNoticeCode());
        BeanUtil.copyProperties((Object)reqBO, (Object)basePhaseItemBO);
        basePhaseItemBO.setSupplierId(dealNoticePO.getSupplierId());
        basePhaseItemBO.setSupplierName(dealNoticePO.getSupplierName());
        String nextStep = EnquiryEnumConstant.NextStepStatusEnum.WAITING_MATCH.getCode();
        if (matchResult == 1 || matchResult == 2) {
            nextStep = EnquiryEnumConstant.NextStepStatusEnum.WAITING_CONFIRM.getCode();
        }
        basePhaseItemBO.setNextStep(nextStep);
        basePhaseItemBOList.add(basePhaseItemBO);
        demanderPhaseReqBO.setPhaseItemList(basePhaseItemBOList);
        BaseAllOperLogReqBO allOperLogReqBO = null;
        if (matchResult == 2) {
            allOperLogReqBO = new BaseAllOperLogReqBO();
            BeanUtil.copyProperties((Object)reqBO, (Object)allOperLogReqBO);
            allOperLogReqBO.setOperateBusiEnum(EnquiryEnumConstant.AllOperateBusiEnum.TYPE2101);
            allOperLogReqBO.setExecuteItemIdList(executeItemIdList);
        }
        if (!"0000".equals((logRspBO = this.baseAllOperLogBusiService.saveAllOperateLog(enquiryLogReqBO = EnquiryLogReqBO.builder().executePhaseReqBO(executePhaseReqBO).demanderPhaseReqBO(demanderPhaseReqBO).allOperLogReqBO(allOperLogReqBO).build())).getRespCode())) {
            throw new BusinessException("8888", logRspBO.getRespDesc());
        }
    }

    private void saveNoticeItemLog(EnquiryDealNoticeReqBO reqBO, DealNoticePO dealNoticePO, List<Long> executeItemIdList, String demanderStatus) {
        BasePhaseReqBO demanderPhaseReqBO = new BasePhaseReqBO();
        BeanUtil.copyProperties((Object)reqBO, (Object)demanderPhaseReqBO);
        demanderPhaseReqBO.setBusiType("2");
        demanderPhaseReqBO.setStepNum(EnquiryConstant.BasPhaseCompete.Ten);
        demanderPhaseReqBO.setExecuteItemIdList(executeItemIdList);
        demanderPhaseReqBO.setStatus(demanderStatus);
        ArrayList<BasePhaseItemBO> basePhaseItemBOList = new ArrayList<BasePhaseItemBO>();
        BasePhaseItemBO basePhaseItemBO = new BasePhaseItemBO();
        basePhaseItemBO.setDealBusId(dealNoticePO.getDealNoticeId());
        basePhaseItemBO.setDealBusCode(dealNoticePO.getDealNoticeCode());
        BeanUtil.copyProperties((Object)reqBO, (Object)basePhaseItemBO);
        basePhaseItemBO.setSupplierId(dealNoticePO.getSupplierId());
        basePhaseItemBO.setSupplierName(dealNoticePO.getSupplierName());
        String nextStep = EnquiryEnumConstant.NextStepStatusEnum.WAITING_CONFIRM.getCode();
        basePhaseItemBO.setNextStep(nextStep);
        basePhaseItemBOList.add(basePhaseItemBO);
        demanderPhaseReqBO.setPhaseItemList(basePhaseItemBOList);
        EnquiryLogReqBO enquiryLogReqBO = EnquiryLogReqBO.builder().executePhaseReqBO(null).demanderPhaseReqBO(demanderPhaseReqBO).allOperLogReqBO(null).build();
        BaseAllOperLogRspBO logRspBO = this.baseAllOperLogBusiService.saveAllOperateLog(enquiryLogReqBO);
        if (!"0000".equals(logRspBO.getRespCode())) {
            throw new BusinessException("8888", logRspBO.getRespDesc());
        }
    }

    @Override
    public GetDealNoticeRedisNoRspBO getDealNoticeRedisNo(GetDealNoticeRedisNoReqBO reqBO) {
        GetDealNoticeRedisNoRspBO rspBO = new GetDealNoticeRedisNoRspBO();
        DealNoticePO dealNoticePO = this.dealNoticeMapper.selectByPrimaryKey(reqBO.getDealNoticeId());
        if (dealNoticePO == null) {
            rspBO.setRespCode("8888");
            rspBO.setRespDesc("\u6210\u4ea4\u901a\u77e5\u4e0d\u5b58\u5728!");
            return rspBO;
        }
        DealNoticeMatchPO dealNoticeMatchPO = new DealNoticeMatchPO();
        dealNoticeMatchPO.setDealNoticeId(reqBO.getDealNoticeId());
        this.dealNoticeMatchMapper.deleteByCondition(dealNoticeMatchPO);
        String redisNo = UUID.randomUUID().toString();
        ArrayList<DealNoticeMatchPO> addDealNoticeMatchPOList = new ArrayList<DealNoticeMatchPO>();
        DealNoticeMatchPO matchPO = new DealNoticeMatchPO();
        matchPO.setDealNoticeId(reqBO.getDealNoticeId());
        List<DealNoticeMatchPO> dealNoticeMatchPOList = this.dealNoticeMatchMapper.selectListBy(matchPO);
        for (DealNoticeMatchPO addMatchPO : dealNoticeMatchPOList) {
            addMatchPO.setDealMatchMidId(this.idUtil.nextId());
            addMatchPO.setRedisNo(redisNo);
            addDealNoticeMatchPOList.add(addMatchPO);
        }
        if (CollectionUtils.isEmpty(addDealNoticeMatchPOList)) {
            DealNoticeItemPO dealNoticeItemPO = new DealNoticeItemPO();
            dealNoticeItemPO.setDealNoticeId(reqBO.getDealNoticeId());
            List<DealNoticeItemPO> dealNoticeItemPOList = this.dealNoticeItemMapper.selectBy(dealNoticeItemPO);
            SupQuoteItemPO qrySupQuoteItemPO = new SupQuoteItemPO();
            qrySupQuoteItemPO.setQuoteId(dealNoticePO.getQuoteId());
            List<SupQuoteItemPO> supQuoteItemPOList = this.supQuoteItemMapper.selectListBy(qrySupQuoteItemPO);
            for (DealNoticeItemPO dealNoticeItem : dealNoticeItemPOList) {
                DealNoticeMatchPO addMatchPO = new DealNoticeMatchPO();
                BeanUtil.copyProperties((Object)dealNoticeItem, (Object)addMatchPO);
                for (SupQuoteItemPO supQuoteItemPO : supQuoteItemPOList) {
                    if (supQuoteItemPO.getQuoteItemId().longValue() != dealNoticeItem.getQuoteItemId().longValue()) continue;
                    addMatchPO.setProductCode(supQuoteItemPO.getProductCode());
                    addMatchPO.setOutsideProductCode(supQuoteItemPO.getOutsideProductCode());
                    addMatchPO.setAgreementItemCode(supQuoteItemPO.getAgreementItemCode());
                    addMatchPO.setUpcCode(supQuoteItemPO.getUpcCode());
                    break;
                }
                addMatchPO.setDealMatchMidId(this.idUtil.nextId());
                addMatchPO.setRedisNo(redisNo);
                addDealNoticeMatchPOList.add(addMatchPO);
            }
        }
        this.dealNoticeMatchMapper.insertMidBatch(addDealNoticeMatchPOList);
        rspBO.setRedisNo(redisNo);
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("\u6210\u529f");
        return rspBO;
    }

    @Override
    public EnquiryDealNoticeMatchRspBO dealDealMatchPutShelf(EnquirySupplierDealConfirmReqBO reqBO) {
        EnquiryDealNoticeMatchRspBO rspBO = new EnquiryDealNoticeMatchRspBO();
        DealNoticePO dealNoticePO = this.dealNoticeMapper.selectByPrimaryKey(reqBO.getDealNoticeId());
        if (dealNoticePO == null || !"1".equals(dealNoticePO.getDealBillStatus())) {
            rspBO.setRespCode("8888");
            rspBO.setRespDesc("\u5f85\u786e\u8ba4\u6210\u4ea4\u901a\u77e5\u4e0d\u5b58\u5728!");
            return rspBO;
        }
        DealNoticeMatchPO matchPO = new DealNoticeMatchPO();
        matchPO.setDealNoticeId(reqBO.getDealNoticeId());
        matchPO.setRedisNo(reqBO.getRedisNo());
        List<DealNoticeMatchPO> dealNoticeMatchPOList = this.dealNoticeMatchMapper.selectMidListBy(matchPO);
        if (CollectionUtils.isEmpty(dealNoticeMatchPOList)) {
            rspBO.setRespCode("8888");
            rspBO.setRespDesc("\u6210\u4ea4\u901a\u77e5\u660e\u7ec6\u4e34\u65f6\u660e\u7ec6\u4fe1\u606f\u4e0d\u5b58\u5728!");
            return rspBO;
        }
        ArrayList<DealNoticeMatchPO> list = new ArrayList<DealNoticeMatchPO>();
        block0: for (EnquirySupplierConfirmItemBo item : reqBO.getConfirmItemList()) {
            for (DealNoticeMatchPO dealNoticeMatchPO : dealNoticeMatchPOList) {
                if (dealNoticeMatchPO.getDealConfirmItemId().longValue() != item.getDealConfirmItemId().longValue()) continue;
                dealNoticeMatchPO.setProductCode(item.getProductCode());
                dealNoticeMatchPO.setOutsideProductCode(item.getOutsideProductCode());
                dealNoticeMatchPO.setAgreementItemCode(item.getAgreementItemCode());
                dealNoticeMatchPO.setUpcCode(item.getUpcCode());
                list.add(dealNoticeMatchPO);
                continue block0;
            }
        }
        if (CollUtil.isNotEmpty(list)) {
            this.dealNoticeMatchMapper.updateDealMidItemByBatch(list, reqBO.getRedisNo());
        }
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("\u6210\u4ea4\u901a\u77e5\u660e\u7ec6\u66f4\u65b0\u6210\u529f");
        return rspBO;
    }
}

