/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.enquiry.busi.impl;

import cn.hutool.core.bean.BeanUtil;
import cn.hutool.core.collection.CollUtil;
import com.alibaba.fastjson.JSONObject;
import com.tydic.enquiry.api.bo.PurchasePlanDealInfoBO;
import com.tydic.enquiry.api.bo.PurchasePlanDealItemListQueryReqBO;
import com.tydic.enquiry.api.bo.PurchasePlanDealItemListQueryRspBO;
import com.tydic.enquiry.api.bo.QryLastLowestQuotationRspBO;
import com.tydic.enquiry.api.bo.QryLastLowestQuoteReqBO;
import com.tydic.enquiry.api.bo.SupQuoteBO;
import com.tydic.enquiry.api.bo.SupQuoteItemBO;
import com.tydic.enquiry.busi.api.EnquiryDealQuoteBusiService;
import com.tydic.enquiry.dao.PlanDealItemMapper;
import com.tydic.enquiry.dao.SupQuoteItemMapper;
import com.tydic.enquiry.dao.SupQuoteMapper;
import com.tydic.enquiry.dao.po.PlanDealItemPO;
import com.tydic.enquiry.dao.po.SupQuoteItemPO;
import com.tydic.enquiry.dao.po.SupQuotePO;
import com.tydic.enquiry.exceptions.BusinessException;
import java.math.BigDecimal;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class EnquiryDealQuoteBusiServiceImpl
implements EnquiryDealQuoteBusiService {
    private static final Logger log = LoggerFactory.getLogger(EnquiryDealQuoteBusiServiceImpl.class);
    @Autowired
    private SupQuoteMapper supQuoteMapper;
    @Autowired
    private SupQuoteItemMapper supQuoteItemMapper;
    @Autowired
    private PlanDealItemMapper planDealItemMapper;

    @Override
    public QryLastLowestQuotationRspBO getSummaryQuoteList(QryLastLowestQuoteReqBO reqBO) {
        QryLastLowestQuotationRspBO rspBO = new QryLastLowestQuotationRspBO();
        ArrayList<SupQuoteBO> rows = new ArrayList<SupQuoteBO>();
        List<SupQuotePO> supQuotePOList = null;
        if ("1".equals(reqBO.getExecuteType())) {
            SupQuotePO queryPO = new SupQuotePO();
            queryPO.setExecuteId(reqBO.getExecuteId());
            supQuotePOList = this.supQuoteMapper.selectLastQuote(queryPO);
        } else if ("2".equals(reqBO.getExecuteType())) {
            SupQuotePO queryPO;
            String confirmDealType = reqBO.getConfirmDealType();
            if ("2".equals(confirmDealType) || "3".equals(confirmDealType)) {
                queryPO = new SupQuotePO();
                queryPO.setExecuteId(reqBO.getExecuteId());
                supQuotePOList = this.supQuoteMapper.selectBiddingLastThreeQuote(queryPO);
            } else if ("1".equals(confirmDealType)) {
                queryPO = new SupQuotePO();
                queryPO.setExecuteId(reqBO.getExecuteId());
                supQuotePOList = this.supQuoteMapper.selectBiddingItemLastThreeQuote(queryPO);
            }
        }
        if (supQuotePOList != null) {
            for (SupQuotePO supQuotePO : supQuotePOList) {
                SupQuoteBO supQuoteBO = new SupQuoteBO();
                BeanUtil.copyProperties((Object)supQuotePO, (Object)supQuoteBO);
                rows.add(supQuoteBO);
            }
        }
        rspBO.setSupQuoteList(rows);
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("\u62a5\u4ef7\u6c47\u603b\u67e5\u8be2\u6210\u529f");
        return rspBO;
    }

    @Override
    public QryLastLowestQuotationRspBO getSubItemLastQuoteList(QryLastLowestQuoteReqBO reqBO) {
        QryLastLowestQuotationRspBO rspBO = new QryLastLowestQuotationRspBO();
        ArrayList<SupQuoteItemBO> rows = new ArrayList<SupQuoteItemBO>();
        List<SupQuoteItemPO> quoteItemPOList = null;
        SupQuoteItemPO countQuery = new SupQuoteItemPO();
        countQuery.setExecuteId(reqBO.getExecuteId());
        Long count = this.supQuoteItemMapper.selectCount(countQuery);
        SupQuoteItemPO queryPO = new SupQuoteItemPO();
        queryPO.setExecuteId(reqBO.getExecuteId());
        queryPO.setExecuteItemIdList(reqBO.getExecuteItemIdList());
        queryPO.setLimitNum(count);
        if ("1".equals(reqBO.getExecuteType())) {
            quoteItemPOList = this.supQuoteItemMapper.selectItemLastQuote(queryPO);
        } else if ("2".equals(reqBO.getExecuteType())) {
            quoteItemPOList = this.supQuoteItemMapper.selectItemBiddingLastQuote(queryPO);
        }
        if (quoteItemPOList != null) {
            for (SupQuoteItemPO quoteItemPO : quoteItemPOList) {
                SupQuoteItemBO quoteItemBO = new SupQuoteItemBO();
                BeanUtil.copyProperties((Object)quoteItemPO, (Object)quoteItemBO);
                rows.add(quoteItemBO);
            }
        }
        rspBO.setSupQuoteItemList(rows);
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("\u5206\u9879\u6700\u540e\u4e00\u6b21\u62a5\u4ef7\u67e5\u8be2\u6210\u529f");
        return rspBO;
    }

    @Override
    public QryLastLowestQuotationRspBO getWholeLowestQuote(QryLastLowestQuoteReqBO reqBO) {
        SupQuotePO queryPO;
        QryLastLowestQuotationRspBO rspBO = new QryLastLowestQuotationRspBO();
        SupQuotePO supQuotePO = null;
        if ("1".equals(reqBO.getExecuteType())) {
            queryPO = new SupQuotePO();
            queryPO.setExecuteId(reqBO.getExecuteId());
            queryPO.setFilterQuoteIdList(reqBO.getFilterQuoteIdList());
            supQuotePO = this.supQuoteMapper.selectLowestQuote(queryPO);
        } else if ("2".equals(reqBO.getExecuteType())) {
            queryPO = new SupQuotePO();
            queryPO.setExecuteId(reqBO.getExecuteId());
            queryPO.setFilterQuoteIdList(reqBO.getFilterQuoteIdList());
            supQuotePO = this.supQuoteMapper.selectBiddingLowestQuote(queryPO);
        }
        SupQuoteBO supQuoteBO = new SupQuoteBO();
        BeanUtil.copyProperties(supQuotePO, (Object)supQuoteBO);
        rspBO.setSupQuoteBO(supQuoteBO);
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("\u6700\u4f4e\u62a5\u4ef7\u67e5\u8be2\u6210\u529f");
        return rspBO;
    }

    @Override
    public QryLastLowestQuotationRspBO getSubItemLowestQuoteList(QryLastLowestQuoteReqBO reqBO) {
        QryLastLowestQuotationRspBO rspBO = new QryLastLowestQuotationRspBO();
        ArrayList<SupQuoteItemBO> rows = new ArrayList<SupQuoteItemBO>();
        List<SupQuoteItemPO> quoteItemPOList = null;
        SupQuoteItemPO countQuery = new SupQuoteItemPO();
        countQuery.setExecuteId(reqBO.getExecuteId());
        Long count = this.supQuoteItemMapper.selectCount(countQuery);
        SupQuoteItemPO queryPO = new SupQuoteItemPO();
        queryPO.setExecuteId(reqBO.getExecuteId());
        queryPO.setLimitNum(count);
        queryPO.setExecuteItemIdList(reqBO.getExecuteItemIdList());
        queryPO.setFilterQuoteItemIdList(reqBO.getFilterQuoteItemIdList());
        log.info("\u62a5\u4ef7\u5217\u8868\u67e5\u8be2\u4fe1\u606f\uff1a" + JSONObject.toJSONString((Object)queryPO));
        if ("1".equals(reqBO.getExecuteType())) {
            quoteItemPOList = this.supQuoteItemMapper.selectItemLowestQuote(queryPO);
        } else if ("2".equals(reqBO.getExecuteType())) {
            quoteItemPOList = this.supQuoteItemMapper.selectItemBiddingLowestQuote(queryPO);
        }
        if (quoteItemPOList != null) {
            for (SupQuoteItemPO quoteItemPO : quoteItemPOList) {
                SupQuoteItemBO quoteItemBO = new SupQuoteItemBO();
                BeanUtil.copyProperties((Object)quoteItemPO, (Object)quoteItemBO);
                rows.add(quoteItemBO);
            }
        }
        rspBO.setSupQuoteItemList(rows);
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("\u5206\u9879\u6700\u4f4e\u62a5\u4ef7\u67e5\u8be2\u6210\u529f");
        return rspBO;
    }

    @Override
    public PurchasePlanDealItemListQueryRspBO queryPlanDealItemList(PurchasePlanDealItemListQueryReqBO reqBO) {
        PurchasePlanDealItemListQueryRspBO rspBO = new PurchasePlanDealItemListQueryRspBO();
        if (reqBO == null) {
            throw new BusinessException("8888", "\u67e5\u8be2\u4e8c\u6b21\u7ade\u4ef7\u6210\u4ea4\u4ef7\u683c\u5165\u53c2\u4e0d\u53ef\u4ee5\u4e3a\u7a7a");
        }
        if (StringUtils.isEmpty((CharSequence)reqBO.getWlbh())) {
            throw new BusinessException("8888", "\u67e5\u8be2\u4e8c\u6b21\u7ade\u4ef7\u6210\u4ea4\u4ef7\u683c\u5165\u53c2\u7269\u6599\u7f16\u7801[wlbh]\u4e0d\u53ef\u4ee5\u4e3a\u7a7a");
        }
        PlanDealItemPO record = new PlanDealItemPO();
        record.setWlbh(reqBO.getWlbh());
        record.setOrderBy("create_time");
        List<PlanDealItemPO> planDealItemPOList = this.planDealItemMapper.getList(record);
        if (CollUtil.isEmpty(planDealItemPOList)) {
            log.info("\u4e8c\u6b21\u7ade\u4ef7\u6210\u4ea4\u4ef7\u683c\u67e5\u8be2\u7ed3\u679c\u4e3a\u7a7a");
            rspBO.setRespCode("0000");
            rspBO.setRespDesc("\u4e8c\u6b21\u7ade\u4ef7\u6210\u4ea4\u4ef7\u683c\u67e5\u8be2\u7ed3\u679c\u4e3a\u7a7a");
            return rspBO;
        }
        ArrayList<BigDecimal> dealPriceList = new ArrayList<BigDecimal>();
        ArrayList<String> dealTimeList = new ArrayList<String>();
        BigDecimal highestBidPrice = planDealItemPOList.get(0).getDealPrice();
        BigDecimal lowestBidPrice = planDealItemPOList.get(0).getDealPrice();
        for (PlanDealItemPO planDealItemPO : planDealItemPOList) {
            SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd");
            String dealTime = format.format(planDealItemPO.getCreateTime());
            dealPriceList.add(planDealItemPO.getDealPrice());
            dealTimeList.add(dealTime);
            if (highestBidPrice.compareTo(planDealItemPO.getDealPrice()) <= 0) {
                PurchasePlanDealInfoBO highestBidPriceBO = new PurchasePlanDealInfoBO();
                highestBidPriceBO.setTime(dealTime);
                highestBidPriceBO.setValue(planDealItemPO.getDealPrice());
                rspBO.setHighestBidPrice(highestBidPriceBO);
            }
            if (lowestBidPrice.compareTo(planDealItemPO.getDealPrice()) < 0) continue;
            PurchasePlanDealInfoBO lowestBidPriceBO = new PurchasePlanDealInfoBO();
            lowestBidPriceBO.setTime(dealTime);
            lowestBidPriceBO.setValue(planDealItemPO.getDealPrice());
            rspBO.setLowestBidPrice(lowestBidPriceBO);
        }
        rspBO.setWlbh(reqBO.getWlbh());
        rspBO.setWxfl(reqBO.getWxfl());
        rspBO.setDealPriceList(dealPriceList);
        rspBO.setDealTimeList(dealTimeList);
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("\u4e8c\u6b21\u7ade\u4ef7\u6210\u4ea4\u4ef7\u683c\u67e5\u8be2\u6210\u529f");
        return rspBO;
    }
}

