/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.enquiry.busi.impl;

import cn.hutool.core.util.StrUtil;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.ohaotian.plugin.db.Sequence;
import com.tydic.enquiry.api.bo.EnquiryExecuteAutoAddReqBO;
import com.tydic.enquiry.api.bo.EnquiryExecuteAutoAddRspBO;
import com.tydic.enquiry.api.bo.EnquiryExecuteAutoItemBO;
import com.tydic.enquiry.api.bo.EnquiryExecuteAutoItemCatalogBO;
import com.tydic.enquiry.busi.api.EnquiryExecuteAutoAddBusiService;
import com.tydic.enquiry.constant.EnquiryConstant;
import com.tydic.enquiry.dao.ExecuteAutoItemMapper;
import com.tydic.enquiry.dao.ExecuteAutoMapper;
import com.tydic.enquiry.dao.po.ExecuteAutoItemPO;
import com.tydic.enquiry.dao.po.ExecuteAutoPO;
import com.tydic.enquiry.exceptions.BusinessException;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class EnquiryExecuteAutoAddBusiServiceImpl
implements EnquiryExecuteAutoAddBusiService {
    @Autowired
    private ExecuteAutoMapper executeAutoMapper;
    @Autowired
    private ExecuteAutoItemMapper executeAutoItemMapper;

    @Override
    public EnquiryExecuteAutoAddRspBO addExecuteAuto(EnquiryExecuteAutoAddReqBO executeAutoAddReqBO) {
        EnquiryExecuteAutoAddRspBO rspBO = new EnquiryExecuteAutoAddRspBO();
        List<ExecuteAutoPO> executeAutoPOS = this.executeAutoMapper.selectByPurchaseUnit(null);
        String unitListStr = JSONObject.toJSONString((Object)executeAutoAddReqBO.getPurchaseUnitList());
        Map<String, String> allMapIn = this.getUnitMap(unitListStr);
        Set<String> unitIdSet = allMapIn.keySet();
        for (ExecuteAutoPO executeAutoPO : executeAutoPOS) {
            String unitStr = executeAutoPO.getPurchaseUnit();
            Map<String, String> allMapRecord = this.getUnitMap(unitStr);
            for (String unitId : unitIdSet) {
                if (!allMapRecord.containsKey(unitId)) continue;
                rspBO.setRespCode("8888");
                rspBO.setRespDesc("\u91c7\u8d2d\u5355\u4f4d\u3010" + allMapRecord.get(unitId) + "\u3011\u5df2\u5b58\u5728\uff01");
                return rspBO;
            }
        }
        ExecuteAutoPO executeAutoPO = new ExecuteAutoPO();
        long autoId = Sequence.getInstance().nextId();
        executeAutoPO.setAutoId(autoId);
        executeAutoPO.setCreateTime(new Date());
        executeAutoPO.setCreateUserId(executeAutoAddReqBO.getUserId());
        executeAutoPO.setCreateUserName(executeAutoAddReqBO.getName());
        executeAutoPO.setDeleteFlag(EnquiryConstant.deleteFlag.NORMAL);
        executeAutoPO.setPurchaseUnit(JSONObject.toJSONString((Object)executeAutoAddReqBO.getPurchaseUnitList()));
        this.executeAutoMapper.insertSelective(executeAutoPO);
        this.createAutoItem(executeAutoAddReqBO.getExecuteAutoItemBOList(), autoId, executeAutoAddReqBO, rspBO);
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("\u6210\u529f");
        return rspBO;
    }

    private Map<String, String> getUnitMap(String unitListStr) {
        HashMap<String, String> unitMap = new HashMap<String, String>();
        if (StrUtil.isNotBlank((CharSequence)unitListStr)) {
            JSONArray arr = JSONArray.parseArray((String)unitListStr);
            int len = arr.size();
            for (int i = 0; i < len; ++i) {
                JSONObject json = arr.getJSONObject(i);
                unitMap.put(json.getString("purchaseId"), json.getString("purchaseName"));
            }
        }
        return unitMap;
    }

    private void createAutoItem(List<EnquiryExecuteAutoItemBO> executeAutoItemBOList, Long autoId, EnquiryExecuteAutoAddReqBO reqBO, EnquiryExecuteAutoAddRspBO rspBO) {
        ArrayList<ExecuteAutoItemPO> executeAutoItemBOS = new ArrayList<ExecuteAutoItemPO>();
        ExecuteAutoItemPO po = new ExecuteAutoItemPO();
        po.setAutoId(autoId);
        ArrayList<String> catalogIdList = new ArrayList<String>();
        for (EnquiryExecuteAutoItemBO itemBO : executeAutoItemBOList) {
            for (EnquiryExecuteAutoItemCatalogBO catalogBO : itemBO.getCatalogBOList()) {
                catalogIdList.add(catalogBO.getCatalogId());
            }
        }
        po.setCatalogIdList(catalogIdList);
        List<ExecuteAutoItemPO> executeAutoItemPOS = this.executeAutoItemMapper.selectByCondition(po);
        if (!CollectionUtils.isEmpty(executeAutoItemPOS)) {
            throw new BusinessException("8888", "\u5c0f\u7c7b\u5df2\u5b58\u5728\uff01");
        }
        for (EnquiryExecuteAutoItemBO itemBO : executeAutoItemBOList) {
            for (EnquiryExecuteAutoItemCatalogBO catalogBO : itemBO.getCatalogBOList()) {
                ExecuteAutoItemPO autoItemPO = new ExecuteAutoItemPO();
                autoItemPO.setAutoId(autoId);
                autoItemPO.setExecuteUserId(itemBO.getExecuteUserId());
                autoItemPO.setExecuteUserName(itemBO.getExecuteUserName());
                autoItemPO.setItemAutoId(Sequence.getInstance().nextId());
                autoItemPO.setCatalogCode(catalogBO.getCatalogCode());
                autoItemPO.setCatalogId(catalogBO.getCatalogId());
                autoItemPO.setCatalogName(catalogBO.getCatalogName());
                executeAutoItemBOS.add(autoItemPO);
            }
        }
        this.executeAutoItemMapper.insertBatch(executeAutoItemBOS);
    }
}

