/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.enquiry.busi.impl;

import com.tydic.enquiry.api.bo.EnquiryExecuteBillQryListReqBO;
import com.tydic.enquiry.api.bo.EnquiryExecuteBillQryListRspBO;
import com.tydic.enquiry.api.bo.PurchaseExecuteBillBo;
import com.tydic.enquiry.busi.api.EnquiryExecuteBillQryListBusiService;
import com.tydic.enquiry.constant.EnquiryConstant;
import com.tydic.enquiry.constant.EnquiryEnumConstant;
import com.tydic.enquiry.dao.ExecuteBillMapper;
import com.tydic.enquiry.dao.ExecuteSupJoinMapper;
import com.tydic.enquiry.dao.SupQuoteMapper;
import com.tydic.enquiry.dao.po.ExecuteBillPO;
import com.tydic.enquiry.dao.po.ExecuteSupJoinPO;
import com.tydic.enquiry.dao.po.SupQuotePO;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class EnquiryExecuteBillQryListBusiServiceImpl
implements EnquiryExecuteBillQryListBusiService {
    @Autowired
    private ExecuteBillMapper executeBillMapper;
    @Autowired
    private ExecuteSupJoinMapper executeSupJoinMapper;
    @Autowired
    private SupQuoteMapper supQuoteMapper;

    @Override
    public EnquiryExecuteBillQryListRspBO qryListExecuteBill(EnquiryExecuteBillQryListReqBO reqBO) {
        EnquiryExecuteBillQryListRspBO rspBO = new EnquiryExecuteBillQryListRspBO();
        ExecuteSupJoinPO supJoinPO = new ExecuteSupJoinPO();
        supJoinPO.setSupplierId(reqBO.getSupId());
        supJoinPO.setDeleteFlag(EnquiryConstant.deleteFlag.NORMAL);
        List<ExecuteSupJoinPO> pos = this.executeSupJoinMapper.selectListByCondition(supJoinPO);
        ArrayList<Long> idList = new ArrayList<Long>();
        if (!CollectionUtils.isEmpty(pos)) {
            for (ExecuteSupJoinPO po : pos) {
                idList.add(po.getExecuteId());
            }
            List<ExecuteBillPO> billPOS = this.executeBillMapper.selectListByExecuteId(idList, "2003");
            List collect = billPOS.stream().map(item -> {
                PurchaseExecuteBillBo executeBillBO = new PurchaseExecuteBillBo();
                BeanUtils.copyProperties((Object)item, (Object)executeBillBO);
                executeBillBO.setExecuteStatusName(EnquiryEnumConstant.ExecuteStatusEnum.getDesc((String)item.getExecuteStatus()));
                executeBillBO.setExecuteTypeName(EnquiryEnumConstant.ExecuteTypeEnum.getDesc((String)item.getExecuteType()));
                this.getQuoteStatus(executeBillBO, reqBO.getSupId());
                return executeBillBO;
            }).collect(Collectors.toList());
            rspBO.setExecuteBillBOList(collect);
        }
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("\u6210\u529f");
        return rspBO;
    }

    private void getQuoteStatus(PurchaseExecuteBillBo executeBillBO, Long supId) {
        List<SupQuotePO> quotePOS = this.supQuoteMapper.selectCurrentQuotationBySupplierId(executeBillBO.getExecuteId(), supId);
        String status = "";
        if (!CollectionUtils.isEmpty(quotePOS)) {
            for (SupQuotePO po : quotePOS) {
                if (po.getQuoteStatus().equals(EnquiryConstant.QuoteStatus.YES)) {
                    status = String.valueOf(po.getQuoteStatus());
                    break;
                }
                status = String.valueOf(po.getQuoteStatus());
            }
            executeBillBO.setQuoteStatus(status);
            executeBillBO.setQuoteStatusName(EnquiryEnumConstant.QuoteStatusEnum.getDesc((String)executeBillBO.getQuoteStatus()));
        }
    }
}

